// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [FeaturestoreOnlineServingService.WriteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues].
type WriteFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntityType for the entities being
	// written. Value format:
	// `projects/{project}/locations/{location}/featurestores/
	// {featurestore}/entityTypes/{entityType}`. For example,
	// for a machine learning model predicting user clicks on a website, an
	// EntityType ID could be `user`.
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Required. The entities to be written. Up to 100,000 feature values can be
	// written across all `payloads`.
	Payloads []*WriteFeatureValuesPayload `protobuf:"bytes,2,rep,name=payloads,proto3" json:"payloads,omitempty"`
}

func (x *WriteFeatureValuesRequest) Reset() {
	*x = WriteFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFeatureValuesRequest) ProtoMessage() {}

func (x *WriteFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*WriteFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{0}
}

func (x *WriteFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *WriteFeatureValuesRequest) GetPayloads() []*WriteFeatureValuesPayload {
	if x != nil {
		return x.Payloads
	}
	return nil
}

// Contains Feature values to be written for a specific entity.
type WriteFeatureValuesPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the entity.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Required. Feature values to be written, mapping from Feature ID to value.
	// Up to 100,000 `feature_values` entries may be written across all payloads.
	// The feature generation time, aligned by days, must be no older than five
	// years (1825 days) and no later than one year (366 days) in the future.
	FeatureValues map[string]*FeatureValue `protobuf:"bytes,2,rep,name=feature_values,json=featureValues,proto3" json:"feature_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WriteFeatureValuesPayload) Reset() {
	*x = WriteFeatureValuesPayload{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteFeatureValuesPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFeatureValuesPayload) ProtoMessage() {}

func (x *WriteFeatureValuesPayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFeatureValuesPayload.ProtoReflect.Descriptor instead.
func (*WriteFeatureValuesPayload) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{1}
}

func (x *WriteFeatureValuesPayload) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *WriteFeatureValuesPayload) GetFeatureValues() map[string]*FeatureValue {
	if x != nil {
		return x.FeatureValues
	}
	return nil
}

// Response message for
// [FeaturestoreOnlineServingService.WriteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues].
type WriteFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteFeatureValuesResponse) Reset() {
	*x = WriteFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFeatureValuesResponse) ProtoMessage() {}

func (x *WriteFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*WriteFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{2}
}

// Request message for
// [FeaturestoreOnlineServingService.ReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.ReadFeatureValues].
type ReadFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntityType for the entity being read.
	// Value format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
	// For example, for a machine learning model predicting user clicks on a
	// website, an EntityType ID could be `user`.
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Required. ID for a specific entity. For example,
	// for a machine learning model predicting user clicks on a website, an entity
	// ID could be `user_123`.
	EntityId string `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Required. Selector choosing Features of the target EntityType.
	FeatureSelector *FeatureSelector `protobuf:"bytes,3,opt,name=feature_selector,json=featureSelector,proto3" json:"feature_selector,omitempty"`
}

func (x *ReadFeatureValuesRequest) Reset() {
	*x = ReadFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesRequest) ProtoMessage() {}

func (x *ReadFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{3}
}

func (x *ReadFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *ReadFeatureValuesRequest) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *ReadFeatureValuesRequest) GetFeatureSelector() *FeatureSelector {
	if x != nil {
		return x.FeatureSelector
	}
	return nil
}

// Response message for
// [FeaturestoreOnlineServingService.ReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.ReadFeatureValues].
type ReadFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response header.
	Header *ReadFeatureValuesResponse_Header `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Entity view with Feature values. This may be the entity in the
	// Featurestore if values for all Features were requested, or a projection
	// of the entity in the Featurestore if values for only some Features were
	// requested.
	EntityView *ReadFeatureValuesResponse_EntityView `protobuf:"bytes,2,opt,name=entity_view,json=entityView,proto3" json:"entity_view,omitempty"`
}

func (x *ReadFeatureValuesResponse) Reset() {
	*x = ReadFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesResponse) ProtoMessage() {}

func (x *ReadFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{4}
}

func (x *ReadFeatureValuesResponse) GetHeader() *ReadFeatureValuesResponse_Header {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ReadFeatureValuesResponse) GetEntityView() *ReadFeatureValuesResponse_EntityView {
	if x != nil {
		return x.EntityView
	}
	return nil
}

// Request message for
// [FeaturestoreOnlineServingService.StreamingReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.StreamingReadFeatureValues].
type StreamingReadFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entities' type.
	// Value format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
	// For example,
	// for a machine learning model predicting user clicks on a website, an
	// EntityType ID could be `user`.
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Required. IDs of entities to read Feature values of. The maximum number of
	// IDs is 100. For example, for a machine learning model predicting user
	// clicks on a website, an entity ID could be `user_123`.
	EntityIds []string `protobuf:"bytes,2,rep,name=entity_ids,json=entityIds,proto3" json:"entity_ids,omitempty"`
	// Required. Selector choosing Features of the target EntityType. Feature IDs
	// will be deduplicated.
	FeatureSelector *FeatureSelector `protobuf:"bytes,3,opt,name=feature_selector,json=featureSelector,proto3" json:"feature_selector,omitempty"`
}

func (x *StreamingReadFeatureValuesRequest) Reset() {
	*x = StreamingReadFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingReadFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingReadFeatureValuesRequest) ProtoMessage() {}

func (x *StreamingReadFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingReadFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*StreamingReadFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{5}
}

func (x *StreamingReadFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *StreamingReadFeatureValuesRequest) GetEntityIds() []string {
	if x != nil {
		return x.EntityIds
	}
	return nil
}

func (x *StreamingReadFeatureValuesRequest) GetFeatureSelector() *FeatureSelector {
	if x != nil {
		return x.FeatureSelector
	}
	return nil
}

// Value for a feature.
type FeatureValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value for the feature.
	//
	// Types that are assignable to Value:
	//
	//	*FeatureValue_BoolValue
	//	*FeatureValue_DoubleValue
	//	*FeatureValue_Int64Value
	//	*FeatureValue_StringValue
	//	*FeatureValue_BoolArrayValue
	//	*FeatureValue_DoubleArrayValue
	//	*FeatureValue_Int64ArrayValue
	//	*FeatureValue_StringArrayValue
	//	*FeatureValue_BytesValue
	//	*FeatureValue_StructValue
	Value isFeatureValue_Value `protobuf_oneof:"value"`
	// Metadata of feature value.
	Metadata *FeatureValue_Metadata `protobuf:"bytes,14,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *FeatureValue) Reset() {
	*x = FeatureValue{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureValue) ProtoMessage() {}

func (x *FeatureValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureValue.ProtoReflect.Descriptor instead.
func (*FeatureValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{6}
}

func (m *FeatureValue) GetValue() isFeatureValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *FeatureValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*FeatureValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *FeatureValue) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*FeatureValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *FeatureValue) GetInt64Value() int64 {
	if x, ok := x.GetValue().(*FeatureValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *FeatureValue) GetStringValue() string {
	if x, ok := x.GetValue().(*FeatureValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *FeatureValue) GetBoolArrayValue() *BoolArray {
	if x, ok := x.GetValue().(*FeatureValue_BoolArrayValue); ok {
		return x.BoolArrayValue
	}
	return nil
}

func (x *FeatureValue) GetDoubleArrayValue() *DoubleArray {
	if x, ok := x.GetValue().(*FeatureValue_DoubleArrayValue); ok {
		return x.DoubleArrayValue
	}
	return nil
}

func (x *FeatureValue) GetInt64ArrayValue() *Int64Array {
	if x, ok := x.GetValue().(*FeatureValue_Int64ArrayValue); ok {
		return x.Int64ArrayValue
	}
	return nil
}

func (x *FeatureValue) GetStringArrayValue() *StringArray {
	if x, ok := x.GetValue().(*FeatureValue_StringArrayValue); ok {
		return x.StringArrayValue
	}
	return nil
}

func (x *FeatureValue) GetBytesValue() []byte {
	if x, ok := x.GetValue().(*FeatureValue_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (x *FeatureValue) GetStructValue() *StructValue {
	if x, ok := x.GetValue().(*FeatureValue_StructValue); ok {
		return x.StructValue
	}
	return nil
}

func (x *FeatureValue) GetMetadata() *FeatureValue_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type isFeatureValue_Value interface {
	isFeatureValue_Value()
}

type FeatureValue_BoolValue struct {
	// Bool type feature value.
	BoolValue bool `protobuf:"varint,1,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type FeatureValue_DoubleValue struct {
	// Double type feature value.
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type FeatureValue_Int64Value struct {
	// Int64 feature value.
	Int64Value int64 `protobuf:"varint,5,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type FeatureValue_StringValue struct {
	// String feature value.
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type FeatureValue_BoolArrayValue struct {
	// A list of bool type feature value.
	BoolArrayValue *BoolArray `protobuf:"bytes,7,opt,name=bool_array_value,json=boolArrayValue,proto3,oneof"`
}

type FeatureValue_DoubleArrayValue struct {
	// A list of double type feature value.
	DoubleArrayValue *DoubleArray `protobuf:"bytes,8,opt,name=double_array_value,json=doubleArrayValue,proto3,oneof"`
}

type FeatureValue_Int64ArrayValue struct {
	// A list of int64 type feature value.
	Int64ArrayValue *Int64Array `protobuf:"bytes,11,opt,name=int64_array_value,json=int64ArrayValue,proto3,oneof"`
}

type FeatureValue_StringArrayValue struct {
	// A list of string type feature value.
	StringArrayValue *StringArray `protobuf:"bytes,12,opt,name=string_array_value,json=stringArrayValue,proto3,oneof"`
}

type FeatureValue_BytesValue struct {
	// Bytes feature value.
	BytesValue []byte `protobuf:"bytes,13,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

type FeatureValue_StructValue struct {
	// A struct type feature value.
	StructValue *StructValue `protobuf:"bytes,15,opt,name=struct_value,json=structValue,proto3,oneof"`
}

func (*FeatureValue_BoolValue) isFeatureValue_Value() {}

func (*FeatureValue_DoubleValue) isFeatureValue_Value() {}

func (*FeatureValue_Int64Value) isFeatureValue_Value() {}

func (*FeatureValue_StringValue) isFeatureValue_Value() {}

func (*FeatureValue_BoolArrayValue) isFeatureValue_Value() {}

func (*FeatureValue_DoubleArrayValue) isFeatureValue_Value() {}

func (*FeatureValue_Int64ArrayValue) isFeatureValue_Value() {}

func (*FeatureValue_StringArrayValue) isFeatureValue_Value() {}

func (*FeatureValue_BytesValue) isFeatureValue_Value() {}

func (*FeatureValue_StructValue) isFeatureValue_Value() {}

// Struct (or object) type feature value.
type StructValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of field values.
	Values []*StructFieldValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *StructValue) Reset() {
	*x = StructValue{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StructValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructValue) ProtoMessage() {}

func (x *StructValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructValue.ProtoReflect.Descriptor instead.
func (*StructValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{7}
}

func (x *StructValue) GetValues() []*StructFieldValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// One field of a Struct (or object) type feature value.
type StructFieldValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the field in the struct feature.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value for this field.
	Value *FeatureValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StructFieldValue) Reset() {
	*x = StructFieldValue{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StructFieldValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructFieldValue) ProtoMessage() {}

func (x *StructFieldValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructFieldValue.ProtoReflect.Descriptor instead.
func (*StructFieldValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{8}
}

func (x *StructFieldValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StructFieldValue) GetValue() *FeatureValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// Container for list of values.
type FeatureValueList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of feature values. All of them should be the same data type.
	Values []*FeatureValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *FeatureValueList) Reset() {
	*x = FeatureValueList{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureValueList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureValueList) ProtoMessage() {}

func (x *FeatureValueList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureValueList.ProtoReflect.Descriptor instead.
func (*FeatureValueList) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{9}
}

func (x *FeatureValueList) GetValues() []*FeatureValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// Metadata for requested Features.
type ReadFeatureValuesResponse_FeatureDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ReadFeatureValuesResponse_FeatureDescriptor) Reset() {
	*x = ReadFeatureValuesResponse_FeatureDescriptor{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesResponse_FeatureDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesResponse_FeatureDescriptor) ProtoMessage() {}

func (x *ReadFeatureValuesResponse_FeatureDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesResponse_FeatureDescriptor.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesResponse_FeatureDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ReadFeatureValuesResponse_FeatureDescriptor) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Response header with metadata for the requested
// [ReadFeatureValuesRequest.entity_type][google.cloud.aiplatform.v1.ReadFeatureValuesRequest.entity_type]
// and Features.
type ReadFeatureValuesResponse_Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the EntityType from the
	// [ReadFeatureValuesRequest][google.cloud.aiplatform.v1.ReadFeatureValuesRequest].
	// Value format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// List of Feature metadata corresponding to each piece of
	// [ReadFeatureValuesResponse.EntityView.data][google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.data].
	FeatureDescriptors []*ReadFeatureValuesResponse_FeatureDescriptor `protobuf:"bytes,2,rep,name=feature_descriptors,json=featureDescriptors,proto3" json:"feature_descriptors,omitempty"`
}

func (x *ReadFeatureValuesResponse_Header) Reset() {
	*x = ReadFeatureValuesResponse_Header{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesResponse_Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesResponse_Header) ProtoMessage() {}

func (x *ReadFeatureValuesResponse_Header) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesResponse_Header.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesResponse_Header) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ReadFeatureValuesResponse_Header) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *ReadFeatureValuesResponse_Header) GetFeatureDescriptors() []*ReadFeatureValuesResponse_FeatureDescriptor {
	if x != nil {
		return x.FeatureDescriptors
	}
	return nil
}

// Entity view with Feature values.
type ReadFeatureValuesResponse_EntityView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the requested entity.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Each piece of data holds the k
	// requested values for one requested Feature. If no values
	// for the requested Feature exist, the corresponding cell will be empty.
	// This has the same size and is in the same order as the features from the
	// header
	// [ReadFeatureValuesResponse.header][google.cloud.aiplatform.v1.ReadFeatureValuesResponse.header].
	Data []*ReadFeatureValuesResponse_EntityView_Data `protobuf:"bytes,2,rep,name=data,proto3" json:"data,omitempty"`
}

func (x *ReadFeatureValuesResponse_EntityView) Reset() {
	*x = ReadFeatureValuesResponse_EntityView{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesResponse_EntityView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesResponse_EntityView) ProtoMessage() {}

func (x *ReadFeatureValuesResponse_EntityView) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesResponse_EntityView.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesResponse_EntityView) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{4, 2}
}

func (x *ReadFeatureValuesResponse_EntityView) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *ReadFeatureValuesResponse_EntityView) GetData() []*ReadFeatureValuesResponse_EntityView_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

// Container to hold value(s), successive in time, for one Feature from the
// request.
type ReadFeatureValuesResponse_EntityView_Data struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*ReadFeatureValuesResponse_EntityView_Data_Value
	//	*ReadFeatureValuesResponse_EntityView_Data_Values
	Data isReadFeatureValuesResponse_EntityView_Data_Data `protobuf_oneof:"data"`
}

func (x *ReadFeatureValuesResponse_EntityView_Data) Reset() {
	*x = ReadFeatureValuesResponse_EntityView_Data{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadFeatureValuesResponse_EntityView_Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFeatureValuesResponse_EntityView_Data) ProtoMessage() {}

func (x *ReadFeatureValuesResponse_EntityView_Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFeatureValuesResponse_EntityView_Data.ProtoReflect.Descriptor instead.
func (*ReadFeatureValuesResponse_EntityView_Data) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{4, 2, 0}
}

func (m *ReadFeatureValuesResponse_EntityView_Data) GetData() isReadFeatureValuesResponse_EntityView_Data_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *ReadFeatureValuesResponse_EntityView_Data) GetValue() *FeatureValue {
	if x, ok := x.GetData().(*ReadFeatureValuesResponse_EntityView_Data_Value); ok {
		return x.Value
	}
	return nil
}

func (x *ReadFeatureValuesResponse_EntityView_Data) GetValues() *FeatureValueList {
	if x, ok := x.GetData().(*ReadFeatureValuesResponse_EntityView_Data_Values); ok {
		return x.Values
	}
	return nil
}

type isReadFeatureValuesResponse_EntityView_Data_Data interface {
	isReadFeatureValuesResponse_EntityView_Data_Data()
}

type ReadFeatureValuesResponse_EntityView_Data_Value struct {
	// Feature value if a single value is requested.
	Value *FeatureValue `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type ReadFeatureValuesResponse_EntityView_Data_Values struct {
	// Feature values list if values, successive in time, are requested.
	// If the requested number of values is greater than the number of
	// existing Feature values, nonexistent values are omitted instead of
	// being returned as empty.
	Values *FeatureValueList `protobuf:"bytes,2,opt,name=values,proto3,oneof"`
}

func (*ReadFeatureValuesResponse_EntityView_Data_Value) isReadFeatureValuesResponse_EntityView_Data_Data() {
}

func (*ReadFeatureValuesResponse_EntityView_Data_Values) isReadFeatureValuesResponse_EntityView_Data_Data() {
}

// Metadata of feature value.
type FeatureValue_Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature generation timestamp. Typically, it is provided by user at
	// feature ingestion time. If not, feature store
	// will use the system timestamp when the data is ingested into feature
	// store. For streaming ingestion, the time, aligned by days, must be no
	// older than five years (1825 days) and no later than one year (366 days)
	// in the future.
	GenerateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=generate_time,json=generateTime,proto3" json:"generate_time,omitempty"`
}

func (x *FeatureValue_Metadata) Reset() {
	*x = FeatureValue_Metadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureValue_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureValue_Metadata) ProtoMessage() {}

func (x *FeatureValue_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureValue_Metadata.ProtoReflect.Descriptor instead.
func (*FeatureValue_Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *FeatureValue_Metadata) GetGenerateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GenerateTime
	}
	return nil
}

var File_google_cloud_aiplatform_v1_featurestore_online_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x01, 0x0a, 0x19, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x08, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x22, 0x9f,
	0x02, 0x0a, 0x19, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x20, 0x0a, 0x09,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x74,
	0x0a, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x1a, 0x6a, 0x0a, 0x12, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x1c, 0x0a, 0x1a, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe8,
	0x01, 0x0a, 0x18, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x10,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xec, 0x05, 0x0a, 0x19, 0x52, 0x65,
	0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x61, 0x0a,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x56, 0x69, 0x65, 0x77,
	0x1a, 0x23, 0x0a, 0x11, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x1a, 0xce, 0x01, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x78, 0x0a, 0x13,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x52, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x1a, 0x9f, 0x02, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x64, 0x12, 0x59, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x56, 0x69,
	0x65, 0x77, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x98, 0x01,
	0x0a, 0x04, 0x44, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48,
	0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xf3, 0x01, 0x0a, 0x21, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x73, 0x12, 0x5b, 0x0a, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x8d,
	0x06, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x51, 0x0a,
	0x10, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00,
	0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x57, 0x0a, 0x12, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x10, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0f,
	0x69, 0x6e, 0x74, 0x36, 0x34, 0x41, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x57, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4b, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3f, 0x0a, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x53,
	0x0a, 0x0b, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x44, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x22, 0x66, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x54, 0x0a, 0x10, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x32, 0xfd, 0x06, 0x0a, 0x20, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf3, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x61, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x71, 0xda, 0x41, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a,
	0x01, 0x2a, 0x22, 0x58, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x90, 0x02, 0x0a,
	0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x7a, 0xda, 0x41, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x3a, 0x01, 0x2a, 0x22, 0x61, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x30, 0x01, 0x12,
	0x80, 0x02, 0x0a, 0x12, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7b, 0xda, 0x41, 0x14, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xdc, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x42, 0x1e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescData = file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_aiplatform_v1_featurestore_online_service_proto_goTypes = []any{
	(*WriteFeatureValuesRequest)(nil),                   // 0: google.cloud.aiplatform.v1.WriteFeatureValuesRequest
	(*WriteFeatureValuesPayload)(nil),                   // 1: google.cloud.aiplatform.v1.WriteFeatureValuesPayload
	(*WriteFeatureValuesResponse)(nil),                  // 2: google.cloud.aiplatform.v1.WriteFeatureValuesResponse
	(*ReadFeatureValuesRequest)(nil),                    // 3: google.cloud.aiplatform.v1.ReadFeatureValuesRequest
	(*ReadFeatureValuesResponse)(nil),                   // 4: google.cloud.aiplatform.v1.ReadFeatureValuesResponse
	(*StreamingReadFeatureValuesRequest)(nil),           // 5: google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest
	(*FeatureValue)(nil),                                // 6: google.cloud.aiplatform.v1.FeatureValue
	(*StructValue)(nil),                                 // 7: google.cloud.aiplatform.v1.StructValue
	(*StructFieldValue)(nil),                            // 8: google.cloud.aiplatform.v1.StructFieldValue
	(*FeatureValueList)(nil),                            // 9: google.cloud.aiplatform.v1.FeatureValueList
	nil,                                                 // 10: google.cloud.aiplatform.v1.WriteFeatureValuesPayload.FeatureValuesEntry
	(*ReadFeatureValuesResponse_FeatureDescriptor)(nil), // 11: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.FeatureDescriptor
	(*ReadFeatureValuesResponse_Header)(nil),            // 12: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.Header
	(*ReadFeatureValuesResponse_EntityView)(nil),        // 13: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView
	(*ReadFeatureValuesResponse_EntityView_Data)(nil),   // 14: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.Data
	(*FeatureValue_Metadata)(nil),                       // 15: google.cloud.aiplatform.v1.FeatureValue.Metadata
	(*FeatureSelector)(nil),                             // 16: google.cloud.aiplatform.v1.FeatureSelector
	(*BoolArray)(nil),                                   // 17: google.cloud.aiplatform.v1.BoolArray
	(*DoubleArray)(nil),                                 // 18: google.cloud.aiplatform.v1.DoubleArray
	(*Int64Array)(nil),                                  // 19: google.cloud.aiplatform.v1.Int64Array
	(*StringArray)(nil),                                 // 20: google.cloud.aiplatform.v1.StringArray
	(*timestamppb.Timestamp)(nil),                       // 21: google.protobuf.Timestamp
}
var file_google_cloud_aiplatform_v1_featurestore_online_service_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1.WriteFeatureValuesRequest.payloads:type_name -> google.cloud.aiplatform.v1.WriteFeatureValuesPayload
	10, // 1: google.cloud.aiplatform.v1.WriteFeatureValuesPayload.feature_values:type_name -> google.cloud.aiplatform.v1.WriteFeatureValuesPayload.FeatureValuesEntry
	16, // 2: google.cloud.aiplatform.v1.ReadFeatureValuesRequest.feature_selector:type_name -> google.cloud.aiplatform.v1.FeatureSelector
	12, // 3: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.header:type_name -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse.Header
	13, // 4: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.entity_view:type_name -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView
	16, // 5: google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest.feature_selector:type_name -> google.cloud.aiplatform.v1.FeatureSelector
	17, // 6: google.cloud.aiplatform.v1.FeatureValue.bool_array_value:type_name -> google.cloud.aiplatform.v1.BoolArray
	18, // 7: google.cloud.aiplatform.v1.FeatureValue.double_array_value:type_name -> google.cloud.aiplatform.v1.DoubleArray
	19, // 8: google.cloud.aiplatform.v1.FeatureValue.int64_array_value:type_name -> google.cloud.aiplatform.v1.Int64Array
	20, // 9: google.cloud.aiplatform.v1.FeatureValue.string_array_value:type_name -> google.cloud.aiplatform.v1.StringArray
	7,  // 10: google.cloud.aiplatform.v1.FeatureValue.struct_value:type_name -> google.cloud.aiplatform.v1.StructValue
	15, // 11: google.cloud.aiplatform.v1.FeatureValue.metadata:type_name -> google.cloud.aiplatform.v1.FeatureValue.Metadata
	8,  // 12: google.cloud.aiplatform.v1.StructValue.values:type_name -> google.cloud.aiplatform.v1.StructFieldValue
	6,  // 13: google.cloud.aiplatform.v1.StructFieldValue.value:type_name -> google.cloud.aiplatform.v1.FeatureValue
	6,  // 14: google.cloud.aiplatform.v1.FeatureValueList.values:type_name -> google.cloud.aiplatform.v1.FeatureValue
	6,  // 15: google.cloud.aiplatform.v1.WriteFeatureValuesPayload.FeatureValuesEntry.value:type_name -> google.cloud.aiplatform.v1.FeatureValue
	11, // 16: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.Header.feature_descriptors:type_name -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse.FeatureDescriptor
	14, // 17: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.data:type_name -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.Data
	6,  // 18: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.Data.value:type_name -> google.cloud.aiplatform.v1.FeatureValue
	9,  // 19: google.cloud.aiplatform.v1.ReadFeatureValuesResponse.EntityView.Data.values:type_name -> google.cloud.aiplatform.v1.FeatureValueList
	21, // 20: google.cloud.aiplatform.v1.FeatureValue.Metadata.generate_time:type_name -> google.protobuf.Timestamp
	3,  // 21: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.ReadFeatureValues:input_type -> google.cloud.aiplatform.v1.ReadFeatureValuesRequest
	5,  // 22: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.StreamingReadFeatureValues:input_type -> google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest
	0,  // 23: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues:input_type -> google.cloud.aiplatform.v1.WriteFeatureValuesRequest
	4,  // 24: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.ReadFeatureValues:output_type -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse
	4,  // 25: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.StreamingReadFeatureValues:output_type -> google.cloud.aiplatform.v1.ReadFeatureValuesResponse
	2,  // 26: google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues:output_type -> google.cloud.aiplatform.v1.WriteFeatureValuesResponse
	24, // [24:27] is the sub-list for method output_type
	21, // [21:24] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_featurestore_online_service_proto_init() }
func file_google_cloud_aiplatform_v1_featurestore_online_service_proto_init() {
	if File_google_cloud_aiplatform_v1_featurestore_online_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_feature_selector_proto_init()
	file_google_cloud_aiplatform_v1_types_proto_init()
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[6].OneofWrappers = []any{
		(*FeatureValue_BoolValue)(nil),
		(*FeatureValue_DoubleValue)(nil),
		(*FeatureValue_Int64Value)(nil),
		(*FeatureValue_StringValue)(nil),
		(*FeatureValue_BoolArrayValue)(nil),
		(*FeatureValue_DoubleArrayValue)(nil),
		(*FeatureValue_Int64ArrayValue)(nil),
		(*FeatureValue_StringArrayValue)(nil),
		(*FeatureValue_BytesValue)(nil),
		(*FeatureValue_StructValue)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes[14].OneofWrappers = []any{
		(*ReadFeatureValuesResponse_EntityView_Data_Value)(nil),
		(*ReadFeatureValuesResponse_EntityView_Data_Values)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_featurestore_online_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_featurestore_online_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_featurestore_online_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_featurestore_online_service_proto = out.File
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_depIdxs = nil
}
