// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/feature_online_store_admin_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [FeatureOnlineStoreAdminService.CreateFeatureOnlineStore][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureOnlineStore].
type CreateFeatureOnlineStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create FeatureOnlineStores.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The FeatureOnlineStore to create.
	FeatureOnlineStore *FeatureOnlineStore `protobuf:"bytes,2,opt,name=feature_online_store,json=featureOnlineStore,proto3" json:"feature_online_store,omitempty"`
	// Required. The ID to use for this FeatureOnlineStore, which will become the
	// final component of the FeatureOnlineStore's resource name.
	//
	// This value may be up to 60 characters, and valid characters are
	// `[a-z0-9_]`. The first character cannot be a number.
	//
	// The value must be unique within the project and location.
	FeatureOnlineStoreId string `protobuf:"bytes,3,opt,name=feature_online_store_id,json=featureOnlineStoreId,proto3" json:"feature_online_store_id,omitempty"`
}

func (x *CreateFeatureOnlineStoreRequest) Reset() {
	*x = CreateFeatureOnlineStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureOnlineStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureOnlineStoreRequest) ProtoMessage() {}

func (x *CreateFeatureOnlineStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureOnlineStoreRequest.ProtoReflect.Descriptor instead.
func (*CreateFeatureOnlineStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateFeatureOnlineStoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeatureOnlineStoreRequest) GetFeatureOnlineStore() *FeatureOnlineStore {
	if x != nil {
		return x.FeatureOnlineStore
	}
	return nil
}

func (x *CreateFeatureOnlineStoreRequest) GetFeatureOnlineStoreId() string {
	if x != nil {
		return x.FeatureOnlineStoreId
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.GetFeatureOnlineStore][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureOnlineStore].
type GetFeatureOnlineStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the FeatureOnlineStore resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeatureOnlineStoreRequest) Reset() {
	*x = GetFeatureOnlineStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeatureOnlineStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeatureOnlineStoreRequest) ProtoMessage() {}

func (x *GetFeatureOnlineStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeatureOnlineStoreRequest.ProtoReflect.Descriptor instead.
func (*GetFeatureOnlineStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetFeatureOnlineStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.ListFeatureOnlineStores][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores].
type ListFeatureOnlineStoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list FeatureOnlineStores.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the FeatureOnlineStores that match the filter expression. The
	// following fields are supported:
	//
	// * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	// Values must be
	//
	//	in RFC 3339 format.
	//
	// * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	// Values must be
	//
	//	in RFC 3339 format.
	//
	// * `labels`: Supports key-value equality and key presence.
	//
	// Examples:
	//
	//   - `create_time > "2020-01-01" OR update_time > "2020-01-01"`
	//     FeatureOnlineStores created or updated after 2020-01-01.
	//   - `labels.env = "prod"`
	//     FeatureOnlineStores with label "env" set to "prod".
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of FeatureOnlineStores to return. The service may return
	// fewer than this value. If unspecified, at most 100 FeatureOnlineStores will
	// be returned. The maximum value is 100; any value greater than 100 will be
	// coerced to 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeatureOnlineStoreAdminService.ListFeatureOnlineStores][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeatureOnlineStoreAdminService.ListFeatureOnlineStores][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	// Supported Fields:
	//
	//   - `create_time`
	//   - `update_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListFeatureOnlineStoresRequest) Reset() {
	*x = ListFeatureOnlineStoresRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureOnlineStoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureOnlineStoresRequest) ProtoMessage() {}

func (x *ListFeatureOnlineStoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureOnlineStoresRequest.ProtoReflect.Descriptor instead.
func (*ListFeatureOnlineStoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListFeatureOnlineStoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeatureOnlineStoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeatureOnlineStoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeatureOnlineStoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFeatureOnlineStoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [FeatureOnlineStoreAdminService.ListFeatureOnlineStores][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores].
type ListFeatureOnlineStoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FeatureOnlineStores matching the request.
	FeatureOnlineStores []*FeatureOnlineStore `protobuf:"bytes,1,rep,name=feature_online_stores,json=featureOnlineStores,proto3" json:"feature_online_stores,omitempty"`
	// A token, which can be sent as
	// [ListFeatureOnlineStoresRequest.page_token][google.cloud.aiplatform.v1.ListFeatureOnlineStoresRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeatureOnlineStoresResponse) Reset() {
	*x = ListFeatureOnlineStoresResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureOnlineStoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureOnlineStoresResponse) ProtoMessage() {}

func (x *ListFeatureOnlineStoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureOnlineStoresResponse.ProtoReflect.Descriptor instead.
func (*ListFeatureOnlineStoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListFeatureOnlineStoresResponse) GetFeatureOnlineStores() []*FeatureOnlineStore {
	if x != nil {
		return x.FeatureOnlineStores
	}
	return nil
}

func (x *ListFeatureOnlineStoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.UpdateFeatureOnlineStore][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureOnlineStore].
type UpdateFeatureOnlineStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The FeatureOnlineStore's `name` field is used to identify the
	// FeatureOnlineStore to be updated. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
	FeatureOnlineStore *FeatureOnlineStore `protobuf:"bytes,1,opt,name=feature_online_store,json=featureOnlineStore,proto3" json:"feature_online_store,omitempty"`
	// Field mask is used to specify the fields to be overwritten in the
	// FeatureOnlineStore resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then only the non-empty fields present in the
	// request will be overwritten. Set the update_mask to `*` to override all
	// fields.
	//
	// Updatable fields:
	//
	//   - `labels`
	//   - `description`
	//   - `bigtable`
	//   - `bigtable.auto_scaling`
	//   - `bigtable.enable_multi_region_replica`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeatureOnlineStoreRequest) Reset() {
	*x = UpdateFeatureOnlineStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeatureOnlineStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeatureOnlineStoreRequest) ProtoMessage() {}

func (x *UpdateFeatureOnlineStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeatureOnlineStoreRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeatureOnlineStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateFeatureOnlineStoreRequest) GetFeatureOnlineStore() *FeatureOnlineStore {
	if x != nil {
		return x.FeatureOnlineStore
	}
	return nil
}

func (x *UpdateFeatureOnlineStoreRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [FeatureOnlineStoreAdminService.DeleteFeatureOnlineStore][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureOnlineStore].
type DeleteFeatureOnlineStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the FeatureOnlineStore to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, any FeatureViews and Features for this FeatureOnlineStore
	// will also be deleted. (Otherwise, the request will only work if the
	// FeatureOnlineStore has no FeatureViews.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteFeatureOnlineStoreRequest) Reset() {
	*x = DeleteFeatureOnlineStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureOnlineStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureOnlineStoreRequest) ProtoMessage() {}

func (x *DeleteFeatureOnlineStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureOnlineStoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeatureOnlineStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteFeatureOnlineStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFeatureOnlineStoreRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [FeatureOnlineStoreAdminService.CreateFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureView].
type CreateFeatureViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the FeatureOnlineStore to create
	// FeatureViews. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The FeatureView to create.
	FeatureView *FeatureView `protobuf:"bytes,2,opt,name=feature_view,json=featureView,proto3" json:"feature_view,omitempty"`
	// Required. The ID to use for the FeatureView, which will become the final
	// component of the FeatureView's resource name.
	//
	// This value may be up to 60 characters, and valid characters are
	// `[a-z0-9_]`. The first character cannot be a number.
	//
	// The value must be unique within a FeatureOnlineStore.
	FeatureViewId string `protobuf:"bytes,3,opt,name=feature_view_id,json=featureViewId,proto3" json:"feature_view_id,omitempty"`
	// Immutable. If set to true, one on demand sync will be run immediately,
	// regardless whether the
	// [FeatureView.sync_config][google.cloud.aiplatform.v1.FeatureView.sync_config]
	// is configured or not.
	RunSyncImmediately bool `protobuf:"varint,4,opt,name=run_sync_immediately,json=runSyncImmediately,proto3" json:"run_sync_immediately,omitempty"`
}

func (x *CreateFeatureViewRequest) Reset() {
	*x = CreateFeatureViewRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureViewRequest) ProtoMessage() {}

func (x *CreateFeatureViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureViewRequest.ProtoReflect.Descriptor instead.
func (*CreateFeatureViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateFeatureViewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeatureViewRequest) GetFeatureView() *FeatureView {
	if x != nil {
		return x.FeatureView
	}
	return nil
}

func (x *CreateFeatureViewRequest) GetFeatureViewId() string {
	if x != nil {
		return x.FeatureViewId
	}
	return ""
}

func (x *CreateFeatureViewRequest) GetRunSyncImmediately() bool {
	if x != nil {
		return x.RunSyncImmediately
	}
	return false
}

// Request message for
// [FeatureOnlineStoreAdminService.GetFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureView].
type GetFeatureViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the FeatureView resource.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeatureViewRequest) Reset() {
	*x = GetFeatureViewRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeatureViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeatureViewRequest) ProtoMessage() {}

func (x *GetFeatureViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeatureViewRequest.ProtoReflect.Descriptor instead.
func (*GetFeatureViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetFeatureViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.ListFeatureViews][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews].
type ListFeatureViewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the FeatureOnlineStore to list FeatureViews.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the FeatureViews that match the filter expression. The following
	// filters are supported:
	//
	// * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
	// Values must be in RFC 3339 format.
	// * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
	// Values must be in RFC 3339 format.
	// * `labels`: Supports key-value equality as well as key presence.
	//
	// Examples:
	//
	//   - `create_time > \"2020-01-31T15:30:00.000000Z\" OR
	//     update_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViews
	//     created or updated after 2020-01-31T15:30:00.000000Z.
	//   - `labels.active = yes AND labels.env = prod` --> FeatureViews having both
	//     (active: yes) and (env: prod) labels.
	//   - `labels.env: *` --> Any FeatureView which has a label with 'env' as the
	//     key.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of FeatureViews to return. The service may return fewer
	// than this value. If unspecified, at most 1000 FeatureViews will be
	// returned. The maximum value is 1000; any value greater than 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeatureOnlineStoreAdminService.ListFeatureViews][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeatureOnlineStoreAdminService.ListFeatureViews][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	//
	// Supported fields:
	//
	//   - `feature_view_id`
	//   - `create_time`
	//   - `update_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListFeatureViewsRequest) Reset() {
	*x = ListFeatureViewsRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureViewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureViewsRequest) ProtoMessage() {}

func (x *ListFeatureViewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureViewsRequest.ProtoReflect.Descriptor instead.
func (*ListFeatureViewsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListFeatureViewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeatureViewsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeatureViewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeatureViewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFeatureViewsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [FeatureOnlineStoreAdminService.ListFeatureViews][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews].
type ListFeatureViewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FeatureViews matching the request.
	FeatureViews []*FeatureView `protobuf:"bytes,1,rep,name=feature_views,json=featureViews,proto3" json:"feature_views,omitempty"`
	// A token, which can be sent as
	// [ListFeatureViewsRequest.page_token][google.cloud.aiplatform.v1.ListFeatureViewsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeatureViewsResponse) Reset() {
	*x = ListFeatureViewsResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureViewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureViewsResponse) ProtoMessage() {}

func (x *ListFeatureViewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureViewsResponse.ProtoReflect.Descriptor instead.
func (*ListFeatureViewsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListFeatureViewsResponse) GetFeatureViews() []*FeatureView {
	if x != nil {
		return x.FeatureViews
	}
	return nil
}

func (x *ListFeatureViewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.UpdateFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureView].
type UpdateFeatureViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The FeatureView's `name` field is used to identify the
	// FeatureView to be updated. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	FeatureView *FeatureView `protobuf:"bytes,1,opt,name=feature_view,json=featureView,proto3" json:"feature_view,omitempty"`
	// Field mask is used to specify the fields to be overwritten in the
	// FeatureView resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then only the non-empty fields present in the
	// request will be overwritten. Set the update_mask to `*` to override all
	// fields.
	//
	// Updatable fields:
	//
	//   - `labels`
	//   - `service_agent_type`
	//   - `big_query_source`
	//   - `big_query_source.uri`
	//   - `big_query_source.entity_id_columns`
	//   - `feature_registry_source`
	//   - `feature_registry_source.feature_groups`
	//   - `sync_config`
	//   - `sync_config.cron`
	//   - `optimized_config.automatic_resources`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeatureViewRequest) Reset() {
	*x = UpdateFeatureViewRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeatureViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeatureViewRequest) ProtoMessage() {}

func (x *UpdateFeatureViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeatureViewRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeatureViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateFeatureViewRequest) GetFeatureView() *FeatureView {
	if x != nil {
		return x.FeatureView
	}
	return nil
}

func (x *UpdateFeatureViewRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [FeatureOnlineStoreAdminService.DeleteFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureView].
type DeleteFeatureViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the FeatureView to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeatureViewRequest) Reset() {
	*x = DeleteFeatureViewRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureViewRequest) ProtoMessage() {}

func (x *DeleteFeatureViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureViewRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeatureViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteFeatureViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details of operations that perform create FeatureOnlineStore.
type CreateFeatureOnlineStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for FeatureOnlineStore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateFeatureOnlineStoreOperationMetadata) Reset() {
	*x = CreateFeatureOnlineStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureOnlineStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureOnlineStoreOperationMetadata) ProtoMessage() {}

func (x *CreateFeatureOnlineStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureOnlineStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateFeatureOnlineStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{12}
}

func (x *CreateFeatureOnlineStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform update FeatureOnlineStore.
type UpdateFeatureOnlineStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for FeatureOnlineStore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateFeatureOnlineStoreOperationMetadata) Reset() {
	*x = UpdateFeatureOnlineStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeatureOnlineStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeatureOnlineStoreOperationMetadata) ProtoMessage() {}

func (x *UpdateFeatureOnlineStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeatureOnlineStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateFeatureOnlineStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateFeatureOnlineStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform create FeatureView.
type CreateFeatureViewOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for FeatureView Create.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateFeatureViewOperationMetadata) Reset() {
	*x = CreateFeatureViewOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureViewOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureViewOperationMetadata) ProtoMessage() {}

func (x *CreateFeatureViewOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureViewOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateFeatureViewOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{14}
}

func (x *CreateFeatureViewOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform update FeatureView.
type UpdateFeatureViewOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for FeatureView Update.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateFeatureViewOperationMetadata) Reset() {
	*x = UpdateFeatureViewOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeatureViewOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeatureViewOperationMetadata) ProtoMessage() {}

func (x *UpdateFeatureViewOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeatureViewOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateFeatureViewOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateFeatureViewOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [FeatureOnlineStoreAdminService.SyncFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.SyncFeatureView].
type SyncFeatureViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	FeatureView string `protobuf:"bytes,1,opt,name=feature_view,json=featureView,proto3" json:"feature_view,omitempty"`
}

func (x *SyncFeatureViewRequest) Reset() {
	*x = SyncFeatureViewRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncFeatureViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFeatureViewRequest) ProtoMessage() {}

func (x *SyncFeatureViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFeatureViewRequest.ProtoReflect.Descriptor instead.
func (*SyncFeatureViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{16}
}

func (x *SyncFeatureViewRequest) GetFeatureView() string {
	if x != nil {
		return x.FeatureView
	}
	return ""
}

// Response message for
// [FeatureOnlineStoreAdminService.SyncFeatureView][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.SyncFeatureView].
type SyncFeatureViewResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
	FeatureViewSync string `protobuf:"bytes,1,opt,name=feature_view_sync,json=featureViewSync,proto3" json:"feature_view_sync,omitempty"`
}

func (x *SyncFeatureViewResponse) Reset() {
	*x = SyncFeatureViewResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncFeatureViewResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFeatureViewResponse) ProtoMessage() {}

func (x *SyncFeatureViewResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFeatureViewResponse.ProtoReflect.Descriptor instead.
func (*SyncFeatureViewResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{17}
}

func (x *SyncFeatureViewResponse) GetFeatureViewSync() string {
	if x != nil {
		return x.FeatureViewSync
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.GetFeatureViewSync][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureViewSync].
type GetFeatureViewSyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the FeatureViewSync resource.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeatureViewSyncRequest) Reset() {
	*x = GetFeatureViewSyncRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeatureViewSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeatureViewSyncRequest) ProtoMessage() {}

func (x *GetFeatureViewSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeatureViewSyncRequest.ProtoReflect.Descriptor instead.
func (*GetFeatureViewSyncRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetFeatureViewSyncRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeatureOnlineStoreAdminService.ListFeatureViewSyncs][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs].
type ListFeatureViewSyncsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the FeatureView to list FeatureViewSyncs.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the FeatureViewSyncs that match the filter expression. The following
	// filters are supported:
	//
	// * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
	// Values must be in RFC 3339 format.
	//
	// Examples:
	//
	//   - `create_time > \"2020-01-31T15:30:00.000000Z\"` --> FeatureViewSyncs
	//     created after 2020-01-31T15:30:00.000000Z.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of FeatureViewSyncs to return. The service may return
	// fewer than this value. If unspecified, at most 1000 FeatureViewSyncs will
	// be returned. The maximum value is 1000; any value greater than 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeatureOnlineStoreAdminService.ListFeatureViewSyncs][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeatureOnlineStoreAdminService.ListFeatureViewSyncs][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	//
	// Supported fields:
	//
	//   - `create_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListFeatureViewSyncsRequest) Reset() {
	*x = ListFeatureViewSyncsRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureViewSyncsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureViewSyncsRequest) ProtoMessage() {}

func (x *ListFeatureViewSyncsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureViewSyncsRequest.ProtoReflect.Descriptor instead.
func (*ListFeatureViewSyncsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListFeatureViewSyncsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeatureViewSyncsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeatureViewSyncsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeatureViewSyncsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFeatureViewSyncsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [FeatureOnlineStoreAdminService.ListFeatureViewSyncs][google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs].
type ListFeatureViewSyncsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FeatureViewSyncs matching the request.
	FeatureViewSyncs []*FeatureViewSync `protobuf:"bytes,1,rep,name=feature_view_syncs,json=featureViewSyncs,proto3" json:"feature_view_syncs,omitempty"`
	// A token, which can be sent as
	// [ListFeatureViewSyncsRequest.page_token][google.cloud.aiplatform.v1.ListFeatureViewSyncsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeatureViewSyncsResponse) Reset() {
	*x = ListFeatureViewSyncsResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeatureViewSyncsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeatureViewSyncsResponse) ProtoMessage() {}

func (x *ListFeatureViewSyncsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeatureViewSyncsResponse.ProtoReflect.Descriptor instead.
func (*ListFeatureViewSyncsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListFeatureViewSyncsResponse) GetFeatureViewSyncs() []*FeatureViewSync {
	if x != nil {
		return x.FeatureViewSyncs
	}
	return nil
}

func (x *ListFeatureViewSyncsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92,
	0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x65, 0x0a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3a, 0x0a, 0x17, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x49, 0x64, 0x22, 0x68, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdd, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad, 0x01,
	0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x62, 0x0a, 0x15, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x13, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc5, 0x01,
	0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x65, 0x0a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x81, 0x01, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a,
	0x2c, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x9d, 0x02, 0x0a, 0x18, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x2b, 0x0a, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x49, 0x64, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x75, 0x6e, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x69,
	0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x12, 0x72, 0x75, 0x6e, 0x53, 0x79, 0x6e, 0x63, 0x49, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x22, 0x5a, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x18, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5d, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x29, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x8c, 0x01, 0x0a, 0x29, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x85, 0x01, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x85, 0x01, 0x0a, 0x22, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x6a, 0x0a, 0x16, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0c,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x22, 0x45,
	0x0a, 0x17, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x53, 0x79, 0x6e, 0x63, 0x22, 0x62, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53,
	0x79, 0x6e, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xa1, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x59, 0x0a, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x73, 0x79, 0x6e, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x32, 0xd0, 0x1a, 0x0a, 0x1e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc6, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xcd, 0x01, 0xca, 0x41, 0x3f, 0x0a, 0x12, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x29, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f,
	0x3a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12,
	0xc9, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xc8, 0x02, 0x0a, 0x18, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xcf, 0x01, 0xca, 0x41, 0x3f, 0x0a, 0x12, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x29, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x64, 0x3a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf7, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f,
	0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xa1, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb6, 0x01, 0xca, 0x41, 0x31,
	0x0a, 0x0b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x22, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x0c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x22, 0x46, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x73, 0x12, 0xa3, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01,
	0xca, 0x41, 0x31, 0x0a, 0x0b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x12, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x32, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf3, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x2a, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9,
	0x01, 0x0a, 0x0f, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0xda, 0x41, 0x0c,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x79, 0x6e, 0x63, 0x12, 0xe2, 0x01, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e,
	0x63, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x53, 0x79, 0x6e, 0x63, 0x22, 0x68, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5b, 0x12, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xf5, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x53, 0x79,
	0x6e, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x12, 0x59, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x53, 0x79, 0x6e, 0x63, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe1, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x23, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescData = file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_goTypes = []any{
	(*CreateFeatureOnlineStoreRequest)(nil),           // 0: google.cloud.aiplatform.v1.CreateFeatureOnlineStoreRequest
	(*GetFeatureOnlineStoreRequest)(nil),              // 1: google.cloud.aiplatform.v1.GetFeatureOnlineStoreRequest
	(*ListFeatureOnlineStoresRequest)(nil),            // 2: google.cloud.aiplatform.v1.ListFeatureOnlineStoresRequest
	(*ListFeatureOnlineStoresResponse)(nil),           // 3: google.cloud.aiplatform.v1.ListFeatureOnlineStoresResponse
	(*UpdateFeatureOnlineStoreRequest)(nil),           // 4: google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreRequest
	(*DeleteFeatureOnlineStoreRequest)(nil),           // 5: google.cloud.aiplatform.v1.DeleteFeatureOnlineStoreRequest
	(*CreateFeatureViewRequest)(nil),                  // 6: google.cloud.aiplatform.v1.CreateFeatureViewRequest
	(*GetFeatureViewRequest)(nil),                     // 7: google.cloud.aiplatform.v1.GetFeatureViewRequest
	(*ListFeatureViewsRequest)(nil),                   // 8: google.cloud.aiplatform.v1.ListFeatureViewsRequest
	(*ListFeatureViewsResponse)(nil),                  // 9: google.cloud.aiplatform.v1.ListFeatureViewsResponse
	(*UpdateFeatureViewRequest)(nil),                  // 10: google.cloud.aiplatform.v1.UpdateFeatureViewRequest
	(*DeleteFeatureViewRequest)(nil),                  // 11: google.cloud.aiplatform.v1.DeleteFeatureViewRequest
	(*CreateFeatureOnlineStoreOperationMetadata)(nil), // 12: google.cloud.aiplatform.v1.CreateFeatureOnlineStoreOperationMetadata
	(*UpdateFeatureOnlineStoreOperationMetadata)(nil), // 13: google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreOperationMetadata
	(*CreateFeatureViewOperationMetadata)(nil),        // 14: google.cloud.aiplatform.v1.CreateFeatureViewOperationMetadata
	(*UpdateFeatureViewOperationMetadata)(nil),        // 15: google.cloud.aiplatform.v1.UpdateFeatureViewOperationMetadata
	(*SyncFeatureViewRequest)(nil),                    // 16: google.cloud.aiplatform.v1.SyncFeatureViewRequest
	(*SyncFeatureViewResponse)(nil),                   // 17: google.cloud.aiplatform.v1.SyncFeatureViewResponse
	(*GetFeatureViewSyncRequest)(nil),                 // 18: google.cloud.aiplatform.v1.GetFeatureViewSyncRequest
	(*ListFeatureViewSyncsRequest)(nil),               // 19: google.cloud.aiplatform.v1.ListFeatureViewSyncsRequest
	(*ListFeatureViewSyncsResponse)(nil),              // 20: google.cloud.aiplatform.v1.ListFeatureViewSyncsResponse
	(*FeatureOnlineStore)(nil),                        // 21: google.cloud.aiplatform.v1.FeatureOnlineStore
	(*fieldmaskpb.FieldMask)(nil),                     // 22: google.protobuf.FieldMask
	(*FeatureView)(nil),                               // 23: google.cloud.aiplatform.v1.FeatureView
	(*GenericOperationMetadata)(nil),                  // 24: google.cloud.aiplatform.v1.GenericOperationMetadata
	(*FeatureViewSync)(nil),                           // 25: google.cloud.aiplatform.v1.FeatureViewSync
	(*longrunningpb.Operation)(nil),                   // 26: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_depIdxs = []int32{
	21, // 0: google.cloud.aiplatform.v1.CreateFeatureOnlineStoreRequest.feature_online_store:type_name -> google.cloud.aiplatform.v1.FeatureOnlineStore
	21, // 1: google.cloud.aiplatform.v1.ListFeatureOnlineStoresResponse.feature_online_stores:type_name -> google.cloud.aiplatform.v1.FeatureOnlineStore
	21, // 2: google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreRequest.feature_online_store:type_name -> google.cloud.aiplatform.v1.FeatureOnlineStore
	22, // 3: google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreRequest.update_mask:type_name -> google.protobuf.FieldMask
	23, // 4: google.cloud.aiplatform.v1.CreateFeatureViewRequest.feature_view:type_name -> google.cloud.aiplatform.v1.FeatureView
	23, // 5: google.cloud.aiplatform.v1.ListFeatureViewsResponse.feature_views:type_name -> google.cloud.aiplatform.v1.FeatureView
	23, // 6: google.cloud.aiplatform.v1.UpdateFeatureViewRequest.feature_view:type_name -> google.cloud.aiplatform.v1.FeatureView
	22, // 7: google.cloud.aiplatform.v1.UpdateFeatureViewRequest.update_mask:type_name -> google.protobuf.FieldMask
	24, // 8: google.cloud.aiplatform.v1.CreateFeatureOnlineStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	24, // 9: google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	24, // 10: google.cloud.aiplatform.v1.CreateFeatureViewOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	24, // 11: google.cloud.aiplatform.v1.UpdateFeatureViewOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	25, // 12: google.cloud.aiplatform.v1.ListFeatureViewSyncsResponse.feature_view_syncs:type_name -> google.cloud.aiplatform.v1.FeatureViewSync
	0,  // 13: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureOnlineStore:input_type -> google.cloud.aiplatform.v1.CreateFeatureOnlineStoreRequest
	1,  // 14: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureOnlineStore:input_type -> google.cloud.aiplatform.v1.GetFeatureOnlineStoreRequest
	2,  // 15: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores:input_type -> google.cloud.aiplatform.v1.ListFeatureOnlineStoresRequest
	4,  // 16: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureOnlineStore:input_type -> google.cloud.aiplatform.v1.UpdateFeatureOnlineStoreRequest
	5,  // 17: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureOnlineStore:input_type -> google.cloud.aiplatform.v1.DeleteFeatureOnlineStoreRequest
	6,  // 18: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureView:input_type -> google.cloud.aiplatform.v1.CreateFeatureViewRequest
	7,  // 19: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureView:input_type -> google.cloud.aiplatform.v1.GetFeatureViewRequest
	8,  // 20: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews:input_type -> google.cloud.aiplatform.v1.ListFeatureViewsRequest
	10, // 21: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureView:input_type -> google.cloud.aiplatform.v1.UpdateFeatureViewRequest
	11, // 22: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureView:input_type -> google.cloud.aiplatform.v1.DeleteFeatureViewRequest
	16, // 23: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.SyncFeatureView:input_type -> google.cloud.aiplatform.v1.SyncFeatureViewRequest
	18, // 24: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureViewSync:input_type -> google.cloud.aiplatform.v1.GetFeatureViewSyncRequest
	19, // 25: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs:input_type -> google.cloud.aiplatform.v1.ListFeatureViewSyncsRequest
	26, // 26: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureOnlineStore:output_type -> google.longrunning.Operation
	21, // 27: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureOnlineStore:output_type -> google.cloud.aiplatform.v1.FeatureOnlineStore
	3,  // 28: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureOnlineStores:output_type -> google.cloud.aiplatform.v1.ListFeatureOnlineStoresResponse
	26, // 29: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureOnlineStore:output_type -> google.longrunning.Operation
	26, // 30: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureOnlineStore:output_type -> google.longrunning.Operation
	26, // 31: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.CreateFeatureView:output_type -> google.longrunning.Operation
	23, // 32: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureView:output_type -> google.cloud.aiplatform.v1.FeatureView
	9,  // 33: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViews:output_type -> google.cloud.aiplatform.v1.ListFeatureViewsResponse
	26, // 34: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.UpdateFeatureView:output_type -> google.longrunning.Operation
	26, // 35: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.DeleteFeatureView:output_type -> google.longrunning.Operation
	17, // 36: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.SyncFeatureView:output_type -> google.cloud.aiplatform.v1.SyncFeatureViewResponse
	25, // 37: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.GetFeatureViewSync:output_type -> google.cloud.aiplatform.v1.FeatureViewSync
	20, // 38: google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService.ListFeatureViewSyncs:output_type -> google.cloud.aiplatform.v1.ListFeatureViewSyncsResponse
	26, // [26:39] is the sub-list for method output_type
	13, // [13:26] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_init() }
func file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_init() {
	if File_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_feature_online_store_proto_init()
	file_google_cloud_aiplatform_v1_feature_view_proto_init()
	file_google_cloud_aiplatform_v1_feature_view_sync_proto_init()
	file_google_cloud_aiplatform_v1_operation_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto = out.File
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_feature_online_store_admin_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FeatureOnlineStoreAdminServiceClient is the client API for FeatureOnlineStoreAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FeatureOnlineStoreAdminServiceClient interface {
	// Creates a new FeatureOnlineStore in a given project and location.
	CreateFeatureOnlineStore(ctx context.Context, in *CreateFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureOnlineStore.
	GetFeatureOnlineStore(ctx context.Context, in *GetFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*FeatureOnlineStore, error)
	// Lists FeatureOnlineStores in a given project and location.
	ListFeatureOnlineStores(ctx context.Context, in *ListFeatureOnlineStoresRequest, opts ...grpc.CallOption) (*ListFeatureOnlineStoresResponse, error)
	// Updates the parameters of a single FeatureOnlineStore.
	UpdateFeatureOnlineStore(ctx context.Context, in *UpdateFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single FeatureOnlineStore. The FeatureOnlineStore must not
	// contain any FeatureViews.
	DeleteFeatureOnlineStore(ctx context.Context, in *DeleteFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new FeatureView in a given FeatureOnlineStore.
	CreateFeatureView(ctx context.Context, in *CreateFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureView.
	GetFeatureView(ctx context.Context, in *GetFeatureViewRequest, opts ...grpc.CallOption) (*FeatureView, error)
	// Lists FeatureViews in a given FeatureOnlineStore.
	ListFeatureViews(ctx context.Context, in *ListFeatureViewsRequest, opts ...grpc.CallOption) (*ListFeatureViewsResponse, error)
	// Updates the parameters of a single FeatureView.
	UpdateFeatureView(ctx context.Context, in *UpdateFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single FeatureView.
	DeleteFeatureView(ctx context.Context, in *DeleteFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Triggers on-demand sync for the FeatureView.
	SyncFeatureView(ctx context.Context, in *SyncFeatureViewRequest, opts ...grpc.CallOption) (*SyncFeatureViewResponse, error)
	// Gets details of a single FeatureViewSync.
	GetFeatureViewSync(ctx context.Context, in *GetFeatureViewSyncRequest, opts ...grpc.CallOption) (*FeatureViewSync, error)
	// Lists FeatureViewSyncs in a given FeatureView.
	ListFeatureViewSyncs(ctx context.Context, in *ListFeatureViewSyncsRequest, opts ...grpc.CallOption) (*ListFeatureViewSyncsResponse, error)
}

type featureOnlineStoreAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeatureOnlineStoreAdminServiceClient(cc grpc.ClientConnInterface) FeatureOnlineStoreAdminServiceClient {
	return &featureOnlineStoreAdminServiceClient{cc}
}

func (c *featureOnlineStoreAdminServiceClient) CreateFeatureOnlineStore(ctx context.Context, in *CreateFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/CreateFeatureOnlineStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) GetFeatureOnlineStore(ctx context.Context, in *GetFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*FeatureOnlineStore, error) {
	out := new(FeatureOnlineStore)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureOnlineStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) ListFeatureOnlineStores(ctx context.Context, in *ListFeatureOnlineStoresRequest, opts ...grpc.CallOption) (*ListFeatureOnlineStoresResponse, error) {
	out := new(ListFeatureOnlineStoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureOnlineStores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) UpdateFeatureOnlineStore(ctx context.Context, in *UpdateFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/UpdateFeatureOnlineStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) DeleteFeatureOnlineStore(ctx context.Context, in *DeleteFeatureOnlineStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/DeleteFeatureOnlineStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) CreateFeatureView(ctx context.Context, in *CreateFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/CreateFeatureView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) GetFeatureView(ctx context.Context, in *GetFeatureViewRequest, opts ...grpc.CallOption) (*FeatureView, error) {
	out := new(FeatureView)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) ListFeatureViews(ctx context.Context, in *ListFeatureViewsRequest, opts ...grpc.CallOption) (*ListFeatureViewsResponse, error) {
	out := new(ListFeatureViewsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureViews", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) UpdateFeatureView(ctx context.Context, in *UpdateFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/UpdateFeatureView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) DeleteFeatureView(ctx context.Context, in *DeleteFeatureViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/DeleteFeatureView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) SyncFeatureView(ctx context.Context, in *SyncFeatureViewRequest, opts ...grpc.CallOption) (*SyncFeatureViewResponse, error) {
	out := new(SyncFeatureViewResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/SyncFeatureView", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) GetFeatureViewSync(ctx context.Context, in *GetFeatureViewSyncRequest, opts ...grpc.CallOption) (*FeatureViewSync, error) {
	out := new(FeatureViewSync)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureViewSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreAdminServiceClient) ListFeatureViewSyncs(ctx context.Context, in *ListFeatureViewSyncsRequest, opts ...grpc.CallOption) (*ListFeatureViewSyncsResponse, error) {
	out := new(ListFeatureViewSyncsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureViewSyncs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeatureOnlineStoreAdminServiceServer is the server API for FeatureOnlineStoreAdminService service.
type FeatureOnlineStoreAdminServiceServer interface {
	// Creates a new FeatureOnlineStore in a given project and location.
	CreateFeatureOnlineStore(context.Context, *CreateFeatureOnlineStoreRequest) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureOnlineStore.
	GetFeatureOnlineStore(context.Context, *GetFeatureOnlineStoreRequest) (*FeatureOnlineStore, error)
	// Lists FeatureOnlineStores in a given project and location.
	ListFeatureOnlineStores(context.Context, *ListFeatureOnlineStoresRequest) (*ListFeatureOnlineStoresResponse, error)
	// Updates the parameters of a single FeatureOnlineStore.
	UpdateFeatureOnlineStore(context.Context, *UpdateFeatureOnlineStoreRequest) (*longrunningpb.Operation, error)
	// Deletes a single FeatureOnlineStore. The FeatureOnlineStore must not
	// contain any FeatureViews.
	DeleteFeatureOnlineStore(context.Context, *DeleteFeatureOnlineStoreRequest) (*longrunningpb.Operation, error)
	// Creates a new FeatureView in a given FeatureOnlineStore.
	CreateFeatureView(context.Context, *CreateFeatureViewRequest) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureView.
	GetFeatureView(context.Context, *GetFeatureViewRequest) (*FeatureView, error)
	// Lists FeatureViews in a given FeatureOnlineStore.
	ListFeatureViews(context.Context, *ListFeatureViewsRequest) (*ListFeatureViewsResponse, error)
	// Updates the parameters of a single FeatureView.
	UpdateFeatureView(context.Context, *UpdateFeatureViewRequest) (*longrunningpb.Operation, error)
	// Deletes a single FeatureView.
	DeleteFeatureView(context.Context, *DeleteFeatureViewRequest) (*longrunningpb.Operation, error)
	// Triggers on-demand sync for the FeatureView.
	SyncFeatureView(context.Context, *SyncFeatureViewRequest) (*SyncFeatureViewResponse, error)
	// Gets details of a single FeatureViewSync.
	GetFeatureViewSync(context.Context, *GetFeatureViewSyncRequest) (*FeatureViewSync, error)
	// Lists FeatureViewSyncs in a given FeatureView.
	ListFeatureViewSyncs(context.Context, *ListFeatureViewSyncsRequest) (*ListFeatureViewSyncsResponse, error)
}

// UnimplementedFeatureOnlineStoreAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFeatureOnlineStoreAdminServiceServer struct {
}

func (*UnimplementedFeatureOnlineStoreAdminServiceServer) CreateFeatureOnlineStore(context.Context, *CreateFeatureOnlineStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeatureOnlineStore not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) GetFeatureOnlineStore(context.Context, *GetFeatureOnlineStoreRequest) (*FeatureOnlineStore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureOnlineStore not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) ListFeatureOnlineStores(context.Context, *ListFeatureOnlineStoresRequest) (*ListFeatureOnlineStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureOnlineStores not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) UpdateFeatureOnlineStore(context.Context, *UpdateFeatureOnlineStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeatureOnlineStore not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) DeleteFeatureOnlineStore(context.Context, *DeleteFeatureOnlineStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureOnlineStore not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) CreateFeatureView(context.Context, *CreateFeatureViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeatureView not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) GetFeatureView(context.Context, *GetFeatureViewRequest) (*FeatureView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureView not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) ListFeatureViews(context.Context, *ListFeatureViewsRequest) (*ListFeatureViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureViews not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) UpdateFeatureView(context.Context, *UpdateFeatureViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeatureView not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) DeleteFeatureView(context.Context, *DeleteFeatureViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureView not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) SyncFeatureView(context.Context, *SyncFeatureViewRequest) (*SyncFeatureViewResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncFeatureView not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) GetFeatureViewSync(context.Context, *GetFeatureViewSyncRequest) (*FeatureViewSync, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureViewSync not implemented")
}
func (*UnimplementedFeatureOnlineStoreAdminServiceServer) ListFeatureViewSyncs(context.Context, *ListFeatureViewSyncsRequest) (*ListFeatureViewSyncsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureViewSyncs not implemented")
}

func RegisterFeatureOnlineStoreAdminServiceServer(s *grpc.Server, srv FeatureOnlineStoreAdminServiceServer) {
	s.RegisterService(&_FeatureOnlineStoreAdminService_serviceDesc, srv)
}

func _FeatureOnlineStoreAdminService_CreateFeatureOnlineStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureOnlineStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).CreateFeatureOnlineStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/CreateFeatureOnlineStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).CreateFeatureOnlineStore(ctx, req.(*CreateFeatureOnlineStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_GetFeatureOnlineStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureOnlineStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureOnlineStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureOnlineStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureOnlineStore(ctx, req.(*GetFeatureOnlineStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_ListFeatureOnlineStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureOnlineStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureOnlineStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureOnlineStores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureOnlineStores(ctx, req.(*ListFeatureOnlineStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_UpdateFeatureOnlineStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureOnlineStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).UpdateFeatureOnlineStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/UpdateFeatureOnlineStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).UpdateFeatureOnlineStore(ctx, req.(*UpdateFeatureOnlineStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_DeleteFeatureOnlineStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureOnlineStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).DeleteFeatureOnlineStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/DeleteFeatureOnlineStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).DeleteFeatureOnlineStore(ctx, req.(*DeleteFeatureOnlineStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_CreateFeatureView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).CreateFeatureView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/CreateFeatureView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).CreateFeatureView(ctx, req.(*CreateFeatureViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_GetFeatureView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureView(ctx, req.(*GetFeatureViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_ListFeatureViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureViews",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureViews(ctx, req.(*ListFeatureViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_UpdateFeatureView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).UpdateFeatureView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/UpdateFeatureView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).UpdateFeatureView(ctx, req.(*UpdateFeatureViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_DeleteFeatureView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).DeleteFeatureView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/DeleteFeatureView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).DeleteFeatureView(ctx, req.(*DeleteFeatureViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_SyncFeatureView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncFeatureViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).SyncFeatureView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/SyncFeatureView",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).SyncFeatureView(ctx, req.(*SyncFeatureViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_GetFeatureViewSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureViewSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureViewSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/GetFeatureViewSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).GetFeatureViewSync(ctx, req.(*GetFeatureViewSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreAdminService_ListFeatureViewSyncs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureViewSyncsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureViewSyncs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService/ListFeatureViewSyncs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreAdminServiceServer).ListFeatureViewSyncs(ctx, req.(*ListFeatureViewSyncsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FeatureOnlineStoreAdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.FeatureOnlineStoreAdminService",
	HandlerType: (*FeatureOnlineStoreAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFeatureOnlineStore",
			Handler:    _FeatureOnlineStoreAdminService_CreateFeatureOnlineStore_Handler,
		},
		{
			MethodName: "GetFeatureOnlineStore",
			Handler:    _FeatureOnlineStoreAdminService_GetFeatureOnlineStore_Handler,
		},
		{
			MethodName: "ListFeatureOnlineStores",
			Handler:    _FeatureOnlineStoreAdminService_ListFeatureOnlineStores_Handler,
		},
		{
			MethodName: "UpdateFeatureOnlineStore",
			Handler:    _FeatureOnlineStoreAdminService_UpdateFeatureOnlineStore_Handler,
		},
		{
			MethodName: "DeleteFeatureOnlineStore",
			Handler:    _FeatureOnlineStoreAdminService_DeleteFeatureOnlineStore_Handler,
		},
		{
			MethodName: "CreateFeatureView",
			Handler:    _FeatureOnlineStoreAdminService_CreateFeatureView_Handler,
		},
		{
			MethodName: "GetFeatureView",
			Handler:    _FeatureOnlineStoreAdminService_GetFeatureView_Handler,
		},
		{
			MethodName: "ListFeatureViews",
			Handler:    _FeatureOnlineStoreAdminService_ListFeatureViews_Handler,
		},
		{
			MethodName: "UpdateFeatureView",
			Handler:    _FeatureOnlineStoreAdminService_UpdateFeatureView_Handler,
		},
		{
			MethodName: "DeleteFeatureView",
			Handler:    _FeatureOnlineStoreAdminService_DeleteFeatureView_Handler,
		},
		{
			MethodName: "SyncFeatureView",
			Handler:    _FeatureOnlineStoreAdminService_SyncFeatureView_Handler,
		},
		{
			MethodName: "GetFeatureViewSync",
			Handler:    _FeatureOnlineStoreAdminService_GetFeatureViewSync_Handler,
		},
		{
			MethodName: "ListFeatureViewSyncs",
			Handler:    _FeatureOnlineStoreAdminService_ListFeatureViewSyncs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/feature_online_store_admin_service.proto",
}
