// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/match_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request message for
// [MatchService.FindNeighbors][google.cloud.aiplatform.v1.MatchService.FindNeighbors].
type FindNeighborsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the index endpoint.
	// Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// The ID of the DeployedIndex that will serve the request. This request is
	// sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
	// IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
	// has a DeployedIndex.id field.
	// The value of the field below must equal one of the DeployedIndex.id
	// fields of the IndexEndpoint that is being called for this request.
	DeployedIndexId string `protobuf:"bytes,2,opt,name=deployed_index_id,json=deployedIndexId,proto3" json:"deployed_index_id,omitempty"`
	// The list of queries.
	Queries []*FindNeighborsRequest_Query `protobuf:"bytes,3,rep,name=queries,proto3" json:"queries,omitempty"`
	// If set to true, the full datapoints (including all vector values and
	// restricts) of the nearest neighbors are returned.
	// Note that returning full datapoint will significantly increase the
	// latency and cost of the query.
	ReturnFullDatapoint bool `protobuf:"varint,4,opt,name=return_full_datapoint,json=returnFullDatapoint,proto3" json:"return_full_datapoint,omitempty"`
}

func (x *FindNeighborsRequest) Reset() {
	*x = FindNeighborsRequest{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsRequest) ProtoMessage() {}

func (x *FindNeighborsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsRequest.ProtoReflect.Descriptor instead.
func (*FindNeighborsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{0}
}

func (x *FindNeighborsRequest) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

func (x *FindNeighborsRequest) GetDeployedIndexId() string {
	if x != nil {
		return x.DeployedIndexId
	}
	return ""
}

func (x *FindNeighborsRequest) GetQueries() []*FindNeighborsRequest_Query {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *FindNeighborsRequest) GetReturnFullDatapoint() bool {
	if x != nil {
		return x.ReturnFullDatapoint
	}
	return false
}

// The response message for
// [MatchService.FindNeighbors][google.cloud.aiplatform.v1.MatchService.FindNeighbors].
type FindNeighborsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The nearest neighbors of the query datapoints.
	NearestNeighbors []*FindNeighborsResponse_NearestNeighbors `protobuf:"bytes,1,rep,name=nearest_neighbors,json=nearestNeighbors,proto3" json:"nearest_neighbors,omitempty"`
}

func (x *FindNeighborsResponse) Reset() {
	*x = FindNeighborsResponse{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsResponse) ProtoMessage() {}

func (x *FindNeighborsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsResponse.ProtoReflect.Descriptor instead.
func (*FindNeighborsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{1}
}

func (x *FindNeighborsResponse) GetNearestNeighbors() []*FindNeighborsResponse_NearestNeighbors {
	if x != nil {
		return x.NearestNeighbors
	}
	return nil
}

// The request message for
// [MatchService.ReadIndexDatapoints][google.cloud.aiplatform.v1.MatchService.ReadIndexDatapoints].
type ReadIndexDatapointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the index endpoint.
	// Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// The ID of the DeployedIndex that will serve the request.
	DeployedIndexId string `protobuf:"bytes,2,opt,name=deployed_index_id,json=deployedIndexId,proto3" json:"deployed_index_id,omitempty"`
	// IDs of the datapoints to be searched for.
	Ids []string `protobuf:"bytes,3,rep,name=ids,proto3" json:"ids,omitempty"`
}

func (x *ReadIndexDatapointsRequest) Reset() {
	*x = ReadIndexDatapointsRequest{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadIndexDatapointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadIndexDatapointsRequest) ProtoMessage() {}

func (x *ReadIndexDatapointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadIndexDatapointsRequest.ProtoReflect.Descriptor instead.
func (*ReadIndexDatapointsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{2}
}

func (x *ReadIndexDatapointsRequest) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

func (x *ReadIndexDatapointsRequest) GetDeployedIndexId() string {
	if x != nil {
		return x.DeployedIndexId
	}
	return ""
}

func (x *ReadIndexDatapointsRequest) GetIds() []string {
	if x != nil {
		return x.Ids
	}
	return nil
}

// The response message for
// [MatchService.ReadIndexDatapoints][google.cloud.aiplatform.v1.MatchService.ReadIndexDatapoints].
type ReadIndexDatapointsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result list of datapoints.
	Datapoints []*IndexDatapoint `protobuf:"bytes,1,rep,name=datapoints,proto3" json:"datapoints,omitempty"`
}

func (x *ReadIndexDatapointsResponse) Reset() {
	*x = ReadIndexDatapointsResponse{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadIndexDatapointsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadIndexDatapointsResponse) ProtoMessage() {}

func (x *ReadIndexDatapointsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadIndexDatapointsResponse.ProtoReflect.Descriptor instead.
func (*ReadIndexDatapointsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{3}
}

func (x *ReadIndexDatapointsResponse) GetDatapoints() []*IndexDatapoint {
	if x != nil {
		return x.Datapoints
	}
	return nil
}

// A query to find a number of the nearest neighbors (most similar vectors)
// of a vector.
type FindNeighborsRequest_Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Ranking:
	//
	//	*FindNeighborsRequest_Query_Rrf
	Ranking isFindNeighborsRequest_Query_Ranking `protobuf_oneof:"ranking"`
	// Required. The datapoint/vector whose nearest neighbors should be searched
	// for.
	Datapoint *IndexDatapoint `protobuf:"bytes,1,opt,name=datapoint,proto3" json:"datapoint,omitempty"`
	// The number of nearest neighbors to be retrieved from database for each
	// query. If not set, will use the default from the service configuration
	// (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
	NeighborCount int32 `protobuf:"varint,2,opt,name=neighbor_count,json=neighborCount,proto3" json:"neighbor_count,omitempty"`
	// Crowding is a constraint on a neighbor list produced by nearest neighbor
	// search requiring that no more than some value k' of the k neighbors
	// returned have the same value of crowding_attribute.
	// It's used for improving result diversity.
	// This field is the maximum number of matches with the same crowding tag.
	PerCrowdingAttributeNeighborCount int32 `protobuf:"varint,3,opt,name=per_crowding_attribute_neighbor_count,json=perCrowdingAttributeNeighborCount,proto3" json:"per_crowding_attribute_neighbor_count,omitempty"`
	// The number of neighbors to find via approximate search before
	// exact reordering is performed. If not set, the default value from scam
	// config is used; if set, this value must be > 0.
	ApproximateNeighborCount int32 `protobuf:"varint,4,opt,name=approximate_neighbor_count,json=approximateNeighborCount,proto3" json:"approximate_neighbor_count,omitempty"`
	// The fraction of the number of leaves to search, set at query time allows
	// user to tune search performance. This value increase result in both
	// search accuracy and latency increase. The value should be between 0.0
	// and 1.0. If not set or set to 0.0, query uses the default value specified
	// in
	// NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
	FractionLeafNodesToSearchOverride float64 `protobuf:"fixed64,5,opt,name=fraction_leaf_nodes_to_search_override,json=fractionLeafNodesToSearchOverride,proto3" json:"fraction_leaf_nodes_to_search_override,omitempty"`
}

func (x *FindNeighborsRequest_Query) Reset() {
	*x = FindNeighborsRequest_Query{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsRequest_Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsRequest_Query) ProtoMessage() {}

func (x *FindNeighborsRequest_Query) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsRequest_Query.ProtoReflect.Descriptor instead.
func (*FindNeighborsRequest_Query) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{0, 0}
}

func (m *FindNeighborsRequest_Query) GetRanking() isFindNeighborsRequest_Query_Ranking {
	if m != nil {
		return m.Ranking
	}
	return nil
}

func (x *FindNeighborsRequest_Query) GetRrf() *FindNeighborsRequest_Query_RRF {
	if x, ok := x.GetRanking().(*FindNeighborsRequest_Query_Rrf); ok {
		return x.Rrf
	}
	return nil
}

func (x *FindNeighborsRequest_Query) GetDatapoint() *IndexDatapoint {
	if x != nil {
		return x.Datapoint
	}
	return nil
}

func (x *FindNeighborsRequest_Query) GetNeighborCount() int32 {
	if x != nil {
		return x.NeighborCount
	}
	return 0
}

func (x *FindNeighborsRequest_Query) GetPerCrowdingAttributeNeighborCount() int32 {
	if x != nil {
		return x.PerCrowdingAttributeNeighborCount
	}
	return 0
}

func (x *FindNeighborsRequest_Query) GetApproximateNeighborCount() int32 {
	if x != nil {
		return x.ApproximateNeighborCount
	}
	return 0
}

func (x *FindNeighborsRequest_Query) GetFractionLeafNodesToSearchOverride() float64 {
	if x != nil {
		return x.FractionLeafNodesToSearchOverride
	}
	return 0
}

type isFindNeighborsRequest_Query_Ranking interface {
	isFindNeighborsRequest_Query_Ranking()
}

type FindNeighborsRequest_Query_Rrf struct {
	// Optional. Represents RRF algorithm that combines search results.
	Rrf *FindNeighborsRequest_Query_RRF `protobuf:"bytes,6,opt,name=rrf,proto3,oneof"`
}

func (*FindNeighborsRequest_Query_Rrf) isFindNeighborsRequest_Query_Ranking() {}

// Parameters for RRF algorithm that combines search results.
type FindNeighborsRequest_Query_RRF struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Users can provide an alpha value to give more weight to dense
	// vs sparse results. For example, if the alpha is 0, we only return
	// sparse and if the alpha is 1, we only return dense.
	Alpha float32 `protobuf:"fixed32,1,opt,name=alpha,proto3" json:"alpha,omitempty"`
}

func (x *FindNeighborsRequest_Query_RRF) Reset() {
	*x = FindNeighborsRequest_Query_RRF{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsRequest_Query_RRF) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsRequest_Query_RRF) ProtoMessage() {}

func (x *FindNeighborsRequest_Query_RRF) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsRequest_Query_RRF.ProtoReflect.Descriptor instead.
func (*FindNeighborsRequest_Query_RRF) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *FindNeighborsRequest_Query_RRF) GetAlpha() float32 {
	if x != nil {
		return x.Alpha
	}
	return 0
}

// A neighbor of the query vector.
type FindNeighborsResponse_Neighbor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The datapoint of the neighbor.
	// Note that full datapoints are returned only when "return_full_datapoint"
	// is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
	// fields are populated.
	Datapoint *IndexDatapoint `protobuf:"bytes,1,opt,name=datapoint,proto3" json:"datapoint,omitempty"`
	// The distance between the neighbor and the dense embedding query.
	Distance float64 `protobuf:"fixed64,2,opt,name=distance,proto3" json:"distance,omitempty"`
	// The distance between the neighbor and the query sparse_embedding.
	SparseDistance float64 `protobuf:"fixed64,3,opt,name=sparse_distance,json=sparseDistance,proto3" json:"sparse_distance,omitempty"`
}

func (x *FindNeighborsResponse_Neighbor) Reset() {
	*x = FindNeighborsResponse_Neighbor{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsResponse_Neighbor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsResponse_Neighbor) ProtoMessage() {}

func (x *FindNeighborsResponse_Neighbor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsResponse_Neighbor.ProtoReflect.Descriptor instead.
func (*FindNeighborsResponse_Neighbor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *FindNeighborsResponse_Neighbor) GetDatapoint() *IndexDatapoint {
	if x != nil {
		return x.Datapoint
	}
	return nil
}

func (x *FindNeighborsResponse_Neighbor) GetDistance() float64 {
	if x != nil {
		return x.Distance
	}
	return 0
}

func (x *FindNeighborsResponse_Neighbor) GetSparseDistance() float64 {
	if x != nil {
		return x.SparseDistance
	}
	return 0
}

// Nearest neighbors for one query.
type FindNeighborsResponse_NearestNeighbors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the query datapoint.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// All its neighbors.
	Neighbors []*FindNeighborsResponse_Neighbor `protobuf:"bytes,2,rep,name=neighbors,proto3" json:"neighbors,omitempty"`
}

func (x *FindNeighborsResponse_NearestNeighbors) Reset() {
	*x = FindNeighborsResponse_NearestNeighbors{}
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindNeighborsResponse_NearestNeighbors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindNeighborsResponse_NearestNeighbors) ProtoMessage() {}

func (x *FindNeighborsResponse_NearestNeighbors) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindNeighborsResponse_NearestNeighbors.ProtoReflect.Descriptor instead.
func (*FindNeighborsResponse_NearestNeighbors) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *FindNeighborsResponse_NearestNeighbors) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FindNeighborsResponse_NearestNeighbors) GetNeighbors() []*FindNeighborsResponse_Neighbor {
	if x != nil {
		return x.Neighbors
	}
	return nil
}

var File_google_cloud_aiplatform_v1_match_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_match_service_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x85, 0x06, 0x0a, 0x14, 0x46, 0x69, 0x6e, 0x64,
	0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x56, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x07, 0x71,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x46, 0x75, 0x6c,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x1a, 0xe2, 0x03, 0x0a, 0x05, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x53, 0x0a, 0x03, 0x72, 0x72, 0x66, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x52, 0x46, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x72, 0x72, 0x66, 0x12, 0x4d, 0x0a, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x65, 0x69, 0x67,
	0x68, 0x62, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0d, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x50, 0x0a, 0x25, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x21,
	0x70, 0x65, 0x72, 0x43, 0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x3c, 0x0a, 0x1a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61,
	0x74, 0x65, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x51, 0x0a, 0x26, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x61, 0x66,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x21, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x61, 0x66, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x54, 0x6f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x1a, 0x20, 0x0a, 0x03, 0x52, 0x52, 0x46, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x22,
	0xa2, 0x03, 0x0a, 0x15, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x11, 0x6e, 0x65, 0x61,
	0x72, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e,
	0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x52, 0x10, 0x6e, 0x65, 0x61, 0x72, 0x65, 0x73,
	0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x1a, 0x99, 0x01, 0x0a, 0x08, 0x4e,
	0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x12, 0x48, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x61, 0x74,
	0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x44, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x7c, 0x0a, 0x10, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73,
	0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x58, 0x0a, 0x09, 0x6e, 0x65,
	0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4e,
	0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x52, 0x09, 0x6e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x73, 0x22, 0xb2, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x69, 0x64, 0x73, 0x22, 0x69, 0x0a, 0x1b, 0x52, 0x65, 0x61,
	0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x32, 0x91, 0x04, 0x0a, 0x0c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x0d, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65,
	0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x64, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xcf, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_match_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_match_service_proto_rawDescData = file_google_cloud_aiplatform_v1_match_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_match_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_match_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_match_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_match_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_match_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_match_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1_match_service_proto_goTypes = []any{
	(*FindNeighborsRequest)(nil),                   // 0: google.cloud.aiplatform.v1.FindNeighborsRequest
	(*FindNeighborsResponse)(nil),                  // 1: google.cloud.aiplatform.v1.FindNeighborsResponse
	(*ReadIndexDatapointsRequest)(nil),             // 2: google.cloud.aiplatform.v1.ReadIndexDatapointsRequest
	(*ReadIndexDatapointsResponse)(nil),            // 3: google.cloud.aiplatform.v1.ReadIndexDatapointsResponse
	(*FindNeighborsRequest_Query)(nil),             // 4: google.cloud.aiplatform.v1.FindNeighborsRequest.Query
	(*FindNeighborsRequest_Query_RRF)(nil),         // 5: google.cloud.aiplatform.v1.FindNeighborsRequest.Query.RRF
	(*FindNeighborsResponse_Neighbor)(nil),         // 6: google.cloud.aiplatform.v1.FindNeighborsResponse.Neighbor
	(*FindNeighborsResponse_NearestNeighbors)(nil), // 7: google.cloud.aiplatform.v1.FindNeighborsResponse.NearestNeighbors
	(*IndexDatapoint)(nil),                         // 8: google.cloud.aiplatform.v1.IndexDatapoint
}
var file_google_cloud_aiplatform_v1_match_service_proto_depIdxs = []int32{
	4, // 0: google.cloud.aiplatform.v1.FindNeighborsRequest.queries:type_name -> google.cloud.aiplatform.v1.FindNeighborsRequest.Query
	7, // 1: google.cloud.aiplatform.v1.FindNeighborsResponse.nearest_neighbors:type_name -> google.cloud.aiplatform.v1.FindNeighborsResponse.NearestNeighbors
	8, // 2: google.cloud.aiplatform.v1.ReadIndexDatapointsResponse.datapoints:type_name -> google.cloud.aiplatform.v1.IndexDatapoint
	5, // 3: google.cloud.aiplatform.v1.FindNeighborsRequest.Query.rrf:type_name -> google.cloud.aiplatform.v1.FindNeighborsRequest.Query.RRF
	8, // 4: google.cloud.aiplatform.v1.FindNeighborsRequest.Query.datapoint:type_name -> google.cloud.aiplatform.v1.IndexDatapoint
	8, // 5: google.cloud.aiplatform.v1.FindNeighborsResponse.Neighbor.datapoint:type_name -> google.cloud.aiplatform.v1.IndexDatapoint
	6, // 6: google.cloud.aiplatform.v1.FindNeighborsResponse.NearestNeighbors.neighbors:type_name -> google.cloud.aiplatform.v1.FindNeighborsResponse.Neighbor
	0, // 7: google.cloud.aiplatform.v1.MatchService.FindNeighbors:input_type -> google.cloud.aiplatform.v1.FindNeighborsRequest
	2, // 8: google.cloud.aiplatform.v1.MatchService.ReadIndexDatapoints:input_type -> google.cloud.aiplatform.v1.ReadIndexDatapointsRequest
	1, // 9: google.cloud.aiplatform.v1.MatchService.FindNeighbors:output_type -> google.cloud.aiplatform.v1.FindNeighborsResponse
	3, // 10: google.cloud.aiplatform.v1.MatchService.ReadIndexDatapoints:output_type -> google.cloud.aiplatform.v1.ReadIndexDatapointsResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_match_service_proto_init() }
func file_google_cloud_aiplatform_v1_match_service_proto_init() {
	if File_google_cloud_aiplatform_v1_match_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_index_proto_init()
	file_google_cloud_aiplatform_v1_match_service_proto_msgTypes[4].OneofWrappers = []any{
		(*FindNeighborsRequest_Query_Rrf)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_match_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_match_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_match_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_match_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_match_service_proto = out.File
	file_google_cloud_aiplatform_v1_match_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_match_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_match_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MatchServiceClient is the client API for MatchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MatchServiceClient interface {
	// Finds the nearest neighbors of each vector within the request.
	FindNeighbors(ctx context.Context, in *FindNeighborsRequest, opts ...grpc.CallOption) (*FindNeighborsResponse, error)
	// Reads the datapoints/vectors of the given IDs.
	// A maximum of 1000 datapoints can be retrieved in a batch.
	ReadIndexDatapoints(ctx context.Context, in *ReadIndexDatapointsRequest, opts ...grpc.CallOption) (*ReadIndexDatapointsResponse, error)
}

type matchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMatchServiceClient(cc grpc.ClientConnInterface) MatchServiceClient {
	return &matchServiceClient{cc}
}

func (c *matchServiceClient) FindNeighbors(ctx context.Context, in *FindNeighborsRequest, opts ...grpc.CallOption) (*FindNeighborsResponse, error) {
	out := new(FindNeighborsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.MatchService/FindNeighbors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchServiceClient) ReadIndexDatapoints(ctx context.Context, in *ReadIndexDatapointsRequest, opts ...grpc.CallOption) (*ReadIndexDatapointsResponse, error) {
	out := new(ReadIndexDatapointsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.MatchService/ReadIndexDatapoints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MatchServiceServer is the server API for MatchService service.
type MatchServiceServer interface {
	// Finds the nearest neighbors of each vector within the request.
	FindNeighbors(context.Context, *FindNeighborsRequest) (*FindNeighborsResponse, error)
	// Reads the datapoints/vectors of the given IDs.
	// A maximum of 1000 datapoints can be retrieved in a batch.
	ReadIndexDatapoints(context.Context, *ReadIndexDatapointsRequest) (*ReadIndexDatapointsResponse, error)
}

// UnimplementedMatchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMatchServiceServer struct {
}

func (*UnimplementedMatchServiceServer) FindNeighbors(context.Context, *FindNeighborsRequest) (*FindNeighborsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindNeighbors not implemented")
}
func (*UnimplementedMatchServiceServer) ReadIndexDatapoints(context.Context, *ReadIndexDatapointsRequest) (*ReadIndexDatapointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadIndexDatapoints not implemented")
}

func RegisterMatchServiceServer(s *grpc.Server, srv MatchServiceServer) {
	s.RegisterService(&_MatchService_serviceDesc, srv)
}

func _MatchService_FindNeighbors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindNeighborsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchServiceServer).FindNeighbors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.MatchService/FindNeighbors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchServiceServer).FindNeighbors(ctx, req.(*FindNeighborsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchService_ReadIndexDatapoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadIndexDatapointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchServiceServer).ReadIndexDatapoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.MatchService/ReadIndexDatapoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchServiceServer).ReadIndexDatapoints(ctx, req.(*ReadIndexDatapointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MatchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.MatchService",
	HandlerType: (*MatchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindNeighbors",
			Handler:    _MatchService_FindNeighbors_Handler,
		},
		{
			MethodName: "ReadIndexDatapoints",
			Handler:    _MatchService_ReadIndexDatapoints_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/match_service.proto",
}
