// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/endpoint.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Models are deployed into it, and afterwards Endpoint is called to obtain
// predictions and explanations.
type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Endpoint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the Endpoint.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the Endpoint.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The models deployed in this Endpoint.
	// To add or remove DeployedModels use
	// [EndpointService.DeployModel][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]
	// and
	// [EndpointService.UndeployModel][google.cloud.aiplatform.v1beta1.EndpointService.UndeployModel]
	// respectively.
	DeployedModels []*DeployedModel `protobuf:"bytes,4,rep,name=deployed_models,json=deployedModels,proto3" json:"deployed_models,omitempty"`
	// A map from a DeployedModel's ID to the percentage of this Endpoint's
	// traffic that should be forwarded to that DeployedModel.
	//
	// If a DeployedModel's ID is not listed in this map, then it receives no
	// traffic.
	//
	// The traffic percentage values must add up to 100, or map must be empty if
	// the Endpoint is to not accept any traffic at a moment.
	TrafficSplit map[string]int32 `protobuf:"bytes,5,rep,name=traffic_split,json=trafficSplit,proto3" json:"traffic_split,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Used to perform consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// The labels with user-defined metadata to organize your Endpoints.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Timestamp when this Endpoint was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this Endpoint was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Customer-managed encryption key spec for an Endpoint. If set, this
	// Endpoint and all sub-resources of this Endpoint will be secured by
	// this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,10,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
	// to which the Endpoint should be peered.
	//
	// Private services access must already be configured for the network. If left
	// unspecified, the Endpoint is not peered with any network.
	//
	// Only one of the fields,
	// [network][google.cloud.aiplatform.v1beta1.Endpoint.network] or
	// [enable_private_service_connect][google.cloud.aiplatform.v1beta1.Endpoint.enable_private_service_connect],
	// can be set.
	//
	// [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`.
	// Where `{project}` is a project number, as in `12345`, and `{network}` is
	// network name.
	Network string `protobuf:"bytes,13,opt,name=network,proto3" json:"network,omitempty"`
	// Deprecated: If true, expose the Endpoint via private service connect.
	//
	// Only one of the fields,
	// [network][google.cloud.aiplatform.v1beta1.Endpoint.network] or
	// [enable_private_service_connect][google.cloud.aiplatform.v1beta1.Endpoint.enable_private_service_connect],
	// can be set.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/endpoint.proto.
	EnablePrivateServiceConnect bool `protobuf:"varint,17,opt,name=enable_private_service_connect,json=enablePrivateServiceConnect,proto3" json:"enable_private_service_connect,omitempty"`
	// Optional. Configuration for private service connect.
	//
	// [network][google.cloud.aiplatform.v1beta1.Endpoint.network] and
	// [private_service_connect_config][google.cloud.aiplatform.v1beta1.Endpoint.private_service_connect_config]
	// are mutually exclusive.
	PrivateServiceConnectConfig *PrivateServiceConnectConfig `protobuf:"bytes,21,opt,name=private_service_connect_config,json=privateServiceConnectConfig,proto3" json:"private_service_connect_config,omitempty"`
	// Output only. Resource name of the Model Monitoring job associated with this
	// Endpoint if monitoring is enabled by
	// [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1beta1.JobService.CreateModelDeploymentMonitoringJob].
	// Format:
	// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
	ModelDeploymentMonitoringJob string `protobuf:"bytes,14,opt,name=model_deployment_monitoring_job,json=modelDeploymentMonitoringJob,proto3" json:"model_deployment_monitoring_job,omitempty"`
	// Configures the request-response logging for online prediction.
	PredictRequestResponseLoggingConfig *PredictRequestResponseLoggingConfig `protobuf:"bytes,18,opt,name=predict_request_response_logging_config,json=predictRequestResponseLoggingConfig,proto3" json:"predict_request_response_logging_config,omitempty"`
	// If true, the endpoint will be exposed through a dedicated
	// DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
	// will be isolated from other users' traffic and will have better performance
	// and reliability.
	// Note: Once you enabled dedicated endpoint, you won't be able to send
	// request to the shared DNS {region}-aiplatform.googleapis.com. The
	// limitation will be removed soon.
	DedicatedEndpointEnabled bool `protobuf:"varint,24,opt,name=dedicated_endpoint_enabled,json=dedicatedEndpointEnabled,proto3" json:"dedicated_endpoint_enabled,omitempty"`
	// Output only. DNS of the dedicated endpoint. Will only be populated if
	// dedicated_endpoint_enabled is true. Depending on the features enabled, uid
	// might be a random number or a string. For example, if fast_tryout is
	// enabled, uid will be fasttryout. Format:
	// `https://{endpoint_id}.{region}-{uid}.prediction.vertexai.goog`.
	DedicatedEndpointDns string `protobuf:"bytes,25,opt,name=dedicated_endpoint_dns,json=dedicatedEndpointDns,proto3" json:"dedicated_endpoint_dns,omitempty"`
	// Configurations that are applied to the endpoint for online prediction.
	ClientConnectionConfig *ClientConnectionConfig `protobuf:"bytes,23,opt,name=client_connection_config,json=clientConnectionConfig,proto3" json:"client_connection_config,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,27,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,28,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Optional. Configuration for GenAiAdvancedFeatures. If the endpoint is
	// serving GenAI models, advanced features like native RAG integration can be
	// configured. Currently, only Model Garden models are supported.
	GenAiAdvancedFeaturesConfig *GenAiAdvancedFeaturesConfig `protobuf:"bytes,29,opt,name=gen_ai_advanced_features_config,json=genAiAdvancedFeaturesConfig,proto3" json:"gen_ai_advanced_features_config,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{0}
}

func (x *Endpoint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Endpoint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Endpoint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Endpoint) GetDeployedModels() []*DeployedModel {
	if x != nil {
		return x.DeployedModels
	}
	return nil
}

func (x *Endpoint) GetTrafficSplit() map[string]int32 {
	if x != nil {
		return x.TrafficSplit
	}
	return nil
}

func (x *Endpoint) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Endpoint) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Endpoint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Endpoint) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Endpoint) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *Endpoint) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/endpoint.proto.
func (x *Endpoint) GetEnablePrivateServiceConnect() bool {
	if x != nil {
		return x.EnablePrivateServiceConnect
	}
	return false
}

func (x *Endpoint) GetPrivateServiceConnectConfig() *PrivateServiceConnectConfig {
	if x != nil {
		return x.PrivateServiceConnectConfig
	}
	return nil
}

func (x *Endpoint) GetModelDeploymentMonitoringJob() string {
	if x != nil {
		return x.ModelDeploymentMonitoringJob
	}
	return ""
}

func (x *Endpoint) GetPredictRequestResponseLoggingConfig() *PredictRequestResponseLoggingConfig {
	if x != nil {
		return x.PredictRequestResponseLoggingConfig
	}
	return nil
}

func (x *Endpoint) GetDedicatedEndpointEnabled() bool {
	if x != nil {
		return x.DedicatedEndpointEnabled
	}
	return false
}

func (x *Endpoint) GetDedicatedEndpointDns() string {
	if x != nil {
		return x.DedicatedEndpointDns
	}
	return ""
}

func (x *Endpoint) GetClientConnectionConfig() *ClientConnectionConfig {
	if x != nil {
		return x.ClientConnectionConfig
	}
	return nil
}

func (x *Endpoint) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Endpoint) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Endpoint) GetGenAiAdvancedFeaturesConfig() *GenAiAdvancedFeaturesConfig {
	if x != nil {
		return x.GenAiAdvancedFeaturesConfig
	}
	return nil
}

// A deployment of a Model. Endpoints contain one or more DeployedModels.
type DeployedModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction (for example, the machine) resources that the DeployedModel
	// uses. The user is billed for the resources (at least their minimal amount)
	// even if the DeployedModel receives no traffic.
	// Not all Models support all resources types. See
	// [Model.supported_deployment_resources_types][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types].
	// Required except for Large Model Deploy use cases.
	//
	// Types that are assignable to PredictionResources:
	//
	//	*DeployedModel_DedicatedResources
	//	*DeployedModel_AutomaticResources
	//	*DeployedModel_SharedResources
	PredictionResources isDeployedModel_PredictionResources `protobuf_oneof:"prediction_resources"`
	// Immutable. The ID of the DeployedModel. If not provided upon deployment,
	// Vertex AI will generate a value for this ID.
	//
	// This value should be 1-10 characters, and valid characters are `/[0-9]/`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The resource name of the Model that this is the deployment of. Note that
	// the Model may be in a different location than the DeployedModel's Endpoint.
	//
	// The resource name may contain version id or version alias to specify the
	// version.
	//
	//	Example: `projects/{project}/locations/{location}/models/{model}@2`
	//	            or
	//	          `projects/{project}/locations/{location}/models/{model}@golden`
	//
	// if no version is specified, the default version will be deployed.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. The version ID of the model that is deployed.
	ModelVersionId string `protobuf:"bytes,18,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
	// The display name of the DeployedModel. If not provided upon creation,
	// the Model's display_name is used.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Timestamp when the DeployedModel was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Explanation configuration for this DeployedModel.
	//
	// When deploying a Model using
	// [EndpointService.DeployModel][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel],
	// this value overrides the value of
	// [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
	// All fields of
	// [explanation_spec][google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec]
	// are optional in the request. If a field of
	// [explanation_spec][google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec]
	// is not populated, the value of the same field of
	// [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
	// is inherited. If the corresponding
	// [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
	// is not populated, all fields of the
	// [explanation_spec][google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec]
	// will be used for the explanation configuration.
	ExplanationSpec *ExplanationSpec `protobuf:"bytes,9,opt,name=explanation_spec,json=explanationSpec,proto3" json:"explanation_spec,omitempty"`
	// If true, deploy the model without explainable feature, regardless the
	// existence of
	// [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
	// or
	// [explanation_spec][google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec].
	DisableExplanations bool `protobuf:"varint,19,opt,name=disable_explanations,json=disableExplanations,proto3" json:"disable_explanations,omitempty"`
	// The service account that the DeployedModel's container runs as. Specify the
	// email address of the service account. If this service account is not
	// specified, the container runs as a service account that doesn't have access
	// to the resource project.
	//
	// Users deploying the Model must have the `iam.serviceAccounts.actAs`
	// permission on this service account.
	ServiceAccount string `protobuf:"bytes,11,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// If true, the container of the DeployedModel instances will send `stderr`
	// and `stdout` streams to Cloud Logging.
	//
	// Only supported for custom-trained Models and AutoML Tabular Models.
	EnableContainerLogging bool `protobuf:"varint,12,opt,name=enable_container_logging,json=enableContainerLogging,proto3" json:"enable_container_logging,omitempty"`
	// For custom-trained Models and AutoML Tabular Models, the container of the
	// DeployedModel instances will send `stderr` and `stdout` streams to
	// Cloud Logging by default. Please note that the logs incur cost,
	// which are subject to [Cloud Logging
	// pricing](https://cloud.google.com/logging/pricing).
	//
	// User can disable container logging by setting this flag to true.
	DisableContainerLogging bool `protobuf:"varint,15,opt,name=disable_container_logging,json=disableContainerLogging,proto3" json:"disable_container_logging,omitempty"`
	// If true, online prediction access logs are sent to Cloud
	// Logging.
	// These logs are like standard server access logs, containing
	// information like timestamp and latency for each prediction request.
	//
	// Note that logs may incur a cost, especially if your project
	// receives prediction requests at a high queries per second rate (QPS).
	// Estimate your costs before enabling this option.
	EnableAccessLogging bool `protobuf:"varint,13,opt,name=enable_access_logging,json=enableAccessLogging,proto3" json:"enable_access_logging,omitempty"`
	// Output only. Provide paths for users to send predict/explain/health
	// requests directly to the deployed model services running on Cloud via
	// private services access. This field is populated if
	// [network][google.cloud.aiplatform.v1beta1.Endpoint.network] is configured.
	PrivateEndpoints *PrivateEndpoints `protobuf:"bytes,14,opt,name=private_endpoints,json=privateEndpoints,proto3" json:"private_endpoints,omitempty"`
	// Configuration for faster model deployment.
	FasterDeploymentConfig *FasterDeploymentConfig `protobuf:"bytes,23,opt,name=faster_deployment_config,json=fasterDeploymentConfig,proto3" json:"faster_deployment_config,omitempty"`
	// Options for configuring rolling deployments.
	RolloutOptions *RolloutOptions `protobuf:"bytes,25,opt,name=rollout_options,json=rolloutOptions,proto3" json:"rollout_options,omitempty"`
	// Output only. Runtime status of the deployed model.
	Status *DeployedModel_Status `protobuf:"bytes,26,opt,name=status,proto3" json:"status,omitempty"`
	// System labels to apply to Model Garden deployments.
	// System labels are managed by Google for internal use only.
	SystemLabels map[string]string `protobuf:"bytes,28,rep,name=system_labels,json=systemLabels,proto3" json:"system_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The checkpoint id of the model.
	CheckpointId string `protobuf:"bytes,29,opt,name=checkpoint_id,json=checkpointId,proto3" json:"checkpoint_id,omitempty"`
	// Optional. Spec for configuring speculative decoding.
	SpeculativeDecodingSpec *SpeculativeDecodingSpec `protobuf:"bytes,30,opt,name=speculative_decoding_spec,json=speculativeDecodingSpec,proto3" json:"speculative_decoding_spec,omitempty"`
}

func (x *DeployedModel) Reset() {
	*x = DeployedModel{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployedModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedModel) ProtoMessage() {}

func (x *DeployedModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedModel.ProtoReflect.Descriptor instead.
func (*DeployedModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{1}
}

func (m *DeployedModel) GetPredictionResources() isDeployedModel_PredictionResources {
	if m != nil {
		return m.PredictionResources
	}
	return nil
}

func (x *DeployedModel) GetDedicatedResources() *DedicatedResources {
	if x, ok := x.GetPredictionResources().(*DeployedModel_DedicatedResources); ok {
		return x.DedicatedResources
	}
	return nil
}

func (x *DeployedModel) GetAutomaticResources() *AutomaticResources {
	if x, ok := x.GetPredictionResources().(*DeployedModel_AutomaticResources); ok {
		return x.AutomaticResources
	}
	return nil
}

func (x *DeployedModel) GetSharedResources() string {
	if x, ok := x.GetPredictionResources().(*DeployedModel_SharedResources); ok {
		return x.SharedResources
	}
	return ""
}

func (x *DeployedModel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeployedModel) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *DeployedModel) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

func (x *DeployedModel) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DeployedModel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeployedModel) GetExplanationSpec() *ExplanationSpec {
	if x != nil {
		return x.ExplanationSpec
	}
	return nil
}

func (x *DeployedModel) GetDisableExplanations() bool {
	if x != nil {
		return x.DisableExplanations
	}
	return false
}

func (x *DeployedModel) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DeployedModel) GetEnableContainerLogging() bool {
	if x != nil {
		return x.EnableContainerLogging
	}
	return false
}

func (x *DeployedModel) GetDisableContainerLogging() bool {
	if x != nil {
		return x.DisableContainerLogging
	}
	return false
}

func (x *DeployedModel) GetEnableAccessLogging() bool {
	if x != nil {
		return x.EnableAccessLogging
	}
	return false
}

func (x *DeployedModel) GetPrivateEndpoints() *PrivateEndpoints {
	if x != nil {
		return x.PrivateEndpoints
	}
	return nil
}

func (x *DeployedModel) GetFasterDeploymentConfig() *FasterDeploymentConfig {
	if x != nil {
		return x.FasterDeploymentConfig
	}
	return nil
}

func (x *DeployedModel) GetRolloutOptions() *RolloutOptions {
	if x != nil {
		return x.RolloutOptions
	}
	return nil
}

func (x *DeployedModel) GetStatus() *DeployedModel_Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *DeployedModel) GetSystemLabels() map[string]string {
	if x != nil {
		return x.SystemLabels
	}
	return nil
}

func (x *DeployedModel) GetCheckpointId() string {
	if x != nil {
		return x.CheckpointId
	}
	return ""
}

func (x *DeployedModel) GetSpeculativeDecodingSpec() *SpeculativeDecodingSpec {
	if x != nil {
		return x.SpeculativeDecodingSpec
	}
	return nil
}

type isDeployedModel_PredictionResources interface {
	isDeployedModel_PredictionResources()
}

type DeployedModel_DedicatedResources struct {
	// A description of resources that are dedicated to the DeployedModel, and
	// that need a higher degree of manual configuration.
	DedicatedResources *DedicatedResources `protobuf:"bytes,7,opt,name=dedicated_resources,json=dedicatedResources,proto3,oneof"`
}

type DeployedModel_AutomaticResources struct {
	// A description of resources that to large degree are decided by Vertex
	// AI, and require only a modest additional configuration.
	AutomaticResources *AutomaticResources `protobuf:"bytes,8,opt,name=automatic_resources,json=automaticResources,proto3,oneof"`
}

type DeployedModel_SharedResources struct {
	// The resource name of the shared DeploymentResourcePool to deploy on.
	// Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
	SharedResources string `protobuf:"bytes,17,opt,name=shared_resources,json=sharedResources,proto3,oneof"`
}

func (*DeployedModel_DedicatedResources) isDeployedModel_PredictionResources() {}

func (*DeployedModel_AutomaticResources) isDeployedModel_PredictionResources() {}

func (*DeployedModel_SharedResources) isDeployedModel_PredictionResources() {}

// PrivateEndpoints proto is used to provide paths for users to send
// requests privately.
// To send request via private service access, use predict_http_uri,
// explain_http_uri or health_http_uri. To send request via private service
// connect, use service_attachment.
type PrivateEndpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Http(s) path to send prediction requests.
	PredictHttpUri string `protobuf:"bytes,1,opt,name=predict_http_uri,json=predictHttpUri,proto3" json:"predict_http_uri,omitempty"`
	// Output only. Http(s) path to send explain requests.
	ExplainHttpUri string `protobuf:"bytes,2,opt,name=explain_http_uri,json=explainHttpUri,proto3" json:"explain_http_uri,omitempty"`
	// Output only. Http(s) path to send health check requests.
	HealthHttpUri string `protobuf:"bytes,3,opt,name=health_http_uri,json=healthHttpUri,proto3" json:"health_http_uri,omitempty"`
	// Output only. The name of the service attachment resource. Populated if
	// private service connect is enabled.
	ServiceAttachment string `protobuf:"bytes,4,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
}

func (x *PrivateEndpoints) Reset() {
	*x = PrivateEndpoints{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateEndpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateEndpoints) ProtoMessage() {}

func (x *PrivateEndpoints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateEndpoints.ProtoReflect.Descriptor instead.
func (*PrivateEndpoints) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{2}
}

func (x *PrivateEndpoints) GetPredictHttpUri() string {
	if x != nil {
		return x.PredictHttpUri
	}
	return ""
}

func (x *PrivateEndpoints) GetExplainHttpUri() string {
	if x != nil {
		return x.ExplainHttpUri
	}
	return ""
}

func (x *PrivateEndpoints) GetHealthHttpUri() string {
	if x != nil {
		return x.HealthHttpUri
	}
	return ""
}

func (x *PrivateEndpoints) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

// Configuration for logging request-response to a BigQuery table.
type PredictRequestResponseLoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If logging is enabled or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Percentage of requests to be logged, expressed as a fraction in
	// range(0,1].
	SamplingRate float64 `protobuf:"fixed64,2,opt,name=sampling_rate,json=samplingRate,proto3" json:"sampling_rate,omitempty"`
	// BigQuery table for logging.
	// If only given a project, a new dataset will be created with name
	// `logging_<endpoint-display-name>_<endpoint-id>` where
	// <endpoint-display-name> will be made BigQuery-dataset-name compatible (e.g.
	// most special characters will become underscores). If no table name is
	// given, a new table will be created with name `request_response_logging`
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,3,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
	// Output only. The schema version used in creating the BigQuery table for the
	// request response logging. The versions are "v1" and "v2". The current
	// default version is "v1".
	RequestResponseLoggingSchemaVersion string `protobuf:"bytes,4,opt,name=request_response_logging_schema_version,json=requestResponseLoggingSchemaVersion,proto3" json:"request_response_logging_schema_version,omitempty"`
	// This field is used for large models. If true, in addition to the
	// original large model logs, logs will be converted in OTel schema format,
	// and saved in otel_log column. Default value is false.
	EnableOtelLogging bool `protobuf:"varint,6,opt,name=enable_otel_logging,json=enableOtelLogging,proto3" json:"enable_otel_logging,omitempty"`
}

func (x *PredictRequestResponseLoggingConfig) Reset() {
	*x = PredictRequestResponseLoggingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictRequestResponseLoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictRequestResponseLoggingConfig) ProtoMessage() {}

func (x *PredictRequestResponseLoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictRequestResponseLoggingConfig.ProtoReflect.Descriptor instead.
func (*PredictRequestResponseLoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{3}
}

func (x *PredictRequestResponseLoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PredictRequestResponseLoggingConfig) GetSamplingRate() float64 {
	if x != nil {
		return x.SamplingRate
	}
	return 0
}

func (x *PredictRequestResponseLoggingConfig) GetBigqueryDestination() *BigQueryDestination {
	if x != nil {
		return x.BigqueryDestination
	}
	return nil
}

func (x *PredictRequestResponseLoggingConfig) GetRequestResponseLoggingSchemaVersion() string {
	if x != nil {
		return x.RequestResponseLoggingSchemaVersion
	}
	return ""
}

func (x *PredictRequestResponseLoggingConfig) GetEnableOtelLogging() bool {
	if x != nil {
		return x.EnableOtelLogging
	}
	return false
}

// This message contains configs of a publisher model.
type PublisherModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction request/response logging config.
	LoggingConfig *PredictRequestResponseLoggingConfig `protobuf:"bytes,3,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
}

func (x *PublisherModelConfig) Reset() {
	*x = PublisherModelConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublisherModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModelConfig) ProtoMessage() {}

func (x *PublisherModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModelConfig.ProtoReflect.Descriptor instead.
func (*PublisherModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{4}
}

func (x *PublisherModelConfig) GetLoggingConfig() *PredictRequestResponseLoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

// Configurations (e.g. inference timeout) that are applied on your endpoints.
type ClientConnectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Customizable online prediction request timeout.
	InferenceTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=inference_timeout,json=inferenceTimeout,proto3" json:"inference_timeout,omitempty"`
}

func (x *ClientConnectionConfig) Reset() {
	*x = ClientConnectionConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientConnectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectionConfig) ProtoMessage() {}

func (x *ClientConnectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectionConfig.ProtoReflect.Descriptor instead.
func (*ClientConnectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{5}
}

func (x *ClientConnectionConfig) GetInferenceTimeout() *durationpb.Duration {
	if x != nil {
		return x.InferenceTimeout
	}
	return nil
}

// Configuration for faster model deployment.
type FasterDeploymentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, enable fast tryout feature for this deployed model.
	FastTryoutEnabled bool `protobuf:"varint,2,opt,name=fast_tryout_enabled,json=fastTryoutEnabled,proto3" json:"fast_tryout_enabled,omitempty"`
}

func (x *FasterDeploymentConfig) Reset() {
	*x = FasterDeploymentConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FasterDeploymentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FasterDeploymentConfig) ProtoMessage() {}

func (x *FasterDeploymentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FasterDeploymentConfig.ProtoReflect.Descriptor instead.
func (*FasterDeploymentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{6}
}

func (x *FasterDeploymentConfig) GetFastTryoutEnabled() bool {
	if x != nil {
		return x.FastTryoutEnabled
	}
	return false
}

// Configuration for rolling deployments.
type RolloutOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configures how many replicas are allowed to be unavailable during a rolling
	// deployment.
	//
	// Types that are assignable to MaxUnavailable:
	//
	//	*RolloutOptions_MaxUnavailableReplicas
	//	*RolloutOptions_MaxUnavailablePercentage
	MaxUnavailable isRolloutOptions_MaxUnavailable `protobuf_oneof:"max_unavailable"`
	// Configures how many additional replicas can be provisioned during a rolling
	// deployment.
	//
	// Types that are assignable to MaxSurge:
	//
	//	*RolloutOptions_MaxSurgeReplicas
	//	*RolloutOptions_MaxSurgePercentage
	MaxSurge isRolloutOptions_MaxSurge `protobuf_oneof:"max_surge"`
	// ID of the DeployedModel that this deployment should replace.
	PreviousDeployedModel string `protobuf:"bytes,1,opt,name=previous_deployed_model,json=previousDeployedModel,proto3" json:"previous_deployed_model,omitempty"`
	// Output only. Read-only. Revision number determines the relative priority of
	// DeployedModels in the same rollout. The DeployedModel with the largest
	// revision number specifies the intended state of the deployment.
	RevisionNumber int32 `protobuf:"varint,2,opt,name=revision_number,json=revisionNumber,proto3" json:"revision_number,omitempty"`
}

func (x *RolloutOptions) Reset() {
	*x = RolloutOptions{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RolloutOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RolloutOptions) ProtoMessage() {}

func (x *RolloutOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RolloutOptions.ProtoReflect.Descriptor instead.
func (*RolloutOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{7}
}

func (m *RolloutOptions) GetMaxUnavailable() isRolloutOptions_MaxUnavailable {
	if m != nil {
		return m.MaxUnavailable
	}
	return nil
}

func (x *RolloutOptions) GetMaxUnavailableReplicas() int32 {
	if x, ok := x.GetMaxUnavailable().(*RolloutOptions_MaxUnavailableReplicas); ok {
		return x.MaxUnavailableReplicas
	}
	return 0
}

func (x *RolloutOptions) GetMaxUnavailablePercentage() int32 {
	if x, ok := x.GetMaxUnavailable().(*RolloutOptions_MaxUnavailablePercentage); ok {
		return x.MaxUnavailablePercentage
	}
	return 0
}

func (m *RolloutOptions) GetMaxSurge() isRolloutOptions_MaxSurge {
	if m != nil {
		return m.MaxSurge
	}
	return nil
}

func (x *RolloutOptions) GetMaxSurgeReplicas() int32 {
	if x, ok := x.GetMaxSurge().(*RolloutOptions_MaxSurgeReplicas); ok {
		return x.MaxSurgeReplicas
	}
	return 0
}

func (x *RolloutOptions) GetMaxSurgePercentage() int32 {
	if x, ok := x.GetMaxSurge().(*RolloutOptions_MaxSurgePercentage); ok {
		return x.MaxSurgePercentage
	}
	return 0
}

func (x *RolloutOptions) GetPreviousDeployedModel() string {
	if x != nil {
		return x.PreviousDeployedModel
	}
	return ""
}

func (x *RolloutOptions) GetRevisionNumber() int32 {
	if x != nil {
		return x.RevisionNumber
	}
	return 0
}

type isRolloutOptions_MaxUnavailable interface {
	isRolloutOptions_MaxUnavailable()
}

type RolloutOptions_MaxUnavailableReplicas struct {
	// Absolute count of replicas allowed to be unavailable.
	MaxUnavailableReplicas int32 `protobuf:"varint,3,opt,name=max_unavailable_replicas,json=maxUnavailableReplicas,proto3,oneof"`
}

type RolloutOptions_MaxUnavailablePercentage struct {
	// Percentage of replicas allowed to be unavailable.
	// For autoscaling deployments, this refers to the target replica count.
	MaxUnavailablePercentage int32 `protobuf:"varint,4,opt,name=max_unavailable_percentage,json=maxUnavailablePercentage,proto3,oneof"`
}

func (*RolloutOptions_MaxUnavailableReplicas) isRolloutOptions_MaxUnavailable() {}

func (*RolloutOptions_MaxUnavailablePercentage) isRolloutOptions_MaxUnavailable() {}

type isRolloutOptions_MaxSurge interface {
	isRolloutOptions_MaxSurge()
}

type RolloutOptions_MaxSurgeReplicas struct {
	// Absolute count of allowed additional replicas.
	MaxSurgeReplicas int32 `protobuf:"varint,5,opt,name=max_surge_replicas,json=maxSurgeReplicas,proto3,oneof"`
}

type RolloutOptions_MaxSurgePercentage struct {
	// Percentage of allowed additional replicas.
	// For autoscaling deployments, this refers to the target replica count.
	MaxSurgePercentage int32 `protobuf:"varint,6,opt,name=max_surge_percentage,json=maxSurgePercentage,proto3,oneof"`
}

func (*RolloutOptions_MaxSurgeReplicas) isRolloutOptions_MaxSurge() {}

func (*RolloutOptions_MaxSurgePercentage) isRolloutOptions_MaxSurge() {}

// Configuration for GenAiAdvancedFeatures.
type GenAiAdvancedFeaturesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for Retrieval Augmented Generation feature.
	RagConfig *GenAiAdvancedFeaturesConfig_RagConfig `protobuf:"bytes,1,opt,name=rag_config,json=ragConfig,proto3" json:"rag_config,omitempty"`
}

func (x *GenAiAdvancedFeaturesConfig) Reset() {
	*x = GenAiAdvancedFeaturesConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenAiAdvancedFeaturesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenAiAdvancedFeaturesConfig) ProtoMessage() {}

func (x *GenAiAdvancedFeaturesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenAiAdvancedFeaturesConfig.ProtoReflect.Descriptor instead.
func (*GenAiAdvancedFeaturesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{8}
}

func (x *GenAiAdvancedFeaturesConfig) GetRagConfig() *GenAiAdvancedFeaturesConfig_RagConfig {
	if x != nil {
		return x.RagConfig
	}
	return nil
}

// Configuration for Speculative Decoding.
type SpeculativeDecodingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of speculation method to use.
	//
	// Types that are assignable to Speculation:
	//
	//	*SpeculativeDecodingSpec_DraftModelSpeculation_
	//	*SpeculativeDecodingSpec_NgramSpeculation_
	Speculation isSpeculativeDecodingSpec_Speculation `protobuf_oneof:"speculation"`
	// The number of speculative tokens to generate at each step.
	SpeculativeTokenCount int32 `protobuf:"varint,1,opt,name=speculative_token_count,json=speculativeTokenCount,proto3" json:"speculative_token_count,omitempty"`
}

func (x *SpeculativeDecodingSpec) Reset() {
	*x = SpeculativeDecodingSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeculativeDecodingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeculativeDecodingSpec) ProtoMessage() {}

func (x *SpeculativeDecodingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeculativeDecodingSpec.ProtoReflect.Descriptor instead.
func (*SpeculativeDecodingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{9}
}

func (m *SpeculativeDecodingSpec) GetSpeculation() isSpeculativeDecodingSpec_Speculation {
	if m != nil {
		return m.Speculation
	}
	return nil
}

func (x *SpeculativeDecodingSpec) GetDraftModelSpeculation() *SpeculativeDecodingSpec_DraftModelSpeculation {
	if x, ok := x.GetSpeculation().(*SpeculativeDecodingSpec_DraftModelSpeculation_); ok {
		return x.DraftModelSpeculation
	}
	return nil
}

func (x *SpeculativeDecodingSpec) GetNgramSpeculation() *SpeculativeDecodingSpec_NgramSpeculation {
	if x, ok := x.GetSpeculation().(*SpeculativeDecodingSpec_NgramSpeculation_); ok {
		return x.NgramSpeculation
	}
	return nil
}

func (x *SpeculativeDecodingSpec) GetSpeculativeTokenCount() int32 {
	if x != nil {
		return x.SpeculativeTokenCount
	}
	return 0
}

type isSpeculativeDecodingSpec_Speculation interface {
	isSpeculativeDecodingSpec_Speculation()
}

type SpeculativeDecodingSpec_DraftModelSpeculation_ struct {
	// draft model speculation.
	DraftModelSpeculation *SpeculativeDecodingSpec_DraftModelSpeculation `protobuf:"bytes,2,opt,name=draft_model_speculation,json=draftModelSpeculation,proto3,oneof"`
}

type SpeculativeDecodingSpec_NgramSpeculation_ struct {
	// N-Gram speculation.
	NgramSpeculation *SpeculativeDecodingSpec_NgramSpeculation `protobuf:"bytes,3,opt,name=ngram_speculation,json=ngramSpeculation,proto3,oneof"`
}

func (*SpeculativeDecodingSpec_DraftModelSpeculation_) isSpeculativeDecodingSpec_Speculation() {}

func (*SpeculativeDecodingSpec_NgramSpeculation_) isSpeculativeDecodingSpec_Speculation() {}

// Runtime status of the deployed model.
type DeployedModel_Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The latest deployed model's status message (if any).
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. The time at which the status was last updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. The number of available replicas of the deployed model.
	AvailableReplicaCount int32 `protobuf:"varint,3,opt,name=available_replica_count,json=availableReplicaCount,proto3" json:"available_replica_count,omitempty"`
}

func (x *DeployedModel_Status) Reset() {
	*x = DeployedModel_Status{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployedModel_Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedModel_Status) ProtoMessage() {}

func (x *DeployedModel_Status) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedModel_Status.ProtoReflect.Descriptor instead.
func (*DeployedModel_Status) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DeployedModel_Status) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DeployedModel_Status) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *DeployedModel_Status) GetAvailableReplicaCount() int32 {
	if x != nil {
		return x.AvailableReplicaCount
	}
	return 0
}

// Configuration for Retrieval Augmented Generation feature.
type GenAiAdvancedFeaturesConfig_RagConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, enable Retrieval Augmented Generation in ChatCompletion request.
	// Once enabled, the endpoint will be identified as GenAI endpoint and
	// Arthedain router will be used.
	EnableRag bool `protobuf:"varint,1,opt,name=enable_rag,json=enableRag,proto3" json:"enable_rag,omitempty"`
}

func (x *GenAiAdvancedFeaturesConfig_RagConfig) Reset() {
	*x = GenAiAdvancedFeaturesConfig_RagConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenAiAdvancedFeaturesConfig_RagConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenAiAdvancedFeaturesConfig_RagConfig) ProtoMessage() {}

func (x *GenAiAdvancedFeaturesConfig_RagConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenAiAdvancedFeaturesConfig_RagConfig.ProtoReflect.Descriptor instead.
func (*GenAiAdvancedFeaturesConfig_RagConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{8, 0}
}

func (x *GenAiAdvancedFeaturesConfig_RagConfig) GetEnableRag() bool {
	if x != nil {
		return x.EnableRag
	}
	return false
}

// Draft model speculation works by using the smaller model to generate
// candidate tokens for speculative decoding.
type SpeculativeDecodingSpec_DraftModelSpeculation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the draft model.
	DraftModel string `protobuf:"bytes,1,opt,name=draft_model,json=draftModel,proto3" json:"draft_model,omitempty"`
}

func (x *SpeculativeDecodingSpec_DraftModelSpeculation) Reset() {
	*x = SpeculativeDecodingSpec_DraftModelSpeculation{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeculativeDecodingSpec_DraftModelSpeculation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeculativeDecodingSpec_DraftModelSpeculation) ProtoMessage() {}

func (x *SpeculativeDecodingSpec_DraftModelSpeculation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeculativeDecodingSpec_DraftModelSpeculation.ProtoReflect.Descriptor instead.
func (*SpeculativeDecodingSpec_DraftModelSpeculation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{9, 0}
}

func (x *SpeculativeDecodingSpec_DraftModelSpeculation) GetDraftModel() string {
	if x != nil {
		return x.DraftModel
	}
	return ""
}

// N-Gram speculation works by trying to find matching tokens in the
// previous prompt sequence and use those as speculation for generating
// new tokens.
type SpeculativeDecodingSpec_NgramSpeculation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of last N input tokens used as ngram to search/match
	// against the previous prompt sequence.
	// This is equal to the N in N-Gram.
	// The default value is 3 if not specified.
	NgramSize int32 `protobuf:"varint,1,opt,name=ngram_size,json=ngramSize,proto3" json:"ngram_size,omitempty"`
}

func (x *SpeculativeDecodingSpec_NgramSpeculation) Reset() {
	*x = SpeculativeDecodingSpec_NgramSpeculation{}
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeculativeDecodingSpec_NgramSpeculation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeculativeDecodingSpec_NgramSpeculation) ProtoMessage() {}

func (x *SpeculativeDecodingSpec_NgramSpeculation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeculativeDecodingSpec_NgramSpeculation.ProtoReflect.Descriptor instead.
func (*SpeculativeDecodingSpec_NgramSpeculation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP(), []int{9, 1}
}

func (x *SpeculativeDecodingSpec_NgramSpeculation) GetNgramSize() int32 {
	if x != nil {
		return x.NgramSize
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_endpoint_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x0f, 0x0a, 0x08, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x47, 0x0a, 0x1e, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x12, 0x86, 0x01, 0x0a, 0x1e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x1f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x38, 0x0a, 0x36, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x52, 0x1c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x12, 0x9a, 0x01, 0x0a, 0x27, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x23, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3c, 0x0a, 0x1a, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x18, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x39, 0x0a,
	0x16, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x64, 0x6e, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x6e, 0x73, 0x12, 0x71, 0x0a, 0x18, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x16, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x73,
	0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x1b, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12,
	0x87, 0x01, 0x0a, 0x1f, 0x67, 0x65, 0x6e, 0x5f, 0x61, 0x69, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x41,
	0x69, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x67, 0x65,
	0x6e, 0x41, 0x69, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3f, 0x0a, 0x11, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb5, 0x01, 0xea, 0x41, 0xb1, 0x01, 0x0a, 0x22, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0x4d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x7d, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x22, 0xa3, 0x0e,
	0x0a, 0x0d, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x66, 0x0a, 0x13, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x62, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xfa, 0x41, 0x32, 0x0a, 0x30,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x48, 0x00, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3a, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x0a, 0x19, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x63, 0x0a, 0x11, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x12, 0x71, 0x0a, 0x18, 0x66, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x66, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x65, 0x0a, 0x0d, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x79, 0x0a,
	0x19, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x17, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xaf, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c,
	0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a,
	0x17, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x3f, 0x0a, 0x11, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x22, 0xd1, 0x01, 0x0a, 0x10, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x48, 0x74, 0x74, 0x70, 0x55, 0x72, 0x69, 0x12, 0x2d, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x48,
	0x74, 0x74, 0x70, 0x55, 0x72, 0x69, 0x12, 0x2b, 0x0a, 0x0f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x48, 0x74, 0x74, 0x70,
	0x55, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xd8, 0x02, 0x0a, 0x23, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x12, 0x67,
	0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x27, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x23, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x74, 0x65, 0x6c, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x22, 0x83, 0x01, 0x0a, 0x14, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x0e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x60, 0x0a, 0x16, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x46, 0x0a, 0x11, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x48, 0x0a, 0x16, 0x46, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x79,
	0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x66, 0x61, 0x73, 0x74, 0x54, 0x72, 0x79, 0x6f, 0x75, 0x74, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x22, 0xf6, 0x02, 0x0a, 0x0e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x75,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x61, 0x78,
	0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x73, 0x12, 0x3e, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x55, 0x6e,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x72, 0x67, 0x65,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x01, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x73, 0x12, 0x32, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x72, 0x67, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x01, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x72, 0x65, 0x76, 0x69,
	0x6f, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f,
	0x75, 0x73, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x11, 0x0a,
	0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x42, 0x0b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x72, 0x67, 0x65, 0x22, 0xb0, 0x01,
	0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a,
	0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x41, 0x69, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0x2a, 0x0a, 0x09, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x61, 0x67,
	0x22, 0xfb, 0x03, 0x0a, 0x17, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x88, 0x01, 0x0a,
	0x17, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x72, 0x61, 0x66, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x15, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x11, 0x6e, 0x67, 0x72, 0x61, 0x6d,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4e, 0x67, 0x72,
	0x61, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x10, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x15, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x61, 0x0a, 0x15, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x0a, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x31, 0x0a, 0x10,
	0x4e, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x69, 0x7a, 0x65, 0x42,
	0x0d, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xe4,
	0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_aiplatform_v1beta1_endpoint_proto_goTypes = []any{
	(*Endpoint)(nil),                            // 0: google.cloud.aiplatform.v1beta1.Endpoint
	(*DeployedModel)(nil),                       // 1: google.cloud.aiplatform.v1beta1.DeployedModel
	(*PrivateEndpoints)(nil),                    // 2: google.cloud.aiplatform.v1beta1.PrivateEndpoints
	(*PredictRequestResponseLoggingConfig)(nil), // 3: google.cloud.aiplatform.v1beta1.PredictRequestResponseLoggingConfig
	(*PublisherModelConfig)(nil),                // 4: google.cloud.aiplatform.v1beta1.PublisherModelConfig
	(*ClientConnectionConfig)(nil),              // 5: google.cloud.aiplatform.v1beta1.ClientConnectionConfig
	(*FasterDeploymentConfig)(nil),              // 6: google.cloud.aiplatform.v1beta1.FasterDeploymentConfig
	(*RolloutOptions)(nil),                      // 7: google.cloud.aiplatform.v1beta1.RolloutOptions
	(*GenAiAdvancedFeaturesConfig)(nil),         // 8: google.cloud.aiplatform.v1beta1.GenAiAdvancedFeaturesConfig
	(*SpeculativeDecodingSpec)(nil),             // 9: google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec
	nil,                                         // 10: google.cloud.aiplatform.v1beta1.Endpoint.TrafficSplitEntry
	nil,                                         // 11: google.cloud.aiplatform.v1beta1.Endpoint.LabelsEntry
	(*DeployedModel_Status)(nil),                // 12: google.cloud.aiplatform.v1beta1.DeployedModel.Status
	nil,                                         // 13: google.cloud.aiplatform.v1beta1.DeployedModel.SystemLabelsEntry
	(*GenAiAdvancedFeaturesConfig_RagConfig)(nil),         // 14: google.cloud.aiplatform.v1beta1.GenAiAdvancedFeaturesConfig.RagConfig
	(*SpeculativeDecodingSpec_DraftModelSpeculation)(nil), // 15: google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.DraftModelSpeculation
	(*SpeculativeDecodingSpec_NgramSpeculation)(nil),      // 16: google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.NgramSpeculation
	(*timestamppb.Timestamp)(nil),                         // 17: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),                                // 18: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*PrivateServiceConnectConfig)(nil),                   // 19: google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
	(*DedicatedResources)(nil),                            // 20: google.cloud.aiplatform.v1beta1.DedicatedResources
	(*AutomaticResources)(nil),                            // 21: google.cloud.aiplatform.v1beta1.AutomaticResources
	(*ExplanationSpec)(nil),                               // 22: google.cloud.aiplatform.v1beta1.ExplanationSpec
	(*BigQueryDestination)(nil),                           // 23: google.cloud.aiplatform.v1beta1.BigQueryDestination
	(*durationpb.Duration)(nil),                           // 24: google.protobuf.Duration
}
var file_google_cloud_aiplatform_v1beta1_endpoint_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1beta1.Endpoint.deployed_models:type_name -> google.cloud.aiplatform.v1beta1.DeployedModel
	10, // 1: google.cloud.aiplatform.v1beta1.Endpoint.traffic_split:type_name -> google.cloud.aiplatform.v1beta1.Endpoint.TrafficSplitEntry
	11, // 2: google.cloud.aiplatform.v1beta1.Endpoint.labels:type_name -> google.cloud.aiplatform.v1beta1.Endpoint.LabelsEntry
	17, // 3: google.cloud.aiplatform.v1beta1.Endpoint.create_time:type_name -> google.protobuf.Timestamp
	17, // 4: google.cloud.aiplatform.v1beta1.Endpoint.update_time:type_name -> google.protobuf.Timestamp
	18, // 5: google.cloud.aiplatform.v1beta1.Endpoint.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	19, // 6: google.cloud.aiplatform.v1beta1.Endpoint.private_service_connect_config:type_name -> google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
	3,  // 7: google.cloud.aiplatform.v1beta1.Endpoint.predict_request_response_logging_config:type_name -> google.cloud.aiplatform.v1beta1.PredictRequestResponseLoggingConfig
	5,  // 8: google.cloud.aiplatform.v1beta1.Endpoint.client_connection_config:type_name -> google.cloud.aiplatform.v1beta1.ClientConnectionConfig
	8,  // 9: google.cloud.aiplatform.v1beta1.Endpoint.gen_ai_advanced_features_config:type_name -> google.cloud.aiplatform.v1beta1.GenAiAdvancedFeaturesConfig
	20, // 10: google.cloud.aiplatform.v1beta1.DeployedModel.dedicated_resources:type_name -> google.cloud.aiplatform.v1beta1.DedicatedResources
	21, // 11: google.cloud.aiplatform.v1beta1.DeployedModel.automatic_resources:type_name -> google.cloud.aiplatform.v1beta1.AutomaticResources
	17, // 12: google.cloud.aiplatform.v1beta1.DeployedModel.create_time:type_name -> google.protobuf.Timestamp
	22, // 13: google.cloud.aiplatform.v1beta1.DeployedModel.explanation_spec:type_name -> google.cloud.aiplatform.v1beta1.ExplanationSpec
	2,  // 14: google.cloud.aiplatform.v1beta1.DeployedModel.private_endpoints:type_name -> google.cloud.aiplatform.v1beta1.PrivateEndpoints
	6,  // 15: google.cloud.aiplatform.v1beta1.DeployedModel.faster_deployment_config:type_name -> google.cloud.aiplatform.v1beta1.FasterDeploymentConfig
	7,  // 16: google.cloud.aiplatform.v1beta1.DeployedModel.rollout_options:type_name -> google.cloud.aiplatform.v1beta1.RolloutOptions
	12, // 17: google.cloud.aiplatform.v1beta1.DeployedModel.status:type_name -> google.cloud.aiplatform.v1beta1.DeployedModel.Status
	13, // 18: google.cloud.aiplatform.v1beta1.DeployedModel.system_labels:type_name -> google.cloud.aiplatform.v1beta1.DeployedModel.SystemLabelsEntry
	9,  // 19: google.cloud.aiplatform.v1beta1.DeployedModel.speculative_decoding_spec:type_name -> google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec
	23, // 20: google.cloud.aiplatform.v1beta1.PredictRequestResponseLoggingConfig.bigquery_destination:type_name -> google.cloud.aiplatform.v1beta1.BigQueryDestination
	3,  // 21: google.cloud.aiplatform.v1beta1.PublisherModelConfig.logging_config:type_name -> google.cloud.aiplatform.v1beta1.PredictRequestResponseLoggingConfig
	24, // 22: google.cloud.aiplatform.v1beta1.ClientConnectionConfig.inference_timeout:type_name -> google.protobuf.Duration
	14, // 23: google.cloud.aiplatform.v1beta1.GenAiAdvancedFeaturesConfig.rag_config:type_name -> google.cloud.aiplatform.v1beta1.GenAiAdvancedFeaturesConfig.RagConfig
	15, // 24: google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.draft_model_speculation:type_name -> google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.DraftModelSpeculation
	16, // 25: google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.ngram_speculation:type_name -> google.cloud.aiplatform.v1beta1.SpeculativeDecodingSpec.NgramSpeculation
	17, // 26: google.cloud.aiplatform.v1beta1.DeployedModel.Status.last_update_time:type_name -> google.protobuf.Timestamp
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_endpoint_proto_init() }
func file_google_cloud_aiplatform_v1beta1_endpoint_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_endpoint_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_explanation_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1beta1_service_networking_proto_init()
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[1].OneofWrappers = []any{
		(*DeployedModel_DedicatedResources)(nil),
		(*DeployedModel_AutomaticResources)(nil),
		(*DeployedModel_SharedResources)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[7].OneofWrappers = []any{
		(*RolloutOptions_MaxUnavailableReplicas)(nil),
		(*RolloutOptions_MaxUnavailablePercentage)(nil),
		(*RolloutOptions_MaxSurgeReplicas)(nil),
		(*RolloutOptions_MaxSurgePercentage)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes[9].OneofWrappers = []any{
		(*SpeculativeDecodingSpec_DraftModelSpeculation_)(nil),
		(*SpeculativeDecodingSpec_NgramSpeculation_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_endpoint_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_endpoint_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_endpoint_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_endpoint_proto = out.File
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_endpoint_proto_depIdxs = nil
}
