// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_monitor.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Vertex AI Model Monitoring Service serves as a central hub for the analysis
// and visualization of data quality and performance related to models.
// ModelMonitor stands as a top level resource for overseeing your model
// monitoring tasks.
type ModelMonitor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional default monitoring objective, it can be overridden in the
	// ModelMonitoringJob objective spec.
	//
	// Types that are assignable to DefaultObjective:
	//
	//	*ModelMonitor_TabularObjective
	DefaultObjective isModelMonitor_DefaultObjective `protobuf_oneof:"default_objective"`
	// Immutable. Resource name of the ModelMonitor. Format:
	// `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the ModelMonitor.
	// The name can be up to 128 characters long and can consist of any UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The entity that is subject to analysis.
	// Currently only models in Vertex AI Model Registry are supported. If you
	// want to analyze the model which is outside the Vertex AI, you could
	// register a model in Vertex AI Model Registry using just a display name.
	ModelMonitoringTarget *ModelMonitor_ModelMonitoringTarget `protobuf:"bytes,3,opt,name=model_monitoring_target,json=modelMonitoringTarget,proto3" json:"model_monitoring_target,omitempty"`
	// Optional training dataset used to train the model.
	// It can serve as a reference dataset to identify changes in production.
	TrainingDataset *ModelMonitoringInput `protobuf:"bytes,10,opt,name=training_dataset,json=trainingDataset,proto3" json:"training_dataset,omitempty"`
	// Optional default notification spec, it can be overridden in the
	// ModelMonitoringJob notification spec.
	NotificationSpec *ModelMonitoringNotificationSpec `protobuf:"bytes,12,opt,name=notification_spec,json=notificationSpec,proto3" json:"notification_spec,omitempty"`
	// Optional default monitoring metrics/logs export spec, it can be overridden
	// in the ModelMonitoringJob output spec.
	// If not specified, a default Google Cloud Storage bucket will be created
	// under your project.
	OutputSpec *ModelMonitoringOutputSpec `protobuf:"bytes,13,opt,name=output_spec,json=outputSpec,proto3" json:"output_spec,omitempty"`
	// Optional model explanation spec. It is used for feature attribution
	// monitoring.
	ExplanationSpec *ExplanationSpec `protobuf:"bytes,16,opt,name=explanation_spec,json=explanationSpec,proto3" json:"explanation_spec,omitempty"`
	// Monitoring Schema is to specify the model's features, prediction outputs
	// and ground truth properties. It is used to extract pertinent data from the
	// dataset and to process features based on their properties.
	// Make sure that the schema aligns with your dataset, if it does not, we will
	// be unable to extract data from the dataset.
	// It is required for most models, but optional for Vertex AI AutoML Tables
	// unless the schem information is not available.
	ModelMonitoringSchema *ModelMonitoringSchema `protobuf:"bytes,9,opt,name=model_monitoring_schema,json=modelMonitoringSchema,proto3" json:"model_monitoring_schema,omitempty"`
	// Customer-managed encryption key spec for a ModelMonitor. If
	// set, this ModelMonitor and all sub-resources of this
	// ModelMonitor will be secured by this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,5,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Output only. Timestamp when this ModelMonitor was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this ModelMonitor was updated most recently.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,17,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,18,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *ModelMonitor) Reset() {
	*x = ModelMonitor{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitor) ProtoMessage() {}

func (x *ModelMonitor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitor.ProtoReflect.Descriptor instead.
func (*ModelMonitor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP(), []int{0}
}

func (m *ModelMonitor) GetDefaultObjective() isModelMonitor_DefaultObjective {
	if m != nil {
		return m.DefaultObjective
	}
	return nil
}

func (x *ModelMonitor) GetTabularObjective() *ModelMonitoringObjectiveSpec_TabularObjective {
	if x, ok := x.GetDefaultObjective().(*ModelMonitor_TabularObjective); ok {
		return x.TabularObjective
	}
	return nil
}

func (x *ModelMonitor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModelMonitor) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ModelMonitor) GetModelMonitoringTarget() *ModelMonitor_ModelMonitoringTarget {
	if x != nil {
		return x.ModelMonitoringTarget
	}
	return nil
}

func (x *ModelMonitor) GetTrainingDataset() *ModelMonitoringInput {
	if x != nil {
		return x.TrainingDataset
	}
	return nil
}

func (x *ModelMonitor) GetNotificationSpec() *ModelMonitoringNotificationSpec {
	if x != nil {
		return x.NotificationSpec
	}
	return nil
}

func (x *ModelMonitor) GetOutputSpec() *ModelMonitoringOutputSpec {
	if x != nil {
		return x.OutputSpec
	}
	return nil
}

func (x *ModelMonitor) GetExplanationSpec() *ExplanationSpec {
	if x != nil {
		return x.ExplanationSpec
	}
	return nil
}

func (x *ModelMonitor) GetModelMonitoringSchema() *ModelMonitoringSchema {
	if x != nil {
		return x.ModelMonitoringSchema
	}
	return nil
}

func (x *ModelMonitor) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *ModelMonitor) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ModelMonitor) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ModelMonitor) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *ModelMonitor) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

type isModelMonitor_DefaultObjective interface {
	isModelMonitor_DefaultObjective()
}

type ModelMonitor_TabularObjective struct {
	// Optional default tabular model monitoring objective.
	TabularObjective *ModelMonitoringObjectiveSpec_TabularObjective `protobuf:"bytes,11,opt,name=tabular_objective,json=tabularObjective,proto3,oneof"`
}

func (*ModelMonitor_TabularObjective) isModelMonitor_DefaultObjective() {}

// The Model Monitoring Schema definition.
type ModelMonitoringSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature names of the model. Vertex AI will try to match the features from
	// your dataset as follows:
	//   - For 'csv' files, the header names are required, and we will extract the
	//     corresponding feature values when the header names align with the
	//     feature names.
	//   - For 'jsonl' files, we will extract the corresponding feature values if
	//     the key names match the feature names.
	//     Note: Nested features are not supported, so please ensure your features
	//     are flattened. Ensure the feature values are scalar or an array of
	//     scalars.
	//   - For 'bigquery' dataset, we will extract the corresponding feature values
	//     if the column names match the feature names.
	//     Note: The column type can be a scalar or an array of scalars. STRUCT or
	//     JSON types are not supported. You may use SQL queries to select or
	//     aggregate the relevant features from your original table. However,
	//     ensure that the 'schema' of the query results meets our requirements.
	//   - For the Vertex AI Endpoint Request Response Logging table or Vertex AI
	//     Batch Prediction Job results. If the
	//     [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
	//     is an array, ensure that the sequence in
	//     [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
	//     matches the order of features in the prediction instance. We will match
	//     the feature with the array in the order specified in [feature_fields].
	FeatureFields []*ModelMonitoringSchema_FieldSchema `protobuf:"bytes,1,rep,name=feature_fields,json=featureFields,proto3" json:"feature_fields,omitempty"`
	// Prediction output names of the model. The requirements are the same as the
	// [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
	// For AutoML Tables, the prediction output name presented in schema will be:
	// `predicted_{target_column}`, the `target_column` is the one you specified
	// when you train the model.
	// For Prediction output drift analysis:
	//   - AutoML Classification, the distribution of the argmax label will be
	//     analyzed.
	//   - AutoML Regression, the distribution of the value will be analyzed.
	PredictionFields []*ModelMonitoringSchema_FieldSchema `protobuf:"bytes,2,rep,name=prediction_fields,json=predictionFields,proto3" json:"prediction_fields,omitempty"`
	// Target /ground truth names of the model.
	GroundTruthFields []*ModelMonitoringSchema_FieldSchema `protobuf:"bytes,3,rep,name=ground_truth_fields,json=groundTruthFields,proto3" json:"ground_truth_fields,omitempty"`
}

func (x *ModelMonitoringSchema) Reset() {
	*x = ModelMonitoringSchema{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringSchema) ProtoMessage() {}

func (x *ModelMonitoringSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringSchema.ProtoReflect.Descriptor instead.
func (*ModelMonitoringSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP(), []int{1}
}

func (x *ModelMonitoringSchema) GetFeatureFields() []*ModelMonitoringSchema_FieldSchema {
	if x != nil {
		return x.FeatureFields
	}
	return nil
}

func (x *ModelMonitoringSchema) GetPredictionFields() []*ModelMonitoringSchema_FieldSchema {
	if x != nil {
		return x.PredictionFields
	}
	return nil
}

func (x *ModelMonitoringSchema) GetGroundTruthFields() []*ModelMonitoringSchema_FieldSchema {
	if x != nil {
		return x.GroundTruthFields
	}
	return nil
}

// The monitoring target refers to the entity that is subject to analysis.
// e.g. Vertex AI Model version.
type ModelMonitor_ModelMonitoringTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*ModelMonitor_ModelMonitoringTarget_VertexModel
	Source isModelMonitor_ModelMonitoringTarget_Source `protobuf_oneof:"source"`
}

func (x *ModelMonitor_ModelMonitoringTarget) Reset() {
	*x = ModelMonitor_ModelMonitoringTarget{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitor_ModelMonitoringTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitor_ModelMonitoringTarget) ProtoMessage() {}

func (x *ModelMonitor_ModelMonitoringTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitor_ModelMonitoringTarget.ProtoReflect.Descriptor instead.
func (*ModelMonitor_ModelMonitoringTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP(), []int{0, 0}
}

func (m *ModelMonitor_ModelMonitoringTarget) GetSource() isModelMonitor_ModelMonitoringTarget_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ModelMonitor_ModelMonitoringTarget) GetVertexModel() *ModelMonitor_ModelMonitoringTarget_VertexModelSource {
	if x, ok := x.GetSource().(*ModelMonitor_ModelMonitoringTarget_VertexModel); ok {
		return x.VertexModel
	}
	return nil
}

type isModelMonitor_ModelMonitoringTarget_Source interface {
	isModelMonitor_ModelMonitoringTarget_Source()
}

type ModelMonitor_ModelMonitoringTarget_VertexModel struct {
	// Model in Vertex AI Model Registry.
	VertexModel *ModelMonitor_ModelMonitoringTarget_VertexModelSource `protobuf:"bytes,1,opt,name=vertex_model,json=vertexModel,proto3,oneof"`
}

func (*ModelMonitor_ModelMonitoringTarget_VertexModel) isModelMonitor_ModelMonitoringTarget_Source() {
}

// Model in Vertex AI Model Registry.
type ModelMonitor_ModelMonitoringTarget_VertexModelSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model resource name. Format:
	// projects/{project}/locations/{location}/models/{model}.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Model version id.
	ModelVersionId string `protobuf:"bytes,2,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
}

func (x *ModelMonitor_ModelMonitoringTarget_VertexModelSource) Reset() {
	*x = ModelMonitor_ModelMonitoringTarget_VertexModelSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitor_ModelMonitoringTarget_VertexModelSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitor_ModelMonitoringTarget_VertexModelSource) ProtoMessage() {}

func (x *ModelMonitor_ModelMonitoringTarget_VertexModelSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitor_ModelMonitoringTarget_VertexModelSource.ProtoReflect.Descriptor instead.
func (*ModelMonitor_ModelMonitoringTarget_VertexModelSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ModelMonitor_ModelMonitoringTarget_VertexModelSource) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *ModelMonitor_ModelMonitoringTarget_VertexModelSource) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

// Schema field definition.
type ModelMonitoringSchema_FieldSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Supported data types are:
	// `float`
	// `integer`
	// `boolean`
	// `string`
	// `categorical`
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Describes if the schema field is an array of given data type.
	Repeated bool `protobuf:"varint,3,opt,name=repeated,proto3" json:"repeated,omitempty"`
}

func (x *ModelMonitoringSchema_FieldSchema) Reset() {
	*x = ModelMonitoringSchema_FieldSchema{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringSchema_FieldSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringSchema_FieldSchema) ProtoMessage() {}

func (x *ModelMonitoringSchema_FieldSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringSchema_FieldSchema.ProtoReflect.Descriptor instead.
func (*ModelMonitoringSchema_FieldSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ModelMonitoringSchema_FieldSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModelMonitoringSchema_FieldSchema) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *ModelMonitoringSchema_FieldSchema) GetRepeated() bool {
	if x != nil {
		return x.Repeated
	}
	return false
}

var File_google_cloud_aiplatform_v1beta1_model_monitor_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x97, 0x0c, 0x0a, 0x0c, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x12, 0x7d, 0x0a, 0x11, 0x74,
	0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x48, 0x00, 0x52, 0x10, 0x74, 0x61, 0x62, 0x75, 0x6c, 0x61,
	0x72, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x7b, 0x0a, 0x17, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x15, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x60, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x6d, 0x0a, 0x11, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x5b, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x65,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e,
	0x0a, 0x17, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x15, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x58,
	0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69,
	0x1a, 0x98, 0x02, 0x0a, 0x15, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x7a, 0x0a, 0x0c, 0x76, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x79, 0x0a, 0x11, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3a, 0x72, 0xea, 0x41, 0x6f,
	0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x7d, 0x42,
	0x13, 0x0a, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x22, 0xc3, 0x03, 0x0a, 0x15, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x69,
	0x0a, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x6f, 0x0a, 0x11, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x72, 0x0a, 0x13, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x11, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x54, 0x72, 0x75, 0x74, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x5a,
	0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0xe8, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x11, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_aiplatform_v1beta1_model_monitor_proto_goTypes = []any{
	(*ModelMonitor)(nil),                                         // 0: google.cloud.aiplatform.v1beta1.ModelMonitor
	(*ModelMonitoringSchema)(nil),                                // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringSchema
	(*ModelMonitor_ModelMonitoringTarget)(nil),                   // 2: google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
	(*ModelMonitor_ModelMonitoringTarget_VertexModelSource)(nil), // 3: google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
	(*ModelMonitoringSchema_FieldSchema)(nil),                    // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema
	(*ModelMonitoringObjectiveSpec_TabularObjective)(nil),        // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
	(*ModelMonitoringInput)(nil),                                 // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringInput
	(*ModelMonitoringNotificationSpec)(nil),                      // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
	(*ModelMonitoringOutputSpec)(nil),                            // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec
	(*ExplanationSpec)(nil),                                      // 9: google.cloud.aiplatform.v1beta1.ExplanationSpec
	(*EncryptionSpec)(nil),                                       // 10: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*timestamppb.Timestamp)(nil),                                // 11: google.protobuf.Timestamp
}
var file_google_cloud_aiplatform_v1beta1_model_monitor_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1beta1.ModelMonitor.tabular_objective:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
	2,  // 1: google.cloud.aiplatform.v1beta1.ModelMonitor.model_monitoring_target:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
	6,  // 2: google.cloud.aiplatform.v1beta1.ModelMonitor.training_dataset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringInput
	7,  // 3: google.cloud.aiplatform.v1beta1.ModelMonitor.notification_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
	8,  // 4: google.cloud.aiplatform.v1beta1.ModelMonitor.output_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec
	9,  // 5: google.cloud.aiplatform.v1beta1.ModelMonitor.explanation_spec:type_name -> google.cloud.aiplatform.v1beta1.ExplanationSpec
	1,  // 6: google.cloud.aiplatform.v1beta1.ModelMonitor.model_monitoring_schema:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringSchema
	10, // 7: google.cloud.aiplatform.v1beta1.ModelMonitor.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	11, // 8: google.cloud.aiplatform.v1beta1.ModelMonitor.create_time:type_name -> google.protobuf.Timestamp
	11, // 9: google.cloud.aiplatform.v1beta1.ModelMonitor.update_time:type_name -> google.protobuf.Timestamp
	4,  // 10: google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema
	4,  // 11: google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.prediction_fields:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema
	4,  // 12: google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.ground_truth_fields:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema
	3,  // 13: google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.vertex_model:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_monitor_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_monitor_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_monitor_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_explanation_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_monitoring_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[0].OneofWrappers = []any{
		(*ModelMonitor_TabularObjective)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes[2].OneofWrappers = []any{
		(*ModelMonitor_ModelMonitoringTarget_VertexModel)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_monitor_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_monitor_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_monitor_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_monitor_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_monitor_proto_depIdxs = nil
}
