// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/pipeline_service.proto

package aiplatformpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PipelineService_CreateTrainingPipeline_FullMethodName  = "/google.cloud.aiplatform.v1beta1.PipelineService/CreateTrainingPipeline"
	PipelineService_GetTrainingPipeline_FullMethodName     = "/google.cloud.aiplatform.v1beta1.PipelineService/GetTrainingPipeline"
	PipelineService_ListTrainingPipelines_FullMethodName   = "/google.cloud.aiplatform.v1beta1.PipelineService/ListTrainingPipelines"
	PipelineService_DeleteTrainingPipeline_FullMethodName  = "/google.cloud.aiplatform.v1beta1.PipelineService/DeleteTrainingPipeline"
	PipelineService_CancelTrainingPipeline_FullMethodName  = "/google.cloud.aiplatform.v1beta1.PipelineService/CancelTrainingPipeline"
	PipelineService_CreatePipelineJob_FullMethodName       = "/google.cloud.aiplatform.v1beta1.PipelineService/CreatePipelineJob"
	PipelineService_GetPipelineJob_FullMethodName          = "/google.cloud.aiplatform.v1beta1.PipelineService/GetPipelineJob"
	PipelineService_ListPipelineJobs_FullMethodName        = "/google.cloud.aiplatform.v1beta1.PipelineService/ListPipelineJobs"
	PipelineService_DeletePipelineJob_FullMethodName       = "/google.cloud.aiplatform.v1beta1.PipelineService/DeletePipelineJob"
	PipelineService_BatchDeletePipelineJobs_FullMethodName = "/google.cloud.aiplatform.v1beta1.PipelineService/BatchDeletePipelineJobs"
	PipelineService_CancelPipelineJob_FullMethodName       = "/google.cloud.aiplatform.v1beta1.PipelineService/CancelPipelineJob"
	PipelineService_BatchCancelPipelineJobs_FullMethodName = "/google.cloud.aiplatform.v1beta1.PipelineService/BatchCancelPipelineJobs"
)

// PipelineServiceClient is the client API for PipelineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PipelineServiceClient interface {
	// Creates a TrainingPipeline. A created TrainingPipeline right away will be
	// attempted to be run.
	CreateTrainingPipeline(ctx context.Context, in *CreateTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error)
	// Gets a TrainingPipeline.
	GetTrainingPipeline(ctx context.Context, in *GetTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error)
	// Lists TrainingPipelines in a Location.
	ListTrainingPipelines(ctx context.Context, in *ListTrainingPipelinesRequest, opts ...grpc.CallOption) (*ListTrainingPipelinesResponse, error)
	// Deletes a TrainingPipeline.
	DeleteTrainingPipeline(ctx context.Context, in *DeleteTrainingPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a TrainingPipeline.
	// Starts asynchronous cancellation on the TrainingPipeline. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the TrainingPipeline is not deleted; instead it becomes a pipeline with
	// a
	// [TrainingPipeline.error][google.cloud.aiplatform.v1beta1.TrainingPipeline.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [TrainingPipeline.state][google.cloud.aiplatform.v1beta1.TrainingPipeline.state]
	// is set to `CANCELLED`.
	CancelTrainingPipeline(ctx context.Context, in *CancelTrainingPipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a PipelineJob. A PipelineJob will run immediately when created.
	CreatePipelineJob(ctx context.Context, in *CreatePipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error)
	// Gets a PipelineJob.
	GetPipelineJob(ctx context.Context, in *GetPipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error)
	// Lists PipelineJobs in a Location.
	ListPipelineJobs(ctx context.Context, in *ListPipelineJobsRequest, opts ...grpc.CallOption) (*ListPipelineJobsResponse, error)
	// Deletes a PipelineJob.
	DeletePipelineJob(ctx context.Context, in *DeletePipelineJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch deletes PipelineJobs
	// The Operation is atomic. If it fails, none of the PipelineJobs are deleted.
	// If it succeeds, all of the PipelineJobs are deleted.
	BatchDeletePipelineJobs(ctx context.Context, in *BatchDeletePipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a PipelineJob.
	// Starts asynchronous cancellation on the PipelineJob. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the PipelineJob is not deleted; instead it becomes a pipeline with
	// a [PipelineJob.error][google.cloud.aiplatform.v1beta1.PipelineJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [PipelineJob.state][google.cloud.aiplatform.v1beta1.PipelineJob.state] is
	// set to `CANCELLED`.
	CancelPipelineJob(ctx context.Context, in *CancelPipelineJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Batch cancel PipelineJobs.
	// Firstly the server will check if all the jobs are in non-terminal states,
	// and skip the jobs that are already terminated.
	// If the operation failed, none of the pipeline jobs are cancelled.
	// The server will poll the states of all the pipeline jobs periodically
	// to check the cancellation status.
	// This operation will return an LRO.
	BatchCancelPipelineJobs(ctx context.Context, in *BatchCancelPipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type pipelineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPipelineServiceClient(cc grpc.ClientConnInterface) PipelineServiceClient {
	return &pipelineServiceClient{cc}
}

func (c *pipelineServiceClient) CreateTrainingPipeline(ctx context.Context, in *CreateTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error) {
	out := new(TrainingPipeline)
	err := c.cc.Invoke(ctx, PipelineService_CreateTrainingPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) GetTrainingPipeline(ctx context.Context, in *GetTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error) {
	out := new(TrainingPipeline)
	err := c.cc.Invoke(ctx, PipelineService_GetTrainingPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) ListTrainingPipelines(ctx context.Context, in *ListTrainingPipelinesRequest, opts ...grpc.CallOption) (*ListTrainingPipelinesResponse, error) {
	out := new(ListTrainingPipelinesResponse)
	err := c.cc.Invoke(ctx, PipelineService_ListTrainingPipelines_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) DeleteTrainingPipeline(ctx context.Context, in *DeleteTrainingPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PipelineService_DeleteTrainingPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CancelTrainingPipeline(ctx context.Context, in *CancelTrainingPipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, PipelineService_CancelTrainingPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CreatePipelineJob(ctx context.Context, in *CreatePipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error) {
	out := new(PipelineJob)
	err := c.cc.Invoke(ctx, PipelineService_CreatePipelineJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) GetPipelineJob(ctx context.Context, in *GetPipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error) {
	out := new(PipelineJob)
	err := c.cc.Invoke(ctx, PipelineService_GetPipelineJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) ListPipelineJobs(ctx context.Context, in *ListPipelineJobsRequest, opts ...grpc.CallOption) (*ListPipelineJobsResponse, error) {
	out := new(ListPipelineJobsResponse)
	err := c.cc.Invoke(ctx, PipelineService_ListPipelineJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) DeletePipelineJob(ctx context.Context, in *DeletePipelineJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PipelineService_DeletePipelineJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) BatchDeletePipelineJobs(ctx context.Context, in *BatchDeletePipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PipelineService_BatchDeletePipelineJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CancelPipelineJob(ctx context.Context, in *CancelPipelineJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, PipelineService_CancelPipelineJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) BatchCancelPipelineJobs(ctx context.Context, in *BatchCancelPipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PipelineService_BatchCancelPipelineJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PipelineServiceServer is the server API for PipelineService service.
// All implementations should embed UnimplementedPipelineServiceServer
// for forward compatibility
type PipelineServiceServer interface {
	// Creates a TrainingPipeline. A created TrainingPipeline right away will be
	// attempted to be run.
	CreateTrainingPipeline(context.Context, *CreateTrainingPipelineRequest) (*TrainingPipeline, error)
	// Gets a TrainingPipeline.
	GetTrainingPipeline(context.Context, *GetTrainingPipelineRequest) (*TrainingPipeline, error)
	// Lists TrainingPipelines in a Location.
	ListTrainingPipelines(context.Context, *ListTrainingPipelinesRequest) (*ListTrainingPipelinesResponse, error)
	// Deletes a TrainingPipeline.
	DeleteTrainingPipeline(context.Context, *DeleteTrainingPipelineRequest) (*longrunningpb.Operation, error)
	// Cancels a TrainingPipeline.
	// Starts asynchronous cancellation on the TrainingPipeline. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the TrainingPipeline is not deleted; instead it becomes a pipeline with
	// a
	// [TrainingPipeline.error][google.cloud.aiplatform.v1beta1.TrainingPipeline.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [TrainingPipeline.state][google.cloud.aiplatform.v1beta1.TrainingPipeline.state]
	// is set to `CANCELLED`.
	CancelTrainingPipeline(context.Context, *CancelTrainingPipelineRequest) (*emptypb.Empty, error)
	// Creates a PipelineJob. A PipelineJob will run immediately when created.
	CreatePipelineJob(context.Context, *CreatePipelineJobRequest) (*PipelineJob, error)
	// Gets a PipelineJob.
	GetPipelineJob(context.Context, *GetPipelineJobRequest) (*PipelineJob, error)
	// Lists PipelineJobs in a Location.
	ListPipelineJobs(context.Context, *ListPipelineJobsRequest) (*ListPipelineJobsResponse, error)
	// Deletes a PipelineJob.
	DeletePipelineJob(context.Context, *DeletePipelineJobRequest) (*longrunningpb.Operation, error)
	// Batch deletes PipelineJobs
	// The Operation is atomic. If it fails, none of the PipelineJobs are deleted.
	// If it succeeds, all of the PipelineJobs are deleted.
	BatchDeletePipelineJobs(context.Context, *BatchDeletePipelineJobsRequest) (*longrunningpb.Operation, error)
	// Cancels a PipelineJob.
	// Starts asynchronous cancellation on the PipelineJob. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the PipelineJob is not deleted; instead it becomes a pipeline with
	// a [PipelineJob.error][google.cloud.aiplatform.v1beta1.PipelineJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [PipelineJob.state][google.cloud.aiplatform.v1beta1.PipelineJob.state] is
	// set to `CANCELLED`.
	CancelPipelineJob(context.Context, *CancelPipelineJobRequest) (*emptypb.Empty, error)
	// Batch cancel PipelineJobs.
	// Firstly the server will check if all the jobs are in non-terminal states,
	// and skip the jobs that are already terminated.
	// If the operation failed, none of the pipeline jobs are cancelled.
	// The server will poll the states of all the pipeline jobs periodically
	// to check the cancellation status.
	// This operation will return an LRO.
	BatchCancelPipelineJobs(context.Context, *BatchCancelPipelineJobsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPipelineServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPipelineServiceServer struct {
}

func (UnimplementedPipelineServiceServer) CreateTrainingPipeline(context.Context, *CreateTrainingPipelineRequest) (*TrainingPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTrainingPipeline not implemented")
}
func (UnimplementedPipelineServiceServer) GetTrainingPipeline(context.Context, *GetTrainingPipelineRequest) (*TrainingPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrainingPipeline not implemented")
}
func (UnimplementedPipelineServiceServer) ListTrainingPipelines(context.Context, *ListTrainingPipelinesRequest) (*ListTrainingPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTrainingPipelines not implemented")
}
func (UnimplementedPipelineServiceServer) DeleteTrainingPipeline(context.Context, *DeleteTrainingPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrainingPipeline not implemented")
}
func (UnimplementedPipelineServiceServer) CancelTrainingPipeline(context.Context, *CancelTrainingPipelineRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTrainingPipeline not implemented")
}
func (UnimplementedPipelineServiceServer) CreatePipelineJob(context.Context, *CreatePipelineJobRequest) (*PipelineJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePipelineJob not implemented")
}
func (UnimplementedPipelineServiceServer) GetPipelineJob(context.Context, *GetPipelineJobRequest) (*PipelineJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipelineJob not implemented")
}
func (UnimplementedPipelineServiceServer) ListPipelineJobs(context.Context, *ListPipelineJobsRequest) (*ListPipelineJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelineJobs not implemented")
}
func (UnimplementedPipelineServiceServer) DeletePipelineJob(context.Context, *DeletePipelineJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePipelineJob not implemented")
}
func (UnimplementedPipelineServiceServer) BatchDeletePipelineJobs(context.Context, *BatchDeletePipelineJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeletePipelineJobs not implemented")
}
func (UnimplementedPipelineServiceServer) CancelPipelineJob(context.Context, *CancelPipelineJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelPipelineJob not implemented")
}
func (UnimplementedPipelineServiceServer) BatchCancelPipelineJobs(context.Context, *BatchCancelPipelineJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCancelPipelineJobs not implemented")
}

// UnsafePipelineServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PipelineServiceServer will
// result in compilation errors.
type UnsafePipelineServiceServer interface {
	mustEmbedUnimplementedPipelineServiceServer()
}

func RegisterPipelineServiceServer(s grpc.ServiceRegistrar, srv PipelineServiceServer) {
	s.RegisterService(&PipelineService_ServiceDesc, srv)
}

func _PipelineService_CreateTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CreateTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_CreateTrainingPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CreateTrainingPipeline(ctx, req.(*CreateTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_GetTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).GetTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_GetTrainingPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).GetTrainingPipeline(ctx, req.(*GetTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_ListTrainingPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTrainingPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).ListTrainingPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_ListTrainingPipelines_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).ListTrainingPipelines(ctx, req.(*ListTrainingPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_DeleteTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).DeleteTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_DeleteTrainingPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).DeleteTrainingPipeline(ctx, req.(*DeleteTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CancelTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CancelTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_CancelTrainingPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CancelTrainingPipeline(ctx, req.(*CancelTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CreatePipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CreatePipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_CreatePipelineJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CreatePipelineJob(ctx, req.(*CreatePipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_GetPipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).GetPipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_GetPipelineJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).GetPipelineJob(ctx, req.(*GetPipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_ListPipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).ListPipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_ListPipelineJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).ListPipelineJobs(ctx, req.(*ListPipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_DeletePipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).DeletePipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_DeletePipelineJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).DeletePipelineJob(ctx, req.(*DeletePipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_BatchDeletePipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeletePipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).BatchDeletePipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_BatchDeletePipelineJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).BatchDeletePipelineJobs(ctx, req.(*BatchDeletePipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CancelPipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelPipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CancelPipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_CancelPipelineJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CancelPipelineJob(ctx, req.(*CancelPipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_BatchCancelPipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCancelPipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).BatchCancelPipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PipelineService_BatchCancelPipelineJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).BatchCancelPipelineJobs(ctx, req.(*BatchCancelPipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PipelineService_ServiceDesc is the grpc.ServiceDesc for PipelineService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PipelineService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.PipelineService",
	HandlerType: (*PipelineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTrainingPipeline",
			Handler:    _PipelineService_CreateTrainingPipeline_Handler,
		},
		{
			MethodName: "GetTrainingPipeline",
			Handler:    _PipelineService_GetTrainingPipeline_Handler,
		},
		{
			MethodName: "ListTrainingPipelines",
			Handler:    _PipelineService_ListTrainingPipelines_Handler,
		},
		{
			MethodName: "DeleteTrainingPipeline",
			Handler:    _PipelineService_DeleteTrainingPipeline_Handler,
		},
		{
			MethodName: "CancelTrainingPipeline",
			Handler:    _PipelineService_CancelTrainingPipeline_Handler,
		},
		{
			MethodName: "CreatePipelineJob",
			Handler:    _PipelineService_CreatePipelineJob_Handler,
		},
		{
			MethodName: "GetPipelineJob",
			Handler:    _PipelineService_GetPipelineJob_Handler,
		},
		{
			MethodName: "ListPipelineJobs",
			Handler:    _PipelineService_ListPipelineJobs_Handler,
		},
		{
			MethodName: "DeletePipelineJob",
			Handler:    _PipelineService_DeletePipelineJob_Handler,
		},
		{
			MethodName: "BatchDeletePipelineJobs",
			Handler:    _PipelineService_BatchDeletePipelineJobs_Handler,
		},
		{
			MethodName: "CancelPipelineJob",
			Handler:    _PipelineService_CancelPipelineJob_Handler,
		},
		{
			MethodName: "BatchCancelPipelineJobs",
			Handler:    _PipelineService_BatchCancelPipelineJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/pipeline_service.proto",
}
