// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/tensorboard_service.proto

package aiplatformpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TensorboardService_CreateTensorboard_FullMethodName                  = "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboard"
	TensorboardService_GetTensorboard_FullMethodName                     = "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboard"
	TensorboardService_UpdateTensorboard_FullMethodName                  = "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboard"
	TensorboardService_ListTensorboards_FullMethodName                   = "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboards"
	TensorboardService_DeleteTensorboard_FullMethodName                  = "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboard"
	TensorboardService_ReadTensorboardUsage_FullMethodName               = "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardUsage"
	TensorboardService_ReadTensorboardSize_FullMethodName                = "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardSize"
	TensorboardService_CreateTensorboardExperiment_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardExperiment"
	TensorboardService_GetTensorboardExperiment_FullMethodName           = "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardExperiment"
	TensorboardService_UpdateTensorboardExperiment_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardExperiment"
	TensorboardService_ListTensorboardExperiments_FullMethodName         = "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardExperiments"
	TensorboardService_DeleteTensorboardExperiment_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardExperiment"
	TensorboardService_CreateTensorboardRun_FullMethodName               = "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardRun"
	TensorboardService_BatchCreateTensorboardRuns_FullMethodName         = "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardRuns"
	TensorboardService_GetTensorboardRun_FullMethodName                  = "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardRun"
	TensorboardService_UpdateTensorboardRun_FullMethodName               = "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardRun"
	TensorboardService_ListTensorboardRuns_FullMethodName                = "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardRuns"
	TensorboardService_DeleteTensorboardRun_FullMethodName               = "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardRun"
	TensorboardService_BatchCreateTensorboardTimeSeries_FullMethodName   = "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardTimeSeries"
	TensorboardService_CreateTensorboardTimeSeries_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardTimeSeries"
	TensorboardService_GetTensorboardTimeSeries_FullMethodName           = "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardTimeSeries"
	TensorboardService_UpdateTensorboardTimeSeries_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardTimeSeries"
	TensorboardService_ListTensorboardTimeSeries_FullMethodName          = "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardTimeSeries"
	TensorboardService_DeleteTensorboardTimeSeries_FullMethodName        = "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardTimeSeries"
	TensorboardService_BatchReadTensorboardTimeSeriesData_FullMethodName = "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchReadTensorboardTimeSeriesData"
	TensorboardService_ReadTensorboardTimeSeriesData_FullMethodName      = "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardTimeSeriesData"
	TensorboardService_ReadTensorboardBlobData_FullMethodName            = "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardBlobData"
	TensorboardService_WriteTensorboardExperimentData_FullMethodName     = "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardExperimentData"
	TensorboardService_WriteTensorboardRunData_FullMethodName            = "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardRunData"
	TensorboardService_ExportTensorboardTimeSeriesData_FullMethodName    = "/google.cloud.aiplatform.v1beta1.TensorboardService/ExportTensorboardTimeSeriesData"
)

// TensorboardServiceClient is the client API for TensorboardService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TensorboardServiceClient interface {
	// Creates a Tensorboard.
	CreateTensorboard(ctx context.Context, in *CreateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Tensorboard.
	GetTensorboard(ctx context.Context, in *GetTensorboardRequest, opts ...grpc.CallOption) (*Tensorboard, error)
	// Updates a Tensorboard.
	UpdateTensorboard(ctx context.Context, in *UpdateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Tensorboards in a Location.
	ListTensorboards(ctx context.Context, in *ListTensorboardsRequest, opts ...grpc.CallOption) (*ListTensorboardsResponse, error)
	// Deletes a Tensorboard.
	DeleteTensorboard(ctx context.Context, in *DeleteTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a list of monthly active users for a given TensorBoard instance.
	ReadTensorboardUsage(ctx context.Context, in *ReadTensorboardUsageRequest, opts ...grpc.CallOption) (*ReadTensorboardUsageResponse, error)
	// Returns the storage size for a given TensorBoard instance.
	ReadTensorboardSize(ctx context.Context, in *ReadTensorboardSizeRequest, opts ...grpc.CallOption) (*ReadTensorboardSizeResponse, error)
	// Creates a TensorboardExperiment.
	CreateTensorboardExperiment(ctx context.Context, in *CreateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Gets a TensorboardExperiment.
	GetTensorboardExperiment(ctx context.Context, in *GetTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Updates a TensorboardExperiment.
	UpdateTensorboardExperiment(ctx context.Context, in *UpdateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Lists TensorboardExperiments in a Location.
	ListTensorboardExperiments(ctx context.Context, in *ListTensorboardExperimentsRequest, opts ...grpc.CallOption) (*ListTensorboardExperimentsResponse, error)
	// Deletes a TensorboardExperiment.
	DeleteTensorboardExperiment(ctx context.Context, in *DeleteTensorboardExperimentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a TensorboardRun.
	CreateTensorboardRun(ctx context.Context, in *CreateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Batch create TensorboardRuns.
	BatchCreateTensorboardRuns(ctx context.Context, in *BatchCreateTensorboardRunsRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardRunsResponse, error)
	// Gets a TensorboardRun.
	GetTensorboardRun(ctx context.Context, in *GetTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Updates a TensorboardRun.
	UpdateTensorboardRun(ctx context.Context, in *UpdateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Lists TensorboardRuns in a Location.
	ListTensorboardRuns(ctx context.Context, in *ListTensorboardRunsRequest, opts ...grpc.CallOption) (*ListTensorboardRunsResponse, error)
	// Deletes a TensorboardRun.
	DeleteTensorboardRun(ctx context.Context, in *DeleteTensorboardRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
	BatchCreateTensorboardTimeSeries(ctx context.Context, in *BatchCreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardTimeSeriesResponse, error)
	// Creates a TensorboardTimeSeries.
	CreateTensorboardTimeSeries(ctx context.Context, in *CreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Gets a TensorboardTimeSeries.
	GetTensorboardTimeSeries(ctx context.Context, in *GetTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Updates a TensorboardTimeSeries.
	UpdateTensorboardTimeSeries(ctx context.Context, in *UpdateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Lists TensorboardTimeSeries in a Location.
	ListTensorboardTimeSeries(ctx context.Context, in *ListTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*ListTensorboardTimeSeriesResponse, error)
	// Deletes a TensorboardTimeSeries.
	DeleteTensorboardTimeSeries(ctx context.Context, in *DeleteTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reads multiple TensorboardTimeSeries' data. The data point number limit is
	// 1000 for scalars, 100 for tensors and blob references. If the number of
	// data points stored is less than the limit, all data is returned.
	// Otherwise, the number limit of data points is randomly selected from
	// this time series and returned.
	BatchReadTensorboardTimeSeriesData(ctx context.Context, in *BatchReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*BatchReadTensorboardTimeSeriesDataResponse, error)
	// Reads a TensorboardTimeSeries' data. By default, if the number of data
	// points stored is less than 1000, all data is returned. Otherwise, 1000
	// data points is randomly selected from this time series and returned.
	// This value can be changed by changing max_data_points, which can't be
	// greater than 10k.
	ReadTensorboardTimeSeriesData(ctx context.Context, in *ReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ReadTensorboardTimeSeriesDataResponse, error)
	// Gets bytes of TensorboardBlobs.
	// This is to allow reading blob data stored in consumer project's Cloud
	// Storage bucket without users having to obtain Cloud Storage access
	// permission.
	ReadTensorboardBlobData(ctx context.Context, in *ReadTensorboardBlobDataRequest, opts ...grpc.CallOption) (TensorboardService_ReadTensorboardBlobDataClient, error)
	// Write time series data points of multiple TensorboardTimeSeries in multiple
	// TensorboardRun's. If any data fail to be ingested, an error is returned.
	WriteTensorboardExperimentData(ctx context.Context, in *WriteTensorboardExperimentDataRequest, opts ...grpc.CallOption) (*WriteTensorboardExperimentDataResponse, error)
	// Write time series data points into multiple TensorboardTimeSeries under
	// a TensorboardRun. If any data fail to be ingested, an error is returned.
	WriteTensorboardRunData(ctx context.Context, in *WriteTensorboardRunDataRequest, opts ...grpc.CallOption) (*WriteTensorboardRunDataResponse, error)
	// Exports a TensorboardTimeSeries' data. Data is returned in paginated
	// responses.
	ExportTensorboardTimeSeriesData(ctx context.Context, in *ExportTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ExportTensorboardTimeSeriesDataResponse, error)
}

type tensorboardServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTensorboardServiceClient(cc grpc.ClientConnInterface) TensorboardServiceClient {
	return &tensorboardServiceClient{cc}
}

func (c *tensorboardServiceClient) CreateTensorboard(ctx context.Context, in *CreateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_CreateTensorboard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboard(ctx context.Context, in *GetTensorboardRequest, opts ...grpc.CallOption) (*Tensorboard, error) {
	out := new(Tensorboard)
	err := c.cc.Invoke(ctx, TensorboardService_GetTensorboard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboard(ctx context.Context, in *UpdateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_UpdateTensorboard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboards(ctx context.Context, in *ListTensorboardsRequest, opts ...grpc.CallOption) (*ListTensorboardsResponse, error) {
	out := new(ListTensorboardsResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ListTensorboards_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboard(ctx context.Context, in *DeleteTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_DeleteTensorboard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardUsage(ctx context.Context, in *ReadTensorboardUsageRequest, opts ...grpc.CallOption) (*ReadTensorboardUsageResponse, error) {
	out := new(ReadTensorboardUsageResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ReadTensorboardUsage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardSize(ctx context.Context, in *ReadTensorboardSizeRequest, opts ...grpc.CallOption) (*ReadTensorboardSizeResponse, error) {
	out := new(ReadTensorboardSizeResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ReadTensorboardSize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardExperiment(ctx context.Context, in *CreateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, TensorboardService_CreateTensorboardExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardExperiment(ctx context.Context, in *GetTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, TensorboardService_GetTensorboardExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardExperiment(ctx context.Context, in *UpdateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, TensorboardService_UpdateTensorboardExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardExperiments(ctx context.Context, in *ListTensorboardExperimentsRequest, opts ...grpc.CallOption) (*ListTensorboardExperimentsResponse, error) {
	out := new(ListTensorboardExperimentsResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ListTensorboardExperiments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardExperiment(ctx context.Context, in *DeleteTensorboardExperimentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_DeleteTensorboardExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardRun(ctx context.Context, in *CreateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, TensorboardService_CreateTensorboardRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchCreateTensorboardRuns(ctx context.Context, in *BatchCreateTensorboardRunsRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardRunsResponse, error) {
	out := new(BatchCreateTensorboardRunsResponse)
	err := c.cc.Invoke(ctx, TensorboardService_BatchCreateTensorboardRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardRun(ctx context.Context, in *GetTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, TensorboardService_GetTensorboardRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardRun(ctx context.Context, in *UpdateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, TensorboardService_UpdateTensorboardRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardRuns(ctx context.Context, in *ListTensorboardRunsRequest, opts ...grpc.CallOption) (*ListTensorboardRunsResponse, error) {
	out := new(ListTensorboardRunsResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ListTensorboardRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardRun(ctx context.Context, in *DeleteTensorboardRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_DeleteTensorboardRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchCreateTensorboardTimeSeries(ctx context.Context, in *BatchCreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardTimeSeriesResponse, error) {
	out := new(BatchCreateTensorboardTimeSeriesResponse)
	err := c.cc.Invoke(ctx, TensorboardService_BatchCreateTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardTimeSeries(ctx context.Context, in *CreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, TensorboardService_CreateTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardTimeSeries(ctx context.Context, in *GetTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, TensorboardService_GetTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardTimeSeries(ctx context.Context, in *UpdateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, TensorboardService_UpdateTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardTimeSeries(ctx context.Context, in *ListTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*ListTensorboardTimeSeriesResponse, error) {
	out := new(ListTensorboardTimeSeriesResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ListTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardTimeSeries(ctx context.Context, in *DeleteTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TensorboardService_DeleteTensorboardTimeSeries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchReadTensorboardTimeSeriesData(ctx context.Context, in *BatchReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*BatchReadTensorboardTimeSeriesDataResponse, error) {
	out := new(BatchReadTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, TensorboardService_BatchReadTensorboardTimeSeriesData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardTimeSeriesData(ctx context.Context, in *ReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ReadTensorboardTimeSeriesDataResponse, error) {
	out := new(ReadTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ReadTensorboardTimeSeriesData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardBlobData(ctx context.Context, in *ReadTensorboardBlobDataRequest, opts ...grpc.CallOption) (TensorboardService_ReadTensorboardBlobDataClient, error) {
	stream, err := c.cc.NewStream(ctx, &TensorboardService_ServiceDesc.Streams[0], TensorboardService_ReadTensorboardBlobData_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &tensorboardServiceReadTensorboardBlobDataClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TensorboardService_ReadTensorboardBlobDataClient interface {
	Recv() (*ReadTensorboardBlobDataResponse, error)
	grpc.ClientStream
}

type tensorboardServiceReadTensorboardBlobDataClient struct {
	grpc.ClientStream
}

func (x *tensorboardServiceReadTensorboardBlobDataClient) Recv() (*ReadTensorboardBlobDataResponse, error) {
	m := new(ReadTensorboardBlobDataResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tensorboardServiceClient) WriteTensorboardExperimentData(ctx context.Context, in *WriteTensorboardExperimentDataRequest, opts ...grpc.CallOption) (*WriteTensorboardExperimentDataResponse, error) {
	out := new(WriteTensorboardExperimentDataResponse)
	err := c.cc.Invoke(ctx, TensorboardService_WriteTensorboardExperimentData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) WriteTensorboardRunData(ctx context.Context, in *WriteTensorboardRunDataRequest, opts ...grpc.CallOption) (*WriteTensorboardRunDataResponse, error) {
	out := new(WriteTensorboardRunDataResponse)
	err := c.cc.Invoke(ctx, TensorboardService_WriteTensorboardRunData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ExportTensorboardTimeSeriesData(ctx context.Context, in *ExportTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ExportTensorboardTimeSeriesDataResponse, error) {
	out := new(ExportTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, TensorboardService_ExportTensorboardTimeSeriesData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TensorboardServiceServer is the server API for TensorboardService service.
// All implementations should embed UnimplementedTensorboardServiceServer
// for forward compatibility
type TensorboardServiceServer interface {
	// Creates a Tensorboard.
	CreateTensorboard(context.Context, *CreateTensorboardRequest) (*longrunningpb.Operation, error)
	// Gets a Tensorboard.
	GetTensorboard(context.Context, *GetTensorboardRequest) (*Tensorboard, error)
	// Updates a Tensorboard.
	UpdateTensorboard(context.Context, *UpdateTensorboardRequest) (*longrunningpb.Operation, error)
	// Lists Tensorboards in a Location.
	ListTensorboards(context.Context, *ListTensorboardsRequest) (*ListTensorboardsResponse, error)
	// Deletes a Tensorboard.
	DeleteTensorboard(context.Context, *DeleteTensorboardRequest) (*longrunningpb.Operation, error)
	// Returns a list of monthly active users for a given TensorBoard instance.
	ReadTensorboardUsage(context.Context, *ReadTensorboardUsageRequest) (*ReadTensorboardUsageResponse, error)
	// Returns the storage size for a given TensorBoard instance.
	ReadTensorboardSize(context.Context, *ReadTensorboardSizeRequest) (*ReadTensorboardSizeResponse, error)
	// Creates a TensorboardExperiment.
	CreateTensorboardExperiment(context.Context, *CreateTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Gets a TensorboardExperiment.
	GetTensorboardExperiment(context.Context, *GetTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Updates a TensorboardExperiment.
	UpdateTensorboardExperiment(context.Context, *UpdateTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Lists TensorboardExperiments in a Location.
	ListTensorboardExperiments(context.Context, *ListTensorboardExperimentsRequest) (*ListTensorboardExperimentsResponse, error)
	// Deletes a TensorboardExperiment.
	DeleteTensorboardExperiment(context.Context, *DeleteTensorboardExperimentRequest) (*longrunningpb.Operation, error)
	// Creates a TensorboardRun.
	CreateTensorboardRun(context.Context, *CreateTensorboardRunRequest) (*TensorboardRun, error)
	// Batch create TensorboardRuns.
	BatchCreateTensorboardRuns(context.Context, *BatchCreateTensorboardRunsRequest) (*BatchCreateTensorboardRunsResponse, error)
	// Gets a TensorboardRun.
	GetTensorboardRun(context.Context, *GetTensorboardRunRequest) (*TensorboardRun, error)
	// Updates a TensorboardRun.
	UpdateTensorboardRun(context.Context, *UpdateTensorboardRunRequest) (*TensorboardRun, error)
	// Lists TensorboardRuns in a Location.
	ListTensorboardRuns(context.Context, *ListTensorboardRunsRequest) (*ListTensorboardRunsResponse, error)
	// Deletes a TensorboardRun.
	DeleteTensorboardRun(context.Context, *DeleteTensorboardRunRequest) (*longrunningpb.Operation, error)
	// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
	BatchCreateTensorboardTimeSeries(context.Context, *BatchCreateTensorboardTimeSeriesRequest) (*BatchCreateTensorboardTimeSeriesResponse, error)
	// Creates a TensorboardTimeSeries.
	CreateTensorboardTimeSeries(context.Context, *CreateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Gets a TensorboardTimeSeries.
	GetTensorboardTimeSeries(context.Context, *GetTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Updates a TensorboardTimeSeries.
	UpdateTensorboardTimeSeries(context.Context, *UpdateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Lists TensorboardTimeSeries in a Location.
	ListTensorboardTimeSeries(context.Context, *ListTensorboardTimeSeriesRequest) (*ListTensorboardTimeSeriesResponse, error)
	// Deletes a TensorboardTimeSeries.
	DeleteTensorboardTimeSeries(context.Context, *DeleteTensorboardTimeSeriesRequest) (*longrunningpb.Operation, error)
	// Reads multiple TensorboardTimeSeries' data. The data point number limit is
	// 1000 for scalars, 100 for tensors and blob references. If the number of
	// data points stored is less than the limit, all data is returned.
	// Otherwise, the number limit of data points is randomly selected from
	// this time series and returned.
	BatchReadTensorboardTimeSeriesData(context.Context, *BatchReadTensorboardTimeSeriesDataRequest) (*BatchReadTensorboardTimeSeriesDataResponse, error)
	// Reads a TensorboardTimeSeries' data. By default, if the number of data
	// points stored is less than 1000, all data is returned. Otherwise, 1000
	// data points is randomly selected from this time series and returned.
	// This value can be changed by changing max_data_points, which can't be
	// greater than 10k.
	ReadTensorboardTimeSeriesData(context.Context, *ReadTensorboardTimeSeriesDataRequest) (*ReadTensorboardTimeSeriesDataResponse, error)
	// Gets bytes of TensorboardBlobs.
	// This is to allow reading blob data stored in consumer project's Cloud
	// Storage bucket without users having to obtain Cloud Storage access
	// permission.
	ReadTensorboardBlobData(*ReadTensorboardBlobDataRequest, TensorboardService_ReadTensorboardBlobDataServer) error
	// Write time series data points of multiple TensorboardTimeSeries in multiple
	// TensorboardRun's. If any data fail to be ingested, an error is returned.
	WriteTensorboardExperimentData(context.Context, *WriteTensorboardExperimentDataRequest) (*WriteTensorboardExperimentDataResponse, error)
	// Write time series data points into multiple TensorboardTimeSeries under
	// a TensorboardRun. If any data fail to be ingested, an error is returned.
	WriteTensorboardRunData(context.Context, *WriteTensorboardRunDataRequest) (*WriteTensorboardRunDataResponse, error)
	// Exports a TensorboardTimeSeries' data. Data is returned in paginated
	// responses.
	ExportTensorboardTimeSeriesData(context.Context, *ExportTensorboardTimeSeriesDataRequest) (*ExportTensorboardTimeSeriesDataResponse, error)
}

// UnimplementedTensorboardServiceServer should be embedded to have forward compatible implementations.
type UnimplementedTensorboardServiceServer struct {
}

func (UnimplementedTensorboardServiceServer) CreateTensorboard(context.Context, *CreateTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboard not implemented")
}
func (UnimplementedTensorboardServiceServer) GetTensorboard(context.Context, *GetTensorboardRequest) (*Tensorboard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboard not implemented")
}
func (UnimplementedTensorboardServiceServer) UpdateTensorboard(context.Context, *UpdateTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboard not implemented")
}
func (UnimplementedTensorboardServiceServer) ListTensorboards(context.Context, *ListTensorboardsRequest) (*ListTensorboardsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboards not implemented")
}
func (UnimplementedTensorboardServiceServer) DeleteTensorboard(context.Context, *DeleteTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboard not implemented")
}
func (UnimplementedTensorboardServiceServer) ReadTensorboardUsage(context.Context, *ReadTensorboardUsageRequest) (*ReadTensorboardUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadTensorboardUsage not implemented")
}
func (UnimplementedTensorboardServiceServer) ReadTensorboardSize(context.Context, *ReadTensorboardSizeRequest) (*ReadTensorboardSizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadTensorboardSize not implemented")
}
func (UnimplementedTensorboardServiceServer) CreateTensorboardExperiment(context.Context, *CreateTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardExperiment not implemented")
}
func (UnimplementedTensorboardServiceServer) GetTensorboardExperiment(context.Context, *GetTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardExperiment not implemented")
}
func (UnimplementedTensorboardServiceServer) UpdateTensorboardExperiment(context.Context, *UpdateTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardExperiment not implemented")
}
func (UnimplementedTensorboardServiceServer) ListTensorboardExperiments(context.Context, *ListTensorboardExperimentsRequest) (*ListTensorboardExperimentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardExperiments not implemented")
}
func (UnimplementedTensorboardServiceServer) DeleteTensorboardExperiment(context.Context, *DeleteTensorboardExperimentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardExperiment not implemented")
}
func (UnimplementedTensorboardServiceServer) CreateTensorboardRun(context.Context, *CreateTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardRun not implemented")
}
func (UnimplementedTensorboardServiceServer) BatchCreateTensorboardRuns(context.Context, *BatchCreateTensorboardRunsRequest) (*BatchCreateTensorboardRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTensorboardRuns not implemented")
}
func (UnimplementedTensorboardServiceServer) GetTensorboardRun(context.Context, *GetTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardRun not implemented")
}
func (UnimplementedTensorboardServiceServer) UpdateTensorboardRun(context.Context, *UpdateTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardRun not implemented")
}
func (UnimplementedTensorboardServiceServer) ListTensorboardRuns(context.Context, *ListTensorboardRunsRequest) (*ListTensorboardRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardRuns not implemented")
}
func (UnimplementedTensorboardServiceServer) DeleteTensorboardRun(context.Context, *DeleteTensorboardRunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardRun not implemented")
}
func (UnimplementedTensorboardServiceServer) BatchCreateTensorboardTimeSeries(context.Context, *BatchCreateTensorboardTimeSeriesRequest) (*BatchCreateTensorboardTimeSeriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) CreateTensorboardTimeSeries(context.Context, *CreateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) GetTensorboardTimeSeries(context.Context, *GetTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) UpdateTensorboardTimeSeries(context.Context, *UpdateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) ListTensorboardTimeSeries(context.Context, *ListTensorboardTimeSeriesRequest) (*ListTensorboardTimeSeriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) DeleteTensorboardTimeSeries(context.Context, *DeleteTensorboardTimeSeriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardTimeSeries not implemented")
}
func (UnimplementedTensorboardServiceServer) BatchReadTensorboardTimeSeriesData(context.Context, *BatchReadTensorboardTimeSeriesDataRequest) (*BatchReadTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchReadTensorboardTimeSeriesData not implemented")
}
func (UnimplementedTensorboardServiceServer) ReadTensorboardTimeSeriesData(context.Context, *ReadTensorboardTimeSeriesDataRequest) (*ReadTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadTensorboardTimeSeriesData not implemented")
}
func (UnimplementedTensorboardServiceServer) ReadTensorboardBlobData(*ReadTensorboardBlobDataRequest, TensorboardService_ReadTensorboardBlobDataServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadTensorboardBlobData not implemented")
}
func (UnimplementedTensorboardServiceServer) WriteTensorboardExperimentData(context.Context, *WriteTensorboardExperimentDataRequest) (*WriteTensorboardExperimentDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteTensorboardExperimentData not implemented")
}
func (UnimplementedTensorboardServiceServer) WriteTensorboardRunData(context.Context, *WriteTensorboardRunDataRequest) (*WriteTensorboardRunDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteTensorboardRunData not implemented")
}
func (UnimplementedTensorboardServiceServer) ExportTensorboardTimeSeriesData(context.Context, *ExportTensorboardTimeSeriesDataRequest) (*ExportTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTensorboardTimeSeriesData not implemented")
}

// UnsafeTensorboardServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TensorboardServiceServer will
// result in compilation errors.
type UnsafeTensorboardServiceServer interface {
	mustEmbedUnimplementedTensorboardServiceServer()
}

func RegisterTensorboardServiceServer(s grpc.ServiceRegistrar, srv TensorboardServiceServer) {
	s.RegisterService(&TensorboardService_ServiceDesc, srv)
}

func _TensorboardService_CreateTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_CreateTensorboard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboard(ctx, req.(*CreateTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_GetTensorboard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboard(ctx, req.(*GetTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_UpdateTensorboard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboard(ctx, req.(*UpdateTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ListTensorboards_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboards(ctx, req.(*ListTensorboardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_DeleteTensorboard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboard(ctx, req.(*DeleteTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadTensorboardUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ReadTensorboardUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ReadTensorboardUsage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ReadTensorboardUsage(ctx, req.(*ReadTensorboardUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadTensorboardSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ReadTensorboardSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ReadTensorboardSize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ReadTensorboardSize(ctx, req.(*ReadTensorboardSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_CreateTensorboardExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardExperiment(ctx, req.(*CreateTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_GetTensorboardExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardExperiment(ctx, req.(*GetTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_UpdateTensorboardExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardExperiment(ctx, req.(*UpdateTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardExperiments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardExperimentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardExperiments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ListTensorboardExperiments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardExperiments(ctx, req.(*ListTensorboardExperimentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_DeleteTensorboardExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardExperiment(ctx, req.(*DeleteTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_CreateTensorboardRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardRun(ctx, req.(*CreateTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchCreateTensorboardRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTensorboardRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_BatchCreateTensorboardRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardRuns(ctx, req.(*BatchCreateTensorboardRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_GetTensorboardRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardRun(ctx, req.(*GetTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_UpdateTensorboardRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardRun(ctx, req.(*UpdateTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ListTensorboardRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardRuns(ctx, req.(*ListTensorboardRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_DeleteTensorboardRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardRun(ctx, req.(*DeleteTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchCreateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_BatchCreateTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardTimeSeries(ctx, req.(*BatchCreateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_CreateTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardTimeSeries(ctx, req.(*CreateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_GetTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardTimeSeries(ctx, req.(*GetTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_UpdateTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardTimeSeries(ctx, req.(*UpdateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ListTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardTimeSeries(ctx, req.(*ListTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_DeleteTensorboardTimeSeries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardTimeSeries(ctx, req.(*DeleteTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchReadTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchReadTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_BatchReadTensorboardTimeSeriesData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchReadTensorboardTimeSeriesData(ctx, req.(*BatchReadTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ReadTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ReadTensorboardTimeSeriesData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ReadTensorboardTimeSeriesData(ctx, req.(*ReadTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardBlobData_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadTensorboardBlobDataRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TensorboardServiceServer).ReadTensorboardBlobData(m, &tensorboardServiceReadTensorboardBlobDataServer{stream})
}

type TensorboardService_ReadTensorboardBlobDataServer interface {
	Send(*ReadTensorboardBlobDataResponse) error
	grpc.ServerStream
}

type tensorboardServiceReadTensorboardBlobDataServer struct {
	grpc.ServerStream
}

func (x *tensorboardServiceReadTensorboardBlobDataServer) Send(m *ReadTensorboardBlobDataResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _TensorboardService_WriteTensorboardExperimentData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteTensorboardExperimentDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).WriteTensorboardExperimentData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_WriteTensorboardExperimentData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).WriteTensorboardExperimentData(ctx, req.(*WriteTensorboardExperimentDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_WriteTensorboardRunData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteTensorboardRunDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).WriteTensorboardRunData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_WriteTensorboardRunData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).WriteTensorboardRunData(ctx, req.(*WriteTensorboardRunDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ExportTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ExportTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TensorboardService_ExportTensorboardTimeSeriesData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ExportTensorboardTimeSeriesData(ctx, req.(*ExportTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TensorboardService_ServiceDesc is the grpc.ServiceDesc for TensorboardService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TensorboardService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.TensorboardService",
	HandlerType: (*TensorboardServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTensorboard",
			Handler:    _TensorboardService_CreateTensorboard_Handler,
		},
		{
			MethodName: "GetTensorboard",
			Handler:    _TensorboardService_GetTensorboard_Handler,
		},
		{
			MethodName: "UpdateTensorboard",
			Handler:    _TensorboardService_UpdateTensorboard_Handler,
		},
		{
			MethodName: "ListTensorboards",
			Handler:    _TensorboardService_ListTensorboards_Handler,
		},
		{
			MethodName: "DeleteTensorboard",
			Handler:    _TensorboardService_DeleteTensorboard_Handler,
		},
		{
			MethodName: "ReadTensorboardUsage",
			Handler:    _TensorboardService_ReadTensorboardUsage_Handler,
		},
		{
			MethodName: "ReadTensorboardSize",
			Handler:    _TensorboardService_ReadTensorboardSize_Handler,
		},
		{
			MethodName: "CreateTensorboardExperiment",
			Handler:    _TensorboardService_CreateTensorboardExperiment_Handler,
		},
		{
			MethodName: "GetTensorboardExperiment",
			Handler:    _TensorboardService_GetTensorboardExperiment_Handler,
		},
		{
			MethodName: "UpdateTensorboardExperiment",
			Handler:    _TensorboardService_UpdateTensorboardExperiment_Handler,
		},
		{
			MethodName: "ListTensorboardExperiments",
			Handler:    _TensorboardService_ListTensorboardExperiments_Handler,
		},
		{
			MethodName: "DeleteTensorboardExperiment",
			Handler:    _TensorboardService_DeleteTensorboardExperiment_Handler,
		},
		{
			MethodName: "CreateTensorboardRun",
			Handler:    _TensorboardService_CreateTensorboardRun_Handler,
		},
		{
			MethodName: "BatchCreateTensorboardRuns",
			Handler:    _TensorboardService_BatchCreateTensorboardRuns_Handler,
		},
		{
			MethodName: "GetTensorboardRun",
			Handler:    _TensorboardService_GetTensorboardRun_Handler,
		},
		{
			MethodName: "UpdateTensorboardRun",
			Handler:    _TensorboardService_UpdateTensorboardRun_Handler,
		},
		{
			MethodName: "ListTensorboardRuns",
			Handler:    _TensorboardService_ListTensorboardRuns_Handler,
		},
		{
			MethodName: "DeleteTensorboardRun",
			Handler:    _TensorboardService_DeleteTensorboardRun_Handler,
		},
		{
			MethodName: "BatchCreateTensorboardTimeSeries",
			Handler:    _TensorboardService_BatchCreateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "CreateTensorboardTimeSeries",
			Handler:    _TensorboardService_CreateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "GetTensorboardTimeSeries",
			Handler:    _TensorboardService_GetTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "UpdateTensorboardTimeSeries",
			Handler:    _TensorboardService_UpdateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "ListTensorboardTimeSeries",
			Handler:    _TensorboardService_ListTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "DeleteTensorboardTimeSeries",
			Handler:    _TensorboardService_DeleteTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "BatchReadTensorboardTimeSeriesData",
			Handler:    _TensorboardService_BatchReadTensorboardTimeSeriesData_Handler,
		},
		{
			MethodName: "ReadTensorboardTimeSeriesData",
			Handler:    _TensorboardService_ReadTensorboardTimeSeriesData_Handler,
		},
		{
			MethodName: "WriteTensorboardExperimentData",
			Handler:    _TensorboardService_WriteTensorboardExperimentData_Handler,
		},
		{
			MethodName: "WriteTensorboardRunData",
			Handler:    _TensorboardService_WriteTensorboardRunData_Handler,
		},
		{
			MethodName: "ExportTensorboardTimeSeriesData",
			Handler:    _TensorboardService_ExportTensorboardTimeSeriesData_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadTensorboardBlobData",
			Handler:       _TensorboardService_ReadTensorboardBlobData_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1beta1/tensorboard_service.proto",
}
