/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpointElasticsearch type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpointElasticsearch{}

// EndpointElasticsearch struct for EndpointElasticsearch
type EndpointElasticsearch struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	Url *string `json:"url,omitempty"`
	ApiKey interface{} `json:"api_key,omitempty"`
}

// NewEndpointElasticsearch instantiates a new EndpointElasticsearch object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpointElasticsearch() *EndpointElasticsearch {
	this := EndpointElasticsearch{}
	return &this
}

// NewEndpointElasticsearchWithDefaults instantiates a new EndpointElasticsearch object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpointElasticsearchWithDefaults() *EndpointElasticsearch {
	this := EndpointElasticsearch{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpointElasticsearch) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointElasticsearch) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpointElasticsearch) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpointElasticsearch) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *EndpointElasticsearch) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointElasticsearch) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *EndpointElasticsearch) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *EndpointElasticsearch) SetUrl(v string) {
	o.Url = &v
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *EndpointElasticsearch) GetApiKey() interface{} {
	if o == nil {
		var ret interface{}
		return ret
	}
	return o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *EndpointElasticsearch) GetApiKeyOk() (*interface{}, bool) {
	if o == nil || IsNil(o.ApiKey) {
		return nil, false
	}
	return &o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *EndpointElasticsearch) HasApiKey() bool {
	if o != nil && IsNil(o.ApiKey) {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given interface{} and assigns it to the ApiKey field.
func (o *EndpointElasticsearch) SetApiKey(v interface{}) {
	o.ApiKey = v
}

func (o EndpointElasticsearch) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpointElasticsearch) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if o.ApiKey != nil {
		toSerialize["api_key"] = o.ApiKey
	}
	return toSerialize, nil
}

type NullableEndpointElasticsearch struct {
	value *EndpointElasticsearch
	isSet bool
}

func (v NullableEndpointElasticsearch) Get() *EndpointElasticsearch {
	return v.value
}

func (v *NullableEndpointElasticsearch) Set(val *EndpointElasticsearch) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpointElasticsearch) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpointElasticsearch) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpointElasticsearch(val *EndpointElasticsearch) *NullableEndpointElasticsearch {
	return &NullableEndpointElasticsearch{value: val, isSet: true}
}

func (v NullableEndpointElasticsearch) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpointElasticsearch) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


