/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpointAzureMonitor type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpointAzureMonitor{}

// EndpointAzureMonitor struct for EndpointAzureMonitor
type EndpointAzureMonitor struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	LogType *string `json:"log_type,omitempty"`
	SharedKey *string `json:"shared_key,omitempty"`
	TimeGeneratedField *string `json:"time_generated_field,omitempty"`
	WorkspaceId *string `json:"workspace_id,omitempty"`
}

// NewEndpointAzureMonitor instantiates a new EndpointAzureMonitor object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpointAzureMonitor() *EndpointAzureMonitor {
	this := EndpointAzureMonitor{}
	return &this
}

// NewEndpointAzureMonitorWithDefaults instantiates a new EndpointAzureMonitor object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpointAzureMonitorWithDefaults() *EndpointAzureMonitor {
	this := EndpointAzureMonitor{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpointAzureMonitor) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureMonitor) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpointAzureMonitor) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpointAzureMonitor) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetLogType returns the LogType field value if set, zero value otherwise.
func (o *EndpointAzureMonitor) GetLogType() string {
	if o == nil || IsNil(o.LogType) {
		var ret string
		return ret
	}
	return *o.LogType
}

// GetLogTypeOk returns a tuple with the LogType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureMonitor) GetLogTypeOk() (*string, bool) {
	if o == nil || IsNil(o.LogType) {
		return nil, false
	}
	return o.LogType, true
}

// HasLogType returns a boolean if a field has been set.
func (o *EndpointAzureMonitor) HasLogType() bool {
	if o != nil && !IsNil(o.LogType) {
		return true
	}

	return false
}

// SetLogType gets a reference to the given string and assigns it to the LogType field.
func (o *EndpointAzureMonitor) SetLogType(v string) {
	o.LogType = &v
}

// GetSharedKey returns the SharedKey field value if set, zero value otherwise.
func (o *EndpointAzureMonitor) GetSharedKey() string {
	if o == nil || IsNil(o.SharedKey) {
		var ret string
		return ret
	}
	return *o.SharedKey
}

// GetSharedKeyOk returns a tuple with the SharedKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureMonitor) GetSharedKeyOk() (*string, bool) {
	if o == nil || IsNil(o.SharedKey) {
		return nil, false
	}
	return o.SharedKey, true
}

// HasSharedKey returns a boolean if a field has been set.
func (o *EndpointAzureMonitor) HasSharedKey() bool {
	if o != nil && !IsNil(o.SharedKey) {
		return true
	}

	return false
}

// SetSharedKey gets a reference to the given string and assigns it to the SharedKey field.
func (o *EndpointAzureMonitor) SetSharedKey(v string) {
	o.SharedKey = &v
}

// GetTimeGeneratedField returns the TimeGeneratedField field value if set, zero value otherwise.
func (o *EndpointAzureMonitor) GetTimeGeneratedField() string {
	if o == nil || IsNil(o.TimeGeneratedField) {
		var ret string
		return ret
	}
	return *o.TimeGeneratedField
}

// GetTimeGeneratedFieldOk returns a tuple with the TimeGeneratedField field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureMonitor) GetTimeGeneratedFieldOk() (*string, bool) {
	if o == nil || IsNil(o.TimeGeneratedField) {
		return nil, false
	}
	return o.TimeGeneratedField, true
}

// HasTimeGeneratedField returns a boolean if a field has been set.
func (o *EndpointAzureMonitor) HasTimeGeneratedField() bool {
	if o != nil && !IsNil(o.TimeGeneratedField) {
		return true
	}

	return false
}

// SetTimeGeneratedField gets a reference to the given string and assigns it to the TimeGeneratedField field.
func (o *EndpointAzureMonitor) SetTimeGeneratedField(v string) {
	o.TimeGeneratedField = &v
}

// GetWorkspaceId returns the WorkspaceId field value if set, zero value otherwise.
func (o *EndpointAzureMonitor) GetWorkspaceId() string {
	if o == nil || IsNil(o.WorkspaceId) {
		var ret string
		return ret
	}
	return *o.WorkspaceId
}

// GetWorkspaceIdOk returns a tuple with the WorkspaceId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureMonitor) GetWorkspaceIdOk() (*string, bool) {
	if o == nil || IsNil(o.WorkspaceId) {
		return nil, false
	}
	return o.WorkspaceId, true
}

// HasWorkspaceId returns a boolean if a field has been set.
func (o *EndpointAzureMonitor) HasWorkspaceId() bool {
	if o != nil && !IsNil(o.WorkspaceId) {
		return true
	}

	return false
}

// SetWorkspaceId gets a reference to the given string and assigns it to the WorkspaceId field.
func (o *EndpointAzureMonitor) SetWorkspaceId(v string) {
	o.WorkspaceId = &v
}

func (o EndpointAzureMonitor) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpointAzureMonitor) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.LogType) {
		toSerialize["log_type"] = o.LogType
	}
	if !IsNil(o.SharedKey) {
		toSerialize["shared_key"] = o.SharedKey
	}
	if !IsNil(o.TimeGeneratedField) {
		toSerialize["time_generated_field"] = o.TimeGeneratedField
	}
	if !IsNil(o.WorkspaceId) {
		toSerialize["workspace_id"] = o.WorkspaceId
	}
	return toSerialize, nil
}

type NullableEndpointAzureMonitor struct {
	value *EndpointAzureMonitor
	isSet bool
}

func (v NullableEndpointAzureMonitor) Get() *EndpointAzureMonitor {
	return v.value
}

func (v *NullableEndpointAzureMonitor) Set(val *EndpointAzureMonitor) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpointAzureMonitor) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpointAzureMonitor) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpointAzureMonitor(val *EndpointAzureMonitor) *NullableEndpointAzureMonitor {
	return &NullableEndpointAzureMonitor{value: val, isSet: true}
}

func (v NullableEndpointAzureMonitor) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpointAzureMonitor) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


