// Unless explicitly stated otherwise all files in this repository are licensed
// under the Apache License Version 2.0.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2016 Datadog, Inc.

// Code generated by make_responsewriter.go DO NOT EDIT

package http

import "net/http"

// wrapResponseWriter wraps an underlying http.ResponseWriter so that it can
// trace the http response codes. It also checks for various http interfaces
// (Flusher, Pusher, CloseNotifier, Hijacker) and if the underlying
// http.ResponseWriter implements them it generates an unnamed struct with the
// appropriate fields.
//
// This code is generated because we have to account for all the permutations
// of the interfaces.
func wrapResponseWriter(w http.ResponseWriter) (http.ResponseWriter, *responseWriter) {
	hFlusher, okFlusher := w.(http.Flusher)
	hPusher, okPusher := w.(http.Pusher)
	hCloseNotifier, okCloseNotifier := w.(http.CloseNotifier)
	hHijacker, okHijacker := w.(http.Hijacker)

	mw := newResponseWriter(w)
	type monitoredResponseWriter interface {
		http.ResponseWriter
		Status() int
	}
	switch {
	case okFlusher && okPusher && okCloseNotifier && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.Pusher
			http.CloseNotifier
			http.Hijacker
		}{mw, hFlusher, hPusher, hCloseNotifier, hHijacker}
	case okFlusher && okPusher && okCloseNotifier:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.Pusher
			http.CloseNotifier
		}{mw, hFlusher, hPusher, hCloseNotifier}
	case okFlusher && okPusher && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.Pusher
			http.Hijacker
		}{mw, hFlusher, hPusher, hHijacker}
	case okFlusher && okCloseNotifier && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.CloseNotifier
			http.Hijacker
		}{mw, hFlusher, hCloseNotifier, hHijacker}
	case okPusher && okCloseNotifier && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Pusher
			http.CloseNotifier
			http.Hijacker
		}{mw, hPusher, hCloseNotifier, hHijacker}
	case okFlusher && okPusher:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.Pusher
		}{mw, hFlusher, hPusher}
	case okFlusher && okCloseNotifier:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.CloseNotifier
		}{mw, hFlusher, hCloseNotifier}
	case okFlusher && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Flusher
			http.Hijacker
		}{mw, hFlusher, hHijacker}
	case okPusher && okCloseNotifier:
		w = struct {
			monitoredResponseWriter
			http.Pusher
			http.CloseNotifier
		}{mw, hPusher, hCloseNotifier}
	case okPusher && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Pusher
			http.Hijacker
		}{mw, hPusher, hHijacker}
	case okCloseNotifier && okHijacker:
		w = struct {
			monitoredResponseWriter
			http.CloseNotifier
			http.Hijacker
		}{mw, hCloseNotifier, hHijacker}
	case okFlusher:
		w = struct {
			monitoredResponseWriter
			http.Flusher
		}{mw, hFlusher}
	case okPusher:
		w = struct {
			monitoredResponseWriter
			http.Pusher
		}{mw, hPusher}
	case okCloseNotifier:
		w = struct {
			monitoredResponseWriter
			http.CloseNotifier
		}{mw, hCloseNotifier}
	case okHijacker:
		w = struct {
			monitoredResponseWriter
			http.Hijacker
		}{mw, hHijacker}
	default:
		w = mw
	}

	return w, mw
}
