// Copyright 2023 Citra Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

package org.citra.citra_emu.model

import androidx.annotation.Keep
import java.io.IOException

class GameInfo(path: String) {
    @Keep
    private val pointer: Long

    init {
        pointer = initialize(path)
        if (pointer == 0L) {
            throw IOException()
        }
    }

    protected external fun finalize()

    external fun getTitle(): String

    external fun getRegions(): String

    external fun getCompany(): String

    external fun getIcon(): IntArray?

    external fun getIsVisibleSystemTitle(): Boolean

    companion object {
        @JvmStatic
        private external fun initialize(path: String): Long
    }
}
