// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package service

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	servicepb "cloud.google.com/go/orchestration/airflow/service/apiv1/servicepb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newEnvironmentsClientHook clientHook

// EnvironmentsCallOptions contains the retry settings for each method of EnvironmentsClient.
type EnvironmentsCallOptions struct {
	CreateEnvironment            []gax.CallOption
	GetEnvironment               []gax.CallOption
	ListEnvironments             []gax.CallOption
	UpdateEnvironment            []gax.CallOption
	DeleteEnvironment            []gax.CallOption
	ExecuteAirflowCommand        []gax.CallOption
	StopAirflowCommand           []gax.CallOption
	PollAirflowCommand           []gax.CallOption
	ListWorkloads                []gax.CallOption
	CheckUpgrade                 []gax.CallOption
	CreateUserWorkloadsSecret    []gax.CallOption
	GetUserWorkloadsSecret       []gax.CallOption
	ListUserWorkloadsSecrets     []gax.CallOption
	UpdateUserWorkloadsSecret    []gax.CallOption
	DeleteUserWorkloadsSecret    []gax.CallOption
	CreateUserWorkloadsConfigMap []gax.CallOption
	GetUserWorkloadsConfigMap    []gax.CallOption
	ListUserWorkloadsConfigMaps  []gax.CallOption
	UpdateUserWorkloadsConfigMap []gax.CallOption
	DeleteUserWorkloadsConfigMap []gax.CallOption
	SaveSnapshot                 []gax.CallOption
	LoadSnapshot                 []gax.CallOption
	DatabaseFailover             []gax.CallOption
	FetchDatabaseProperties      []gax.CallOption
	DeleteOperation              []gax.CallOption
	GetOperation                 []gax.CallOption
	ListOperations               []gax.CallOption
}

func defaultEnvironmentsGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("composer.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("composer.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("composer.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://composer.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultEnvironmentsCallOptions() *EnvironmentsCallOptions {
	return &EnvironmentsCallOptions{
		CreateEnvironment:            []gax.CallOption{},
		GetEnvironment:               []gax.CallOption{},
		ListEnvironments:             []gax.CallOption{},
		UpdateEnvironment:            []gax.CallOption{},
		DeleteEnvironment:            []gax.CallOption{},
		ExecuteAirflowCommand:        []gax.CallOption{},
		StopAirflowCommand:           []gax.CallOption{},
		PollAirflowCommand:           []gax.CallOption{},
		ListWorkloads:                []gax.CallOption{},
		CheckUpgrade:                 []gax.CallOption{},
		CreateUserWorkloadsSecret:    []gax.CallOption{},
		GetUserWorkloadsSecret:       []gax.CallOption{},
		ListUserWorkloadsSecrets:     []gax.CallOption{},
		UpdateUserWorkloadsSecret:    []gax.CallOption{},
		DeleteUserWorkloadsSecret:    []gax.CallOption{},
		CreateUserWorkloadsConfigMap: []gax.CallOption{},
		GetUserWorkloadsConfigMap:    []gax.CallOption{},
		ListUserWorkloadsConfigMaps:  []gax.CallOption{},
		UpdateUserWorkloadsConfigMap: []gax.CallOption{},
		DeleteUserWorkloadsConfigMap: []gax.CallOption{},
		SaveSnapshot:                 []gax.CallOption{},
		LoadSnapshot:                 []gax.CallOption{},
		DatabaseFailover:             []gax.CallOption{},
		FetchDatabaseProperties:      []gax.CallOption{},
		DeleteOperation:              []gax.CallOption{},
		GetOperation:                 []gax.CallOption{},
		ListOperations:               []gax.CallOption{},
	}
}

func defaultEnvironmentsRESTCallOptions() *EnvironmentsCallOptions {
	return &EnvironmentsCallOptions{
		CreateEnvironment:            []gax.CallOption{},
		GetEnvironment:               []gax.CallOption{},
		ListEnvironments:             []gax.CallOption{},
		UpdateEnvironment:            []gax.CallOption{},
		DeleteEnvironment:            []gax.CallOption{},
		ExecuteAirflowCommand:        []gax.CallOption{},
		StopAirflowCommand:           []gax.CallOption{},
		PollAirflowCommand:           []gax.CallOption{},
		ListWorkloads:                []gax.CallOption{},
		CheckUpgrade:                 []gax.CallOption{},
		CreateUserWorkloadsSecret:    []gax.CallOption{},
		GetUserWorkloadsSecret:       []gax.CallOption{},
		ListUserWorkloadsSecrets:     []gax.CallOption{},
		UpdateUserWorkloadsSecret:    []gax.CallOption{},
		DeleteUserWorkloadsSecret:    []gax.CallOption{},
		CreateUserWorkloadsConfigMap: []gax.CallOption{},
		GetUserWorkloadsConfigMap:    []gax.CallOption{},
		ListUserWorkloadsConfigMaps:  []gax.CallOption{},
		UpdateUserWorkloadsConfigMap: []gax.CallOption{},
		DeleteUserWorkloadsConfigMap: []gax.CallOption{},
		SaveSnapshot:                 []gax.CallOption{},
		LoadSnapshot:                 []gax.CallOption{},
		DatabaseFailover:             []gax.CallOption{},
		FetchDatabaseProperties:      []gax.CallOption{},
		DeleteOperation:              []gax.CallOption{},
		GetOperation:                 []gax.CallOption{},
		ListOperations:               []gax.CallOption{},
	}
}

// internalEnvironmentsClient is an interface that defines the methods available from Cloud Composer API.
type internalEnvironmentsClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateEnvironment(context.Context, *servicepb.CreateEnvironmentRequest, ...gax.CallOption) (*CreateEnvironmentOperation, error)
	CreateEnvironmentOperation(name string) *CreateEnvironmentOperation
	GetEnvironment(context.Context, *servicepb.GetEnvironmentRequest, ...gax.CallOption) (*servicepb.Environment, error)
	ListEnvironments(context.Context, *servicepb.ListEnvironmentsRequest, ...gax.CallOption) *EnvironmentIterator
	UpdateEnvironment(context.Context, *servicepb.UpdateEnvironmentRequest, ...gax.CallOption) (*UpdateEnvironmentOperation, error)
	UpdateEnvironmentOperation(name string) *UpdateEnvironmentOperation
	DeleteEnvironment(context.Context, *servicepb.DeleteEnvironmentRequest, ...gax.CallOption) (*DeleteEnvironmentOperation, error)
	DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation
	ExecuteAirflowCommand(context.Context, *servicepb.ExecuteAirflowCommandRequest, ...gax.CallOption) (*servicepb.ExecuteAirflowCommandResponse, error)
	StopAirflowCommand(context.Context, *servicepb.StopAirflowCommandRequest, ...gax.CallOption) (*servicepb.StopAirflowCommandResponse, error)
	PollAirflowCommand(context.Context, *servicepb.PollAirflowCommandRequest, ...gax.CallOption) (*servicepb.PollAirflowCommandResponse, error)
	ListWorkloads(context.Context, *servicepb.ListWorkloadsRequest, ...gax.CallOption) *ListWorkloadsResponse_ComposerWorkloadIterator
	CheckUpgrade(context.Context, *servicepb.CheckUpgradeRequest, ...gax.CallOption) (*CheckUpgradeOperation, error)
	CheckUpgradeOperation(name string) *CheckUpgradeOperation
	CreateUserWorkloadsSecret(context.Context, *servicepb.CreateUserWorkloadsSecretRequest, ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error)
	GetUserWorkloadsSecret(context.Context, *servicepb.GetUserWorkloadsSecretRequest, ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error)
	ListUserWorkloadsSecrets(context.Context, *servicepb.ListUserWorkloadsSecretsRequest, ...gax.CallOption) *UserWorkloadsSecretIterator
	UpdateUserWorkloadsSecret(context.Context, *servicepb.UpdateUserWorkloadsSecretRequest, ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error)
	DeleteUserWorkloadsSecret(context.Context, *servicepb.DeleteUserWorkloadsSecretRequest, ...gax.CallOption) error
	CreateUserWorkloadsConfigMap(context.Context, *servicepb.CreateUserWorkloadsConfigMapRequest, ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error)
	GetUserWorkloadsConfigMap(context.Context, *servicepb.GetUserWorkloadsConfigMapRequest, ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error)
	ListUserWorkloadsConfigMaps(context.Context, *servicepb.ListUserWorkloadsConfigMapsRequest, ...gax.CallOption) *UserWorkloadsConfigMapIterator
	UpdateUserWorkloadsConfigMap(context.Context, *servicepb.UpdateUserWorkloadsConfigMapRequest, ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error)
	DeleteUserWorkloadsConfigMap(context.Context, *servicepb.DeleteUserWorkloadsConfigMapRequest, ...gax.CallOption) error
	SaveSnapshot(context.Context, *servicepb.SaveSnapshotRequest, ...gax.CallOption) (*SaveSnapshotOperation, error)
	SaveSnapshotOperation(name string) *SaveSnapshotOperation
	LoadSnapshot(context.Context, *servicepb.LoadSnapshotRequest, ...gax.CallOption) (*LoadSnapshotOperation, error)
	LoadSnapshotOperation(name string) *LoadSnapshotOperation
	DatabaseFailover(context.Context, *servicepb.DatabaseFailoverRequest, ...gax.CallOption) (*DatabaseFailoverOperation, error)
	DatabaseFailoverOperation(name string) *DatabaseFailoverOperation
	FetchDatabaseProperties(context.Context, *servicepb.FetchDatabasePropertiesRequest, ...gax.CallOption) (*servicepb.FetchDatabasePropertiesResponse, error)
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// EnvironmentsClient is a client for interacting with Cloud Composer API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Managed Apache Airflow Environments.
type EnvironmentsClient struct {
	// The internal transport-dependent client.
	internalClient internalEnvironmentsClient

	// The call options for this service.
	CallOptions *EnvironmentsCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *EnvironmentsClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *EnvironmentsClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *EnvironmentsClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateEnvironment create a new environment.
func (c *EnvironmentsClient) CreateEnvironment(ctx context.Context, req *servicepb.CreateEnvironmentRequest, opts ...gax.CallOption) (*CreateEnvironmentOperation, error) {
	return c.internalClient.CreateEnvironment(ctx, req, opts...)
}

// CreateEnvironmentOperation returns a new CreateEnvironmentOperation from a given name.
// The name must be that of a previously created CreateEnvironmentOperation, possibly from a different process.
func (c *EnvironmentsClient) CreateEnvironmentOperation(name string) *CreateEnvironmentOperation {
	return c.internalClient.CreateEnvironmentOperation(name)
}

// GetEnvironment get an existing environment.
func (c *EnvironmentsClient) GetEnvironment(ctx context.Context, req *servicepb.GetEnvironmentRequest, opts ...gax.CallOption) (*servicepb.Environment, error) {
	return c.internalClient.GetEnvironment(ctx, req, opts...)
}

// ListEnvironments list environments.
func (c *EnvironmentsClient) ListEnvironments(ctx context.Context, req *servicepb.ListEnvironmentsRequest, opts ...gax.CallOption) *EnvironmentIterator {
	return c.internalClient.ListEnvironments(ctx, req, opts...)
}

// UpdateEnvironment update an environment.
func (c *EnvironmentsClient) UpdateEnvironment(ctx context.Context, req *servicepb.UpdateEnvironmentRequest, opts ...gax.CallOption) (*UpdateEnvironmentOperation, error) {
	return c.internalClient.UpdateEnvironment(ctx, req, opts...)
}

// UpdateEnvironmentOperation returns a new UpdateEnvironmentOperation from a given name.
// The name must be that of a previously created UpdateEnvironmentOperation, possibly from a different process.
func (c *EnvironmentsClient) UpdateEnvironmentOperation(name string) *UpdateEnvironmentOperation {
	return c.internalClient.UpdateEnvironmentOperation(name)
}

// DeleteEnvironment delete an environment.
func (c *EnvironmentsClient) DeleteEnvironment(ctx context.Context, req *servicepb.DeleteEnvironmentRequest, opts ...gax.CallOption) (*DeleteEnvironmentOperation, error) {
	return c.internalClient.DeleteEnvironment(ctx, req, opts...)
}

// DeleteEnvironmentOperation returns a new DeleteEnvironmentOperation from a given name.
// The name must be that of a previously created DeleteEnvironmentOperation, possibly from a different process.
func (c *EnvironmentsClient) DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation {
	return c.internalClient.DeleteEnvironmentOperation(name)
}

// ExecuteAirflowCommand executes Airflow CLI command.
func (c *EnvironmentsClient) ExecuteAirflowCommand(ctx context.Context, req *servicepb.ExecuteAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.ExecuteAirflowCommandResponse, error) {
	return c.internalClient.ExecuteAirflowCommand(ctx, req, opts...)
}

// StopAirflowCommand stops Airflow CLI command execution.
func (c *EnvironmentsClient) StopAirflowCommand(ctx context.Context, req *servicepb.StopAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.StopAirflowCommandResponse, error) {
	return c.internalClient.StopAirflowCommand(ctx, req, opts...)
}

// PollAirflowCommand polls Airflow CLI command execution and fetches logs.
func (c *EnvironmentsClient) PollAirflowCommand(ctx context.Context, req *servicepb.PollAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.PollAirflowCommandResponse, error) {
	return c.internalClient.PollAirflowCommand(ctx, req, opts...)
}

// ListWorkloads lists workloads in a Cloud Composer environment. Workload is a unit that
// runs a single Composer component.
//
// This method is supported for Cloud Composer environments in versions
// composer-2..-airflow-..* and newer.
func (c *EnvironmentsClient) ListWorkloads(ctx context.Context, req *servicepb.ListWorkloadsRequest, opts ...gax.CallOption) *ListWorkloadsResponse_ComposerWorkloadIterator {
	return c.internalClient.ListWorkloads(ctx, req, opts...)
}

// CheckUpgrade check if an upgrade operation on the environment will succeed.
//
// In case of problems detailed info can be found in the returned Operation.
func (c *EnvironmentsClient) CheckUpgrade(ctx context.Context, req *servicepb.CheckUpgradeRequest, opts ...gax.CallOption) (*CheckUpgradeOperation, error) {
	return c.internalClient.CheckUpgrade(ctx, req, opts...)
}

// CheckUpgradeOperation returns a new CheckUpgradeOperation from a given name.
// The name must be that of a previously created CheckUpgradeOperation, possibly from a different process.
func (c *EnvironmentsClient) CheckUpgradeOperation(name string) *CheckUpgradeOperation {
	return c.internalClient.CheckUpgradeOperation(name)
}

// CreateUserWorkloadsSecret creates a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) CreateUserWorkloadsSecret(ctx context.Context, req *servicepb.CreateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	return c.internalClient.CreateUserWorkloadsSecret(ctx, req, opts...)
}

// GetUserWorkloadsSecret gets an existing user workloads Secret.
// Values of the “data” field in the response are cleared.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) GetUserWorkloadsSecret(ctx context.Context, req *servicepb.GetUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	return c.internalClient.GetUserWorkloadsSecret(ctx, req, opts...)
}

// ListUserWorkloadsSecrets lists user workloads Secrets.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) ListUserWorkloadsSecrets(ctx context.Context, req *servicepb.ListUserWorkloadsSecretsRequest, opts ...gax.CallOption) *UserWorkloadsSecretIterator {
	return c.internalClient.ListUserWorkloadsSecrets(ctx, req, opts...)
}

// UpdateUserWorkloadsSecret updates a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) UpdateUserWorkloadsSecret(ctx context.Context, req *servicepb.UpdateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	return c.internalClient.UpdateUserWorkloadsSecret(ctx, req, opts...)
}

// DeleteUserWorkloadsSecret deletes a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) DeleteUserWorkloadsSecret(ctx context.Context, req *servicepb.DeleteUserWorkloadsSecretRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteUserWorkloadsSecret(ctx, req, opts...)
}

// CreateUserWorkloadsConfigMap creates a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) CreateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.CreateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	return c.internalClient.CreateUserWorkloadsConfigMap(ctx, req, opts...)
}

// GetUserWorkloadsConfigMap gets an existing user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) GetUserWorkloadsConfigMap(ctx context.Context, req *servicepb.GetUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	return c.internalClient.GetUserWorkloadsConfigMap(ctx, req, opts...)
}

// ListUserWorkloadsConfigMaps lists user workloads ConfigMaps.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) ListUserWorkloadsConfigMaps(ctx context.Context, req *servicepb.ListUserWorkloadsConfigMapsRequest, opts ...gax.CallOption) *UserWorkloadsConfigMapIterator {
	return c.internalClient.ListUserWorkloadsConfigMaps(ctx, req, opts...)
}

// UpdateUserWorkloadsConfigMap updates a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) UpdateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.UpdateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	return c.internalClient.UpdateUserWorkloadsConfigMap(ctx, req, opts...)
}

// DeleteUserWorkloadsConfigMap deletes a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *EnvironmentsClient) DeleteUserWorkloadsConfigMap(ctx context.Context, req *servicepb.DeleteUserWorkloadsConfigMapRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteUserWorkloadsConfigMap(ctx, req, opts...)
}

// SaveSnapshot creates a snapshots of a Cloud Composer environment.
//
// As a result of this operation, snapshot of environment’s state is stored
// in a location specified in the SaveSnapshotRequest.
func (c *EnvironmentsClient) SaveSnapshot(ctx context.Context, req *servicepb.SaveSnapshotRequest, opts ...gax.CallOption) (*SaveSnapshotOperation, error) {
	return c.internalClient.SaveSnapshot(ctx, req, opts...)
}

// SaveSnapshotOperation returns a new SaveSnapshotOperation from a given name.
// The name must be that of a previously created SaveSnapshotOperation, possibly from a different process.
func (c *EnvironmentsClient) SaveSnapshotOperation(name string) *SaveSnapshotOperation {
	return c.internalClient.SaveSnapshotOperation(name)
}

// LoadSnapshot loads a snapshot of a Cloud Composer environment.
//
// As a result of this operation, a snapshot of environment’s specified in
// LoadSnapshotRequest is loaded into the environment.
func (c *EnvironmentsClient) LoadSnapshot(ctx context.Context, req *servicepb.LoadSnapshotRequest, opts ...gax.CallOption) (*LoadSnapshotOperation, error) {
	return c.internalClient.LoadSnapshot(ctx, req, opts...)
}

// LoadSnapshotOperation returns a new LoadSnapshotOperation from a given name.
// The name must be that of a previously created LoadSnapshotOperation, possibly from a different process.
func (c *EnvironmentsClient) LoadSnapshotOperation(name string) *LoadSnapshotOperation {
	return c.internalClient.LoadSnapshotOperation(name)
}

// DatabaseFailover triggers database failover (only for highly resilient environments).
func (c *EnvironmentsClient) DatabaseFailover(ctx context.Context, req *servicepb.DatabaseFailoverRequest, opts ...gax.CallOption) (*DatabaseFailoverOperation, error) {
	return c.internalClient.DatabaseFailover(ctx, req, opts...)
}

// DatabaseFailoverOperation returns a new DatabaseFailoverOperation from a given name.
// The name must be that of a previously created DatabaseFailoverOperation, possibly from a different process.
func (c *EnvironmentsClient) DatabaseFailoverOperation(name string) *DatabaseFailoverOperation {
	return c.internalClient.DatabaseFailoverOperation(name)
}

// FetchDatabaseProperties fetches database properties.
func (c *EnvironmentsClient) FetchDatabaseProperties(ctx context.Context, req *servicepb.FetchDatabasePropertiesRequest, opts ...gax.CallOption) (*servicepb.FetchDatabasePropertiesResponse, error) {
	return c.internalClient.FetchDatabaseProperties(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *EnvironmentsClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *EnvironmentsClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *EnvironmentsClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// environmentsGRPCClient is a client for interacting with Cloud Composer API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type environmentsGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing EnvironmentsClient
	CallOptions **EnvironmentsCallOptions

	// The gRPC API client.
	environmentsClient servicepb.EnvironmentsClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewEnvironmentsClient creates a new environments client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Managed Apache Airflow Environments.
func NewEnvironmentsClient(ctx context.Context, opts ...option.ClientOption) (*EnvironmentsClient, error) {
	clientOpts := defaultEnvironmentsGRPCClientOptions()
	if newEnvironmentsClientHook != nil {
		hookOpts, err := newEnvironmentsClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := EnvironmentsClient{CallOptions: defaultEnvironmentsCallOptions()}

	c := &environmentsGRPCClient{
		connPool:           connPool,
		environmentsClient: servicepb.NewEnvironmentsClient(connPool),
		CallOptions:        &client.CallOptions,
		logger:             internaloption.GetLogger(opts),
		operationsClient:   longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *environmentsGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *environmentsGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *environmentsGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type environmentsRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing EnvironmentsClient
	CallOptions **EnvironmentsCallOptions

	logger *slog.Logger
}

// NewEnvironmentsRESTClient creates a new environments rest client.
//
// Managed Apache Airflow Environments.
func NewEnvironmentsRESTClient(ctx context.Context, opts ...option.ClientOption) (*EnvironmentsClient, error) {
	clientOpts := append(defaultEnvironmentsRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultEnvironmentsRESTCallOptions()
	c := &environmentsRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &EnvironmentsClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultEnvironmentsRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://composer.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://composer.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://composer.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://composer.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *environmentsRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *environmentsRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *environmentsRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *environmentsGRPCClient) CreateEnvironment(ctx context.Context, req *servicepb.CreateEnvironmentRequest, opts ...gax.CallOption) (*CreateEnvironmentOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEnvironment[0:len((*c.CallOptions).CreateEnvironment):len((*c.CallOptions).CreateEnvironment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.CreateEnvironment, req, settings.GRPC, c.logger, "CreateEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) GetEnvironment(ctx context.Context, req *servicepb.GetEnvironmentRequest, opts ...gax.CallOption) (*servicepb.Environment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEnvironment[0:len((*c.CallOptions).GetEnvironment):len((*c.CallOptions).GetEnvironment)], opts...)
	var resp *servicepb.Environment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.GetEnvironment, req, settings.GRPC, c.logger, "GetEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) ListEnvironments(ctx context.Context, req *servicepb.ListEnvironmentsRequest, opts ...gax.CallOption) *EnvironmentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEnvironments[0:len((*c.CallOptions).ListEnvironments):len((*c.CallOptions).ListEnvironments)], opts...)
	it := &EnvironmentIterator{}
	req = proto.Clone(req).(*servicepb.ListEnvironmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.Environment, string, error) {
		resp := &servicepb.ListEnvironmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.environmentsClient.ListEnvironments, req, settings.GRPC, c.logger, "ListEnvironments")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEnvironments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *environmentsGRPCClient) UpdateEnvironment(ctx context.Context, req *servicepb.UpdateEnvironmentRequest, opts ...gax.CallOption) (*UpdateEnvironmentOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEnvironment[0:len((*c.CallOptions).UpdateEnvironment):len((*c.CallOptions).UpdateEnvironment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.UpdateEnvironment, req, settings.GRPC, c.logger, "UpdateEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) DeleteEnvironment(ctx context.Context, req *servicepb.DeleteEnvironmentRequest, opts ...gax.CallOption) (*DeleteEnvironmentOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEnvironment[0:len((*c.CallOptions).DeleteEnvironment):len((*c.CallOptions).DeleteEnvironment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.DeleteEnvironment, req, settings.GRPC, c.logger, "DeleteEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) ExecuteAirflowCommand(ctx context.Context, req *servicepb.ExecuteAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.ExecuteAirflowCommandResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExecuteAirflowCommand[0:len((*c.CallOptions).ExecuteAirflowCommand):len((*c.CallOptions).ExecuteAirflowCommand)], opts...)
	var resp *servicepb.ExecuteAirflowCommandResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.ExecuteAirflowCommand, req, settings.GRPC, c.logger, "ExecuteAirflowCommand")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) StopAirflowCommand(ctx context.Context, req *servicepb.StopAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.StopAirflowCommandResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopAirflowCommand[0:len((*c.CallOptions).StopAirflowCommand):len((*c.CallOptions).StopAirflowCommand)], opts...)
	var resp *servicepb.StopAirflowCommandResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.StopAirflowCommand, req, settings.GRPC, c.logger, "StopAirflowCommand")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) PollAirflowCommand(ctx context.Context, req *servicepb.PollAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.PollAirflowCommandResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).PollAirflowCommand[0:len((*c.CallOptions).PollAirflowCommand):len((*c.CallOptions).PollAirflowCommand)], opts...)
	var resp *servicepb.PollAirflowCommandResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.PollAirflowCommand, req, settings.GRPC, c.logger, "PollAirflowCommand")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) ListWorkloads(ctx context.Context, req *servicepb.ListWorkloadsRequest, opts ...gax.CallOption) *ListWorkloadsResponse_ComposerWorkloadIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListWorkloads[0:len((*c.CallOptions).ListWorkloads):len((*c.CallOptions).ListWorkloads)], opts...)
	it := &ListWorkloadsResponse_ComposerWorkloadIterator{}
	req = proto.Clone(req).(*servicepb.ListWorkloadsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.ListWorkloadsResponse_ComposerWorkload, string, error) {
		resp := &servicepb.ListWorkloadsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.environmentsClient.ListWorkloads, req, settings.GRPC, c.logger, "ListWorkloads")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetWorkloads(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *environmentsGRPCClient) CheckUpgrade(ctx context.Context, req *servicepb.CheckUpgradeRequest, opts ...gax.CallOption) (*CheckUpgradeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CheckUpgrade[0:len((*c.CallOptions).CheckUpgrade):len((*c.CallOptions).CheckUpgrade)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.CheckUpgrade, req, settings.GRPC, c.logger, "CheckUpgrade")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CheckUpgradeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) CreateUserWorkloadsSecret(ctx context.Context, req *servicepb.CreateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateUserWorkloadsSecret[0:len((*c.CallOptions).CreateUserWorkloadsSecret):len((*c.CallOptions).CreateUserWorkloadsSecret)], opts...)
	var resp *servicepb.UserWorkloadsSecret
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.CreateUserWorkloadsSecret, req, settings.GRPC, c.logger, "CreateUserWorkloadsSecret")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) GetUserWorkloadsSecret(ctx context.Context, req *servicepb.GetUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetUserWorkloadsSecret[0:len((*c.CallOptions).GetUserWorkloadsSecret):len((*c.CallOptions).GetUserWorkloadsSecret)], opts...)
	var resp *servicepb.UserWorkloadsSecret
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.GetUserWorkloadsSecret, req, settings.GRPC, c.logger, "GetUserWorkloadsSecret")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) ListUserWorkloadsSecrets(ctx context.Context, req *servicepb.ListUserWorkloadsSecretsRequest, opts ...gax.CallOption) *UserWorkloadsSecretIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListUserWorkloadsSecrets[0:len((*c.CallOptions).ListUserWorkloadsSecrets):len((*c.CallOptions).ListUserWorkloadsSecrets)], opts...)
	it := &UserWorkloadsSecretIterator{}
	req = proto.Clone(req).(*servicepb.ListUserWorkloadsSecretsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.UserWorkloadsSecret, string, error) {
		resp := &servicepb.ListUserWorkloadsSecretsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.environmentsClient.ListUserWorkloadsSecrets, req, settings.GRPC, c.logger, "ListUserWorkloadsSecrets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetUserWorkloadsSecrets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *environmentsGRPCClient) UpdateUserWorkloadsSecret(ctx context.Context, req *servicepb.UpdateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "user_workloads_secret.name", url.QueryEscape(req.GetUserWorkloadsSecret().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateUserWorkloadsSecret[0:len((*c.CallOptions).UpdateUserWorkloadsSecret):len((*c.CallOptions).UpdateUserWorkloadsSecret)], opts...)
	var resp *servicepb.UserWorkloadsSecret
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.UpdateUserWorkloadsSecret, req, settings.GRPC, c.logger, "UpdateUserWorkloadsSecret")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) DeleteUserWorkloadsSecret(ctx context.Context, req *servicepb.DeleteUserWorkloadsSecretRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteUserWorkloadsSecret[0:len((*c.CallOptions).DeleteUserWorkloadsSecret):len((*c.CallOptions).DeleteUserWorkloadsSecret)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.environmentsClient.DeleteUserWorkloadsSecret, req, settings.GRPC, c.logger, "DeleteUserWorkloadsSecret")
		return err
	}, opts...)
	return err
}

func (c *environmentsGRPCClient) CreateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.CreateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateUserWorkloadsConfigMap[0:len((*c.CallOptions).CreateUserWorkloadsConfigMap):len((*c.CallOptions).CreateUserWorkloadsConfigMap)], opts...)
	var resp *servicepb.UserWorkloadsConfigMap
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.CreateUserWorkloadsConfigMap, req, settings.GRPC, c.logger, "CreateUserWorkloadsConfigMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) GetUserWorkloadsConfigMap(ctx context.Context, req *servicepb.GetUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetUserWorkloadsConfigMap[0:len((*c.CallOptions).GetUserWorkloadsConfigMap):len((*c.CallOptions).GetUserWorkloadsConfigMap)], opts...)
	var resp *servicepb.UserWorkloadsConfigMap
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.GetUserWorkloadsConfigMap, req, settings.GRPC, c.logger, "GetUserWorkloadsConfigMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) ListUserWorkloadsConfigMaps(ctx context.Context, req *servicepb.ListUserWorkloadsConfigMapsRequest, opts ...gax.CallOption) *UserWorkloadsConfigMapIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListUserWorkloadsConfigMaps[0:len((*c.CallOptions).ListUserWorkloadsConfigMaps):len((*c.CallOptions).ListUserWorkloadsConfigMaps)], opts...)
	it := &UserWorkloadsConfigMapIterator{}
	req = proto.Clone(req).(*servicepb.ListUserWorkloadsConfigMapsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.UserWorkloadsConfigMap, string, error) {
		resp := &servicepb.ListUserWorkloadsConfigMapsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.environmentsClient.ListUserWorkloadsConfigMaps, req, settings.GRPC, c.logger, "ListUserWorkloadsConfigMaps")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetUserWorkloadsConfigMaps(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *environmentsGRPCClient) UpdateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.UpdateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "user_workloads_config_map.name", url.QueryEscape(req.GetUserWorkloadsConfigMap().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateUserWorkloadsConfigMap[0:len((*c.CallOptions).UpdateUserWorkloadsConfigMap):len((*c.CallOptions).UpdateUserWorkloadsConfigMap)], opts...)
	var resp *servicepb.UserWorkloadsConfigMap
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.UpdateUserWorkloadsConfigMap, req, settings.GRPC, c.logger, "UpdateUserWorkloadsConfigMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) DeleteUserWorkloadsConfigMap(ctx context.Context, req *servicepb.DeleteUserWorkloadsConfigMapRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteUserWorkloadsConfigMap[0:len((*c.CallOptions).DeleteUserWorkloadsConfigMap):len((*c.CallOptions).DeleteUserWorkloadsConfigMap)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.environmentsClient.DeleteUserWorkloadsConfigMap, req, settings.GRPC, c.logger, "DeleteUserWorkloadsConfigMap")
		return err
	}, opts...)
	return err
}

func (c *environmentsGRPCClient) SaveSnapshot(ctx context.Context, req *servicepb.SaveSnapshotRequest, opts ...gax.CallOption) (*SaveSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SaveSnapshot[0:len((*c.CallOptions).SaveSnapshot):len((*c.CallOptions).SaveSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.SaveSnapshot, req, settings.GRPC, c.logger, "SaveSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SaveSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) LoadSnapshot(ctx context.Context, req *servicepb.LoadSnapshotRequest, opts ...gax.CallOption) (*LoadSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).LoadSnapshot[0:len((*c.CallOptions).LoadSnapshot):len((*c.CallOptions).LoadSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.LoadSnapshot, req, settings.GRPC, c.logger, "LoadSnapshot")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &LoadSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) DatabaseFailover(ctx context.Context, req *servicepb.DatabaseFailoverRequest, opts ...gax.CallOption) (*DatabaseFailoverOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DatabaseFailover[0:len((*c.CallOptions).DatabaseFailover):len((*c.CallOptions).DatabaseFailover)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.DatabaseFailover, req, settings.GRPC, c.logger, "DatabaseFailover")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DatabaseFailoverOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *environmentsGRPCClient) FetchDatabaseProperties(ctx context.Context, req *servicepb.FetchDatabasePropertiesRequest, opts ...gax.CallOption) (*servicepb.FetchDatabasePropertiesResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).FetchDatabaseProperties[0:len((*c.CallOptions).FetchDatabaseProperties):len((*c.CallOptions).FetchDatabaseProperties)], opts...)
	var resp *servicepb.FetchDatabasePropertiesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.environmentsClient.FetchDatabaseProperties, req, settings.GRPC, c.logger, "FetchDatabaseProperties")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *environmentsGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *environmentsGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateEnvironment create a new environment.
func (c *environmentsRESTClient) CreateEnvironment(ctx context.Context, req *servicepb.CreateEnvironmentRequest, opts ...gax.CallOption) (*CreateEnvironmentOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEnvironment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/environments", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateEnvironment")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetEnvironment get an existing environment.
func (c *environmentsRESTClient) GetEnvironment(ctx context.Context, req *servicepb.GetEnvironmentRequest, opts ...gax.CallOption) (*servicepb.Environment, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEnvironment[0:len((*c.CallOptions).GetEnvironment):len((*c.CallOptions).GetEnvironment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.Environment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEnvironment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListEnvironments list environments.
func (c *environmentsRESTClient) ListEnvironments(ctx context.Context, req *servicepb.ListEnvironmentsRequest, opts ...gax.CallOption) *EnvironmentIterator {
	it := &EnvironmentIterator{}
	req = proto.Clone(req).(*servicepb.ListEnvironmentsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.Environment, string, error) {
		resp := &servicepb.ListEnvironmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/environments", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEnvironments")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEnvironments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateEnvironment update an environment.
func (c *environmentsRESTClient) UpdateEnvironment(ctx context.Context, req *servicepb.UpdateEnvironmentRequest, opts ...gax.CallOption) (*UpdateEnvironmentOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEnvironment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateEnvironment")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteEnvironment delete an environment.
func (c *environmentsRESTClient) DeleteEnvironment(ctx context.Context, req *servicepb.DeleteEnvironmentRequest, opts ...gax.CallOption) (*DeleteEnvironmentOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteEnvironment")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExecuteAirflowCommand executes Airflow CLI command.
func (c *environmentsRESTClient) ExecuteAirflowCommand(ctx context.Context, req *servicepb.ExecuteAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.ExecuteAirflowCommandResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:executeAirflowCommand", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ExecuteAirflowCommand[0:len((*c.CallOptions).ExecuteAirflowCommand):len((*c.CallOptions).ExecuteAirflowCommand)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.ExecuteAirflowCommandResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExecuteAirflowCommand")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// StopAirflowCommand stops Airflow CLI command execution.
func (c *environmentsRESTClient) StopAirflowCommand(ctx context.Context, req *servicepb.StopAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.StopAirflowCommandResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:stopAirflowCommand", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).StopAirflowCommand[0:len((*c.CallOptions).StopAirflowCommand):len((*c.CallOptions).StopAirflowCommand)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.StopAirflowCommandResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StopAirflowCommand")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// PollAirflowCommand polls Airflow CLI command execution and fetches logs.
func (c *environmentsRESTClient) PollAirflowCommand(ctx context.Context, req *servicepb.PollAirflowCommandRequest, opts ...gax.CallOption) (*servicepb.PollAirflowCommandResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:pollAirflowCommand", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).PollAirflowCommand[0:len((*c.CallOptions).PollAirflowCommand):len((*c.CallOptions).PollAirflowCommand)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.PollAirflowCommandResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "PollAirflowCommand")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListWorkloads lists workloads in a Cloud Composer environment. Workload is a unit that
// runs a single Composer component.
//
// This method is supported for Cloud Composer environments in versions
// composer-2..-airflow-..* and newer.
func (c *environmentsRESTClient) ListWorkloads(ctx context.Context, req *servicepb.ListWorkloadsRequest, opts ...gax.CallOption) *ListWorkloadsResponse_ComposerWorkloadIterator {
	it := &ListWorkloadsResponse_ComposerWorkloadIterator{}
	req = proto.Clone(req).(*servicepb.ListWorkloadsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.ListWorkloadsResponse_ComposerWorkload, string, error) {
		resp := &servicepb.ListWorkloadsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/workloads", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListWorkloads")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetWorkloads(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CheckUpgrade check if an upgrade operation on the environment will succeed.
//
// In case of problems detailed info can be found in the returned Operation.
func (c *environmentsRESTClient) CheckUpgrade(ctx context.Context, req *servicepb.CheckUpgradeRequest, opts ...gax.CallOption) (*CheckUpgradeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:checkUpgrade", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CheckUpgrade")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CheckUpgradeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateUserWorkloadsSecret creates a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) CreateUserWorkloadsSecret(ctx context.Context, req *servicepb.CreateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetUserWorkloadsSecret()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/userWorkloadsSecrets", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateUserWorkloadsSecret[0:len((*c.CallOptions).CreateUserWorkloadsSecret):len((*c.CallOptions).CreateUserWorkloadsSecret)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsSecret{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateUserWorkloadsSecret")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetUserWorkloadsSecret gets an existing user workloads Secret.
// Values of the “data” field in the response are cleared.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) GetUserWorkloadsSecret(ctx context.Context, req *servicepb.GetUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetUserWorkloadsSecret[0:len((*c.CallOptions).GetUserWorkloadsSecret):len((*c.CallOptions).GetUserWorkloadsSecret)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsSecret{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetUserWorkloadsSecret")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListUserWorkloadsSecrets lists user workloads Secrets.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) ListUserWorkloadsSecrets(ctx context.Context, req *servicepb.ListUserWorkloadsSecretsRequest, opts ...gax.CallOption) *UserWorkloadsSecretIterator {
	it := &UserWorkloadsSecretIterator{}
	req = proto.Clone(req).(*servicepb.ListUserWorkloadsSecretsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.UserWorkloadsSecret, string, error) {
		resp := &servicepb.ListUserWorkloadsSecretsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/userWorkloadsSecrets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListUserWorkloadsSecrets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetUserWorkloadsSecrets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateUserWorkloadsSecret updates a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) UpdateUserWorkloadsSecret(ctx context.Context, req *servicepb.UpdateUserWorkloadsSecretRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsSecret, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetUserWorkloadsSecret()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetUserWorkloadsSecret().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "user_workloads_secret.name", url.QueryEscape(req.GetUserWorkloadsSecret().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateUserWorkloadsSecret[0:len((*c.CallOptions).UpdateUserWorkloadsSecret):len((*c.CallOptions).UpdateUserWorkloadsSecret)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsSecret{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PUT", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateUserWorkloadsSecret")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteUserWorkloadsSecret deletes a user workloads Secret.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) DeleteUserWorkloadsSecret(ctx context.Context, req *servicepb.DeleteUserWorkloadsSecretRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteUserWorkloadsSecret")
		return err
	}, opts...)
}

// CreateUserWorkloadsConfigMap creates a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) CreateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.CreateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetUserWorkloadsConfigMap()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/userWorkloadsConfigMaps", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateUserWorkloadsConfigMap[0:len((*c.CallOptions).CreateUserWorkloadsConfigMap):len((*c.CallOptions).CreateUserWorkloadsConfigMap)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsConfigMap{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateUserWorkloadsConfigMap")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetUserWorkloadsConfigMap gets an existing user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) GetUserWorkloadsConfigMap(ctx context.Context, req *servicepb.GetUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetUserWorkloadsConfigMap[0:len((*c.CallOptions).GetUserWorkloadsConfigMap):len((*c.CallOptions).GetUserWorkloadsConfigMap)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsConfigMap{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetUserWorkloadsConfigMap")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListUserWorkloadsConfigMaps lists user workloads ConfigMaps.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) ListUserWorkloadsConfigMaps(ctx context.Context, req *servicepb.ListUserWorkloadsConfigMapsRequest, opts ...gax.CallOption) *UserWorkloadsConfigMapIterator {
	it := &UserWorkloadsConfigMapIterator{}
	req = proto.Clone(req).(*servicepb.ListUserWorkloadsConfigMapsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.UserWorkloadsConfigMap, string, error) {
		resp := &servicepb.ListUserWorkloadsConfigMapsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/userWorkloadsConfigMaps", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListUserWorkloadsConfigMaps")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetUserWorkloadsConfigMaps(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateUserWorkloadsConfigMap updates a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) UpdateUserWorkloadsConfigMap(ctx context.Context, req *servicepb.UpdateUserWorkloadsConfigMapRequest, opts ...gax.CallOption) (*servicepb.UserWorkloadsConfigMap, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetUserWorkloadsConfigMap()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetUserWorkloadsConfigMap().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "user_workloads_config_map.name", url.QueryEscape(req.GetUserWorkloadsConfigMap().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateUserWorkloadsConfigMap[0:len((*c.CallOptions).UpdateUserWorkloadsConfigMap):len((*c.CallOptions).UpdateUserWorkloadsConfigMap)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.UserWorkloadsConfigMap{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PUT", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateUserWorkloadsConfigMap")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteUserWorkloadsConfigMap deletes a user workloads ConfigMap.
//
// This method is supported for Cloud Composer environments in versions
// composer-3-airflow-..-build. and newer.
func (c *environmentsRESTClient) DeleteUserWorkloadsConfigMap(ctx context.Context, req *servicepb.DeleteUserWorkloadsConfigMapRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteUserWorkloadsConfigMap")
		return err
	}, opts...)
}

// SaveSnapshot creates a snapshots of a Cloud Composer environment.
//
// As a result of this operation, snapshot of environment’s state is stored
// in a location specified in the SaveSnapshotRequest.
func (c *environmentsRESTClient) SaveSnapshot(ctx context.Context, req *servicepb.SaveSnapshotRequest, opts ...gax.CallOption) (*SaveSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:saveSnapshot", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SaveSnapshot")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &SaveSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// LoadSnapshot loads a snapshot of a Cloud Composer environment.
//
// As a result of this operation, a snapshot of environment’s specified in
// LoadSnapshotRequest is loaded into the environment.
func (c *environmentsRESTClient) LoadSnapshot(ctx context.Context, req *servicepb.LoadSnapshotRequest, opts ...gax.CallOption) (*LoadSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:loadSnapshot", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "LoadSnapshot")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &LoadSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DatabaseFailover triggers database failover (only for highly resilient environments).
func (c *environmentsRESTClient) DatabaseFailover(ctx context.Context, req *servicepb.DatabaseFailoverRequest, opts ...gax.CallOption) (*DatabaseFailoverOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:databaseFailover", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DatabaseFailover")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DatabaseFailoverOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// FetchDatabaseProperties fetches database properties.
func (c *environmentsRESTClient) FetchDatabaseProperties(ctx context.Context, req *servicepb.FetchDatabasePropertiesRequest, opts ...gax.CallOption) (*servicepb.FetchDatabasePropertiesResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:fetchDatabaseProperties", req.GetEnvironment())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "environment", url.QueryEscape(req.GetEnvironment()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).FetchDatabaseProperties[0:len((*c.CallOptions).FetchDatabaseProperties):len((*c.CallOptions).FetchDatabaseProperties)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &servicepb.FetchDatabasePropertiesResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "FetchDatabaseProperties")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *environmentsRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *environmentsRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *environmentsRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CheckUpgradeOperation returns a new CheckUpgradeOperation from a given name.
// The name must be that of a previously created CheckUpgradeOperation, possibly from a different process.
func (c *environmentsGRPCClient) CheckUpgradeOperation(name string) *CheckUpgradeOperation {
	return &CheckUpgradeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CheckUpgradeOperation returns a new CheckUpgradeOperation from a given name.
// The name must be that of a previously created CheckUpgradeOperation, possibly from a different process.
func (c *environmentsRESTClient) CheckUpgradeOperation(name string) *CheckUpgradeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CheckUpgradeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateEnvironmentOperation returns a new CreateEnvironmentOperation from a given name.
// The name must be that of a previously created CreateEnvironmentOperation, possibly from a different process.
func (c *environmentsGRPCClient) CreateEnvironmentOperation(name string) *CreateEnvironmentOperation {
	return &CreateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateEnvironmentOperation returns a new CreateEnvironmentOperation from a given name.
// The name must be that of a previously created CreateEnvironmentOperation, possibly from a different process.
func (c *environmentsRESTClient) CreateEnvironmentOperation(name string) *CreateEnvironmentOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DatabaseFailoverOperation returns a new DatabaseFailoverOperation from a given name.
// The name must be that of a previously created DatabaseFailoverOperation, possibly from a different process.
func (c *environmentsGRPCClient) DatabaseFailoverOperation(name string) *DatabaseFailoverOperation {
	return &DatabaseFailoverOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DatabaseFailoverOperation returns a new DatabaseFailoverOperation from a given name.
// The name must be that of a previously created DatabaseFailoverOperation, possibly from a different process.
func (c *environmentsRESTClient) DatabaseFailoverOperation(name string) *DatabaseFailoverOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DatabaseFailoverOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteEnvironmentOperation returns a new DeleteEnvironmentOperation from a given name.
// The name must be that of a previously created DeleteEnvironmentOperation, possibly from a different process.
func (c *environmentsGRPCClient) DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation {
	return &DeleteEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEnvironmentOperation returns a new DeleteEnvironmentOperation from a given name.
// The name must be that of a previously created DeleteEnvironmentOperation, possibly from a different process.
func (c *environmentsRESTClient) DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// LoadSnapshotOperation returns a new LoadSnapshotOperation from a given name.
// The name must be that of a previously created LoadSnapshotOperation, possibly from a different process.
func (c *environmentsGRPCClient) LoadSnapshotOperation(name string) *LoadSnapshotOperation {
	return &LoadSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// LoadSnapshotOperation returns a new LoadSnapshotOperation from a given name.
// The name must be that of a previously created LoadSnapshotOperation, possibly from a different process.
func (c *environmentsRESTClient) LoadSnapshotOperation(name string) *LoadSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &LoadSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// SaveSnapshotOperation returns a new SaveSnapshotOperation from a given name.
// The name must be that of a previously created SaveSnapshotOperation, possibly from a different process.
func (c *environmentsGRPCClient) SaveSnapshotOperation(name string) *SaveSnapshotOperation {
	return &SaveSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SaveSnapshotOperation returns a new SaveSnapshotOperation from a given name.
// The name must be that of a previously created SaveSnapshotOperation, possibly from a different process.
func (c *environmentsRESTClient) SaveSnapshotOperation(name string) *SaveSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &SaveSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateEnvironmentOperation returns a new UpdateEnvironmentOperation from a given name.
// The name must be that of a previously created UpdateEnvironmentOperation, possibly from a different process.
func (c *environmentsGRPCClient) UpdateEnvironmentOperation(name string) *UpdateEnvironmentOperation {
	return &UpdateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateEnvironmentOperation returns a new UpdateEnvironmentOperation from a given name.
// The name must be that of a previously created UpdateEnvironmentOperation, possibly from a different process.
func (c *environmentsRESTClient) UpdateEnvironmentOperation(name string) *UpdateEnvironmentOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateEnvironmentOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
