;; Tests for f64x2 arithmetic operations on major boundary values and all special values.


(module
  (func (export "f64x2.add") (param v128 v128) (result v128) (f64x2.add (local.get 0) (local.get 1)))
  (func (export "f64x2.sub") (param v128 v128) (result v128) (f64x2.sub (local.get 0) (local.get 1)))
  (func (export "f64x2.mul") (param v128 v128) (result v128) (f64x2.mul (local.get 0) (local.get 1)))
  (func (export "f64x2.div") (param v128 v128) (result v128) (f64x2.div (local.get 0) (local.get 1)))
  (func (export "f64x2.neg") (param v128) (result v128) (f64x2.neg (local.get 0)))
  (func (export "f64x2.sqrt") (param v128) (result v128) (f64x2.sqrt (local.get 0)))
)

(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1021 0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1021 -0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.b21fb54442d18p+2 0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.721fb54442d18p+2 -0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.721fb54442d18p+2 0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.b21fb54442d18p+2 -0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.d21fb54442d18p+2 0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.521fb54442d18p+2 -0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.521fb54442d18p+2 0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.d21fb54442d18p+2 -0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.b21fb54442d18p+2 0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.721fb54442d18p+2 0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.d21fb54442d18p+2 0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.521fb54442d18p+2 0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+3 0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.721fb54442d18p+2 -0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.b21fb54442d18p+2 -0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.521fb54442d18p+2 -0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.d21fb54442d18p+2 -0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+3 -0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789 0123456789)
                                   (v128.const f64x2 0123456789 0123456789))
                                   (v128.const f64x2 246913578.0 246913578.0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789e019 0123456789e019)
                                   (v128.const f64x2 0123456789e019 0123456789e019))
                                   (v128.const f64x2 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                   (v128.const f64x2 0123456789e+019 0123456789e+019))
                                   (v128.const f64x2 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                   (v128.const f64x2 0123456789e-019 0123456789e-019))
                                   (v128.const f64x2 2.46913578e-11 2.46913578e-11))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789. 0123456789.)
                                   (v128.const f64x2 0123456789. 0123456789.))
                                   (v128.const f64x2 246913578.0 246913578.0))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                   (v128.const f64x2 0123456789.e019 0123456789.e019))
                                   (v128.const f64x2 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                   (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                   (v128.const f64x2 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                   (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                   (v128.const f64x2 2.46913578e-11 2.46913578e-11))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f64x2 246913578.02469134 246913578.02469134))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f64x2 2.4691357802469137e+27 2.4691357802469137e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f64x2 2.4691357802469137e+27 2.4691357802469137e+27))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f64x2 2.4691357802469137e-11 2.4691357802469137e-11))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.23456789abcdfp+81 0x1.23456789abcdfp+81))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.23456789abcdfp+62 0x1.23456789abcdfp+62))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                   (v128.const f64x2 0x1.23456789abcdfp+81 0x1.23456789abcdfp+81))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                   (v128.const f64x2 0x1.23456789abcdfp+62 0x1.23456789abcdfp+62))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.23456789abcdfp+81 0x1.23456789abcdfp+81))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.23456789abcdfp+100 0x1.23456789abcdfp+100))
(assert_return (invoke "f64x2.add" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.23456789abcdfp+62 0x1.23456789abcdfp+62))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1021 0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.fffffffffffffp-1022 0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.fffffffffffffp-1022 0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1021 -0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000001p-1022 -0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000001p-1022 -0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.721fb54442d18p+2 -0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.b21fb54442d18p+2 0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.b21fb54442d18p+2 -0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.721fb54442d18p+2 0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.521fb54442d18p+2 -0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.d21fb54442d18p+2 0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.d21fb54442d18p+2 -0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.521fb54442d18p+2 0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.721fb54442d18p+2 0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.b21fb54442d18p+2 0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.521fb54442d18p+2 0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.d21fb54442d18p+2 0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+3 0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.b21fb54442d18p+2 -0x1.b21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.721fb54442d18p+2 -0x1.721fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.d21fb54442d18p+2 -0x1.d21fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.521fb54442d18p+2 -0x1.521fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+3 -0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.fffffffffffffp-1022 -0x0.fffffffffffffp-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000001p-1022 0x1.0000000000001p-1022))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789 0123456789)
                                   (v128.const f64x2 0123456789 0123456789))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789e019 0123456789e019)
                                   (v128.const f64x2 0123456789e019 0123456789e019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                   (v128.const f64x2 0123456789e+019 0123456789e+019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                   (v128.const f64x2 0123456789e-019 0123456789e-019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789. 0123456789.)
                                   (v128.const f64x2 0123456789. 0123456789.))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                   (v128.const f64x2 0123456789.e019 0123456789.e019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                   (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                   (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sub" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.8000000000000p-1022 0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.8000000000000p-1022 -0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p-1020 0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p-1020 -0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1 0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1 -0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x0.8000000000000p-1022 -0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.8000000000000p-1022 0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p-1020 -0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p-1020 0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1 -0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1 0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.8000000000000p-1022 0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.8000000000000p-1022 -0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-2 0x1.0000000000000p-2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-2 -0x1.0000000000000p-2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+1 0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+1 -0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1022 0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1022 -0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.8000000000000p-1022 -0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.8000000000000p-1022 0x0.8000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-2 -0x1.0000000000000p-2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-2 0x1.0000000000000p-2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+1 -0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+1 0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1022 -0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1022 0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p-1020 0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p-1020 -0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+1 0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+1 -0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.3bd3cc9be45dep+5 0x1.3bd3cc9be45dep+5))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.3bd3cc9be45dep+5 -0x1.3bd3cc9be45dep+5))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000006p-1022 0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0000000000006p-1022 0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p-1020 -0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p-1020 0x1.921fb54442d18p-1020))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+1 -0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+1 0x1.921fb54442d18p+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.3bd3cc9be45dep+5 -0x1.3bd3cc9be45dep+5))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.3bd3cc9be45dep+5 0x1.3bd3cc9be45dep+5))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000006p-1022 -0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000006p-1022 -0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1 0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1 -0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1022 0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1022 -0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp-51 0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp-51 0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1 -0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1 0x1.fffffffffffffp+1))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1022 -0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1022 0x1.fffffffffffffp+1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp-51 -0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp-51 -0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0000000000006p-1022 0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0000000000006p-1022 -0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp-51 0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp-51 -0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0000000000006p-1022 0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0000000000006p-1022 -0x0.0000000000006p-1022))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp-51 0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp-51 -0x1.fffffffffffffp-51))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789 0123456789)
                                   (v128.const f64x2 0123456789 0123456789))
                                   (v128.const f64x2 1.524157875019052e+16 1.524157875019052e+16))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789e019 0123456789e019)
                                   (v128.const f64x2 0123456789e019 0123456789e019))
                                   (v128.const f64x2 1.524157875019052e+54 1.524157875019052e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                   (v128.const f64x2 0123456789e+019 0123456789e+019))
                                   (v128.const f64x2 1.524157875019052e+54 1.524157875019052e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                   (v128.const f64x2 0123456789e-019 0123456789e-019))
                                   (v128.const f64x2 1.524157875019052e-22 1.524157875019052e-22))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789. 0123456789.)
                                   (v128.const f64x2 0123456789. 0123456789.))
                                   (v128.const f64x2 1.524157875019052e+16 1.524157875019052e+16))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                   (v128.const f64x2 0123456789.e019 0123456789.e019))
                                   (v128.const f64x2 1.524157875019052e+54 1.524157875019052e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                   (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                   (v128.const f64x2 1.524157875019052e+54 1.524157875019052e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                   (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                   (v128.const f64x2 1.524157875019052e-22 1.524157875019052e-22))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f64x2 1.5241578753238834e+16 1.5241578753238834e+16))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f64x2 1.5241578753238838e+54 1.5241578753238838e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f64x2 1.5241578753238838e+54 1.5241578753238838e+54))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f64x2 1.524157875323884e-22 1.524157875323884e-22))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+160 0x1.4b66dc33f6acep+160))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+122 0x1.4b66dc33f6acep+122))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+160 0x1.4b66dc33f6acep+160))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+122 0x1.4b66dc33f6acep+122))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+160 0x1.4b66dc33f6acep+160))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+198 0x1.4b66dc33f6acep+198))
(assert_return (invoke "f64x2.mul" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.4b66dc33f6acep+122 0x1.4b66dc33f6acep+122))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1021 0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1021 -0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.28be60db93910p-1022 0x0.28be60db93910p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.28be60db93910p-1022 -0x0.28be60db93910p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+52 0x1.0000000000000p+52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+52 0x1.0000000000000p+52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1021 -0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1021 0x1.0000000000000p-1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.28be60db93910p-1022 -0x0.28be60db93910p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.28be60db93910p-1022 0x0.28be60db93910p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+52 -0x1.0000000000000p+52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+52 -0x1.0000000000000p+52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+1021 0x1.0000000000000p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+1021 -0x1.0000000000000p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c883p-4 0x1.45f306dc9c883p-4))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c883p-4 -0x1.45f306dc9c883p-4))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.2000000000000p-1022 0x0.2000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.2000000000000p-1022 -0x0.2000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+1021 -0x1.0000000000000p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+1021 0x1.0000000000000p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c883p-4 -0x1.45f306dc9c883p-4))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c883p-4 0x1.45f306dc9c883p-4))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.2000000000000p-1022 -0x0.2000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.2000000000000p-1022 0x0.2000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+1022 0x1.0000000000000p+1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+1022 -0x1.0000000000000p+1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c883p-3 0x1.45f306dc9c883p-3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c883p-3 -0x1.45f306dc9c883p-3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.4000000000000p-1022 0x0.4000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.4000000000000p-1022 -0x0.4000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+1022 -0x1.0000000000000p+1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+1022 0x1.0000000000000p+1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c883p-3 -0x1.45f306dc9c883p-3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c883p-3 0x1.45f306dc9c883p-3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.4000000000000p-1022 -0x0.4000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.4000000000000p-1022 0x0.4000000000000p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+3 0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+3 -0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.921fb54442d19p-1022 0x1.921fb54442d19p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.921fb54442d19p-1022 -0x1.921fb54442d19p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+3 -0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+3 0x1.921fb54442d18p+3))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.921fb54442d19p-1022 -0x1.921fb54442d19p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.921fb54442d19p-1022 0x1.921fb54442d19p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c882p+1021 0x1.45f306dc9c882p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c882p+1021 -0x1.45f306dc9c882p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.45f306dc9c882p+1021 -0x1.45f306dc9c882p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.45f306dc9c882p+1021 0x1.45f306dc9c882p+1021))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-52 0x1.0000000000000p-52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-52 -0x1.0000000000000p-52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0000000000002p-1022 -0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-52 0x1.0000000000000p-52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-52 -0x1.0000000000000p-52))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0000000000002p-1022 0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0000000000002p-1022 -0x0.0000000000002p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789 0123456789)
                                   (v128.const f64x2 0123456789 0123456789))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789e019 0123456789e019)
                                   (v128.const f64x2 0123456789e019 0123456789e019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                   (v128.const f64x2 0123456789e+019 0123456789e+019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                   (v128.const f64x2 0123456789e-019 0123456789e-019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789. 0123456789.)
                                   (v128.const f64x2 0123456789. 0123456789.))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                   (v128.const f64x2 0123456789.e019 0123456789.e019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                   (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                   (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.div" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                   (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-511 0x1.0000000000000p-511))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.6a09e667f3bcdp-1 0x1.6a09e667f3bcdp-1))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.40d931ff62705p+1 0x1.40d931ff62705p+1))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+511 0x1.fffffffffffffp+511))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-537 0x1.0000000000000p-537))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-537 0x1.0000000000000p-537))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 nan nan))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 11111.111060555555 11111.111060555555))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 35136418286444.62 35136418286444.62))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 35136418286444.62 35136418286444.62))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 3.5136418286444623e-06 3.5136418286444623e-06))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 11111.111060555555 11111.111060555555))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 35136418286444.62 35136418286444.62))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 35136418286444.62 35136418286444.62))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 3.5136418286444623e-06 3.5136418286444623e-06))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 11111.11106111111 11111.11106111111))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 35136418288201.445 35136418288201.445))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 35136418288201.445 35136418288201.445))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 3.513641828820144e-06 3.513641828820144e-06))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.1111111111111p+40 0x1.1111111111111p+40))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+30 0x1.822cb17ff2eb8p+30))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.1111111111111p+40 0x1.1111111111111p+40))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+30 0x1.822cb17ff2eb8p+30))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.1111111111111p+40 0x1.1111111111111p+40))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+49 0x1.822cb17ff2eb8p+49))
(assert_return (invoke "f64x2.sqrt" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.822cb17ff2eb8p+30 0x1.822cb17ff2eb8p+30))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 nan nan))
                                   (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789 0123456789))
                                   (v128.const f64x2 -123456789.0 -123456789.0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789e019 0123456789e019))
                                   (v128.const f64x2 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                   (v128.const f64x2 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                   (v128.const f64x2 -1.23456789e-11 -1.23456789e-11))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789. 0123456789.))
                                   (v128.const f64x2 -123456789.0 -123456789.0))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                   (v128.const f64x2 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                   (v128.const f64x2 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                   (v128.const f64x2 -1.23456789e-11 -1.23456789e-11))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f64x2 -123456789.01234567 -123456789.01234567))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f64x2 -1.2345678901234569e+27 -1.2345678901234569e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f64x2 -1.2345678901234569e+27 -1.2345678901234569e+27))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f64x2 -1.2345678901234568e-11 -1.2345678901234568e-11))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                   (v128.const f64x2 -0x1.23456789abcdfp+80 -0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+61 -0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                   (v128.const f64x2 -0x1.23456789abcdfp+80 -0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+61 -0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                   (v128.const f64x2 -0x1.23456789abcdfp+80 -0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+99 -0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.neg" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                   (v128.const f64x2 -0x1.23456789abcdfp+61 -0x1.23456789abcdfp+61))

;; Mixed f64x2 tests when some lanes are NaNs
(module
  (func (export "f64x2_add_arith") (result v128)
    (f64x2.add (v128.const f64x2 nan:0x8000000000000 1.0) (v128.const f64x2 nan 1.0)))
  (func (export "f64x2_div_mixed") (result v128)
    (f64x2.div (v128.const f64x2 nan 1.0) (v128.const f64x2 2.0 -nan:0x8000000000000)))
  (func (export "f64x2_mul_mixed") (result v128)
    (f64x2.mul (v128.const f64x2 nan:0x8000000000000 1.0) (v128.const f64x2 2.0 nan)))
  (func (export "f64x2_neg_canon") (result v128)
    (f64x2.neg (v128.const f64x2 nan 1.0)))
  (func (export "f64x2_sqrt_canon") (result v128)
    (f64x2.sqrt (v128.const f64x2 4.0 -nan)))
  (func (export "f64x2_sub_arith") (result v128)
    (f64x2.sub (v128.const f64x2 1.0 -1.0) (v128.const f64x2 -nan 1.0)))
)

(assert_return (invoke "f64x2_add_arith") (v128.const f64x2 nan:arithmetic 2.0))
(assert_return (invoke "f64x2_div_mixed") (v128.const f64x2 nan:canonical nan:arithmetic))
(assert_return (invoke "f64x2_mul_mixed") (v128.const f64x2 nan:arithmetic nan:canonical))
(assert_return (invoke "f64x2_neg_canon") (v128.const f64x2 nan:canonical -1.0))
(assert_return (invoke "f64x2_sqrt_canon") (v128.const f64x2 2.0 nan:canonical))
(assert_return (invoke "f64x2_sub_arith") (v128.const f64x2 nan:canonical -2.0))

;; type check
(assert_invalid (module (func (result v128) (f64x2.neg (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.sqrt (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.add (i64.const 0) (f64.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.sub (i64.const 0) (f64.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.mul (i64.const 0) (f64.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.div (i64.const 0) (f64.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f64x2.neg-arg-empty (result v128)
      (f64x2.neg)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.sqrt-arg-empty (result v128)
      (f64x2.sqrt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.add-1st-arg-empty (result v128)
      (f64x2.add (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.add-arg-empty (result v128)
      (f64x2.add)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.sub-1st-arg-empty (result v128)
      (f64x2.sub (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.sub-arg-empty (result v128)
      (f64x2.sub)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.mul-1st-arg-empty (result v128)
      (f64x2.mul (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.mul-arg-empty (result v128)
      (f64x2.mul)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.div-1st-arg-empty (result v128)
      (f64x2.div (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.div-arg-empty (result v128)
      (f64x2.div)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (f64x2.add (f64x2.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-add") (param v128 v128 v128) (result v128)
    (f64x2.div (f64x2.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-mul") (param v128 v128 v128) (result v128)
    (f64x2.div (f64x2.mul (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-sub") (param v128 v128 v128) (result v128)
    (f64x2.div (f64x2.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-add") (param v128 v128 v128) (result v128)
    (f64x2.mul (f64x2.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-div") (param v128 v128 v128) (result v128)
    (f64x2.mul (f64x2.div (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-sub") (param v128 v128 v128) (result v128)
    (f64x2.mul (f64x2.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (f64x2.sub (f64x2.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (f64x2.add (f64x2.neg (local.get 0)) (local.get 1)))
  (func (export "add-sqrt") (param v128 v128) (result v128)
    (f64x2.add (f64x2.sqrt (local.get 0)) (local.get 1)))
  (func (export "div-neg") (param v128 v128) (result v128)
    (f64x2.div (f64x2.neg (local.get 0)) (local.get 1)))
  (func (export "div-sqrt") (param v128 v128) (result v128)
    (f64x2.div (f64x2.sqrt (local.get 0)) (local.get 1)))
  (func (export "mul-neg") (param v128 v128) (result v128)
    (f64x2.mul (f64x2.neg (local.get 0)) (local.get 1)))
  (func (export "mul-sqrt") (param v128 v128) (result v128)
    (f64x2.mul (f64x2.sqrt (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (f64x2.sub (f64x2.neg (local.get 0)) (local.get 1)))
  (func (export "sub-sqrt") (param v128 v128) (result v128)
    (f64x2.sub (f64x2.sqrt (local.get 0)) (local.get 1)))
)

(assert_return (invoke "add-sub" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.25 0.25)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 1.0 1.0))
(assert_return (invoke "div-add" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 5.0 5.0))
(assert_return (invoke "div-mul" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 4 4)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 18.0 18.0))
(assert_return (invoke "div-sub" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 4.0 4.0))
(assert_return (invoke "mul-add" (v128.const f64x2 1.25 1.25)
                                 (v128.const f64x2 0.25 0.25)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 0.375 0.375))
(assert_return (invoke "mul-div" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 2.25 2.25))
(assert_return (invoke "mul-sub" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 0.25 0.25))
(assert_return (invoke "sub-add" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.25 0.25)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 1.25 1.25))
(assert_return (invoke "add-neg" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 -1.0 -1.0))
(assert_return (invoke "add-sqrt" (v128.const f64x2 2.25 2.25)
                                  (v128.const f64x2 0.25 0.25))
                                  (v128.const f64x2 1.75 1.75))
(assert_return (invoke "div-neg" (v128.const f64x2 1.5 1.5)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 -6 -6))
(assert_return (invoke "div-sqrt" (v128.const f64x2 2.25 2.25)
                                  (v128.const f64x2 0.25 0.25))
                                  (v128.const f64x2 6 6))
(assert_return (invoke "mul-neg" (v128.const f64x2 1.5 1.5)
                                 (v128.const f64x2 0.25 0.25))
                                 (v128.const f64x2 -0.375 -0.375))
(assert_return (invoke "mul-sqrt" (v128.const f64x2 2.25 2.25)
                                  (v128.const f64x2 0.25 0.25))
                                  (v128.const f64x2 0.375 0.375))
(assert_return (invoke "sub-neg" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 -1.25 -1.25))
(assert_return (invoke "sub-sqrt" (v128.const f64x2 2.25 2.25)
                                  (v128.const f64x2 0.25 0.25))
                                  (v128.const f64x2 1.25 1.25))