// Code generated by go-swagger; DO NOT EDIT.

package modelscapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BlocklistLink blocklist link
//
// swagger:model BlocklistLink
type BlocklistLink struct {

	// duration
	// Required: true
	Duration *string `json:"duration"`

	// the name of the blocklist
	// Required: true
	Name *string `json:"name"`

	// the remediation that should be used for the blocklist
	// Required: true
	Remediation *string `json:"remediation"`

	// the scope of decisions in the blocklist
	// Required: true
	Scope *string `json:"scope"`

	// the url from which the blocklist content can be downloaded
	// Required: true
	URL *string `json:"url"`
}

// Validate validates this blocklist link
func (m *BlocklistLink) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemediation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateURL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BlocklistLink) validateDuration(formats strfmt.Registry) error {

	if err := validate.Required("duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *BlocklistLink) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *BlocklistLink) validateRemediation(formats strfmt.Registry) error {

	if err := validate.Required("remediation", "body", m.Remediation); err != nil {
		return err
	}

	return nil
}

func (m *BlocklistLink) validateScope(formats strfmt.Registry) error {

	if err := validate.Required("scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *BlocklistLink) validateURL(formats strfmt.Registry) error {

	if err := validate.Required("url", "body", m.URL); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this blocklist link based on context it is used
func (m *BlocklistLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BlocklistLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BlocklistLink) UnmarshalBinary(b []byte) error {
	var res BlocklistLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
