// Code generated by 'go generate'; DO NOT EDIT.

package certstore

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modadvapi32 = windows.NewLazySystemDLL("advapi32.dll")
	modncrypt   = windows.NewLazySystemDLL("ncrypt.dll")

	procCryptCreateHash   = modadvapi32.NewProc("CryptCreateHash")
	procCryptDestroyHash  = modadvapi32.NewProc("CryptDestroyHash")
	procCryptGetHashParam = modadvapi32.NewProc("CryptGetHashParam")
	procCryptGetProvParam = modadvapi32.NewProc("CryptGetProvParam")
	procCryptSetHashParam = modadvapi32.NewProc("CryptSetHashParam")
	procCryptSetProvParam = modadvapi32.NewProc("CryptSetProvParam")
	procCryptSignHashW    = modadvapi32.NewProc("CryptSignHashW")
	procNCryptDeleteKey   = modncrypt.NewProc("NCryptDeleteKey")
	procNCryptFreeObject  = modncrypt.NewProc("NCryptFreeObject")
	procNCryptSignHash    = modncrypt.NewProc("NCryptSignHash")
)

func cryptCreateHash(hProv cryptProviderHandle, Algid cryptAlgorithm, hKey cryptKeyHandle, dwFlags uint32, phHash *cryptHashHandle) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptCreateHash.Addr(), 5, uintptr(hProv), uintptr(Algid), uintptr(hKey), uintptr(dwFlags), uintptr(unsafe.Pointer(phHash)), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptDestroyHash(hHash cryptHashHandle) (err error) {
	r1, _, e1 := syscall.Syscall(procCryptDestroyHash.Addr(), 1, uintptr(hHash), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptGetHashParam(hHash cryptHashHandle, dwParam uint32, pbData unsafe.Pointer, pdwDataLen *uint32, dwFlags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptGetHashParam.Addr(), 5, uintptr(hHash), uintptr(dwParam), uintptr(pbData), uintptr(unsafe.Pointer(pdwDataLen)), uintptr(dwFlags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptGetProvParam(hProv cryptProviderHandle, dwParam uint32, pbData *byte, pdwDataLen *uint32, dwFlags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptGetProvParam.Addr(), 5, uintptr(hProv), uintptr(dwParam), uintptr(unsafe.Pointer(pbData)), uintptr(unsafe.Pointer(pdwDataLen)), uintptr(dwFlags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptSetHashParam(hHash cryptHashHandle, dwParam uint32, pbData unsafe.Pointer, dwFlags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptSetHashParam.Addr(), 4, uintptr(hHash), uintptr(dwParam), uintptr(pbData), uintptr(dwFlags), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptSetProvParam(hProv cryptProviderHandle, dwParam uint32, pbData *byte, dwFlags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptSetProvParam.Addr(), 4, uintptr(hProv), uintptr(dwParam), uintptr(unsafe.Pointer(pbData)), uintptr(dwFlags), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func cryptSignHash(hHash cryptHashHandle, dwKeySpec uint32, szDescription *uint16, dwFlags uint32, pbSignature *byte, pdwSigLen *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptSignHashW.Addr(), 6, uintptr(hHash), uintptr(dwKeySpec), uintptr(unsafe.Pointer(szDescription)), uintptr(dwFlags), uintptr(unsafe.Pointer(pbSignature)), uintptr(unsafe.Pointer(pdwSigLen)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func nCryptDeleteKey(hKey nCryptKeyHandle, dwFlags uint32) (ret error) {
	r0, _, _ := syscall.Syscall(procNCryptDeleteKey.Addr(), 2, uintptr(hKey), uintptr(dwFlags), 0)
	if r0 != 0 {
		ret = syscall.Errno(r0)
	}
	return
}

func nCryptFreeObject(hObject windows.Handle) (ret error) {
	r0, _, _ := syscall.Syscall(procNCryptFreeObject.Addr(), 1, uintptr(hObject), 0, 0)
	if r0 != 0 {
		ret = syscall.Errno(r0)
	}
	return
}

func nCryptSignHash(hKey nCryptKeyHandle, pPaddingInfo unsafe.Pointer, pbHashValue *byte, cbHashValue uint32, pbSignature *byte, cbSignature uint32, pcbResult *uint32, dwFlags uint32) (ret error) {
	r0, _, _ := syscall.Syscall9(procNCryptSignHash.Addr(), 8, uintptr(hKey), uintptr(pPaddingInfo), uintptr(unsafe.Pointer(pbHashValue)), uintptr(cbHashValue), uintptr(unsafe.Pointer(pbSignature)), uintptr(cbSignature), uintptr(unsafe.Pointer(pcbResult)), uintptr(dwFlags), 0)
	if r0 != 0 {
		ret = syscall.Errno(r0)
	}
	return
}
