// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package rekognitioniface provides an interface to enable mocking the Amazon Rekognition service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package rekognitioniface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/rekognition"
)

// RekognitionAPI provides an interface to enable mocking the
// rekognition.Rekognition service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Rekognition.
//	func myFunc(svc rekognitioniface.RekognitionAPI) bool {
//	    // Make svc.AssociateFaces request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := rekognition.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockRekognitionClient struct {
//	    rekognitioniface.RekognitionAPI
//	}
//	func (m *mockRekognitionClient) AssociateFaces(input *rekognition.AssociateFacesInput) (*rekognition.AssociateFacesOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockRekognitionClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type RekognitionAPI interface {
	AssociateFaces(*rekognition.AssociateFacesInput) (*rekognition.AssociateFacesOutput, error)
	AssociateFacesWithContext(aws.Context, *rekognition.AssociateFacesInput, ...request.Option) (*rekognition.AssociateFacesOutput, error)
	AssociateFacesRequest(*rekognition.AssociateFacesInput) (*request.Request, *rekognition.AssociateFacesOutput)

	CompareFaces(*rekognition.CompareFacesInput) (*rekognition.CompareFacesOutput, error)
	CompareFacesWithContext(aws.Context, *rekognition.CompareFacesInput, ...request.Option) (*rekognition.CompareFacesOutput, error)
	CompareFacesRequest(*rekognition.CompareFacesInput) (*request.Request, *rekognition.CompareFacesOutput)

	CopyProjectVersion(*rekognition.CopyProjectVersionInput) (*rekognition.CopyProjectVersionOutput, error)
	CopyProjectVersionWithContext(aws.Context, *rekognition.CopyProjectVersionInput, ...request.Option) (*rekognition.CopyProjectVersionOutput, error)
	CopyProjectVersionRequest(*rekognition.CopyProjectVersionInput) (*request.Request, *rekognition.CopyProjectVersionOutput)

	CreateCollection(*rekognition.CreateCollectionInput) (*rekognition.CreateCollectionOutput, error)
	CreateCollectionWithContext(aws.Context, *rekognition.CreateCollectionInput, ...request.Option) (*rekognition.CreateCollectionOutput, error)
	CreateCollectionRequest(*rekognition.CreateCollectionInput) (*request.Request, *rekognition.CreateCollectionOutput)

	CreateDataset(*rekognition.CreateDatasetInput) (*rekognition.CreateDatasetOutput, error)
	CreateDatasetWithContext(aws.Context, *rekognition.CreateDatasetInput, ...request.Option) (*rekognition.CreateDatasetOutput, error)
	CreateDatasetRequest(*rekognition.CreateDatasetInput) (*request.Request, *rekognition.CreateDatasetOutput)

	CreateFaceLivenessSession(*rekognition.CreateFaceLivenessSessionInput) (*rekognition.CreateFaceLivenessSessionOutput, error)
	CreateFaceLivenessSessionWithContext(aws.Context, *rekognition.CreateFaceLivenessSessionInput, ...request.Option) (*rekognition.CreateFaceLivenessSessionOutput, error)
	CreateFaceLivenessSessionRequest(*rekognition.CreateFaceLivenessSessionInput) (*request.Request, *rekognition.CreateFaceLivenessSessionOutput)

	CreateProject(*rekognition.CreateProjectInput) (*rekognition.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *rekognition.CreateProjectInput, ...request.Option) (*rekognition.CreateProjectOutput, error)
	CreateProjectRequest(*rekognition.CreateProjectInput) (*request.Request, *rekognition.CreateProjectOutput)

	CreateProjectVersion(*rekognition.CreateProjectVersionInput) (*rekognition.CreateProjectVersionOutput, error)
	CreateProjectVersionWithContext(aws.Context, *rekognition.CreateProjectVersionInput, ...request.Option) (*rekognition.CreateProjectVersionOutput, error)
	CreateProjectVersionRequest(*rekognition.CreateProjectVersionInput) (*request.Request, *rekognition.CreateProjectVersionOutput)

	CreateStreamProcessor(*rekognition.CreateStreamProcessorInput) (*rekognition.CreateStreamProcessorOutput, error)
	CreateStreamProcessorWithContext(aws.Context, *rekognition.CreateStreamProcessorInput, ...request.Option) (*rekognition.CreateStreamProcessorOutput, error)
	CreateStreamProcessorRequest(*rekognition.CreateStreamProcessorInput) (*request.Request, *rekognition.CreateStreamProcessorOutput)

	CreateUser(*rekognition.CreateUserInput) (*rekognition.CreateUserOutput, error)
	CreateUserWithContext(aws.Context, *rekognition.CreateUserInput, ...request.Option) (*rekognition.CreateUserOutput, error)
	CreateUserRequest(*rekognition.CreateUserInput) (*request.Request, *rekognition.CreateUserOutput)

	DeleteCollection(*rekognition.DeleteCollectionInput) (*rekognition.DeleteCollectionOutput, error)
	DeleteCollectionWithContext(aws.Context, *rekognition.DeleteCollectionInput, ...request.Option) (*rekognition.DeleteCollectionOutput, error)
	DeleteCollectionRequest(*rekognition.DeleteCollectionInput) (*request.Request, *rekognition.DeleteCollectionOutput)

	DeleteDataset(*rekognition.DeleteDatasetInput) (*rekognition.DeleteDatasetOutput, error)
	DeleteDatasetWithContext(aws.Context, *rekognition.DeleteDatasetInput, ...request.Option) (*rekognition.DeleteDatasetOutput, error)
	DeleteDatasetRequest(*rekognition.DeleteDatasetInput) (*request.Request, *rekognition.DeleteDatasetOutput)

	DeleteFaces(*rekognition.DeleteFacesInput) (*rekognition.DeleteFacesOutput, error)
	DeleteFacesWithContext(aws.Context, *rekognition.DeleteFacesInput, ...request.Option) (*rekognition.DeleteFacesOutput, error)
	DeleteFacesRequest(*rekognition.DeleteFacesInput) (*request.Request, *rekognition.DeleteFacesOutput)

	DeleteProject(*rekognition.DeleteProjectInput) (*rekognition.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *rekognition.DeleteProjectInput, ...request.Option) (*rekognition.DeleteProjectOutput, error)
	DeleteProjectRequest(*rekognition.DeleteProjectInput) (*request.Request, *rekognition.DeleteProjectOutput)

	DeleteProjectPolicy(*rekognition.DeleteProjectPolicyInput) (*rekognition.DeleteProjectPolicyOutput, error)
	DeleteProjectPolicyWithContext(aws.Context, *rekognition.DeleteProjectPolicyInput, ...request.Option) (*rekognition.DeleteProjectPolicyOutput, error)
	DeleteProjectPolicyRequest(*rekognition.DeleteProjectPolicyInput) (*request.Request, *rekognition.DeleteProjectPolicyOutput)

	DeleteProjectVersion(*rekognition.DeleteProjectVersionInput) (*rekognition.DeleteProjectVersionOutput, error)
	DeleteProjectVersionWithContext(aws.Context, *rekognition.DeleteProjectVersionInput, ...request.Option) (*rekognition.DeleteProjectVersionOutput, error)
	DeleteProjectVersionRequest(*rekognition.DeleteProjectVersionInput) (*request.Request, *rekognition.DeleteProjectVersionOutput)

	DeleteStreamProcessor(*rekognition.DeleteStreamProcessorInput) (*rekognition.DeleteStreamProcessorOutput, error)
	DeleteStreamProcessorWithContext(aws.Context, *rekognition.DeleteStreamProcessorInput, ...request.Option) (*rekognition.DeleteStreamProcessorOutput, error)
	DeleteStreamProcessorRequest(*rekognition.DeleteStreamProcessorInput) (*request.Request, *rekognition.DeleteStreamProcessorOutput)

	DeleteUser(*rekognition.DeleteUserInput) (*rekognition.DeleteUserOutput, error)
	DeleteUserWithContext(aws.Context, *rekognition.DeleteUserInput, ...request.Option) (*rekognition.DeleteUserOutput, error)
	DeleteUserRequest(*rekognition.DeleteUserInput) (*request.Request, *rekognition.DeleteUserOutput)

	DescribeCollection(*rekognition.DescribeCollectionInput) (*rekognition.DescribeCollectionOutput, error)
	DescribeCollectionWithContext(aws.Context, *rekognition.DescribeCollectionInput, ...request.Option) (*rekognition.DescribeCollectionOutput, error)
	DescribeCollectionRequest(*rekognition.DescribeCollectionInput) (*request.Request, *rekognition.DescribeCollectionOutput)

	DescribeDataset(*rekognition.DescribeDatasetInput) (*rekognition.DescribeDatasetOutput, error)
	DescribeDatasetWithContext(aws.Context, *rekognition.DescribeDatasetInput, ...request.Option) (*rekognition.DescribeDatasetOutput, error)
	DescribeDatasetRequest(*rekognition.DescribeDatasetInput) (*request.Request, *rekognition.DescribeDatasetOutput)

	DescribeProjectVersions(*rekognition.DescribeProjectVersionsInput) (*rekognition.DescribeProjectVersionsOutput, error)
	DescribeProjectVersionsWithContext(aws.Context, *rekognition.DescribeProjectVersionsInput, ...request.Option) (*rekognition.DescribeProjectVersionsOutput, error)
	DescribeProjectVersionsRequest(*rekognition.DescribeProjectVersionsInput) (*request.Request, *rekognition.DescribeProjectVersionsOutput)

	DescribeProjectVersionsPages(*rekognition.DescribeProjectVersionsInput, func(*rekognition.DescribeProjectVersionsOutput, bool) bool) error
	DescribeProjectVersionsPagesWithContext(aws.Context, *rekognition.DescribeProjectVersionsInput, func(*rekognition.DescribeProjectVersionsOutput, bool) bool, ...request.Option) error

	DescribeProjects(*rekognition.DescribeProjectsInput) (*rekognition.DescribeProjectsOutput, error)
	DescribeProjectsWithContext(aws.Context, *rekognition.DescribeProjectsInput, ...request.Option) (*rekognition.DescribeProjectsOutput, error)
	DescribeProjectsRequest(*rekognition.DescribeProjectsInput) (*request.Request, *rekognition.DescribeProjectsOutput)

	DescribeProjectsPages(*rekognition.DescribeProjectsInput, func(*rekognition.DescribeProjectsOutput, bool) bool) error
	DescribeProjectsPagesWithContext(aws.Context, *rekognition.DescribeProjectsInput, func(*rekognition.DescribeProjectsOutput, bool) bool, ...request.Option) error

	DescribeStreamProcessor(*rekognition.DescribeStreamProcessorInput) (*rekognition.DescribeStreamProcessorOutput, error)
	DescribeStreamProcessorWithContext(aws.Context, *rekognition.DescribeStreamProcessorInput, ...request.Option) (*rekognition.DescribeStreamProcessorOutput, error)
	DescribeStreamProcessorRequest(*rekognition.DescribeStreamProcessorInput) (*request.Request, *rekognition.DescribeStreamProcessorOutput)

	DetectCustomLabels(*rekognition.DetectCustomLabelsInput) (*rekognition.DetectCustomLabelsOutput, error)
	DetectCustomLabelsWithContext(aws.Context, *rekognition.DetectCustomLabelsInput, ...request.Option) (*rekognition.DetectCustomLabelsOutput, error)
	DetectCustomLabelsRequest(*rekognition.DetectCustomLabelsInput) (*request.Request, *rekognition.DetectCustomLabelsOutput)

	DetectFaces(*rekognition.DetectFacesInput) (*rekognition.DetectFacesOutput, error)
	DetectFacesWithContext(aws.Context, *rekognition.DetectFacesInput, ...request.Option) (*rekognition.DetectFacesOutput, error)
	DetectFacesRequest(*rekognition.DetectFacesInput) (*request.Request, *rekognition.DetectFacesOutput)

	DetectLabels(*rekognition.DetectLabelsInput) (*rekognition.DetectLabelsOutput, error)
	DetectLabelsWithContext(aws.Context, *rekognition.DetectLabelsInput, ...request.Option) (*rekognition.DetectLabelsOutput, error)
	DetectLabelsRequest(*rekognition.DetectLabelsInput) (*request.Request, *rekognition.DetectLabelsOutput)

	DetectModerationLabels(*rekognition.DetectModerationLabelsInput) (*rekognition.DetectModerationLabelsOutput, error)
	DetectModerationLabelsWithContext(aws.Context, *rekognition.DetectModerationLabelsInput, ...request.Option) (*rekognition.DetectModerationLabelsOutput, error)
	DetectModerationLabelsRequest(*rekognition.DetectModerationLabelsInput) (*request.Request, *rekognition.DetectModerationLabelsOutput)

	DetectProtectiveEquipment(*rekognition.DetectProtectiveEquipmentInput) (*rekognition.DetectProtectiveEquipmentOutput, error)
	DetectProtectiveEquipmentWithContext(aws.Context, *rekognition.DetectProtectiveEquipmentInput, ...request.Option) (*rekognition.DetectProtectiveEquipmentOutput, error)
	DetectProtectiveEquipmentRequest(*rekognition.DetectProtectiveEquipmentInput) (*request.Request, *rekognition.DetectProtectiveEquipmentOutput)

	DetectText(*rekognition.DetectTextInput) (*rekognition.DetectTextOutput, error)
	DetectTextWithContext(aws.Context, *rekognition.DetectTextInput, ...request.Option) (*rekognition.DetectTextOutput, error)
	DetectTextRequest(*rekognition.DetectTextInput) (*request.Request, *rekognition.DetectTextOutput)

	DisassociateFaces(*rekognition.DisassociateFacesInput) (*rekognition.DisassociateFacesOutput, error)
	DisassociateFacesWithContext(aws.Context, *rekognition.DisassociateFacesInput, ...request.Option) (*rekognition.DisassociateFacesOutput, error)
	DisassociateFacesRequest(*rekognition.DisassociateFacesInput) (*request.Request, *rekognition.DisassociateFacesOutput)

	DistributeDatasetEntries(*rekognition.DistributeDatasetEntriesInput) (*rekognition.DistributeDatasetEntriesOutput, error)
	DistributeDatasetEntriesWithContext(aws.Context, *rekognition.DistributeDatasetEntriesInput, ...request.Option) (*rekognition.DistributeDatasetEntriesOutput, error)
	DistributeDatasetEntriesRequest(*rekognition.DistributeDatasetEntriesInput) (*request.Request, *rekognition.DistributeDatasetEntriesOutput)

	GetCelebrityInfo(*rekognition.GetCelebrityInfoInput) (*rekognition.GetCelebrityInfoOutput, error)
	GetCelebrityInfoWithContext(aws.Context, *rekognition.GetCelebrityInfoInput, ...request.Option) (*rekognition.GetCelebrityInfoOutput, error)
	GetCelebrityInfoRequest(*rekognition.GetCelebrityInfoInput) (*request.Request, *rekognition.GetCelebrityInfoOutput)

	GetCelebrityRecognition(*rekognition.GetCelebrityRecognitionInput) (*rekognition.GetCelebrityRecognitionOutput, error)
	GetCelebrityRecognitionWithContext(aws.Context, *rekognition.GetCelebrityRecognitionInput, ...request.Option) (*rekognition.GetCelebrityRecognitionOutput, error)
	GetCelebrityRecognitionRequest(*rekognition.GetCelebrityRecognitionInput) (*request.Request, *rekognition.GetCelebrityRecognitionOutput)

	GetCelebrityRecognitionPages(*rekognition.GetCelebrityRecognitionInput, func(*rekognition.GetCelebrityRecognitionOutput, bool) bool) error
	GetCelebrityRecognitionPagesWithContext(aws.Context, *rekognition.GetCelebrityRecognitionInput, func(*rekognition.GetCelebrityRecognitionOutput, bool) bool, ...request.Option) error

	GetContentModeration(*rekognition.GetContentModerationInput) (*rekognition.GetContentModerationOutput, error)
	GetContentModerationWithContext(aws.Context, *rekognition.GetContentModerationInput, ...request.Option) (*rekognition.GetContentModerationOutput, error)
	GetContentModerationRequest(*rekognition.GetContentModerationInput) (*request.Request, *rekognition.GetContentModerationOutput)

	GetContentModerationPages(*rekognition.GetContentModerationInput, func(*rekognition.GetContentModerationOutput, bool) bool) error
	GetContentModerationPagesWithContext(aws.Context, *rekognition.GetContentModerationInput, func(*rekognition.GetContentModerationOutput, bool) bool, ...request.Option) error

	GetFaceDetection(*rekognition.GetFaceDetectionInput) (*rekognition.GetFaceDetectionOutput, error)
	GetFaceDetectionWithContext(aws.Context, *rekognition.GetFaceDetectionInput, ...request.Option) (*rekognition.GetFaceDetectionOutput, error)
	GetFaceDetectionRequest(*rekognition.GetFaceDetectionInput) (*request.Request, *rekognition.GetFaceDetectionOutput)

	GetFaceDetectionPages(*rekognition.GetFaceDetectionInput, func(*rekognition.GetFaceDetectionOutput, bool) bool) error
	GetFaceDetectionPagesWithContext(aws.Context, *rekognition.GetFaceDetectionInput, func(*rekognition.GetFaceDetectionOutput, bool) bool, ...request.Option) error

	GetFaceLivenessSessionResults(*rekognition.GetFaceLivenessSessionResultsInput) (*rekognition.GetFaceLivenessSessionResultsOutput, error)
	GetFaceLivenessSessionResultsWithContext(aws.Context, *rekognition.GetFaceLivenessSessionResultsInput, ...request.Option) (*rekognition.GetFaceLivenessSessionResultsOutput, error)
	GetFaceLivenessSessionResultsRequest(*rekognition.GetFaceLivenessSessionResultsInput) (*request.Request, *rekognition.GetFaceLivenessSessionResultsOutput)

	GetFaceSearch(*rekognition.GetFaceSearchInput) (*rekognition.GetFaceSearchOutput, error)
	GetFaceSearchWithContext(aws.Context, *rekognition.GetFaceSearchInput, ...request.Option) (*rekognition.GetFaceSearchOutput, error)
	GetFaceSearchRequest(*rekognition.GetFaceSearchInput) (*request.Request, *rekognition.GetFaceSearchOutput)

	GetFaceSearchPages(*rekognition.GetFaceSearchInput, func(*rekognition.GetFaceSearchOutput, bool) bool) error
	GetFaceSearchPagesWithContext(aws.Context, *rekognition.GetFaceSearchInput, func(*rekognition.GetFaceSearchOutput, bool) bool, ...request.Option) error

	GetLabelDetection(*rekognition.GetLabelDetectionInput) (*rekognition.GetLabelDetectionOutput, error)
	GetLabelDetectionWithContext(aws.Context, *rekognition.GetLabelDetectionInput, ...request.Option) (*rekognition.GetLabelDetectionOutput, error)
	GetLabelDetectionRequest(*rekognition.GetLabelDetectionInput) (*request.Request, *rekognition.GetLabelDetectionOutput)

	GetLabelDetectionPages(*rekognition.GetLabelDetectionInput, func(*rekognition.GetLabelDetectionOutput, bool) bool) error
	GetLabelDetectionPagesWithContext(aws.Context, *rekognition.GetLabelDetectionInput, func(*rekognition.GetLabelDetectionOutput, bool) bool, ...request.Option) error

	GetPersonTracking(*rekognition.GetPersonTrackingInput) (*rekognition.GetPersonTrackingOutput, error)
	GetPersonTrackingWithContext(aws.Context, *rekognition.GetPersonTrackingInput, ...request.Option) (*rekognition.GetPersonTrackingOutput, error)
	GetPersonTrackingRequest(*rekognition.GetPersonTrackingInput) (*request.Request, *rekognition.GetPersonTrackingOutput)

	GetPersonTrackingPages(*rekognition.GetPersonTrackingInput, func(*rekognition.GetPersonTrackingOutput, bool) bool) error
	GetPersonTrackingPagesWithContext(aws.Context, *rekognition.GetPersonTrackingInput, func(*rekognition.GetPersonTrackingOutput, bool) bool, ...request.Option) error

	GetSegmentDetection(*rekognition.GetSegmentDetectionInput) (*rekognition.GetSegmentDetectionOutput, error)
	GetSegmentDetectionWithContext(aws.Context, *rekognition.GetSegmentDetectionInput, ...request.Option) (*rekognition.GetSegmentDetectionOutput, error)
	GetSegmentDetectionRequest(*rekognition.GetSegmentDetectionInput) (*request.Request, *rekognition.GetSegmentDetectionOutput)

	GetSegmentDetectionPages(*rekognition.GetSegmentDetectionInput, func(*rekognition.GetSegmentDetectionOutput, bool) bool) error
	GetSegmentDetectionPagesWithContext(aws.Context, *rekognition.GetSegmentDetectionInput, func(*rekognition.GetSegmentDetectionOutput, bool) bool, ...request.Option) error

	GetTextDetection(*rekognition.GetTextDetectionInput) (*rekognition.GetTextDetectionOutput, error)
	GetTextDetectionWithContext(aws.Context, *rekognition.GetTextDetectionInput, ...request.Option) (*rekognition.GetTextDetectionOutput, error)
	GetTextDetectionRequest(*rekognition.GetTextDetectionInput) (*request.Request, *rekognition.GetTextDetectionOutput)

	GetTextDetectionPages(*rekognition.GetTextDetectionInput, func(*rekognition.GetTextDetectionOutput, bool) bool) error
	GetTextDetectionPagesWithContext(aws.Context, *rekognition.GetTextDetectionInput, func(*rekognition.GetTextDetectionOutput, bool) bool, ...request.Option) error

	IndexFaces(*rekognition.IndexFacesInput) (*rekognition.IndexFacesOutput, error)
	IndexFacesWithContext(aws.Context, *rekognition.IndexFacesInput, ...request.Option) (*rekognition.IndexFacesOutput, error)
	IndexFacesRequest(*rekognition.IndexFacesInput) (*request.Request, *rekognition.IndexFacesOutput)

	ListCollections(*rekognition.ListCollectionsInput) (*rekognition.ListCollectionsOutput, error)
	ListCollectionsWithContext(aws.Context, *rekognition.ListCollectionsInput, ...request.Option) (*rekognition.ListCollectionsOutput, error)
	ListCollectionsRequest(*rekognition.ListCollectionsInput) (*request.Request, *rekognition.ListCollectionsOutput)

	ListCollectionsPages(*rekognition.ListCollectionsInput, func(*rekognition.ListCollectionsOutput, bool) bool) error
	ListCollectionsPagesWithContext(aws.Context, *rekognition.ListCollectionsInput, func(*rekognition.ListCollectionsOutput, bool) bool, ...request.Option) error

	ListDatasetEntries(*rekognition.ListDatasetEntriesInput) (*rekognition.ListDatasetEntriesOutput, error)
	ListDatasetEntriesWithContext(aws.Context, *rekognition.ListDatasetEntriesInput, ...request.Option) (*rekognition.ListDatasetEntriesOutput, error)
	ListDatasetEntriesRequest(*rekognition.ListDatasetEntriesInput) (*request.Request, *rekognition.ListDatasetEntriesOutput)

	ListDatasetEntriesPages(*rekognition.ListDatasetEntriesInput, func(*rekognition.ListDatasetEntriesOutput, bool) bool) error
	ListDatasetEntriesPagesWithContext(aws.Context, *rekognition.ListDatasetEntriesInput, func(*rekognition.ListDatasetEntriesOutput, bool) bool, ...request.Option) error

	ListDatasetLabels(*rekognition.ListDatasetLabelsInput) (*rekognition.ListDatasetLabelsOutput, error)
	ListDatasetLabelsWithContext(aws.Context, *rekognition.ListDatasetLabelsInput, ...request.Option) (*rekognition.ListDatasetLabelsOutput, error)
	ListDatasetLabelsRequest(*rekognition.ListDatasetLabelsInput) (*request.Request, *rekognition.ListDatasetLabelsOutput)

	ListDatasetLabelsPages(*rekognition.ListDatasetLabelsInput, func(*rekognition.ListDatasetLabelsOutput, bool) bool) error
	ListDatasetLabelsPagesWithContext(aws.Context, *rekognition.ListDatasetLabelsInput, func(*rekognition.ListDatasetLabelsOutput, bool) bool, ...request.Option) error

	ListFaces(*rekognition.ListFacesInput) (*rekognition.ListFacesOutput, error)
	ListFacesWithContext(aws.Context, *rekognition.ListFacesInput, ...request.Option) (*rekognition.ListFacesOutput, error)
	ListFacesRequest(*rekognition.ListFacesInput) (*request.Request, *rekognition.ListFacesOutput)

	ListFacesPages(*rekognition.ListFacesInput, func(*rekognition.ListFacesOutput, bool) bool) error
	ListFacesPagesWithContext(aws.Context, *rekognition.ListFacesInput, func(*rekognition.ListFacesOutput, bool) bool, ...request.Option) error

	ListProjectPolicies(*rekognition.ListProjectPoliciesInput) (*rekognition.ListProjectPoliciesOutput, error)
	ListProjectPoliciesWithContext(aws.Context, *rekognition.ListProjectPoliciesInput, ...request.Option) (*rekognition.ListProjectPoliciesOutput, error)
	ListProjectPoliciesRequest(*rekognition.ListProjectPoliciesInput) (*request.Request, *rekognition.ListProjectPoliciesOutput)

	ListProjectPoliciesPages(*rekognition.ListProjectPoliciesInput, func(*rekognition.ListProjectPoliciesOutput, bool) bool) error
	ListProjectPoliciesPagesWithContext(aws.Context, *rekognition.ListProjectPoliciesInput, func(*rekognition.ListProjectPoliciesOutput, bool) bool, ...request.Option) error

	ListStreamProcessors(*rekognition.ListStreamProcessorsInput) (*rekognition.ListStreamProcessorsOutput, error)
	ListStreamProcessorsWithContext(aws.Context, *rekognition.ListStreamProcessorsInput, ...request.Option) (*rekognition.ListStreamProcessorsOutput, error)
	ListStreamProcessorsRequest(*rekognition.ListStreamProcessorsInput) (*request.Request, *rekognition.ListStreamProcessorsOutput)

	ListStreamProcessorsPages(*rekognition.ListStreamProcessorsInput, func(*rekognition.ListStreamProcessorsOutput, bool) bool) error
	ListStreamProcessorsPagesWithContext(aws.Context, *rekognition.ListStreamProcessorsInput, func(*rekognition.ListStreamProcessorsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*rekognition.ListTagsForResourceInput) (*rekognition.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *rekognition.ListTagsForResourceInput, ...request.Option) (*rekognition.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*rekognition.ListTagsForResourceInput) (*request.Request, *rekognition.ListTagsForResourceOutput)

	ListUsers(*rekognition.ListUsersInput) (*rekognition.ListUsersOutput, error)
	ListUsersWithContext(aws.Context, *rekognition.ListUsersInput, ...request.Option) (*rekognition.ListUsersOutput, error)
	ListUsersRequest(*rekognition.ListUsersInput) (*request.Request, *rekognition.ListUsersOutput)

	ListUsersPages(*rekognition.ListUsersInput, func(*rekognition.ListUsersOutput, bool) bool) error
	ListUsersPagesWithContext(aws.Context, *rekognition.ListUsersInput, func(*rekognition.ListUsersOutput, bool) bool, ...request.Option) error

	PutProjectPolicy(*rekognition.PutProjectPolicyInput) (*rekognition.PutProjectPolicyOutput, error)
	PutProjectPolicyWithContext(aws.Context, *rekognition.PutProjectPolicyInput, ...request.Option) (*rekognition.PutProjectPolicyOutput, error)
	PutProjectPolicyRequest(*rekognition.PutProjectPolicyInput) (*request.Request, *rekognition.PutProjectPolicyOutput)

	RecognizeCelebrities(*rekognition.RecognizeCelebritiesInput) (*rekognition.RecognizeCelebritiesOutput, error)
	RecognizeCelebritiesWithContext(aws.Context, *rekognition.RecognizeCelebritiesInput, ...request.Option) (*rekognition.RecognizeCelebritiesOutput, error)
	RecognizeCelebritiesRequest(*rekognition.RecognizeCelebritiesInput) (*request.Request, *rekognition.RecognizeCelebritiesOutput)

	SearchFaces(*rekognition.SearchFacesInput) (*rekognition.SearchFacesOutput, error)
	SearchFacesWithContext(aws.Context, *rekognition.SearchFacesInput, ...request.Option) (*rekognition.SearchFacesOutput, error)
	SearchFacesRequest(*rekognition.SearchFacesInput) (*request.Request, *rekognition.SearchFacesOutput)

	SearchFacesByImage(*rekognition.SearchFacesByImageInput) (*rekognition.SearchFacesByImageOutput, error)
	SearchFacesByImageWithContext(aws.Context, *rekognition.SearchFacesByImageInput, ...request.Option) (*rekognition.SearchFacesByImageOutput, error)
	SearchFacesByImageRequest(*rekognition.SearchFacesByImageInput) (*request.Request, *rekognition.SearchFacesByImageOutput)

	SearchUsers(*rekognition.SearchUsersInput) (*rekognition.SearchUsersOutput, error)
	SearchUsersWithContext(aws.Context, *rekognition.SearchUsersInput, ...request.Option) (*rekognition.SearchUsersOutput, error)
	SearchUsersRequest(*rekognition.SearchUsersInput) (*request.Request, *rekognition.SearchUsersOutput)

	SearchUsersByImage(*rekognition.SearchUsersByImageInput) (*rekognition.SearchUsersByImageOutput, error)
	SearchUsersByImageWithContext(aws.Context, *rekognition.SearchUsersByImageInput, ...request.Option) (*rekognition.SearchUsersByImageOutput, error)
	SearchUsersByImageRequest(*rekognition.SearchUsersByImageInput) (*request.Request, *rekognition.SearchUsersByImageOutput)

	StartCelebrityRecognition(*rekognition.StartCelebrityRecognitionInput) (*rekognition.StartCelebrityRecognitionOutput, error)
	StartCelebrityRecognitionWithContext(aws.Context, *rekognition.StartCelebrityRecognitionInput, ...request.Option) (*rekognition.StartCelebrityRecognitionOutput, error)
	StartCelebrityRecognitionRequest(*rekognition.StartCelebrityRecognitionInput) (*request.Request, *rekognition.StartCelebrityRecognitionOutput)

	StartContentModeration(*rekognition.StartContentModerationInput) (*rekognition.StartContentModerationOutput, error)
	StartContentModerationWithContext(aws.Context, *rekognition.StartContentModerationInput, ...request.Option) (*rekognition.StartContentModerationOutput, error)
	StartContentModerationRequest(*rekognition.StartContentModerationInput) (*request.Request, *rekognition.StartContentModerationOutput)

	StartFaceDetection(*rekognition.StartFaceDetectionInput) (*rekognition.StartFaceDetectionOutput, error)
	StartFaceDetectionWithContext(aws.Context, *rekognition.StartFaceDetectionInput, ...request.Option) (*rekognition.StartFaceDetectionOutput, error)
	StartFaceDetectionRequest(*rekognition.StartFaceDetectionInput) (*request.Request, *rekognition.StartFaceDetectionOutput)

	StartFaceSearch(*rekognition.StartFaceSearchInput) (*rekognition.StartFaceSearchOutput, error)
	StartFaceSearchWithContext(aws.Context, *rekognition.StartFaceSearchInput, ...request.Option) (*rekognition.StartFaceSearchOutput, error)
	StartFaceSearchRequest(*rekognition.StartFaceSearchInput) (*request.Request, *rekognition.StartFaceSearchOutput)

	StartLabelDetection(*rekognition.StartLabelDetectionInput) (*rekognition.StartLabelDetectionOutput, error)
	StartLabelDetectionWithContext(aws.Context, *rekognition.StartLabelDetectionInput, ...request.Option) (*rekognition.StartLabelDetectionOutput, error)
	StartLabelDetectionRequest(*rekognition.StartLabelDetectionInput) (*request.Request, *rekognition.StartLabelDetectionOutput)

	StartPersonTracking(*rekognition.StartPersonTrackingInput) (*rekognition.StartPersonTrackingOutput, error)
	StartPersonTrackingWithContext(aws.Context, *rekognition.StartPersonTrackingInput, ...request.Option) (*rekognition.StartPersonTrackingOutput, error)
	StartPersonTrackingRequest(*rekognition.StartPersonTrackingInput) (*request.Request, *rekognition.StartPersonTrackingOutput)

	StartProjectVersion(*rekognition.StartProjectVersionInput) (*rekognition.StartProjectVersionOutput, error)
	StartProjectVersionWithContext(aws.Context, *rekognition.StartProjectVersionInput, ...request.Option) (*rekognition.StartProjectVersionOutput, error)
	StartProjectVersionRequest(*rekognition.StartProjectVersionInput) (*request.Request, *rekognition.StartProjectVersionOutput)

	StartSegmentDetection(*rekognition.StartSegmentDetectionInput) (*rekognition.StartSegmentDetectionOutput, error)
	StartSegmentDetectionWithContext(aws.Context, *rekognition.StartSegmentDetectionInput, ...request.Option) (*rekognition.StartSegmentDetectionOutput, error)
	StartSegmentDetectionRequest(*rekognition.StartSegmentDetectionInput) (*request.Request, *rekognition.StartSegmentDetectionOutput)

	StartStreamProcessor(*rekognition.StartStreamProcessorInput) (*rekognition.StartStreamProcessorOutput, error)
	StartStreamProcessorWithContext(aws.Context, *rekognition.StartStreamProcessorInput, ...request.Option) (*rekognition.StartStreamProcessorOutput, error)
	StartStreamProcessorRequest(*rekognition.StartStreamProcessorInput) (*request.Request, *rekognition.StartStreamProcessorOutput)

	StartTextDetection(*rekognition.StartTextDetectionInput) (*rekognition.StartTextDetectionOutput, error)
	StartTextDetectionWithContext(aws.Context, *rekognition.StartTextDetectionInput, ...request.Option) (*rekognition.StartTextDetectionOutput, error)
	StartTextDetectionRequest(*rekognition.StartTextDetectionInput) (*request.Request, *rekognition.StartTextDetectionOutput)

	StopProjectVersion(*rekognition.StopProjectVersionInput) (*rekognition.StopProjectVersionOutput, error)
	StopProjectVersionWithContext(aws.Context, *rekognition.StopProjectVersionInput, ...request.Option) (*rekognition.StopProjectVersionOutput, error)
	StopProjectVersionRequest(*rekognition.StopProjectVersionInput) (*request.Request, *rekognition.StopProjectVersionOutput)

	StopStreamProcessor(*rekognition.StopStreamProcessorInput) (*rekognition.StopStreamProcessorOutput, error)
	StopStreamProcessorWithContext(aws.Context, *rekognition.StopStreamProcessorInput, ...request.Option) (*rekognition.StopStreamProcessorOutput, error)
	StopStreamProcessorRequest(*rekognition.StopStreamProcessorInput) (*request.Request, *rekognition.StopStreamProcessorOutput)

	TagResource(*rekognition.TagResourceInput) (*rekognition.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *rekognition.TagResourceInput, ...request.Option) (*rekognition.TagResourceOutput, error)
	TagResourceRequest(*rekognition.TagResourceInput) (*request.Request, *rekognition.TagResourceOutput)

	UntagResource(*rekognition.UntagResourceInput) (*rekognition.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *rekognition.UntagResourceInput, ...request.Option) (*rekognition.UntagResourceOutput, error)
	UntagResourceRequest(*rekognition.UntagResourceInput) (*request.Request, *rekognition.UntagResourceOutput)

	UpdateDatasetEntries(*rekognition.UpdateDatasetEntriesInput) (*rekognition.UpdateDatasetEntriesOutput, error)
	UpdateDatasetEntriesWithContext(aws.Context, *rekognition.UpdateDatasetEntriesInput, ...request.Option) (*rekognition.UpdateDatasetEntriesOutput, error)
	UpdateDatasetEntriesRequest(*rekognition.UpdateDatasetEntriesInput) (*request.Request, *rekognition.UpdateDatasetEntriesOutput)

	UpdateStreamProcessor(*rekognition.UpdateStreamProcessorInput) (*rekognition.UpdateStreamProcessorOutput, error)
	UpdateStreamProcessorWithContext(aws.Context, *rekognition.UpdateStreamProcessorInput, ...request.Option) (*rekognition.UpdateStreamProcessorOutput, error)
	UpdateStreamProcessorRequest(*rekognition.UpdateStreamProcessorInput) (*request.Request, *rekognition.UpdateStreamProcessorOutput)

	WaitUntilProjectVersionRunning(*rekognition.DescribeProjectVersionsInput) error
	WaitUntilProjectVersionRunningWithContext(aws.Context, *rekognition.DescribeProjectVersionsInput, ...request.WaiterOption) error

	WaitUntilProjectVersionTrainingCompleted(*rekognition.DescribeProjectVersionsInput) error
	WaitUntilProjectVersionTrainingCompletedWithContext(aws.Context, *rekognition.DescribeProjectVersionsInput, ...request.WaiterOption) error
}

var _ RekognitionAPI = (*rekognition.Rekognition)(nil)
