// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddTagsToResourceRequest method.
//	req, resp := client.AddTagsToResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for AWS Database Migration Service.
//
// Adds metadata tags to an DMS resource, including replication instance, endpoint,
// subnet group, and migration task. These tags can also be used with cost allocation
// reporting to track cost associated with DMS resources, or used in a Condition
// statement in an IAM policy for DMS. For more information, see Tag (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html)
// data type description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//	req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction
func (c *DatabaseMigrationService) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for AWS Database Migration Service.
//
// Applies a pending maintenance action to a resource (for example, to a replication
// instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction
func (c *DatabaseMigrationService) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStartRecommendations = "BatchStartRecommendations"

// BatchStartRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchStartRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStartRecommendations for more information on using the BatchStartRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchStartRecommendationsRequest method.
//	req, resp := client.BatchStartRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations
func (c *DatabaseMigrationService) BatchStartRecommendationsRequest(input *BatchStartRecommendationsInput) (req *request.Request, output *BatchStartRecommendationsOutput) {
	op := &request.Operation{
		Name:       opBatchStartRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchStartRecommendationsInput{}
	}

	output = &BatchStartRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStartRecommendations API operation for AWS Database Migration Service.
//
// Starts the analysis of up to 20 source databases to recommend target engines
// for each source database. This is a batch version of StartRecommendations
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html).
//
// The result of analysis of each source database is reported individually in
// the response. Because the batch request can result in a combination of successful
// and unsuccessful actions, you should check for batch errors even when the
// call returns an HTTP status code of 200.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation BatchStartRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations
func (c *DatabaseMigrationService) BatchStartRecommendations(input *BatchStartRecommendationsInput) (*BatchStartRecommendationsOutput, error) {
	req, out := c.BatchStartRecommendationsRequest(input)
	return out, req.Send()
}

// BatchStartRecommendationsWithContext is the same as BatchStartRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStartRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) BatchStartRecommendationsWithContext(ctx aws.Context, input *BatchStartRecommendationsInput, opts ...request.Option) (*BatchStartRecommendationsOutput, error) {
	req, out := c.BatchStartRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelReplicationTaskAssessmentRun = "CancelReplicationTaskAssessmentRun"

// CancelReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelReplicationTaskAssessmentRun for more information on using the CancelReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelReplicationTaskAssessmentRunRequest method.
//	req, resp := client.CancelReplicationTaskAssessmentRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRunRequest(input *CancelReplicationTaskAssessmentRunInput) (req *request.Request, output *CancelReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opCancelReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReplicationTaskAssessmentRunInput{}
	}

	output = &CancelReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Cancels a single premigration assessment run.
//
// This operation prevents any individual assessments from running if they haven't
// started running. It also attempts to cancel any individual assessments that
// are currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CancelReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRun(input *CancelReplicationTaskAssessmentRunInput) (*CancelReplicationTaskAssessmentRunOutput, error) {
	req, out := c.CancelReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// CancelReplicationTaskAssessmentRunWithContext is the same as CancelReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *CancelReplicationTaskAssessmentRunInput, opts ...request.Option) (*CancelReplicationTaskAssessmentRunOutput, error) {
	req, out := c.CancelReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataProvider = "CreateDataProvider"

// CreateDataProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataProvider for more information on using the CreateDataProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataProviderRequest method.
//	req, resp := client.CreateDataProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider
func (c *DatabaseMigrationService) CreateDataProviderRequest(input *CreateDataProviderInput) (req *request.Request, output *CreateDataProviderOutput) {
	op := &request.Operation{
		Name:       opCreateDataProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataProviderInput{}
	}

	output = &CreateDataProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataProvider API operation for AWS Database Migration Service.
//
// Creates a data provider using the provided settings. A data provider stores
// a data store type and location information about your database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateDataProvider for usage and error information.
//
// Returned Error Types:
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider
func (c *DatabaseMigrationService) CreateDataProvider(input *CreateDataProviderInput) (*CreateDataProviderOutput, error) {
	req, out := c.CreateDataProviderRequest(input)
	return out, req.Send()
}

// CreateDataProviderWithContext is the same as CreateDataProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateDataProviderWithContext(ctx aws.Context, input *CreateDataProviderInput, opts ...request.Option) (*CreateDataProviderOutput, error) {
	req, out := c.CreateDataProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointRequest method.
//	req, resp := client.CreateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for AWS Database Migration Service.
//
// Creates an endpoint using the provided settings.
//
// For a MySQL source or target endpoint, don't explicitly specify the database
// using the DatabaseName request parameter on the CreateEndpoint API call.
// Specifying DatabaseName when you create a MySQL endpoint replicates all the
// task tables to this single database. For MySQL endpoints, you specify the
// database only when you specify the schema in the table-mapping rules of the
// DMS task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventSubscriptionRequest method.
//	req, resp := client.CreateEventSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for AWS Database Migration Service.
//
// Creates an DMS event notification subscription.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of DMS source IDs (SourceIds) that triggers the events, and
// provide a list of event categories (EventCategories) for events you want
// to be notified of. If you specify both the SourceType and SourceIds, such
// as SourceType = replication-instance and SourceIdentifier = my-replinstance,
// you will be notified of all the replication instance events for the specified
// source. If you specify a SourceType but don't specify a SourceIdentifier,
// you receive notice of the events for that source type for all your DMS sources.
// If you don't specify either SourceType nor SourceIdentifier, you will be
// notified of events generated from all DMS sources belonging to your customer
// account.
//
// For more information about DMS events, see Working with Events and Notifications
// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the
// Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - SNSInvalidTopicFault
//     The SNS topic is invalid.
//
//   - SNSNoAuthorizationFault
//     You are not authorized for the SNS subscription.
//
//   - KMSAccessDeniedFault
//     The ciphertext references a key that doesn't exist or that the DMS account
//     doesn't have access to.
//
//   - KMSDisabledFault
//     The specified KMS key isn't enabled.
//
//   - KMSInvalidStateFault
//     The state of the specified KMS resource isn't valid for this request.
//
//   - KMSNotFoundFault
//     The specified KMS entity or resource can't be found.
//
//   - KMSThrottlingFault
//     This request triggered KMS request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleetAdvisorCollector = "CreateFleetAdvisorCollector"

// CreateFleetAdvisorCollectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleetAdvisorCollector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleetAdvisorCollector for more information on using the CreateFleetAdvisorCollector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetAdvisorCollectorRequest method.
//	req, resp := client.CreateFleetAdvisorCollectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector
func (c *DatabaseMigrationService) CreateFleetAdvisorCollectorRequest(input *CreateFleetAdvisorCollectorInput) (req *request.Request, output *CreateFleetAdvisorCollectorOutput) {
	op := &request.Operation{
		Name:       opCreateFleetAdvisorCollector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetAdvisorCollectorInput{}
	}

	output = &CreateFleetAdvisorCollectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleetAdvisorCollector API operation for AWS Database Migration Service.
//
// Creates a Fleet Advisor collector using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateFleetAdvisorCollector for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector
func (c *DatabaseMigrationService) CreateFleetAdvisorCollector(input *CreateFleetAdvisorCollectorInput) (*CreateFleetAdvisorCollectorOutput, error) {
	req, out := c.CreateFleetAdvisorCollectorRequest(input)
	return out, req.Send()
}

// CreateFleetAdvisorCollectorWithContext is the same as CreateFleetAdvisorCollector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleetAdvisorCollector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateFleetAdvisorCollectorWithContext(ctx aws.Context, input *CreateFleetAdvisorCollectorInput, opts ...request.Option) (*CreateFleetAdvisorCollectorOutput, error) {
	req, out := c.CreateFleetAdvisorCollectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceProfile = "CreateInstanceProfile"

// CreateInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceProfile for more information on using the CreateInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceProfileRequest method.
//	req, resp := client.CreateInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile
func (c *DatabaseMigrationService) CreateInstanceProfileRequest(input *CreateInstanceProfileInput) (req *request.Request, output *CreateInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceProfileInput{}
	}

	output = &CreateInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceProfile API operation for AWS Database Migration Service.
//
// Creates the instance profile using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile
func (c *DatabaseMigrationService) CreateInstanceProfile(input *CreateInstanceProfileInput) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	return out, req.Send()
}

// CreateInstanceProfileWithContext is the same as CreateInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateInstanceProfileWithContext(ctx aws.Context, input *CreateInstanceProfileInput, opts ...request.Option) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMigrationProject = "CreateMigrationProject"

// CreateMigrationProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateMigrationProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMigrationProject for more information on using the CreateMigrationProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMigrationProjectRequest method.
//	req, resp := client.CreateMigrationProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject
func (c *DatabaseMigrationService) CreateMigrationProjectRequest(input *CreateMigrationProjectInput) (req *request.Request, output *CreateMigrationProjectOutput) {
	op := &request.Operation{
		Name:       opCreateMigrationProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMigrationProjectInput{}
	}

	output = &CreateMigrationProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMigrationProject API operation for AWS Database Migration Service.
//
// Creates the migration project using the specified parameters.
//
// You can run this action only after you create an instance profile and data
// providers using CreateInstanceProfile (https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html)
// and CreateDataProvider (https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateMigrationProject for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject
func (c *DatabaseMigrationService) CreateMigrationProject(input *CreateMigrationProjectInput) (*CreateMigrationProjectOutput, error) {
	req, out := c.CreateMigrationProjectRequest(input)
	return out, req.Send()
}

// CreateMigrationProjectWithContext is the same as CreateMigrationProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMigrationProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateMigrationProjectWithContext(ctx aws.Context, input *CreateMigrationProjectInput, opts ...request.Option) (*CreateMigrationProjectOutput, error) {
	req, out := c.CreateMigrationProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationConfig = "CreateReplicationConfig"

// CreateReplicationConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationConfig for more information on using the CreateReplicationConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationConfigRequest method.
//	req, resp := client.CreateReplicationConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig
func (c *DatabaseMigrationService) CreateReplicationConfigRequest(input *CreateReplicationConfigInput) (req *request.Request, output *CreateReplicationConfigOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationConfigInput{}
	}

	output = &CreateReplicationConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationConfig API operation for AWS Database Migration Service.
//
// Creates a configuration that you can later provide to configure and start
// an DMS Serverless replication. You can also provide options to validate the
// configuration inputs before you start the replication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ReplicationSubnetGroupDoesNotCoverEnoughAZs
//     The replication subnet group does not cover enough Availability Zones (AZs).
//     Edit the replication subnet group and add more AZs.
//
//   - InvalidSubnet
//     The subnet provided isn't valid.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig
func (c *DatabaseMigrationService) CreateReplicationConfig(input *CreateReplicationConfigInput) (*CreateReplicationConfigOutput, error) {
	req, out := c.CreateReplicationConfigRequest(input)
	return out, req.Send()
}

// CreateReplicationConfigWithContext is the same as CreateReplicationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationConfigWithContext(ctx aws.Context, input *CreateReplicationConfigInput, opts ...request.Option) (*CreateReplicationConfigOutput, error) {
	req, out := c.CreateReplicationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationInstance = "CreateReplicationInstance"

// CreateReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationInstance for more information on using the CreateReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationInstanceRequest method.
//	req, resp := client.CreateReplicationInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstanceRequest(input *CreateReplicationInstanceInput) (req *request.Request, output *CreateReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationInstanceInput{}
	}

	output = &CreateReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationInstance API operation for AWS Database Migration Service.
//
// Creates the replication instance using the specified parameters.
//
// DMS requires that your account have certain roles with appropriate permissions
// before you can create a replication instance. For information on the required
// roles, see Creating the IAM Roles to Use With the CLI and DMS API (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole).
// For information on the required permissions, see IAM Permissions Needed to
// Use DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationInstance for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - InsufficientResourceCapacityFault
//     There are not enough resources allocated to the database migration.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - StorageQuotaExceededFault
//     The storage quota has been exceeded.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ReplicationSubnetGroupDoesNotCoverEnoughAZs
//     The replication subnet group does not cover enough Availability Zones (AZs).
//     Edit the replication subnet group and add more AZs.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - InvalidSubnet
//     The subnet provided isn't valid.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstance(input *CreateReplicationInstanceInput) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	return out, req.Send()
}

// CreateReplicationInstanceWithContext is the same as CreateReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationInstanceWithContext(ctx aws.Context, input *CreateReplicationInstanceInput, opts ...request.Option) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationSubnetGroup = "CreateReplicationSubnetGroup"

// CreateReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationSubnetGroup for more information on using the CreateReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationSubnetGroupRequest method.
//	req, resp := client.CreateReplicationSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupRequest(input *CreateReplicationSubnetGroupInput) (req *request.Request, output *CreateReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationSubnetGroupInput{}
	}

	output = &CreateReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
//
// The VPC needs to have at least one subnet in at least two availability zones
// in the Amazon Web Services Region, otherwise the service will throw a ReplicationSubnetGroupDoesNotCoverEnoughAZs
// exception.
//
// If a replication subnet group exists in your Amazon Web Services account,
// the CreateReplicationSubnetGroup action returns the following error message:
// The Replication Subnet Group already exists. In this case, delete the existing
// replication subnet group. To do so, use the DeleteReplicationSubnetGroup
// (https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html)
// action. Optionally, choose Subnet groups in the DMS console, then choose
// your subnet group. Next, choose Delete from Actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - ReplicationSubnetGroupDoesNotCoverEnoughAZs
//     The replication subnet group does not cover enough Availability Zones (AZs).
//     Edit the replication subnet group and add more AZs.
//
//   - InvalidSubnet
//     The subnet provided isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroup(input *CreateReplicationSubnetGroupInput) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateReplicationSubnetGroupWithContext is the same as CreateReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupWithContext(ctx aws.Context, input *CreateReplicationSubnetGroupInput, opts ...request.Option) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationTask = "CreateReplicationTask"

// CreateReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationTask for more information on using the CreateReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationTaskRequest method.
//	req, resp := client.CreateReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTaskRequest(input *CreateReplicationTaskInput) (req *request.Request, output *CreateReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationTaskInput{}
	}

	output = &CreateReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationTask API operation for AWS Database Migration Service.
//
// Creates a replication task using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTask(input *CreateReplicationTaskInput) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	return out, req.Send()
}

// CreateReplicationTaskWithContext is the same as CreateReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationTaskWithContext(ctx aws.Context, input *CreateReplicationTaskInput, opts ...request.Option) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCertificateRequest method.
//	req, resp := client.DeleteCertificateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCertificate API operation for AWS Database Migration Service.
//
// Deletes the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectionRequest method.
//	req, resp := client.DeleteConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection
func (c *DatabaseMigrationService) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Database Migration Service.
//
// Deletes the connection between a replication instance and an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection
func (c *DatabaseMigrationService) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataProvider = "DeleteDataProvider"

// DeleteDataProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataProvider for more information on using the DeleteDataProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataProviderRequest method.
//	req, resp := client.DeleteDataProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider
func (c *DatabaseMigrationService) DeleteDataProviderRequest(input *DeleteDataProviderInput) (req *request.Request, output *DeleteDataProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteDataProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataProviderInput{}
	}

	output = &DeleteDataProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataProvider API operation for AWS Database Migration Service.
//
// Deletes the specified data provider.
//
// All migration projects associated with the data provider must be deleted
// or modified before you can delete the data provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteDataProvider for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider
func (c *DatabaseMigrationService) DeleteDataProvider(input *DeleteDataProviderInput) (*DeleteDataProviderOutput, error) {
	req, out := c.DeleteDataProviderRequest(input)
	return out, req.Send()
}

// DeleteDataProviderWithContext is the same as DeleteDataProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteDataProviderWithContext(ctx aws.Context, input *DeleteDataProviderInput, opts ...request.Option) (*DeleteDataProviderOutput, error) {
	req, out := c.DeleteDataProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointRequest method.
//	req, resp := client.DeleteEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for AWS Database Migration Service.
//
// Deletes the specified endpoint.
//
// All tasks associated with the endpoint must be deleted before you can delete
// the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventSubscriptionRequest method.
//	req, resp := client.DeleteEventSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for AWS Database Migration Service.
//
// Deletes an DMS event subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleetAdvisorCollector = "DeleteFleetAdvisorCollector"

// DeleteFleetAdvisorCollectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleetAdvisorCollector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleetAdvisorCollector for more information on using the DeleteFleetAdvisorCollector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetAdvisorCollectorRequest method.
//	req, resp := client.DeleteFleetAdvisorCollectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector
func (c *DatabaseMigrationService) DeleteFleetAdvisorCollectorRequest(input *DeleteFleetAdvisorCollectorInput) (req *request.Request, output *DeleteFleetAdvisorCollectorOutput) {
	op := &request.Operation{
		Name:       opDeleteFleetAdvisorCollector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetAdvisorCollectorInput{}
	}

	output = &DeleteFleetAdvisorCollectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleetAdvisorCollector API operation for AWS Database Migration Service.
//
// Deletes the specified Fleet Advisor collector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteFleetAdvisorCollector for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - CollectorNotFoundFault
//     The specified collector doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector
func (c *DatabaseMigrationService) DeleteFleetAdvisorCollector(input *DeleteFleetAdvisorCollectorInput) (*DeleteFleetAdvisorCollectorOutput, error) {
	req, out := c.DeleteFleetAdvisorCollectorRequest(input)
	return out, req.Send()
}

// DeleteFleetAdvisorCollectorWithContext is the same as DeleteFleetAdvisorCollector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleetAdvisorCollector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteFleetAdvisorCollectorWithContext(ctx aws.Context, input *DeleteFleetAdvisorCollectorInput, opts ...request.Option) (*DeleteFleetAdvisorCollectorOutput, error) {
	req, out := c.DeleteFleetAdvisorCollectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleetAdvisorDatabases = "DeleteFleetAdvisorDatabases"

// DeleteFleetAdvisorDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleetAdvisorDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleetAdvisorDatabases for more information on using the DeleteFleetAdvisorDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetAdvisorDatabasesRequest method.
//	req, resp := client.DeleteFleetAdvisorDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases
func (c *DatabaseMigrationService) DeleteFleetAdvisorDatabasesRequest(input *DeleteFleetAdvisorDatabasesInput) (req *request.Request, output *DeleteFleetAdvisorDatabasesOutput) {
	op := &request.Operation{
		Name:       opDeleteFleetAdvisorDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetAdvisorDatabasesInput{}
	}

	output = &DeleteFleetAdvisorDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleetAdvisorDatabases API operation for AWS Database Migration Service.
//
// Deletes the specified Fleet Advisor collector databases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteFleetAdvisorDatabases for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidOperationFault
//     The action or operation requested isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases
func (c *DatabaseMigrationService) DeleteFleetAdvisorDatabases(input *DeleteFleetAdvisorDatabasesInput) (*DeleteFleetAdvisorDatabasesOutput, error) {
	req, out := c.DeleteFleetAdvisorDatabasesRequest(input)
	return out, req.Send()
}

// DeleteFleetAdvisorDatabasesWithContext is the same as DeleteFleetAdvisorDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleetAdvisorDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteFleetAdvisorDatabasesWithContext(ctx aws.Context, input *DeleteFleetAdvisorDatabasesInput, opts ...request.Option) (*DeleteFleetAdvisorDatabasesOutput, error) {
	req, out := c.DeleteFleetAdvisorDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceProfile for more information on using the DeleteInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceProfileRequest method.
//	req, resp := client.DeleteInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile
func (c *DatabaseMigrationService) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) (req *request.Request, output *DeleteInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	output = &DeleteInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceProfile API operation for AWS Database Migration Service.
//
// Deletes the specified instance profile.
//
// All migration projects associated with the instance profile must be deleted
// or modified before you can delete the instance profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile
func (c *DatabaseMigrationService) DeleteInstanceProfile(input *DeleteInstanceProfileInput) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	return out, req.Send()
}

// DeleteInstanceProfileWithContext is the same as DeleteInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteInstanceProfileWithContext(ctx aws.Context, input *DeleteInstanceProfileInput, opts ...request.Option) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMigrationProject = "DeleteMigrationProject"

// DeleteMigrationProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMigrationProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMigrationProject for more information on using the DeleteMigrationProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMigrationProjectRequest method.
//	req, resp := client.DeleteMigrationProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject
func (c *DatabaseMigrationService) DeleteMigrationProjectRequest(input *DeleteMigrationProjectInput) (req *request.Request, output *DeleteMigrationProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteMigrationProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMigrationProjectInput{}
	}

	output = &DeleteMigrationProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMigrationProject API operation for AWS Database Migration Service.
//
// Deletes the specified migration project.
//
// The migration project must be closed before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteMigrationProject for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject
func (c *DatabaseMigrationService) DeleteMigrationProject(input *DeleteMigrationProjectInput) (*DeleteMigrationProjectOutput, error) {
	req, out := c.DeleteMigrationProjectRequest(input)
	return out, req.Send()
}

// DeleteMigrationProjectWithContext is the same as DeleteMigrationProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMigrationProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteMigrationProjectWithContext(ctx aws.Context, input *DeleteMigrationProjectInput, opts ...request.Option) (*DeleteMigrationProjectOutput, error) {
	req, out := c.DeleteMigrationProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationConfig = "DeleteReplicationConfig"

// DeleteReplicationConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationConfig for more information on using the DeleteReplicationConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationConfigRequest method.
//	req, resp := client.DeleteReplicationConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig
func (c *DatabaseMigrationService) DeleteReplicationConfigRequest(input *DeleteReplicationConfigInput) (req *request.Request, output *DeleteReplicationConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationConfigInput{}
	}

	output = &DeleteReplicationConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationConfig API operation for AWS Database Migration Service.
//
// Deletes an DMS Serverless replication configuration. This effectively deprovisions
// any and all replications that use this configuration. You can't delete the
// configuration for an DMS Serverless replication that is ongoing. You can
// delete the configuration when the replication is in a non-RUNNING and non-STARTING
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig
func (c *DatabaseMigrationService) DeleteReplicationConfig(input *DeleteReplicationConfigInput) (*DeleteReplicationConfigOutput, error) {
	req, out := c.DeleteReplicationConfigRequest(input)
	return out, req.Send()
}

// DeleteReplicationConfigWithContext is the same as DeleteReplicationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationConfigWithContext(ctx aws.Context, input *DeleteReplicationConfigInput, opts ...request.Option) (*DeleteReplicationConfigOutput, error) {
	req, out := c.DeleteReplicationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationInstance = "DeleteReplicationInstance"

// DeleteReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationInstance for more information on using the DeleteReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationInstanceRequest method.
//	req, resp := client.DeleteReplicationInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstanceRequest(input *DeleteReplicationInstanceInput) (req *request.Request, output *DeleteReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationInstanceInput{}
	}

	output = &DeleteReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationInstance API operation for AWS Database Migration Service.
//
// Deletes the specified replication instance.
//
// You must delete any migration tasks that are associated with the replication
// instance before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstance(input *DeleteReplicationInstanceInput) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	return out, req.Send()
}

// DeleteReplicationInstanceWithContext is the same as DeleteReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationInstanceWithContext(ctx aws.Context, input *DeleteReplicationInstanceInput, opts ...request.Option) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationSubnetGroup = "DeleteReplicationSubnetGroup"

// DeleteReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationSubnetGroup for more information on using the DeleteReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationSubnetGroupRequest method.
//	req, resp := client.DeleteReplicationSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupRequest(input *DeleteReplicationSubnetGroupInput) (req *request.Request, output *DeleteReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationSubnetGroupInput{}
	}

	output = &DeleteReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Deletes a subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroup(input *DeleteReplicationSubnetGroupInput) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteReplicationSubnetGroupWithContext is the same as DeleteReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupWithContext(ctx aws.Context, input *DeleteReplicationSubnetGroupInput, opts ...request.Option) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationTask = "DeleteReplicationTask"

// DeleteReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationTask for more information on using the DeleteReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationTaskRequest method.
//	req, resp := client.DeleteReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTaskRequest(input *DeleteReplicationTaskInput) (req *request.Request, output *DeleteReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskInput{}
	}

	output = &DeleteReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationTask API operation for AWS Database Migration Service.
//
// Deletes the specified replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTask(input *DeleteReplicationTaskInput) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	return out, req.Send()
}

// DeleteReplicationTaskWithContext is the same as DeleteReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationTaskWithContext(ctx aws.Context, input *DeleteReplicationTaskInput, opts ...request.Option) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationTaskAssessmentRun = "DeleteReplicationTaskAssessmentRun"

// DeleteReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationTaskAssessmentRun for more information on using the DeleteReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationTaskAssessmentRunRequest method.
//	req, resp := client.DeleteReplicationTaskAssessmentRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRunRequest(input *DeleteReplicationTaskAssessmentRunInput) (req *request.Request, output *DeleteReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskAssessmentRunInput{}
	}

	output = &DeleteReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Deletes the record of a single premigration assessment run.
//
// This operation removes all metadata that DMS maintains about this assessment
// run. However, the operation leaves untouched all information about this assessment
// run that is stored in your Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRun(input *DeleteReplicationTaskAssessmentRunInput) (*DeleteReplicationTaskAssessmentRunOutput, error) {
	req, out := c.DeleteReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// DeleteReplicationTaskAssessmentRunWithContext is the same as DeleteReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *DeleteReplicationTaskAssessmentRunInput, opts ...request.Option) (*DeleteReplicationTaskAssessmentRunOutput, error) {
	req, out := c.DeleteReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountAttributesRequest method.
//	req, resp := client.DescribeAccountAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for AWS Database Migration Service.
//
// Lists all of the DMS attributes for a customer account. These attributes
// include DMS quotas for the account and a unique account identifier in a particular
// DMS region. DMS quotas include a list of resource quotas supported by the
// account, such as the number of replication instances allowed. The description
// for each resource quota, includes the quota name, current usage toward that
// quota, and the quota's maximum value. DMS uses the unique account identifier
// to name each artifact used by DMS in the given region.
//
// This command does not take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicableIndividualAssessments = "DescribeApplicableIndividualAssessments"

// DescribeApplicableIndividualAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicableIndividualAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicableIndividualAssessments for more information on using the DescribeApplicableIndividualAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicableIndividualAssessmentsRequest method.
//	req, resp := client.DescribeApplicableIndividualAssessmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsRequest(input *DescribeApplicableIndividualAssessmentsInput) (req *request.Request, output *DescribeApplicableIndividualAssessmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicableIndividualAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeApplicableIndividualAssessmentsInput{}
	}

	output = &DescribeApplicableIndividualAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicableIndividualAssessments API operation for AWS Database Migration Service.
//
// Provides a list of individual assessments that you can specify for a new
// premigration assessment run, given one or more parameters.
//
// If you specify an existing migration task, this operation provides the default
// individual assessments you can specify for that task. Otherwise, the specified
// parameters model elements of a possible migration task on which to base a
// premigration assessment run.
//
// To use these migration task modeling parameters, you must specify an existing
// replication instance, a source database engine, a target database engine,
// and a migration type. This combination of parameters potentially limits the
// default individual assessments available for an assessment run created for
// a corresponding migration task.
//
// If you specify no parameters, this operation provides a list of all possible
// individual assessments that you can specify for an assessment run. If you
// specify any one of the task modeling parameters, you must specify all of
// them or the operation cannot provide a list of individual assessments. The
// only parameter that you can specify alone is for an existing migration task.
// The specified task definition then determines the default list of individual
// assessments that you can specify in an assessment run for the task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeApplicableIndividualAssessments for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessments(input *DescribeApplicableIndividualAssessmentsInput) (*DescribeApplicableIndividualAssessmentsOutput, error) {
	req, out := c.DescribeApplicableIndividualAssessmentsRequest(input)
	return out, req.Send()
}

// DescribeApplicableIndividualAssessmentsWithContext is the same as DescribeApplicableIndividualAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicableIndividualAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsWithContext(ctx aws.Context, input *DescribeApplicableIndividualAssessmentsInput, opts ...request.Option) (*DescribeApplicableIndividualAssessmentsOutput, error) {
	req, out := c.DescribeApplicableIndividualAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeApplicableIndividualAssessmentsPages iterates over the pages of a DescribeApplicableIndividualAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeApplicableIndividualAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeApplicableIndividualAssessments operation.
//	pageNum := 0
//	err := client.DescribeApplicableIndividualAssessmentsPages(params,
//	    func(page *databasemigrationservice.DescribeApplicableIndividualAssessmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsPages(input *DescribeApplicableIndividualAssessmentsInput, fn func(*DescribeApplicableIndividualAssessmentsOutput, bool) bool) error {
	return c.DescribeApplicableIndividualAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeApplicableIndividualAssessmentsPagesWithContext same as DescribeApplicableIndividualAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsPagesWithContext(ctx aws.Context, input *DescribeApplicableIndividualAssessmentsInput, fn func(*DescribeApplicableIndividualAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeApplicableIndividualAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeApplicableIndividualAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeApplicableIndividualAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCertificatesRequest method.
//	req, resp := client.DescribeCertificatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for AWS Database Migration Service.
//
// Provides a description of the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCertificatesPages iterates over the pages of a DescribeCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCertificates operation.
//	pageNum := 0
//	err := client.DescribeCertificatesPages(params,
//	    func(page *databasemigrationservice.DescribeCertificatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeCertificatesPages(input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool) error {
	return c.DescribeCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCertificatesPagesWithContext same as DescribeCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesPagesWithContext(ctx aws.Context, input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnections for more information on using the DescribeConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConnectionsRequest method.
//	req, resp := client.DescribeConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *DescribeConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &DescribeConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Database Migration Service.
//
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnections(input *DescribeConnectionsInput) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionsWithContext is the same as DescribeConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsWithContext(ctx aws.Context, input *DescribeConnectionsInput, opts ...request.Option) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConnectionsPages iterates over the pages of a DescribeConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeConnections operation.
//	pageNum := 0
//	err := client.DescribeConnectionsPages(params,
//	    func(page *databasemigrationservice.DescribeConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeConnectionsPages(input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool) error {
	return c.DescribeConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConnectionsPagesWithContext same as DescribeConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsPagesWithContext(ctx aws.Context, input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConversionConfiguration = "DescribeConversionConfiguration"

// DescribeConversionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConversionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConversionConfiguration for more information on using the DescribeConversionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConversionConfigurationRequest method.
//	req, resp := client.DescribeConversionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration
func (c *DatabaseMigrationService) DescribeConversionConfigurationRequest(input *DescribeConversionConfigurationInput) (req *request.Request, output *DescribeConversionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeConversionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConversionConfigurationInput{}
	}

	output = &DescribeConversionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConversionConfiguration API operation for AWS Database Migration Service.
//
// Returns configuration parameters for a schema conversion project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeConversionConfiguration for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration
func (c *DatabaseMigrationService) DescribeConversionConfiguration(input *DescribeConversionConfigurationInput) (*DescribeConversionConfigurationOutput, error) {
	req, out := c.DescribeConversionConfigurationRequest(input)
	return out, req.Send()
}

// DescribeConversionConfigurationWithContext is the same as DescribeConversionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConversionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConversionConfigurationWithContext(ctx aws.Context, input *DescribeConversionConfigurationInput, opts ...request.Option) (*DescribeConversionConfigurationOutput, error) {
	req, out := c.DescribeConversionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataProviders = "DescribeDataProviders"

// DescribeDataProvidersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataProviders for more information on using the DescribeDataProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataProvidersRequest method.
//	req, resp := client.DescribeDataProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders
func (c *DatabaseMigrationService) DescribeDataProvidersRequest(input *DescribeDataProvidersInput) (req *request.Request, output *DescribeDataProvidersOutput) {
	op := &request.Operation{
		Name:       opDescribeDataProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDataProvidersInput{}
	}

	output = &DescribeDataProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataProviders API operation for AWS Database Migration Service.
//
// Returns a paginated list of data providers for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeDataProviders for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders
func (c *DatabaseMigrationService) DescribeDataProviders(input *DescribeDataProvidersInput) (*DescribeDataProvidersOutput, error) {
	req, out := c.DescribeDataProvidersRequest(input)
	return out, req.Send()
}

// DescribeDataProvidersWithContext is the same as DescribeDataProviders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeDataProvidersWithContext(ctx aws.Context, input *DescribeDataProvidersInput, opts ...request.Option) (*DescribeDataProvidersOutput, error) {
	req, out := c.DescribeDataProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDataProvidersPages iterates over the pages of a DescribeDataProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDataProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeDataProviders operation.
//	pageNum := 0
//	err := client.DescribeDataProvidersPages(params,
//	    func(page *databasemigrationservice.DescribeDataProvidersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeDataProvidersPages(input *DescribeDataProvidersInput, fn func(*DescribeDataProvidersOutput, bool) bool) error {
	return c.DescribeDataProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDataProvidersPagesWithContext same as DescribeDataProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeDataProvidersPagesWithContext(ctx aws.Context, input *DescribeDataProvidersInput, fn func(*DescribeDataProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDataProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDataProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDataProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpointSettings = "DescribeEndpointSettings"

// DescribeEndpointSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointSettings for more information on using the DescribeEndpointSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointSettingsRequest method.
//	req, resp := client.DescribeEndpointSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings
func (c *DatabaseMigrationService) DescribeEndpointSettingsRequest(input *DescribeEndpointSettingsInput) (req *request.Request, output *DescribeEndpointSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointSettingsInput{}
	}

	output = &DescribeEndpointSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointSettings API operation for AWS Database Migration Service.
//
// Returns information about the possible endpoint settings available when you
// create an endpoint for a specific database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointSettings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings
func (c *DatabaseMigrationService) DescribeEndpointSettings(input *DescribeEndpointSettingsInput) (*DescribeEndpointSettingsOutput, error) {
	req, out := c.DescribeEndpointSettingsRequest(input)
	return out, req.Send()
}

// DescribeEndpointSettingsWithContext is the same as DescribeEndpointSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointSettingsWithContext(ctx aws.Context, input *DescribeEndpointSettingsInput, opts ...request.Option) (*DescribeEndpointSettingsOutput, error) {
	req, out := c.DescribeEndpointSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointSettingsPages iterates over the pages of a DescribeEndpointSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpointSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEndpointSettings operation.
//	pageNum := 0
//	err := client.DescribeEndpointSettingsPages(params,
//	    func(page *databasemigrationservice.DescribeEndpointSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEndpointSettingsPages(input *DescribeEndpointSettingsInput, fn func(*DescribeEndpointSettingsOutput, bool) bool) error {
	return c.DescribeEndpointSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointSettingsPagesWithContext same as DescribeEndpointSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointSettingsPagesWithContext(ctx aws.Context, input *DescribeEndpointSettingsInput, fn func(*DescribeEndpointSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpointTypes = "DescribeEndpointTypes"

// DescribeEndpointTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointTypes for more information on using the DescribeEndpointTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointTypesRequest method.
//	req, resp := client.DescribeEndpointTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypesRequest(input *DescribeEndpointTypesInput) (req *request.Request, output *DescribeEndpointTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointTypesInput{}
	}

	output = &DescribeEndpointTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointTypes API operation for AWS Database Migration Service.
//
// Returns information about the type of endpoints available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointTypes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypes(input *DescribeEndpointTypesInput) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	return out, req.Send()
}

// DescribeEndpointTypesWithContext is the same as DescribeEndpointTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, opts ...request.Option) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointTypesPages iterates over the pages of a DescribeEndpointTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpointTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEndpointTypes operation.
//	pageNum := 0
//	err := client.DescribeEndpointTypesPages(params,
//	    func(page *databasemigrationservice.DescribeEndpointTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEndpointTypesPages(input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool) error {
	return c.DescribeEndpointTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointTypesPagesWithContext same as DescribeEndpointTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesPagesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointsRequest method.
//	req, resp := client.DescribeEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for AWS Database Migration Service.
//
// Returns information about the endpoints for your account in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointsPages iterates over the pages of a DescribeEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEndpoints operation.
//	pageNum := 0
//	err := client.DescribeEndpointsPages(params,
//	    func(page *databasemigrationservice.DescribeEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEndpointsPages(input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool) error {
	return c.DescribeEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointsPagesWithContext same as DescribeEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsPagesWithContext(ctx aws.Context, input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEngineVersions = "DescribeEngineVersions"

// DescribeEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineVersions for more information on using the DescribeEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEngineVersionsRequest method.
//	req, resp := client.DescribeEngineVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions
func (c *DatabaseMigrationService) DescribeEngineVersionsRequest(input *DescribeEngineVersionsInput) (req *request.Request, output *DescribeEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineVersionsInput{}
	}

	output = &DescribeEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineVersions API operation for AWS Database Migration Service.
//
// Returns information about the replication instance versions used in the project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEngineVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions
func (c *DatabaseMigrationService) DescribeEngineVersions(input *DescribeEngineVersionsInput) (*DescribeEngineVersionsOutput, error) {
	req, out := c.DescribeEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeEngineVersionsWithContext is the same as DescribeEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEngineVersionsWithContext(ctx aws.Context, input *DescribeEngineVersionsInput, opts ...request.Option) (*DescribeEngineVersionsOutput, error) {
	req, out := c.DescribeEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEngineVersionsPages iterates over the pages of a DescribeEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEngineVersions operation.
//	pageNum := 0
//	err := client.DescribeEngineVersionsPages(params,
//	    func(page *databasemigrationservice.DescribeEngineVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEngineVersionsPages(input *DescribeEngineVersionsInput, fn func(*DescribeEngineVersionsOutput, bool) bool) error {
	return c.DescribeEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEngineVersionsPagesWithContext same as DescribeEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeEngineVersionsInput, fn func(*DescribeEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEngineVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventCategoriesRequest method.
//	req, resp := client.DescribeEventCategoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for AWS Database Migration Service.
//
// Lists categories for all event source types, or, if specified, for a specified
// source type. You can see a list of the event categories and source types
// in Working with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventSubscriptionsRequest method.
//	req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for AWS Database Migration Service.
//
// Lists all the event subscriptions for a customer account. The description
// of a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify SubscriptionName, this action lists the description for that
// subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//	pageNum := 0
//	err := client.DescribeEventSubscriptionsPages(params,
//	    func(page *databasemigrationservice.DescribeEventSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventsRequest method.
//	req, resp := client.DescribeEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS Database Migration Service.
//
// Lists events for a given source identifier and source type. You can also
// specify a start and end time. For more information on DMS events, see Working
// with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEvents operation.
//	pageNum := 0
//	err := client.DescribeEventsPages(params,
//	    func(page *databasemigrationservice.DescribeEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeExtensionPackAssociations = "DescribeExtensionPackAssociations"

// DescribeExtensionPackAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExtensionPackAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExtensionPackAssociations for more information on using the DescribeExtensionPackAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExtensionPackAssociationsRequest method.
//	req, resp := client.DescribeExtensionPackAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations
func (c *DatabaseMigrationService) DescribeExtensionPackAssociationsRequest(input *DescribeExtensionPackAssociationsInput) (req *request.Request, output *DescribeExtensionPackAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeExtensionPackAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExtensionPackAssociationsInput{}
	}

	output = &DescribeExtensionPackAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExtensionPackAssociations API operation for AWS Database Migration Service.
//
// Returns a paginated list of extension pack associations for the specified
// migration project. An extension pack is an add-on module that emulates functions
// present in a source database that are required when converting objects to
// the target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeExtensionPackAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations
func (c *DatabaseMigrationService) DescribeExtensionPackAssociations(input *DescribeExtensionPackAssociationsInput) (*DescribeExtensionPackAssociationsOutput, error) {
	req, out := c.DescribeExtensionPackAssociationsRequest(input)
	return out, req.Send()
}

// DescribeExtensionPackAssociationsWithContext is the same as DescribeExtensionPackAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExtensionPackAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeExtensionPackAssociationsWithContext(ctx aws.Context, input *DescribeExtensionPackAssociationsInput, opts ...request.Option) (*DescribeExtensionPackAssociationsOutput, error) {
	req, out := c.DescribeExtensionPackAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeExtensionPackAssociationsPages iterates over the pages of a DescribeExtensionPackAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeExtensionPackAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeExtensionPackAssociations operation.
//	pageNum := 0
//	err := client.DescribeExtensionPackAssociationsPages(params,
//	    func(page *databasemigrationservice.DescribeExtensionPackAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeExtensionPackAssociationsPages(input *DescribeExtensionPackAssociationsInput, fn func(*DescribeExtensionPackAssociationsOutput, bool) bool) error {
	return c.DescribeExtensionPackAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeExtensionPackAssociationsPagesWithContext same as DescribeExtensionPackAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeExtensionPackAssociationsPagesWithContext(ctx aws.Context, input *DescribeExtensionPackAssociationsInput, fn func(*DescribeExtensionPackAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeExtensionPackAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeExtensionPackAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeExtensionPackAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetAdvisorCollectors = "DescribeFleetAdvisorCollectors"

// DescribeFleetAdvisorCollectorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAdvisorCollectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAdvisorCollectors for more information on using the DescribeFleetAdvisorCollectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAdvisorCollectorsRequest method.
//	req, resp := client.DescribeFleetAdvisorCollectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors
func (c *DatabaseMigrationService) DescribeFleetAdvisorCollectorsRequest(input *DescribeFleetAdvisorCollectorsInput) (req *request.Request, output *DescribeFleetAdvisorCollectorsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAdvisorCollectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAdvisorCollectorsInput{}
	}

	output = &DescribeFleetAdvisorCollectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAdvisorCollectors API operation for AWS Database Migration Service.
//
// Returns a list of the Fleet Advisor collectors in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeFleetAdvisorCollectors for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors
func (c *DatabaseMigrationService) DescribeFleetAdvisorCollectors(input *DescribeFleetAdvisorCollectorsInput) (*DescribeFleetAdvisorCollectorsOutput, error) {
	req, out := c.DescribeFleetAdvisorCollectorsRequest(input)
	return out, req.Send()
}

// DescribeFleetAdvisorCollectorsWithContext is the same as DescribeFleetAdvisorCollectors with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAdvisorCollectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorCollectorsWithContext(ctx aws.Context, input *DescribeFleetAdvisorCollectorsInput, opts ...request.Option) (*DescribeFleetAdvisorCollectorsOutput, error) {
	req, out := c.DescribeFleetAdvisorCollectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAdvisorCollectorsPages iterates over the pages of a DescribeFleetAdvisorCollectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAdvisorCollectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAdvisorCollectors operation.
//	pageNum := 0
//	err := client.DescribeFleetAdvisorCollectorsPages(params,
//	    func(page *databasemigrationservice.DescribeFleetAdvisorCollectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeFleetAdvisorCollectorsPages(input *DescribeFleetAdvisorCollectorsInput, fn func(*DescribeFleetAdvisorCollectorsOutput, bool) bool) error {
	return c.DescribeFleetAdvisorCollectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAdvisorCollectorsPagesWithContext same as DescribeFleetAdvisorCollectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorCollectorsPagesWithContext(ctx aws.Context, input *DescribeFleetAdvisorCollectorsInput, fn func(*DescribeFleetAdvisorCollectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAdvisorCollectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAdvisorCollectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAdvisorCollectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetAdvisorDatabases = "DescribeFleetAdvisorDatabases"

// DescribeFleetAdvisorDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAdvisorDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAdvisorDatabases for more information on using the DescribeFleetAdvisorDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAdvisorDatabasesRequest method.
//	req, resp := client.DescribeFleetAdvisorDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases
func (c *DatabaseMigrationService) DescribeFleetAdvisorDatabasesRequest(input *DescribeFleetAdvisorDatabasesInput) (req *request.Request, output *DescribeFleetAdvisorDatabasesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAdvisorDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAdvisorDatabasesInput{}
	}

	output = &DescribeFleetAdvisorDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAdvisorDatabases API operation for AWS Database Migration Service.
//
// Returns a list of Fleet Advisor databases in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeFleetAdvisorDatabases for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases
func (c *DatabaseMigrationService) DescribeFleetAdvisorDatabases(input *DescribeFleetAdvisorDatabasesInput) (*DescribeFleetAdvisorDatabasesOutput, error) {
	req, out := c.DescribeFleetAdvisorDatabasesRequest(input)
	return out, req.Send()
}

// DescribeFleetAdvisorDatabasesWithContext is the same as DescribeFleetAdvisorDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAdvisorDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorDatabasesWithContext(ctx aws.Context, input *DescribeFleetAdvisorDatabasesInput, opts ...request.Option) (*DescribeFleetAdvisorDatabasesOutput, error) {
	req, out := c.DescribeFleetAdvisorDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAdvisorDatabasesPages iterates over the pages of a DescribeFleetAdvisorDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAdvisorDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAdvisorDatabases operation.
//	pageNum := 0
//	err := client.DescribeFleetAdvisorDatabasesPages(params,
//	    func(page *databasemigrationservice.DescribeFleetAdvisorDatabasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeFleetAdvisorDatabasesPages(input *DescribeFleetAdvisorDatabasesInput, fn func(*DescribeFleetAdvisorDatabasesOutput, bool) bool) error {
	return c.DescribeFleetAdvisorDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAdvisorDatabasesPagesWithContext same as DescribeFleetAdvisorDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorDatabasesPagesWithContext(ctx aws.Context, input *DescribeFleetAdvisorDatabasesInput, fn func(*DescribeFleetAdvisorDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAdvisorDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAdvisorDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAdvisorDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetAdvisorLsaAnalysis = "DescribeFleetAdvisorLsaAnalysis"

// DescribeFleetAdvisorLsaAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAdvisorLsaAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAdvisorLsaAnalysis for more information on using the DescribeFleetAdvisorLsaAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAdvisorLsaAnalysisRequest method.
//	req, resp := client.DescribeFleetAdvisorLsaAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis
func (c *DatabaseMigrationService) DescribeFleetAdvisorLsaAnalysisRequest(input *DescribeFleetAdvisorLsaAnalysisInput) (req *request.Request, output *DescribeFleetAdvisorLsaAnalysisOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAdvisorLsaAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAdvisorLsaAnalysisInput{}
	}

	output = &DescribeFleetAdvisorLsaAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAdvisorLsaAnalysis API operation for AWS Database Migration Service.
//
// Provides descriptions of large-scale assessment (LSA) analyses produced by
// your Fleet Advisor collectors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeFleetAdvisorLsaAnalysis for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis
func (c *DatabaseMigrationService) DescribeFleetAdvisorLsaAnalysis(input *DescribeFleetAdvisorLsaAnalysisInput) (*DescribeFleetAdvisorLsaAnalysisOutput, error) {
	req, out := c.DescribeFleetAdvisorLsaAnalysisRequest(input)
	return out, req.Send()
}

// DescribeFleetAdvisorLsaAnalysisWithContext is the same as DescribeFleetAdvisorLsaAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAdvisorLsaAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorLsaAnalysisWithContext(ctx aws.Context, input *DescribeFleetAdvisorLsaAnalysisInput, opts ...request.Option) (*DescribeFleetAdvisorLsaAnalysisOutput, error) {
	req, out := c.DescribeFleetAdvisorLsaAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAdvisorLsaAnalysisPages iterates over the pages of a DescribeFleetAdvisorLsaAnalysis operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAdvisorLsaAnalysis method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAdvisorLsaAnalysis operation.
//	pageNum := 0
//	err := client.DescribeFleetAdvisorLsaAnalysisPages(params,
//	    func(page *databasemigrationservice.DescribeFleetAdvisorLsaAnalysisOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeFleetAdvisorLsaAnalysisPages(input *DescribeFleetAdvisorLsaAnalysisInput, fn func(*DescribeFleetAdvisorLsaAnalysisOutput, bool) bool) error {
	return c.DescribeFleetAdvisorLsaAnalysisPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAdvisorLsaAnalysisPagesWithContext same as DescribeFleetAdvisorLsaAnalysisPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorLsaAnalysisPagesWithContext(ctx aws.Context, input *DescribeFleetAdvisorLsaAnalysisInput, fn func(*DescribeFleetAdvisorLsaAnalysisOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAdvisorLsaAnalysisInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAdvisorLsaAnalysisRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAdvisorLsaAnalysisOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetAdvisorSchemaObjectSummary = "DescribeFleetAdvisorSchemaObjectSummary"

// DescribeFleetAdvisorSchemaObjectSummaryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAdvisorSchemaObjectSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAdvisorSchemaObjectSummary for more information on using the DescribeFleetAdvisorSchemaObjectSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAdvisorSchemaObjectSummaryRequest method.
//	req, resp := client.DescribeFleetAdvisorSchemaObjectSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemaObjectSummaryRequest(input *DescribeFleetAdvisorSchemaObjectSummaryInput) (req *request.Request, output *DescribeFleetAdvisorSchemaObjectSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAdvisorSchemaObjectSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAdvisorSchemaObjectSummaryInput{}
	}

	output = &DescribeFleetAdvisorSchemaObjectSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAdvisorSchemaObjectSummary API operation for AWS Database Migration Service.
//
// Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeFleetAdvisorSchemaObjectSummary for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemaObjectSummary(input *DescribeFleetAdvisorSchemaObjectSummaryInput) (*DescribeFleetAdvisorSchemaObjectSummaryOutput, error) {
	req, out := c.DescribeFleetAdvisorSchemaObjectSummaryRequest(input)
	return out, req.Send()
}

// DescribeFleetAdvisorSchemaObjectSummaryWithContext is the same as DescribeFleetAdvisorSchemaObjectSummary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAdvisorSchemaObjectSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemaObjectSummaryWithContext(ctx aws.Context, input *DescribeFleetAdvisorSchemaObjectSummaryInput, opts ...request.Option) (*DescribeFleetAdvisorSchemaObjectSummaryOutput, error) {
	req, out := c.DescribeFleetAdvisorSchemaObjectSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAdvisorSchemaObjectSummaryPages iterates over the pages of a DescribeFleetAdvisorSchemaObjectSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAdvisorSchemaObjectSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAdvisorSchemaObjectSummary operation.
//	pageNum := 0
//	err := client.DescribeFleetAdvisorSchemaObjectSummaryPages(params,
//	    func(page *databasemigrationservice.DescribeFleetAdvisorSchemaObjectSummaryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemaObjectSummaryPages(input *DescribeFleetAdvisorSchemaObjectSummaryInput, fn func(*DescribeFleetAdvisorSchemaObjectSummaryOutput, bool) bool) error {
	return c.DescribeFleetAdvisorSchemaObjectSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAdvisorSchemaObjectSummaryPagesWithContext same as DescribeFleetAdvisorSchemaObjectSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemaObjectSummaryPagesWithContext(ctx aws.Context, input *DescribeFleetAdvisorSchemaObjectSummaryInput, fn func(*DescribeFleetAdvisorSchemaObjectSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAdvisorSchemaObjectSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAdvisorSchemaObjectSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAdvisorSchemaObjectSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetAdvisorSchemas = "DescribeFleetAdvisorSchemas"

// DescribeFleetAdvisorSchemasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAdvisorSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAdvisorSchemas for more information on using the DescribeFleetAdvisorSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAdvisorSchemasRequest method.
//	req, resp := client.DescribeFleetAdvisorSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemasRequest(input *DescribeFleetAdvisorSchemasInput) (req *request.Request, output *DescribeFleetAdvisorSchemasOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAdvisorSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAdvisorSchemasInput{}
	}

	output = &DescribeFleetAdvisorSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAdvisorSchemas API operation for AWS Database Migration Service.
//
// Returns a list of schemas detected by Fleet Advisor Collectors in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeFleetAdvisorSchemas for usage and error information.
//
// Returned Error Types:
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemas(input *DescribeFleetAdvisorSchemasInput) (*DescribeFleetAdvisorSchemasOutput, error) {
	req, out := c.DescribeFleetAdvisorSchemasRequest(input)
	return out, req.Send()
}

// DescribeFleetAdvisorSchemasWithContext is the same as DescribeFleetAdvisorSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAdvisorSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemasWithContext(ctx aws.Context, input *DescribeFleetAdvisorSchemasInput, opts ...request.Option) (*DescribeFleetAdvisorSchemasOutput, error) {
	req, out := c.DescribeFleetAdvisorSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAdvisorSchemasPages iterates over the pages of a DescribeFleetAdvisorSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAdvisorSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAdvisorSchemas operation.
//	pageNum := 0
//	err := client.DescribeFleetAdvisorSchemasPages(params,
//	    func(page *databasemigrationservice.DescribeFleetAdvisorSchemasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemasPages(input *DescribeFleetAdvisorSchemasInput, fn func(*DescribeFleetAdvisorSchemasOutput, bool) bool) error {
	return c.DescribeFleetAdvisorSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAdvisorSchemasPagesWithContext same as DescribeFleetAdvisorSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeFleetAdvisorSchemasPagesWithContext(ctx aws.Context, input *DescribeFleetAdvisorSchemasInput, fn func(*DescribeFleetAdvisorSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAdvisorSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAdvisorSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAdvisorSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceProfiles = "DescribeInstanceProfiles"

// DescribeInstanceProfilesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceProfiles for more information on using the DescribeInstanceProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceProfilesRequest method.
//	req, resp := client.DescribeInstanceProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles
func (c *DatabaseMigrationService) DescribeInstanceProfilesRequest(input *DescribeInstanceProfilesInput) (req *request.Request, output *DescribeInstanceProfilesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceProfilesInput{}
	}

	output = &DescribeInstanceProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceProfiles API operation for AWS Database Migration Service.
//
// Returns a paginated list of instance profiles for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeInstanceProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles
func (c *DatabaseMigrationService) DescribeInstanceProfiles(input *DescribeInstanceProfilesInput) (*DescribeInstanceProfilesOutput, error) {
	req, out := c.DescribeInstanceProfilesRequest(input)
	return out, req.Send()
}

// DescribeInstanceProfilesWithContext is the same as DescribeInstanceProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeInstanceProfilesWithContext(ctx aws.Context, input *DescribeInstanceProfilesInput, opts ...request.Option) (*DescribeInstanceProfilesOutput, error) {
	req, out := c.DescribeInstanceProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceProfilesPages iterates over the pages of a DescribeInstanceProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstanceProfiles operation.
//	pageNum := 0
//	err := client.DescribeInstanceProfilesPages(params,
//	    func(page *databasemigrationservice.DescribeInstanceProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeInstanceProfilesPages(input *DescribeInstanceProfilesInput, fn func(*DescribeInstanceProfilesOutput, bool) bool) error {
	return c.DescribeInstanceProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceProfilesPagesWithContext same as DescribeInstanceProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeInstanceProfilesPagesWithContext(ctx aws.Context, input *DescribeInstanceProfilesInput, fn func(*DescribeInstanceProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMetadataModelAssessments = "DescribeMetadataModelAssessments"

// DescribeMetadataModelAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetadataModelAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetadataModelAssessments for more information on using the DescribeMetadataModelAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetadataModelAssessmentsRequest method.
//	req, resp := client.DescribeMetadataModelAssessmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments
func (c *DatabaseMigrationService) DescribeMetadataModelAssessmentsRequest(input *DescribeMetadataModelAssessmentsInput) (req *request.Request, output *DescribeMetadataModelAssessmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeMetadataModelAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetadataModelAssessmentsInput{}
	}

	output = &DescribeMetadataModelAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetadataModelAssessments API operation for AWS Database Migration Service.
//
// Returns a paginated list of metadata model assessments for your account in
// the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMetadataModelAssessments for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments
func (c *DatabaseMigrationService) DescribeMetadataModelAssessments(input *DescribeMetadataModelAssessmentsInput) (*DescribeMetadataModelAssessmentsOutput, error) {
	req, out := c.DescribeMetadataModelAssessmentsRequest(input)
	return out, req.Send()
}

// DescribeMetadataModelAssessmentsWithContext is the same as DescribeMetadataModelAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetadataModelAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelAssessmentsWithContext(ctx aws.Context, input *DescribeMetadataModelAssessmentsInput, opts ...request.Option) (*DescribeMetadataModelAssessmentsOutput, error) {
	req, out := c.DescribeMetadataModelAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMetadataModelAssessmentsPages iterates over the pages of a DescribeMetadataModelAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMetadataModelAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMetadataModelAssessments operation.
//	pageNum := 0
//	err := client.DescribeMetadataModelAssessmentsPages(params,
//	    func(page *databasemigrationservice.DescribeMetadataModelAssessmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMetadataModelAssessmentsPages(input *DescribeMetadataModelAssessmentsInput, fn func(*DescribeMetadataModelAssessmentsOutput, bool) bool) error {
	return c.DescribeMetadataModelAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMetadataModelAssessmentsPagesWithContext same as DescribeMetadataModelAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelAssessmentsPagesWithContext(ctx aws.Context, input *DescribeMetadataModelAssessmentsInput, fn func(*DescribeMetadataModelAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMetadataModelAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMetadataModelAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMetadataModelAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMetadataModelConversions = "DescribeMetadataModelConversions"

// DescribeMetadataModelConversionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetadataModelConversions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetadataModelConversions for more information on using the DescribeMetadataModelConversions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetadataModelConversionsRequest method.
//	req, resp := client.DescribeMetadataModelConversionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions
func (c *DatabaseMigrationService) DescribeMetadataModelConversionsRequest(input *DescribeMetadataModelConversionsInput) (req *request.Request, output *DescribeMetadataModelConversionsOutput) {
	op := &request.Operation{
		Name:       opDescribeMetadataModelConversions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetadataModelConversionsInput{}
	}

	output = &DescribeMetadataModelConversionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetadataModelConversions API operation for AWS Database Migration Service.
//
// Returns a paginated list of metadata model conversions for a migration project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMetadataModelConversions for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions
func (c *DatabaseMigrationService) DescribeMetadataModelConversions(input *DescribeMetadataModelConversionsInput) (*DescribeMetadataModelConversionsOutput, error) {
	req, out := c.DescribeMetadataModelConversionsRequest(input)
	return out, req.Send()
}

// DescribeMetadataModelConversionsWithContext is the same as DescribeMetadataModelConversions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetadataModelConversions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelConversionsWithContext(ctx aws.Context, input *DescribeMetadataModelConversionsInput, opts ...request.Option) (*DescribeMetadataModelConversionsOutput, error) {
	req, out := c.DescribeMetadataModelConversionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMetadataModelConversionsPages iterates over the pages of a DescribeMetadataModelConversions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMetadataModelConversions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMetadataModelConversions operation.
//	pageNum := 0
//	err := client.DescribeMetadataModelConversionsPages(params,
//	    func(page *databasemigrationservice.DescribeMetadataModelConversionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMetadataModelConversionsPages(input *DescribeMetadataModelConversionsInput, fn func(*DescribeMetadataModelConversionsOutput, bool) bool) error {
	return c.DescribeMetadataModelConversionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMetadataModelConversionsPagesWithContext same as DescribeMetadataModelConversionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelConversionsPagesWithContext(ctx aws.Context, input *DescribeMetadataModelConversionsInput, fn func(*DescribeMetadataModelConversionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMetadataModelConversionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMetadataModelConversionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMetadataModelConversionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMetadataModelExportsAsScript = "DescribeMetadataModelExportsAsScript"

// DescribeMetadataModelExportsAsScriptRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetadataModelExportsAsScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetadataModelExportsAsScript for more information on using the DescribeMetadataModelExportsAsScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetadataModelExportsAsScriptRequest method.
//	req, resp := client.DescribeMetadataModelExportsAsScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript
func (c *DatabaseMigrationService) DescribeMetadataModelExportsAsScriptRequest(input *DescribeMetadataModelExportsAsScriptInput) (req *request.Request, output *DescribeMetadataModelExportsAsScriptOutput) {
	op := &request.Operation{
		Name:       opDescribeMetadataModelExportsAsScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetadataModelExportsAsScriptInput{}
	}

	output = &DescribeMetadataModelExportsAsScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetadataModelExportsAsScript API operation for AWS Database Migration Service.
//
// Returns a paginated list of metadata model exports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMetadataModelExportsAsScript for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript
func (c *DatabaseMigrationService) DescribeMetadataModelExportsAsScript(input *DescribeMetadataModelExportsAsScriptInput) (*DescribeMetadataModelExportsAsScriptOutput, error) {
	req, out := c.DescribeMetadataModelExportsAsScriptRequest(input)
	return out, req.Send()
}

// DescribeMetadataModelExportsAsScriptWithContext is the same as DescribeMetadataModelExportsAsScript with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetadataModelExportsAsScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelExportsAsScriptWithContext(ctx aws.Context, input *DescribeMetadataModelExportsAsScriptInput, opts ...request.Option) (*DescribeMetadataModelExportsAsScriptOutput, error) {
	req, out := c.DescribeMetadataModelExportsAsScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMetadataModelExportsAsScriptPages iterates over the pages of a DescribeMetadataModelExportsAsScript operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMetadataModelExportsAsScript method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMetadataModelExportsAsScript operation.
//	pageNum := 0
//	err := client.DescribeMetadataModelExportsAsScriptPages(params,
//	    func(page *databasemigrationservice.DescribeMetadataModelExportsAsScriptOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMetadataModelExportsAsScriptPages(input *DescribeMetadataModelExportsAsScriptInput, fn func(*DescribeMetadataModelExportsAsScriptOutput, bool) bool) error {
	return c.DescribeMetadataModelExportsAsScriptPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMetadataModelExportsAsScriptPagesWithContext same as DescribeMetadataModelExportsAsScriptPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelExportsAsScriptPagesWithContext(ctx aws.Context, input *DescribeMetadataModelExportsAsScriptInput, fn func(*DescribeMetadataModelExportsAsScriptOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMetadataModelExportsAsScriptInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMetadataModelExportsAsScriptRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMetadataModelExportsAsScriptOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMetadataModelExportsToTarget = "DescribeMetadataModelExportsToTarget"

// DescribeMetadataModelExportsToTargetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetadataModelExportsToTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetadataModelExportsToTarget for more information on using the DescribeMetadataModelExportsToTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetadataModelExportsToTargetRequest method.
//	req, resp := client.DescribeMetadataModelExportsToTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget
func (c *DatabaseMigrationService) DescribeMetadataModelExportsToTargetRequest(input *DescribeMetadataModelExportsToTargetInput) (req *request.Request, output *DescribeMetadataModelExportsToTargetOutput) {
	op := &request.Operation{
		Name:       opDescribeMetadataModelExportsToTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetadataModelExportsToTargetInput{}
	}

	output = &DescribeMetadataModelExportsToTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetadataModelExportsToTarget API operation for AWS Database Migration Service.
//
// Returns a paginated list of metadata model exports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMetadataModelExportsToTarget for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget
func (c *DatabaseMigrationService) DescribeMetadataModelExportsToTarget(input *DescribeMetadataModelExportsToTargetInput) (*DescribeMetadataModelExportsToTargetOutput, error) {
	req, out := c.DescribeMetadataModelExportsToTargetRequest(input)
	return out, req.Send()
}

// DescribeMetadataModelExportsToTargetWithContext is the same as DescribeMetadataModelExportsToTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetadataModelExportsToTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelExportsToTargetWithContext(ctx aws.Context, input *DescribeMetadataModelExportsToTargetInput, opts ...request.Option) (*DescribeMetadataModelExportsToTargetOutput, error) {
	req, out := c.DescribeMetadataModelExportsToTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMetadataModelExportsToTargetPages iterates over the pages of a DescribeMetadataModelExportsToTarget operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMetadataModelExportsToTarget method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMetadataModelExportsToTarget operation.
//	pageNum := 0
//	err := client.DescribeMetadataModelExportsToTargetPages(params,
//	    func(page *databasemigrationservice.DescribeMetadataModelExportsToTargetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMetadataModelExportsToTargetPages(input *DescribeMetadataModelExportsToTargetInput, fn func(*DescribeMetadataModelExportsToTargetOutput, bool) bool) error {
	return c.DescribeMetadataModelExportsToTargetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMetadataModelExportsToTargetPagesWithContext same as DescribeMetadataModelExportsToTargetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelExportsToTargetPagesWithContext(ctx aws.Context, input *DescribeMetadataModelExportsToTargetInput, fn func(*DescribeMetadataModelExportsToTargetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMetadataModelExportsToTargetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMetadataModelExportsToTargetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMetadataModelExportsToTargetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMetadataModelImports = "DescribeMetadataModelImports"

// DescribeMetadataModelImportsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetadataModelImports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetadataModelImports for more information on using the DescribeMetadataModelImports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetadataModelImportsRequest method.
//	req, resp := client.DescribeMetadataModelImportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports
func (c *DatabaseMigrationService) DescribeMetadataModelImportsRequest(input *DescribeMetadataModelImportsInput) (req *request.Request, output *DescribeMetadataModelImportsOutput) {
	op := &request.Operation{
		Name:       opDescribeMetadataModelImports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetadataModelImportsInput{}
	}

	output = &DescribeMetadataModelImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetadataModelImports API operation for AWS Database Migration Service.
//
// Returns a paginated list of metadata model imports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMetadataModelImports for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports
func (c *DatabaseMigrationService) DescribeMetadataModelImports(input *DescribeMetadataModelImportsInput) (*DescribeMetadataModelImportsOutput, error) {
	req, out := c.DescribeMetadataModelImportsRequest(input)
	return out, req.Send()
}

// DescribeMetadataModelImportsWithContext is the same as DescribeMetadataModelImports with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetadataModelImports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelImportsWithContext(ctx aws.Context, input *DescribeMetadataModelImportsInput, opts ...request.Option) (*DescribeMetadataModelImportsOutput, error) {
	req, out := c.DescribeMetadataModelImportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMetadataModelImportsPages iterates over the pages of a DescribeMetadataModelImports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMetadataModelImports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMetadataModelImports operation.
//	pageNum := 0
//	err := client.DescribeMetadataModelImportsPages(params,
//	    func(page *databasemigrationservice.DescribeMetadataModelImportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMetadataModelImportsPages(input *DescribeMetadataModelImportsInput, fn func(*DescribeMetadataModelImportsOutput, bool) bool) error {
	return c.DescribeMetadataModelImportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMetadataModelImportsPagesWithContext same as DescribeMetadataModelImportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMetadataModelImportsPagesWithContext(ctx aws.Context, input *DescribeMetadataModelImportsInput, fn func(*DescribeMetadataModelImportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMetadataModelImportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMetadataModelImportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMetadataModelImportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMigrationProjects = "DescribeMigrationProjects"

// DescribeMigrationProjectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMigrationProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMigrationProjects for more information on using the DescribeMigrationProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMigrationProjectsRequest method.
//	req, resp := client.DescribeMigrationProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects
func (c *DatabaseMigrationService) DescribeMigrationProjectsRequest(input *DescribeMigrationProjectsInput) (req *request.Request, output *DescribeMigrationProjectsOutput) {
	op := &request.Operation{
		Name:       opDescribeMigrationProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMigrationProjectsInput{}
	}

	output = &DescribeMigrationProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMigrationProjects API operation for AWS Database Migration Service.
//
// Returns a paginated list of migration projects for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeMigrationProjects for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects
func (c *DatabaseMigrationService) DescribeMigrationProjects(input *DescribeMigrationProjectsInput) (*DescribeMigrationProjectsOutput, error) {
	req, out := c.DescribeMigrationProjectsRequest(input)
	return out, req.Send()
}

// DescribeMigrationProjectsWithContext is the same as DescribeMigrationProjects with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMigrationProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMigrationProjectsWithContext(ctx aws.Context, input *DescribeMigrationProjectsInput, opts ...request.Option) (*DescribeMigrationProjectsOutput, error) {
	req, out := c.DescribeMigrationProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMigrationProjectsPages iterates over the pages of a DescribeMigrationProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMigrationProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMigrationProjects operation.
//	pageNum := 0
//	err := client.DescribeMigrationProjectsPages(params,
//	    func(page *databasemigrationservice.DescribeMigrationProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeMigrationProjectsPages(input *DescribeMigrationProjectsInput, fn func(*DescribeMigrationProjectsOutput, bool) bool) error {
	return c.DescribeMigrationProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMigrationProjectsPagesWithContext same as DescribeMigrationProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeMigrationProjectsPagesWithContext(ctx aws.Context, input *DescribeMigrationProjectsInput, fn func(*DescribeMigrationProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMigrationProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMigrationProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMigrationProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrderableReplicationInstances = "DescribeOrderableReplicationInstances"

// DescribeOrderableReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableReplicationInstances for more information on using the DescribeOrderableReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrderableReplicationInstancesRequest method.
//	req, resp := client.DescribeOrderableReplicationInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesRequest(input *DescribeOrderableReplicationInstancesInput) (req *request.Request, output *DescribeOrderableReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableReplicationInstancesInput{}
	}

	output = &DescribeOrderableReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about the replication instance types that can be created
// in the specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeOrderableReplicationInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstances(input *DescribeOrderableReplicationInstancesInput) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesWithContext is the same as DescribeOrderableReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, opts ...request.Option) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesPages iterates over the pages of a DescribeOrderableReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeOrderableReplicationInstances operation.
//	pageNum := 0
//	err := client.DescribeOrderableReplicationInstancesPages(params,
//	    func(page *databasemigrationservice.DescribeOrderableReplicationInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPages(input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool) error {
	return c.DescribeOrderableReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableReplicationInstancesPagesWithContext same as DescribeOrderableReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrderableReplicationInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//	req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for AWS Database Migration Service.
//
// # For internal use only
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions
func (c *DatabaseMigrationService) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsPages iterates over the pages of a DescribePendingMaintenanceActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePendingMaintenanceActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePendingMaintenanceActions operation.
//	pageNum := 0
//	err := client.DescribePendingMaintenanceActionsPages(params,
//	    func(page *databasemigrationservice.DescribePendingMaintenanceActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsPages(input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool) error {
	return c.DescribePendingMaintenanceActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePendingMaintenanceActionsPagesWithContext same as DescribePendingMaintenanceActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsPagesWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePendingMaintenanceActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePendingMaintenanceActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePendingMaintenanceActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRecommendationLimitations = "DescribeRecommendationLimitations"

// DescribeRecommendationLimitationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecommendationLimitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecommendationLimitations for more information on using the DescribeRecommendationLimitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecommendationLimitationsRequest method.
//	req, resp := client.DescribeRecommendationLimitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations
func (c *DatabaseMigrationService) DescribeRecommendationLimitationsRequest(input *DescribeRecommendationLimitationsInput) (req *request.Request, output *DescribeRecommendationLimitationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRecommendationLimitations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRecommendationLimitationsInput{}
	}

	output = &DescribeRecommendationLimitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecommendationLimitations API operation for AWS Database Migration Service.
//
// Returns a paginated list of limitations for recommendations of target Amazon
// Web Services engines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRecommendationLimitations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations
func (c *DatabaseMigrationService) DescribeRecommendationLimitations(input *DescribeRecommendationLimitationsInput) (*DescribeRecommendationLimitationsOutput, error) {
	req, out := c.DescribeRecommendationLimitationsRequest(input)
	return out, req.Send()
}

// DescribeRecommendationLimitationsWithContext is the same as DescribeRecommendationLimitations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecommendationLimitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRecommendationLimitationsWithContext(ctx aws.Context, input *DescribeRecommendationLimitationsInput, opts ...request.Option) (*DescribeRecommendationLimitationsOutput, error) {
	req, out := c.DescribeRecommendationLimitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRecommendationLimitationsPages iterates over the pages of a DescribeRecommendationLimitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRecommendationLimitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRecommendationLimitations operation.
//	pageNum := 0
//	err := client.DescribeRecommendationLimitationsPages(params,
//	    func(page *databasemigrationservice.DescribeRecommendationLimitationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeRecommendationLimitationsPages(input *DescribeRecommendationLimitationsInput, fn func(*DescribeRecommendationLimitationsOutput, bool) bool) error {
	return c.DescribeRecommendationLimitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRecommendationLimitationsPagesWithContext same as DescribeRecommendationLimitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRecommendationLimitationsPagesWithContext(ctx aws.Context, input *DescribeRecommendationLimitationsInput, fn func(*DescribeRecommendationLimitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRecommendationLimitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRecommendationLimitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRecommendationLimitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRecommendations = "DescribeRecommendations"

// DescribeRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecommendations for more information on using the DescribeRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecommendationsRequest method.
//	req, resp := client.DescribeRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations
func (c *DatabaseMigrationService) DescribeRecommendationsRequest(input *DescribeRecommendationsInput) (req *request.Request, output *DescribeRecommendationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRecommendationsInput{}
	}

	output = &DescribeRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecommendations API operation for AWS Database Migration Service.
//
// Returns a paginated list of target engine recommendations for your source
// databases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations
func (c *DatabaseMigrationService) DescribeRecommendations(input *DescribeRecommendationsInput) (*DescribeRecommendationsOutput, error) {
	req, out := c.DescribeRecommendationsRequest(input)
	return out, req.Send()
}

// DescribeRecommendationsWithContext is the same as DescribeRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRecommendationsWithContext(ctx aws.Context, input *DescribeRecommendationsInput, opts ...request.Option) (*DescribeRecommendationsOutput, error) {
	req, out := c.DescribeRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRecommendationsPages iterates over the pages of a DescribeRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRecommendations operation.
//	pageNum := 0
//	err := client.DescribeRecommendationsPages(params,
//	    func(page *databasemigrationservice.DescribeRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeRecommendationsPages(input *DescribeRecommendationsInput, fn func(*DescribeRecommendationsOutput, bool) bool) error {
	return c.DescribeRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRecommendationsPagesWithContext same as DescribeRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRecommendationsPagesWithContext(ctx aws.Context, input *DescribeRecommendationsInput, fn func(*DescribeRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRefreshSchemasStatus = "DescribeRefreshSchemasStatus"

// DescribeRefreshSchemasStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchemasStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRefreshSchemasStatus for more information on using the DescribeRefreshSchemasStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRefreshSchemasStatusRequest method.
//	req, resp := client.DescribeRefreshSchemasStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusRequest(input *DescribeRefreshSchemasStatusInput) (req *request.Request, output *DescribeRefreshSchemasStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchemasStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRefreshSchemasStatusInput{}
	}

	output = &DescribeRefreshSchemasStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRefreshSchemasStatus API operation for AWS Database Migration Service.
//
// Returns the status of the RefreshSchemas operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRefreshSchemasStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatus(input *DescribeRefreshSchemasStatusInput) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	return out, req.Send()
}

// DescribeRefreshSchemasStatusWithContext is the same as DescribeRefreshSchemasStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRefreshSchemasStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusWithContext(ctx aws.Context, input *DescribeRefreshSchemasStatusInput, opts ...request.Option) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReplicationConfigs = "DescribeReplicationConfigs"

// DescribeReplicationConfigsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationConfigs for more information on using the DescribeReplicationConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationConfigsRequest method.
//	req, resp := client.DescribeReplicationConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs
func (c *DatabaseMigrationService) DescribeReplicationConfigsRequest(input *DescribeReplicationConfigsInput) (req *request.Request, output *DescribeReplicationConfigsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationConfigsInput{}
	}

	output = &DescribeReplicationConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationConfigs API operation for AWS Database Migration Service.
//
// Returns one or more existing DMS Serverless replication configurations as
// a list of structures.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationConfigs for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs
func (c *DatabaseMigrationService) DescribeReplicationConfigs(input *DescribeReplicationConfigsInput) (*DescribeReplicationConfigsOutput, error) {
	req, out := c.DescribeReplicationConfigsRequest(input)
	return out, req.Send()
}

// DescribeReplicationConfigsWithContext is the same as DescribeReplicationConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationConfigsWithContext(ctx aws.Context, input *DescribeReplicationConfigsInput, opts ...request.Option) (*DescribeReplicationConfigsOutput, error) {
	req, out := c.DescribeReplicationConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationConfigsPages iterates over the pages of a DescribeReplicationConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationConfigs operation.
//	pageNum := 0
//	err := client.DescribeReplicationConfigsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationConfigsPages(input *DescribeReplicationConfigsInput, fn func(*DescribeReplicationConfigsOutput, bool) bool) error {
	return c.DescribeReplicationConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationConfigsPagesWithContext same as DescribeReplicationConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationConfigsPagesWithContext(ctx aws.Context, input *DescribeReplicationConfigsInput, fn func(*DescribeReplicationConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationInstanceTaskLogs = "DescribeReplicationInstanceTaskLogs"

// DescribeReplicationInstanceTaskLogsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstanceTaskLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationInstanceTaskLogs for more information on using the DescribeReplicationInstanceTaskLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationInstanceTaskLogsRequest method.
//	req, resp := client.DescribeReplicationInstanceTaskLogsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsRequest(input *DescribeReplicationInstanceTaskLogsInput) (req *request.Request, output *DescribeReplicationInstanceTaskLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstanceTaskLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstanceTaskLogsInput{}
	}

	output = &DescribeReplicationInstanceTaskLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationInstanceTaskLogs API operation for AWS Database Migration Service.
//
// Returns information about the task logs for the specified task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstanceTaskLogs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogs(input *DescribeReplicationInstanceTaskLogsInput) (*DescribeReplicationInstanceTaskLogsOutput, error) {
	req, out := c.DescribeReplicationInstanceTaskLogsRequest(input)
	return out, req.Send()
}

// DescribeReplicationInstanceTaskLogsWithContext is the same as DescribeReplicationInstanceTaskLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationInstanceTaskLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsWithContext(ctx aws.Context, input *DescribeReplicationInstanceTaskLogsInput, opts ...request.Option) (*DescribeReplicationInstanceTaskLogsOutput, error) {
	req, out := c.DescribeReplicationInstanceTaskLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationInstanceTaskLogsPages iterates over the pages of a DescribeReplicationInstanceTaskLogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationInstanceTaskLogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationInstanceTaskLogs operation.
//	pageNum := 0
//	err := client.DescribeReplicationInstanceTaskLogsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationInstanceTaskLogsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsPages(input *DescribeReplicationInstanceTaskLogsInput, fn func(*DescribeReplicationInstanceTaskLogsOutput, bool) bool) error {
	return c.DescribeReplicationInstanceTaskLogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationInstanceTaskLogsPagesWithContext same as DescribeReplicationInstanceTaskLogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsPagesWithContext(ctx aws.Context, input *DescribeReplicationInstanceTaskLogsInput, fn func(*DescribeReplicationInstanceTaskLogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationInstanceTaskLogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationInstanceTaskLogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationInstanceTaskLogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationInstances = "DescribeReplicationInstances"

// DescribeReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationInstances for more information on using the DescribeReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationInstancesRequest method.
//	req, resp := client.DescribeReplicationInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstancesRequest(input *DescribeReplicationInstancesInput) (req *request.Request, output *DescribeReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstancesInput{}
	}

	output = &DescribeReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about replication instances for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstances for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstances(input *DescribeReplicationInstancesInput) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeReplicationInstancesWithContext is the same as DescribeReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, opts ...request.Option) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationInstancesPages iterates over the pages of a DescribeReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationInstances operation.
//	pageNum := 0
//	err := client.DescribeReplicationInstancesPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationInstancesPages(input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool) error {
	return c.DescribeReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationInstancesPagesWithContext same as DescribeReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationSubnetGroups = "DescribeReplicationSubnetGroups"

// DescribeReplicationSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationSubnetGroups for more information on using the DescribeReplicationSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationSubnetGroupsRequest method.
//	req, resp := client.DescribeReplicationSubnetGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsRequest(input *DescribeReplicationSubnetGroupsInput) (req *request.Request, output *DescribeReplicationSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationSubnetGroupsInput{}
	}

	output = &DescribeReplicationSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationSubnetGroups API operation for AWS Database Migration Service.
//
// Returns information about the replication subnet groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationSubnetGroups for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroups(input *DescribeReplicationSubnetGroupsInput) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsWithContext is the same as DescribeReplicationSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, opts ...request.Option) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsPages iterates over the pages of a DescribeReplicationSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationSubnetGroups operation.
//	pageNum := 0
//	err := client.DescribeReplicationSubnetGroupsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationSubnetGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPages(input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool) error {
	return c.DescribeReplicationSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationSubnetGroupsPagesWithContext same as DescribeReplicationSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTableStatistics = "DescribeReplicationTableStatistics"

// DescribeReplicationTableStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTableStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTableStatistics for more information on using the DescribeReplicationTableStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationTableStatisticsRequest method.
//	req, resp := client.DescribeReplicationTableStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics
func (c *DatabaseMigrationService) DescribeReplicationTableStatisticsRequest(input *DescribeReplicationTableStatisticsInput) (req *request.Request, output *DescribeReplicationTableStatisticsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTableStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTableStatisticsInput{}
	}

	output = &DescribeReplicationTableStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTableStatistics API operation for AWS Database Migration Service.
//
// Returns table and schema statistics for one or more provisioned replications
// that use a given DMS Serverless replication configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTableStatistics for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics
func (c *DatabaseMigrationService) DescribeReplicationTableStatistics(input *DescribeReplicationTableStatisticsInput) (*DescribeReplicationTableStatisticsOutput, error) {
	req, out := c.DescribeReplicationTableStatisticsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTableStatisticsWithContext is the same as DescribeReplicationTableStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTableStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTableStatisticsWithContext(ctx aws.Context, input *DescribeReplicationTableStatisticsInput, opts ...request.Option) (*DescribeReplicationTableStatisticsOutput, error) {
	req, out := c.DescribeReplicationTableStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTableStatisticsPages iterates over the pages of a DescribeReplicationTableStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTableStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationTableStatistics operation.
//	pageNum := 0
//	err := client.DescribeReplicationTableStatisticsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationTableStatisticsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationTableStatisticsPages(input *DescribeReplicationTableStatisticsInput, fn func(*DescribeReplicationTableStatisticsOutput, bool) bool) error {
	return c.DescribeReplicationTableStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTableStatisticsPagesWithContext same as DescribeReplicationTableStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTableStatisticsPagesWithContext(ctx aws.Context, input *DescribeReplicationTableStatisticsInput, fn func(*DescribeReplicationTableStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTableStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTableStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTableStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskAssessmentResults = "DescribeReplicationTaskAssessmentResults"

// DescribeReplicationTaskAssessmentResultsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskAssessmentResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskAssessmentResults for more information on using the DescribeReplicationTaskAssessmentResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationTaskAssessmentResultsRequest method.
//	req, resp := client.DescribeReplicationTaskAssessmentResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsRequest(input *DescribeReplicationTaskAssessmentResultsInput) (req *request.Request, output *DescribeReplicationTaskAssessmentResultsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskAssessmentResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskAssessmentResultsInput{}
	}

	output = &DescribeReplicationTaskAssessmentResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskAssessmentResults API operation for AWS Database Migration Service.
//
// Returns the task assessment results from the Amazon S3 bucket that DMS creates
// in your Amazon Web Services account. This action always returns the latest
// results.
//
// For more information about DMS task assessments, see Creating a task assessment
// report (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskAssessmentResults for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResults(input *DescribeReplicationTaskAssessmentResultsInput) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsWithContext is the same as DescribeReplicationTaskAssessmentResults with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskAssessmentResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, opts ...request.Option) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsPages iterates over the pages of a DescribeReplicationTaskAssessmentResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskAssessmentResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationTaskAssessmentResults operation.
//	pageNum := 0
//	err := client.DescribeReplicationTaskAssessmentResultsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationTaskAssessmentResultsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPages(input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool) error {
	return c.DescribeReplicationTaskAssessmentResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskAssessmentResultsPagesWithContext same as DescribeReplicationTaskAssessmentResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskAssessmentResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskAssessmentResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskAssessmentResultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskAssessmentRuns = "DescribeReplicationTaskAssessmentRuns"

// DescribeReplicationTaskAssessmentRunsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskAssessmentRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskAssessmentRuns for more information on using the DescribeReplicationTaskAssessmentRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationTaskAssessmentRunsRequest method.
//	req, resp := client.DescribeReplicationTaskAssessmentRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsRequest(input *DescribeReplicationTaskAssessmentRunsInput) (req *request.Request, output *DescribeReplicationTaskAssessmentRunsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskAssessmentRunsInput{}
	}

	output = &DescribeReplicationTaskAssessmentRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskAssessmentRuns API operation for AWS Database Migration Service.
//
// Returns a paginated list of premigration assessment runs based on filter
// settings.
//
// These filter settings can specify a combination of premigration assessment
// runs, migration tasks, replication instances, and assessment run status values.
//
// This operation doesn't return information about individual assessments. For
// this information, see the DescribeReplicationTaskIndividualAssessments operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskAssessmentRuns for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRuns(input *DescribeReplicationTaskAssessmentRunsInput) (*DescribeReplicationTaskAssessmentRunsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentRunsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentRunsWithContext is the same as DescribeReplicationTaskAssessmentRuns with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskAssessmentRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentRunsInput, opts ...request.Option) (*DescribeReplicationTaskAssessmentRunsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentRunsPages iterates over the pages of a DescribeReplicationTaskAssessmentRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskAssessmentRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationTaskAssessmentRuns operation.
//	pageNum := 0
//	err := client.DescribeReplicationTaskAssessmentRunsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationTaskAssessmentRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsPages(input *DescribeReplicationTaskAssessmentRunsInput, fn func(*DescribeReplicationTaskAssessmentRunsOutput, bool) bool) error {
	return c.DescribeReplicationTaskAssessmentRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskAssessmentRunsPagesWithContext same as DescribeReplicationTaskAssessmentRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentRunsInput, fn func(*DescribeReplicationTaskAssessmentRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskAssessmentRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskAssessmentRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskAssessmentRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskIndividualAssessments = "DescribeReplicationTaskIndividualAssessments"

// DescribeReplicationTaskIndividualAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskIndividualAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskIndividualAssessments for more information on using the DescribeReplicationTaskIndividualAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationTaskIndividualAssessmentsRequest method.
//	req, resp := client.DescribeReplicationTaskIndividualAssessmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsRequest(input *DescribeReplicationTaskIndividualAssessmentsInput) (req *request.Request, output *DescribeReplicationTaskIndividualAssessmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskIndividualAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskIndividualAssessmentsInput{}
	}

	output = &DescribeReplicationTaskIndividualAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskIndividualAssessments API operation for AWS Database Migration Service.
//
// Returns a paginated list of individual assessments based on filter settings.
//
// These filter settings can specify a combination of premigration assessment
// runs, migration tasks, and assessment status values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskIndividualAssessments for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessments(input *DescribeReplicationTaskIndividualAssessmentsInput) (*DescribeReplicationTaskIndividualAssessmentsOutput, error) {
	req, out := c.DescribeReplicationTaskIndividualAssessmentsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskIndividualAssessmentsWithContext is the same as DescribeReplicationTaskIndividualAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskIndividualAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsWithContext(ctx aws.Context, input *DescribeReplicationTaskIndividualAssessmentsInput, opts ...request.Option) (*DescribeReplicationTaskIndividualAssessmentsOutput, error) {
	req, out := c.DescribeReplicationTaskIndividualAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskIndividualAssessmentsPages iterates over the pages of a DescribeReplicationTaskIndividualAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskIndividualAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationTaskIndividualAssessments operation.
//	pageNum := 0
//	err := client.DescribeReplicationTaskIndividualAssessmentsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationTaskIndividualAssessmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsPages(input *DescribeReplicationTaskIndividualAssessmentsInput, fn func(*DescribeReplicationTaskIndividualAssessmentsOutput, bool) bool) error {
	return c.DescribeReplicationTaskIndividualAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskIndividualAssessmentsPagesWithContext same as DescribeReplicationTaskIndividualAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskIndividualAssessmentsInput, fn func(*DescribeReplicationTaskIndividualAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskIndividualAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskIndividualAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskIndividualAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTasks = "DescribeReplicationTasks"

// DescribeReplicationTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTasks for more information on using the DescribeReplicationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationTasksRequest method.
//	req, resp := client.DescribeReplicationTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasksRequest(input *DescribeReplicationTasksInput) (req *request.Request, output *DescribeReplicationTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTasksInput{}
	}

	output = &DescribeReplicationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTasks API operation for AWS Database Migration Service.
//
// Returns information about replication tasks for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTasks for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasks(input *DescribeReplicationTasksInput) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	return out, req.Send()
}

// DescribeReplicationTasksWithContext is the same as DescribeReplicationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, opts ...request.Option) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTasksPages iterates over the pages of a DescribeReplicationTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplicationTasks operation.
//	pageNum := 0
//	err := client.DescribeReplicationTasksPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationTasksPages(input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool) error {
	return c.DescribeReplicationTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTasksPagesWithContext same as DescribeReplicationTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksPagesWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplications = "DescribeReplications"

// DescribeReplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplications for more information on using the DescribeReplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationsRequest method.
//	req, resp := client.DescribeReplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications
func (c *DatabaseMigrationService) DescribeReplicationsRequest(input *DescribeReplicationsInput) (req *request.Request, output *DescribeReplicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationsInput{}
	}

	output = &DescribeReplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplications API operation for AWS Database Migration Service.
//
// Provides details on replication progress by returning status information
// for one or more provisioned DMS Serverless replications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplications for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications
func (c *DatabaseMigrationService) DescribeReplications(input *DescribeReplicationsInput) (*DescribeReplicationsOutput, error) {
	req, out := c.DescribeReplicationsRequest(input)
	return out, req.Send()
}

// DescribeReplicationsWithContext is the same as DescribeReplications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationsWithContext(ctx aws.Context, input *DescribeReplicationsInput, opts ...request.Option) (*DescribeReplicationsOutput, error) {
	req, out := c.DescribeReplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationsPages iterates over the pages of a DescribeReplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReplications operation.
//	pageNum := 0
//	err := client.DescribeReplicationsPages(params,
//	    func(page *databasemigrationservice.DescribeReplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeReplicationsPages(input *DescribeReplicationsInput, fn func(*DescribeReplicationsOutput, bool) bool) error {
	return c.DescribeReplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationsPagesWithContext same as DescribeReplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationsPagesWithContext(ctx aws.Context, input *DescribeReplicationsInput, fn func(*DescribeReplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSchemas = "DescribeSchemas"

// DescribeSchemasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchemas for more information on using the DescribeSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSchemasRequest method.
//	req, resp := client.DescribeSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemasRequest(input *DescribeSchemasInput) (req *request.Request, output *DescribeSchemasOutput) {
	op := &request.Operation{
		Name:       opDescribeSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSchemasInput{}
	}

	output = &DescribeSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchemas API operation for AWS Database Migration Service.
//
// Returns information about the schema for the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeSchemas for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemas(input *DescribeSchemasInput) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	return out, req.Send()
}

// DescribeSchemasWithContext is the same as DescribeSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasWithContext(ctx aws.Context, input *DescribeSchemasInput, opts ...request.Option) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSchemasPages iterates over the pages of a DescribeSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSchemas operation.
//	pageNum := 0
//	err := client.DescribeSchemasPages(params,
//	    func(page *databasemigrationservice.DescribeSchemasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeSchemasPages(input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool) error {
	return c.DescribeSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSchemasPagesWithContext same as DescribeSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasPagesWithContext(ctx aws.Context, input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTableStatistics = "DescribeTableStatistics"

// DescribeTableStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableStatistics for more information on using the DescribeTableStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTableStatisticsRequest method.
//	req, resp := client.DescribeTableStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatisticsRequest(input *DescribeTableStatisticsInput) (req *request.Request, output *DescribeTableStatisticsOutput) {
	op := &request.Operation{
		Name:       opDescribeTableStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTableStatisticsInput{}
	}

	output = &DescribeTableStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableStatistics API operation for AWS Database Migration Service.
//
// Returns table statistics on the database migration task, including table
// name, rows inserted, rows updated, and rows deleted.
//
// Note that the "last updated" column the DMS console only indicates the time
// that DMS last updated the table statistics record for a table. It does not
// indicate the time of the last update to the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeTableStatistics for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatistics(input *DescribeTableStatisticsInput) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	return out, req.Send()
}

// DescribeTableStatisticsWithContext is the same as DescribeTableStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, opts ...request.Option) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTableStatisticsPages iterates over the pages of a DescribeTableStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTableStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeTableStatistics operation.
//	pageNum := 0
//	err := client.DescribeTableStatisticsPages(params,
//	    func(page *databasemigrationservice.DescribeTableStatisticsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DatabaseMigrationService) DescribeTableStatisticsPages(input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool) error {
	return c.DescribeTableStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTableStatisticsPagesWithContext same as DescribeTableStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsPagesWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTableStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTableStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTableStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opExportMetadataModelAssessment = "ExportMetadataModelAssessment"

// ExportMetadataModelAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the ExportMetadataModelAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportMetadataModelAssessment for more information on using the ExportMetadataModelAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportMetadataModelAssessmentRequest method.
//	req, resp := client.ExportMetadataModelAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment
func (c *DatabaseMigrationService) ExportMetadataModelAssessmentRequest(input *ExportMetadataModelAssessmentInput) (req *request.Request, output *ExportMetadataModelAssessmentOutput) {
	op := &request.Operation{
		Name:       opExportMetadataModelAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportMetadataModelAssessmentInput{}
	}

	output = &ExportMetadataModelAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportMetadataModelAssessment API operation for AWS Database Migration Service.
//
// Saves a copy of a database migration assessment report to your Amazon S3
// bucket. DMS can save your assessment report as a comma-separated value (CSV)
// or a PDF file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ExportMetadataModelAssessment for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment
func (c *DatabaseMigrationService) ExportMetadataModelAssessment(input *ExportMetadataModelAssessmentInput) (*ExportMetadataModelAssessmentOutput, error) {
	req, out := c.ExportMetadataModelAssessmentRequest(input)
	return out, req.Send()
}

// ExportMetadataModelAssessmentWithContext is the same as ExportMetadataModelAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See ExportMetadataModelAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ExportMetadataModelAssessmentWithContext(ctx aws.Context, input *ExportMetadataModelAssessmentInput, opts ...request.Option) (*ExportMetadataModelAssessmentOutput, error) {
	req, out := c.ExportMetadataModelAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificate for more information on using the ImportCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportCertificateRequest method.
//	req, resp := client.ImportCertificateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	output = &ImportCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCertificate API operation for AWS Database Migration Service.
//
// Uploads the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - InvalidCertificateFault
//     The certificate was not valid.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateWithContext is the same as ImportCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ImportCertificateWithContext(ctx aws.Context, input *ImportCertificateInput, opts ...request.Option) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Database Migration Service.
//
// Lists all metadata tags attached to an DMS resource, including replication
// instance, endpoint, subnet group, and migration task. For more information,
// see Tag (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html)
// data type description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyConversionConfiguration = "ModifyConversionConfiguration"

// ModifyConversionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ModifyConversionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyConversionConfiguration for more information on using the ModifyConversionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyConversionConfigurationRequest method.
//	req, resp := client.ModifyConversionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration
func (c *DatabaseMigrationService) ModifyConversionConfigurationRequest(input *ModifyConversionConfigurationInput) (req *request.Request, output *ModifyConversionConfigurationOutput) {
	op := &request.Operation{
		Name:       opModifyConversionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyConversionConfigurationInput{}
	}

	output = &ModifyConversionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyConversionConfiguration API operation for AWS Database Migration Service.
//
// Modifies the specified schema conversion configuration using the provided
// parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyConversionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration
func (c *DatabaseMigrationService) ModifyConversionConfiguration(input *ModifyConversionConfigurationInput) (*ModifyConversionConfigurationOutput, error) {
	req, out := c.ModifyConversionConfigurationRequest(input)
	return out, req.Send()
}

// ModifyConversionConfigurationWithContext is the same as ModifyConversionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyConversionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyConversionConfigurationWithContext(ctx aws.Context, input *ModifyConversionConfigurationInput, opts ...request.Option) (*ModifyConversionConfigurationOutput, error) {
	req, out := c.ModifyConversionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDataProvider = "ModifyDataProvider"

// ModifyDataProviderRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDataProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDataProvider for more information on using the ModifyDataProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyDataProviderRequest method.
//	req, resp := client.ModifyDataProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider
func (c *DatabaseMigrationService) ModifyDataProviderRequest(input *ModifyDataProviderInput) (req *request.Request, output *ModifyDataProviderOutput) {
	op := &request.Operation{
		Name:       opModifyDataProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDataProviderInput{}
	}

	output = &ModifyDataProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDataProvider API operation for AWS Database Migration Service.
//
// Modifies the specified data provider using the provided settings.
//
// You must remove the data provider from all migration projects before you
// can modify it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyDataProvider for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider
func (c *DatabaseMigrationService) ModifyDataProvider(input *ModifyDataProviderInput) (*ModifyDataProviderOutput, error) {
	req, out := c.ModifyDataProviderRequest(input)
	return out, req.Send()
}

// ModifyDataProviderWithContext is the same as ModifyDataProvider with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDataProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyDataProviderWithContext(ctx aws.Context, input *ModifyDataProviderInput, opts ...request.Option) (*ModifyDataProviderOutput, error) {
	req, out := c.ModifyDataProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEndpoint = "ModifyEndpoint"

// ModifyEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEndpoint for more information on using the ModifyEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyEndpointRequest method.
//	req, resp := client.ModifyEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpointRequest(input *ModifyEndpointInput) (req *request.Request, output *ModifyEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEndpointInput{}
	}

	output = &ModifyEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEndpoint API operation for AWS Database Migration Service.
//
// Modifies the specified endpoint.
//
// For a MySQL source or target endpoint, don't explicitly specify the database
// using the DatabaseName request parameter on the ModifyEndpoint API call.
// Specifying DatabaseName when you modify a MySQL endpoint replicates all the
// task tables to this single database. For MySQL endpoints, you specify the
// database only when you specify the schema in the table-mapping rules of the
// DMS task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpoint(input *ModifyEndpointInput) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	return out, req.Send()
}

// ModifyEndpointWithContext is the same as ModifyEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEndpointWithContext(ctx aws.Context, input *ModifyEndpointInput, opts ...request.Option) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyEventSubscriptionRequest method.
//	req, resp := client.ModifyEventSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for AWS Database Migration Service.
//
// Modifies an existing DMS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - SNSInvalidTopicFault
//     The SNS topic is invalid.
//
//   - SNSNoAuthorizationFault
//     You are not authorized for the SNS subscription.
//
//   - KMSAccessDeniedFault
//     The ciphertext references a key that doesn't exist or that the DMS account
//     doesn't have access to.
//
//   - KMSDisabledFault
//     The specified KMS key isn't enabled.
//
//   - KMSInvalidStateFault
//     The state of the specified KMS resource isn't valid for this request.
//
//   - KMSNotFoundFault
//     The specified KMS entity or resource can't be found.
//
//   - KMSThrottlingFault
//     This request triggered KMS request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyInstanceProfile = "ModifyInstanceProfile"

// ModifyInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyInstanceProfile for more information on using the ModifyInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyInstanceProfileRequest method.
//	req, resp := client.ModifyInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile
func (c *DatabaseMigrationService) ModifyInstanceProfileRequest(input *ModifyInstanceProfileInput) (req *request.Request, output *ModifyInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceProfileInput{}
	}

	output = &ModifyInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyInstanceProfile API operation for AWS Database Migration Service.
//
// Modifies the specified instance profile using the provided parameters.
//
// All migration projects associated with the instance profile must be deleted
// or modified before you can modify the instance profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile
func (c *DatabaseMigrationService) ModifyInstanceProfile(input *ModifyInstanceProfileInput) (*ModifyInstanceProfileOutput, error) {
	req, out := c.ModifyInstanceProfileRequest(input)
	return out, req.Send()
}

// ModifyInstanceProfileWithContext is the same as ModifyInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyInstanceProfileWithContext(ctx aws.Context, input *ModifyInstanceProfileInput, opts ...request.Option) (*ModifyInstanceProfileOutput, error) {
	req, out := c.ModifyInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyMigrationProject = "ModifyMigrationProject"

// ModifyMigrationProjectRequest generates a "aws/request.Request" representing the
// client's request for the ModifyMigrationProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyMigrationProject for more information on using the ModifyMigrationProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyMigrationProjectRequest method.
//	req, resp := client.ModifyMigrationProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject
func (c *DatabaseMigrationService) ModifyMigrationProjectRequest(input *ModifyMigrationProjectInput) (req *request.Request, output *ModifyMigrationProjectOutput) {
	op := &request.Operation{
		Name:       opModifyMigrationProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyMigrationProjectInput{}
	}

	output = &ModifyMigrationProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyMigrationProject API operation for AWS Database Migration Service.
//
// Modifies the specified migration project using the provided parameters.
//
// The migration project must be closed before you can modify it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyMigrationProject for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject
func (c *DatabaseMigrationService) ModifyMigrationProject(input *ModifyMigrationProjectInput) (*ModifyMigrationProjectOutput, error) {
	req, out := c.ModifyMigrationProjectRequest(input)
	return out, req.Send()
}

// ModifyMigrationProjectWithContext is the same as ModifyMigrationProject with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyMigrationProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyMigrationProjectWithContext(ctx aws.Context, input *ModifyMigrationProjectInput, opts ...request.Option) (*ModifyMigrationProjectOutput, error) {
	req, out := c.ModifyMigrationProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationConfig = "ModifyReplicationConfig"

// ModifyReplicationConfigRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationConfig for more information on using the ModifyReplicationConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyReplicationConfigRequest method.
//	req, resp := client.ModifyReplicationConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig
func (c *DatabaseMigrationService) ModifyReplicationConfigRequest(input *ModifyReplicationConfigInput) (req *request.Request, output *ModifyReplicationConfigOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationConfigInput{}
	}

	output = &ModifyReplicationConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationConfig API operation for AWS Database Migration Service.
//
// Modifies an existing DMS Serverless replication configuration that you can
// use to start a replication. This command includes input validation and logic
// to check the state of any replication that uses this configuration. You can
// only modify a replication configuration before any replication that uses
// it has started. As soon as you have initially started a replication with
// a given configuiration, you can't modify that configuration, even if you
// stop it.
//
// Other run statuses that allow you to run this command include FAILED and
// CREATED. A provisioning state that allows you to run this command is FAILED_PROVISION.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationConfig for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ReplicationSubnetGroupDoesNotCoverEnoughAZs
//     The replication subnet group does not cover enough Availability Zones (AZs).
//     Edit the replication subnet group and add more AZs.
//
//   - InvalidSubnet
//     The subnet provided isn't valid.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig
func (c *DatabaseMigrationService) ModifyReplicationConfig(input *ModifyReplicationConfigInput) (*ModifyReplicationConfigOutput, error) {
	req, out := c.ModifyReplicationConfigRequest(input)
	return out, req.Send()
}

// ModifyReplicationConfigWithContext is the same as ModifyReplicationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationConfigWithContext(ctx aws.Context, input *ModifyReplicationConfigInput, opts ...request.Option) (*ModifyReplicationConfigOutput, error) {
	req, out := c.ModifyReplicationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationInstance = "ModifyReplicationInstance"

// ModifyReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationInstance for more information on using the ModifyReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyReplicationInstanceRequest method.
//	req, resp := client.ModifyReplicationInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstanceRequest(input *ModifyReplicationInstanceInput) (req *request.Request, output *ModifyReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationInstanceInput{}
	}

	output = &ModifyReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationInstance API operation for AWS Database Migration Service.
//
// Modifies the replication instance to apply new settings. You can change one
// or more parameters by specifying these parameters and the new values in the
// request.
//
// Some settings are applied during the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationInstance for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InsufficientResourceCapacityFault
//     There are not enough resources allocated to the database migration.
//
//   - StorageQuotaExceededFault
//     The storage quota has been exceeded.
//
//   - UpgradeDependencyFailureFault
//     An upgrade dependency is preventing the database migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstance(input *ModifyReplicationInstanceInput) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	return out, req.Send()
}

// ModifyReplicationInstanceWithContext is the same as ModifyReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationInstanceWithContext(ctx aws.Context, input *ModifyReplicationInstanceInput, opts ...request.Option) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationSubnetGroup = "ModifyReplicationSubnetGroup"

// ModifyReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationSubnetGroup for more information on using the ModifyReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyReplicationSubnetGroupRequest method.
//	req, resp := client.ModifyReplicationSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupRequest(input *ModifyReplicationSubnetGroupInput) (req *request.Request, output *ModifyReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationSubnetGroupInput{}
	}

	output = &ModifyReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Modifies the settings for the specified replication subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - SubnetAlreadyInUse
//     The specified subnet is already in use.
//
//   - ReplicationSubnetGroupDoesNotCoverEnoughAZs
//     The replication subnet group does not cover enough Availability Zones (AZs).
//     Edit the replication subnet group and add more AZs.
//
//   - InvalidSubnet
//     The subnet provided isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroup(input *ModifyReplicationSubnetGroupInput) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyReplicationSubnetGroupWithContext is the same as ModifyReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupWithContext(ctx aws.Context, input *ModifyReplicationSubnetGroupInput, opts ...request.Option) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationTask = "ModifyReplicationTask"

// ModifyReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationTask for more information on using the ModifyReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyReplicationTaskRequest method.
//	req, resp := client.ModifyReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTaskRequest(input *ModifyReplicationTaskInput) (req *request.Request, output *ModifyReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationTaskInput{}
	}

	output = &ModifyReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationTask API operation for AWS Database Migration Service.
//
// Modifies the specified replication task.
//
// You can't modify the task endpoints. The task must be stopped before you
// can modify it.
//
// For more information about DMS tasks, see Working with Migration Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTask(input *ModifyReplicationTaskInput) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	return out, req.Send()
}

// ModifyReplicationTaskWithContext is the same as ModifyReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationTaskWithContext(ctx aws.Context, input *ModifyReplicationTaskInput, opts ...request.Option) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMoveReplicationTask = "MoveReplicationTask"

// MoveReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the MoveReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MoveReplicationTask for more information on using the MoveReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the MoveReplicationTaskRequest method.
//	req, resp := client.MoveReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask
func (c *DatabaseMigrationService) MoveReplicationTaskRequest(input *MoveReplicationTaskInput) (req *request.Request, output *MoveReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opMoveReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveReplicationTaskInput{}
	}

	output = &MoveReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MoveReplicationTask API operation for AWS Database Migration Service.
//
// Moves a replication task from its current replication instance to a different
// target replication instance using the specified parameters. The target replication
// instance must be created with the same or later DMS version as the current
// replication instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation MoveReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask
func (c *DatabaseMigrationService) MoveReplicationTask(input *MoveReplicationTaskInput) (*MoveReplicationTaskOutput, error) {
	req, out := c.MoveReplicationTaskRequest(input)
	return out, req.Send()
}

// MoveReplicationTaskWithContext is the same as MoveReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See MoveReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) MoveReplicationTaskWithContext(ctx aws.Context, input *MoveReplicationTaskInput, opts ...request.Option) (*MoveReplicationTaskOutput, error) {
	req, out := c.MoveReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootReplicationInstance = "RebootReplicationInstance"

// RebootReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootReplicationInstance for more information on using the RebootReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RebootReplicationInstanceRequest method.
//	req, resp := client.RebootReplicationInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance
func (c *DatabaseMigrationService) RebootReplicationInstanceRequest(input *RebootReplicationInstanceInput) (req *request.Request, output *RebootReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootReplicationInstanceInput{}
	}

	output = &RebootReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootReplicationInstance API operation for AWS Database Migration Service.
//
// Reboots a replication instance. Rebooting results in a momentary outage,
// until the replication instance becomes available again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RebootReplicationInstance for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance
func (c *DatabaseMigrationService) RebootReplicationInstance(input *RebootReplicationInstanceInput) (*RebootReplicationInstanceOutput, error) {
	req, out := c.RebootReplicationInstanceRequest(input)
	return out, req.Send()
}

// RebootReplicationInstanceWithContext is the same as RebootReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RebootReplicationInstanceWithContext(ctx aws.Context, input *RebootReplicationInstanceInput, opts ...request.Option) (*RebootReplicationInstanceOutput, error) {
	req, out := c.RebootReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRefreshSchemas = "RefreshSchemas"

// RefreshSchemasRequest generates a "aws/request.Request" representing the
// client's request for the RefreshSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshSchemas for more information on using the RefreshSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RefreshSchemasRequest method.
//	req, resp := client.RefreshSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemasRequest(input *RefreshSchemasInput) (req *request.Request, output *RefreshSchemasOutput) {
	op := &request.Operation{
		Name:       opRefreshSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshSchemasInput{}
	}

	output = &RefreshSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshSchemas API operation for AWS Database Migration Service.
//
// Populates the schema for the specified endpoint. This is an asynchronous
// operation and can take several minutes. You can check the status of this
// operation by calling the DescribeRefreshSchemasStatus operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RefreshSchemas for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemas(input *RefreshSchemasInput) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	return out, req.Send()
}

// RefreshSchemasWithContext is the same as RefreshSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RefreshSchemasWithContext(ctx aws.Context, input *RefreshSchemasInput, opts ...request.Option) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReloadReplicationTables = "ReloadReplicationTables"

// ReloadReplicationTablesRequest generates a "aws/request.Request" representing the
// client's request for the ReloadReplicationTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReloadReplicationTables for more information on using the ReloadReplicationTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReloadReplicationTablesRequest method.
//	req, resp := client.ReloadReplicationTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables
func (c *DatabaseMigrationService) ReloadReplicationTablesRequest(input *ReloadReplicationTablesInput) (req *request.Request, output *ReloadReplicationTablesOutput) {
	op := &request.Operation{
		Name:       opReloadReplicationTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReloadReplicationTablesInput{}
	}

	output = &ReloadReplicationTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReloadReplicationTables API operation for AWS Database Migration Service.
//
// Reloads the target database table with the source data for a given DMS Serverless
// replication configuration.
//
// You can only use this operation with a task in the RUNNING state, otherwise
// the service will throw an InvalidResourceStateFault exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ReloadReplicationTables for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables
func (c *DatabaseMigrationService) ReloadReplicationTables(input *ReloadReplicationTablesInput) (*ReloadReplicationTablesOutput, error) {
	req, out := c.ReloadReplicationTablesRequest(input)
	return out, req.Send()
}

// ReloadReplicationTablesWithContext is the same as ReloadReplicationTables with the addition of
// the ability to pass a context and additional request options.
//
// See ReloadReplicationTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ReloadReplicationTablesWithContext(ctx aws.Context, input *ReloadReplicationTablesInput, opts ...request.Option) (*ReloadReplicationTablesOutput, error) {
	req, out := c.ReloadReplicationTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReloadTables = "ReloadTables"

// ReloadTablesRequest generates a "aws/request.Request" representing the
// client's request for the ReloadTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReloadTables for more information on using the ReloadTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReloadTablesRequest method.
//	req, resp := client.ReloadTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTablesRequest(input *ReloadTablesInput) (req *request.Request, output *ReloadTablesOutput) {
	op := &request.Operation{
		Name:       opReloadTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReloadTablesInput{}
	}

	output = &ReloadTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReloadTables API operation for AWS Database Migration Service.
//
// Reloads the target database table with the source data.
//
// You can only use this operation with a task in the RUNNING state, otherwise
// the service will throw an InvalidResourceStateFault exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ReloadTables for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTables(input *ReloadTablesInput) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	return out, req.Send()
}

// ReloadTablesWithContext is the same as ReloadTables with the addition of
// the ability to pass a context and additional request options.
//
// See ReloadTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ReloadTablesWithContext(ctx aws.Context, input *ReloadTablesInput, opts ...request.Option) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTagsFromResourceRequest method.
//	req, resp := client.RemoveTagsFromResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for AWS Database Migration Service.
//
// Removes metadata tags from an DMS resource, including replication instance,
// endpoint, subnet group, and migration task. For more information, see Tag
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunFleetAdvisorLsaAnalysis = "RunFleetAdvisorLsaAnalysis"

// RunFleetAdvisorLsaAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the RunFleetAdvisorLsaAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RunFleetAdvisorLsaAnalysis for more information on using the RunFleetAdvisorLsaAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RunFleetAdvisorLsaAnalysisRequest method.
//	req, resp := client.RunFleetAdvisorLsaAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis
func (c *DatabaseMigrationService) RunFleetAdvisorLsaAnalysisRequest(input *RunFleetAdvisorLsaAnalysisInput) (req *request.Request, output *RunFleetAdvisorLsaAnalysisOutput) {
	op := &request.Operation{
		Name:       opRunFleetAdvisorLsaAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunFleetAdvisorLsaAnalysisInput{}
	}

	output = &RunFleetAdvisorLsaAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunFleetAdvisorLsaAnalysis API operation for AWS Database Migration Service.
//
// Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RunFleetAdvisorLsaAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis
func (c *DatabaseMigrationService) RunFleetAdvisorLsaAnalysis(input *RunFleetAdvisorLsaAnalysisInput) (*RunFleetAdvisorLsaAnalysisOutput, error) {
	req, out := c.RunFleetAdvisorLsaAnalysisRequest(input)
	return out, req.Send()
}

// RunFleetAdvisorLsaAnalysisWithContext is the same as RunFleetAdvisorLsaAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See RunFleetAdvisorLsaAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RunFleetAdvisorLsaAnalysisWithContext(ctx aws.Context, input *RunFleetAdvisorLsaAnalysisInput, opts ...request.Option) (*RunFleetAdvisorLsaAnalysisOutput, error) {
	req, out := c.RunFleetAdvisorLsaAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExtensionPackAssociation = "StartExtensionPackAssociation"

// StartExtensionPackAssociationRequest generates a "aws/request.Request" representing the
// client's request for the StartExtensionPackAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExtensionPackAssociation for more information on using the StartExtensionPackAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartExtensionPackAssociationRequest method.
//	req, resp := client.StartExtensionPackAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation
func (c *DatabaseMigrationService) StartExtensionPackAssociationRequest(input *StartExtensionPackAssociationInput) (req *request.Request, output *StartExtensionPackAssociationOutput) {
	op := &request.Operation{
		Name:       opStartExtensionPackAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExtensionPackAssociationInput{}
	}

	output = &StartExtensionPackAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExtensionPackAssociation API operation for AWS Database Migration Service.
//
// Applies the extension pack to your target database. An extension pack is
// an add-on module that emulates functions present in a source database that
// are required when converting objects to the target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartExtensionPackAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation
func (c *DatabaseMigrationService) StartExtensionPackAssociation(input *StartExtensionPackAssociationInput) (*StartExtensionPackAssociationOutput, error) {
	req, out := c.StartExtensionPackAssociationRequest(input)
	return out, req.Send()
}

// StartExtensionPackAssociationWithContext is the same as StartExtensionPackAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See StartExtensionPackAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartExtensionPackAssociationWithContext(ctx aws.Context, input *StartExtensionPackAssociationInput, opts ...request.Option) (*StartExtensionPackAssociationOutput, error) {
	req, out := c.StartExtensionPackAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataModelAssessment = "StartMetadataModelAssessment"

// StartMetadataModelAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataModelAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataModelAssessment for more information on using the StartMetadataModelAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataModelAssessmentRequest method.
//	req, resp := client.StartMetadataModelAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment
func (c *DatabaseMigrationService) StartMetadataModelAssessmentRequest(input *StartMetadataModelAssessmentInput) (req *request.Request, output *StartMetadataModelAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartMetadataModelAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetadataModelAssessmentInput{}
	}

	output = &StartMetadataModelAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataModelAssessment API operation for AWS Database Migration Service.
//
// Creates a database migration assessment report by assessing the migration
// complexity for your source database. A database migration assessment report
// summarizes all of the schema conversion tasks. It also details the action
// items for database objects that can't be converted to the database engine
// of your target database instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartMetadataModelAssessment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment
func (c *DatabaseMigrationService) StartMetadataModelAssessment(input *StartMetadataModelAssessmentInput) (*StartMetadataModelAssessmentOutput, error) {
	req, out := c.StartMetadataModelAssessmentRequest(input)
	return out, req.Send()
}

// StartMetadataModelAssessmentWithContext is the same as StartMetadataModelAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataModelAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartMetadataModelAssessmentWithContext(ctx aws.Context, input *StartMetadataModelAssessmentInput, opts ...request.Option) (*StartMetadataModelAssessmentOutput, error) {
	req, out := c.StartMetadataModelAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataModelConversion = "StartMetadataModelConversion"

// StartMetadataModelConversionRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataModelConversion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataModelConversion for more information on using the StartMetadataModelConversion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataModelConversionRequest method.
//	req, resp := client.StartMetadataModelConversionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion
func (c *DatabaseMigrationService) StartMetadataModelConversionRequest(input *StartMetadataModelConversionInput) (req *request.Request, output *StartMetadataModelConversionOutput) {
	op := &request.Operation{
		Name:       opStartMetadataModelConversion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetadataModelConversionInput{}
	}

	output = &StartMetadataModelConversionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataModelConversion API operation for AWS Database Migration Service.
//
// Converts your source database objects to a format compatible with the target
// database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartMetadataModelConversion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion
func (c *DatabaseMigrationService) StartMetadataModelConversion(input *StartMetadataModelConversionInput) (*StartMetadataModelConversionOutput, error) {
	req, out := c.StartMetadataModelConversionRequest(input)
	return out, req.Send()
}

// StartMetadataModelConversionWithContext is the same as StartMetadataModelConversion with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataModelConversion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartMetadataModelConversionWithContext(ctx aws.Context, input *StartMetadataModelConversionInput, opts ...request.Option) (*StartMetadataModelConversionOutput, error) {
	req, out := c.StartMetadataModelConversionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataModelExportAsScript = "StartMetadataModelExportAsScript"

// StartMetadataModelExportAsScriptRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataModelExportAsScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataModelExportAsScript for more information on using the StartMetadataModelExportAsScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataModelExportAsScriptRequest method.
//	req, resp := client.StartMetadataModelExportAsScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript
func (c *DatabaseMigrationService) StartMetadataModelExportAsScriptRequest(input *StartMetadataModelExportAsScriptInput) (req *request.Request, output *StartMetadataModelExportAsScriptOutput) {
	op := &request.Operation{
		Name:       opStartMetadataModelExportAsScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetadataModelExportAsScriptInput{}
	}

	output = &StartMetadataModelExportAsScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataModelExportAsScript API operation for AWS Database Migration Service.
//
// Saves your converted code to a file as a SQL script, and stores this file
// on your Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartMetadataModelExportAsScript for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript
func (c *DatabaseMigrationService) StartMetadataModelExportAsScript(input *StartMetadataModelExportAsScriptInput) (*StartMetadataModelExportAsScriptOutput, error) {
	req, out := c.StartMetadataModelExportAsScriptRequest(input)
	return out, req.Send()
}

// StartMetadataModelExportAsScriptWithContext is the same as StartMetadataModelExportAsScript with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataModelExportAsScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartMetadataModelExportAsScriptWithContext(ctx aws.Context, input *StartMetadataModelExportAsScriptInput, opts ...request.Option) (*StartMetadataModelExportAsScriptOutput, error) {
	req, out := c.StartMetadataModelExportAsScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataModelExportToTarget = "StartMetadataModelExportToTarget"

// StartMetadataModelExportToTargetRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataModelExportToTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataModelExportToTarget for more information on using the StartMetadataModelExportToTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataModelExportToTargetRequest method.
//	req, resp := client.StartMetadataModelExportToTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget
func (c *DatabaseMigrationService) StartMetadataModelExportToTargetRequest(input *StartMetadataModelExportToTargetInput) (req *request.Request, output *StartMetadataModelExportToTargetOutput) {
	op := &request.Operation{
		Name:       opStartMetadataModelExportToTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetadataModelExportToTargetInput{}
	}

	output = &StartMetadataModelExportToTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataModelExportToTarget API operation for AWS Database Migration Service.
//
// Applies converted database objects to your target database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartMetadataModelExportToTarget for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget
func (c *DatabaseMigrationService) StartMetadataModelExportToTarget(input *StartMetadataModelExportToTargetInput) (*StartMetadataModelExportToTargetOutput, error) {
	req, out := c.StartMetadataModelExportToTargetRequest(input)
	return out, req.Send()
}

// StartMetadataModelExportToTargetWithContext is the same as StartMetadataModelExportToTarget with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataModelExportToTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartMetadataModelExportToTargetWithContext(ctx aws.Context, input *StartMetadataModelExportToTargetInput, opts ...request.Option) (*StartMetadataModelExportToTargetOutput, error) {
	req, out := c.StartMetadataModelExportToTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataModelImport = "StartMetadataModelImport"

// StartMetadataModelImportRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataModelImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataModelImport for more information on using the StartMetadataModelImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataModelImportRequest method.
//	req, resp := client.StartMetadataModelImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport
func (c *DatabaseMigrationService) StartMetadataModelImportRequest(input *StartMetadataModelImportInput) (req *request.Request, output *StartMetadataModelImportOutput) {
	op := &request.Operation{
		Name:       opStartMetadataModelImport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetadataModelImportInput{}
	}

	output = &StartMetadataModelImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataModelImport API operation for AWS Database Migration Service.
//
// Loads the metadata for all the dependent database objects of the parent object.
//
// This operation uses your project's Amazon S3 bucket as a metadata cache to
// improve performance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartMetadataModelImport for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport
func (c *DatabaseMigrationService) StartMetadataModelImport(input *StartMetadataModelImportInput) (*StartMetadataModelImportOutput, error) {
	req, out := c.StartMetadataModelImportRequest(input)
	return out, req.Send()
}

// StartMetadataModelImportWithContext is the same as StartMetadataModelImport with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataModelImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartMetadataModelImportWithContext(ctx aws.Context, input *StartMetadataModelImportInput, opts ...request.Option) (*StartMetadataModelImportOutput, error) {
	req, out := c.StartMetadataModelImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRecommendations = "StartRecommendations"

// StartRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the StartRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRecommendations for more information on using the StartRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRecommendationsRequest method.
//	req, resp := client.StartRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations
func (c *DatabaseMigrationService) StartRecommendationsRequest(input *StartRecommendationsInput) (req *request.Request, output *StartRecommendationsOutput) {
	op := &request.Operation{
		Name:       opStartRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRecommendationsInput{}
	}

	output = &StartRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartRecommendations API operation for AWS Database Migration Service.
//
// Starts the analysis of your source database to provide recommendations of
// target engines.
//
// You can create recommendations for multiple source databases using BatchStartRecommendations
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations
func (c *DatabaseMigrationService) StartRecommendations(input *StartRecommendationsInput) (*StartRecommendationsOutput, error) {
	req, out := c.StartRecommendationsRequest(input)
	return out, req.Send()
}

// StartRecommendationsWithContext is the same as StartRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See StartRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartRecommendationsWithContext(ctx aws.Context, input *StartRecommendationsInput, opts ...request.Option) (*StartRecommendationsOutput, error) {
	req, out := c.StartRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplication = "StartReplication"

// StartReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplication for more information on using the StartReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplicationRequest method.
//	req, resp := client.StartReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication
func (c *DatabaseMigrationService) StartReplicationRequest(input *StartReplicationInput) (req *request.Request, output *StartReplicationOutput) {
	op := &request.Operation{
		Name:       opStartReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationInput{}
	}

	output = &StartReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplication API operation for AWS Database Migration Service.
//
// For a given DMS Serverless replication configuration, DMS connects to the
// source endpoint and collects the metadata to analyze the replication workload.
// Using this metadata, DMS then computes and provisions the required capacity
// and starts replicating to the target endpoint using the server resources
// that DMS has provisioned for the DMS Serverless replication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication
func (c *DatabaseMigrationService) StartReplication(input *StartReplicationInput) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	return out, req.Send()
}

// StartReplicationWithContext is the same as StartReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationWithContext(ctx aws.Context, input *StartReplicationInput, opts ...request.Option) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTask = "StartReplicationTask"

// StartReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTask for more information on using the StartReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplicationTaskRequest method.
//	req, resp := client.StartReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTaskRequest(input *StartReplicationTaskInput) (req *request.Request, output *StartReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskInput{}
	}

	output = &StartReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTask API operation for AWS Database Migration Service.
//
// Starts the replication task.
//
// For more information about DMS tasks, see Working with Migration Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTask(input *StartReplicationTaskInput) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	return out, req.Send()
}

// StartReplicationTaskWithContext is the same as StartReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskWithContext(ctx aws.Context, input *StartReplicationTaskInput, opts ...request.Option) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTaskAssessment = "StartReplicationTaskAssessment"

// StartReplicationTaskAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTaskAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTaskAssessment for more information on using the StartReplicationTaskAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplicationTaskAssessmentRequest method.
//	req, resp := client.StartReplicationTaskAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRequest(input *StartReplicationTaskAssessmentInput) (req *request.Request, output *StartReplicationTaskAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTaskAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskAssessmentInput{}
	}

	output = &StartReplicationTaskAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTaskAssessment API operation for AWS Database Migration Service.
//
// Starts the replication task assessment for unsupported data types in the
// source database.
//
// You can only use this operation for a task if the following conditions are
// true:
//
//   - The task must be in the stopped state.
//
//   - The task must have successful connections to the source and target.
//
// If either of these conditions are not met, an InvalidResourceStateFault error
// will result.
//
// For information about DMS task assessments, see Creating a task assessment
// report (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTaskAssessment for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessment(input *StartReplicationTaskAssessmentInput) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	return out, req.Send()
}

// StartReplicationTaskAssessmentWithContext is the same as StartReplicationTaskAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTaskAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentWithContext(ctx aws.Context, input *StartReplicationTaskAssessmentInput, opts ...request.Option) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTaskAssessmentRun = "StartReplicationTaskAssessmentRun"

// StartReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTaskAssessmentRun for more information on using the StartReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplicationTaskAssessmentRunRequest method.
//	req, resp := client.StartReplicationTaskAssessmentRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRunRequest(input *StartReplicationTaskAssessmentRunInput) (req *request.Request, output *StartReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskAssessmentRunInput{}
	}

	output = &StartReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Starts a new premigration assessment run for one or more individual assessments
// of a migration task.
//
// The assessments that you can specify depend on the source and target database
// engine and the migration type defined for the given task. To run this operation,
// your migration task must already be created. After you run this operation,
// you can review the status of each individual assessment. You can also run
// the migration task manually after the assessment run and its individual assessments
// complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - KMSAccessDeniedFault
//     The ciphertext references a key that doesn't exist or that the DMS account
//     doesn't have access to.
//
//   - KMSDisabledFault
//     The specified KMS key isn't enabled.
//
//   - KMSFault
//     An Key Management Service (KMS) error is preventing access to KMS.
//
//   - KMSInvalidStateFault
//     The state of the specified KMS resource isn't valid for this request.
//
//   - KMSNotFoundFault
//     The specified KMS entity or resource can't be found.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - S3AccessDeniedFault
//     Insufficient privileges are preventing access to an Amazon S3 object.
//
//   - S3ResourceNotFoundFault
//     A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   - ResourceAlreadyExistsFault
//     The resource you are attempting to create already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRun(input *StartReplicationTaskAssessmentRunInput) (*StartReplicationTaskAssessmentRunOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// StartReplicationTaskAssessmentRunWithContext is the same as StartReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *StartReplicationTaskAssessmentRunInput, opts ...request.Option) (*StartReplicationTaskAssessmentRunOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplication = "StopReplication"

// StopReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplication for more information on using the StopReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopReplicationRequest method.
//	req, resp := client.StopReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication
func (c *DatabaseMigrationService) StopReplicationRequest(input *StopReplicationInput) (req *request.Request, output *StopReplicationOutput) {
	op := &request.Operation{
		Name:       opStopReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationInput{}
	}

	output = &StopReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplication API operation for AWS Database Migration Service.
//
// For a given DMS Serverless replication configuration, DMS stops any and all
// ongoing DMS Serverless replications. This command doesn't deprovision the
// stopped replications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StopReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication
func (c *DatabaseMigrationService) StopReplication(input *StopReplicationInput) (*StopReplicationOutput, error) {
	req, out := c.StopReplicationRequest(input)
	return out, req.Send()
}

// StopReplicationWithContext is the same as StopReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StopReplicationWithContext(ctx aws.Context, input *StopReplicationInput, opts ...request.Option) (*StopReplicationOutput, error) {
	req, out := c.StopReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplicationTask = "StopReplicationTask"

// StopReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplicationTask for more information on using the StopReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopReplicationTaskRequest method.
//	req, resp := client.StopReplicationTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTaskRequest(input *StopReplicationTaskInput) (req *request.Request, output *StopReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStopReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationTaskInput{}
	}

	output = &StopReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplicationTask API operation for AWS Database Migration Service.
//
// Stops the replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StopReplicationTask for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTask(input *StopReplicationTaskInput) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	return out, req.Send()
}

// StopReplicationTaskWithContext is the same as StopReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StopReplicationTaskWithContext(ctx aws.Context, input *StopReplicationTaskInput, opts ...request.Option) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestConnection = "TestConnection"

// TestConnectionRequest generates a "aws/request.Request" representing the
// client's request for the TestConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestConnection for more information on using the TestConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestConnectionRequest method.
//	req, resp := client.TestConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnectionRequest(input *TestConnectionInput) (req *request.Request, output *TestConnectionOutput) {
	op := &request.Operation{
		Name:       opTestConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestConnectionInput{}
	}

	output = &TestConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestConnection API operation for AWS Database Migration Service.
//
// Tests the connection between the replication instance and the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation TestConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundFault
//     The resource could not be found.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
//   - KMSKeyNotAccessibleFault
//     DMS cannot access the KMS key.
//
//   - ResourceQuotaExceededFault
//     The quota for this resource quota has been exceeded.
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnection(input *TestConnectionInput) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	return out, req.Send()
}

// TestConnectionWithContext is the same as TestConnection with the addition of
// the ability to pass a context and additional request options.
//
// See TestConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) TestConnectionWithContext(ctx aws.Context, input *TestConnectionInput, opts ...request.Option) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionsToEventBridge = "UpdateSubscriptionsToEventBridge"

// UpdateSubscriptionsToEventBridgeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionsToEventBridge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionsToEventBridge for more information on using the UpdateSubscriptionsToEventBridge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriptionsToEventBridgeRequest method.
//	req, resp := client.UpdateSubscriptionsToEventBridgeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/UpdateSubscriptionsToEventBridge
func (c *DatabaseMigrationService) UpdateSubscriptionsToEventBridgeRequest(input *UpdateSubscriptionsToEventBridgeInput) (req *request.Request, output *UpdateSubscriptionsToEventBridgeOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionsToEventBridge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSubscriptionsToEventBridgeInput{}
	}

	output = &UpdateSubscriptionsToEventBridgeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionsToEventBridge API operation for AWS Database Migration Service.
//
// Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts
// them to corresponding Amazon EventBridge rules. By default, this operation
// migrates subscriptions only when all your replication instance versions are
// 3.4.6 or higher. If any replication instances are from versions earlier than
// 3.4.6, the operation raises an error and tells you to upgrade these instances
// to version 3.4.6 or higher. To enable migration regardless of version, set
// the Force option to true. However, if you don't upgrade instances earlier
// than version 3.4.6, some types of events might not be available when you
// use Amazon EventBridge.
//
// To call this operation, make sure that you have certain permissions added
// to your user account. For more information, see Migrating event subscriptions
// to Amazon EventBridge (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge)
// in the Amazon Web Services Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation UpdateSubscriptionsToEventBridge for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedFault
//     DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   - InvalidResourceStateFault
//     The resource is in a state that prevents it from being used for database
//     migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/UpdateSubscriptionsToEventBridge
func (c *DatabaseMigrationService) UpdateSubscriptionsToEventBridge(input *UpdateSubscriptionsToEventBridgeInput) (*UpdateSubscriptionsToEventBridgeOutput, error) {
	req, out := c.UpdateSubscriptionsToEventBridgeRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionsToEventBridgeWithContext is the same as UpdateSubscriptionsToEventBridge with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionsToEventBridge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) UpdateSubscriptionsToEventBridgeWithContext(ctx aws.Context, input *UpdateSubscriptionsToEventBridgeInput, opts ...request.Option) (*UpdateSubscriptionsToEventBridgeOutput, error) {
	req, out := c.UpdateSubscriptionsToEventBridgeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DMS was denied access to the endpoint. Check that the role is correctly configured.
type AccessDeniedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedFault) GoString() string {
	return s.String()
}

func newErrorAccessDeniedFault(v protocol.ResponseMetadata) error {
	return &AccessDeniedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedFault) Code() string {
	return "AccessDeniedFault"
}

// Message returns the exception's message.
func (s *AccessDeniedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedFault) OrigErr() error {
	return nil
}

func (s *AccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a quota for an Amazon Web Services account, for example the number
// of replication instances allowed.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the DMS quota for this Amazon Web Services account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountQuota) GoString() string {
	return s.String()
}

// SetAccountQuotaName sets the AccountQuotaName field's value.
func (s *AccountQuota) SetAccountQuotaName(v string) *AccountQuota {
	s.AccountQuotaName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *AccountQuota) SetMax(v int64) *AccountQuota {
	s.Max = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountQuota) SetUsed(v int64) *AccountQuota {
	s.Used = &v
	return s
}

// Associates a set of tags with an DMS resource.
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the DMS resource to which tags should be added. The value for
	// this parameter is an Amazon Resource Name (ARN).
	//
	// For DMS, you can tag a replication instance, an endpoint, or a replication
	// task.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// One or more tags to be assigned to the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsToResourceInput) SetResourceArn(v string) *AddTagsToResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// Valid values: os-upgrade, system-update, db-upgrade
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// You can't undo an opt-in request of type immediate.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
	// action applies to.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ApplyPendingMaintenanceActionInput) SetReplicationInstanceArn(v string) *ApplyPendingMaintenanceActionInput {
	s.ReplicationInstanceArn = &v
	return s
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// The DMS resource that the pending maintenance action will be applied to.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

// The name of an Availability Zone for use during database migration. AvailabilityZone
// is an optional parameter to the CreateReplicationInstance (https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationInstance.html)
// operation, and it’s value relates to the Amazon Web Services Region of
// an endpoint. For example, the availability zone of an endpoint in the us-east-1
// region might be us-east-1a, us-east-1b, us-east-1c, or us-east-1d.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// Provides information about the errors that occurred during the analysis of
// the source database.
type BatchStartRecommendationsErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code of an error that occurred during the analysis of the source database.
	Code *string `type:"string"`

	// The identifier of the source database.
	DatabaseId *string `type:"string"`

	// The information about the error.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsErrorEntry) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchStartRecommendationsErrorEntry) SetCode(v string) *BatchStartRecommendationsErrorEntry {
	s.Code = &v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *BatchStartRecommendationsErrorEntry) SetDatabaseId(v string) *BatchStartRecommendationsErrorEntry {
	s.DatabaseId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchStartRecommendationsErrorEntry) SetMessage(v string) *BatchStartRecommendationsErrorEntry {
	s.Message = &v
	return s
}

type BatchStartRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Provides information about source databases to analyze. After this analysis,
	// Fleet Advisor recommends target engines for each source database.
	Data []*StartRecommendationsRequestEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStartRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStartRecommendationsInput"}
	if s.Data != nil {
		for i, v := range s.Data {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Data", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *BatchStartRecommendationsInput) SetData(v []*StartRecommendationsRequestEntry) *BatchStartRecommendationsInput {
	s.Data = v
	return s
}

type BatchStartRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// A list with error details about the analysis of each source database.
	ErrorEntries []*BatchStartRecommendationsErrorEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartRecommendationsOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchStartRecommendationsOutput) SetErrorEntries(v []*BatchStartRecommendationsErrorEntry) *BatchStartRecommendationsOutput {
	s.ErrorEntries = v
	return s
}

type CancelReplicationTaskAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the premigration assessment run to be canceled.
	//
	// ReplicationTaskAssessmentRunArn is a required field
	ReplicationTaskAssessmentRunArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplicationTaskAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplicationTaskAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelReplicationTaskAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelReplicationTaskAssessmentRunInput"}
	if s.ReplicationTaskAssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskAssessmentRunArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *CancelReplicationTaskAssessmentRunInput) SetReplicationTaskAssessmentRunArn(v string) *CancelReplicationTaskAssessmentRunInput {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

type CancelReplicationTaskAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The ReplicationTaskAssessmentRun object for the canceled assessment run.
	ReplicationTaskAssessmentRun *ReplicationTaskAssessmentRun `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplicationTaskAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplicationTaskAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskAssessmentRun sets the ReplicationTaskAssessmentRun field's value.
func (s *CancelReplicationTaskAssessmentRunOutput) SetReplicationTaskAssessmentRun(v *ReplicationTaskAssessmentRun) *CancelReplicationTaskAssessmentRunOutput {
	s.ReplicationTaskAssessmentRun = v
	return s
}

// The SSL certificate that can be used to encrypt connections between the endpoints
// and the replication instance.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The date that the certificate was created.
	CertificateCreationDate *time.Time `type:"timestamp"`

	// A customer-assigned name for the certificate. Identifiers must begin with
	// a letter and must contain only ASCII letters, digits, and hyphens. They can't
	// end with a hyphen or contain two consecutive hyphens.
	CertificateIdentifier *string `type:"string"`

	// The owner of the certificate.
	CertificateOwner *string `type:"string"`

	// The contents of a .pem file, which contains an X.509 certificate.
	CertificatePem *string `type:"string"`

	// The location of an imported Oracle Wallet certificate for use with SSL. Example:
	// filebase64("${path.root}/rds-ca-2019-root.sso")
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The key length of the cryptographic algorithm being used.
	KeyLength *int64 `type:"integer"`

	// The signing algorithm for the certificate.
	SigningAlgorithm *string `type:"string"`

	// The beginning date that the certificate is valid.
	ValidFromDate *time.Time `type:"timestamp"`

	// The final date that the certificate is valid.
	ValidToDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateCreationDate sets the CertificateCreationDate field's value.
func (s *Certificate) SetCertificateCreationDate(v time.Time) *Certificate {
	s.CertificateCreationDate = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateOwner sets the CertificateOwner field's value.
func (s *Certificate) SetCertificateOwner(v string) *Certificate {
	s.CertificateOwner = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *Certificate) SetCertificatePem(v string) *Certificate {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *Certificate) SetCertificateWallet(v []byte) *Certificate {
	s.CertificateWallet = v
	return s
}

// SetKeyLength sets the KeyLength field's value.
func (s *Certificate) SetKeyLength(v int64) *Certificate {
	s.KeyLength = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *Certificate) SetSigningAlgorithm(v string) *Certificate {
	s.SigningAlgorithm = &v
	return s
}

// SetValidFromDate sets the ValidFromDate field's value.
func (s *Certificate) SetValidFromDate(v time.Time) *Certificate {
	s.ValidFromDate = &v
	return s
}

// SetValidToDate sets the ValidToDate field's value.
func (s *Certificate) SetValidToDate(v time.Time) *Certificate {
	s.ValidToDate = &v
	return s
}

// Describes the last Fleet Advisor collector health check.
type CollectorHealthCheck struct {
	_ struct{} `type:"structure"`

	// The status of the Fleet Advisor collector.
	CollectorStatus *string `type:"string" enum:"CollectorStatus"`

	// Whether the local collector can access its Amazon S3 bucket.
	LocalCollectorS3Access *bool `type:"boolean"`

	// Whether the role that you provided when creating the Fleet Advisor collector
	// has sufficient permissions to access the Fleet Advisor web collector.
	WebCollectorGrantedRoleBasedAccess *bool `type:"boolean"`

	// Whether the web collector can access its Amazon S3 bucket.
	WebCollectorS3Access *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorHealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorHealthCheck) GoString() string {
	return s.String()
}

// SetCollectorStatus sets the CollectorStatus field's value.
func (s *CollectorHealthCheck) SetCollectorStatus(v string) *CollectorHealthCheck {
	s.CollectorStatus = &v
	return s
}

// SetLocalCollectorS3Access sets the LocalCollectorS3Access field's value.
func (s *CollectorHealthCheck) SetLocalCollectorS3Access(v bool) *CollectorHealthCheck {
	s.LocalCollectorS3Access = &v
	return s
}

// SetWebCollectorGrantedRoleBasedAccess sets the WebCollectorGrantedRoleBasedAccess field's value.
func (s *CollectorHealthCheck) SetWebCollectorGrantedRoleBasedAccess(v bool) *CollectorHealthCheck {
	s.WebCollectorGrantedRoleBasedAccess = &v
	return s
}

// SetWebCollectorS3Access sets the WebCollectorS3Access field's value.
func (s *CollectorHealthCheck) SetWebCollectorS3Access(v bool) *CollectorHealthCheck {
	s.WebCollectorS3Access = &v
	return s
}

// The specified collector doesn't exist.
type CollectorNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorNotFoundFault) GoString() string {
	return s.String()
}

func newErrorCollectorNotFoundFault(v protocol.ResponseMetadata) error {
	return &CollectorNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CollectorNotFoundFault) Code() string {
	return "CollectorNotFoundFault"
}

// Message returns the exception's message.
func (s *CollectorNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CollectorNotFoundFault) OrigErr() error {
	return nil
}

func (s *CollectorNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CollectorNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CollectorNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a Fleet Advisor collector.
type CollectorResponse struct {
	_ struct{} `type:"structure"`

	// Describes the last Fleet Advisor collector health check.
	CollectorHealthCheck *CollectorHealthCheck `type:"structure"`

	// The name of the Fleet Advisor collector .
	CollectorName *string `type:"string"`

	// The reference ID of the Fleet Advisor collector.
	CollectorReferencedId *string `type:"string"`

	// The version of your Fleet Advisor collector, in semantic versioning format,
	// for example 1.0.2
	CollectorVersion *string `type:"string"`

	// The timestamp when you created the collector, in the following format: 2022-01-24T19:04:02.596113Z
	CreatedDate *string `type:"string"`

	// A summary description of the Fleet Advisor collector.
	Description *string `type:"string"`

	// Describes a Fleet Advisor collector inventory.
	InventoryData *InventoryData `type:"structure"`

	// The timestamp of the last time the collector received data, in the following
	// format: 2022-01-24T19:04:02.596113Z
	LastDataReceived *string `type:"string"`

	// The timestamp when DMS last modified the collector, in the following format:
	// 2022-01-24T19:04:02.596113Z
	ModifiedDate *string `type:"string"`

	// The timestamp when DMS registered the collector, in the following format:
	// 2022-01-24T19:04:02.596113Z
	RegisteredDate *string `type:"string"`

	// The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory
	// metadata.
	S3BucketName *string `type:"string"`

	// The IAM role that grants permissions to access the specified Amazon S3 bucket.
	ServiceAccessRoleArn *string `type:"string"`

	// Whether the collector version is up to date.
	VersionStatus *string `type:"string" enum:"VersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorResponse) GoString() string {
	return s.String()
}

// SetCollectorHealthCheck sets the CollectorHealthCheck field's value.
func (s *CollectorResponse) SetCollectorHealthCheck(v *CollectorHealthCheck) *CollectorResponse {
	s.CollectorHealthCheck = v
	return s
}

// SetCollectorName sets the CollectorName field's value.
func (s *CollectorResponse) SetCollectorName(v string) *CollectorResponse {
	s.CollectorName = &v
	return s
}

// SetCollectorReferencedId sets the CollectorReferencedId field's value.
func (s *CollectorResponse) SetCollectorReferencedId(v string) *CollectorResponse {
	s.CollectorReferencedId = &v
	return s
}

// SetCollectorVersion sets the CollectorVersion field's value.
func (s *CollectorResponse) SetCollectorVersion(v string) *CollectorResponse {
	s.CollectorVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CollectorResponse) SetCreatedDate(v string) *CollectorResponse {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollectorResponse) SetDescription(v string) *CollectorResponse {
	s.Description = &v
	return s
}

// SetInventoryData sets the InventoryData field's value.
func (s *CollectorResponse) SetInventoryData(v *InventoryData) *CollectorResponse {
	s.InventoryData = v
	return s
}

// SetLastDataReceived sets the LastDataReceived field's value.
func (s *CollectorResponse) SetLastDataReceived(v string) *CollectorResponse {
	s.LastDataReceived = &v
	return s
}

// SetModifiedDate sets the ModifiedDate field's value.
func (s *CollectorResponse) SetModifiedDate(v string) *CollectorResponse {
	s.ModifiedDate = &v
	return s
}

// SetRegisteredDate sets the RegisteredDate field's value.
func (s *CollectorResponse) SetRegisteredDate(v string) *CollectorResponse {
	s.RegisteredDate = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CollectorResponse) SetS3BucketName(v string) *CollectorResponse {
	s.S3BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *CollectorResponse) SetServiceAccessRoleArn(v string) *CollectorResponse {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetVersionStatus sets the VersionStatus field's value.
func (s *CollectorResponse) SetVersionStatus(v string) *CollectorResponse {
	s.VersionStatus = &v
	return s
}

// Briefly describes a Fleet Advisor collector.
type CollectorShortInfoResponse struct {
	_ struct{} `type:"structure"`

	// The name of the Fleet Advisor collector.
	CollectorName *string `type:"string"`

	// The reference ID of the Fleet Advisor collector.
	CollectorReferencedId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorShortInfoResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorShortInfoResponse) GoString() string {
	return s.String()
}

// SetCollectorName sets the CollectorName field's value.
func (s *CollectorShortInfoResponse) SetCollectorName(v string) *CollectorShortInfoResponse {
	s.CollectorName = &v
	return s
}

// SetCollectorReferencedId sets the CollectorReferencedId field's value.
func (s *CollectorShortInfoResponse) SetCollectorReferencedId(v string) *CollectorShortInfoResponse {
	s.CollectorReferencedId = &v
	return s
}

// Configuration parameters for provisioning an DMS Serverless replication.
type ComputeConfig struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the DMS Serverless replication using this configuration
	// will run. The default value is a random, system-chosen Availability Zone
	// in the configuration's Amazon Web Services Region, for example, "us-west-2".
	// You can't set this parameter if the MultiAZ parameter is set to true.
	AvailabilityZone *string `type:"string"`

	// A list of custom DNS name servers supported for the DMS Serverless replication
	// to access your source or target database. This list overrides the default
	// name servers supported by the DMS Serverless replication. You can specify
	// a comma-separated list of internet addresses for up to four DNS name servers.
	// For example: "1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"
	DnsNameServers *string `type:"string"`

	// An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used
	// to encrypt the data during DMS Serverless replication.
	//
	// If you don't specify a value for the KmsKeyId parameter, DMS uses your default
	// encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyId *string `type:"string"`

	// Specifies the maximum value of the DMS capacity units (DCUs) for which a
	// given DMS Serverless replication can be provisioned. A single DCU is 2GB
	// of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values
	// includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value
	// that you can specify for DMS Serverless is 384. The MaxCapacityUnits parameter
	// is the only DCU parameter you are required to specify.
	MaxCapacityUnits *int64 `type:"integer"`

	// Specifies the minimum value of the DMS capacity units (DCUs) for which a
	// given DMS Serverless replication can be provisioned. A single DCU is 2GB
	// of RAM, with 2 DCUs as the minimum value allowed. The list of valid DCU values
	// includes 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU
	// value that you can specify for DMS Serverless is 2. You don't have to specify
	// a value for the MinCapacityUnits parameter. If you don't set this value,
	// DMS scans the current activity of available source tables to identify an
	// optimum setting for this parameter. If there is no current source activity
	// or DMS can't otherwise identify a more appropriate value, it sets this parameter
	// to the minimum DCU value allowed, 2.
	MinCapacityUnits *int64 `type:"integer"`

	// Specifies whether the DMS Serverless replication is a Multi-AZ deployment.
	// You can't set the AvailabilityZone parameter if the MultiAZ parameter is
	// set to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range during which system maintenance can occur for the DMS
	// Serverless replication, in Universal Coordinated Time (UTC). The format is
	// ddd:hh24:mi-ddd:hh24:mi.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time per Amazon Web Services Region. This maintenance occurs on a random
	// day of the week. Valid values for days of the week include Mon, Tue, Wed,
	// Thu, Fri, Sat, and Sun.
	//
	// Constraints include a minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies a subnet group identifier to associate with the DMS Serverless
	// replication.
	ReplicationSubnetGroupId *string `type:"string"`

	// Specifies the virtual private cloud (VPC) security group to use with the
	// DMS Serverless replication. The VPC security group must work with the VPC
	// containing the replication.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeConfig) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ComputeConfig) SetAvailabilityZone(v string) *ComputeConfig {
	s.AvailabilityZone = &v
	return s
}

// SetDnsNameServers sets the DnsNameServers field's value.
func (s *ComputeConfig) SetDnsNameServers(v string) *ComputeConfig {
	s.DnsNameServers = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ComputeConfig) SetKmsKeyId(v string) *ComputeConfig {
	s.KmsKeyId = &v
	return s
}

// SetMaxCapacityUnits sets the MaxCapacityUnits field's value.
func (s *ComputeConfig) SetMaxCapacityUnits(v int64) *ComputeConfig {
	s.MaxCapacityUnits = &v
	return s
}

// SetMinCapacityUnits sets the MinCapacityUnits field's value.
func (s *ComputeConfig) SetMinCapacityUnits(v int64) *ComputeConfig {
	s.MinCapacityUnits = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ComputeConfig) SetMultiAZ(v bool) *ComputeConfig {
	s.MultiAZ = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ComputeConfig) SetPreferredMaintenanceWindow(v string) *ComputeConfig {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationSubnetGroupId sets the ReplicationSubnetGroupId field's value.
func (s *ComputeConfig) SetReplicationSubnetGroupId(v string) *ComputeConfig {
	s.ReplicationSubnetGroupId = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ComputeConfig) SetVpcSecurityGroupIds(v []*string) *ComputeConfig {
	s.VpcSecurityGroupIds = v
	return s
}

// Status of the connection between an endpoint and a replication instance,
// including Amazon Resource Names (ARNs) and the last error message issued.
type Connection struct {
	_ struct{} `type:"structure"`

	// The ARN string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The identifier of the endpoint. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The error message when the connection last failed.
	LastFailureMessage *string `type:"string"`

	// The ARN of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// The connection status. This parameter can return one of the following values:
	//
	//    * "successful"
	//
	//    * "testing"
	//
	//    * "failed"
	//
	//    * "deleting"
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Connection) SetEndpointArn(v string) *Connection {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Connection) SetEndpointIdentifier(v string) *Connection {
	s.EndpointIdentifier = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *Connection) SetLastFailureMessage(v string) *Connection {
	s.LastFailureMessage = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *Connection) SetReplicationInstanceArn(v string) *Connection {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *Connection) SetReplicationInstanceIdentifier(v string) *Connection {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connection) SetStatus(v string) *Connection {
	s.Status = &v
	return s
}

type CreateDataProviderInput struct {
	_ struct{} `type:"structure"`

	// A user-friendly name for the data provider.
	DataProviderName *string `type:"string"`

	// A user-friendly description of the data provider.
	Description *string `type:"string"`

	// The type of database engine for the data provider. Valid values include "aurora",
	// "aurora_postgresql", "mysql", "oracle", "postgres", and "sqlserver". A value
	// of "aurora" represents Amazon Aurora MySQL-Compatible Edition.
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The settings in JSON format for a data provider.
	//
	// Settings is a required field
	Settings *DataProviderSettings `type:"structure" required:"true"`

	// One or more tags to be assigned to the data provider.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataProviderInput"}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.Settings == nil {
		invalidParams.Add(request.NewErrParamRequired("Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataProviderName sets the DataProviderName field's value.
func (s *CreateDataProviderInput) SetDataProviderName(v string) *CreateDataProviderInput {
	s.DataProviderName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataProviderInput) SetDescription(v string) *CreateDataProviderInput {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDataProviderInput) SetEngine(v string) *CreateDataProviderInput {
	s.Engine = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateDataProviderInput) SetSettings(v *DataProviderSettings) *CreateDataProviderInput {
	s.Settings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataProviderInput) SetTags(v []*Tag) *CreateDataProviderInput {
	s.Tags = v
	return s
}

type CreateDataProviderOutput struct {
	_ struct{} `type:"structure"`

	// The data provider that was created.
	DataProvider *DataProvider `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataProviderOutput) GoString() string {
	return s.String()
}

// SetDataProvider sets the DataProvider field's value.
func (s *CreateDataProviderOutput) SetDataProvider(v *DataProvider) *CreateDataProviderOutput {
	s.DataProvider = v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database. For a MySQL source or target endpoint,
	// do not specify DatabaseName. To migrate to a specific database, use this
	// setting and targetDbType.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Possible settings include the following:
	//
	//    * ServiceAccessRoleArn - The Amazon Resource Name (ARN) used by the service
	//    access IAM role. The role must allow the iam:PassRole action.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string,BucketName=string
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string", }
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Provides information that defines a DocumentDB endpoint.
	DocDbSettings *DocDbSettings `type:"structure"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For information
	// about other available settings, see Using Object Mapping to Migrate Data
	// to DynamoDB (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping)
	// in the Database Migration Service User Guide.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// Settings in JSON format for the target OpenSearch endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// OpenSearch as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration)
	// in the Database Migration Service User Guide.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen, or contain two consecutive hyphens.
	//
	// EndpointIdentifier is a required field
	EndpointIdentifier *string `type:"string" required:"true"`

	// The type of endpoint. Valid values are source and target.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values, depending on the EndpointType
	// value, include "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "opensearch", "redshift", "s3", "db2", "db2-zos", "azuredb", "sybase", "dynamodb",
	// "mongodb", "kinesis", "kafka", "elasticsearch", "docdb", "sqlserver", "neptune",
	// and "babelfish".
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional attributes associated with the connection. Each attribute is specified
	// as a name-value pair associated by an equal sign (=). Multiple attributes
	// are separated by a semicolon (;) with no additional white space. For information
	// on the attributes available for connecting your source or target endpoint,
	// see Working with DMS Endpoints (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html)
	// in the Database Migration Service User Guide.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source GCP MySQL endpoint.
	GcpMySQLSettings *GcpMySQLSettings `type:"structure"`

	// Settings in JSON format for the source IBM Db2 LUW endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Db2 LUW as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// Settings in JSON format for the target Apache Kafka endpoint. For more information
	// about the available settings, see Using object mapping to migrate data to
	// a Kafka topic (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping)
	// in the Database Migration Service User Guide.
	KafkaSettings *KafkaSettings `type:"structure"`

	// Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
	// For more information about the available settings, see Using object mapping
	// to migrate data to a Kinesis data stream (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping)
	// in the Database Migration Service User Guide.
	KinesisSettings *KinesisSettings `type:"structure"`

	// An KMS key identifier that is used to encrypt the connection parameters for
	// the endpoint.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyId *string `type:"string"`

	// Settings in JSON format for the source and target Microsoft SQL Server endpoint.
	// For information about other available settings, see Extra connection attributes
	// when using SQL Server as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib)
	// and Extra connection attributes when using SQL Server as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see Endpoint configuration settings when using
	// MongoDB as a source for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration)
	// in the Database Migration Service User Guide.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// Settings in JSON format for the source and target MySQL endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// MySQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib)
	// and Extra connection attributes when using a MySQL-compatible database as
	// a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MySQLSettings *MySQLSettings `type:"structure"`

	// Settings in JSON format for the target Amazon Neptune endpoint. For more
	// information about the available settings, see Specifying graph-mapping rules
	// using Gremlin and R2RML for Amazon Neptune as a target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings)
	// in the Database Migration Service User Guide.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// Settings in JSON format for the source and target Oracle endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Oracle as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib)
	// and Extra connection attributes when using Oracle as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	OracleSettings *OracleSettings `type:"structure"`

	// The password to be used to log in to the endpoint database.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEndpointInput's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the source and target PostgreSQL endpoint. For
	// information about other available settings, see Extra connection attributes
	// when using PostgreSQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib)
	// and Extra connection attributes when using PostgreSQL as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	PostgreSQLSettings *PostgreSQLSettings `type:"structure"`

	// Settings in JSON format for the target Redis endpoint.
	RedisSettings *RedisSettings `type:"structure"`

	// Provides information that defines an Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// Settings in JSON format for the target Amazon S3 endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Amazon S3 as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring)
	// in the Database Migration Service User Guide.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) for the service access role that you want
	// to use to create the endpoint. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default
	// is none
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// Settings in JSON format for the source and target SAP ASE endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// SAP ASE as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib)
	// and Extra connection attributes when using SAP ASE as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	SybaseSettings *SybaseSettings `type:"structure"`

	// One or more tags to be assigned to the endpoint.
	Tags []*Tag `type:"list"`

	// Settings in JSON format for the target Amazon Timestream endpoint.
	TimestreamSettings *TimestreamSettings `type:"structure"`

	// The user name to be used to log in to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIdentifier"))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchSettings != nil {
		if err := s.ElasticsearchSettings.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.NeptuneSettings != nil {
		if err := s.NeptuneSettings.Validate(); err != nil {
			invalidParams.AddNested("NeptuneSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RedisSettings != nil {
		if err := s.RedisSettings.Validate(); err != nil {
			invalidParams.AddNested("RedisSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestreamSettings != nil {
		if err := s.TimestreamSettings.Validate(); err != nil {
			invalidParams.AddNested("TimestreamSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateEndpointInput) SetCertificateArn(v string) *CreateEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateEndpointInput) SetDatabaseName(v string) *CreateEndpointInput {
	s.DatabaseName = &v
	return s
}

// SetDmsTransferSettings sets the DmsTransferSettings field's value.
func (s *CreateEndpointInput) SetDmsTransferSettings(v *DmsTransferSettings) *CreateEndpointInput {
	s.DmsTransferSettings = v
	return s
}

// SetDocDbSettings sets the DocDbSettings field's value.
func (s *CreateEndpointInput) SetDocDbSettings(v *DocDbSettings) *CreateEndpointInput {
	s.DocDbSettings = v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *CreateEndpointInput) SetDynamoDbSettings(v *DynamoDbSettings) *CreateEndpointInput {
	s.DynamoDbSettings = v
	return s
}

// SetElasticsearchSettings sets the ElasticsearchSettings field's value.
func (s *CreateEndpointInput) SetElasticsearchSettings(v *ElasticsearchSettings) *CreateEndpointInput {
	s.ElasticsearchSettings = v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *CreateEndpointInput) SetEndpointIdentifier(v string) *CreateEndpointInput {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateEndpointInput) SetEndpointType(v string) *CreateEndpointInput {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *CreateEndpointInput) SetEngineName(v string) *CreateEndpointInput {
	s.EngineName = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *CreateEndpointInput) SetExternalTableDefinition(v string) *CreateEndpointInput {
	s.ExternalTableDefinition = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *CreateEndpointInput) SetExtraConnectionAttributes(v string) *CreateEndpointInput {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetGcpMySQLSettings sets the GcpMySQLSettings field's value.
func (s *CreateEndpointInput) SetGcpMySQLSettings(v *GcpMySQLSettings) *CreateEndpointInput {
	s.GcpMySQLSettings = v
	return s
}

// SetIBMDb2Settings sets the IBMDb2Settings field's value.
func (s *CreateEndpointInput) SetIBMDb2Settings(v *IBMDb2Settings) *CreateEndpointInput {
	s.IBMDb2Settings = v
	return s
}

// SetKafkaSettings sets the KafkaSettings field's value.
func (s *CreateEndpointInput) SetKafkaSettings(v *KafkaSettings) *CreateEndpointInput {
	s.KafkaSettings = v
	return s
}

// SetKinesisSettings sets the KinesisSettings field's value.
func (s *CreateEndpointInput) SetKinesisSettings(v *KinesisSettings) *CreateEndpointInput {
	s.KinesisSettings = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEndpointInput) SetKmsKeyId(v string) *CreateEndpointInput {
	s.KmsKeyId = &v
	return s
}

// SetMicrosoftSQLServerSettings sets the MicrosoftSQLServerSettings field's value.
func (s *CreateEndpointInput) SetMicrosoftSQLServerSettings(v *MicrosoftSQLServerSettings) *CreateEndpointInput {
	s.MicrosoftSQLServerSettings = v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *CreateEndpointInput) SetMongoDbSettings(v *MongoDbSettings) *CreateEndpointInput {
	s.MongoDbSettings = v
	return s
}

// SetMySQLSettings sets the MySQLSettings field's value.
func (s *CreateEndpointInput) SetMySQLSettings(v *MySQLSettings) *CreateEndpointInput {
	s.MySQLSettings = v
	return s
}

// SetNeptuneSettings sets the NeptuneSettings field's value.
func (s *CreateEndpointInput) SetNeptuneSettings(v *NeptuneSettings) *CreateEndpointInput {
	s.NeptuneSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *CreateEndpointInput) SetOracleSettings(v *OracleSettings) *CreateEndpointInput {
	s.OracleSettings = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateEndpointInput) SetPassword(v string) *CreateEndpointInput {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateEndpointInput) SetPort(v int64) *CreateEndpointInput {
	s.Port = &v
	return s
}

// SetPostgreSQLSettings sets the PostgreSQLSettings field's value.
func (s *CreateEndpointInput) SetPostgreSQLSettings(v *PostgreSQLSettings) *CreateEndpointInput {
	s.PostgreSQLSettings = v
	return s
}

// SetRedisSettings sets the RedisSettings field's value.
func (s *CreateEndpointInput) SetRedisSettings(v *RedisSettings) *CreateEndpointInput {
	s.RedisSettings = v
	return s
}

// SetRedshiftSettings sets the RedshiftSettings field's value.
func (s *CreateEndpointInput) SetRedshiftSettings(v *RedshiftSettings) *CreateEndpointInput {
	s.RedshiftSettings = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateEndpointInput) SetResourceIdentifier(v string) *CreateEndpointInput {
	s.ResourceIdentifier = &v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *CreateEndpointInput) SetS3Settings(v *S3Settings) *CreateEndpointInput {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateEndpointInput) SetServerName(v string) *CreateEndpointInput {
	s.ServerName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *CreateEndpointInput) SetServiceAccessRoleArn(v string) *CreateEndpointInput {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *CreateEndpointInput) SetSslMode(v string) *CreateEndpointInput {
	s.SslMode = &v
	return s
}

// SetSybaseSettings sets the SybaseSettings field's value.
func (s *CreateEndpointInput) SetSybaseSettings(v *SybaseSettings) *CreateEndpointInput {
	s.SybaseSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

// SetTimestreamSettings sets the TimestreamSettings field's value.
func (s *CreateEndpointInput) SetTimestreamSettings(v *TimestreamSettings) *CreateEndpointInput {
	s.TimestreamSettings = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateEndpointInput) SetUsername(v string) *CreateEndpointInput {
	s.Username = &v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was created.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateEndpointOutput) SetEndpoint(v *Endpoint) *CreateEndpointOutput {
	s.Endpoint = v
	return s
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, or set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// For more information, see Working with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
	// in the Database Migration Service User Guide.
	EventCategories []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of identifiers for which DMS provides notification events.
	//
	// If you don't specify a value, notifications are provided for all sources.
	//
	// If you specify multiple values, they must be of the same type. For example,
	// if you specify a database instance ID, then all of the other values must
	// be database instance IDs.
	SourceIds []*string `type:"list"`

	// The type of DMS resource that generates the events. For example, if you want
	// to be notified of events generated by a replication instance, you set this
	// parameter to replication-instance. If this value isn't specified, all events
	// are returned.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`

	// The name of the DMS event notification subscription. This name must be less
	// than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// One or more tags to be assigned to the event subscription.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was created.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type CreateFleetAdvisorCollectorInput struct {
	_ struct{} `type:"structure"`

	// The name of your Fleet Advisor collector (for example, sample-collector).
	//
	// CollectorName is a required field
	CollectorName *string `type:"string" required:"true"`

	// A summary description of your Fleet Advisor collector.
	Description *string `type:"string"`

	// The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory
	// metadata.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// The IAM role that grants permissions to access the specified Amazon S3 bucket.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetAdvisorCollectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetAdvisorCollectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetAdvisorCollectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetAdvisorCollectorInput"}
	if s.CollectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectorName"))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectorName sets the CollectorName field's value.
func (s *CreateFleetAdvisorCollectorInput) SetCollectorName(v string) *CreateFleetAdvisorCollectorInput {
	s.CollectorName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetAdvisorCollectorInput) SetDescription(v string) *CreateFleetAdvisorCollectorInput {
	s.Description = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateFleetAdvisorCollectorInput) SetS3BucketName(v string) *CreateFleetAdvisorCollectorInput {
	s.S3BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *CreateFleetAdvisorCollectorInput) SetServiceAccessRoleArn(v string) *CreateFleetAdvisorCollectorInput {
	s.ServiceAccessRoleArn = &v
	return s
}

type CreateFleetAdvisorCollectorOutput struct {
	_ struct{} `type:"structure"`

	// The name of the new Fleet Advisor collector.
	CollectorName *string `type:"string"`

	// The unique ID of the new Fleet Advisor collector, for example: 22fda70c-40d5-4acf-b233-a495bd8eb7f5
	CollectorReferencedId *string `type:"string"`

	// A summary description of the Fleet Advisor collector.
	Description *string `type:"string"`

	// The Amazon S3 bucket that the collector uses to store inventory metadata.
	S3BucketName *string `type:"string"`

	// The IAM role that grants permissions to access the specified Amazon S3 bucket.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetAdvisorCollectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetAdvisorCollectorOutput) GoString() string {
	return s.String()
}

// SetCollectorName sets the CollectorName field's value.
func (s *CreateFleetAdvisorCollectorOutput) SetCollectorName(v string) *CreateFleetAdvisorCollectorOutput {
	s.CollectorName = &v
	return s
}

// SetCollectorReferencedId sets the CollectorReferencedId field's value.
func (s *CreateFleetAdvisorCollectorOutput) SetCollectorReferencedId(v string) *CreateFleetAdvisorCollectorOutput {
	s.CollectorReferencedId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetAdvisorCollectorOutput) SetDescription(v string) *CreateFleetAdvisorCollectorOutput {
	s.Description = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateFleetAdvisorCollectorOutput) SetS3BucketName(v string) *CreateFleetAdvisorCollectorOutput {
	s.S3BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *CreateFleetAdvisorCollectorOutput) SetServiceAccessRoleArn(v string) *CreateFleetAdvisorCollectorOutput {
	s.ServiceAccessRoleArn = &v
	return s
}

type CreateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the instance profile will be created. The default
	// value is a random, system-chosen Availability Zone in the Amazon Web Services
	// Region where your data provider is created, for examplem us-east-1d.
	AvailabilityZone *string `type:"string"`

	// A user-friendly description of the instance profile.
	Description *string `type:"string"`

	// A user-friendly name for the instance profile.
	InstanceProfileName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the
	// connection parameters for the instance profile.
	//
	// If you don't specify a value for the KmsKeyArn parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyArn *string `type:"string"`

	// Specifies the network type for the instance profile. A value of IPV4 represents
	// an instance profile with IPv4 network type and only supports IPv4 addressing.
	// A value of IPV6 represents an instance profile with IPv6 network type and
	// only supports IPv6 addressing. A value of DUAL represents an instance profile
	// with dual network type that supports IPv4 and IPv6 addressing.
	NetworkType *string `type:"string"`

	// Specifies the accessibility options for the instance profile. A value of
	// true represents an instance profile with a public IP address. A value of
	// false represents an instance profile with a private IP address. The default
	// value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// A subnet group to associate with the instance profile.
	SubnetGroupIdentifier *string `type:"string"`

	// One or more tags to be assigned to the instance profile.
	Tags []*Tag `type:"list"`

	// Specifies the VPC security group names to be used with the instance profile.
	// The VPC security group must work with the VPC containing the instance profile.
	VpcSecurityGroups []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileInput) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstanceProfileInput) SetAvailabilityZone(v string) *CreateInstanceProfileInput {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateInstanceProfileInput) SetDescription(v string) *CreateInstanceProfileInput {
	s.Description = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *CreateInstanceProfileInput) SetInstanceProfileName(v string) *CreateInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateInstanceProfileInput) SetKmsKeyArn(v string) *CreateInstanceProfileInput {
	s.KmsKeyArn = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *CreateInstanceProfileInput) SetNetworkType(v string) *CreateInstanceProfileInput {
	s.NetworkType = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateInstanceProfileInput) SetPubliclyAccessible(v bool) *CreateInstanceProfileInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSubnetGroupIdentifier sets the SubnetGroupIdentifier field's value.
func (s *CreateInstanceProfileInput) SetSubnetGroupIdentifier(v string) *CreateInstanceProfileInput {
	s.SubnetGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstanceProfileInput) SetTags(v []*Tag) *CreateInstanceProfileInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *CreateInstanceProfileInput) SetVpcSecurityGroups(v []*string) *CreateInstanceProfileInput {
	s.VpcSecurityGroups = v
	return s
}

type CreateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The instance profile that was created.
	InstanceProfile *InstanceProfile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *CreateInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *CreateInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

type CreateMigrationProjectInput struct {
	_ struct{} `type:"structure"`

	// A user-friendly description of the migration project.
	Description *string `type:"string"`

	// The identifier of the associated instance profile. Identifiers must begin
	// with a letter and must contain only ASCII letters, digits, and hyphens. They
	// can't end with a hyphen, or contain two consecutive hyphens.
	//
	// InstanceProfileIdentifier is a required field
	InstanceProfileIdentifier *string `type:"string" required:"true"`

	// A user-friendly name for the migration project.
	MigrationProjectName *string `type:"string"`

	// The schema conversion application attributes, including the Amazon S3 bucket
	// name and Amazon S3 role ARN.
	SchemaConversionApplicationAttributes *SCApplicationAttributes `type:"structure"`

	// Information about the source data provider, including the name, ARN, and
	// Secrets Manager parameters.
	//
	// SourceDataProviderDescriptors is a required field
	SourceDataProviderDescriptors []*DataProviderDescriptorDefinition `type:"list" required:"true"`

	// One or more tags to be assigned to the migration project.
	Tags []*Tag `type:"list"`

	// Information about the target data provider, including the name, ARN, and
	// Amazon Web Services Secrets Manager parameters.
	//
	// TargetDataProviderDescriptors is a required field
	TargetDataProviderDescriptors []*DataProviderDescriptorDefinition `type:"list" required:"true"`

	// The settings in JSON format for migration rules. Migration rules make it
	// possible for you to change the object names according to the rules that you
	// specify. For example, you can change an object name to lowercase or uppercase,
	// add or remove a prefix or suffix, or rename objects.
	TransformationRules *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMigrationProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMigrationProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMigrationProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMigrationProjectInput"}
	if s.InstanceProfileIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileIdentifier"))
	}
	if s.SourceDataProviderDescriptors == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDataProviderDescriptors"))
	}
	if s.TargetDataProviderDescriptors == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDataProviderDescriptors"))
	}
	if s.SourceDataProviderDescriptors != nil {
		for i, v := range s.SourceDataProviderDescriptors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceDataProviderDescriptors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetDataProviderDescriptors != nil {
		for i, v := range s.TargetDataProviderDescriptors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetDataProviderDescriptors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateMigrationProjectInput) SetDescription(v string) *CreateMigrationProjectInput {
	s.Description = &v
	return s
}

// SetInstanceProfileIdentifier sets the InstanceProfileIdentifier field's value.
func (s *CreateMigrationProjectInput) SetInstanceProfileIdentifier(v string) *CreateMigrationProjectInput {
	s.InstanceProfileIdentifier = &v
	return s
}

// SetMigrationProjectName sets the MigrationProjectName field's value.
func (s *CreateMigrationProjectInput) SetMigrationProjectName(v string) *CreateMigrationProjectInput {
	s.MigrationProjectName = &v
	return s
}

// SetSchemaConversionApplicationAttributes sets the SchemaConversionApplicationAttributes field's value.
func (s *CreateMigrationProjectInput) SetSchemaConversionApplicationAttributes(v *SCApplicationAttributes) *CreateMigrationProjectInput {
	s.SchemaConversionApplicationAttributes = v
	return s
}

// SetSourceDataProviderDescriptors sets the SourceDataProviderDescriptors field's value.
func (s *CreateMigrationProjectInput) SetSourceDataProviderDescriptors(v []*DataProviderDescriptorDefinition) *CreateMigrationProjectInput {
	s.SourceDataProviderDescriptors = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMigrationProjectInput) SetTags(v []*Tag) *CreateMigrationProjectInput {
	s.Tags = v
	return s
}

// SetTargetDataProviderDescriptors sets the TargetDataProviderDescriptors field's value.
func (s *CreateMigrationProjectInput) SetTargetDataProviderDescriptors(v []*DataProviderDescriptorDefinition) *CreateMigrationProjectInput {
	s.TargetDataProviderDescriptors = v
	return s
}

// SetTransformationRules sets the TransformationRules field's value.
func (s *CreateMigrationProjectInput) SetTransformationRules(v string) *CreateMigrationProjectInput {
	s.TransformationRules = &v
	return s
}

type CreateMigrationProjectOutput struct {
	_ struct{} `type:"structure"`

	// The migration project that was created.
	MigrationProject *MigrationProject `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMigrationProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMigrationProjectOutput) GoString() string {
	return s.String()
}

// SetMigrationProject sets the MigrationProject field's value.
func (s *CreateMigrationProjectOutput) SetMigrationProject(v *MigrationProject) *CreateMigrationProjectOutput {
	s.MigrationProject = v
	return s
}

type CreateReplicationConfigInput struct {
	_ struct{} `type:"structure"`

	// Configuration parameters for provisioning an DMS Serverless replication.
	//
	// ComputeConfig is a required field
	ComputeConfig *ComputeConfig `type:"structure" required:"true"`

	// A unique identifier that you want to use to create a ReplicationConfigArn
	// that is returned as part of the output from this action. You can then pass
	// this output ReplicationConfigArn as the value of the ReplicationConfigArn
	// option for other actions to identify both DMS Serverless replications and
	// replication configurations that you want those actions to operate on. For
	// some actions, you can also use either this unique identifier or a corresponding
	// ARN in action filters to identify the specific replication and replication
	// configuration to operate on.
	//
	// ReplicationConfigIdentifier is a required field
	ReplicationConfigIdentifier *string `type:"string" required:"true"`

	// Optional JSON settings for DMS Serverless replications that are provisioned
	// using this replication configuration. For example, see Change processing
	// tuning settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html).
	ReplicationSettings *string `type:"string"`

	// The type of DMS Serverless replication to provision using this replication
	// configuration.
	//
	// Possible values:
	//
	//    * "full-load"
	//
	//    * "cdc"
	//
	//    * "full-load-and-cdc"
	//
	// ReplicationType is a required field
	ReplicationType *string `type:"string" required:"true" enum:"MigrationTypeValue"`

	// Optional unique value or name that you set for a given resource that can
	// be used to construct an Amazon Resource Name (ARN) for that resource. For
	// more information, see Fine-grained access control using resource names and
	// tags (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess).
	ResourceIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) of the source endpoint for this DMS Serverless
	// replication configuration.
	//
	// SourceEndpointArn is a required field
	SourceEndpointArn *string `type:"string" required:"true"`

	// Optional JSON settings for specifying supplemental data. For more information,
	// see Specifying supplemental data for task settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html).
	SupplementalSettings *string `type:"string"`

	// JSON table mappings for DMS Serverless replications that are provisioned
	// using this replication configuration. For more information, see Specifying
	// table selection and transformations rules using JSON (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html).
	//
	// TableMappings is a required field
	TableMappings *string `type:"string" required:"true"`

	// One or more optional tags associated with resources used by the DMS Serverless
	// replication. For more information, see Tagging resources in Database Migration
	// Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html).
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless
	// replication configuration.
	//
	// TargetEndpointArn is a required field
	TargetEndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationConfigInput"}
	if s.ComputeConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeConfig"))
	}
	if s.ReplicationConfigIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigIdentifier"))
	}
	if s.ReplicationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationType"))
	}
	if s.SourceEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEndpointArn"))
	}
	if s.TableMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("TableMappings"))
	}
	if s.TargetEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeConfig sets the ComputeConfig field's value.
func (s *CreateReplicationConfigInput) SetComputeConfig(v *ComputeConfig) *CreateReplicationConfigInput {
	s.ComputeConfig = v
	return s
}

// SetReplicationConfigIdentifier sets the ReplicationConfigIdentifier field's value.
func (s *CreateReplicationConfigInput) SetReplicationConfigIdentifier(v string) *CreateReplicationConfigInput {
	s.ReplicationConfigIdentifier = &v
	return s
}

// SetReplicationSettings sets the ReplicationSettings field's value.
func (s *CreateReplicationConfigInput) SetReplicationSettings(v string) *CreateReplicationConfigInput {
	s.ReplicationSettings = &v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *CreateReplicationConfigInput) SetReplicationType(v string) *CreateReplicationConfigInput {
	s.ReplicationType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateReplicationConfigInput) SetResourceIdentifier(v string) *CreateReplicationConfigInput {
	s.ResourceIdentifier = &v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *CreateReplicationConfigInput) SetSourceEndpointArn(v string) *CreateReplicationConfigInput {
	s.SourceEndpointArn = &v
	return s
}

// SetSupplementalSettings sets the SupplementalSettings field's value.
func (s *CreateReplicationConfigInput) SetSupplementalSettings(v string) *CreateReplicationConfigInput {
	s.SupplementalSettings = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *CreateReplicationConfigInput) SetTableMappings(v string) *CreateReplicationConfigInput {
	s.TableMappings = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationConfigInput) SetTags(v []*Tag) *CreateReplicationConfigInput {
	s.Tags = v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *CreateReplicationConfigInput) SetTargetEndpointArn(v string) *CreateReplicationConfigInput {
	s.TargetEndpointArn = &v
	return s
}

type CreateReplicationConfigOutput struct {
	_ struct{} `type:"structure"`

	// Configuration parameters returned from the DMS Serverless replication after
	// it is created.
	ReplicationConfig *ReplicationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigOutput) GoString() string {
	return s.String()
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *CreateReplicationConfigOutput) SetReplicationConfig(v *ReplicationConfig) *CreateReplicationConfigOutput {
	s.ReplicationConfig = v
	return s
}

type CreateReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// A value that indicates whether minor engine upgrades are applied automatically
	// to the replication instance during the maintenance window. This parameter
	// defaults to true.
	//
	// Default: true
	//
	// When AutoMinorVersionUpgrade is enabled, DMS uses the current default engine
	// version when you create a replication instance. For example, if you set EngineVersion
	// to a lower version number than the current default version, DMS uses the
	// default version.
	//
	// If AutoMinorVersionUpgrade isn’t enabled when you create a replication
	// instance, DMS uses the engine version specified by the EngineVersion parameter.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone where the replication instance will be created. The
	// default value is a random, system-chosen Availability Zone in the endpoint's
	// Amazon Web Services Region, for example: us-east-1d.
	AvailabilityZone *string `type:"string"`

	// A list of custom DNS name servers supported for the replication instance
	// to access your on-premise source or target database. This list overrides
	// the default name servers supported by the replication instance. You can specify
	// a comma-separated list of internet addresses for up to four on-premise DNS
	// name servers. For example: "1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"
	DnsNameServers *string `type:"string"`

	// The engine version number of the replication instance.
	//
	// If an engine version number is not specified when a replication instance
	// is created, the default is the latest engine version available.
	EngineVersion *string `type:"string"`

	// An KMS key identifier that is used to encrypt the data on the replication
	// instance.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyId *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The type of IP address protocol used by a replication instance, such as IPv4
	// only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only
	// is not yet supported.
	NetworkType *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per Amazon Web Services Region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. For example to specify the instance
	// class dms.c4.large, set this parameter to "dms.c4.large".
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Choosing the right DMS replication instance (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html);
	// and, Selecting the best size for a replication instance (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_BestPractices.SizingReplicationInstance.html).
	//
	// ReplicationInstanceClass is a required field
	ReplicationInstanceClass *string `type:"string" required:"true"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain 1-63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	//
	// ReplicationInstanceIdentifier is a required field
	ReplicationInstanceIdentifier *string `type:"string" required:"true"`

	// A subnet group to associate with the replication instance.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// One or more tags to be assigned to the replication instance.
	Tags []*Tag `type:"list"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationInstanceInput"}
	if s.ReplicationInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceClass"))
	}
	if s.ReplicationInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateReplicationInstanceInput) SetAllocatedStorage(v int64) *CreateReplicationInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateReplicationInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateReplicationInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateReplicationInstanceInput) SetAvailabilityZone(v string) *CreateReplicationInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetDnsNameServers sets the DnsNameServers field's value.
func (s *CreateReplicationInstanceInput) SetDnsNameServers(v string) *CreateReplicationInstanceInput {
	s.DnsNameServers = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateReplicationInstanceInput) SetEngineVersion(v string) *CreateReplicationInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateReplicationInstanceInput) SetKmsKeyId(v string) *CreateReplicationInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateReplicationInstanceInput) SetMultiAZ(v bool) *CreateReplicationInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *CreateReplicationInstanceInput) SetNetworkType(v string) *CreateReplicationInstanceInput {
	s.NetworkType = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateReplicationInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateReplicationInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateReplicationInstanceInput) SetPubliclyAccessible(v bool) *CreateReplicationInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceClass(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetResourceIdentifier(v string) *CreateReplicationInstanceInput {
	s.ResourceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationInstanceInput) SetTags(v []*Tag) *CreateReplicationInstanceInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateReplicationInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateReplicationInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was created.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *CreateReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *CreateReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

type CreateReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	//
	// ReplicationSubnetGroupDescription is a required field
	ReplicationSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the replication subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// spaces, underscores, or hyphens. Must not be "default".
	//
	// Example: mySubnetgroup
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// One or more subnet IDs to be assigned to the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// One or more tags to be assigned to the subnet group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupDescription"))
	}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupDescription(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateReplicationSubnetGroupInput) SetSubnetIds(v []*string) *CreateReplicationSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationSubnetGroupInput) SetTags(v []*Tag) *CreateReplicationSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The replication subnet group that was created.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *CreateReplicationSubnetGroupOutput) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *CreateReplicationSubnetGroupOutput {
	s.ReplicationSubnetGroup = v
	return s
}

type CreateReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	//
	// When you use this task setting with a source PostgreSQL database, a logical
	// replication slot should already be created and associated with the source
	// endpoint. You can verify this by setting the slotName extra connection attribute
	// to the name of this logical replication slot. For more information, see Extra
	// Connection Attributes When Using PostgreSQL as a Source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
	CdcStartPosition *string `type:"string"`

	// Indicates the start time for a change data capture (CDC) operation. Use either
	// CdcStartTime or CdcStartPosition to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
	CdcStartTime *time.Time `type:"timestamp"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12“
	CdcStopPosition *string `type:"string"`

	// The migration type. Valid values: full-load | cdc | full-load-and-cdc
	//
	// MigrationType is a required field
	MigrationType *string `type:"string" required:"true" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of a replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// An identifier for the replication task.
	//
	// Constraints:
	//
	//    * Must contain 1-255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ReplicationTaskIdentifier is a required field
	ReplicationTaskIdentifier *string `type:"string" required:"true"`

	// Overall settings for the task, in JSON format. For more information, see
	// Specifying Task Settings for Database Migration Service Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html)
	// in the Database Migration Service User Guide.
	ReplicationTaskSettings *string `type:"string"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
	//
	// SourceEndpointArn is a required field
	SourceEndpointArn *string `type:"string" required:"true"`

	// The table mappings for the task, in JSON format. For more information, see
	// Using Table Mapping to Specify Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
	// in the Database Migration Service User Guide.
	//
	// TableMappings is a required field
	TableMappings *string `type:"string" required:"true"`

	// One or more tags to be assigned to the replication task.
	Tags []*Tag `type:"list"`

	// An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
	//
	// TargetEndpointArn is a required field
	TargetEndpointArn *string `type:"string" required:"true"`

	// Supplemental information that the task requires to migrate the data for certain
	// source and target endpoints. For more information, see Specifying Supplemental
	// Data for Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
	// in the Database Migration Service User Guide.
	TaskData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationTaskInput"}
	if s.MigrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}
	if s.ReplicationTaskIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskIdentifier"))
	}
	if s.SourceEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEndpointArn"))
	}
	if s.TableMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("TableMappings"))
	}
	if s.TargetEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartPosition sets the CdcStartPosition field's value.
func (s *CreateReplicationTaskInput) SetCdcStartPosition(v string) *CreateReplicationTaskInput {
	s.CdcStartPosition = &v
	return s
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *CreateReplicationTaskInput) SetCdcStartTime(v time.Time) *CreateReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetCdcStopPosition sets the CdcStopPosition field's value.
func (s *CreateReplicationTaskInput) SetCdcStopPosition(v string) *CreateReplicationTaskInput {
	s.CdcStopPosition = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *CreateReplicationTaskInput) SetMigrationType(v string) *CreateReplicationTaskInput {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *CreateReplicationTaskInput) SetReplicationInstanceArn(v string) *CreateReplicationTaskInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskIdentifier(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskSettings(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskSettings = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateReplicationTaskInput) SetResourceIdentifier(v string) *CreateReplicationTaskInput {
	s.ResourceIdentifier = &v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetSourceEndpointArn(v string) *CreateReplicationTaskInput {
	s.SourceEndpointArn = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *CreateReplicationTaskInput) SetTableMappings(v string) *CreateReplicationTaskInput {
	s.TableMappings = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationTaskInput) SetTags(v []*Tag) *CreateReplicationTaskInput {
	s.Tags = v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetTargetEndpointArn(v string) *CreateReplicationTaskInput {
	s.TargetEndpointArn = &v
	return s
}

// SetTaskData sets the TaskData field's value.
func (s *CreateReplicationTaskInput) SetTaskData(v string) *CreateReplicationTaskInput {
	s.TaskData = &v
	return s
}

type CreateReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was created.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *CreateReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *CreateReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// Provides information that defines a data provider.
type DataProvider struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
	DataProviderArn *string `type:"string"`

	// The time the data provider was created.
	DataProviderCreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the data provider.
	DataProviderName *string `type:"string"`

	// A description of the data provider. Descriptions can have up to 31 characters.
	// A description can contain only ASCII letters, digits, and hyphens ('-').
	// Also, it can't end with a hyphen or contain two consecutive hyphens, and
	// can only begin with a letter.
	Description *string `type:"string"`

	// The type of database engine for the data provider. Valid values include "aurora",
	// "aurora_postgresql", "mysql", "oracle", "postgres", and "sqlserver". A value
	// of "aurora" represents Amazon Aurora MySQL-Compatible Edition.
	Engine *string `type:"string"`

	// The settings in JSON format for a data provider.
	Settings *DataProviderSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProvider) GoString() string {
	return s.String()
}

// SetDataProviderArn sets the DataProviderArn field's value.
func (s *DataProvider) SetDataProviderArn(v string) *DataProvider {
	s.DataProviderArn = &v
	return s
}

// SetDataProviderCreationTime sets the DataProviderCreationTime field's value.
func (s *DataProvider) SetDataProviderCreationTime(v time.Time) *DataProvider {
	s.DataProviderCreationTime = &v
	return s
}

// SetDataProviderName sets the DataProviderName field's value.
func (s *DataProvider) SetDataProviderName(v string) *DataProvider {
	s.DataProviderName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataProvider) SetDescription(v string) *DataProvider {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DataProvider) SetEngine(v string) *DataProvider {
	s.Engine = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *DataProvider) SetSettings(v *DataProviderSettings) *DataProvider {
	s.Settings = v
	return s
}

// Information about a data provider.
type DataProviderDescriptor struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data provider.
	DataProviderArn *string `type:"string"`

	// The user-friendly name of the data provider.
	DataProviderName *string `type:"string"`

	// The ARN of the role used to access Amazon Web Services Secrets Manager.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The identifier of the Amazon Web Services Secrets Manager Secret used to
	// store access credentials for the data provider.
	SecretsManagerSecretId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderDescriptor) GoString() string {
	return s.String()
}

// SetDataProviderArn sets the DataProviderArn field's value.
func (s *DataProviderDescriptor) SetDataProviderArn(v string) *DataProviderDescriptor {
	s.DataProviderArn = &v
	return s
}

// SetDataProviderName sets the DataProviderName field's value.
func (s *DataProviderDescriptor) SetDataProviderName(v string) *DataProviderDescriptor {
	s.DataProviderName = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *DataProviderDescriptor) SetSecretsManagerAccessRoleArn(v string) *DataProviderDescriptor {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *DataProviderDescriptor) SetSecretsManagerSecretId(v string) *DataProviderDescriptor {
	s.SecretsManagerSecretId = &v
	return s
}

// Information about a data provider.
type DataProviderDescriptorDefinition struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the data provider.
	//
	// DataProviderIdentifier is a required field
	DataProviderIdentifier *string `type:"string" required:"true"`

	// The ARN of the role used to access Amazon Web Services Secrets Manager.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The identifier of the Amazon Web Services Secrets Manager Secret used to
	// store access credentials for the data provider.
	SecretsManagerSecretId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderDescriptorDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderDescriptorDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProviderDescriptorDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProviderDescriptorDefinition"}
	if s.DataProviderIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataProviderIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataProviderIdentifier sets the DataProviderIdentifier field's value.
func (s *DataProviderDescriptorDefinition) SetDataProviderIdentifier(v string) *DataProviderDescriptorDefinition {
	s.DataProviderIdentifier = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *DataProviderDescriptorDefinition) SetSecretsManagerAccessRoleArn(v string) *DataProviderDescriptorDefinition {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *DataProviderDescriptorDefinition) SetSecretsManagerSecretId(v string) *DataProviderDescriptorDefinition {
	s.SecretsManagerSecretId = &v
	return s
}

// Provides information that defines a data provider.
type DataProviderSettings struct {
	_ struct{} `type:"structure"`

	// Provides information that defines a Microsoft SQL Server data provider.
	MicrosoftSqlServerSettings *MicrosoftSqlServerDataProviderSettings `type:"structure"`

	// Provides information that defines a MySQL data provider.
	MySqlSettings *MySqlDataProviderSettings `type:"structure"`

	// Provides information that defines an Oracle data provider.
	OracleSettings *OracleDataProviderSettings `type:"structure"`

	// Provides information that defines a PostgreSQL data provider.
	PostgreSqlSettings *PostgreSqlDataProviderSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProviderSettings) GoString() string {
	return s.String()
}

// SetMicrosoftSqlServerSettings sets the MicrosoftSqlServerSettings field's value.
func (s *DataProviderSettings) SetMicrosoftSqlServerSettings(v *MicrosoftSqlServerDataProviderSettings) *DataProviderSettings {
	s.MicrosoftSqlServerSettings = v
	return s
}

// SetMySqlSettings sets the MySqlSettings field's value.
func (s *DataProviderSettings) SetMySqlSettings(v *MySqlDataProviderSettings) *DataProviderSettings {
	s.MySqlSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *DataProviderSettings) SetOracleSettings(v *OracleDataProviderSettings) *DataProviderSettings {
	s.OracleSettings = v
	return s
}

// SetPostgreSqlSettings sets the PostgreSqlSettings field's value.
func (s *DataProviderSettings) SetPostgreSqlSettings(v *PostgreSqlDataProviderSettings) *DataProviderSettings {
	s.PostgreSqlSettings = v
	return s
}

// Describes an inventory database instance for a Fleet Advisor collector.
type DatabaseInstanceSoftwareDetailsResponse struct {
	_ struct{} `type:"structure"`

	// The database engine of a database in a Fleet Advisor collector inventory,
	// for example Microsoft SQL Server.
	Engine *string `type:"string"`

	// The database engine edition of a database in a Fleet Advisor collector inventory,
	// for example Express.
	EngineEdition *string `type:"string"`

	// The database engine version of a database in a Fleet Advisor collector inventory,
	// for example 2019.
	EngineVersion *string `type:"string"`

	// The operating system architecture of the database.
	OsArchitecture *int64 `type:"integer"`

	// The service pack level of the database.
	ServicePack *string `type:"string"`

	// The support level of the database, for example Mainstream support.
	SupportLevel *string `type:"string"`

	// Information about the database engine software, for example Mainstream support
	// ends on November 14th, 2024.
	Tooltip *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInstanceSoftwareDetailsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInstanceSoftwareDetailsResponse) GoString() string {
	return s.String()
}

// SetEngine sets the Engine field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetEngine(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.Engine = &v
	return s
}

// SetEngineEdition sets the EngineEdition field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetEngineEdition(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.EngineEdition = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetEngineVersion(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.EngineVersion = &v
	return s
}

// SetOsArchitecture sets the OsArchitecture field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetOsArchitecture(v int64) *DatabaseInstanceSoftwareDetailsResponse {
	s.OsArchitecture = &v
	return s
}

// SetServicePack sets the ServicePack field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetServicePack(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.ServicePack = &v
	return s
}

// SetSupportLevel sets the SupportLevel field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetSupportLevel(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.SupportLevel = &v
	return s
}

// SetTooltip sets the Tooltip field's value.
func (s *DatabaseInstanceSoftwareDetailsResponse) SetTooltip(v string) *DatabaseInstanceSoftwareDetailsResponse {
	s.Tooltip = &v
	return s
}

// Describes a database in a Fleet Advisor collector inventory.
type DatabaseResponse struct {
	_ struct{} `type:"structure"`

	// A list of collectors associated with the database.
	Collectors []*CollectorShortInfoResponse `type:"list"`

	// The ID of a database in a Fleet Advisor collector inventory.
	DatabaseId *string `type:"string"`

	// The name of a database in a Fleet Advisor collector inventory.
	DatabaseName *string `type:"string"`

	// The IP address of a database in a Fleet Advisor collector inventory.
	IpAddress *string `type:"string"`

	// The number of schemas in a Fleet Advisor collector inventory database.
	NumberOfSchemas *int64 `type:"long"`

	// The server name of a database in a Fleet Advisor collector inventory.
	Server *ServerShortInfoResponse `type:"structure"`

	// The software details of a database in a Fleet Advisor collector inventory,
	// such as database engine and version.
	SoftwareDetails *DatabaseInstanceSoftwareDetailsResponse `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseResponse) GoString() string {
	return s.String()
}

// SetCollectors sets the Collectors field's value.
func (s *DatabaseResponse) SetCollectors(v []*CollectorShortInfoResponse) *DatabaseResponse {
	s.Collectors = v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *DatabaseResponse) SetDatabaseId(v string) *DatabaseResponse {
	s.DatabaseId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DatabaseResponse) SetDatabaseName(v string) *DatabaseResponse {
	s.DatabaseName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *DatabaseResponse) SetIpAddress(v string) *DatabaseResponse {
	s.IpAddress = &v
	return s
}

// SetNumberOfSchemas sets the NumberOfSchemas field's value.
func (s *DatabaseResponse) SetNumberOfSchemas(v int64) *DatabaseResponse {
	s.NumberOfSchemas = &v
	return s
}

// SetServer sets the Server field's value.
func (s *DatabaseResponse) SetServer(v *ServerShortInfoResponse) *DatabaseResponse {
	s.Server = v
	return s
}

// SetSoftwareDetails sets the SoftwareDetails field's value.
func (s *DatabaseResponse) SetSoftwareDetails(v *DatabaseInstanceSoftwareDetailsResponse) *DatabaseResponse {
	s.SoftwareDetails = v
	return s
}

// Describes a database in a Fleet Advisor collector inventory.
type DatabaseShortInfoResponse struct {
	_ struct{} `type:"structure"`

	// The database engine of a database in a Fleet Advisor collector inventory,
	// for example PostgreSQL.
	DatabaseEngine *string `type:"string"`

	// The ID of a database in a Fleet Advisor collector inventory.
	DatabaseId *string `type:"string"`

	// The IP address of a database in a Fleet Advisor collector inventory.
	DatabaseIpAddress *string `type:"string"`

	// The name of a database in a Fleet Advisor collector inventory.
	DatabaseName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseShortInfoResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseShortInfoResponse) GoString() string {
	return s.String()
}

// SetDatabaseEngine sets the DatabaseEngine field's value.
func (s *DatabaseShortInfoResponse) SetDatabaseEngine(v string) *DatabaseShortInfoResponse {
	s.DatabaseEngine = &v
	return s
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *DatabaseShortInfoResponse) SetDatabaseId(v string) *DatabaseShortInfoResponse {
	s.DatabaseId = &v
	return s
}

// SetDatabaseIpAddress sets the DatabaseIpAddress field's value.
func (s *DatabaseShortInfoResponse) SetDatabaseIpAddress(v string) *DatabaseShortInfoResponse {
	s.DatabaseIpAddress = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DatabaseShortInfoResponse) SetDatabaseName(v string) *DatabaseShortInfoResponse {
	s.DatabaseName = &v
	return s
}

// Provides error information about a schema conversion operation.
type DefaultErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultErrorDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DefaultErrorDetails) SetMessage(v string) *DefaultErrorDetails {
	s.Message = &v
	return s
}

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeleteCertificateInput) SetCertificateArn(v string) *DeleteCertificateInput {
	s.CertificateArn = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificate.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DeleteCertificateOutput) SetCertificate(v *Certificate) *DeleteCertificateOutput {
	s.Certificate = v
	return s
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteConnectionInput) SetEndpointArn(v string) *DeleteConnectionInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DeleteConnectionInput) SetReplicationInstanceArn(v string) *DeleteConnectionInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection that is being deleted.
	Connection *Connection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteConnectionOutput) SetConnection(v *Connection) *DeleteConnectionOutput {
	s.Connection = v
	return s
}

type DeleteDataProviderInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data provider to delete.
	//
	// DataProviderIdentifier is a required field
	DataProviderIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataProviderInput"}
	if s.DataProviderIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataProviderIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataProviderIdentifier sets the DataProviderIdentifier field's value.
func (s *DeleteDataProviderInput) SetDataProviderIdentifier(v string) *DeleteDataProviderInput {
	s.DataProviderIdentifier = &v
	return s
}

type DeleteDataProviderOutput struct {
	_ struct{} `type:"structure"`

	// The data provider that was deleted.
	DataProvider *DataProvider `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataProviderOutput) GoString() string {
	return s.String()
}

// SetDataProvider sets the DataProvider field's value.
func (s *DeleteDataProviderOutput) SetDataProvider(v *DataProvider) *DeleteDataProviderOutput {
	s.DataProvider = v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was deleted.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteEndpointOutput) SetEndpoint(v *Endpoint) *DeleteEndpointOutput {
	s.Endpoint = v
	return s
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the DMS event notification subscription to be deleted.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was deleted.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type DeleteFleetAdvisorCollectorInput struct {
	_ struct{} `type:"structure"`

	// The reference ID of the Fleet Advisor collector to delete.
	//
	// CollectorReferencedId is a required field
	CollectorReferencedId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorCollectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorCollectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetAdvisorCollectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetAdvisorCollectorInput"}
	if s.CollectorReferencedId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectorReferencedId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectorReferencedId sets the CollectorReferencedId field's value.
func (s *DeleteFleetAdvisorCollectorInput) SetCollectorReferencedId(v string) *DeleteFleetAdvisorCollectorInput {
	s.CollectorReferencedId = &v
	return s
}

type DeleteFleetAdvisorCollectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorCollectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorCollectorOutput) GoString() string {
	return s.String()
}

type DeleteFleetAdvisorDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Fleet Advisor collector databases to delete.
	//
	// DatabaseIds is a required field
	DatabaseIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetAdvisorDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetAdvisorDatabasesInput"}
	if s.DatabaseIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseIds sets the DatabaseIds field's value.
func (s *DeleteFleetAdvisorDatabasesInput) SetDatabaseIds(v []*string) *DeleteFleetAdvisorDatabasesInput {
	s.DatabaseIds = v
	return s
}

type DeleteFleetAdvisorDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the databases that the operation deleted.
	DatabaseIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetAdvisorDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabaseIds sets the DatabaseIds field's value.
func (s *DeleteFleetAdvisorDatabasesOutput) SetDatabaseIds(v []*string) *DeleteFleetAdvisorDatabasesOutput {
	s.DatabaseIds = v
	return s
}

type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the instance profile to delete.
	//
	// InstanceProfileIdentifier is a required field
	InstanceProfileIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceProfileInput"}
	if s.InstanceProfileIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileIdentifier sets the InstanceProfileIdentifier field's value.
func (s *DeleteInstanceProfileInput) SetInstanceProfileIdentifier(v string) *DeleteInstanceProfileInput {
	s.InstanceProfileIdentifier = &v
	return s
}

type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The instance profile that was deleted.
	InstanceProfile *InstanceProfile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *DeleteInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *DeleteInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

type DeleteMigrationProjectInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the migration project to delete.
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMigrationProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMigrationProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMigrationProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMigrationProjectInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DeleteMigrationProjectInput) SetMigrationProjectIdentifier(v string) *DeleteMigrationProjectInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DeleteMigrationProjectOutput struct {
	_ struct{} `type:"structure"`

	// The migration project that was deleted.
	MigrationProject *MigrationProject `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMigrationProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMigrationProjectOutput) GoString() string {
	return s.String()
}

// SetMigrationProject sets the MigrationProject field's value.
func (s *DeleteMigrationProjectOutput) SetMigrationProject(v *MigrationProject) *DeleteMigrationProjectOutput {
	s.MigrationProject = v
	return s
}

type DeleteReplicationConfigInput struct {
	_ struct{} `type:"structure"`

	// The replication config to delete.
	//
	// ReplicationConfigArn is a required field
	ReplicationConfigArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationConfigInput"}
	if s.ReplicationConfigArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationConfigArn sets the ReplicationConfigArn field's value.
func (s *DeleteReplicationConfigInput) SetReplicationConfigArn(v string) *DeleteReplicationConfigInput {
	s.ReplicationConfigArn = &v
	return s
}

type DeleteReplicationConfigOutput struct {
	_ struct{} `type:"structure"`

	// Configuration parameters returned for the DMS Serverless replication after
	// it is deleted.
	ReplicationConfig *ReplicationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigOutput) GoString() string {
	return s.String()
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *DeleteReplicationConfigOutput) SetReplicationConfig(v *ReplicationConfig) *DeleteReplicationConfigOutput {
	s.ReplicationConfig = v
	return s
}

type DeleteReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication instance to be deleted.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DeleteReplicationInstanceInput) SetReplicationInstanceArn(v string) *DeleteReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DeleteReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was deleted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *DeleteReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *DeleteReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

type DeleteReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The subnet group name of the replication instance.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *DeleteReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *DeleteReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

type DeleteReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteReplicationTaskAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the premigration assessment run to be deleted.
	//
	// ReplicationTaskAssessmentRunArn is a required field
	ReplicationTaskAssessmentRunArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskAssessmentRunInput"}
	if s.ReplicationTaskAssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskAssessmentRunArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *DeleteReplicationTaskAssessmentRunInput) SetReplicationTaskAssessmentRunArn(v string) *DeleteReplicationTaskAssessmentRunInput {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

type DeleteReplicationTaskAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The ReplicationTaskAssessmentRun object for the deleted assessment run.
	ReplicationTaskAssessmentRun *ReplicationTaskAssessmentRun `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskAssessmentRun sets the ReplicationTaskAssessmentRun field's value.
func (s *DeleteReplicationTaskAssessmentRunOutput) SetReplicationTaskAssessmentRun(v *ReplicationTaskAssessmentRun) *DeleteReplicationTaskAssessmentRunOutput {
	s.ReplicationTaskAssessmentRun = v
	return s
}

type DeleteReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task to be deleted.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DeleteReplicationTaskInput) SetReplicationTaskArn(v string) *DeleteReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

type DeleteReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The deleted replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *DeleteReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *DeleteReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Account quota information.
	AccountQuotas []*AccountQuota `type:"list"`

	// A unique DMS identifier for an account in a particular Amazon Web Services
	// Region. The value of this identifier has the following format: c99999999999.
	// DMS uses this identifier to name artifacts. For example, DMS uses this identifier
	// to name the default Amazon S3 bucket for storing task assessment reports
	// in a given Amazon Web Services Region. The format of this S3 bucket name
	// is the following: dms-AccountNumber-UniqueAccountIdentifier. Here is an example
	// name for this default S3 bucket: dms-111122223333-c44445555666.
	//
	// DMS supports the UniqueAccountIdentifier parameter in versions 3.1.4 and
	// later.
	UniqueAccountIdentifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountQuotas sets the AccountQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetAccountQuotas(v []*AccountQuota) *DescribeAccountAttributesOutput {
	s.AccountQuotas = v
	return s
}

// SetUniqueAccountIdentifier sets the UniqueAccountIdentifier field's value.
func (s *DescribeAccountAttributesOutput) SetUniqueAccountIdentifier(v string) *DescribeAccountAttributesOutput {
	s.UniqueAccountIdentifier = &v
	return s
}

type DescribeApplicableIndividualAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// Maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// Name of the migration type that each provided individual assessment must
	// support.
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// ARN of a replication instance on which you want to base the default list
	// of individual assessments.
	ReplicationInstanceArn *string `type:"string"`

	// Amazon Resource Name (ARN) of a migration task on which you want to base
	// the default list of individual assessments.
	ReplicationTaskArn *string `type:"string"`

	// Name of a database engine that the specified replication instance supports
	// as a source.
	SourceEngineName *string `type:"string"`

	// Name of a database engine that the specified replication instance supports
	// as a target.
	TargetEngineName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicableIndividualAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicableIndividualAssessmentsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMarker(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMaxRecords(v int64) *DescribeApplicableIndividualAssessmentsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMigrationType(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetReplicationInstanceArn(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetReplicationTaskArn(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetSourceEngineName sets the SourceEngineName field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetSourceEngineName(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.SourceEngineName = &v
	return s
}

// SetTargetEngineName sets the TargetEngineName field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetTargetEngineName(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.TargetEngineName = &v
	return s
}

type DescribeApplicableIndividualAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// List of names for the individual assessments supported by the premigration
	// assessment run that you start based on the specified request parameters.
	// For more information on the available individual assessments, including compatibility
	// with different migration task configurations, see Working with premigration
	// assessment runs (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html)
	// in the Database Migration Service User Guide.
	IndividualAssessmentNames []*string `type:"list"`

	// Pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicableIndividualAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicableIndividualAssessmentsOutput) GoString() string {
	return s.String()
}

// SetIndividualAssessmentNames sets the IndividualAssessmentNames field's value.
func (s *DescribeApplicableIndividualAssessmentsOutput) SetIndividualAssessmentNames(v []*string) *DescribeApplicableIndividualAssessmentsOutput {
	s.IndividualAssessmentNames = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeApplicableIndividualAssessmentsOutput) SetMarker(v string) *DescribeApplicableIndividualAssessmentsOutput {
	s.Marker = &v
	return s
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the certificates described in the form of key-value pairs.
	// Valid values are certificate-arn and certificate-id.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 10
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificates associated with the replication
	// instance.
	Certificates []*Certificate `type:"list"`

	// The pagination token.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The filters applied to the connection.
	//
	// Valid filter names: endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeConnectionsInput) SetFilters(v []*Filter) *DescribeConnectionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsInput) SetMarker(v string) *DescribeConnectionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeConnectionsInput) SetMaxRecords(v int64) *DescribeConnectionsInput {
	s.MaxRecords = &v
	return s
}

type DescribeConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A description of the connections.
	Connections []*Connection `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeConnectionsOutput) SetConnections(v []*Connection) *DescribeConnectionsOutput {
	s.Connections = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsOutput) SetMarker(v string) *DescribeConnectionsOutput {
	s.Marker = &v
	return s
}

type DescribeConversionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) for the schema conversion project
	// to describe.
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConversionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConversionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConversionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConversionConfigurationInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeConversionConfigurationInput) SetMigrationProjectIdentifier(v string) *DescribeConversionConfigurationInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeConversionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration parameters for the schema conversion project.
	ConversionConfiguration *string `type:"string"`

	// The name or Amazon Resource Name (ARN) for the schema conversion project.
	MigrationProjectIdentifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConversionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConversionConfigurationOutput) GoString() string {
	return s.String()
}

// SetConversionConfiguration sets the ConversionConfiguration field's value.
func (s *DescribeConversionConfigurationOutput) SetConversionConfiguration(v string) *DescribeConversionConfigurationOutput {
	s.ConversionConfiguration = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeConversionConfigurationOutput) SetMigrationProjectIdentifier(v string) *DescribeConversionConfigurationOutput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeDataProvidersInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the data providers described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataProvidersInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeDataProvidersInput) SetFilters(v []*Filter) *DescribeDataProvidersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDataProvidersInput) SetMarker(v string) *DescribeDataProvidersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDataProvidersInput) SetMaxRecords(v int64) *DescribeDataProvidersInput {
	s.MaxRecords = &v
	return s
}

type DescribeDataProvidersOutput struct {
	_ struct{} `type:"structure"`

	// A description of data providers.
	DataProviders []*DataProvider `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataProvidersOutput) GoString() string {
	return s.String()
}

// SetDataProviders sets the DataProviders field's value.
func (s *DescribeDataProvidersOutput) SetDataProviders(v []*DataProvider) *DescribeDataProvidersOutput {
	s.DataProviders = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDataProvidersOutput) SetMarker(v string) *DescribeDataProvidersOutput {
	s.Marker = &v
	return s
}

type DescribeEndpointSettingsInput struct {
	_ struct{} `type:"structure"`

	// The database engine used for your source or target endpoint.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointSettingsInput"}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *DescribeEndpointSettingsInput) SetEngineName(v string) *DescribeEndpointSettingsInput {
	s.EngineName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointSettingsInput) SetMarker(v string) *DescribeEndpointSettingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointSettingsInput) SetMaxRecords(v int64) *DescribeEndpointSettingsInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Descriptions of the endpoint settings available for your source or target
	// database engine.
	EndpointSettings []*EndpointSetting `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointSettingsOutput) GoString() string {
	return s.String()
}

// SetEndpointSettings sets the EndpointSettings field's value.
func (s *DescribeEndpointSettingsOutput) SetEndpointSettings(v []*EndpointSetting) *DescribeEndpointSettingsOutput {
	s.EndpointSettings = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointSettingsOutput) SetMarker(v string) *DescribeEndpointSettingsOutput {
	s.Marker = &v
	return s
}

type DescribeEndpointTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the endpoint types.
	//
	// Valid filter names: engine-name | endpoint-type
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointTypesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointTypesInput) SetFilters(v []*Filter) *DescribeEndpointTypesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesInput) SetMarker(v string) *DescribeEndpointTypesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointTypesInput) SetMaxRecords(v int64) *DescribeEndpointTypesInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointTypesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The types of endpoints that are supported.
	SupportedEndpointTypes []*SupportedEndpointType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointTypesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesOutput) SetMarker(v string) *DescribeEndpointTypesOutput {
	s.Marker = &v
	return s
}

// SetSupportedEndpointTypes sets the SupportedEndpointTypes field's value.
func (s *DescribeEndpointTypesOutput) SetSupportedEndpointTypes(v []*SupportedEndpointType) *DescribeEndpointTypesOutput {
	s.SupportedEndpointTypes = v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the endpoints.
	//
	// Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointsInput) SetFilters(v []*Filter) *DescribeEndpointsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsInput) SetMarker(v string) *DescribeEndpointsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointsInput) SetMaxRecords(v int64) *DescribeEndpointsInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Endpoint description.
	Endpoints []*Endpoint `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsOutput) SetMarker(v string) *DescribeEndpointsOutput {
	s.Marker = &v
	return s
}

type DescribeEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineVersionsInput) SetMarker(v string) *DescribeEngineVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineVersionsInput) SetMaxRecords(v int64) *DescribeEngineVersionsInput {
	s.MaxRecords = &v
	return s
}

type DescribeEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Returned EngineVersion objects that describe the replication instance engine
	// versions used in the project.
	EngineVersions []*EngineVersion `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetEngineVersions sets the EngineVersions field's value.
func (s *DescribeEngineVersionsOutput) SetEngineVersions(v []*EngineVersion) *DescribeEngineVersionsOutput {
	s.EngineVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineVersionsOutput) SetMarker(v string) *DescribeEngineVersionsOutput {
	s.Marker = &v
	return s
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the event categories.
	Filters []*Filter `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories.
	EventCategoryGroupList []*EventCategoryGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoryGroupList sets the EventCategoryGroupList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoryGroupList(v []*EventCategoryGroup) *DescribeEventCategoriesOutput {
	s.EventCategoryGroupList = v
	return s
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to event subscriptions.
	//
	// Valid filter names: event-subscription-arn | event-subscription-id
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the DMS event subscription to be described.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSubscriptionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventSubscriptionsInput) SetFilters(v []*Filter) *DescribeEventSubscriptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The duration of the events to be listed.
	Duration *int64 `type:"integer"`

	// The end time for the events to be listed.
	EndTime *time.Time `type:"timestamp"`

	// A list of event categories for the source type that you've chosen.
	EventCategories []*string `type:"list"`

	// Filters applied to events. The only valid filter is replication-instance-id.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of an event source.
	SourceIdentifier *string `type:"string"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string" enum:"SourceType"`

	// The start time for the events to be listed.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// The events described.
	Events []*Event `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

type DescribeExtensionPackAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the extension pack associations described in the form
	// of key-value pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) for the migration project.
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExtensionPackAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExtensionPackAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExtensionPackAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExtensionPackAssociationsInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeExtensionPackAssociationsInput) SetFilters(v []*Filter) *DescribeExtensionPackAssociationsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeExtensionPackAssociationsInput) SetMarker(v string) *DescribeExtensionPackAssociationsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeExtensionPackAssociationsInput) SetMaxRecords(v int64) *DescribeExtensionPackAssociationsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeExtensionPackAssociationsInput) SetMigrationProjectIdentifier(v string) *DescribeExtensionPackAssociationsInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeExtensionPackAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of extension pack associations for the specified migration
	// project.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExtensionPackAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExtensionPackAssociationsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeExtensionPackAssociationsOutput) SetMarker(v string) *DescribeExtensionPackAssociationsOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeExtensionPackAssociationsOutput) SetRequests(v []*SchemaConversionRequest) *DescribeExtensionPackAssociationsOutput {
	s.Requests = v
	return s
}

type DescribeFleetAdvisorCollectorsInput struct {
	_ struct{} `type:"structure"`

	// If you specify any of the following filters, the output includes information
	// for only those collectors that meet the filter criteria:
	//
	//    * collector-referenced-id – The ID of the collector agent, for example
	//    d4610ac5-e323-4ad9-bc50-eaf7249dfe9d.
	//
	//    * collector-name – The name of the collector agent.
	//
	// An example is: describe-fleet-advisor-collectors --filter Name="collector-referenced-id",Values="d4610ac5-e323-4ad9-bc50-eaf7249dfe9d"
	Filters []*Filter `type:"list"`

	// Sets the maximum number of records returned in the response.
	MaxRecords *int64 `type:"integer"`

	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorCollectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorCollectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAdvisorCollectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAdvisorCollectorsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeFleetAdvisorCollectorsInput) SetFilters(v []*Filter) *DescribeFleetAdvisorCollectorsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeFleetAdvisorCollectorsInput) SetMaxRecords(v int64) *DescribeFleetAdvisorCollectorsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorCollectorsInput) SetNextToken(v string) *DescribeFleetAdvisorCollectorsInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorCollectorsOutput struct {
	_ struct{} `type:"structure"`

	// Provides descriptions of the Fleet Advisor collectors, including the collectors'
	// name and ID, and the latest inventory data.
	Collectors []*CollectorResponse `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorCollectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorCollectorsOutput) GoString() string {
	return s.String()
}

// SetCollectors sets the Collectors field's value.
func (s *DescribeFleetAdvisorCollectorsOutput) SetCollectors(v []*CollectorResponse) *DescribeFleetAdvisorCollectorsOutput {
	s.Collectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorCollectorsOutput) SetNextToken(v string) *DescribeFleetAdvisorCollectorsOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorDatabasesInput struct {
	_ struct{} `type:"structure"`

	// If you specify any of the following filters, the output includes information
	// for only those databases that meet the filter criteria:
	//
	//    * database-id – The ID of the database.
	//
	//    * database-name – The name of the database.
	//
	//    * database-engine – The name of the database engine.
	//
	//    * server-ip-address – The IP address of the database server.
	//
	//    * database-ip-address – The IP address of the database.
	//
	//    * collector-name – The name of the associated Fleet Advisor collector.
	//
	// An example is: describe-fleet-advisor-databases --filter Name="database-id",Values="45"
	Filters []*Filter `type:"list"`

	// Sets the maximum number of records returned in the response.
	MaxRecords *int64 `type:"integer"`

	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAdvisorDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAdvisorDatabasesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeFleetAdvisorDatabasesInput) SetFilters(v []*Filter) *DescribeFleetAdvisorDatabasesInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeFleetAdvisorDatabasesInput) SetMaxRecords(v int64) *DescribeFleetAdvisorDatabasesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorDatabasesInput) SetNextToken(v string) *DescribeFleetAdvisorDatabasesInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// Provides descriptions of the Fleet Advisor collector databases, including
	// the database's collector, ID, and name.
	Databases []*DatabaseResponse `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabases sets the Databases field's value.
func (s *DescribeFleetAdvisorDatabasesOutput) SetDatabases(v []*DatabaseResponse) *DescribeFleetAdvisorDatabasesOutput {
	s.Databases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorDatabasesOutput) SetNextToken(v string) *DescribeFleetAdvisorDatabasesOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorLsaAnalysisInput struct {
	_ struct{} `type:"structure"`

	// Sets the maximum number of records returned in the response.
	MaxRecords *int64 `type:"integer"`

	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorLsaAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorLsaAnalysisInput) GoString() string {
	return s.String()
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeFleetAdvisorLsaAnalysisInput) SetMaxRecords(v int64) *DescribeFleetAdvisorLsaAnalysisInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorLsaAnalysisInput) SetNextToken(v string) *DescribeFleetAdvisorLsaAnalysisInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorLsaAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// A list of FleetAdvisorLsaAnalysisResponse objects.
	Analysis []*FleetAdvisorLsaAnalysisResponse `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorLsaAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorLsaAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalysis sets the Analysis field's value.
func (s *DescribeFleetAdvisorLsaAnalysisOutput) SetAnalysis(v []*FleetAdvisorLsaAnalysisResponse) *DescribeFleetAdvisorLsaAnalysisOutput {
	s.Analysis = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorLsaAnalysisOutput) SetNextToken(v string) *DescribeFleetAdvisorLsaAnalysisOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorSchemaObjectSummaryInput struct {
	_ struct{} `type:"structure"`

	// If you specify any of the following filters, the output includes information
	// for only those schema objects that meet the filter criteria:
	//
	//    * schema-id – The ID of the schema, for example d4610ac5-e323-4ad9-bc50-eaf7249dfe9d.
	//
	// Example: describe-fleet-advisor-schema-object-summary --filter Name="schema-id",Values="50"
	Filters []*Filter `type:"list"`

	// Sets the maximum number of records returned in the response.
	MaxRecords *int64 `type:"integer"`

	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemaObjectSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemaObjectSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAdvisorSchemaObjectSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAdvisorSchemaObjectSummaryInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeFleetAdvisorSchemaObjectSummaryInput) SetFilters(v []*Filter) *DescribeFleetAdvisorSchemaObjectSummaryInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeFleetAdvisorSchemaObjectSummaryInput) SetMaxRecords(v int64) *DescribeFleetAdvisorSchemaObjectSummaryInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorSchemaObjectSummaryInput) SetNextToken(v string) *DescribeFleetAdvisorSchemaObjectSummaryInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorSchemaObjectSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A collection of FleetAdvisorSchemaObjectResponse objects.
	FleetAdvisorSchemaObjects []*FleetAdvisorSchemaObjectResponse `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemaObjectSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemaObjectSummaryOutput) GoString() string {
	return s.String()
}

// SetFleetAdvisorSchemaObjects sets the FleetAdvisorSchemaObjects field's value.
func (s *DescribeFleetAdvisorSchemaObjectSummaryOutput) SetFleetAdvisorSchemaObjects(v []*FleetAdvisorSchemaObjectResponse) *DescribeFleetAdvisorSchemaObjectSummaryOutput {
	s.FleetAdvisorSchemaObjects = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorSchemaObjectSummaryOutput) SetNextToken(v string) *DescribeFleetAdvisorSchemaObjectSummaryOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorSchemasInput struct {
	_ struct{} `type:"structure"`

	// If you specify any of the following filters, the output includes information
	// for only those schemas that meet the filter criteria:
	//
	//    * complexity – The schema's complexity, for example Simple.
	//
	//    * database-id – The ID of the schema's database.
	//
	//    * database-ip-address – The IP address of the schema's database.
	//
	//    * database-name – The name of the schema's database.
	//
	//    * database-engine – The name of the schema database's engine.
	//
	//    * original-schema-name – The name of the schema's database's main schema.
	//
	//    * schema-id – The ID of the schema, for example 15.
	//
	//    * schema-name – The name of the schema.
	//
	//    * server-ip-address – The IP address of the schema database's server.
	//
	// An example is: describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"
	Filters []*Filter `type:"list"`

	// Sets the maximum number of records returned in the response.
	MaxRecords *int64 `type:"integer"`

	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAdvisorSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAdvisorSchemasInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeFleetAdvisorSchemasInput) SetFilters(v []*Filter) *DescribeFleetAdvisorSchemasInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeFleetAdvisorSchemasInput) SetMaxRecords(v int64) *DescribeFleetAdvisorSchemasInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorSchemasInput) SetNextToken(v string) *DescribeFleetAdvisorSchemasInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAdvisorSchemasOutput struct {
	_ struct{} `type:"structure"`

	// A collection of SchemaResponse objects.
	FleetAdvisorSchemas []*SchemaResponse `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAdvisorSchemasOutput) GoString() string {
	return s.String()
}

// SetFleetAdvisorSchemas sets the FleetAdvisorSchemas field's value.
func (s *DescribeFleetAdvisorSchemasOutput) SetFleetAdvisorSchemas(v []*SchemaResponse) *DescribeFleetAdvisorSchemasOutput {
	s.FleetAdvisorSchemas = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAdvisorSchemasOutput) SetNextToken(v string) *DescribeFleetAdvisorSchemasOutput {
	s.NextToken = &v
	return s
}

type DescribeInstanceProfilesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the instance profiles described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceProfilesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInstanceProfilesInput) SetFilters(v []*Filter) *DescribeInstanceProfilesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeInstanceProfilesInput) SetMarker(v string) *DescribeInstanceProfilesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeInstanceProfilesInput) SetMaxRecords(v int64) *DescribeInstanceProfilesInput {
	s.MaxRecords = &v
	return s
}

type DescribeInstanceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A description of instance profiles.
	InstanceProfiles []*InstanceProfile `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceProfilesOutput) GoString() string {
	return s.String()
}

// SetInstanceProfiles sets the InstanceProfiles field's value.
func (s *DescribeInstanceProfilesOutput) SetInstanceProfiles(v []*InstanceProfile) *DescribeInstanceProfilesOutput {
	s.InstanceProfiles = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeInstanceProfilesOutput) SetMarker(v string) *DescribeInstanceProfilesOutput {
	s.Marker = &v
	return s
}

type DescribeMetadataModelAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the metadata model assessments described in the form of
	// key-value pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) of the migration project.
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelAssessmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetadataModelAssessmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetadataModelAssessmentsInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMetadataModelAssessmentsInput) SetFilters(v []*Filter) *DescribeMetadataModelAssessmentsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelAssessmentsInput) SetMarker(v string) *DescribeMetadataModelAssessmentsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMetadataModelAssessmentsInput) SetMaxRecords(v int64) *DescribeMetadataModelAssessmentsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeMetadataModelAssessmentsInput) SetMigrationProjectIdentifier(v string) *DescribeMetadataModelAssessmentsInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeMetadataModelAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model assessments for the specified migration
	// project.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelAssessmentsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelAssessmentsOutput) SetMarker(v string) *DescribeMetadataModelAssessmentsOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeMetadataModelAssessmentsOutput) SetRequests(v []*SchemaConversionRequest) *DescribeMetadataModelAssessmentsOutput {
	s.Requests = v
	return s
}

type DescribeMetadataModelConversionsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the metadata model conversions described in the form of
	// key-value pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelConversionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelConversionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetadataModelConversionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetadataModelConversionsInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMetadataModelConversionsInput) SetFilters(v []*Filter) *DescribeMetadataModelConversionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelConversionsInput) SetMarker(v string) *DescribeMetadataModelConversionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMetadataModelConversionsInput) SetMaxRecords(v int64) *DescribeMetadataModelConversionsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeMetadataModelConversionsInput) SetMigrationProjectIdentifier(v string) *DescribeMetadataModelConversionsInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeMetadataModelConversionsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model conversions.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelConversionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelConversionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelConversionsOutput) SetMarker(v string) *DescribeMetadataModelConversionsOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeMetadataModelConversionsOutput) SetRequests(v []*SchemaConversionRequest) *DescribeMetadataModelConversionsOutput {
	s.Requests = v
	return s
}

type DescribeMetadataModelExportsAsScriptInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the metadata model exports described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsAsScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsAsScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetadataModelExportsAsScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetadataModelExportsAsScriptInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMetadataModelExportsAsScriptInput) SetFilters(v []*Filter) *DescribeMetadataModelExportsAsScriptInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelExportsAsScriptInput) SetMarker(v string) *DescribeMetadataModelExportsAsScriptInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMetadataModelExportsAsScriptInput) SetMaxRecords(v int64) *DescribeMetadataModelExportsAsScriptInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeMetadataModelExportsAsScriptInput) SetMigrationProjectIdentifier(v string) *DescribeMetadataModelExportsAsScriptInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeMetadataModelExportsAsScriptOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model exports.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsAsScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsAsScriptOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelExportsAsScriptOutput) SetMarker(v string) *DescribeMetadataModelExportsAsScriptOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeMetadataModelExportsAsScriptOutput) SetRequests(v []*SchemaConversionRequest) *DescribeMetadataModelExportsAsScriptOutput {
	s.Requests = v
	return s
}

type DescribeMetadataModelExportsToTargetInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the metadata model exports described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsToTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsToTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetadataModelExportsToTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetadataModelExportsToTargetInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMetadataModelExportsToTargetInput) SetFilters(v []*Filter) *DescribeMetadataModelExportsToTargetInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelExportsToTargetInput) SetMarker(v string) *DescribeMetadataModelExportsToTargetInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMetadataModelExportsToTargetInput) SetMaxRecords(v int64) *DescribeMetadataModelExportsToTargetInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeMetadataModelExportsToTargetInput) SetMigrationProjectIdentifier(v string) *DescribeMetadataModelExportsToTargetInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeMetadataModelExportsToTargetOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model exports.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsToTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelExportsToTargetOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelExportsToTargetOutput) SetMarker(v string) *DescribeMetadataModelExportsToTargetOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeMetadataModelExportsToTargetOutput) SetRequests(v []*SchemaConversionRequest) *DescribeMetadataModelExportsToTargetOutput {
	s.Requests = v
	return s
}

type DescribeMetadataModelImportsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the metadata model imports described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model imports.
	MaxRecords *int64 `type:"integer"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetadataModelImportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetadataModelImportsInput"}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMetadataModelImportsInput) SetFilters(v []*Filter) *DescribeMetadataModelImportsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelImportsInput) SetMarker(v string) *DescribeMetadataModelImportsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMetadataModelImportsInput) SetMaxRecords(v int64) *DescribeMetadataModelImportsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *DescribeMetadataModelImportsInput) SetMigrationProjectIdentifier(v string) *DescribeMetadataModelImportsInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type DescribeMetadataModelImportsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A paginated list of metadata model imports.
	Requests []*SchemaConversionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelImportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetadataModelImportsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMetadataModelImportsOutput) SetMarker(v string) *DescribeMetadataModelImportsOutput {
	s.Marker = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *DescribeMetadataModelImportsOutput) SetRequests(v []*SchemaConversionRequest) *DescribeMetadataModelImportsOutput {
	s.Requests = v
	return s
}

type DescribeMigrationProjectsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the migration projects described in the form of key-value
	// pairs.
	Filters []*Filter `type:"list"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, DMS includes a pagination token
	// in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMigrationProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMigrationProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMigrationProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMigrationProjectsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMigrationProjectsInput) SetFilters(v []*Filter) *DescribeMigrationProjectsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMigrationProjectsInput) SetMarker(v string) *DescribeMigrationProjectsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeMigrationProjectsInput) SetMaxRecords(v int64) *DescribeMigrationProjectsInput {
	s.MaxRecords = &v
	return s
}

type DescribeMigrationProjectsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If Marker is returned by a previous response, there are more results available.
	// The value of Marker is a unique pagination token for each page. To retrieve
	// the next page, make the call again using the returned token and keeping all
	// other arguments unchanged.
	Marker *string `type:"string"`

	// A description of migration projects.
	MigrationProjects []*MigrationProject `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMigrationProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMigrationProjectsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMigrationProjectsOutput) SetMarker(v string) *DescribeMigrationProjectsOutput {
	s.Marker = &v
	return s
}

// SetMigrationProjects sets the MigrationProjects field's value.
func (s *DescribeMigrationProjectsOutput) SetMigrationProjects(v []*MigrationProject) *DescribeMigrationProjectsOutput {
	s.MigrationProjects = v
	return s
}

type DescribeOrderableReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrderableReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrderableReplicationInstancesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMarker(v string) *DescribeOrderableReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMaxRecords(v int64) *DescribeOrderableReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

type DescribeOrderableReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The order-able replication instances available.
	OrderableReplicationInstances []*OrderableReplicationInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrderableReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrderableReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetMarker(v string) *DescribeOrderableReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetOrderableReplicationInstances sets the OrderableReplicationInstances field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetOrderableReplicationInstances(v []*OrderableReplicationInstance) *DescribeOrderableReplicationInstancesOutput {
	s.OrderableReplicationInstances = v
	return s
}

type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePendingMaintenanceActionsInput) SetFilters(v []*Filter) *DescribePendingMaintenanceActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMarker(v string) *DescribePendingMaintenanceActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMaxRecords(v int64) *DescribePendingMaintenanceActionsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribePendingMaintenanceActionsInput) SetReplicationInstanceArn(v string) *DescribePendingMaintenanceActionsInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The pending maintenance action.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetMarker(v string) *DescribePendingMaintenanceActionsOutput {
	s.Marker = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetPendingMaintenanceActions(v []*ResourcePendingMaintenanceActions) *DescribePendingMaintenanceActionsOutput {
	s.PendingMaintenanceActions = v
	return s
}

type DescribeRecommendationLimitationsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the limitations described in the form of key-value pairs.
	Filters []*Filter `type:"list"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, Fleet Advisor includes a pagination
	// token in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationLimitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationLimitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecommendationLimitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecommendationLimitationsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeRecommendationLimitationsInput) SetFilters(v []*Filter) *DescribeRecommendationLimitationsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeRecommendationLimitationsInput) SetMaxRecords(v int64) *DescribeRecommendationLimitationsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationLimitationsInput) SetNextToken(v string) *DescribeRecommendationLimitationsInput {
	s.NextToken = &v
	return s
}

type DescribeRecommendationLimitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of limitations for recommendations of target Amazon Web Services
	// engines.
	Limitations []*Limitation `type:"list"`

	// The unique pagination token returned for you to pass to a subsequent request.
	// Fleet Advisor returns this token when the number of records in the response
	// is greater than the MaxRecords value. To retrieve the next page, make the
	// call again using the returned token and keeping all other arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationLimitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationLimitationsOutput) GoString() string {
	return s.String()
}

// SetLimitations sets the Limitations field's value.
func (s *DescribeRecommendationLimitationsOutput) SetLimitations(v []*Limitation) *DescribeRecommendationLimitationsOutput {
	s.Limitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationLimitationsOutput) SetNextToken(v string) *DescribeRecommendationLimitationsOutput {
	s.NextToken = &v
	return s
}

type DescribeRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the target engine recommendations described in the form
	// of key-value pairs.
	Filters []*Filter `type:"list"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, Fleet Advisor includes a pagination
	// token in the response so that you can retrieve the remaining results.
	MaxRecords *int64 `type:"integer"`

	// Specifies the unique pagination token that makes it possible to display the
	// next page of results. If this parameter is specified, the response includes
	// only records beyond the marker, up to the value specified by MaxRecords.
	//
	// If NextToken is returned by a previous response, there are more results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecommendationsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeRecommendationsInput) SetFilters(v []*Filter) *DescribeRecommendationsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeRecommendationsInput) SetMaxRecords(v int64) *DescribeRecommendationsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationsInput) SetNextToken(v string) *DescribeRecommendationsInput {
	s.NextToken = &v
	return s
}

type DescribeRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The unique pagination token returned for you to pass to a subsequent request.
	// Fleet Advisor returns this token when the number of records in the response
	// is greater than the MaxRecords value. To retrieve the next page, make the
	// call again using the returned token and keeping all other arguments unchanged.
	NextToken *string `type:"string"`

	// The list of recommendations of target engines that Fleet Advisor created
	// for the source database.
	Recommendations []*Recommendation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationsOutput) SetNextToken(v string) *DescribeRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *DescribeRecommendationsOutput) SetRecommendations(v []*Recommendation) *DescribeRecommendationsOutput {
	s.Recommendations = v
	return s
}

type DescribeRefreshSchemasStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRefreshSchemasStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRefreshSchemasStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRefreshSchemasStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRefreshSchemasStatusInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeRefreshSchemasStatusInput) SetEndpointArn(v string) *DescribeRefreshSchemasStatusInput {
	s.EndpointArn = &v
	return s
}

type DescribeRefreshSchemasStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRefreshSchemasStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRefreshSchemasStatusOutput) GoString() string {
	return s.String()
}

// SetRefreshSchemasStatus sets the RefreshSchemasStatus field's value.
func (s *DescribeRefreshSchemasStatusOutput) SetRefreshSchemasStatus(v *RefreshSchemasStatus) *DescribeRefreshSchemasStatusOutput {
	s.RefreshSchemasStatus = v
	return s
}

type DescribeReplicationConfigsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the replication configs.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationConfigsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationConfigsInput) SetFilters(v []*Filter) *DescribeReplicationConfigsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationConfigsInput) SetMarker(v string) *DescribeReplicationConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationConfigsInput) SetMaxRecords(v int64) *DescribeReplicationConfigsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationConfigsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// Returned configuration parameters that describe each provisioned DMS Serverless
	// replication.
	ReplicationConfigs []*ReplicationConfig `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationConfigsOutput) SetMarker(v string) *DescribeReplicationConfigsOutput {
	s.Marker = &v
	return s
}

// SetReplicationConfigs sets the ReplicationConfigs field's value.
func (s *DescribeReplicationConfigsOutput) SetReplicationConfigs(v []*ReplicationConfig) *DescribeReplicationConfigsOutput {
	s.ReplicationConfigs = v
	return s
}

type DescribeReplicationInstanceTaskLogsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstanceTaskLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstanceTaskLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstanceTaskLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstanceTaskLogsInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetMarker(v string) *DescribeReplicationInstanceTaskLogsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetMaxRecords(v int64) *DescribeReplicationInstanceTaskLogsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetReplicationInstanceArn(v string) *DescribeReplicationInstanceTaskLogsInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DescribeReplicationInstanceTaskLogsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// An array of replication task log metadata. Each member of the array contains
	// the replication task name, ARN, and task log size (in bytes).
	ReplicationInstanceTaskLogs []*ReplicationInstanceTaskLog `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstanceTaskLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstanceTaskLogsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetMarker(v string) *DescribeReplicationInstanceTaskLogsOutput {
	s.Marker = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetReplicationInstanceArn(v string) *DescribeReplicationInstanceTaskLogsOutput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceTaskLogs sets the ReplicationInstanceTaskLogs field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetReplicationInstanceTaskLogs(v []*ReplicationInstanceTaskLog) *DescribeReplicationInstanceTaskLogsOutput {
	s.ReplicationInstanceTaskLogs = v
	return s
}

type DescribeReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication instances.
	//
	// Valid filter names: replication-instance-arn | replication-instance-id |
	// replication-instance-class | engine-version
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationInstancesInput) SetFilters(v []*Filter) *DescribeReplicationInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesInput) SetMarker(v string) *DescribeReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationInstancesInput) SetMaxRecords(v int64) *DescribeReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication instances described.
	ReplicationInstances []*ReplicationInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesOutput) SetMarker(v string) *DescribeReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetReplicationInstances sets the ReplicationInstances field's value.
func (s *DescribeReplicationInstancesOutput) SetReplicationInstances(v []*ReplicationInstance) *DescribeReplicationInstancesOutput {
	s.ReplicationInstances = v
	return s
}

type DescribeReplicationSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication subnet groups.
	//
	// Valid filter names: replication-subnet-group-id
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetFilters(v []*Filter) *DescribeReplicationSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMarker(v string) *DescribeReplicationSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMaxRecords(v int64) *DescribeReplicationSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication subnet groups.
	ReplicationSubnetGroups []*ReplicationSubnetGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetMarker(v string) *DescribeReplicationSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// SetReplicationSubnetGroups sets the ReplicationSubnetGroups field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetReplicationSubnetGroups(v []*ReplicationSubnetGroup) *DescribeReplicationSubnetGroupsOutput {
	s.ReplicationSubnetGroups = v
	return s
}

type DescribeReplicationTableStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the replication table statistics.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// The replication config to describe.
	//
	// ReplicationConfigArn is a required field
	ReplicationConfigArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTableStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTableStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTableStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTableStatisticsInput"}
	if s.ReplicationConfigArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigArn"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTableStatisticsInput) SetFilters(v []*Filter) *DescribeReplicationTableStatisticsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTableStatisticsInput) SetMarker(v string) *DescribeReplicationTableStatisticsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTableStatisticsInput) SetMaxRecords(v int64) *DescribeReplicationTableStatisticsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationConfigArn sets the ReplicationConfigArn field's value.
func (s *DescribeReplicationTableStatisticsInput) SetReplicationConfigArn(v string) *DescribeReplicationTableStatisticsInput {
	s.ReplicationConfigArn = &v
	return s
}

type DescribeReplicationTableStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name of the replication config.
	ReplicationConfigArn *string `type:"string"`

	// Returns table statistics on the replication, including table name, rows inserted,
	// rows updated, and rows deleted.
	ReplicationTableStatistics []*TableStatistics `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTableStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTableStatisticsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTableStatisticsOutput) SetMarker(v string) *DescribeReplicationTableStatisticsOutput {
	s.Marker = &v
	return s
}

// SetReplicationConfigArn sets the ReplicationConfigArn field's value.
func (s *DescribeReplicationTableStatisticsOutput) SetReplicationConfigArn(v string) *DescribeReplicationTableStatisticsOutput {
	s.ReplicationConfigArn = &v
	return s
}

// SetReplicationTableStatistics sets the ReplicationTableStatistics field's value.
func (s *DescribeReplicationTableStatisticsOutput) SetReplicationTableStatistics(v []*TableStatistics) *DescribeReplicationTableStatisticsOutput {
	s.ReplicationTableStatistics = v
	return s
}

type DescribeReplicationTaskAssessmentResultsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the task.
	// When this input parameter is specified, the API returns only one result and
	// ignore the values of the MaxRecords and Marker parameters.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentResultsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMaxRecords(v int64) *DescribeReplicationTaskAssessmentResultsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetReplicationTaskArn(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.ReplicationTaskArn = &v
	return s
}

type DescribeReplicationTaskAssessmentResultsOutput struct {
	_ struct{} `type:"structure"`

	// - The Amazon S3 bucket where the task assessment report is located.
	BucketName *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The task assessment report.
	ReplicationTaskAssessmentResults []*ReplicationTaskAssessmentResult `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentResultsOutput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetBucketName(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.BucketName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskAssessmentResults sets the ReplicationTaskAssessmentResults field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetReplicationTaskAssessmentResults(v []*ReplicationTaskAssessmentResult) *DescribeReplicationTaskAssessmentResultsOutput {
	s.ReplicationTaskAssessmentResults = v
	return s
}

type DescribeReplicationTaskAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the premigration assessment runs described in the form
	// of key-value pairs.
	//
	// Valid filter names: replication-task-assessment-run-arn, replication-task-arn,
	// replication-instance-arn, status
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTaskAssessmentRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTaskAssessmentRunsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetFilters(v []*Filter) *DescribeReplicationTaskAssessmentRunsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetMarker(v string) *DescribeReplicationTaskAssessmentRunsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetMaxRecords(v int64) *DescribeReplicationTaskAssessmentRunsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationTaskAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`

	// One or more premigration assessment runs as specified by Filters.
	ReplicationTaskAssessmentRuns []*ReplicationTaskAssessmentRun `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskAssessmentRunsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentRunsOutput) SetMarker(v string) *DescribeReplicationTaskAssessmentRunsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskAssessmentRuns sets the ReplicationTaskAssessmentRuns field's value.
func (s *DescribeReplicationTaskAssessmentRunsOutput) SetReplicationTaskAssessmentRuns(v []*ReplicationTaskAssessmentRun) *DescribeReplicationTaskAssessmentRunsOutput {
	s.ReplicationTaskAssessmentRuns = v
	return s
}

type DescribeReplicationTaskIndividualAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the individual assessments described in the form of key-value
	// pairs.
	//
	// Valid filter names: replication-task-assessment-run-arn, replication-task-arn,
	// status
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskIndividualAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskIndividualAssessmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTaskIndividualAssessmentsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetFilters(v []*Filter) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetMarker(v string) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetMaxRecords(v int64) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationTaskIndividualAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`

	// One or more individual assessments as specified by Filters.
	ReplicationTaskIndividualAssessments []*ReplicationTaskIndividualAssessment `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskIndividualAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTaskIndividualAssessmentsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsOutput) SetMarker(v string) *DescribeReplicationTaskIndividualAssessmentsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskIndividualAssessments sets the ReplicationTaskIndividualAssessments field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsOutput) SetReplicationTaskIndividualAssessments(v []*ReplicationTaskIndividualAssessment) *DescribeReplicationTaskIndividualAssessmentsOutput {
	s.ReplicationTaskIndividualAssessments = v
	return s
}

type DescribeReplicationTasksInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication tasks.
	//
	// Valid filter names: replication-task-arn | replication-task-id | migration-type
	// | endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An option to set to avoid returning information about settings. Use this
	// to reduce overhead when setting information is too large. To use this option,
	// choose true; otherwise, choose false (the default).
	WithoutSettings *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTasksInput) SetFilters(v []*Filter) *DescribeReplicationTasksInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksInput) SetMarker(v string) *DescribeReplicationTasksInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTasksInput) SetMaxRecords(v int64) *DescribeReplicationTasksInput {
	s.MaxRecords = &v
	return s
}

// SetWithoutSettings sets the WithoutSettings field's value.
func (s *DescribeReplicationTasksInput) SetWithoutSettings(v bool) *DescribeReplicationTasksInput {
	s.WithoutSettings = &v
	return s
}

type DescribeReplicationTasksOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication tasks.
	ReplicationTasks []*ReplicationTask `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationTasksOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksOutput) SetMarker(v string) *DescribeReplicationTasksOutput {
	s.Marker = &v
	return s
}

// SetReplicationTasks sets the ReplicationTasks field's value.
func (s *DescribeReplicationTasksOutput) SetReplicationTasks(v []*ReplicationTask) *DescribeReplicationTasksOutput {
	s.ReplicationTasks = v
	return s
}

type DescribeReplicationsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the replications.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationsInput) SetFilters(v []*Filter) *DescribeReplicationsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationsInput) SetMarker(v string) *DescribeReplicationsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationsInput) SetMaxRecords(v int64) *DescribeReplicationsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication descriptions.
	Replications []*Replication `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationsOutput) SetMarker(v string) *DescribeReplicationsOutput {
	s.Marker = &v
	return s
}

// SetReplications sets the Replications field's value.
func (s *DescribeReplicationsOutput) SetReplications(v []*Replication) *DescribeReplicationsOutput {
	s.Replications = v
	return s
}

type DescribeSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeSchemasInput) SetEndpointArn(v string) *DescribeSchemasInput {
	s.EndpointArn = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasInput) SetMarker(v string) *DescribeSchemasInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSchemasInput) SetMaxRecords(v int64) *DescribeSchemasInput {
	s.MaxRecords = &v
	return s
}

type DescribeSchemasOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The described schema.
	Schemas []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemasOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasOutput) SetMarker(v string) *DescribeSchemasOutput {
	s.Marker = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *DescribeSchemasOutput) SetSchemas(v []*string) *DescribeSchemasOutput {
	s.Schemas = v
	return s
}

type DescribeTableStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to table statistics.
	//
	// Valid filter names: schema-name | table-name | table-state
	//
	// A combination of filters creates an AND condition where each record matches
	// all specified filters.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 500.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableStatisticsInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeTableStatisticsInput) SetFilters(v []*Filter) *DescribeTableStatisticsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsInput) SetMarker(v string) *DescribeTableStatisticsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTableStatisticsInput) SetMaxRecords(v int64) *DescribeTableStatisticsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsInput) SetReplicationTaskArn(v string) *DescribeTableStatisticsInput {
	s.ReplicationTaskArn = &v
	return s
}

type DescribeTableStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The table statistics.
	TableStatistics []*TableStatistics `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableStatisticsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsOutput) SetMarker(v string) *DescribeTableStatisticsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsOutput) SetReplicationTaskArn(v string) *DescribeTableStatisticsOutput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTableStatistics sets the TableStatistics field's value.
func (s *DescribeTableStatisticsOutput) SetTableStatistics(v []*TableStatistics) *DescribeTableStatisticsOutput {
	s.TableStatistics = v
	return s
}

// The settings in JSON format for the DMS Transfer type source endpoint.
type DmsTransferSettings struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket to use.
	BucketName *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service access IAM role. The role
	// must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DmsTransferSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DmsTransferSettings) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DmsTransferSettings) SetBucketName(v string) *DmsTransferSettings {
	s.BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *DmsTransferSettings) SetServiceAccessRoleArn(v string) *DmsTransferSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Provides information that defines a DocumentDB endpoint.
type DocDbSettings struct {
	_ struct{} `type:"structure"`

	// The database name on the DocumentDB source endpoint.
	DatabaseName *string `type:"string"`

	// Indicates the number of documents to preview to determine the document organization.
	// Use this setting when NestingLevel is set to "one".
	//
	// Must be a positive value greater than 0. Default value is 1000.
	DocsToInvestigate *int64 `type:"integer"`

	// Specifies the document ID. Use this setting when NestingLevel is set to "none".
	//
	// Default value is "false".
	ExtractDocId *bool `type:"boolean"`

	// The KMS key identifier that is used to encrypt the content on the replication
	// instance. If you don't specify a value for the KmsKeyId parameter, then DMS
	// uses your default encryption key. KMS creates the default encryption key
	// for your Amazon Web Services account. Your Amazon Web Services account has
	// a different default encryption key for each Amazon Web Services Region.
	KmsKeyId *string `type:"string"`

	// Specifies either document or table mode.
	//
	// Default value is "none". Specify "none" to use document mode. Specify "one"
	// to use table mode.
	NestingLevel *string `type:"string" enum:"NestingLevelValue"`

	// The password for the user account you use to access the DocumentDB source
	// endpoint.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DocDbSettings's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// The port value for the DocumentDB source endpoint.
	Port *int64 `type:"integer"`

	// If true, DMS replicates data to shard collections. DMS only uses this setting
	// if the target endpoint is a DocumentDB elastic cluster.
	//
	// When this setting is true, note the following:
	//
	//    * You must set TargetTablePrepMode to nothing.
	//
	//    * DMS automatically sets useUpdateLookup to false.
	ReplicateShardCollections *bool `type:"boolean"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the DocumentDB endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the DocumentDB endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// The name of the server on the DocumentDB source endpoint.
	ServerName *string `type:"string"`

	// If true, DMS retrieves the entire document from the DocumentDB source during
	// migration. This may cause a migration failure if the server response exceeds
	// bandwidth limits. To fetch only updates and deletes during migration, set
	// this parameter to false.
	UseUpdateLookUp *bool `type:"boolean"`

	// The user name you use to access the DocumentDB source endpoint.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocDbSettings) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DocDbSettings) SetDatabaseName(v string) *DocDbSettings {
	s.DatabaseName = &v
	return s
}

// SetDocsToInvestigate sets the DocsToInvestigate field's value.
func (s *DocDbSettings) SetDocsToInvestigate(v int64) *DocDbSettings {
	s.DocsToInvestigate = &v
	return s
}

// SetExtractDocId sets the ExtractDocId field's value.
func (s *DocDbSettings) SetExtractDocId(v bool) *DocDbSettings {
	s.ExtractDocId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DocDbSettings) SetKmsKeyId(v string) *DocDbSettings {
	s.KmsKeyId = &v
	return s
}

// SetNestingLevel sets the NestingLevel field's value.
func (s *DocDbSettings) SetNestingLevel(v string) *DocDbSettings {
	s.NestingLevel = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *DocDbSettings) SetPassword(v string) *DocDbSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DocDbSettings) SetPort(v int64) *DocDbSettings {
	s.Port = &v
	return s
}

// SetReplicateShardCollections sets the ReplicateShardCollections field's value.
func (s *DocDbSettings) SetReplicateShardCollections(v bool) *DocDbSettings {
	s.ReplicateShardCollections = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *DocDbSettings) SetSecretsManagerAccessRoleArn(v string) *DocDbSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *DocDbSettings) SetSecretsManagerSecretId(v string) *DocDbSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DocDbSettings) SetServerName(v string) *DocDbSettings {
	s.ServerName = &v
	return s
}

// SetUseUpdateLookUp sets the UseUpdateLookUp field's value.
func (s *DocDbSettings) SetUseUpdateLookUp(v bool) *DocDbSettings {
	s.UseUpdateLookUp = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DocDbSettings) SetUsername(v string) *DocDbSettings {
	s.Username = &v
	return s
}

// Provides the Amazon Resource Name (ARN) of the Identity and Access Management
// (IAM) role used to define an Amazon DynamoDB target endpoint.
type DynamoDbSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamoDbSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDbSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDbSettings"}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *DynamoDbSettings) SetServiceAccessRoleArn(v string) *DynamoDbSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Provides information that defines an OpenSearch endpoint.
type ElasticsearchSettings struct {
	_ struct{} `type:"structure"`

	// The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol
	// (http/https) is not specified.
	//
	// EndpointUri is a required field
	EndpointUri *string `type:"string" required:"true"`

	// The maximum number of seconds for which DMS retries failed API requests to
	// the OpenSearch cluster.
	ErrorRetryDuration *int64 `type:"integer"`

	// The maximum percentage of records that can fail to be written before a full
	// load operation stops.
	//
	// To avoid early failure, this counter is only effective after 1000 records
	// are transferred. OpenSearch also has the concept of error monitoring during
	// the last 10 minutes of an Observation Window. If transfer of all records
	// fail in the last 10 minutes, the full load operation stops.
	FullLoadErrorPercentage *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`

	// Set this option to true for DMS to migrate documentation using the documentation
	// type _doc. OpenSearch and an Elasticsearch cluster only support the _doc
	// documentation type in versions 7. x and later. The default value is false.
	UseNewMappingType *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchSettings"}
	if s.EndpointUri == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointUri"))
	}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointUri sets the EndpointUri field's value.
func (s *ElasticsearchSettings) SetEndpointUri(v string) *ElasticsearchSettings {
	s.EndpointUri = &v
	return s
}

// SetErrorRetryDuration sets the ErrorRetryDuration field's value.
func (s *ElasticsearchSettings) SetErrorRetryDuration(v int64) *ElasticsearchSettings {
	s.ErrorRetryDuration = &v
	return s
}

// SetFullLoadErrorPercentage sets the FullLoadErrorPercentage field's value.
func (s *ElasticsearchSettings) SetFullLoadErrorPercentage(v int64) *ElasticsearchSettings {
	s.FullLoadErrorPercentage = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *ElasticsearchSettings) SetServiceAccessRoleArn(v string) *ElasticsearchSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetUseNewMappingType sets the UseNewMappingType field's value.
func (s *ElasticsearchSettings) SetUseNewMappingType(v bool) *ElasticsearchSettings {
	s.UseNewMappingType = &v
	return s
}

// Describes an endpoint of a database instance in response to operations such
// as the following:
//
//   - CreateEndpoint
//
//   - DescribeEndpoint
//
//   - ModifyEndpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
	CertificateArn *string `type:"string"`

	// The name of the database at the endpoint.
	DatabaseName *string `type:"string"`

	// The settings for the DMS Transfer type source. For more information, see
	// the DmsTransferSettings structure.
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Provides information that defines a DocumentDB endpoint.
	DocDbSettings *DocDbSettings `type:"structure"`

	// The settings for the DynamoDB target endpoint. For more information, see
	// the DynamoDBSettings structure.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The settings for the OpenSearch source endpoint. For more information, see
	// the ElasticsearchSettings structure.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint. Valid values are source and target.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The expanded name for the engine name. For example, if the EngineName parameter
	// is "aurora", this value would be "Amazon Aurora MySQL".
	EngineDisplayName *string `type:"string"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "db2-zos", "azuredb", "sybase", "dynamodb", "mongodb",
	// "kinesis", "kafka", "elasticsearch", "documentdb", "sqlserver", "neptune",
	// and "babelfish".
	EngineName *string `type:"string"`

	// Value returned by a call to CreateEndpoint that can be used for cross-account
	// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint
	// with a cross-account.
	ExternalId *string `type:"string"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional connection attributes used to connect to the endpoint.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source GCP MySQL endpoint.
	GcpMySQLSettings *GcpMySQLSettings `type:"structure"`

	// The settings for the IBM Db2 LUW source endpoint. For more information, see
	// the IBMDb2Settings structure.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// The settings for the Apache Kafka target endpoint. For more information,
	// see the KafkaSettings structure.
	KafkaSettings *KafkaSettings `type:"structure"`

	// The settings for the Amazon Kinesis target endpoint. For more information,
	// see the KinesisSettings structure.
	KinesisSettings *KinesisSettings `type:"structure"`

	// An KMS key identifier that is used to encrypt the connection parameters for
	// the endpoint.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyId *string `type:"string"`

	// The settings for the Microsoft SQL Server source and target endpoint. For
	// more information, see the MicrosoftSQLServerSettings structure.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// The settings for the MongoDB source endpoint. For more information, see the
	// MongoDbSettings structure.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The settings for the MySQL source and target endpoint. For more information,
	// see the MySQLSettings structure.
	MySQLSettings *MySQLSettings `type:"structure"`

	// The settings for the Amazon Neptune target endpoint. For more information,
	// see the NeptuneSettings structure.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// The settings for the Oracle source and target endpoint. For more information,
	// see the OracleSettings structure.
	OracleSettings *OracleSettings `type:"structure"`

	// The port value used to access the endpoint.
	Port *int64 `type:"integer"`

	// The settings for the PostgreSQL source and target endpoint. For more information,
	// see the PostgreSQLSettings structure.
	PostgreSQLSettings *PostgreSQLSettings `type:"structure"`

	// The settings for the Redis target endpoint. For more information, see the
	// RedisSettings structure.
	RedisSettings *RedisSettings `type:"structure"`

	// Settings for the Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// The settings for the S3 target endpoint. For more information, see the S3Settings
	// structure.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server at the endpoint.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The SSL mode used to connect to the endpoint. The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The status of the endpoint.
	Status *string `type:"string"`

	// The settings for the SAP ASE source and target endpoint. For more information,
	// see the SybaseSettings structure.
	SybaseSettings *SybaseSettings `type:"structure"`

	// The settings for the Amazon Timestream target endpoint. For more information,
	// see the TimestreamSettings structure.
	TimestreamSettings *TimestreamSettings `type:"structure"`

	// The user name used to connect to the endpoint.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Endpoint) SetCertificateArn(v string) *Endpoint {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Endpoint) SetDatabaseName(v string) *Endpoint {
	s.DatabaseName = &v
	return s
}

// SetDmsTransferSettings sets the DmsTransferSettings field's value.
func (s *Endpoint) SetDmsTransferSettings(v *DmsTransferSettings) *Endpoint {
	s.DmsTransferSettings = v
	return s
}

// SetDocDbSettings sets the DocDbSettings field's value.
func (s *Endpoint) SetDocDbSettings(v *DocDbSettings) *Endpoint {
	s.DocDbSettings = v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *Endpoint) SetDynamoDbSettings(v *DynamoDbSettings) *Endpoint {
	s.DynamoDbSettings = v
	return s
}

// SetElasticsearchSettings sets the ElasticsearchSettings field's value.
func (s *Endpoint) SetElasticsearchSettings(v *ElasticsearchSettings) *Endpoint {
	s.ElasticsearchSettings = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Endpoint) SetEndpointIdentifier(v string) *Endpoint {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *Endpoint) SetEndpointType(v string) *Endpoint {
	s.EndpointType = &v
	return s
}

// SetEngineDisplayName sets the EngineDisplayName field's value.
func (s *Endpoint) SetEngineDisplayName(v string) *Endpoint {
	s.EngineDisplayName = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *Endpoint) SetEngineName(v string) *Endpoint {
	s.EngineName = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *Endpoint) SetExternalId(v string) *Endpoint {
	s.ExternalId = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *Endpoint) SetExternalTableDefinition(v string) *Endpoint {
	s.ExternalTableDefinition = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *Endpoint) SetExtraConnectionAttributes(v string) *Endpoint {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetGcpMySQLSettings sets the GcpMySQLSettings field's value.
func (s *Endpoint) SetGcpMySQLSettings(v *GcpMySQLSettings) *Endpoint {
	s.GcpMySQLSettings = v
	return s
}

// SetIBMDb2Settings sets the IBMDb2Settings field's value.
func (s *Endpoint) SetIBMDb2Settings(v *IBMDb2Settings) *Endpoint {
	s.IBMDb2Settings = v
	return s
}

// SetKafkaSettings sets the KafkaSettings field's value.
func (s *Endpoint) SetKafkaSettings(v *KafkaSettings) *Endpoint {
	s.KafkaSettings = v
	return s
}

// SetKinesisSettings sets the KinesisSettings field's value.
func (s *Endpoint) SetKinesisSettings(v *KinesisSettings) *Endpoint {
	s.KinesisSettings = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Endpoint) SetKmsKeyId(v string) *Endpoint {
	s.KmsKeyId = &v
	return s
}

// SetMicrosoftSQLServerSettings sets the MicrosoftSQLServerSettings field's value.
func (s *Endpoint) SetMicrosoftSQLServerSettings(v *MicrosoftSQLServerSettings) *Endpoint {
	s.MicrosoftSQLServerSettings = v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *Endpoint) SetMongoDbSettings(v *MongoDbSettings) *Endpoint {
	s.MongoDbSettings = v
	return s
}

// SetMySQLSettings sets the MySQLSettings field's value.
func (s *Endpoint) SetMySQLSettings(v *MySQLSettings) *Endpoint {
	s.MySQLSettings = v
	return s
}

// SetNeptuneSettings sets the NeptuneSettings field's value.
func (s *Endpoint) SetNeptuneSettings(v *NeptuneSettings) *Endpoint {
	s.NeptuneSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *Endpoint) SetOracleSettings(v *OracleSettings) *Endpoint {
	s.OracleSettings = v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// SetPostgreSQLSettings sets the PostgreSQLSettings field's value.
func (s *Endpoint) SetPostgreSQLSettings(v *PostgreSQLSettings) *Endpoint {
	s.PostgreSQLSettings = v
	return s
}

// SetRedisSettings sets the RedisSettings field's value.
func (s *Endpoint) SetRedisSettings(v *RedisSettings) *Endpoint {
	s.RedisSettings = v
	return s
}

// SetRedshiftSettings sets the RedshiftSettings field's value.
func (s *Endpoint) SetRedshiftSettings(v *RedshiftSettings) *Endpoint {
	s.RedshiftSettings = v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *Endpoint) SetS3Settings(v *S3Settings) *Endpoint {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *Endpoint) SetServerName(v string) *Endpoint {
	s.ServerName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *Endpoint) SetServiceAccessRoleArn(v string) *Endpoint {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *Endpoint) SetSslMode(v string) *Endpoint {
	s.SslMode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Endpoint) SetStatus(v string) *Endpoint {
	s.Status = &v
	return s
}

// SetSybaseSettings sets the SybaseSettings field's value.
func (s *Endpoint) SetSybaseSettings(v *SybaseSettings) *Endpoint {
	s.SybaseSettings = v
	return s
}

// SetTimestreamSettings sets the TimestreamSettings field's value.
func (s *Endpoint) SetTimestreamSettings(v *TimestreamSettings) *Endpoint {
	s.TimestreamSettings = v
	return s
}

// SetUsername sets the Username field's value.
func (s *Endpoint) SetUsername(v string) *Endpoint {
	s.Username = &v
	return s
}

// Endpoint settings.
type EndpointSetting struct {
	_ struct{} `type:"structure"`

	// The relevance or validity of an endpoint setting for an engine name and its
	// endpoint type.
	Applicability *string `type:"string"`

	// The default value of the endpoint setting if no value is specified using
	// CreateEndpoint or ModifyEndpoint.
	DefaultValue *string `type:"string"`

	// Enumerated values to use for this endpoint.
	EnumValues []*string `type:"list"`

	// The maximum value of an endpoint setting that is of type int.
	IntValueMax *int64 `type:"integer"`

	// The minimum value of an endpoint setting that is of type int.
	IntValueMin *int64 `type:"integer"`

	// The name that you want to give the endpoint settings.
	Name *string `type:"string"`

	// A value that marks this endpoint setting as sensitive.
	Sensitive *bool `type:"boolean"`

	// The type of endpoint. Valid values are source and target.
	Type *string `type:"string" enum:"EndpointSettingTypeValue"`

	// The unit of measure for this endpoint setting.
	Units *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointSetting) GoString() string {
	return s.String()
}

// SetApplicability sets the Applicability field's value.
func (s *EndpointSetting) SetApplicability(v string) *EndpointSetting {
	s.Applicability = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *EndpointSetting) SetDefaultValue(v string) *EndpointSetting {
	s.DefaultValue = &v
	return s
}

// SetEnumValues sets the EnumValues field's value.
func (s *EndpointSetting) SetEnumValues(v []*string) *EndpointSetting {
	s.EnumValues = v
	return s
}

// SetIntValueMax sets the IntValueMax field's value.
func (s *EndpointSetting) SetIntValueMax(v int64) *EndpointSetting {
	s.IntValueMax = &v
	return s
}

// SetIntValueMin sets the IntValueMin field's value.
func (s *EndpointSetting) SetIntValueMin(v int64) *EndpointSetting {
	s.IntValueMin = &v
	return s
}

// SetName sets the Name field's value.
func (s *EndpointSetting) SetName(v string) *EndpointSetting {
	s.Name = &v
	return s
}

// SetSensitive sets the Sensitive field's value.
func (s *EndpointSetting) SetSensitive(v bool) *EndpointSetting {
	s.Sensitive = &v
	return s
}

// SetType sets the Type field's value.
func (s *EndpointSetting) SetType(v string) *EndpointSetting {
	s.Type = &v
	return s
}

// SetUnits sets the Units field's value.
func (s *EndpointSetting) SetUnits(v string) *EndpointSetting {
	s.Units = &v
	return s
}

// Provides information about a replication instance version.
type EngineVersion struct {
	_ struct{} `type:"structure"`

	// The date when the replication instance will be automatically upgraded. This
	// setting only applies if the auto-minor-version setting is enabled.
	AutoUpgradeDate *time.Time `type:"timestamp"`

	// The list of valid replication instance versions that you can upgrade to.
	AvailableUpgrades []*string `type:"list"`

	// The date when the replication instance version will be deprecated and can
	// no longer be requested.
	DeprecationDate *time.Time `type:"timestamp"`

	// The date when the replication instance will have a version upgrade forced.
	ForceUpgradeDate *time.Time `type:"timestamp"`

	// The date when the replication instance version became publicly available.
	LaunchDate *time.Time `type:"timestamp"`

	// The lifecycle status of the replication instance version. Valid values are
	// DEPRECATED, DEFAULT_VERSION, and ACTIVE.
	Lifecycle *string `type:"string"`

	// The release status of the replication instance version.
	ReleaseStatus *string `type:"string" enum:"ReleaseStatusValues"`

	// The version number of the replication instance.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersion) GoString() string {
	return s.String()
}

// SetAutoUpgradeDate sets the AutoUpgradeDate field's value.
func (s *EngineVersion) SetAutoUpgradeDate(v time.Time) *EngineVersion {
	s.AutoUpgradeDate = &v
	return s
}

// SetAvailableUpgrades sets the AvailableUpgrades field's value.
func (s *EngineVersion) SetAvailableUpgrades(v []*string) *EngineVersion {
	s.AvailableUpgrades = v
	return s
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *EngineVersion) SetDeprecationDate(v time.Time) *EngineVersion {
	s.DeprecationDate = &v
	return s
}

// SetForceUpgradeDate sets the ForceUpgradeDate field's value.
func (s *EngineVersion) SetForceUpgradeDate(v time.Time) *EngineVersion {
	s.ForceUpgradeDate = &v
	return s
}

// SetLaunchDate sets the LaunchDate field's value.
func (s *EngineVersion) SetLaunchDate(v time.Time) *EngineVersion {
	s.LaunchDate = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *EngineVersion) SetLifecycle(v string) *EngineVersion {
	s.Lifecycle = &v
	return s
}

// SetReleaseStatus sets the ReleaseStatus field's value.
func (s *EngineVersion) SetReleaseStatus(v string) *EngineVersion {
	s.ReleaseStatus = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EngineVersion) SetVersion(v string) *EngineVersion {
	s.Version = &v
	return s
}

// Provides error information about a project.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// Error information about a project.
	DefaultErrorDetails *DefaultErrorDetails `locationName:"defaultErrorDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetDefaultErrorDetails sets the DefaultErrorDetails field's value.
func (s *ErrorDetails) SetDefaultErrorDetails(v *DefaultErrorDetails) *ErrorDetails {
	s.DefaultErrorDetails = v
	return s
}

// Describes an identifiable significant activity that affects a replication
// instance or task. This object can provide the message, the available event
// categories, the date and source of the event, and the DMS resource type.
type Event struct {
	_ struct{} `type:"structure"`

	// The date of the event.
	Date *time.Time `type:"timestamp"`

	// The event categories available for the specified source type.
	EventCategories []*string `type:"list"`

	// The event message.
	Message *string `type:"string"`

	// The identifier of an event source.
	SourceIdentifier *string `type:"string"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | endpoint | replication-task
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Lists categories of events subscribed to, and generated by, the applicable
// DMS resource type. This data type appears in response to the DescribeEventCategories
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_EventCategoryGroup.html)
// action.
type EventCategoryGroup struct {
	_ struct{} `type:"structure"`

	// A list of event categories from a source type that you've chosen.
	EventCategories []*string `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventCategoryGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventCategoryGroup) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoryGroup) SetEventCategories(v []*string) *EventCategoryGroup {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoryGroup) SetSourceType(v string) *EventCategoryGroup {
	s.SourceType = &v
	return s
}

// Describes an event notification subscription created by the CreateEventSubscription
// operation.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The DMS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The Amazon Web Services customer account associated with the DMS event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// Boolean value that indicates if the event subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A lists of event categories.
	EventCategoriesList []*string `type:"list"`

	// The topic ARN of the DMS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source Ids for the event subscription.
	SourceIdsList []*string `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`

	// The status of the DMS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that DMS no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic
	// was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the DMS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v string) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

type ExportMetadataModelAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The file format of the assessment file.
	AssessmentReportTypes []*string `min:"1" type:"list" enum:"AssessmentReportType"`

	// The name of the assessment file to create in your Amazon S3 bucket.
	FileName *string `type:"string"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`

	// A value that specifies the database objects to assess.
	//
	// SelectionRules is a required field
	SelectionRules *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportMetadataModelAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportMetadataModelAssessmentInput"}
	if s.AssessmentReportTypes != nil && len(s.AssessmentReportTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentReportTypes", 1))
	}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}
	if s.SelectionRules == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentReportTypes sets the AssessmentReportTypes field's value.
func (s *ExportMetadataModelAssessmentInput) SetAssessmentReportTypes(v []*string) *ExportMetadataModelAssessmentInput {
	s.AssessmentReportTypes = v
	return s
}

// SetFileName sets the FileName field's value.
func (s *ExportMetadataModelAssessmentInput) SetFileName(v string) *ExportMetadataModelAssessmentInput {
	s.FileName = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *ExportMetadataModelAssessmentInput) SetMigrationProjectIdentifier(v string) *ExportMetadataModelAssessmentInput {
	s.MigrationProjectIdentifier = &v
	return s
}

// SetSelectionRules sets the SelectionRules field's value.
func (s *ExportMetadataModelAssessmentInput) SetSelectionRules(v string) *ExportMetadataModelAssessmentInput {
	s.SelectionRules = &v
	return s
}

type ExportMetadataModelAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 details for an assessment exported in CSV format.
	CsvReport *ExportMetadataModelAssessmentResultEntry `type:"structure"`

	// The Amazon S3 details for an assessment exported in PDF format.
	PdfReport *ExportMetadataModelAssessmentResultEntry `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentOutput) GoString() string {
	return s.String()
}

// SetCsvReport sets the CsvReport field's value.
func (s *ExportMetadataModelAssessmentOutput) SetCsvReport(v *ExportMetadataModelAssessmentResultEntry) *ExportMetadataModelAssessmentOutput {
	s.CsvReport = v
	return s
}

// SetPdfReport sets the PdfReport field's value.
func (s *ExportMetadataModelAssessmentOutput) SetPdfReport(v *ExportMetadataModelAssessmentResultEntry) *ExportMetadataModelAssessmentOutput {
	s.PdfReport = v
	return s
}

// Provides information about an exported metadata model assessment.
type ExportMetadataModelAssessmentResultEntry struct {
	_ struct{} `type:"structure"`

	// The URL for the object containing the exported metadata model assessment.
	ObjectURL *string `type:"string"`

	// The object key for the object containing the exported metadata model assessment.
	S3ObjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportMetadataModelAssessmentResultEntry) GoString() string {
	return s.String()
}

// SetObjectURL sets the ObjectURL field's value.
func (s *ExportMetadataModelAssessmentResultEntry) SetObjectURL(v string) *ExportMetadataModelAssessmentResultEntry {
	s.ObjectURL = &v
	return s
}

// SetS3ObjectKey sets the S3ObjectKey field's value.
func (s *ExportMetadataModelAssessmentResultEntry) SetS3ObjectKey(v string) *ExportMetadataModelAssessmentResultEntry {
	s.S3ObjectKey = &v
	return s
}

// Provides information about a metadata model assessment exported to SQL.
type ExportSqlDetails struct {
	_ struct{} `type:"structure"`

	// The URL for the object containing the exported metadata model assessment.
	ObjectURL *string `type:"string"`

	// The Amazon S3 object key for the object containing the exported metadata
	// model assessment.
	S3ObjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSqlDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSqlDetails) GoString() string {
	return s.String()
}

// SetObjectURL sets the ObjectURL field's value.
func (s *ExportSqlDetails) SetObjectURL(v string) *ExportSqlDetails {
	s.ObjectURL = &v
	return s
}

// SetS3ObjectKey sets the S3ObjectKey field's value.
func (s *ExportSqlDetails) SetS3ObjectKey(v string) *ExportSqlDetails {
	s.S3ObjectKey = &v
	return s
}

// Identifies the name and value of a filter object. This filter is used to
// limit the number and type of DMS objects that are returned for a particular
// Describe* call or similar operation. Filters are used as an optional parameter
// for certain API operations.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter as specified for a Describe* or similar operation.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filter value, which can specify one or more values used to narrow the
	// returned results.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Describes a large-scale assessment (LSA) analysis run by a Fleet Advisor
// collector.
type FleetAdvisorLsaAnalysisResponse struct {
	_ struct{} `type:"structure"`

	// The ID of an LSA analysis run by a Fleet Advisor collector.
	LsaAnalysisId *string `type:"string"`

	// The status of an LSA analysis run by a Fleet Advisor collector.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAdvisorLsaAnalysisResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAdvisorLsaAnalysisResponse) GoString() string {
	return s.String()
}

// SetLsaAnalysisId sets the LsaAnalysisId field's value.
func (s *FleetAdvisorLsaAnalysisResponse) SetLsaAnalysisId(v string) *FleetAdvisorLsaAnalysisResponse {
	s.LsaAnalysisId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FleetAdvisorLsaAnalysisResponse) SetStatus(v string) *FleetAdvisorLsaAnalysisResponse {
	s.Status = &v
	return s
}

// Describes a schema object in a Fleet Advisor collector inventory.
type FleetAdvisorSchemaObjectResponse struct {
	_ struct{} `type:"structure"`

	// The number of lines of code in a schema object in a Fleet Advisor collector
	// inventory.
	CodeLineCount *int64 `type:"long"`

	// The size level of the code in a schema object in a Fleet Advisor collector
	// inventory.
	CodeSize *int64 `type:"long"`

	// The number of objects in a schema object in a Fleet Advisor collector inventory.
	NumberOfObjects *int64 `type:"long"`

	// The type of the schema object, as reported by the database engine. Examples
	// include the following:
	//
	//    * function
	//
	//    * trigger
	//
	//    * SYSTEM_TABLE
	//
	//    * QUEUE
	ObjectType *string `type:"string"`

	// The ID of a schema object in a Fleet Advisor collector inventory.
	SchemaId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAdvisorSchemaObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAdvisorSchemaObjectResponse) GoString() string {
	return s.String()
}

// SetCodeLineCount sets the CodeLineCount field's value.
func (s *FleetAdvisorSchemaObjectResponse) SetCodeLineCount(v int64) *FleetAdvisorSchemaObjectResponse {
	s.CodeLineCount = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *FleetAdvisorSchemaObjectResponse) SetCodeSize(v int64) *FleetAdvisorSchemaObjectResponse {
	s.CodeSize = &v
	return s
}

// SetNumberOfObjects sets the NumberOfObjects field's value.
func (s *FleetAdvisorSchemaObjectResponse) SetNumberOfObjects(v int64) *FleetAdvisorSchemaObjectResponse {
	s.NumberOfObjects = &v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *FleetAdvisorSchemaObjectResponse) SetObjectType(v string) *FleetAdvisorSchemaObjectResponse {
	s.ObjectType = &v
	return s
}

// SetSchemaId sets the SchemaId field's value.
func (s *FleetAdvisorSchemaObjectResponse) SetSchemaId(v string) *FleetAdvisorSchemaObjectResponse {
	s.SchemaId = &v
	return s
}

// Settings in JSON format for the source GCP MySQL endpoint.
type GcpMySQLSettings struct {
	_ struct{} `type:"structure"`

	// Specifies a script to run immediately after DMS connects to the endpoint.
	// The migration task continues running regardless if the SQL statement succeeds
	// or fails.
	//
	// For this parameter, provide the code of the script itself, not the name of
	// a file containing the script.
	AfterConnectScript *string `type:"string"`

	// Cleans and recreates table metadata information on the replication instance
	// when a mismatch occurs. For example, in a situation where running an alter
	// DDL on the table could result in different information about the table cached
	// in the replication instance.
	CleanSourceMetadataOnMismatch *bool `type:"boolean"`

	// Database name for the endpoint. For a MySQL source or target endpoint, don't
	// explicitly specify the database using the DatabaseName request parameter
	// on either the CreateEndpoint or ModifyEndpoint API call. Specifying DatabaseName
	// when you create or modify a MySQL endpoint replicates all the task tables
	// to this single database. For MySQL endpoints, you specify the database only
	// when you specify the schema in the table-mapping rules of the DMS task.
	DatabaseName *string `type:"string"`

	// Specifies how often to check the binary log for new changes/events when the
	// database is idle. The default is five seconds.
	//
	// Example: eventsPollInterval=5;
	//
	// In the example, DMS checks for changes in the binary logs every five seconds.
	EventsPollInterval *int64 `type:"integer"`

	// Specifies the maximum size (in KB) of any .csv file used to transfer data
	// to a MySQL-compatible database.
	//
	// Example: maxFileSize=512
	MaxFileSize *int64 `type:"integer"`

	// Improves performance when loading data into the MySQL-compatible target database.
	// Specifies how many threads to use to load the data into the MySQL-compatible
	// target database. Setting a large number of threads can have an adverse effect
	// on database performance, because a separate connection is required for each
	// thread. The default is one.
	//
	// Example: parallelLoadThreads=1
	ParallelLoadThreads *int64 `type:"integer"`

	// Endpoint connection password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GcpMySQLSettings's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the MySQL endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the MySQL endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// The MySQL host name.
	ServerName *string `type:"string"`

	// Specifies the time zone for the source MySQL database.
	//
	// Example: serverTimezone=US/Pacific;
	//
	// Note: Do not enclose time zones in single quotes.
	ServerTimezone *string `type:"string"`

	// Specifies where to migrate source tables on the target, either to a single
	// database or multiple databases.
	//
	// Example: targetDbType=MULTIPLE_DATABASES
	TargetDbType *string `type:"string" enum:"TargetDbType"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GcpMySQLSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GcpMySQLSettings) GoString() string {
	return s.String()
}

// SetAfterConnectScript sets the AfterConnectScript field's value.
func (s *GcpMySQLSettings) SetAfterConnectScript(v string) *GcpMySQLSettings {
	s.AfterConnectScript = &v
	return s
}

// SetCleanSourceMetadataOnMismatch sets the CleanSourceMetadataOnMismatch field's value.
func (s *GcpMySQLSettings) SetCleanSourceMetadataOnMismatch(v bool) *GcpMySQLSettings {
	s.CleanSourceMetadataOnMismatch = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GcpMySQLSettings) SetDatabaseName(v string) *GcpMySQLSettings {
	s.DatabaseName = &v
	return s
}

// SetEventsPollInterval sets the EventsPollInterval field's value.
func (s *GcpMySQLSettings) SetEventsPollInterval(v int64) *GcpMySQLSettings {
	s.EventsPollInterval = &v
	return s
}

// SetMaxFileSize sets the MaxFileSize field's value.
func (s *GcpMySQLSettings) SetMaxFileSize(v int64) *GcpMySQLSettings {
	s.MaxFileSize = &v
	return s
}

// SetParallelLoadThreads sets the ParallelLoadThreads field's value.
func (s *GcpMySQLSettings) SetParallelLoadThreads(v int64) *GcpMySQLSettings {
	s.ParallelLoadThreads = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *GcpMySQLSettings) SetPassword(v string) *GcpMySQLSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GcpMySQLSettings) SetPort(v int64) *GcpMySQLSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *GcpMySQLSettings) SetSecretsManagerAccessRoleArn(v string) *GcpMySQLSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *GcpMySQLSettings) SetSecretsManagerSecretId(v string) *GcpMySQLSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *GcpMySQLSettings) SetServerName(v string) *GcpMySQLSettings {
	s.ServerName = &v
	return s
}

// SetServerTimezone sets the ServerTimezone field's value.
func (s *GcpMySQLSettings) SetServerTimezone(v string) *GcpMySQLSettings {
	s.ServerTimezone = &v
	return s
}

// SetTargetDbType sets the TargetDbType field's value.
func (s *GcpMySQLSettings) SetTargetDbType(v string) *GcpMySQLSettings {
	s.TargetDbType = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *GcpMySQLSettings) SetUsername(v string) *GcpMySQLSettings {
	s.Username = &v
	return s
}

// Provides information that defines an IBM Db2 LUW endpoint.
type IBMDb2Settings struct {
	_ struct{} `type:"structure"`

	// For ongoing replication (CDC), use CurrentLSN to specify a log sequence number
	// (LSN) where you want the replication to start.
	CurrentLsn *string `type:"string"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// Maximum number of bytes per read, as a NUMBER value. The default is 64 KB.
	MaxKBytesPerRead *int64 `type:"integer"`

	// Endpoint connection password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IBMDb2Settings's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port. The default value is 50000.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the Db2 LUW endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the Db2 LUW endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Enables ongoing replication (CDC) as a BOOLEAN value. The default is true.
	SetDataCaptureChanges *bool `type:"boolean"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IBMDb2Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IBMDb2Settings) GoString() string {
	return s.String()
}

// SetCurrentLsn sets the CurrentLsn field's value.
func (s *IBMDb2Settings) SetCurrentLsn(v string) *IBMDb2Settings {
	s.CurrentLsn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *IBMDb2Settings) SetDatabaseName(v string) *IBMDb2Settings {
	s.DatabaseName = &v
	return s
}

// SetMaxKBytesPerRead sets the MaxKBytesPerRead field's value.
func (s *IBMDb2Settings) SetMaxKBytesPerRead(v int64) *IBMDb2Settings {
	s.MaxKBytesPerRead = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *IBMDb2Settings) SetPassword(v string) *IBMDb2Settings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *IBMDb2Settings) SetPort(v int64) *IBMDb2Settings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *IBMDb2Settings) SetSecretsManagerAccessRoleArn(v string) *IBMDb2Settings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *IBMDb2Settings) SetSecretsManagerSecretId(v string) *IBMDb2Settings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *IBMDb2Settings) SetServerName(v string) *IBMDb2Settings {
	s.ServerName = &v
	return s
}

// SetSetDataCaptureChanges sets the SetDataCaptureChanges field's value.
func (s *IBMDb2Settings) SetSetDataCaptureChanges(v bool) *IBMDb2Settings {
	s.SetDataCaptureChanges = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *IBMDb2Settings) SetUsername(v string) *IBMDb2Settings {
	s.Username = &v
	return s
}

type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// A customer-assigned name for the certificate. Identifiers must begin with
	// a letter and must contain only ASCII letters, digits, and hyphens. They can't
	// end with a hyphen or contain two consecutive hyphens.
	//
	// CertificateIdentifier is a required field
	CertificateIdentifier *string `type:"string" required:"true"`

	// The contents of a .pem file, which contains an X.509 certificate.
	//
	// CertificatePem is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ImportCertificateInput's
	// String and GoString methods.
	CertificatePem *string `type:"string" sensitive:"true"`

	// The location of an imported Oracle Wallet certificate for use with SSL. Provide
	// the name of a .sso file using the fileb:// prefix. You can't provide the
	// certificate inline.
	//
	// Example: filebase64("${path.root}/rds-ca-2019-root.sso")
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The tags associated with the certificate.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.CertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *ImportCertificateInput) SetCertificateIdentifier(v string) *ImportCertificateInput {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *ImportCertificateInput) SetCertificatePem(v string) *ImportCertificateInput {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *ImportCertificateInput) SetCertificateWallet(v []byte) *ImportCertificateInput {
	s.CertificateWallet = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportCertificateInput) SetTags(v []*Tag) *ImportCertificateInput {
	s.Tags = v
	return s
}

type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate to be uploaded.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateOutput) SetCertificate(v *Certificate) *ImportCertificateOutput {
	s.Certificate = v
	return s
}

// Provides information that defines an instance profile.
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the instance profile runs.
	AvailabilityZone *string `type:"string"`

	// A description of the instance profile. Descriptions can have up to 31 characters.
	// A description can contain only ASCII letters, digits, and hyphens ('-').
	// Also, it can't end with a hyphen or contain two consecutive hyphens, and
	// can only begin with a letter.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the instance
	// profile.
	InstanceProfileArn *string `type:"string"`

	// The time the instance profile was created.
	InstanceProfileCreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user-friendly name for the instance profile.
	InstanceProfileName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the
	// connection parameters for the instance profile.
	//
	// If you don't specify a value for the KmsKeyArn parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your Amazon Web Services account.
	// Your Amazon Web Services account has a different default encryption key for
	// each Amazon Web Services Region.
	KmsKeyArn *string `type:"string"`

	// Specifies the network type for the instance profile. A value of IPV4 represents
	// an instance profile with IPv4 network type and only supports IPv4 addressing.
	// A value of IPV6 represents an instance profile with IPv6 network type and
	// only supports IPv6 addressing. A value of DUAL represents an instance profile
	// with dual network type that supports IPv4 and IPv6 addressing.
	NetworkType *string `type:"string"`

	// Specifies the accessibility options for the instance profile. A value of
	// true represents an instance profile with a public IP address. A value of
	// false represents an instance profile with a private IP address. The default
	// value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The identifier of the subnet group that is associated with the instance profile.
	SubnetGroupIdentifier *string `type:"string"`

	// The VPC security groups that are used with the instance profile. The VPC
	// security group must work with the VPC containing the instance profile.
	VpcSecurityGroups []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProfile) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InstanceProfile) SetAvailabilityZone(v string) *InstanceProfile {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InstanceProfile) SetDescription(v string) *InstanceProfile {
	s.Description = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *InstanceProfile) SetInstanceProfileArn(v string) *InstanceProfile {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceProfileCreationTime sets the InstanceProfileCreationTime field's value.
func (s *InstanceProfile) SetInstanceProfileCreationTime(v time.Time) *InstanceProfile {
	s.InstanceProfileCreationTime = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *InstanceProfile) SetInstanceProfileName(v string) *InstanceProfile {
	s.InstanceProfileName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *InstanceProfile) SetKmsKeyArn(v string) *InstanceProfile {
	s.KmsKeyArn = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *InstanceProfile) SetNetworkType(v string) *InstanceProfile {
	s.NetworkType = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *InstanceProfile) SetPubliclyAccessible(v bool) *InstanceProfile {
	s.PubliclyAccessible = &v
	return s
}

// SetSubnetGroupIdentifier sets the SubnetGroupIdentifier field's value.
func (s *InstanceProfile) SetSubnetGroupIdentifier(v string) *InstanceProfile {
	s.SubnetGroupIdentifier = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *InstanceProfile) SetVpcSecurityGroups(v []*string) *InstanceProfile {
	s.VpcSecurityGroups = v
	return s
}

// There are not enough resources allocated to the database migration.
type InsufficientResourceCapacityFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientResourceCapacityFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientResourceCapacityFault) GoString() string {
	return s.String()
}

func newErrorInsufficientResourceCapacityFault(v protocol.ResponseMetadata) error {
	return &InsufficientResourceCapacityFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientResourceCapacityFault) Code() string {
	return "InsufficientResourceCapacityFault"
}

// Message returns the exception's message.
func (s *InsufficientResourceCapacityFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientResourceCapacityFault) OrigErr() error {
	return nil
}

func (s *InsufficientResourceCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientResourceCapacityFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientResourceCapacityFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate was not valid.
type InvalidCertificateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCertificateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCertificateFault) GoString() string {
	return s.String()
}

func newErrorInvalidCertificateFault(v protocol.ResponseMetadata) error {
	return &InvalidCertificateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCertificateFault) Code() string {
	return "InvalidCertificateFault"
}

// Message returns the exception's message.
func (s *InvalidCertificateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCertificateFault) OrigErr() error {
	return nil
}

func (s *InvalidCertificateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCertificateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCertificateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action or operation requested isn't valid.
type InvalidOperationFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationFault) GoString() string {
	return s.String()
}

func newErrorInvalidOperationFault(v protocol.ResponseMetadata) error {
	return &InvalidOperationFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOperationFault) Code() string {
	return "InvalidOperationFault"
}

// Message returns the exception's message.
func (s *InvalidOperationFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOperationFault) OrigErr() error {
	return nil
}

func (s *InvalidOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOperationFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOperationFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is in a state that prevents it from being used for database
// migration.
type InvalidResourceStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateFault(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateFault) Code() string {
	return "InvalidResourceStateFault"
}

// Message returns the exception's message.
func (s *InvalidResourceStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateFault) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The subnet provided isn't valid.
type InvalidSubnet struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSubnet) GoString() string {
	return s.String()
}

func newErrorInvalidSubnet(v protocol.ResponseMetadata) error {
	return &InvalidSubnet{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSubnet) Code() string {
	return "InvalidSubnet"
}

// Message returns the exception's message.
func (s *InvalidSubnet) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSubnet) OrigErr() error {
	return nil
}

func (s *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSubnet) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSubnet) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a Fleet Advisor collector inventory.
type InventoryData struct {
	_ struct{} `type:"structure"`

	// The number of databases in the Fleet Advisor collector inventory.
	NumberOfDatabases *int64 `type:"integer"`

	// The number of schemas in the Fleet Advisor collector inventory.
	NumberOfSchemas *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InventoryData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InventoryData) GoString() string {
	return s.String()
}

// SetNumberOfDatabases sets the NumberOfDatabases field's value.
func (s *InventoryData) SetNumberOfDatabases(v int64) *InventoryData {
	s.NumberOfDatabases = &v
	return s
}

// SetNumberOfSchemas sets the NumberOfSchemas field's value.
func (s *InventoryData) SetNumberOfSchemas(v int64) *InventoryData {
	s.NumberOfSchemas = &v
	return s
}

// The ciphertext references a key that doesn't exist or that the DMS account
// doesn't have access to.
type KMSAccessDeniedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSAccessDeniedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSAccessDeniedFault) GoString() string {
	return s.String()
}

func newErrorKMSAccessDeniedFault(v protocol.ResponseMetadata) error {
	return &KMSAccessDeniedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSAccessDeniedFault) Code() string {
	return "KMSAccessDeniedFault"
}

// Message returns the exception's message.
func (s *KMSAccessDeniedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSAccessDeniedFault) OrigErr() error {
	return nil
}

func (s *KMSAccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSAccessDeniedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSAccessDeniedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified KMS key isn't enabled.
type KMSDisabledFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSDisabledFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSDisabledFault) GoString() string {
	return s.String()
}

func newErrorKMSDisabledFault(v protocol.ResponseMetadata) error {
	return &KMSDisabledFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSDisabledFault) Code() string {
	return "KMSDisabledFault"
}

// Message returns the exception's message.
func (s *KMSDisabledFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSDisabledFault) OrigErr() error {
	return nil
}

func (s *KMSDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSDisabledFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSDisabledFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Key Management Service (KMS) error is preventing access to KMS.
type KMSFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSFault) GoString() string {
	return s.String()
}

func newErrorKMSFault(v protocol.ResponseMetadata) error {
	return &KMSFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSFault) Code() string {
	return "KMSFault"
}

// Message returns the exception's message.
func (s *KMSFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSFault) OrigErr() error {
	return nil
}

func (s *KMSFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the specified KMS resource isn't valid for this request.
type KMSInvalidStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidStateFault) GoString() string {
	return s.String()
}

func newErrorKMSInvalidStateFault(v protocol.ResponseMetadata) error {
	return &KMSInvalidStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidStateFault) Code() string {
	return "KMSInvalidStateFault"
}

// Message returns the exception's message.
func (s *KMSInvalidStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidStateFault) OrigErr() error {
	return nil
}

func (s *KMSInvalidStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// DMS cannot access the KMS key.
type KMSKeyNotAccessibleFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSKeyNotAccessibleFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSKeyNotAccessibleFault) GoString() string {
	return s.String()
}

func newErrorKMSKeyNotAccessibleFault(v protocol.ResponseMetadata) error {
	return &KMSKeyNotAccessibleFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSKeyNotAccessibleFault) Code() string {
	return "KMSKeyNotAccessibleFault"
}

// Message returns the exception's message.
func (s *KMSKeyNotAccessibleFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSKeyNotAccessibleFault) OrigErr() error {
	return nil
}

func (s *KMSKeyNotAccessibleFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSKeyNotAccessibleFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSKeyNotAccessibleFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified KMS entity or resource can't be found.
type KMSNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSNotFoundFault) GoString() string {
	return s.String()
}

func newErrorKMSNotFoundFault(v protocol.ResponseMetadata) error {
	return &KMSNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSNotFoundFault) Code() string {
	return "KMSNotFoundFault"
}

// Message returns the exception's message.
func (s *KMSNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSNotFoundFault) OrigErr() error {
	return nil
}

func (s *KMSNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// This request triggered KMS request throttling.
type KMSThrottlingFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSThrottlingFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSThrottlingFault) GoString() string {
	return s.String()
}

func newErrorKMSThrottlingFault(v protocol.ResponseMetadata) error {
	return &KMSThrottlingFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSThrottlingFault) Code() string {
	return "KMSThrottlingFault"
}

// Message returns the exception's message.
func (s *KMSThrottlingFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSThrottlingFault) OrigErr() error {
	return nil
}

func (s *KMSThrottlingFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSThrottlingFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSThrottlingFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information that describes an Apache Kafka endpoint. This information
// includes the output format of records applied to the endpoint and details
// of transaction and control table data information.
type KafkaSettings struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of one or more broker locations in your Kafka cluster
	// that host your Kafka instance. Specify each broker location in the form broker-hostname-or-ip:port
	// . For example, "ec2-12-345-678-901.compute-1.amazonaws.com:2345". For more
	// information and examples of specifying a list of broker locations, see Using
	// Apache Kafka as a target for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html)
	// in the Database Migration Service User Guide.
	Broker *string `type:"string"`

	// Shows detailed control information for table definition, column definition,
	// and table and column changes in the Kafka message output. The default is
	// false.
	IncludeControlDetails *bool `type:"boolean"`

	// Include NULL and empty columns for records migrated to the endpoint. The
	// default is false.
	IncludeNullAndEmpty *bool `type:"boolean"`

	// Shows the partition value within the Kafka message output unless the partition
	// type is schema-table-type. The default is false.
	IncludePartitionValue *bool `type:"boolean"`

	// Includes any data definition language (DDL) operations that change the table
	// in the control data, such as rename-table, drop-table, add-column, drop-column,
	// and rename-column. The default is false.
	IncludeTableAlterOperations *bool `type:"boolean"`

	// Provides detailed transaction information from the source database. This
	// information includes a commit timestamp, a log position, and values for transaction_id,
	// previous transaction_id, and transaction_record_id (the record offset within
	// a transaction). The default is false.
	IncludeTransactionDetails *bool `type:"boolean"`

	// The output format for the records created on the endpoint. The message format
	// is JSON (default) or JSON_UNFORMATTED (a single line with no tab).
	MessageFormat *string `type:"string" enum:"MessageFormatValue"`

	// The maximum size in bytes for records created on the endpoint The default
	// is 1,000,000.
	MessageMaxBytes *int64 `type:"integer"`

	// Set this optional parameter to true to avoid adding a '0x' prefix to raw
	// data in hexadecimal format. For example, by default, DMS adds a '0x' prefix
	// to the LOB column type in hexadecimal format moving from an Oracle source
	// to a Kafka target. Use the NoHexPrefix endpoint setting to enable migration
	// of RAW data type columns without adding the '0x' prefix.
	NoHexPrefix *bool `type:"boolean"`

	// Prefixes schema and table names to partition values, when the partition type
	// is primary-key-type. Doing this increases data distribution among Kafka partitions.
	// For example, suppose that a SysBench schema has thousands of tables and each
	// table has only limited range for a primary key. In this case, the same primary
	// key is sent from thousands of tables to the same partition, which causes
	// throttling. The default is false.
	PartitionIncludeSchemaTable *bool `type:"boolean"`

	// For SASL/SSL authentication, DMS supports the SCRAM-SHA-512 mechanism by
	// default. DMS versions 3.5.0 and later also support the PLAIN mechanism. To
	// use the PLAIN mechanism, set this parameter to PLAIN.
	SaslMechanism *string `type:"string" enum:"KafkaSaslMechanism"`

	// The secure password you created when you first set up your MSK cluster to
	// validate a client identity and make an encrypted connection between server
	// and client using SASL-SSL authentication.
	//
	// SaslPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KafkaSettings's
	// String and GoString methods.
	SaslPassword *string `type:"string" sensitive:"true"`

	// The secure user name you created when you first set up your MSK cluster to
	// validate a client identity and make an encrypted connection between server
	// and client using SASL-SSL authentication.
	SaslUsername *string `type:"string"`

	// Set secure connection to a Kafka target endpoint using Transport Layer Security
	// (TLS). Options include ssl-encryption, ssl-authentication, and sasl-ssl.
	// sasl-ssl requires SaslUsername and SaslPassword.
	SecurityProtocol *string `type:"string" enum:"KafkaSecurityProtocol"`

	// The Amazon Resource Name (ARN) for the private certificate authority (CA)
	// cert that DMS uses to securely connect to your Kafka target endpoint.
	SslCaCertificateArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the client certificate used to securely
	// connect to a Kafka target endpoint.
	SslClientCertificateArn *string `type:"string"`

	// The Amazon Resource Name (ARN) for the client private key used to securely
	// connect to a Kafka target endpoint.
	SslClientKeyArn *string `type:"string"`

	// The password for the client private key used to securely connect to a Kafka
	// target endpoint.
	//
	// SslClientKeyPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KafkaSettings's
	// String and GoString methods.
	SslClientKeyPassword *string `type:"string" sensitive:"true"`

	// Sets hostname verification for the certificate. This setting is supported
	// in DMS version 3.5.1 and later.
	SslEndpointIdentificationAlgorithm *string `type:"string" enum:"KafkaSslEndpointIdentificationAlgorithm"`

	// The topic to which you migrate the data. If you don't specify a topic, DMS
	// specifies "kafka-default-topic" as the migration topic.
	Topic *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaSettings) GoString() string {
	return s.String()
}

// SetBroker sets the Broker field's value.
func (s *KafkaSettings) SetBroker(v string) *KafkaSettings {
	s.Broker = &v
	return s
}

// SetIncludeControlDetails sets the IncludeControlDetails field's value.
func (s *KafkaSettings) SetIncludeControlDetails(v bool) *KafkaSettings {
	s.IncludeControlDetails = &v
	return s
}

// SetIncludeNullAndEmpty sets the IncludeNullAndEmpty field's value.
func (s *KafkaSettings) SetIncludeNullAndEmpty(v bool) *KafkaSettings {
	s.IncludeNullAndEmpty = &v
	return s
}

// SetIncludePartitionValue sets the IncludePartitionValue field's value.
func (s *KafkaSettings) SetIncludePartitionValue(v bool) *KafkaSettings {
	s.IncludePartitionValue = &v
	return s
}

// SetIncludeTableAlterOperations sets the IncludeTableAlterOperations field's value.
func (s *KafkaSettings) SetIncludeTableAlterOperations(v bool) *KafkaSettings {
	s.IncludeTableAlterOperations = &v
	return s
}

// SetIncludeTransactionDetails sets the IncludeTransactionDetails field's value.
func (s *KafkaSettings) SetIncludeTransactionDetails(v bool) *KafkaSettings {
	s.IncludeTransactionDetails = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *KafkaSettings) SetMessageFormat(v string) *KafkaSettings {
	s.MessageFormat = &v
	return s
}

// SetMessageMaxBytes sets the MessageMaxBytes field's value.
func (s *KafkaSettings) SetMessageMaxBytes(v int64) *KafkaSettings {
	s.MessageMaxBytes = &v
	return s
}

// SetNoHexPrefix sets the NoHexPrefix field's value.
func (s *KafkaSettings) SetNoHexPrefix(v bool) *KafkaSettings {
	s.NoHexPrefix = &v
	return s
}

// SetPartitionIncludeSchemaTable sets the PartitionIncludeSchemaTable field's value.
func (s *KafkaSettings) SetPartitionIncludeSchemaTable(v bool) *KafkaSettings {
	s.PartitionIncludeSchemaTable = &v
	return s
}

// SetSaslMechanism sets the SaslMechanism field's value.
func (s *KafkaSettings) SetSaslMechanism(v string) *KafkaSettings {
	s.SaslMechanism = &v
	return s
}

// SetSaslPassword sets the SaslPassword field's value.
func (s *KafkaSettings) SetSaslPassword(v string) *KafkaSettings {
	s.SaslPassword = &v
	return s
}

// SetSaslUsername sets the SaslUsername field's value.
func (s *KafkaSettings) SetSaslUsername(v string) *KafkaSettings {
	s.SaslUsername = &v
	return s
}

// SetSecurityProtocol sets the SecurityProtocol field's value.
func (s *KafkaSettings) SetSecurityProtocol(v string) *KafkaSettings {
	s.SecurityProtocol = &v
	return s
}

// SetSslCaCertificateArn sets the SslCaCertificateArn field's value.
func (s *KafkaSettings) SetSslCaCertificateArn(v string) *KafkaSettings {
	s.SslCaCertificateArn = &v
	return s
}

// SetSslClientCertificateArn sets the SslClientCertificateArn field's value.
func (s *KafkaSettings) SetSslClientCertificateArn(v string) *KafkaSettings {
	s.SslClientCertificateArn = &v
	return s
}

// SetSslClientKeyArn sets the SslClientKeyArn field's value.
func (s *KafkaSettings) SetSslClientKeyArn(v string) *KafkaSettings {
	s.SslClientKeyArn = &v
	return s
}

// SetSslClientKeyPassword sets the SslClientKeyPassword field's value.
func (s *KafkaSettings) SetSslClientKeyPassword(v string) *KafkaSettings {
	s.SslClientKeyPassword = &v
	return s
}

// SetSslEndpointIdentificationAlgorithm sets the SslEndpointIdentificationAlgorithm field's value.
func (s *KafkaSettings) SetSslEndpointIdentificationAlgorithm(v string) *KafkaSettings {
	s.SslEndpointIdentificationAlgorithm = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *KafkaSettings) SetTopic(v string) *KafkaSettings {
	s.Topic = &v
	return s
}

// Provides information that describes an Amazon Kinesis Data Stream endpoint.
// This information includes the output format of records applied to the endpoint
// and details of transaction and control table data information.
type KinesisSettings struct {
	_ struct{} `type:"structure"`

	// Shows detailed control information for table definition, column definition,
	// and table and column changes in the Kinesis message output. The default is
	// false.
	IncludeControlDetails *bool `type:"boolean"`

	// Include NULL and empty columns for records migrated to the endpoint. The
	// default is false.
	IncludeNullAndEmpty *bool `type:"boolean"`

	// Shows the partition value within the Kinesis message output, unless the partition
	// type is schema-table-type. The default is false.
	IncludePartitionValue *bool `type:"boolean"`

	// Includes any data definition language (DDL) operations that change the table
	// in the control data, such as rename-table, drop-table, add-column, drop-column,
	// and rename-column. The default is false.
	IncludeTableAlterOperations *bool `type:"boolean"`

	// Provides detailed transaction information from the source database. This
	// information includes a commit timestamp, a log position, and values for transaction_id,
	// previous transaction_id, and transaction_record_id (the record offset within
	// a transaction). The default is false.
	IncludeTransactionDetails *bool `type:"boolean"`

	// The output format for the records created on the endpoint. The message format
	// is JSON (default) or JSON_UNFORMATTED (a single line with no tab).
	MessageFormat *string `type:"string" enum:"MessageFormatValue"`

	// Set this optional parameter to true to avoid adding a '0x' prefix to raw
	// data in hexadecimal format. For example, by default, DMS adds a '0x' prefix
	// to the LOB column type in hexadecimal format moving from an Oracle source
	// to an Amazon Kinesis target. Use the NoHexPrefix endpoint setting to enable
	// migration of RAW data type columns without adding the '0x' prefix.
	NoHexPrefix *bool `type:"boolean"`

	// Prefixes schema and table names to partition values, when the partition type
	// is primary-key-type. Doing this increases data distribution among Kinesis
	// shards. For example, suppose that a SysBench schema has thousands of tables
	// and each table has only limited range for a primary key. In this case, the
	// same primary key is sent from thousands of tables to the same shard, which
	// causes throttling. The default is false.
	PartitionIncludeSchemaTable *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to
	// the Kinesis data stream. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
	StreamArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisSettings) GoString() string {
	return s.String()
}

// SetIncludeControlDetails sets the IncludeControlDetails field's value.
func (s *KinesisSettings) SetIncludeControlDetails(v bool) *KinesisSettings {
	s.IncludeControlDetails = &v
	return s
}

// SetIncludeNullAndEmpty sets the IncludeNullAndEmpty field's value.
func (s *KinesisSettings) SetIncludeNullAndEmpty(v bool) *KinesisSettings {
	s.IncludeNullAndEmpty = &v
	return s
}

// SetIncludePartitionValue sets the IncludePartitionValue field's value.
func (s *KinesisSettings) SetIncludePartitionValue(v bool) *KinesisSettings {
	s.IncludePartitionValue = &v
	return s
}

// SetIncludeTableAlterOperations sets the IncludeTableAlterOperations field's value.
func (s *KinesisSettings) SetIncludeTableAlterOperations(v bool) *KinesisSettings {
	s.IncludeTableAlterOperations = &v
	return s
}

// SetIncludeTransactionDetails sets the IncludeTransactionDetails field's value.
func (s *KinesisSettings) SetIncludeTransactionDetails(v bool) *KinesisSettings {
	s.IncludeTransactionDetails = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *KinesisSettings) SetMessageFormat(v string) *KinesisSettings {
	s.MessageFormat = &v
	return s
}

// SetNoHexPrefix sets the NoHexPrefix field's value.
func (s *KinesisSettings) SetNoHexPrefix(v bool) *KinesisSettings {
	s.NoHexPrefix = &v
	return s
}

// SetPartitionIncludeSchemaTable sets the PartitionIncludeSchemaTable field's value.
func (s *KinesisSettings) SetPartitionIncludeSchemaTable(v bool) *KinesisSettings {
	s.PartitionIncludeSchemaTable = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *KinesisSettings) SetServiceAccessRoleArn(v string) *KinesisSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *KinesisSettings) SetStreamArn(v string) *KinesisSettings {
	s.StreamArn = &v
	return s
}

// Provides information about the limitations of target Amazon Web Services
// engines.
//
// Your source database might include features that the target Amazon Web Services
// engine doesn't support. Fleet Advisor lists these features as limitations.
// You should consider these limitations during database migration. For each
// limitation, Fleet Advisor recommends an action that you can take to address
// or avoid this limitation.
type Limitation struct {
	_ struct{} `type:"structure"`

	// The identifier of the source database.
	DatabaseId *string `type:"string"`

	// A description of the limitation. Provides additional information about the
	// limitation, and includes recommended actions that you can take to address
	// or avoid this limitation.
	Description *string `type:"string"`

	// The name of the target engine that Fleet Advisor should use in the target
	// engine recommendation. Valid values include "rds-aurora-mysql", "rds-aurora-postgresql",
	// "rds-mysql", "rds-oracle", "rds-sql-server", and "rds-postgresql".
	EngineName *string `type:"string"`

	// The impact of the limitation. You can use this parameter to prioritize limitations
	// that you want to address. Valid values include "Blocker", "High", "Medium",
	// and "Low".
	Impact *string `type:"string"`

	// The name of the limitation. Describes unsupported database features, migration
	// action items, and other limitations.
	Name *string `type:"string"`

	// The type of the limitation, such as action required, upgrade required, and
	// limited feature.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limitation) GoString() string {
	return s.String()
}

// SetDatabaseId sets the DatabaseId field's value.
func (s *Limitation) SetDatabaseId(v string) *Limitation {
	s.DatabaseId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Limitation) SetDescription(v string) *Limitation {
	s.Description = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *Limitation) SetEngineName(v string) *Limitation {
	s.EngineName = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *Limitation) SetImpact(v string) *Limitation {
	s.Impact = &v
	return s
}

// SetName sets the Name field's value.
func (s *Limitation) SetName(v string) *Limitation {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Limitation) SetType(v string) *Limitation {
	s.Type = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource
	// to list tags for. This returns a list of keys (names of tags) created for
	// the resource and their associated tag values.
	ResourceArn *string `type:"string"`

	// List of ARNs that identify multiple DMS resources that you want to list tags
	// for. This returns a list of keys (tag names) and their associated tag values.
	// It also returns each tag's associated ResourceArn value, which is the ARN
	// of the resource for which each listed tag is created.
	ResourceArnList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceArnList sets the ResourceArnList field's value.
func (s *ListTagsForResourceInput) SetResourceArnList(v []*string) *ListTagsForResourceInput {
	s.ResourceArnList = v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags for the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// Provides information that defines a Microsoft SQL Server endpoint.
type MicrosoftSQLServerSettings struct {
	_ struct{} `type:"structure"`

	// The maximum size of the packets (in bytes) used to transfer data using BCP.
	BcpPacketSize *int64 `type:"integer"`

	// Specifies a file group for the DMS internal tables. When the replication
	// task starts, all the internal DMS control tables (awsdms_ apply_exception,
	// awsdms_apply, awsdms_changes) are created for the specified file group.
	ControlTablesFileGroup *string `type:"string"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// Forces LOB lookup on inline LOB.
	ForceLobLookup *bool `type:"boolean"`

	// Endpoint connection password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MicrosoftSQLServerSettings's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// Cleans and recreates table metadata information on the replication instance
	// when a mismatch occurs. An example is a situation where running an alter
	// DDL statement on a table might result in different information about the
	// table cached in the replication instance.
	QuerySingleAlwaysOnNode *bool `type:"boolean"`

	// When this attribute is set to Y, DMS only reads changes from transaction
	// log backups and doesn't read from the active transaction log file during
	// ongoing replication. Setting this parameter to Y enables you to control active
	// transaction log file growth during full load and ongoing replication tasks.
	// However, it can add some source latency to ongoing replication.
	ReadBackupOnly *bool `type:"boolean"`

	// Use this attribute to minimize the need to access the backup log and enable
	// DMS to prevent truncation using one of the following two methods.
	//
	// Start transactions in the database: This is the default method. When this
	// method is used, DMS prevents TLOG truncation by mimicking a transaction in
	// the database. As long as such a transaction is open, changes that appear
	// after the transaction started aren't truncated. If you need Microsoft Replication
	// to be enabled in your database, then you must choose this method.
	//
	// Exclusively use sp_repldone within a single task: When this method is used,
	// DMS reads the changes and then uses sp_repldone to mark the TLOG transactions
	// as ready for truncation. Although this method doesn't involve any transactional
	// activities, it can only be used when Microsoft Replication isn't running.
	// Also, when using this method, only one DMS task can access the database at
	// any given time. Therefore, if you need to run parallel DMS tasks against
	// the same database, use the default method.
	SafeguardPolicy *string `type:"string" enum:"SafeguardPolicy"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the SQL Server endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the SQL Server endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint. For an Amazon RDS SQL Server
	// instance, this is the output of DescribeDBInstances (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html),
	// in the Endpoint (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html).Address
	// field.
	ServerName *string `type:"string"`

	// Indicates the mode used to fetch CDC data.
	TlogAccessMode *string `type:"string" enum:"TlogAccessMode"`

	// Use the TrimSpaceInChar source endpoint setting to trim data on CHAR and
	// NCHAR data types during migration. The default value is true.
	TrimSpaceInChar *bool `type:"boolean"`

	// Use this to attribute to transfer data for full-load operations using BCP.
	// When the target table contains an identity column that does not exist in
	// the source table, you must disable the use BCP for loading table option.
	UseBcpFullLoad *bool `type:"boolean"`

	// When this attribute is set to Y, DMS processes third-party transaction log
	// backups if they are created in native format.
	UseThirdPartyBackupDevice *bool `type:"boolean"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MicrosoftSQLServerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MicrosoftSQLServerSettings) GoString() string {
	return s.String()
}

// SetBcpPacketSize sets the BcpPacketSize field's value.
func (s *MicrosoftSQLServerSettings) SetBcpPacketSize(v int64) *MicrosoftSQLServerSettings {
	s.BcpPacketSize = &v
	return s
}

// SetControlTablesFileGroup sets the ControlTablesFileGroup field's value.
func (s *MicrosoftSQLServerSettings) SetControlTablesFileGroup(v string) *MicrosoftSQLServerSettings {
	s.ControlTablesFileGroup = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MicrosoftSQLServerSettings) SetDatabaseName(v string) *MicrosoftSQLServerSettings {
	s.DatabaseName = &v
	return s
}

// SetForceLobLookup sets the ForceLobLookup field's value.
func (s *MicrosoftSQLServerSettings) SetForceLobLookup(v bool) *MicrosoftSQLServerSettings {
	s.ForceLobLookup = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MicrosoftSQLServerSettings) SetPassword(v string) *MicrosoftSQLServerSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MicrosoftSQLServerSettings) SetPort(v int64) *MicrosoftSQLServerSettings {
	s.Port = &v
	return s
}

// SetQuerySingleAlwaysOnNode sets the QuerySingleAlwaysOnNode field's value.
func (s *MicrosoftSQLServerSettings) SetQuerySingleAlwaysOnNode(v bool) *MicrosoftSQLServerSettings {
	s.QuerySingleAlwaysOnNode = &v
	return s
}

// SetReadBackupOnly sets the ReadBackupOnly field's value.
func (s *MicrosoftSQLServerSettings) SetReadBackupOnly(v bool) *MicrosoftSQLServerSettings {
	s.ReadBackupOnly = &v
	return s
}

// SetSafeguardPolicy sets the SafeguardPolicy field's value.
func (s *MicrosoftSQLServerSettings) SetSafeguardPolicy(v string) *MicrosoftSQLServerSettings {
	s.SafeguardPolicy = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *MicrosoftSQLServerSettings) SetSecretsManagerAccessRoleArn(v string) *MicrosoftSQLServerSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *MicrosoftSQLServerSettings) SetSecretsManagerSecretId(v string) *MicrosoftSQLServerSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MicrosoftSQLServerSettings) SetServerName(v string) *MicrosoftSQLServerSettings {
	s.ServerName = &v
	return s
}

// SetTlogAccessMode sets the TlogAccessMode field's value.
func (s *MicrosoftSQLServerSettings) SetTlogAccessMode(v string) *MicrosoftSQLServerSettings {
	s.TlogAccessMode = &v
	return s
}

// SetTrimSpaceInChar sets the TrimSpaceInChar field's value.
func (s *MicrosoftSQLServerSettings) SetTrimSpaceInChar(v bool) *MicrosoftSQLServerSettings {
	s.TrimSpaceInChar = &v
	return s
}

// SetUseBcpFullLoad sets the UseBcpFullLoad field's value.
func (s *MicrosoftSQLServerSettings) SetUseBcpFullLoad(v bool) *MicrosoftSQLServerSettings {
	s.UseBcpFullLoad = &v
	return s
}

// SetUseThirdPartyBackupDevice sets the UseThirdPartyBackupDevice field's value.
func (s *MicrosoftSQLServerSettings) SetUseThirdPartyBackupDevice(v bool) *MicrosoftSQLServerSettings {
	s.UseThirdPartyBackupDevice = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MicrosoftSQLServerSettings) SetUsername(v string) *MicrosoftSQLServerSettings {
	s.Username = &v
	return s
}

// Provides information that defines a Microsoft SQL Server data provider.
type MicrosoftSqlServerDataProviderSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate used for SSL connection.
	CertificateArn *string `type:"string"`

	// The database name on the Microsoft SQL Server data provider.
	DatabaseName *string `type:"string"`

	// The port value for the Microsoft SQL Server data provider.
	Port *int64 `type:"integer"`

	// The name of the Microsoft SQL Server server.
	ServerName *string `type:"string"`

	// The SSL mode used to connect to the Microsoft SQL Server data provider. The
	// default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MicrosoftSqlServerDataProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MicrosoftSqlServerDataProviderSettings) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *MicrosoftSqlServerDataProviderSettings) SetCertificateArn(v string) *MicrosoftSqlServerDataProviderSettings {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MicrosoftSqlServerDataProviderSettings) SetDatabaseName(v string) *MicrosoftSqlServerDataProviderSettings {
	s.DatabaseName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MicrosoftSqlServerDataProviderSettings) SetPort(v int64) *MicrosoftSqlServerDataProviderSettings {
	s.Port = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MicrosoftSqlServerDataProviderSettings) SetServerName(v string) *MicrosoftSqlServerDataProviderSettings {
	s.ServerName = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *MicrosoftSqlServerDataProviderSettings) SetSslMode(v string) *MicrosoftSqlServerDataProviderSettings {
	s.SslMode = &v
	return s
}

// Provides information that defines a migration project.
type MigrationProject struct {
	_ struct{} `type:"structure"`

	// A user-friendly description of the migration project.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the instance profile for your migration
	// project.
	InstanceProfileArn *string `type:"string"`

	// The name of the associated instance profile.
	InstanceProfileName *string `type:"string"`

	// The ARN string that uniquely identifies the migration project.
	MigrationProjectArn *string `type:"string"`

	// The time when the migration project was created.
	MigrationProjectCreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the migration project.
	MigrationProjectName *string `type:"string"`

	// The schema conversion application attributes, including the Amazon S3 bucket
	// name and Amazon S3 role ARN.
	SchemaConversionApplicationAttributes *SCApplicationAttributes `type:"structure"`

	// Information about the source data provider, including the name or ARN, and
	// Secrets Manager parameters.
	SourceDataProviderDescriptors []*DataProviderDescriptor `type:"list"`

	// Information about the target data provider, including the name or ARN, and
	// Secrets Manager parameters.
	TargetDataProviderDescriptors []*DataProviderDescriptor `type:"list"`

	// The settings in JSON format for migration rules. Migration rules make it
	// possible for you to change the object names according to the rules that you
	// specify. For example, you can change an object name to lowercase or uppercase,
	// add or remove a prefix or suffix, or rename objects.
	TransformationRules *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrationProject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrationProject) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MigrationProject) SetDescription(v string) *MigrationProject {
	s.Description = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *MigrationProject) SetInstanceProfileArn(v string) *MigrationProject {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *MigrationProject) SetInstanceProfileName(v string) *MigrationProject {
	s.InstanceProfileName = &v
	return s
}

// SetMigrationProjectArn sets the MigrationProjectArn field's value.
func (s *MigrationProject) SetMigrationProjectArn(v string) *MigrationProject {
	s.MigrationProjectArn = &v
	return s
}

// SetMigrationProjectCreationTime sets the MigrationProjectCreationTime field's value.
func (s *MigrationProject) SetMigrationProjectCreationTime(v time.Time) *MigrationProject {
	s.MigrationProjectCreationTime = &v
	return s
}

// SetMigrationProjectName sets the MigrationProjectName field's value.
func (s *MigrationProject) SetMigrationProjectName(v string) *MigrationProject {
	s.MigrationProjectName = &v
	return s
}

// SetSchemaConversionApplicationAttributes sets the SchemaConversionApplicationAttributes field's value.
func (s *MigrationProject) SetSchemaConversionApplicationAttributes(v *SCApplicationAttributes) *MigrationProject {
	s.SchemaConversionApplicationAttributes = v
	return s
}

// SetSourceDataProviderDescriptors sets the SourceDataProviderDescriptors field's value.
func (s *MigrationProject) SetSourceDataProviderDescriptors(v []*DataProviderDescriptor) *MigrationProject {
	s.SourceDataProviderDescriptors = v
	return s
}

// SetTargetDataProviderDescriptors sets the TargetDataProviderDescriptors field's value.
func (s *MigrationProject) SetTargetDataProviderDescriptors(v []*DataProviderDescriptor) *MigrationProject {
	s.TargetDataProviderDescriptors = v
	return s
}

// SetTransformationRules sets the TransformationRules field's value.
func (s *MigrationProject) SetTransformationRules(v string) *MigrationProject {
	s.TransformationRules = &v
	return s
}

type ModifyConversionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The new conversion configuration.
	//
	// ConversionConfiguration is a required field
	ConversionConfiguration *string `type:"string" required:"true"`

	// The migration project name or Amazon Resource Name (ARN).
	//
	// MigrationProjectIdentifier is a required field
	MigrationProjectIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyConversionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyConversionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyConversionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyConversionConfigurationInput"}
	if s.ConversionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ConversionConfiguration"))
	}
	if s.MigrationProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConversionConfiguration sets the ConversionConfiguration field's value.
func (s *ModifyConversionConfigurationInput) SetConversionConfiguration(v string) *ModifyConversionConfigurationInput {
	s.ConversionConfiguration = &v
	return s
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *ModifyConversionConfigurationInput) SetMigrationProjectIdentifier(v string) *ModifyConversionConfigurationInput {
	s.MigrationProjectIdentifier = &v
	return s
}

type ModifyConversionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the modified configuration.
	MigrationProjectIdentifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyConversionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyConversionConfigurationOutput) GoString() string {
	return s.String()
}

// SetMigrationProjectIdentifier sets the MigrationProjectIdentifier field's value.
func (s *ModifyConversionConfigurationOutput) SetMigrationProjectIdentifier(v string) *ModifyConversionConfigurationOutput {
	s.MigrationProjectIdentifier = &v
	return s
}

type ModifyDataProviderInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data provider. Identifiers must begin with a letter
	// and must contain only ASCII letters, digits, and hyphens. They can't end
	// with a hyphen, or contain two consecutive hyphens.
	//
	// DataProviderIdentifier is a required field
	DataProviderIdentifier *string `type:"string" required:"true"`

	// The name of the data provider.
	DataProviderName *string `type:"string"`

	// A user-friendly description of the data provider.
	Description *string `type:"string"`

	// The type of database engine for the data provider. Valid values include "aurora",
	// "aurora_postgresql", "mysql", "oracle", "postgres", and "sqlserver". A value
	// of "aurora" represents Amazon Aurora MySQL-Compatible Edition.
	Engine *string `type:"string"`

	// If this attribute is Y, the current call to ModifyDataProvider replaces all
	// existing data provider settings with the exact settings that you specify
	// in this call. If this attribute is N, the current call to ModifyDataProvider
	// does two things:
	//
	//    * It replaces any data provider settings that already exist with new values,
	//    for settings with the same names.
	//
	//    * It creates new data provider settings that you specify in the call,
	//    for settings with different names.
	ExactSettings *bool `type:"boolean"`

	// The settings in JSON format for a data provider.
	Settings *DataProviderSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyDataProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyDataProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDataProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDataProviderInput"}
	if s.DataProviderIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataProviderIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataProviderIdentifier sets the DataProviderIdentifier field's value.
func (s *ModifyDataProviderInput) SetDataProviderIdentifier(v string) *ModifyDataProviderInput {
	s.DataProviderIdentifier = &v
	return s
}

// SetDataProviderName sets the DataProviderName field's value.
func (s *ModifyDataProviderInput) SetDataProviderName(v string) *ModifyDataProviderInput {
	s.DataProviderName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyDataProviderInput) SetDescription(v string) *ModifyDataProviderInput {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *ModifyDataProviderInput) SetEngine(v string) *ModifyDataProviderInput {
	s.Engine = &v
	return s
}

// SetExactSettings sets the ExactSettings field's value.
func (s *ModifyDataProviderInput) SetExactSettings(v bool) *ModifyDataProviderInput {
	s.ExactSettings = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *ModifyDataProviderInput) SetSettings(v *DataProviderSettings) *ModifyDataProviderInput {
	s.Settings = v
	return s
}

type ModifyDataProviderOutput struct {
	_ struct{} `type:"structure"`

	// The data provider that was modified.
	DataProvider *DataProvider `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyDataProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyDataProviderOutput) GoString() string {
	return s.String()
}

// SetDataProvider sets the DataProvider field's value.
func (s *ModifyDataProviderOutput) SetDataProvider(v *DataProvider) *ModifyDataProviderOutput {
	s.DataProvider = v
	return s
}

type ModifyEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate used for SSL connection.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database. For a MySQL source or target endpoint,
	// do not specify DatabaseName.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Attributes include the following:
	//
	//    * serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service
	//    access IAM role. The role must allow the iam:PassRole action.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string
	// ,BucketName=string
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string"}
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Settings in JSON format for the source DocumentDB endpoint. For more information
	// about the available settings, see the configuration properties section in
	// Using DocumentDB as a Target for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html)
	// in the Database Migration Service User Guide.
	DocDbSettings *DocDbSettings `type:"structure"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For information
	// about other available settings, see Using Object Mapping to Migrate Data
	// to DynamoDB (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping)
	// in the Database Migration Service User Guide.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// Settings in JSON format for the target OpenSearch endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// OpenSearch as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration)
	// in the Database Migration Service User Guide.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint. Valid values are source and target.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "db2-zos", "azuredb", "sybase", "dynamodb", "mongodb",
	// "kinesis", "kafka", "elasticsearch", "documentdb", "sqlserver", "neptune",
	// and "babelfish".
	EngineName *string `type:"string"`

	// If this attribute is Y, the current call to ModifyEndpoint replaces all existing
	// endpoint settings with the exact settings that you specify in this call.
	// If this attribute is N, the current call to ModifyEndpoint does two things:
	//
	//    * It replaces any endpoint settings that already exist with new values,
	//    for settings with the same names.
	//
	//    * It creates new endpoint settings that you specify in the call, for settings
	//    with different names.
	//
	// For example, if you call create-endpoint ... --endpoint-settings '{"a":1}'
	// ..., the endpoint has the following endpoint settings: '{"a":1}'. If you
	// then call modify-endpoint ... --endpoint-settings '{"b":2}' ... for the same
	// endpoint, the endpoint has the following settings: '{"a":1,"b":2}'.
	//
	// However, suppose that you follow this with a call to modify-endpoint ...
	// --endpoint-settings '{"b":2}' --exact-settings ... for that same endpoint
	// again. Then the endpoint has the following settings: '{"b":2}'. All existing
	// settings are replaced with the exact settings that you specify.
	ExactSettings *bool `type:"boolean"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional attributes associated with the connection. To reset this parameter,
	// pass the empty string ("") as an argument.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source GCP MySQL endpoint.
	GcpMySQLSettings *GcpMySQLSettings `type:"structure"`

	// Settings in JSON format for the source IBM Db2 LUW endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Db2 LUW as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// Settings in JSON format for the target Apache Kafka endpoint. For more information
	// about the available settings, see Using object mapping to migrate data to
	// a Kafka topic (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping)
	// in the Database Migration Service User Guide.
	KafkaSettings *KafkaSettings `type:"structure"`

	// Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
	// For more information about the available settings, see Using object mapping
	// to migrate data to a Kinesis data stream (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping)
	// in the Database Migration Service User Guide.
	KinesisSettings *KinesisSettings `type:"structure"`

	// Settings in JSON format for the source and target Microsoft SQL Server endpoint.
	// For information about other available settings, see Extra connection attributes
	// when using SQL Server as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib)
	// and Extra connection attributes when using SQL Server as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see the configuration properties section in
	// Endpoint configuration settings when using MongoDB as a source for Database
	// Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration)
	// in the Database Migration Service User Guide.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// Settings in JSON format for the source and target MySQL endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// MySQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib)
	// and Extra connection attributes when using a MySQL-compatible database as
	// a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MySQLSettings *MySQLSettings `type:"structure"`

	// Settings in JSON format for the target Amazon Neptune endpoint. For more
	// information about the available settings, see Specifying graph-mapping rules
	// using Gremlin and R2RML for Amazon Neptune as a target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings)
	// in the Database Migration Service User Guide.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// Settings in JSON format for the source and target Oracle endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Oracle as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib)
	// and Extra connection attributes when using Oracle as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	OracleSettings *OracleSettings `type:"structure"`

	// The password to be used to login to the endpoint database.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ModifyEndpointInput's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the source and target PostgreSQL endpoint. For
	// information about other available settings, see Extra connection attributes
	// when using PostgreSQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/use