// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateExternalConnection = "AssociateExternalConnection"

// AssociateExternalConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateExternalConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateExternalConnection for more information on using the AssociateExternalConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateExternalConnectionRequest method.
//	req, resp := client.AssociateExternalConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/AssociateExternalConnection
func (c *CodeArtifact) AssociateExternalConnectionRequest(input *AssociateExternalConnectionInput) (req *request.Request, output *AssociateExternalConnectionOutput) {
	op := &request.Operation{
		Name:       opAssociateExternalConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repository/external-connection",
	}

	if input == nil {
		input = &AssociateExternalConnectionInput{}
	}

	output = &AssociateExternalConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateExternalConnection API operation for CodeArtifact.
//
// Adds an existing external connection to a repository. One external connection
// is allowed per repository.
//
// A repository can have one or more upstream repositories, or an external connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation AssociateExternalConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/AssociateExternalConnection
func (c *CodeArtifact) AssociateExternalConnection(input *AssociateExternalConnectionInput) (*AssociateExternalConnectionOutput, error) {
	req, out := c.AssociateExternalConnectionRequest(input)
	return out, req.Send()
}

// AssociateExternalConnectionWithContext is the same as AssociateExternalConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateExternalConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) AssociateExternalConnectionWithContext(ctx aws.Context, input *AssociateExternalConnectionInput, opts ...request.Option) (*AssociateExternalConnectionOutput, error) {
	req, out := c.AssociateExternalConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyPackageVersions = "CopyPackageVersions"

// CopyPackageVersionsRequest generates a "aws/request.Request" representing the
// client's request for the CopyPackageVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyPackageVersions for more information on using the CopyPackageVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyPackageVersionsRequest method.
//	req, resp := client.CopyPackageVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CopyPackageVersions
func (c *CodeArtifact) CopyPackageVersionsRequest(input *CopyPackageVersionsInput) (req *request.Request, output *CopyPackageVersionsOutput) {
	op := &request.Operation{
		Name:       opCopyPackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/copy",
	}

	if input == nil {
		input = &CopyPackageVersionsInput{}
	}

	output = &CopyPackageVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyPackageVersions API operation for CodeArtifact.
//
// Copies package versions from one repository to another repository in the
// same domain.
//
// You must specify versions or versionRevisions. You cannot specify both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation CopyPackageVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CopyPackageVersions
func (c *CodeArtifact) CopyPackageVersions(input *CopyPackageVersionsInput) (*CopyPackageVersionsOutput, error) {
	req, out := c.CopyPackageVersionsRequest(input)
	return out, req.Send()
}

// CopyPackageVersionsWithContext is the same as CopyPackageVersions with the addition of
// the ability to pass a context and additional request options.
//
// See CopyPackageVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) CopyPackageVersionsWithContext(ctx aws.Context, input *CopyPackageVersionsInput, opts ...request.Option) (*CopyPackageVersionsOutput, error) {
	req, out := c.CopyPackageVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateDomain
func (c *CodeArtifact) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/domain",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for CodeArtifact.
//
// Creates a domain. CodeArtifact domains make it easier to manage multiple
// repositories across an organization. You can use a domain to apply permissions
// across many repositories owned by different Amazon Web Services accounts.
// An asset is stored only once in a domain, even if it's in multiple repositories.
//
// Although you can have multiple domains, we recommend a single production
// domain that contains all published artifacts so that your development teams
// can find and share packages. You can use a second pre-production domain to
// test changes to the production domain configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateDomain
func (c *CodeArtifact) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRepository for more information on using the CreateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRepositoryRequest method.
//	req, resp := client.CreateRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateRepository
func (c *CodeArtifact) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for CodeArtifact.
//
// Creates a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation CreateRepository for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateRepository
func (c *CodeArtifact) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) CreateRepositoryWithContext(ctx aws.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomain
func (c *CodeArtifact) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/domain",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for CodeArtifact.
//
// Deletes a domain. You cannot delete a domain that contains repositories.
// If you want to delete a domain with repositories, first delete its repositories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomain
func (c *CodeArtifact) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainPermissionsPolicy = "DeleteDomainPermissionsPolicy"

// DeleteDomainPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainPermissionsPolicy for more information on using the DeleteDomainPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainPermissionsPolicyRequest method.
//	req, resp := client.DeleteDomainPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomainPermissionsPolicy
func (c *CodeArtifact) DeleteDomainPermissionsPolicyRequest(input *DeleteDomainPermissionsPolicyInput) (req *request.Request, output *DeleteDomainPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainPermissionsPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/domain/permissions/policy",
	}

	if input == nil {
		input = &DeleteDomainPermissionsPolicyInput{}
	}

	output = &DeleteDomainPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomainPermissionsPolicy API operation for CodeArtifact.
//
// Deletes the resource policy set on a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeleteDomainPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomainPermissionsPolicy
func (c *CodeArtifact) DeleteDomainPermissionsPolicy(input *DeleteDomainPermissionsPolicyInput) (*DeleteDomainPermissionsPolicyOutput, error) {
	req, out := c.DeleteDomainPermissionsPolicyRequest(input)
	return out, req.Send()
}

// DeleteDomainPermissionsPolicyWithContext is the same as DeleteDomainPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeleteDomainPermissionsPolicyWithContext(ctx aws.Context, input *DeleteDomainPermissionsPolicyInput, opts ...request.Option) (*DeleteDomainPermissionsPolicyOutput, error) {
	req, out := c.DeleteDomainPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackage = "DeletePackage"

// DeletePackageRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackage for more information on using the DeletePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePackageRequest method.
//	req, resp := client.DeletePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackage
func (c *CodeArtifact) DeletePackageRequest(input *DeletePackageInput) (req *request.Request, output *DeletePackageOutput) {
	op := &request.Operation{
		Name:       opDeletePackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/package",
	}

	if input == nil {
		input = &DeletePackageInput{}
	}

	output = &DeletePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePackage API operation for CodeArtifact.
//
// Deletes a package and all associated package versions. A deleted package
// cannot be restored. To delete one or more package versions, use the DeletePackageVersions
// (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeletePackageVersions.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeletePackage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackage
func (c *CodeArtifact) DeletePackage(input *DeletePackageInput) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	return out, req.Send()
}

// DeletePackageWithContext is the same as DeletePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeletePackageWithContext(ctx aws.Context, input *DeletePackageInput, opts ...request.Option) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackageVersions = "DeletePackageVersions"

// DeletePackageVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackageVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackageVersions for more information on using the DeletePackageVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePackageVersionsRequest method.
//	req, resp := client.DeletePackageVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackageVersions
func (c *CodeArtifact) DeletePackageVersionsRequest(input *DeletePackageVersionsInput) (req *request.Request, output *DeletePackageVersionsOutput) {
	op := &request.Operation{
		Name:       opDeletePackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/delete",
	}

	if input == nil {
		input = &DeletePackageVersionsInput{}
	}

	output = &DeletePackageVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePackageVersions API operation for CodeArtifact.
//
// Deletes one or more versions of a package. A deleted package version cannot
// be restored in your repository. If you want to remove a package version from
// your repository and be able to restore it later, set its status to Archived.
// Archived packages cannot be downloaded from a repository and don't show up
// with list package APIs (for example, ListPackageVersions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)),
// but you can restore them using UpdatePackageVersionsStatus (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeletePackageVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackageVersions
func (c *CodeArtifact) DeletePackageVersions(input *DeletePackageVersionsInput) (*DeletePackageVersionsOutput, error) {
	req, out := c.DeletePackageVersionsRequest(input)
	return out, req.Send()
}

// DeletePackageVersionsWithContext is the same as DeletePackageVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackageVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeletePackageVersionsWithContext(ctx aws.Context, input *DeletePackageVersionsInput, opts ...request.Option) (*DeletePackageVersionsOutput, error) {
	req, out := c.DeletePackageVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepository for more information on using the DeleteRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryRequest method.
//	req, resp := client.DeleteRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepository
func (c *CodeArtifact) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for CodeArtifact.
//
// Deletes a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepository
func (c *CodeArtifact) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	return out, req.Send()
}

// DeleteRepositoryWithContext is the same as DeleteRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeleteRepositoryWithContext(ctx aws.Context, input *DeleteRepositoryInput, opts ...request.Option) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepositoryPermissionsPolicy = "DeleteRepositoryPermissionsPolicy"

// DeleteRepositoryPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepositoryPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepositoryPermissionsPolicy for more information on using the DeleteRepositoryPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryPermissionsPolicyRequest method.
//	req, resp := client.DeleteRepositoryPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepositoryPermissionsPolicy
func (c *CodeArtifact) DeleteRepositoryPermissionsPolicyRequest(input *DeleteRepositoryPermissionsPolicyInput) (req *request.Request, output *DeleteRepositoryPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRepositoryPermissionsPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/repository/permissions/policies",
	}

	if input == nil {
		input = &DeleteRepositoryPermissionsPolicyInput{}
	}

	output = &DeleteRepositoryPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepositoryPermissionsPolicy API operation for CodeArtifact.
//
// Deletes the resource policy that is set on a repository. After a resource
// policy is deleted, the permissions allowed and denied by the deleted policy
// are removed. The effect of deleting a resource policy might not be immediate.
//
// Use DeleteRepositoryPermissionsPolicy with caution. After a policy is deleted,
// Amazon Web Services users, roles, and accounts lose permissions to perform
// the repository actions granted by the deleted policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DeleteRepositoryPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepositoryPermissionsPolicy
func (c *CodeArtifact) DeleteRepositoryPermissionsPolicy(input *DeleteRepositoryPermissionsPolicyInput) (*DeleteRepositoryPermissionsPolicyOutput, error) {
	req, out := c.DeleteRepositoryPermissionsPolicyRequest(input)
	return out, req.Send()
}

// DeleteRepositoryPermissionsPolicyWithContext is the same as DeleteRepositoryPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepositoryPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DeleteRepositoryPermissionsPolicyWithContext(ctx aws.Context, input *DeleteRepositoryPermissionsPolicyInput, opts ...request.Option) (*DeleteRepositoryPermissionsPolicyOutput, error) {
	req, out := c.DeleteRepositoryPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainRequest method.
//	req, resp := client.DescribeDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeDomain
func (c *CodeArtifact) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/domain",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for CodeArtifact.
//
// Returns a DomainDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html)
// object that contains information about the requested domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeDomain
func (c *CodeArtifact) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackage = "DescribePackage"

// DescribePackageRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackage for more information on using the DescribePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePackageRequest method.
//	req, resp := client.DescribePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackage
func (c *CodeArtifact) DescribePackageRequest(input *DescribePackageInput) (req *request.Request, output *DescribePackageOutput) {
	op := &request.Operation{
		Name:       opDescribePackage,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package",
	}

	if input == nil {
		input = &DescribePackageInput{}
	}

	output = &DescribePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackage API operation for CodeArtifact.
//
// Returns a PackageDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html)
// object that contains information about the requested package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DescribePackage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackage
func (c *CodeArtifact) DescribePackage(input *DescribePackageInput) (*DescribePackageOutput, error) {
	req, out := c.DescribePackageRequest(input)
	return out, req.Send()
}

// DescribePackageWithContext is the same as DescribePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DescribePackageWithContext(ctx aws.Context, input *DescribePackageInput, opts ...request.Option) (*DescribePackageOutput, error) {
	req, out := c.DescribePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackageVersion = "DescribePackageVersion"

// DescribePackageVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackageVersion for more information on using the DescribePackageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePackageVersionRequest method.
//	req, resp := client.DescribePackageVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackageVersion
func (c *CodeArtifact) DescribePackageVersionRequest(input *DescribePackageVersionInput) (req *request.Request, output *DescribePackageVersionOutput) {
	op := &request.Operation{
		Name:       opDescribePackageVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package/version",
	}

	if input == nil {
		input = &DescribePackageVersionInput{}
	}

	output = &DescribePackageVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackageVersion API operation for CodeArtifact.
//
// Returns a PackageVersionDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
// object that contains information about the requested package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DescribePackageVersion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackageVersion
func (c *CodeArtifact) DescribePackageVersion(input *DescribePackageVersionInput) (*DescribePackageVersionOutput, error) {
	req, out := c.DescribePackageVersionRequest(input)
	return out, req.Send()
}

// DescribePackageVersionWithContext is the same as DescribePackageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DescribePackageVersionWithContext(ctx aws.Context, input *DescribePackageVersionInput, opts ...request.Option) (*DescribePackageVersionOutput, error) {
	req, out := c.DescribePackageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRepository = "DescribeRepository"

// DescribeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRepository for more information on using the DescribeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRepositoryRequest method.
//	req, resp := client.DescribeRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeRepository
func (c *CodeArtifact) DescribeRepositoryRequest(input *DescribeRepositoryInput) (req *request.Request, output *DescribeRepositoryOutput) {
	op := &request.Operation{
		Name:       opDescribeRepository,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &DescribeRepositoryInput{}
	}

	output = &DescribeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRepository API operation for CodeArtifact.
//
// Returns a RepositoryDescription object that contains detailed information
// about the requested repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DescribeRepository for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeRepository
func (c *CodeArtifact) DescribeRepository(input *DescribeRepositoryInput) (*DescribeRepositoryOutput, error) {
	req, out := c.DescribeRepositoryRequest(input)
	return out, req.Send()
}

// DescribeRepositoryWithContext is the same as DescribeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DescribeRepositoryWithContext(ctx aws.Context, input *DescribeRepositoryInput, opts ...request.Option) (*DescribeRepositoryOutput, error) {
	req, out := c.DescribeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateExternalConnection = "DisassociateExternalConnection"

// DisassociateExternalConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateExternalConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateExternalConnection for more information on using the DisassociateExternalConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateExternalConnectionRequest method.
//	req, resp := client.DisassociateExternalConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisassociateExternalConnection
func (c *CodeArtifact) DisassociateExternalConnectionRequest(input *DisassociateExternalConnectionInput) (req *request.Request, output *DisassociateExternalConnectionOutput) {
	op := &request.Operation{
		Name:       opDisassociateExternalConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/repository/external-connection",
	}

	if input == nil {
		input = &DisassociateExternalConnectionInput{}
	}

	output = &DisassociateExternalConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateExternalConnection API operation for CodeArtifact.
//
// Removes an existing external connection from a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DisassociateExternalConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisassociateExternalConnection
func (c *CodeArtifact) DisassociateExternalConnection(input *DisassociateExternalConnectionInput) (*DisassociateExternalConnectionOutput, error) {
	req, out := c.DisassociateExternalConnectionRequest(input)
	return out, req.Send()
}

// DisassociateExternalConnectionWithContext is the same as DisassociateExternalConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateExternalConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DisassociateExternalConnectionWithContext(ctx aws.Context, input *DisassociateExternalConnectionInput, opts ...request.Option) (*DisassociateExternalConnectionOutput, error) {
	req, out := c.DisassociateExternalConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisposePackageVersions = "DisposePackageVersions"

// DisposePackageVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DisposePackageVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisposePackageVersions for more information on using the DisposePackageVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisposePackageVersionsRequest method.
//	req, resp := client.DisposePackageVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisposePackageVersions
func (c *CodeArtifact) DisposePackageVersionsRequest(input *DisposePackageVersionsInput) (req *request.Request, output *DisposePackageVersionsOutput) {
	op := &request.Operation{
		Name:       opDisposePackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/dispose",
	}

	if input == nil {
		input = &DisposePackageVersionsInput{}
	}

	output = &DisposePackageVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisposePackageVersions API operation for CodeArtifact.
//
// Deletes the assets in package versions and sets the package versions' status
// to Disposed. A disposed package version cannot be restored in your repository
// because its assets are deleted.
//
// To view all disposed package versions in a repository, use ListPackageVersions
// (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)
// and set the status (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax)
// parameter to Disposed.
//
// To view information about a disposed package version, use DescribePackageVersion
// (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation DisposePackageVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisposePackageVersions
func (c *CodeArtifact) DisposePackageVersions(input *DisposePackageVersionsInput) (*DisposePackageVersionsOutput, error) {
	req, out := c.DisposePackageVersionsRequest(input)
	return out, req.Send()
}

// DisposePackageVersionsWithContext is the same as DisposePackageVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DisposePackageVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) DisposePackageVersionsWithContext(ctx aws.Context, input *DisposePackageVersionsInput, opts ...request.Option) (*DisposePackageVersionsOutput, error) {
	req, out := c.DisposePackageVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAuthorizationToken = "GetAuthorizationToken"

// GetAuthorizationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizationToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizationToken for more information on using the GetAuthorizationToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAuthorizationTokenRequest method.
//	req, resp := client.GetAuthorizationTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetAuthorizationToken
func (c *CodeArtifact) GetAuthorizationTokenRequest(input *GetAuthorizationTokenInput) (req *request.Request, output *GetAuthorizationTokenOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/authorization-token",
	}

	if input == nil {
		input = &GetAuthorizationTokenInput{}
	}

	output = &GetAuthorizationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizationToken API operation for CodeArtifact.
//
// Generates a temporary authorization token for accessing repositories in the
// domain. This API requires the codeartifact:GetAuthorizationToken and sts:GetServiceBearerToken
// permissions. For more information about authorization tokens, see CodeArtifact
// authentication and tokens (https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
//
// CodeArtifact authorization tokens are valid for a period of 12 hours when
// created with the login command. You can call login periodically to refresh
// the token. When you create an authorization token with the GetAuthorizationToken
// API, you can set a custom authorization period, up to a maximum of 12 hours,
// with the durationSeconds parameter.
//
// The authorization period begins after login or GetAuthorizationToken is called.
// If login or GetAuthorizationToken is called while assuming a role, the token
// lifetime is independent of the maximum session duration of the role. For
// example, if you call sts assume-role and specify a session duration of 15
// minutes, then generate a CodeArtifact authorization token, the token will
// be valid for the full authorization period even though this is longer than
// the 15-minute session duration.
//
// See Using IAM Roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
// for more information on controlling session duration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetAuthorizationToken for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetAuthorizationToken
func (c *CodeArtifact) GetAuthorizationToken(input *GetAuthorizationTokenInput) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	return out, req.Send()
}

// GetAuthorizationTokenWithContext is the same as GetAuthorizationToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizationToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetAuthorizationTokenWithContext(ctx aws.Context, input *GetAuthorizationTokenInput, opts ...request.Option) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainPermissionsPolicy = "GetDomainPermissionsPolicy"

// GetDomainPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainPermissionsPolicy for more information on using the GetDomainPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDomainPermissionsPolicyRequest method.
//	req, resp := client.GetDomainPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetDomainPermissionsPolicy
func (c *CodeArtifact) GetDomainPermissionsPolicyRequest(input *GetDomainPermissionsPolicyInput) (req *request.Request, output *GetDomainPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opGetDomainPermissionsPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/domain/permissions/policy",
	}

	if input == nil {
		input = &GetDomainPermissionsPolicyInput{}
	}

	output = &GetDomainPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainPermissionsPolicy API operation for CodeArtifact.
//
// Returns the resource policy attached to the specified domain.
//
// The policy is a resource-based policy, not an identity-based policy. For
// more information, see Identity-based policies and resource-based policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetDomainPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetDomainPermissionsPolicy
func (c *CodeArtifact) GetDomainPermissionsPolicy(input *GetDomainPermissionsPolicyInput) (*GetDomainPermissionsPolicyOutput, error) {
	req, out := c.GetDomainPermissionsPolicyRequest(input)
	return out, req.Send()
}

// GetDomainPermissionsPolicyWithContext is the same as GetDomainPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetDomainPermissionsPolicyWithContext(ctx aws.Context, input *GetDomainPermissionsPolicyInput, opts ...request.Option) (*GetDomainPermissionsPolicyOutput, error) {
	req, out := c.GetDomainPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPackageVersionAsset = "GetPackageVersionAsset"

// GetPackageVersionAssetRequest generates a "aws/request.Request" representing the
// client's request for the GetPackageVersionAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPackageVersionAsset for more information on using the GetPackageVersionAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPackageVersionAssetRequest method.
//	req, resp := client.GetPackageVersionAssetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset
func (c *CodeArtifact) GetPackageVersionAssetRequest(input *GetPackageVersionAssetInput) (req *request.Request, output *GetPackageVersionAssetOutput) {
	op := &request.Operation{
		Name:       opGetPackageVersionAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package/version/asset",
	}

	if input == nil {
		input = &GetPackageVersionAssetInput{}
	}

	output = &GetPackageVersionAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPackageVersionAsset API operation for CodeArtifact.
//
// Returns an asset (or file) that is in a package. For example, for a Maven
// package version, use GetPackageVersionAsset to download a JAR file, a POM
// file, or any other assets in the package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetPackageVersionAsset for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset
func (c *CodeArtifact) GetPackageVersionAsset(input *GetPackageVersionAssetInput) (*GetPackageVersionAssetOutput, error) {
	req, out := c.GetPackageVersionAssetRequest(input)
	return out, req.Send()
}

// GetPackageVersionAssetWithContext is the same as GetPackageVersionAsset with the addition of
// the ability to pass a context and additional request options.
//
// See GetPackageVersionAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetPackageVersionAssetWithContext(ctx aws.Context, input *GetPackageVersionAssetInput, opts ...request.Option) (*GetPackageVersionAssetOutput, error) {
	req, out := c.GetPackageVersionAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPackageVersionReadme = "GetPackageVersionReadme"

// GetPackageVersionReadmeRequest generates a "aws/request.Request" representing the
// client's request for the GetPackageVersionReadme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPackageVersionReadme for more information on using the GetPackageVersionReadme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPackageVersionReadmeRequest method.
//	req, resp := client.GetPackageVersionReadmeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionReadme
func (c *CodeArtifact) GetPackageVersionReadmeRequest(input *GetPackageVersionReadmeInput) (req *request.Request, output *GetPackageVersionReadmeOutput) {
	op := &request.Operation{
		Name:       opGetPackageVersionReadme,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package/version/readme",
	}

	if input == nil {
		input = &GetPackageVersionReadmeInput{}
	}

	output = &GetPackageVersionReadmeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPackageVersionReadme API operation for CodeArtifact.
//
// Gets the readme file or descriptive text for a package version.
//
// The returned text might contain formatting. For example, it might contain
// formatting for Markdown or reStructuredText.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetPackageVersionReadme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionReadme
func (c *CodeArtifact) GetPackageVersionReadme(input *GetPackageVersionReadmeInput) (*GetPackageVersionReadmeOutput, error) {
	req, out := c.GetPackageVersionReadmeRequest(input)
	return out, req.Send()
}

// GetPackageVersionReadmeWithContext is the same as GetPackageVersionReadme with the addition of
// the ability to pass a context and additional request options.
//
// See GetPackageVersionReadme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetPackageVersionReadmeWithContext(ctx aws.Context, input *GetPackageVersionReadmeInput, opts ...request.Option) (*GetPackageVersionReadmeOutput, error) {
	req, out := c.GetPackageVersionReadmeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryEndpoint = "GetRepositoryEndpoint"

// GetRepositoryEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryEndpoint for more information on using the GetRepositoryEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryEndpointRequest method.
//	req, resp := client.GetRepositoryEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryEndpoint
func (c *CodeArtifact) GetRepositoryEndpointRequest(input *GetRepositoryEndpointInput) (req *request.Request, output *GetRepositoryEndpointOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/repository/endpoint",
	}

	if input == nil {
		input = &GetRepositoryEndpointInput{}
	}

	output = &GetRepositoryEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryEndpoint API operation for CodeArtifact.
//
// Returns the endpoint of a repository for a specific package format. A repository
// has one endpoint for each package format:
//
//   - maven
//
//   - npm
//
//   - nuget
//
//   - pypi
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetRepositoryEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryEndpoint
func (c *CodeArtifact) GetRepositoryEndpoint(input *GetRepositoryEndpointInput) (*GetRepositoryEndpointOutput, error) {
	req, out := c.GetRepositoryEndpointRequest(input)
	return out, req.Send()
}

// GetRepositoryEndpointWithContext is the same as GetRepositoryEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetRepositoryEndpointWithContext(ctx aws.Context, input *GetRepositoryEndpointInput, opts ...request.Option) (*GetRepositoryEndpointOutput, error) {
	req, out := c.GetRepositoryEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryPermissionsPolicy = "GetRepositoryPermissionsPolicy"

// GetRepositoryPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryPermissionsPolicy for more information on using the GetRepositoryPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryPermissionsPolicyRequest method.
//	req, resp := client.GetRepositoryPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryPermissionsPolicy
func (c *CodeArtifact) GetRepositoryPermissionsPolicyRequest(input *GetRepositoryPermissionsPolicyInput) (req *request.Request, output *GetRepositoryPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryPermissionsPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/repository/permissions/policy",
	}

	if input == nil {
		input = &GetRepositoryPermissionsPolicyInput{}
	}

	output = &GetRepositoryPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryPermissionsPolicy API operation for CodeArtifact.
//
// Returns the resource policy that is set on a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation GetRepositoryPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryPermissionsPolicy
func (c *CodeArtifact) GetRepositoryPermissionsPolicy(input *GetRepositoryPermissionsPolicyInput) (*GetRepositoryPermissionsPolicyOutput, error) {
	req, out := c.GetRepositoryPermissionsPolicyRequest(input)
	return out, req.Send()
}

// GetRepositoryPermissionsPolicyWithContext is the same as GetRepositoryPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) GetRepositoryPermissionsPolicyWithContext(ctx aws.Context, input *GetRepositoryPermissionsPolicyInput, opts ...request.Option) (*GetRepositoryPermissionsPolicyOutput, error) {
	req, out := c.GetRepositoryPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains
func (c *CodeArtifact) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for CodeArtifact.
//
// Returns a list of DomainSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
// objects for all domains owned by the Amazon Web Services account that makes
// this call. Each returned DomainSummary object contains information about
// a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains
func (c *CodeArtifact) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomains operation.
//	pageNum := 0
//	err := client.ListDomainsPages(params,
//	    func(page *codeartifact.ListDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackageVersionAssets = "ListPackageVersionAssets"

// ListPackageVersionAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListPackageVersionAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackageVersionAssets for more information on using the ListPackageVersionAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackageVersionAssetsRequest method.
//	req, resp := client.ListPackageVersionAssetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets
func (c *CodeArtifact) ListPackageVersionAssetsRequest(input *ListPackageVersionAssetsInput) (req *request.Request, output *ListPackageVersionAssetsOutput) {
	op := &request.Operation{
		Name:       opListPackageVersionAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/version/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackageVersionAssetsInput{}
	}

	output = &ListPackageVersionAssetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackageVersionAssets API operation for CodeArtifact.
//
// Returns a list of AssetSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html)
// objects for assets in a package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListPackageVersionAssets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets
func (c *CodeArtifact) ListPackageVersionAssets(input *ListPackageVersionAssetsInput) (*ListPackageVersionAssetsOutput, error) {
	req, out := c.ListPackageVersionAssetsRequest(input)
	return out, req.Send()
}

// ListPackageVersionAssetsWithContext is the same as ListPackageVersionAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackageVersionAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackageVersionAssetsWithContext(ctx aws.Context, input *ListPackageVersionAssetsInput, opts ...request.Option) (*ListPackageVersionAssetsOutput, error) {
	req, out := c.ListPackageVersionAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackageVersionAssetsPages iterates over the pages of a ListPackageVersionAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackageVersionAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPackageVersionAssets operation.
//	pageNum := 0
//	err := client.ListPackageVersionAssetsPages(params,
//	    func(page *codeartifact.ListPackageVersionAssetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListPackageVersionAssetsPages(input *ListPackageVersionAssetsInput, fn func(*ListPackageVersionAssetsOutput, bool) bool) error {
	return c.ListPackageVersionAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackageVersionAssetsPagesWithContext same as ListPackageVersionAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackageVersionAssetsPagesWithContext(ctx aws.Context, input *ListPackageVersionAssetsInput, fn func(*ListPackageVersionAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackageVersionAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackageVersionAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackageVersionAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackageVersionDependencies = "ListPackageVersionDependencies"

// ListPackageVersionDependenciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPackageVersionDependencies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackageVersionDependencies for more information on using the ListPackageVersionDependencies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackageVersionDependenciesRequest method.
//	req, resp := client.ListPackageVersionDependenciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionDependencies
func (c *CodeArtifact) ListPackageVersionDependenciesRequest(input *ListPackageVersionDependenciesInput) (req *request.Request, output *ListPackageVersionDependenciesOutput) {
	op := &request.Operation{
		Name:       opListPackageVersionDependencies,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/version/dependencies",
	}

	if input == nil {
		input = &ListPackageVersionDependenciesInput{}
	}

	output = &ListPackageVersionDependenciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackageVersionDependencies API operation for CodeArtifact.
//
// Returns the direct dependencies for a package version. The dependencies are
// returned as PackageDependency (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html)
// objects. CodeArtifact extracts the dependencies for a package version from
// the metadata file for the package format (for example, the package.json file
// for npm packages and the pom.xml file for Maven). Any package version dependencies
// that are not listed in the configuration file are not returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListPackageVersionDependencies for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionDependencies
func (c *CodeArtifact) ListPackageVersionDependencies(input *ListPackageVersionDependenciesInput) (*ListPackageVersionDependenciesOutput, error) {
	req, out := c.ListPackageVersionDependenciesRequest(input)
	return out, req.Send()
}

// ListPackageVersionDependenciesWithContext is the same as ListPackageVersionDependencies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackageVersionDependencies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackageVersionDependenciesWithContext(ctx aws.Context, input *ListPackageVersionDependenciesInput, opts ...request.Option) (*ListPackageVersionDependenciesOutput, error) {
	req, out := c.ListPackageVersionDependenciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPackageVersions = "ListPackageVersions"

// ListPackageVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPackageVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackageVersions for more information on using the ListPackageVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackageVersionsRequest method.
//	req, resp := client.ListPackageVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions
func (c *CodeArtifact) ListPackageVersionsRequest(input *ListPackageVersionsInput) (req *request.Request, output *ListPackageVersionsOutput) {
	op := &request.Operation{
		Name:       opListPackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackageVersionsInput{}
	}

	output = &ListPackageVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackageVersions API operation for CodeArtifact.
//
// Returns a list of PackageVersionSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html)
// objects for package versions in a repository that match the request parameters.
// Package versions of all statuses will be returned by default when calling
// list-package-versions with no --status parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListPackageVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions
func (c *CodeArtifact) ListPackageVersions(input *ListPackageVersionsInput) (*ListPackageVersionsOutput, error) {
	req, out := c.ListPackageVersionsRequest(input)
	return out, req.Send()
}

// ListPackageVersionsWithContext is the same as ListPackageVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackageVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackageVersionsWithContext(ctx aws.Context, input *ListPackageVersionsInput, opts ...request.Option) (*ListPackageVersionsOutput, error) {
	req, out := c.ListPackageVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackageVersionsPages iterates over the pages of a ListPackageVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackageVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPackageVersions operation.
//	pageNum := 0
//	err := client.ListPackageVersionsPages(params,
//	    func(page *codeartifact.ListPackageVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListPackageVersionsPages(input *ListPackageVersionsInput, fn func(*ListPackageVersionsOutput, bool) bool) error {
	return c.ListPackageVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackageVersionsPagesWithContext same as ListPackageVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackageVersionsPagesWithContext(ctx aws.Context, input *ListPackageVersionsInput, fn func(*ListPackageVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackageVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackageVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackageVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackages = "ListPackages"

// ListPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackages for more information on using the ListPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackagesRequest method.
//	req, resp := client.ListPackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages
func (c *CodeArtifact) ListPackagesRequest(input *ListPackagesInput) (req *request.Request, output *ListPackagesOutput) {
	op := &request.Operation{
		Name:       opListPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesInput{}
	}

	output = &ListPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackages API operation for CodeArtifact.
//
// Returns a list of PackageSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html)
// objects for packages in a repository that match the request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListPackages for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages
func (c *CodeArtifact) ListPackages(input *ListPackagesInput) (*ListPackagesOutput, error) {
	req, out := c.ListPackagesRequest(input)
	return out, req.Send()
}

// ListPackagesWithContext is the same as ListPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackagesWithContext(ctx aws.Context, input *ListPackagesInput, opts ...request.Option) (*ListPackagesOutput, error) {
	req, out := c.ListPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagesPages iterates over the pages of a ListPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPackages operation.
//	pageNum := 0
//	err := client.ListPackagesPages(params,
//	    func(page *codeartifact.ListPackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListPackagesPages(input *ListPackagesInput, fn func(*ListPackagesOutput, bool) bool) error {
	return c.ListPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagesPagesWithContext same as ListPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListPackagesPagesWithContext(ctx aws.Context, input *ListPackagesInput, fn func(*ListPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositories for more information on using the ListRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositoriesRequest method.
//	req, resp := client.ListRepositoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories
func (c *CodeArtifact) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repositories",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	output = &ListRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositories API operation for CodeArtifact.
//
// Returns a list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
// objects. Each RepositorySummary contains information about a repository in
// the specified Amazon Web Services account and that matches the input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListRepositories for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories
func (c *CodeArtifact) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	return out, req.Send()
}

// ListRepositoriesWithContext is the same as ListRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListRepositoriesWithContext(ctx aws.Context, input *ListRepositoriesInput, opts ...request.Option) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoriesPages iterates over the pages of a ListRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRepositories operation.
//	pageNum := 0
//	err := client.ListRepositoriesPages(params,
//	    func(page *codeartifact.ListRepositoriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListRepositoriesPages(input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool) error {
	return c.ListRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoriesPagesWithContext same as ListRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListRepositoriesPagesWithContext(ctx aws.Context, input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositoriesInDomain = "ListRepositoriesInDomain"

// ListRepositoriesInDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositoriesInDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositoriesInDomain for more information on using the ListRepositoriesInDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositoriesInDomainRequest method.
//	req, resp := client.ListRepositoriesInDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain
func (c *CodeArtifact) ListRepositoriesInDomainRequest(input *ListRepositoriesInDomainInput) (req *request.Request, output *ListRepositoriesInDomainOutput) {
	op := &request.Operation{
		Name:       opListRepositoriesInDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/domain/repositories",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInDomainInput{}
	}

	output = &ListRepositoriesInDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositoriesInDomain API operation for CodeArtifact.
//
// Returns a list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
// objects. Each RepositorySummary contains information about a repository in
// the specified domain and that matches the input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListRepositoriesInDomain for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain
func (c *CodeArtifact) ListRepositoriesInDomain(input *ListRepositoriesInDomainInput) (*ListRepositoriesInDomainOutput, error) {
	req, out := c.ListRepositoriesInDomainRequest(input)
	return out, req.Send()
}

// ListRepositoriesInDomainWithContext is the same as ListRepositoriesInDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositoriesInDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListRepositoriesInDomainWithContext(ctx aws.Context, input *ListRepositoriesInDomainInput, opts ...request.Option) (*ListRepositoriesInDomainOutput, error) {
	req, out := c.ListRepositoriesInDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoriesInDomainPages iterates over the pages of a ListRepositoriesInDomain operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositoriesInDomain method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRepositoriesInDomain operation.
//	pageNum := 0
//	err := client.ListRepositoriesInDomainPages(params,
//	    func(page *codeartifact.ListRepositoriesInDomainOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeArtifact) ListRepositoriesInDomainPages(input *ListRepositoriesInDomainInput, fn func(*ListRepositoriesInDomainOutput, bool) bool) error {
	return c.ListRepositoriesInDomainPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoriesInDomainPagesWithContext same as ListRepositoriesInDomainPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListRepositoriesInDomainPagesWithContext(ctx aws.Context, input *ListRepositoriesInDomainInput, fn func(*ListRepositoriesInDomainOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoriesInDomainInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoriesInDomainRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoriesInDomainOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListTagsForResource
func (c *CodeArtifact) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for CodeArtifact.
//
// Gets information about Amazon Web Services tags for a specified Amazon Resource
// Name (ARN) in CodeArtifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListTagsForResource
func (c *CodeArtifact) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishPackageVersion = "PublishPackageVersion"

// PublishPackageVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishPackageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishPackageVersion for more information on using the PublishPackageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PublishPackageVersionRequest method.
//	req, resp := client.PublishPackageVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PublishPackageVersion
func (c *CodeArtifact) PublishPackageVersionRequest(input *PublishPackageVersionInput) (req *request.Request, output *PublishPackageVersionOutput) {
	op := &request.Operation{
		Name:       opPublishPackageVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/version/publish",
	}

	if input == nil {
		input = &PublishPackageVersionInput{}
	}

	output = &PublishPackageVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishPackageVersion API operation for CodeArtifact.
//
// Creates a new package version containing one or more assets (or files).
//
// The unfinished flag can be used to keep the package version in the Unfinished
// state until all of its assets have been uploaded (see Package version status
// (https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status)
// in the CodeArtifact user guide). To set the package version’s status to
// Published, omit the unfinished flag when uploading the final asset, or set
// the status using UpdatePackageVersionStatus (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
// Once a package version’s status is set to Published, it cannot change back
// to Unfinished.
//
// Only generic packages can be published using this API. For more information,
// see Using generic packages (https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html)
// in the CodeArtifact User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation PublishPackageVersion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PublishPackageVersion
func (c *CodeArtifact) PublishPackageVersion(input *PublishPackageVersionInput) (*PublishPackageVersionOutput, error) {
	req, out := c.PublishPackageVersionRequest(input)
	return out, req.Send()
}

// PublishPackageVersionWithContext is the same as PublishPackageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishPackageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) PublishPackageVersionWithContext(ctx aws.Context, input *PublishPackageVersionInput, opts ...request.Option) (*PublishPackageVersionOutput, error) {
	req, out := c.PublishPackageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDomainPermissionsPolicy = "PutDomainPermissionsPolicy"

// PutDomainPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutDomainPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDomainPermissionsPolicy for more information on using the PutDomainPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDomainPermissionsPolicyRequest method.
//	req, resp := client.PutDomainPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutDomainPermissionsPolicy
func (c *CodeArtifact) PutDomainPermissionsPolicyRequest(input *PutDomainPermissionsPolicyInput) (req *request.Request, output *PutDomainPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opPutDomainPermissionsPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/domain/permissions/policy",
	}

	if input == nil {
		input = &PutDomainPermissionsPolicyInput{}
	}

	output = &PutDomainPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDomainPermissionsPolicy API operation for CodeArtifact.
//
// Sets a resource policy on a domain that specifies permissions to access it.
//
// When you call PutDomainPermissionsPolicy, the resource policy on the domain
// is ignored when evaluting permissions. This ensures that the owner of a domain
// cannot lock themselves out of the domain, which would prevent them from being
// able to update the resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation PutDomainPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutDomainPermissionsPolicy
func (c *CodeArtifact) PutDomainPermissionsPolicy(input *PutDomainPermissionsPolicyInput) (*PutDomainPermissionsPolicyOutput, error) {
	req, out := c.PutDomainPermissionsPolicyRequest(input)
	return out, req.Send()
}

// PutDomainPermissionsPolicyWithContext is the same as PutDomainPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutDomainPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) PutDomainPermissionsPolicyWithContext(ctx aws.Context, input *PutDomainPermissionsPolicyInput, opts ...request.Option) (*PutDomainPermissionsPolicyOutput, error) {
	req, out := c.PutDomainPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPackageOriginConfiguration = "PutPackageOriginConfiguration"

// PutPackageOriginConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutPackageOriginConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPackageOriginConfiguration for more information on using the PutPackageOriginConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPackageOriginConfigurationRequest method.
//	req, resp := client.PutPackageOriginConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutPackageOriginConfiguration
func (c *CodeArtifact) PutPackageOriginConfigurationRequest(input *PutPackageOriginConfigurationInput) (req *request.Request, output *PutPackageOriginConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutPackageOriginConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package",
	}

	if input == nil {
		input = &PutPackageOriginConfigurationInput{}
	}

	output = &PutPackageOriginConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPackageOriginConfiguration API operation for CodeArtifact.
//
// Sets the package origin configuration for a package.
//
// The package origin configuration determines how new versions of a package
// can be added to a repository. You can allow or block direct publishing of
// new package versions, or ingestion and retaining of new package versions
// from an external connection or upstream source. For more information about
// package origin controls and configuration, see Editing package origin controls
// (https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html)
// in the CodeArtifact User Guide.
//
// PutPackageOriginConfiguration can be called on a package that doesn't yet
// exist in the repository. When called on a package that does not exist, a
// package is created in the repository with no versions and the requested restrictions
// are set on the package. This can be used to preemptively block ingesting
// or retaining any versions from external connections or upstream repositories,
// or to block publishing any versions of the package into the repository before
// connecting any package managers or publishers to the repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation PutPackageOriginConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutPackageOriginConfiguration
func (c *CodeArtifact) PutPackageOriginConfiguration(input *PutPackageOriginConfigurationInput) (*PutPackageOriginConfigurationOutput, error) {
	req, out := c.PutPackageOriginConfigurationRequest(input)
	return out, req.Send()
}

// PutPackageOriginConfigurationWithContext is the same as PutPackageOriginConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutPackageOriginConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) PutPackageOriginConfigurationWithContext(ctx aws.Context, input *PutPackageOriginConfigurationInput, opts ...request.Option) (*PutPackageOriginConfigurationOutput, error) {
	req, out := c.PutPackageOriginConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRepositoryPermissionsPolicy = "PutRepositoryPermissionsPolicy"

// PutRepositoryPermissionsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutRepositoryPermissionsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRepositoryPermissionsPolicy for more information on using the PutRepositoryPermissionsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRepositoryPermissionsPolicyRequest method.
//	req, resp := client.PutRepositoryPermissionsPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutRepositoryPermissionsPolicy
func (c *CodeArtifact) PutRepositoryPermissionsPolicyRequest(input *PutRepositoryPermissionsPolicyInput) (req *request.Request, output *PutRepositoryPermissionsPolicyOutput) {
	op := &request.Operation{
		Name:       opPutRepositoryPermissionsPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/repository/permissions/policy",
	}

	if input == nil {
		input = &PutRepositoryPermissionsPolicyInput{}
	}

	output = &PutRepositoryPermissionsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRepositoryPermissionsPolicy API operation for CodeArtifact.
//
// Sets the resource policy on a repository that specifies permissions to access
// it.
//
// When you call PutRepositoryPermissionsPolicy, the resource policy on the
// repository is ignored when evaluting permissions. This ensures that the owner
// of a repository cannot lock themselves out of the repository, which would
// prevent them from being able to update the resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation PutRepositoryPermissionsPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutRepositoryPermissionsPolicy
func (c *CodeArtifact) PutRepositoryPermissionsPolicy(input *PutRepositoryPermissionsPolicyInput) (*PutRepositoryPermissionsPolicyOutput, error) {
	req, out := c.PutRepositoryPermissionsPolicyRequest(input)
	return out, req.Send()
}

// PutRepositoryPermissionsPolicyWithContext is the same as PutRepositoryPermissionsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutRepositoryPermissionsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) PutRepositoryPermissionsPolicyWithContext(ctx aws.Context, input *PutRepositoryPermissionsPolicyInput, opts ...request.Option) (*PutRepositoryPermissionsPolicyOutput, error) {
	req, out := c.PutRepositoryPermissionsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/TagResource
func (c *CodeArtifact) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tag",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for CodeArtifact.
//
// Adds or updates tags for a resource in CodeArtifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/TagResource
func (c *CodeArtifact) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UntagResource
func (c *CodeArtifact) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for CodeArtifact.
//
// Removes tags from a resource in CodeArtifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UntagResource
func (c *CodeArtifact) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePackageVersionsStatus = "UpdatePackageVersionsStatus"

// UpdatePackageVersionsStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePackageVersionsStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePackageVersionsStatus for more information on using the UpdatePackageVersionsStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePackageVersionsStatusRequest method.
//	req, resp := client.UpdatePackageVersionsStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdatePackageVersionsStatus
func (c *CodeArtifact) UpdatePackageVersionsStatusRequest(input *UpdatePackageVersionsStatusInput) (req *request.Request, output *UpdatePackageVersionsStatusOutput) {
	op := &request.Operation{
		Name:       opUpdatePackageVersionsStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/update_status",
	}

	if input == nil {
		input = &UpdatePackageVersionsStatusInput{}
	}

	output = &UpdatePackageVersionsStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePackageVersionsStatus API operation for CodeArtifact.
//
// Updates the status of one or more versions of a package. Using UpdatePackageVersionsStatus,
// you can update the status of package versions to Archived, Published, or
// Unlisted. To set the status of a package version to Disposed, use DisposePackageVersions
// (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation UpdatePackageVersionsStatus for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdatePackageVersionsStatus
func (c *CodeArtifact) UpdatePackageVersionsStatus(input *UpdatePackageVersionsStatusInput) (*UpdatePackageVersionsStatusOutput, error) {
	req, out := c.UpdatePackageVersionsStatusRequest(input)
	return out, req.Send()
}

// UpdatePackageVersionsStatusWithContext is the same as UpdatePackageVersionsStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePackageVersionsStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) UpdatePackageVersionsStatusWithContext(ctx aws.Context, input *UpdatePackageVersionsStatusInput, opts ...request.Option) (*UpdatePackageVersionsStatusOutput, error) {
	req, out := c.UpdatePackageVersionsStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepository = "UpdateRepository"

// UpdateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRepository for more information on using the UpdateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRepositoryRequest method.
//	req, resp := client.UpdateRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdateRepository
func (c *CodeArtifact) UpdateRepositoryRequest(input *UpdateRepositoryInput) (req *request.Request, output *UpdateRepositoryOutput) {
	op := &request.Operation{
		Name:       opUpdateRepository,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &UpdateRepositoryInput{}
	}

	output = &UpdateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRepository API operation for CodeArtifact.
//
// Update the properties of a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CodeArtifact's
// API operation UpdateRepository for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The operation did not succeed because of an unauthorized access attempt.
//
//   - ConflictException
//     The operation did not succeed because prerequisites are not met.
//
//   - InternalServerException
//     The operation did not succeed because of an error that occurred inside CodeArtifact.
//
//   - ResourceNotFoundException
//     The operation did not succeed because the resource requested is not found
//     in the service.
//
//   - ServiceQuotaExceededException
//     The operation did not succeed because it would have exceeded a service limit
//     for your account.
//
//   - ThrottlingException
//     The operation did not succeed because too many requests are sent to the service.
//
//   - ValidationException
//     The operation did not succeed because a parameter in the request was sent
//     with an invalid value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdateRepository
func (c *CodeArtifact) UpdateRepository(input *UpdateRepositoryInput) (*UpdateRepositoryOutput, error) {
	req, out := c.UpdateRepositoryRequest(input)
	return out, req.Send()
}

// UpdateRepositoryWithContext is the same as UpdateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeArtifact) UpdateRepositoryWithContext(ctx aws.Context, input *UpdateRepositoryInput, opts ...request.Option) (*UpdateRepositoryOutput, error) {
	req, out := c.UpdateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The operation did not succeed because of an unauthorized access attempt.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about a package version asset.
type AssetSummary struct {
	_ struct{} `type:"structure"`

	// The hashes of the asset.
	Hashes map[string]*string `locationName:"hashes" type:"map"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The size of the asset.
	Size *int64 `locationName:"size" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSummary) GoString() string {
	return s.String()
}

// SetHashes sets the Hashes field's value.
func (s *AssetSummary) SetHashes(v map[string]*string) *AssetSummary {
	s.Hashes = v
	return s
}

// SetName sets the Name field's value.
func (s *AssetSummary) SetName(v string) *AssetSummary {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AssetSummary) SetSize(v int64) *AssetSummary {
	s.Size = &v
	return s
}

type AssociateExternalConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the external connection to add to the repository. The following
	// values are supported:
	//
	//    * public:npmjs - for the npm public repository.
	//
	//    * public:nuget-org - for the NuGet Gallery.
	//
	//    * public:pypi - for the Python Package Index.
	//
	//    * public:maven-central - for Maven Central.
	//
	//    * public:maven-googleandroid - for the Google Android repository.
	//
	//    * public:maven-gradleplugins - for the Gradle plugins repository.
	//
	//    * public:maven-commonsware - for the CommonsWare Android repository.
	//
	//    * public:maven-clojars - for the Clojars repository.
	//
	// ExternalConnection is a required field
	ExternalConnection *string `location:"querystring" locationName:"external-connection" min:"2" type:"string" required:"true"`

	// The name of the repository to which the external connection is added.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateExternalConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateExternalConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateExternalConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateExternalConnectionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.ExternalConnection == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalConnection"))
	}
	if s.ExternalConnection != nil && len(*s.ExternalConnection) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalConnection", 2))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AssociateExternalConnectionInput) SetDomain(v string) *AssociateExternalConnectionInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *AssociateExternalConnectionInput) SetDomainOwner(v string) *AssociateExternalConnectionInput {
	s.DomainOwner = &v
	return s
}

// SetExternalConnection sets the ExternalConnection field's value.
func (s *AssociateExternalConnectionInput) SetExternalConnection(v string) *AssociateExternalConnectionInput {
	s.ExternalConnection = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *AssociateExternalConnectionInput) SetRepository(v string) *AssociateExternalConnectionInput {
	s.Repository = &v
	return s
}

type AssociateExternalConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the connected repository after processing the request.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateExternalConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateExternalConnectionOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *AssociateExternalConnectionOutput) SetRepository(v *RepositoryDescription) *AssociateExternalConnectionOutput {
	s.Repository = v
	return s
}

// The operation did not succeed because prerequisites are not met.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of Amazon Web Services resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CopyPackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// Set to true to overwrite a package version that already exists in the destination
	// repository. If set to false and the package version already exists in the
	// destination repository, the package version is returned in the failedVersions
	// field of the response with an ALREADY_EXISTS error code.
	AllowOverwrite *bool `locationName:"allowOverwrite" type:"boolean"`

	// The name of the repository into which package versions are copied.
	//
	// DestinationRepository is a required field
	DestinationRepository *string `location:"querystring" locationName:"destination-repository" min:"2" type:"string" required:"true"`

	// The name of the domain that contains the source and destination repositories.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package versions to be copied.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// Set to true to copy packages from repositories that are upstream from the
	// source repository to the destination repository. The default setting is false.
	// For more information, see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	IncludeFromUpstream *bool `locationName:"includeFromUpstream" type:"boolean"`

	// The namespace of the package versions to be copied. The package version component
	// that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId. The namespace
	//    is required when copying Maven package versions.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package that contains the versions to be copied.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package versions to be copied.
	//
	// SourceRepository is a required field
	SourceRepository *string `location:"querystring" locationName:"source-repository" min:"2" type:"string" required:"true"`

	// A list of key-value pairs. The keys are package versions and the values are
	// package version revisions. A CopyPackageVersion operation succeeds if the
	// specified versions in the source repository match the specified package version
	// revision.
	//
	// You must specify versions or versionRevisions. You cannot specify both.
	VersionRevisions map[string]*string `locationName:"versionRevisions" type:"map"`

	// The versions of the package to be copied.
	//
	// You must specify versions or versionRevisions. You cannot specify both.
	Versions []*string `locationName:"versions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPackageVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyPackageVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyPackageVersionsInput"}
	if s.DestinationRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRepository"))
	}
	if s.DestinationRepository != nil && len(*s.DestinationRepository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationRepository", 2))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.SourceRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRepository"))
	}
	if s.SourceRepository != nil && len(*s.SourceRepository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRepository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowOverwrite sets the AllowOverwrite field's value.
func (s *CopyPackageVersionsInput) SetAllowOverwrite(v bool) *CopyPackageVersionsInput {
	s.AllowOverwrite = &v
	return s
}

// SetDestinationRepository sets the DestinationRepository field's value.
func (s *CopyPackageVersionsInput) SetDestinationRepository(v string) *CopyPackageVersionsInput {
	s.DestinationRepository = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CopyPackageVersionsInput) SetDomain(v string) *CopyPackageVersionsInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *CopyPackageVersionsInput) SetDomainOwner(v string) *CopyPackageVersionsInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CopyPackageVersionsInput) SetFormat(v string) *CopyPackageVersionsInput {
	s.Format = &v
	return s
}

// SetIncludeFromUpstream sets the IncludeFromUpstream field's value.
func (s *CopyPackageVersionsInput) SetIncludeFromUpstream(v bool) *CopyPackageVersionsInput {
	s.IncludeFromUpstream = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CopyPackageVersionsInput) SetNamespace(v string) *CopyPackageVersionsInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *CopyPackageVersionsInput) SetPackage(v string) *CopyPackageVersionsInput {
	s.Package = &v
	return s
}

// SetSourceRepository sets the SourceRepository field's value.
func (s *CopyPackageVersionsInput) SetSourceRepository(v string) *CopyPackageVersionsInput {
	s.SourceRepository = &v
	return s
}

// SetVersionRevisions sets the VersionRevisions field's value.
func (s *CopyPackageVersionsInput) SetVersionRevisions(v map[string]*string) *CopyPackageVersionsInput {
	s.VersionRevisions = v
	return s
}

// SetVersions sets the Versions field's value.
func (s *CopyPackageVersionsInput) SetVersions(v []*string) *CopyPackageVersionsInput {
	s.Versions = v
	return s
}

type CopyPackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of package versions that failed to copy and their error codes. The
	// possible error codes are in the PackageVersionError data type. They are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	FailedVersions map[string]*PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of the package versions that were successfully copied to your repository.
	SuccessfulVersions map[string]*SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPackageVersionsOutput) GoString() string {
	return s.String()
}

// SetFailedVersions sets the FailedVersions field's value.
func (s *CopyPackageVersionsOutput) SetFailedVersions(v map[string]*PackageVersionError) *CopyPackageVersionsOutput {
	s.FailedVersions = v
	return s
}

// SetSuccessfulVersions sets the SuccessfulVersions field's value.
func (s *CopyPackageVersionsOutput) SetSuccessfulVersions(v map[string]*SuccessfulPackageVersionInfo) *CopyPackageVersionsOutput {
	s.SuccessfulVersions = v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to create. All domain names in an Amazon Web Services
	// Region that are in the same Amazon Web Services account must be unique. The
	// domain name is used as the prefix in DNS hostnames. Do not use sensitive
	// information in a domain name because it is publicly discoverable.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The encryption key for the domain. This is used to encrypt content stored
	// in a domain. An encryption key can be a key ID, a key Amazon Resource Name
	// (ARN), a key alias, or a key alias ARN. To specify an encryptionKey, your
	// IAM role must have kms:DescribeKey and kms:CreateGrant permissions on the
	// encryption key that is used. For more information, see DescribeKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax)
	// in the Key Management Service API Reference and Key Management Service API
	// Permissions Reference (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
	// in the Key Management Service Developer Guide.
	//
	// CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric
	// CMK with your domain. For more information, see Using symmetric and asymmetric
	// keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the Key Management Service Developer Guide.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// One or more tag key-value pairs for the domain.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateDomainInput) SetDomain(v string) *CreateDomainInput {
	s.Domain = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateDomainInput) SetEncryptionKey(v string) *CreateDomainInput {
	s.EncryptionKey = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v []*Tag) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the created domain after processing the request.
	Domain *DomainDescription `locationName:"domain" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *CreateDomainOutput) SetDomain(v *DomainDescription) *CreateDomainOutput {
	s.Domain = v
	return s
}

type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A description of the created repository.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain that contains the created repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository to create.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// One or more tag key-value pairs for the repository.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A list of upstream repositories to associate with the repository. The order
	// of the upstream repositories in the list determines their priority order
	// when CodeArtifact looks for a requested package version. For more information,
	// see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	Upstreams []*UpstreamRepository `locationName:"upstreams" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Upstreams != nil {
		for i, v := range s.Upstreams {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Upstreams", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRepositoryInput) SetDescription(v string) *CreateRepositoryInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateRepositoryInput) SetDomain(v string) *CreateRepositoryInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *CreateRepositoryInput) SetDomainOwner(v string) *CreateRepositoryInput {
	s.DomainOwner = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *CreateRepositoryInput) SetRepository(v string) *CreateRepositoryInput {
	s.Repository = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRepositoryInput) SetTags(v []*Tag) *CreateRepositoryInput {
	s.Tags = v
	return s
}

// SetUpstreams sets the Upstreams field's value.
func (s *CreateRepositoryInput) SetUpstreams(v []*UpstreamRepository) *CreateRepositoryInput {
	s.Upstreams = v
	return s
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the created repository after processing the request.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *CreateRepositoryOutput) SetRepository(v *RepositoryDescription) *CreateRepositoryOutput {
	s.Repository = v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain to delete.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteDomainInput) SetDomain(v string) *DeleteDomainInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeleteDomainInput) SetDomainOwner(v string) *DeleteDomainInput {
	s.DomainOwner = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the deleted domain after processing the request.
	Domain *DomainDescription `locationName:"domain" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DeleteDomainOutput) SetDomain(v *DomainDescription) *DeleteDomainOutput {
	s.Domain = v
	return s
}

type DeleteDomainPermissionsPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain associated with the resource policy to be deleted.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The current revision of the resource policy to be deleted. This revision
	// is used for optimistic locking, which prevents others from overwriting your
	// changes to the domain's resource policy.
	PolicyRevision *string `location:"querystring" locationName:"policy-revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteDomainPermissionsPolicyInput) SetDomain(v string) *DeleteDomainPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeleteDomainPermissionsPolicyInput) SetDomainOwner(v string) *DeleteDomainPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

// SetPolicyRevision sets the PolicyRevision field's value.
func (s *DeleteDomainPermissionsPolicyInput) SetPolicyRevision(v string) *DeleteDomainPermissionsPolicyInput {
	s.PolicyRevision = &v
	return s
}

type DeleteDomainPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted resource policy after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DeleteDomainPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *DeleteDomainPermissionsPolicyOutput {
	s.Policy = v
	return s
}

type DeletePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the package to delete.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the requested package to delete.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package to delete. The package component that specifies
	// its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId. The namespace is required
	//    when deleting Maven package versions.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain corresponding components, packages
	//    of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package to delete.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package to delete.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeletePackageInput) SetDomain(v string) *DeletePackageInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeletePackageInput) SetDomainOwner(v string) *DeletePackageInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DeletePackageInput) SetFormat(v string) *DeletePackageInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeletePackageInput) SetNamespace(v string) *DeletePackageInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *DeletePackageInput) SetPackage(v string) *DeletePackageInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DeletePackageInput) SetRepository(v string) *DeletePackageInput {
	s.Repository = &v
	return s
}

type DeletePackageOutput struct {
	_ struct{} `type:"structure"`

	// Details about a package, including its format, namespace, and name.
	DeletedPackage *PackageSummary `locationName:"deletedPackage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) GoString() string {
	return s.String()
}

// SetDeletedPackage sets the DeletedPackage field's value.
func (s *DeletePackageOutput) SetDeletedPackage(v *PackageSummary) *DeletePackageOutput {
	s.DeletedPackage = v
	return s
}

type DeletePackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the package to delete.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The expected status of the package version to delete.
	ExpectedStatus *string `locationName:"expectedStatus" type:"string" enum:"PackageVersionStatus"`

	// The format of the package versions to delete.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package versions to be deleted. The package version
	// component that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId. The namespace
	//    is required when deleting Maven package versions.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package with the versions to delete.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package versions to delete.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// An array of strings that specify the versions of the package to delete.
	//
	// Versions is a required field
	Versions []*string `locationName:"versions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageVersionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.Versions == nil {
		invalidParams.Add(request.NewErrParamRequired("Versions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeletePackageVersionsInput) SetDomain(v string) *DeletePackageVersionsInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeletePackageVersionsInput) SetDomainOwner(v string) *DeletePackageVersionsInput {
	s.DomainOwner = &v
	return s
}

// SetExpectedStatus sets the ExpectedStatus field's value.
func (s *DeletePackageVersionsInput) SetExpectedStatus(v string) *DeletePackageVersionsInput {
	s.ExpectedStatus = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DeletePackageVersionsInput) SetFormat(v string) *DeletePackageVersionsInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeletePackageVersionsInput) SetNamespace(v string) *DeletePackageVersionsInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *DeletePackageVersionsInput) SetPackage(v string) *DeletePackageVersionsInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DeletePackageVersionsInput) SetRepository(v string) *DeletePackageVersionsInput {
	s.Repository = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *DeletePackageVersionsInput) SetVersions(v []*string) *DeletePackageVersionsInput {
	s.Versions = v
	return s
}

type DeletePackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A PackageVersionError object that contains a map of errors codes for the
	// deleted package that failed. The possible error codes are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	FailedVersions map[string]*PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of the package versions that were successfully deleted. The status
	// of every successful version will be Deleted.
	SuccessfulVersions map[string]*SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageVersionsOutput) GoString() string {
	return s.String()
}

// SetFailedVersions sets the FailedVersions field's value.
func (s *DeletePackageVersionsOutput) SetFailedVersions(v map[string]*PackageVersionError) *DeletePackageVersionsOutput {
	s.FailedVersions = v
	return s
}

// SetSuccessfulVersions sets the SuccessfulVersions field's value.
func (s *DeletePackageVersionsOutput) SetSuccessfulVersions(v map[string]*SuccessfulPackageVersionInfo) *DeletePackageVersionsOutput {
	s.SuccessfulVersions = v
	return s
}

type DeleteRepositoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository to delete.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository to delete.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteRepositoryInput) SetDomain(v string) *DeleteRepositoryInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeleteRepositoryInput) SetDomainOwner(v string) *DeleteRepositoryInput {
	s.DomainOwner = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryInput) SetRepository(v string) *DeleteRepositoryInput {
	s.Repository = &v
	return s
}

type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted repository after processing the request.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryOutput) SetRepository(v *RepositoryDescription) *DeleteRepositoryOutput {
	s.Repository = v
	return s
}

type DeleteRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository associated with the resource
	// policy to be deleted.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The revision of the repository's resource policy to be deleted. This revision
	// is used for optimistic locking, which prevents others from accidentally overwriting
	// your changes to the repository's resource policy.
	PolicyRevision *string `location:"querystring" locationName:"policy-revision" min:"1" type:"string"`

	// The name of the repository that is associated with the resource policy to
	// be deleted
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyRevision", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteRepositoryPermissionsPolicyInput) SetDomain(v string) *DeleteRepositoryPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DeleteRepositoryPermissionsPolicyInput) SetDomainOwner(v string) *DeleteRepositoryPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

// SetPolicyRevision sets the PolicyRevision field's value.
func (s *DeleteRepositoryPermissionsPolicyInput) SetPolicyRevision(v string) *DeleteRepositoryPermissionsPolicyInput {
	s.PolicyRevision = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryPermissionsPolicyInput) SetRepository(v string) *DeleteRepositoryPermissionsPolicyInput {
	s.Repository = &v
	return s
}

type DeleteRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted policy after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DeleteRepositoryPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *DeleteRepositoryPermissionsPolicyOutput {
	s.Policy = v
	return s
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A string that specifies the name of the requested domain.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeDomainInput) SetDomain(v string) *DescribeDomainInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DescribeDomainInput) SetDomainOwner(v string) *DescribeDomainInput {
	s.DomainOwner = &v
	return s
}

type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// Information about a domain. A domain is a container for repositories. When
	// you create a domain, it is empty until you add one or more repositories.
	Domain *DomainDescription `locationName:"domain" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DescribeDomainOutput) SetDomain(v *DomainDescription) *DescribeDomainOutput {
	s.Domain = v
	return s
}

type DescribePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the package.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the requested package.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the requested package. The package component that specifies
	// its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId. The namespace is required
	//    when requesting Maven packages.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the requested package.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the requested package.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackageInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribePackageInput) SetDomain(v string) *DescribePackageInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DescribePackageInput) SetDomainOwner(v string) *DescribePackageInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DescribePackageInput) SetFormat(v string) *DescribePackageInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribePackageInput) SetNamespace(v string) *DescribePackageInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *DescribePackageInput) SetPackage(v string) *DescribePackageInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DescribePackageInput) SetRepository(v string) *DescribePackageInput {
	s.Repository = &v
	return s
}

type DescribePackageOutput struct {
	_ struct{} `type:"structure"`

	// A PackageDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html)
	// object that contains information about the requested package.
	//
	// Package is a required field
	Package *PackageDescription `locationName:"package" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageOutput) GoString() string {
	return s.String()
}

// SetPackage sets the Package field's value.
func (s *DescribePackageOutput) SetPackage(v *PackageDescription) *DescribePackageOutput {
	s.Package = v
	return s
}

type DescribePackageVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the package
	// version.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the requested package version.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the requested package version. The package version component
	// that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the requested package version.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package version.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackageVersionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribePackageVersionInput) SetDomain(v string) *DescribePackageVersionInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DescribePackageVersionInput) SetDomainOwner(v string) *DescribePackageVersionInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DescribePackageVersionInput) SetFormat(v string) *DescribePackageVersionInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribePackageVersionInput) SetNamespace(v string) *DescribePackageVersionInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *DescribePackageVersionInput) SetPackage(v string) *DescribePackageVersionInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DescribePackageVersionInput) SetPackageVersion(v string) *DescribePackageVersionInput {
	s.PackageVersion = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DescribePackageVersionInput) SetRepository(v string) *DescribePackageVersionInput {
	s.Repository = &v
	return s
}

type DescribePackageVersionOutput struct {
	_ struct{} `type:"structure"`

	// A PackageVersionDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
	// object that contains information about the requested package version.
	//
	// PackageVersion is a required field
	PackageVersion *PackageVersionDescription `locationName:"packageVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionOutput) GoString() string {
	return s.String()
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DescribePackageVersionOutput) SetPackageVersion(v *PackageVersionDescription) *DescribePackageVersionOutput {
	s.PackageVersion = v
	return s
}

type DescribeRepositoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository to describe.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A string that specifies the name of the requested repository.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoryInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeRepositoryInput) SetDomain(v string) *DescribeRepositoryInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DescribeRepositoryInput) SetDomainOwner(v string) *DescribeRepositoryInput {
	s.DomainOwner = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DescribeRepositoryInput) SetRepository(v string) *DescribeRepositoryInput {
	s.Repository = &v
	return s
}

type DescribeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// A RepositoryDescription object that contains the requested repository information.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DescribeRepositoryOutput) SetRepository(v *RepositoryDescription) *DescribeRepositoryOutput {
	s.Repository = v
	return s
}

type DisassociateExternalConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository from which to remove
	// the external repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the external connection to be removed from the repository.
	//
	// ExternalConnection is a required field
	ExternalConnection *string `location:"querystring" locationName:"external-connection" min:"2" type:"string" required:"true"`

	// The name of the repository from which the external connection will be removed.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateExternalConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateExternalConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateExternalConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateExternalConnectionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.ExternalConnection == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalConnection"))
	}
	if s.ExternalConnection != nil && len(*s.ExternalConnection) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalConnection", 2))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DisassociateExternalConnectionInput) SetDomain(v string) *DisassociateExternalConnectionInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DisassociateExternalConnectionInput) SetDomainOwner(v string) *DisassociateExternalConnectionInput {
	s.DomainOwner = &v
	return s
}

// SetExternalConnection sets the ExternalConnection field's value.
func (s *DisassociateExternalConnectionInput) SetExternalConnection(v string) *DisassociateExternalConnectionInput {
	s.ExternalConnection = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DisassociateExternalConnectionInput) SetRepository(v string) *DisassociateExternalConnectionInput {
	s.Repository = &v
	return s
}

type DisassociateExternalConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The repository associated with the removed external connection.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateExternalConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateExternalConnectionOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DisassociateExternalConnectionOutput) SetRepository(v *RepositoryDescription) *DisassociateExternalConnectionOutput {
	s.Repository = v
	return s
}

type DisposePackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository you want to dispose.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The expected status of the package version to dispose.
	ExpectedStatus *string `locationName:"expectedStatus" type:"string" enum:"PackageVersionStatus"`

	// A format that specifies the type of package versions you want to dispose.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package versions to be disposed. The package version
	// component that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package with the versions you want to dispose.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package versions you want to
	// dispose.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// The revisions of the package versions you want to dispose.
	VersionRevisions map[string]*string `locationName:"versionRevisions" type:"map"`

	// The versions of the package you want to dispose.
	//
	// Versions is a required field
	Versions []*string `locationName:"versions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisposePackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisposePackageVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisposePackageVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisposePackageVersionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.Versions == nil {
		invalidParams.Add(request.NewErrParamRequired("Versions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DisposePackageVersionsInput) SetDomain(v string) *DisposePackageVersionsInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *DisposePackageVersionsInput) SetDomainOwner(v string) *DisposePackageVersionsInput {
	s.DomainOwner = &v
	return s
}

// SetExpectedStatus sets the ExpectedStatus field's value.
func (s *DisposePackageVersionsInput) SetExpectedStatus(v string) *DisposePackageVersionsInput {
	s.ExpectedStatus = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DisposePackageVersionsInput) SetFormat(v string) *DisposePackageVersionsInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DisposePackageVersionsInput) SetNamespace(v string) *DisposePackageVersionsInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *DisposePackageVersionsInput) SetPackage(v string) *DisposePackageVersionsInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *DisposePackageVersionsInput) SetRepository(v string) *DisposePackageVersionsInput {
	s.Repository = &v
	return s
}

// SetVersionRevisions sets the VersionRevisions field's value.
func (s *DisposePackageVersionsInput) SetVersionRevisions(v map[string]*string) *DisposePackageVersionsInput {
	s.VersionRevisions = v
	return s
}

// SetVersions sets the Versions field's value.
func (s *DisposePackageVersionsInput) SetVersions(v []*string) *DisposePackageVersionsInput {
	s.Versions = v
	return s
}

type DisposePackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A PackageVersionError object that contains a map of errors codes for the
	// disposed package versions that failed. The possible error codes are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	FailedVersions map[string]*PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of the package versions that were successfully disposed.
	SuccessfulVersions map[string]*SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisposePackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisposePackageVersionsOutput) GoString() string {
	return s.String()
}

// SetFailedVersions sets the FailedVersions field's value.
func (s *DisposePackageVersionsOutput) SetFailedVersions(v map[string]*PackageVersionError) *DisposePackageVersionsOutput {
	s.FailedVersions = v
	return s
}

// SetSuccessfulVersions sets the SuccessfulVersions field's value.
func (s *DisposePackageVersionsOutput) SetSuccessfulVersions(v map[string]*SuccessfulPackageVersionInfo) *DisposePackageVersionsOutput {
	s.SuccessfulVersions = v
	return s
}

// Information about a domain. A domain is a container for repositories. When
// you create a domain, it is empty until you add one or more repositories.
type DomainDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The total size of all assets in the domain.
	AssetSizeBytes *int64 `locationName:"assetSizeBytes" type:"long"`

	// A timestamp that represents the date and time the domain was created.
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp"`

	// The ARN of an Key Management Service (KMS) key associated with a domain.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The name of the domain.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The Amazon Web Services account ID that owns the domain.
	Owner *string `locationName:"owner" min:"12" type:"string"`

	// The number of repositories in the domain.
	RepositoryCount *int64 `locationName:"repositoryCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store
	// package assets in the domain.
	S3BucketArn *string `locationName:"s3BucketArn" min:"1" type:"string"`

	// The current status of a domain.
	Status *string `locationName:"status" type:"string" enum:"DomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainDescription) SetArn(v string) *DomainDescription {
	s.Arn = &v
	return s
}

// SetAssetSizeBytes sets the AssetSizeBytes field's value.
func (s *DomainDescription) SetAssetSizeBytes(v int64) *DomainDescription {
	s.AssetSizeBytes = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DomainDescription) SetCreatedTime(v time.Time) *DomainDescription {
	s.CreatedTime = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *DomainDescription) SetEncryptionKey(v string) *DomainDescription {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainDescription) SetName(v string) *DomainDescription {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DomainDescription) SetOwner(v string) *DomainDescription {
	s.Owner = &v
	return s
}

// SetRepositoryCount sets the RepositoryCount field's value.
func (s *DomainDescription) SetRepositoryCount(v int64) *DomainDescription {
	s.RepositoryCount = &v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *DomainDescription) SetS3BucketArn(v string) *DomainDescription {
	s.S3BucketArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainDescription) SetStatus(v string) *DomainDescription {
	s.Status = &v
	return s
}

// Information about how a package originally entered the CodeArtifact domain.
// For packages published directly to CodeArtifact, the entry point is the repository
// it was published to. For packages ingested from an external repository, the
// entry point is the external connection that it was ingested from. An external
// connection is a CodeArtifact repository that is connected to an external
// repository such as the npm registry or NuGet gallery.
type DomainEntryPoint struct {
	_ struct{} `type:"structure"`

	// The name of the external connection that a package was ingested from.
	ExternalConnectionName *string `locationName:"externalConnectionName" min:"2" type:"string"`

	// The name of the repository that a package was originally published to.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEntryPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEntryPoint) GoString() string {
	return s.String()
}

// SetExternalConnectionName sets the ExternalConnectionName field's value.
func (s *DomainEntryPoint) SetExternalConnectionName(v string) *DomainEntryPoint {
	s.ExternalConnectionName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DomainEntryPoint) SetRepositoryName(v string) *DomainEntryPoint {
	s.RepositoryName = &v
	return s
}

// Information about a domain, including its name, Amazon Resource Name (ARN),
// and status. The ListDomains (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html)
// operation returns a list of DomainSummary objects.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A timestamp that contains the date and time the domain was created.
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp"`

	// The key used to encrypt the domain.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The name of the domain.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	Owner *string `locationName:"owner" min:"12" type:"string"`

	// A string that contains the status of the domain.
	Status *string `locationName:"status" type:"string" enum:"DomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainSummary) SetArn(v string) *DomainSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DomainSummary) SetCreatedTime(v time.Time) *DomainSummary {
	s.CreatedTime = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *DomainSummary) SetEncryptionKey(v string) *DomainSummary {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainSummary) SetName(v string) *DomainSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DomainSummary) SetOwner(v string) *DomainSummary {
	s.Owner = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainSummary) SetStatus(v string) *DomainSummary {
	s.Status = &v
	return s
}

type GetAuthorizationTokenInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that is in scope for the generated authorization token.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The time, in seconds, that the generated authorization token is valid. Valid
	// values are 0 and any number between 900 (15 minutes) and 43200 (12 hours).
	// A value of 0 will set the expiration of the authorization token to the same
	// expiration of the user's role's temporary credentials.
	DurationSeconds *int64 `location:"querystring" locationName:"duration" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizationTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizationTokenInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetAuthorizationTokenInput) SetDomain(v string) *GetAuthorizationTokenInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetAuthorizationTokenInput) SetDomainOwner(v string) *GetAuthorizationTokenInput {
	s.DomainOwner = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetAuthorizationTokenInput) SetDurationSeconds(v int64) *GetAuthorizationTokenInput {
	s.DurationSeconds = &v
	return s
}

type GetAuthorizationTokenOutput struct {
	_ struct{} `type:"structure"`

	// The returned authentication token.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// A timestamp that specifies the date and time the authorization token expires.
	Expiration *time.Time `locationName:"expiration" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenOutput) GoString() string {
	return s.String()
}

// SetAuthorizationToken sets the AuthorizationToken field's value.
func (s *GetAuthorizationTokenOutput) SetAuthorizationToken(v string) *GetAuthorizationTokenOutput {
	s.AuthorizationToken = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetAuthorizationTokenOutput) SetExpiration(v time.Time) *GetAuthorizationTokenOutput {
	s.Expiration = &v
	return s
}

type GetDomainPermissionsPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain to which the resource policy is attached.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetDomainPermissionsPolicyInput) SetDomain(v string) *GetDomainPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetDomainPermissionsPolicyInput) SetDomainOwner(v string) *GetDomainPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

type GetDomainPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The returned resource policy.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetDomainPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *GetDomainPermissionsPolicyOutput {
	s.Policy = v
	return s
}

type GetPackageVersionAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the requested asset.
	//
	// Asset is a required field
	Asset *string `location:"querystring" locationName:"asset" min:"1" type:"string" required:"true"`

	// The name of the domain that contains the repository that contains the package
	// version with the requested asset.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the package version with the requested
	// asset file.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package version with the requested asset file. The package
	// version component that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package that contains the requested asset.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the package version revision that contains the requested asset.
	PackageVersionRevision *string `location:"querystring" locationName:"revision" min:"1" type:"string"`

	// The repository that contains the package version with the requested asset.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPackageVersionAssetInput"}
	if s.Asset == nil {
		invalidParams.Add(request.NewErrParamRequired("Asset"))
	}
	if s.Asset != nil && len(*s.Asset) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Asset", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.PackageVersionRevision != nil && len(*s.PackageVersionRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersionRevision", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAsset sets the Asset field's value.
func (s *GetPackageVersionAssetInput) SetAsset(v string) *GetPackageVersionAssetInput {
	s.Asset = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *GetPackageVersionAssetInput) SetDomain(v string) *GetPackageVersionAssetInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetPackageVersionAssetInput) SetDomainOwner(v string) *GetPackageVersionAssetInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetPackageVersionAssetInput) SetFormat(v string) *GetPackageVersionAssetInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetPackageVersionAssetInput) SetNamespace(v string) *GetPackageVersionAssetInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *GetPackageVersionAssetInput) SetPackage(v string) *GetPackageVersionAssetInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *GetPackageVersionAssetInput) SetPackageVersion(v string) *GetPackageVersionAssetInput {
	s.PackageVersion = &v
	return s
}

// SetPackageVersionRevision sets the PackageVersionRevision field's value.
func (s *GetPackageVersionAssetInput) SetPackageVersionRevision(v string) *GetPackageVersionAssetInput {
	s.PackageVersionRevision = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *GetPackageVersionAssetInput) SetRepository(v string) *GetPackageVersionAssetInput {
	s.Repository = &v
	return s
}

type GetPackageVersionAssetOutput struct {
	_ struct{} `type:"structure" payload:"Asset"`

	// The binary file, or asset, that is downloaded.
	Asset io.ReadCloser `locationName:"asset" type:"blob"`

	// The name of the asset that is downloaded.
	AssetName *string `location:"header" locationName:"X-AssetName" min:"1" type:"string"`

	// A string that contains the package version (for example, 3.5.2).
	PackageVersion *string `location:"header" locationName:"X-PackageVersion" min:"1" type:"string"`

	// The name of the package version revision that contains the downloaded asset.
	PackageVersionRevision *string `location:"header" locationName:"X-PackageVersionRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionAssetOutput) GoString() string {
	return s.String()
}

// SetAsset sets the Asset field's value.
func (s *GetPackageVersionAssetOutput) SetAsset(v io.ReadCloser) *GetPackageVersionAssetOutput {
	s.Asset = v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *GetPackageVersionAssetOutput) SetAssetName(v string) *GetPackageVersionAssetOutput {
	s.AssetName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *GetPackageVersionAssetOutput) SetPackageVersion(v string) *GetPackageVersionAssetOutput {
	s.PackageVersion = &v
	return s
}

// SetPackageVersionRevision sets the PackageVersionRevision field's value.
func (s *GetPackageVersionAssetOutput) SetPackageVersionRevision(v string) *GetPackageVersionAssetOutput {
	s.PackageVersionRevision = &v
	return s
}

type GetPackageVersionReadmeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the package
	// version with the requested readme file.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the package version with the requested
	// readme file.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package version with the requested readme file. The
	// package version component that specifies its namespace depends on its type.
	// For example:
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package version that contains the requested readme file.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The repository that contains the package with the requested readme file.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionReadmeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionReadmeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionReadmeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPackageVersionReadmeInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetPackageVersionReadmeInput) SetDomain(v string) *GetPackageVersionReadmeInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetPackageVersionReadmeInput) SetDomainOwner(v string) *GetPackageVersionReadmeInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetPackageVersionReadmeInput) SetFormat(v string) *GetPackageVersionReadmeInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetPackageVersionReadmeInput) SetNamespace(v string) *GetPackageVersionReadmeInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *GetPackageVersionReadmeInput) SetPackage(v string) *GetPackageVersionReadmeInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *GetPackageVersionReadmeInput) SetPackageVersion(v string) *GetPackageVersionReadmeInput {
	s.PackageVersion = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *GetPackageVersionReadmeInput) SetRepository(v string) *GetPackageVersionReadmeInput {
	s.Repository = &v
	return s
}

type GetPackageVersionReadmeOutput struct {
	_ struct{} `type:"structure"`

	// The format of the package with the requested readme file.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package version with the requested readme file. The
	// package version component that specifies its namespace depends on its type.
	// For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name of the package that contains the returned readme file.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The text of the returned readme file.
	Readme *string `locationName:"readme" type:"string"`

	// The version of the package with the requested readme file.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionReadmeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionReadmeOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetPackageVersionReadmeOutput) SetFormat(v string) *GetPackageVersionReadmeOutput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetPackageVersionReadmeOutput) SetNamespace(v string) *GetPackageVersionReadmeOutput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *GetPackageVersionReadmeOutput) SetPackage(v string) *GetPackageVersionReadmeOutput {
	s.Package = &v
	return s
}

// SetReadme sets the Readme field's value.
func (s *GetPackageVersionReadmeOutput) SetReadme(v string) *GetPackageVersionReadmeOutput {
	s.Readme = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetPackageVersionReadmeOutput) SetVersion(v string) *GetPackageVersionReadmeOutput {
	s.Version = &v
	return s
}

// SetVersionRevision sets the VersionRevision field's value.
func (s *GetPackageVersionReadmeOutput) SetVersionRevision(v string) *GetPackageVersionReadmeOutput {
	s.VersionRevision = &v
	return s
}

type GetRepositoryEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain that contains the repository. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// Returns which endpoint of a repository to return. A repository has one endpoint
	// for each package format.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The name of the repository.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryEndpointInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetRepositoryEndpointInput) SetDomain(v string) *GetRepositoryEndpointInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetRepositoryEndpointInput) SetDomainOwner(v string) *GetRepositoryEndpointInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetRepositoryEndpointInput) SetFormat(v string) *GetRepositoryEndpointInput {
	s.Format = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *GetRepositoryEndpointInput) SetRepository(v string) *GetRepositoryEndpointInput {
	s.Repository = &v
	return s
}

type GetRepositoryEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A string that specifies the URL of the returned endpoint.
	RepositoryEndpoint *string `locationName:"repositoryEndpoint" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryEndpointOutput) GoString() string {
	return s.String()
}

// SetRepositoryEndpoint sets the RepositoryEndpoint field's value.
func (s *GetRepositoryEndpointOutput) SetRepositoryEndpoint(v string) *GetRepositoryEndpointOutput {
	s.RepositoryEndpoint = &v
	return s
}

type GetRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain containing the repository whose associated resource
	// policy is to be retrieved.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository whose associated resource policy is to be retrieved.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetRepositoryPermissionsPolicyInput) SetDomain(v string) *GetRepositoryPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *GetRepositoryPermissionsPolicyInput) SetDomainOwner(v string) *GetRepositoryPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *GetRepositoryPermissionsPolicyInput) SetRepository(v string) *GetRepositoryPermissionsPolicyInput {
	s.Repository = &v
	return s
}

type GetRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The returned resource policy.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetRepositoryPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *GetRepositoryPermissionsPolicyOutput {
	s.Policy = v
	return s
}

// The operation did not succeed because of an error that occurred inside CodeArtifact.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details of the license data.
type LicenseInfo struct {
	_ struct{} `type:"structure"`

	// Name of the license.
	Name *string `locationName:"name" type:"string"`

	// The URL for license data.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *LicenseInfo) SetName(v string) *LicenseInfo {
	s.Name = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *LicenseInfo) SetUrl(v string) *LicenseInfo {
	s.Url = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of DomainSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html)
	// objects.
	Domains []*DomainSummary `locationName:"domains" type:"list"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *ListDomainsOutput) SetDomains(v []*DomainSummary) *ListDomainsOutput {
	s.Domains = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListPackageVersionAssetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository associated with the package
	// version assets.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package that contains the requested package version assets.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the package version that contains the requested package
	// version assets. The package version component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the package that contains the requested package version assets.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package that contains the requested
	// package version assets.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackageVersionAssetsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListPackageVersionAssetsInput) SetDomain(v string) *ListPackageVersionAssetsInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *ListPackageVersionAssetsInput) SetDomainOwner(v string) *ListPackageVersionAssetsInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionAssetsInput) SetFormat(v string) *ListPackageVersionAssetsInput {
	s.Format = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackageVersionAssetsInput) SetMaxResults(v int64) *ListPackageVersionAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionAssetsInput) SetNamespace(v string) *ListPackageVersionAssetsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionAssetsInput) SetNextToken(v string) *ListPackageVersionAssetsInput {
	s.NextToken = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionAssetsInput) SetPackage(v string) *ListPackageVersionAssetsInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *ListPackageVersionAssetsInput) SetPackageVersion(v string) *ListPackageVersionAssetsInput {
	s.PackageVersion = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListPackageVersionAssetsInput) SetRepository(v string) *ListPackageVersionAssetsInput {
	s.Repository = &v
	return s
}

type ListPackageVersionAssetsOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of AssetSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html)
	// objects.
	Assets []*AssetSummary `locationName:"assets" type:"list"`

	// The format of the package that contains the requested package version assets.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package version that contains the requested package
	// version assets. The package version component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package that contains the requested package version assets.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The version of the package associated with the requested assets.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionAssetsOutput) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *ListPackageVersionAssetsOutput) SetAssets(v []*AssetSummary) *ListPackageVersionAssetsOutput {
	s.Assets = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionAssetsOutput) SetFormat(v string) *ListPackageVersionAssetsOutput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionAssetsOutput) SetNamespace(v string) *ListPackageVersionAssetsOutput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionAssetsOutput) SetNextToken(v string) *ListPackageVersionAssetsOutput {
	s.NextToken = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionAssetsOutput) SetPackage(v string) *ListPackageVersionAssetsOutput {
	s.Package = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ListPackageVersionAssetsOutput) SetVersion(v string) *ListPackageVersionAssetsOutput {
	s.Version = &v
	return s
}

// SetVersionRevision sets the VersionRevision field's value.
func (s *ListPackageVersionAssetsOutput) SetVersionRevision(v string) *ListPackageVersionAssetsOutput {
	s.VersionRevision = &v
	return s
}

type ListPackageVersionDependenciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the requested
	// package version dependencies.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package with the requested dependencies.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package version with the requested dependencies. The
	// package version component that specifies its namespace depends on its type.
	// For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the package versions' package.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the requested package version.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionDependenciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionDependenciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackageVersionDependenciesInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListPackageVersionDependenciesInput) SetDomain(v string) *ListPackageVersionDependenciesInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *ListPackageVersionDependenciesInput) SetDomainOwner(v string) *ListPackageVersionDependenciesInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionDependenciesInput) SetFormat(v string) *ListPackageVersionDependenciesInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionDependenciesInput) SetNamespace(v string) *ListPackageVersionDependenciesInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionDependenciesInput) SetNextToken(v string) *ListPackageVersionDependenciesInput {
	s.NextToken = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionDependenciesInput) SetPackage(v string) *ListPackageVersionDependenciesInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *ListPackageVersionDependenciesInput) SetPackageVersion(v string) *ListPackageVersionDependenciesInput {
	s.PackageVersion = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListPackageVersionDependenciesInput) SetRepository(v string) *ListPackageVersionDependenciesInput {
	s.Repository = &v
	return s
}

type ListPackageVersionDependenciesOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of PackageDependency (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html)
	// objects.
	Dependencies []*PackageDependency `locationName:"dependencies" type:"list"`

	// A format that specifies the type of the package that contains the returned
	// dependencies.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package version that contains the returned dependencies.
	// The package version component that specifies its namespace depends on its
	// type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package that contains the returned package versions dependencies.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The version of the package that is specified in the request.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionDependenciesOutput) GoString() string {
	return s.String()
}

// SetDependencies sets the Dependencies field's value.
func (s *ListPackageVersionDependenciesOutput) SetDependencies(v []*PackageDependency) *ListPackageVersionDependenciesOutput {
	s.Dependencies = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionDependenciesOutput) SetFormat(v string) *ListPackageVersionDependenciesOutput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionDependenciesOutput) SetNamespace(v string) *ListPackageVersionDependenciesOutput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionDependenciesOutput) SetNextToken(v string) *ListPackageVersionDependenciesOutput {
	s.NextToken = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionDependenciesOutput) SetPackage(v string) *ListPackageVersionDependenciesOutput {
	s.Package = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ListPackageVersionDependenciesOutput) SetVersion(v string) *ListPackageVersionDependenciesOutput {
	s.Version = &v
	return s
}

// SetVersionRevision sets the VersionRevision field's value.
func (s *ListPackageVersionDependenciesOutput) SetVersionRevision(v string) *ListPackageVersionDependenciesOutput {
	s.VersionRevision = &v
	return s
}

type ListPackageVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the requested
	// package versions.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package versions you want to list.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the package that contains the requested package versions.
	// The package component that specifies its namespace depends on its type. For
	// example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The originType used to filter package versions. Only package versions with
	// the provided originType will be returned.
	OriginType *string `location:"querystring" locationName:"originType" type:"string" enum:"PackageVersionOriginType"`

	// The name of the package for which you want to request package versions.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the requested package versions.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// How to sort the requested list of package versions.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"PackageVersionSortType"`

	// A string that filters the requested package versions by status.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"PackageVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackageVersionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListPackageVersionsInput) SetDomain(v string) *ListPackageVersionsInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *ListPackageVersionsInput) SetDomainOwner(v string) *ListPackageVersionsInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionsInput) SetFormat(v string) *ListPackageVersionsInput {
	s.Format = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackageVersionsInput) SetMaxResults(v int64) *ListPackageVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionsInput) SetNamespace(v string) *ListPackageVersionsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionsInput) SetNextToken(v string) *ListPackageVersionsInput {
	s.NextToken = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ListPackageVersionsInput) SetOriginType(v string) *ListPackageVersionsInput {
	s.OriginType = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionsInput) SetPackage(v string) *ListPackageVersionsInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListPackageVersionsInput) SetRepository(v string) *ListPackageVersionsInput {
	s.Repository = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListPackageVersionsInput) SetSortBy(v string) *ListPackageVersionsInput {
	s.SortBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListPackageVersionsInput) SetStatus(v string) *ListPackageVersionsInput {
	s.Status = &v
	return s
}

type ListPackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The default package version to display. This depends on the package format:
	//
	//    * For Maven and PyPI packages, it's the most recently published package
	//    version.
	//
	//    * For npm packages, it's the version referenced by the latest tag. If
	//    the latest tag is not set, it's the most recently published package version.
	DefaultDisplayVersion *string `locationName:"defaultDisplayVersion" min:"1" type:"string"`

	// A format of the package.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package that contains the requested package versions.
	// The package component that specifies its namespace depends on its type. For
	// example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The returned list of PackageVersionSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html)
	// objects.
	Versions []*PackageVersionSummary `locationName:"versions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageVersionsOutput) GoString() string {
	return s.String()
}

// SetDefaultDisplayVersion sets the DefaultDisplayVersion field's value.
func (s *ListPackageVersionsOutput) SetDefaultDisplayVersion(v string) *ListPackageVersionsOutput {
	s.DefaultDisplayVersion = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackageVersionsOutput) SetFormat(v string) *ListPackageVersionsOutput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackageVersionsOutput) SetNamespace(v string) *ListPackageVersionsOutput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageVersionsOutput) SetNextToken(v string) *ListPackageVersionsOutput {
	s.NextToken = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *ListPackageVersionsOutput) SetPackage(v string) *ListPackageVersionsOutput {
	s.Package = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListPackageVersionsOutput) SetVersions(v []*PackageVersionSummary) *ListPackageVersionsOutput {
	s.Versions = v
	return s
}

type ListPackagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that contains the repository that contains the requested
	// packages.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format used to filter requested packages. Only packages from the provided
	// format will be returned.
	Format *string `location:"querystring" locationName:"format" type:"string" enum:"PackageFormat"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace prefix used to filter requested packages. Only packages with
	// a namespace that starts with the provided string value are returned. Note
	// that although this option is called --namespace and not --namespace-prefix,
	// it has prefix-matching behavior.
	//
	// Each package format uses namespace as follows:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A prefix used to filter requested packages. Only packages with names that
	// start with packagePrefix are returned.
	PackagePrefix *string `location:"querystring" locationName:"package-prefix" min:"1" type:"string"`

	// The value of the Publish package origin control restriction used to filter
	// requested packages. Only packages with the provided restriction are returned.
	// For more information, see PackageOriginRestrictions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
	Publish *string `location:"querystring" locationName:"publish" type:"string" enum:"AllowPublish"`

	// The name of the repository that contains the requested packages.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// The value of the Upstream package origin control restriction used to filter
	// requested packages. Only packages with the provided restriction are returned.
	// For more information, see PackageOriginRestrictions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
	Upstream *string `location:"querystring" locationName:"upstream" type:"string" enum:"AllowUpstream"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagesInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PackagePrefix != nil && len(*s.PackagePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackagePrefix", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListPackagesInput) SetDomain(v string) *ListPackagesInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *ListPackagesInput) SetDomainOwner(v string) *ListPackagesInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListPackagesInput) SetFormat(v string) *ListPackagesInput {
	s.Format = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagesInput) SetMaxResults(v int64) *ListPackagesInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPackagesInput) SetNamespace(v string) *ListPackagesInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesInput) SetNextToken(v string) *ListPackagesInput {
	s.NextToken = &v
	return s
}

// SetPackagePrefix sets the PackagePrefix field's value.
func (s *ListPackagesInput) SetPackagePrefix(v string) *ListPackagesInput {
	s.PackagePrefix = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *ListPackagesInput) SetPublish(v string) *ListPackagesInput {
	s.Publish = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListPackagesInput) SetRepository(v string) *ListPackagesInput {
	s.Repository = &v
	return s
}

// SetUpstream sets the Upstream field's value.
func (s *ListPackagesInput) SetUpstream(v string) *ListPackagesInput {
	s.Upstream = &v
	return s
}

type ListPackagesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of returned PackageSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html)
	// objects.
	Packages []*PackageSummary `locationName:"packages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesOutput) SetNextToken(v string) *ListPackagesOutput {
	s.NextToken = &v
	return s
}

// SetPackages sets the Packages field's value.
func (s *ListPackagesOutput) SetPackages(v []*PackageSummary) *ListPackagesOutput {
	s.Packages = v
	return s
}

type ListRepositoriesInDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Filter the list of repositories to only include those that are managed by
	// the Amazon Web Services account ID.
	AdministratorAccount *string `location:"querystring" locationName:"administrator-account" min:"12" type:"string"`

	// The name of the domain that contains the returned list of repositories.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A prefix used to filter returned repositories. Only repositories with names
	// that start with repositoryPrefix are returned.
	RepositoryPrefix *string `location:"querystring" locationName:"repository-prefix" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoriesInDomainInput"}
	if s.AdministratorAccount != nil && len(*s.AdministratorAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AdministratorAccount", 12))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RepositoryPrefix != nil && len(*s.RepositoryPrefix) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryPrefix", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdministratorAccount sets the AdministratorAccount field's value.
func (s *ListRepositoriesInDomainInput) SetAdministratorAccount(v string) *ListRepositoriesInDomainInput {
	s.AdministratorAccount = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ListRepositoriesInDomainInput) SetDomain(v string) *ListRepositoriesInDomainInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *ListRepositoriesInDomainInput) SetDomainOwner(v string) *ListRepositoriesInDomainInput {
	s.DomainOwner = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoriesInDomainInput) SetMaxResults(v int64) *ListRepositoriesInDomainInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInDomainInput) SetNextToken(v string) *ListRepositoriesInDomainInput {
	s.NextToken = &v
	return s
}

// SetRepositoryPrefix sets the RepositoryPrefix field's value.
func (s *ListRepositoriesInDomainInput) SetRepositoryPrefix(v string) *ListRepositoriesInDomainInput {
	s.RepositoryPrefix = &v
	return s
}

type ListRepositoriesInDomainOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The returned list of repositories.
	Repositories []*RepositorySummary `locationName:"repositories" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInDomainOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInDomainOutput) SetNextToken(v string) *ListRepositoriesInDomainOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ListRepositoriesInDomainOutput) SetRepositories(v []*RepositorySummary) *ListRepositoriesInDomainOutput {
	s.Repositories = v
	return s
}

type ListRepositoriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A prefix used to filter returned repositories. Only repositories with names
	// that start with repositoryPrefix are returned.
	RepositoryPrefix *string `location:"querystring" locationName:"repository-prefix" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RepositoryPrefix != nil && len(*s.RepositoryPrefix) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryPrefix", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoriesInput) SetMaxResults(v int64) *ListRepositoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInput) SetNextToken(v string) *ListRepositoriesInput {
	s.NextToken = &v
	return s
}

// SetRepositoryPrefix sets the RepositoryPrefix field's value.
func (s *ListRepositoriesInput) SetRepositoryPrefix(v string) *ListRepositoriesInput {
	s.RepositoryPrefix = &v
	return s
}

type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The returned list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
	// objects.
	Repositories []*RepositorySummary `locationName:"repositories" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesOutput) SetNextToken(v string) *ListRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ListRepositoriesOutput) SetRepositories(v []*RepositorySummary) *ListRepositoriesOutput {
	s.Repositories = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to get tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag key and value pairs associated with the specified resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Details about a package dependency.
type PackageDependency struct {
	_ struct{} `type:"structure"`

	// The type of a package dependency. The possible values depend on the package
	// type.
	//
	//    * npm: regular, dev, peer, optional
	//
	//    * maven: optional, parent, compile, runtime, test, system, provided. Note
	//    that parent is not a regular Maven dependency type; instead this is extracted
	//    from the <parent> element if one is defined in the package version's POM
	//    file.
	//
	//    * nuget: The dependencyType field is never set for NuGet packages.
	//
	//    * pypi: Requires-Dist
	DependencyType *string `locationName:"dependencyType" type:"string"`

	// The namespace of the package that this package depends on. The package component
	// that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name of the package that this package depends on.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The required version, or version range, of the package that this package
	// depends on. The version format is specific to the package type. For example,
	// the following are possible valid required versions: 1.2.3, ^2.3.4, or 4.x.
	VersionRequirement *string `locationName:"versionRequirement" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDependency) GoString() string {
	return s.String()
}

// SetDependencyType sets the DependencyType field's value.
func (s *PackageDependency) SetDependencyType(v string) *PackageDependency {
	s.DependencyType = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PackageDependency) SetNamespace(v string) *PackageDependency {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *PackageDependency) SetPackage(v string) *PackageDependency {
	s.Package = &v
	return s
}

// SetVersionRequirement sets the VersionRequirement field's value.
func (s *PackageDependency) SetVersionRequirement(v string) *PackageDependency {
	s.VersionRequirement = &v
	return s
}

// Details about a package.
type PackageDescription struct {
	_ struct{} `type:"structure"`

	// A format that specifies the type of the package.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The name of the package.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The package origin configuration for the package.
	OriginConfiguration *PackageOriginConfiguration `locationName:"originConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDescription) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *PackageDescription) SetFormat(v string) *PackageDescription {
	s.Format = &v
	return s
}

// SetName sets the Name field's value.
func (s *PackageDescription) SetName(v string) *PackageDescription {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PackageDescription) SetNamespace(v string) *PackageDescription {
	s.Namespace = &v
	return s
}

// SetOriginConfiguration sets the OriginConfiguration field's value.
func (s *PackageDescription) SetOriginConfiguration(v *PackageOriginConfiguration) *PackageDescription {
	s.OriginConfiguration = v
	return s
}

// Details about the package origin configuration of a package.
type PackageOriginConfiguration struct {
	_ struct{} `type:"structure"`

	// A PackageOriginRestrictions object that contains information about the upstream
	// and publish package origin configuration for the package.
	Restrictions *PackageOriginRestrictions `locationName:"restrictions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageOriginConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageOriginConfiguration) GoString() string {
	return s.String()
}

// SetRestrictions sets the Restrictions field's value.
func (s *PackageOriginConfiguration) SetRestrictions(v *PackageOriginRestrictions) *PackageOriginConfiguration {
	s.Restrictions = v
	return s
}

// Details about the origin restrictions set on the package. The package origin
// restrictions determine how new versions of a package can be added to a specific
// repository.
type PackageOriginRestrictions struct {
	_ struct{} `type:"structure"`

	// The package origin configuration that determines if new versions of the package
	// can be published directly to the repository.
	//
	// Publish is a required field
	Publish *string `locationName:"publish" type:"string" required:"true" enum:"AllowPublish"`

	// The package origin configuration that determines if new versions of the package
	// can be added to the repository from an external connection or upstream source.
	//
	// Upstream is a required field
	Upstream *string `locationName:"upstream" type:"string" required:"true" enum:"AllowUpstream"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageOriginRestrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageOriginRestrictions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageOriginRestrictions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageOriginRestrictions"}
	if s.Publish == nil {
		invalidParams.Add(request.NewErrParamRequired("Publish"))
	}
	if s.Upstream == nil {
		invalidParams.Add(request.NewErrParamRequired("Upstream"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPublish sets the Publish field's value.
func (s *PackageOriginRestrictions) SetPublish(v string) *PackageOriginRestrictions {
	s.Publish = &v
	return s
}

// SetUpstream sets the Upstream field's value.
func (s *PackageOriginRestrictions) SetUpstream(v string) *PackageOriginRestrictions {
	s.Upstream = &v
	return s
}

// Details about a package, including its format, namespace, and name.
type PackageSummary struct {
	_ struct{} `type:"structure"`

	// The format of the package.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// A PackageOriginConfiguration (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html)
	// object that contains a PackageOriginRestrictions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html)
	// object that contains information about the upstream and publish package origin
	// restrictions.
	OriginConfiguration *PackageOriginConfiguration `locationName:"originConfiguration" type:"structure"`

	// The name of the package.
	Package *string `locationName:"package" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSummary) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *PackageSummary) SetFormat(v string) *PackageSummary {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PackageSummary) SetNamespace(v string) *PackageSummary {
	s.Namespace = &v
	return s
}

// SetOriginConfiguration sets the OriginConfiguration field's value.
func (s *PackageSummary) SetOriginConfiguration(v *PackageOriginConfiguration) *PackageSummary {
	s.OriginConfiguration = v
	return s
}

// SetPackage sets the Package field's value.
func (s *PackageSummary) SetPackage(v string) *PackageSummary {
	s.Package = &v
	return s
}

// Details about a package version.
type PackageVersionDescription struct {
	_ struct{} `type:"structure"`

	// The name of the package that is displayed. The displayName varies depending
	// on the package version's format. For example, if an npm package is named
	// ui, is in the namespace vue, and has the format npm, then the displayName
	// is @vue/ui.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The format of the package version.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The homepage associated with the package.
	HomePage *string `locationName:"homePage" type:"string"`

	// Information about licenses associated with the package version.
	Licenses []*LicenseInfo `locationName:"licenses" type:"list"`

	// The namespace of the package version. The package version component that
	// specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// A PackageVersionOrigin (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html)
	// object that contains information about how the package version was added
	// to the repository.
	Origin *PackageVersionOrigin `locationName:"origin" type:"structure"`

	// The name of the requested package.
	PackageName *string `locationName:"packageName" min:"1" type:"string"`

	// A timestamp that contains the date and time the package version was published.
	PublishedTime *time.Time `locationName:"publishedTime" type:"timestamp"`

	// The revision of the package version.
	Revision *string `locationName:"revision" min:"1" type:"string"`

	// The repository for the source code in the package version, or the source
	// code used to build it.
	SourceCodeRepository *string `locationName:"sourceCodeRepository" type:"string"`

	// A string that contains the status of the package version.
	Status *string `locationName:"status" type:"string" enum:"PackageVersionStatus"`

	// A summary of the package version. The summary is extracted from the package.
	// The information in and detail level of the summary depends on the package
	// version's format.
	Summary *string `locationName:"summary" type:"string"`

	// The version of the package.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionDescription) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *PackageVersionDescription) SetDisplayName(v string) *PackageVersionDescription {
	s.DisplayName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *PackageVersionDescription) SetFormat(v string) *PackageVersionDescription {
	s.Format = &v
	return s
}

// SetHomePage sets the HomePage field's value.
func (s *PackageVersionDescription) SetHomePage(v string) *PackageVersionDescription {
	s.HomePage = &v
	return s
}

// SetLicenses sets the Licenses field's value.
func (s *PackageVersionDescription) SetLicenses(v []*LicenseInfo) *PackageVersionDescription {
	s.Licenses = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PackageVersionDescription) SetNamespace(v string) *PackageVersionDescription {
	s.Namespace = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *PackageVersionDescription) SetOrigin(v *PackageVersionOrigin) *PackageVersionDescription {
	s.Origin = v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageVersionDescription) SetPackageName(v string) *PackageVersionDescription {
	s.PackageName = &v
	return s
}

// SetPublishedTime sets the PublishedTime field's value.
func (s *PackageVersionDescription) SetPublishedTime(v time.Time) *PackageVersionDescription {
	s.PublishedTime = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *PackageVersionDescription) SetRevision(v string) *PackageVersionDescription {
	s.Revision = &v
	return s
}

// SetSourceCodeRepository sets the SourceCodeRepository field's value.
func (s *PackageVersionDescription) SetSourceCodeRepository(v string) *PackageVersionDescription {
	s.SourceCodeRepository = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PackageVersionDescription) SetStatus(v string) *PackageVersionDescription {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *PackageVersionDescription) SetSummary(v string) *PackageVersionDescription {
	s.Summary = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PackageVersionDescription) SetVersion(v string) *PackageVersionDescription {
	s.Version = &v
	return s
}

// l An error associated with package.
type PackageVersionError struct {
	_ struct{} `type:"structure"`

	// The error code associated with the error. Valid error codes are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"PackageVersionErrorCode"`

	// The error message associated with the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PackageVersionError) SetErrorCode(v string) *PackageVersionError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PackageVersionError) SetErrorMessage(v string) *PackageVersionError {
	s.ErrorMessage = &v
	return s
}

// Information about how a package version was added to a repository.
type PackageVersionOrigin struct {
	_ struct{} `type:"structure"`

	// A DomainEntryPoint (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html)
	// object that contains information about from which repository or external
	// connection the package version was added to the domain.
	DomainEntryPoint *DomainEntryPoint `locationName:"domainEntryPoint" type:"structure"`

	// Describes how the package version was originally added to the domain. An
	// INTERNAL origin type means the package version was published directly to
	// a repository in the domain. An EXTERNAL origin type means the package version
	// was ingested from an external connection.
	OriginType *string `locationName:"originType" type:"string" enum:"PackageVersionOriginType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionOrigin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionOrigin) GoString() string {
	return s.String()
}

// SetDomainEntryPoint sets the DomainEntryPoint field's value.
func (s *PackageVersionOrigin) SetDomainEntryPoint(v *DomainEntryPoint) *PackageVersionOrigin {
	s.DomainEntryPoint = v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *PackageVersionOrigin) SetOriginType(v string) *PackageVersionOrigin {
	s.OriginType = &v
	return s
}

// Details about a package version, including its status, version, and revision.
// The ListPackageVersions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)
// operation returns a list of PackageVersionSummary objects.
type PackageVersionSummary struct {
	_ struct{} `type:"structure"`

	// A PackageVersionOrigin (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html)
	// object that contains information about how the package version was added
	// to the repository.
	Origin *PackageVersionOrigin `locationName:"origin" type:"structure"`

	// The revision associated with a package version.
	Revision *string `locationName:"revision" min:"1" type:"string"`

	// A string that contains the status of the package version. It can be one of
	// the following:
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"PackageVersionStatus"`

	// Information about a package version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionSummary) GoString() string {
	return s.String()
}

// SetOrigin sets the Origin field's value.
func (s *PackageVersionSummary) SetOrigin(v *PackageVersionOrigin) *PackageVersionSummary {
	s.Origin = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *PackageVersionSummary) SetRevision(v string) *PackageVersionSummary {
	s.Revision = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PackageVersionSummary) SetStatus(v string) *PackageVersionSummary {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PackageVersionSummary) SetVersion(v string) *PackageVersionSummary {
	s.Version = &v
	return s
}

type PublishPackageVersionInput struct {
	_ struct{} `type:"structure" payload:"AssetContent"`

	// The content of the asset to publish.
	//
	// AssetContent is a required field
	AssetContent io.ReadSeeker `locationName:"assetContent" type:"blob" required:"true"`

	// The name of the asset to publish. Asset names can include Unicode letters
	// and numbers, and the following special characters: ~ ! @ ^ & ( ) - ` _ +
	// [ ] { } ; , . `
	//
	// AssetName is a required field
	AssetName *string `location:"querystring" locationName:"asset" min:"1" type:"string" required:"true"`

	// The SHA256 hash of the assetContent to publish. This value must be calculated
	// by the caller and provided with the request (see Publishing a generic package
	// (https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html#publishing-generic-packages)
	// in the CodeArtifact User Guide).
	//
	// This value is used as an integrity check to verify that the assetContent
	// has not changed after it was originally sent.
	//
	// AssetSHA256 is a required field
	AssetSHA256 *string `location:"header" locationName:"x-amz-content-sha256" min:"64" type:"string" required:"true"`

	// The name of the domain that contains the repository that contains the package
	// version to publish.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the package version with the requested
	// asset file.
	//
	// The only supported value is generic.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package version to publish.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package version to publish.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The package version to publish (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that the package version will be published to.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// Specifies whether the package version should remain in the unfinished state.
	// If omitted, the package version status will be set to Published (see Package
	// version status (https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status)
	// in the CodeArtifact User Guide).
	//
	// Valid values: unfinished
	Unfinished *bool `location:"querystring" locationName:"unfinished" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishPackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishPackageVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishPackageVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishPackageVersionInput"}
	if s.AssetContent == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetContent"))
	}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetName", 1))
	}
	if s.AssetSHA256 == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetSHA256"))
	}
	if s.AssetSHA256 != nil && len(*s.AssetSHA256) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("AssetSHA256", 64))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetContent sets the AssetContent field's value.
func (s *PublishPackageVersionInput) SetAssetContent(v io.ReadSeeker) *PublishPackageVersionInput {
	s.AssetContent = v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *PublishPackageVersionInput) SetAssetName(v string) *PublishPackageVersionInput {
	s.AssetName = &v
	return s
}

// SetAssetSHA256 sets the AssetSHA256 field's value.
func (s *PublishPackageVersionInput) SetAssetSHA256(v string) *PublishPackageVersionInput {
	s.AssetSHA256 = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *PublishPackageVersionInput) SetDomain(v string) *PublishPackageVersionInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *PublishPackageVersionInput) SetDomainOwner(v string) *PublishPackageVersionInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *PublishPackageVersionInput) SetFormat(v string) *PublishPackageVersionInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PublishPackageVersionInput) SetNamespace(v string) *PublishPackageVersionInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *PublishPackageVersionInput) SetPackage(v string) *PublishPackageVersionInput {
	s.Package = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PublishPackageVersionInput) SetPackageVersion(v string) *PublishPackageVersionInput {
	s.PackageVersion = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *PublishPackageVersionInput) SetRepository(v string) *PublishPackageVersionInput {
	s.Repository = &v
	return s
}

// SetUnfinished sets the Unfinished field's value.
func (s *PublishPackageVersionInput) SetUnfinished(v bool) *PublishPackageVersionInput {
	s.Unfinished = &v
	return s
}

type PublishPackageVersionOutput struct {
	_ struct{} `type:"structure"`

	// An AssetSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html)
	// for the published asset.
	Asset *AssetSummary `locationName:"asset" type:"structure"`

	// The format of the package version.
	Format *string `locationName:"format" type:"string" enum:"PackageFormat"`

	// The namespace of the package version.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name of the package.
	Package *string `locationName:"package" min:"1" type:"string"`

	// A string that contains the status of the package version. For more information,
	// see Package version status (https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status)
	// in the CodeArtifact User Guide.
	Status *string `locationName:"status" type:"string" enum:"PackageVersionStatus"`

	// The version of the package.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The revision of the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishPackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishPackageVersionOutput) GoString() string {
	return s.String()
}

// SetAsset sets the Asset field's value.
func (s *PublishPackageVersionOutput) SetAsset(v *AssetSummary) *PublishPackageVersionOutput {
	s.Asset = v
	return s
}

// SetFormat sets the Format field's value.
func (s *PublishPackageVersionOutput) SetFormat(v string) *PublishPackageVersionOutput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PublishPackageVersionOutput) SetNamespace(v string) *PublishPackageVersionOutput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *PublishPackageVersionOutput) SetPackage(v string) *PublishPackageVersionOutput {
	s.Package = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PublishPackageVersionOutput) SetStatus(v string) *PublishPackageVersionOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PublishPackageVersionOutput) SetVersion(v string) *PublishPackageVersionOutput {
	s.Version = &v
	return s
}

// SetVersionRevision sets the VersionRevision field's value.
func (s *PublishPackageVersionOutput) SetVersionRevision(v string) *PublishPackageVersionOutput {
	s.VersionRevision = &v
	return s
}

type PutDomainPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain on which to set the resource policy.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `locationName:"domainOwner" min:"12" type:"string"`

	// A valid displayable JSON Aspen policy string to be set as the access control
	// resource policy on the provided domain.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string" required:"true"`

	// The current revision of the resource policy to be set. This revision is used
	// for optimistic locking, which prevents others from overwriting your changes
	// to the domain's resource policy.
	PolicyRevision *string `locationName:"policyRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDomainPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDomainPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDomainPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDomainPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *PutDomainPermissionsPolicyInput) SetDomain(v string) *PutDomainPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *PutDomainPermissionsPolicyInput) SetDomainOwner(v string) *PutDomainPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PutDomainPermissionsPolicyInput) SetPolicyDocument(v string) *PutDomainPermissionsPolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyRevision sets the PolicyRevision field's value.
func (s *PutDomainPermissionsPolicyInput) SetPolicyRevision(v string) *PutDomainPermissionsPolicyInput {
	s.PolicyRevision = &v
	return s
}

type PutDomainPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy that was set after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDomainPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDomainPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutDomainPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *PutDomainPermissionsPolicyOutput {
	s.Policy = v
	return s
}

type PutPackageOriginConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository that contains the package.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the package to be updated.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package to be updated. The package component that specifies
	// its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * Python and NuGet packages do not contain a corresponding component,
	//    packages of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package to be updated.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// A PackageOriginRestrictions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html)
	// object that contains information about the upstream and publish package origin
	// restrictions. The upstream restriction determines if new package versions
	// can be ingested or retained from external connections or upstream repositories.
	// The publish restriction determines if new package versions can be published
	// directly to the repository.
	//
	// You must include both the desired upstream and publish restrictions.
	//
	// Restrictions is a required field
	Restrictions *PackageOriginRestrictions `locationName:"restrictions" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPackageOriginConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPackageOriginConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPackageOriginConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPackageOriginConfigurationInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.Restrictions == nil {
		invalidParams.Add(request.NewErrParamRequired("Restrictions"))
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *PutPackageOriginConfigurationInput) SetDomain(v string) *PutPackageOriginConfigurationInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *PutPackageOriginConfigurationInput) SetDomainOwner(v string) *PutPackageOriginConfigurationInput {
	s.DomainOwner = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *PutPackageOriginConfigurationInput) SetFormat(v string) *PutPackageOriginConfigurationInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutPackageOriginConfigurationInput) SetNamespace(v string) *PutPackageOriginConfigurationInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *PutPackageOriginConfigurationInput) SetPackage(v string) *PutPackageOriginConfigurationInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *PutPackageOriginConfigurationInput) SetRepository(v string) *PutPackageOriginConfigurationInput {
	s.Repository = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *PutPackageOriginConfigurationInput) SetRestrictions(v *PackageOriginRestrictions) *PutPackageOriginConfigurationInput {
	s.Restrictions = v
	return s
}

type PutPackageOriginConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A PackageOriginConfiguration (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html)
	// object that describes the origin configuration set for the package. It contains
	// a PackageOriginRestrictions (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html)
	// object that describes how new versions of the package can be introduced to
	// the repository.
	OriginConfiguration *PackageOriginConfiguration `locationName:"originConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPackageOriginConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPackageOriginConfigurationOutput) GoString() string {
	return s.String()
}

// SetOriginConfiguration sets the OriginConfiguration field's value.
func (s *PutPackageOriginConfigurationOutput) SetOriginConfiguration(v *PackageOriginConfiguration) *PutPackageOriginConfigurationOutput {
	s.OriginConfiguration = v
	return s
}

type PutRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the repository to set the resource policy
	// on.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A valid displayable JSON Aspen policy string to be set as the access control
	// resource policy on the provided repository.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string" required:"true"`

	// Sets the revision of the resource policy that specifies permissions to access
	// the repository. This revision is used for optimistic locking, which prevents
	// others from overwriting your changes to the repository's resource policy.
	PolicyRevision *string `locationName:"policyRevision" min:"1" type:"string"`

	// The name of the repository to set the resource policy on.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryPermissionsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRepositoryPermissionsPolicyInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyRevision", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *PutRepositoryPermissionsPolicyInput) SetDomain(v string) *PutRepositoryPermissionsPolicyInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *PutRepositoryPermissionsPolicyInput) SetDomainOwner(v string) *PutRepositoryPermissionsPolicyInput {
	s.DomainOwner = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PutRepositoryPermissionsPolicyInput) SetPolicyDocument(v string) *PutRepositoryPermissionsPolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyRevision sets the PolicyRevision field's value.
func (s *PutRepositoryPermissionsPolicyInput) SetPolicyRevision(v string) *PutRepositoryPermissionsPolicyInput {
	s.PolicyRevision = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *PutRepositoryPermissionsPolicyInput) SetRepository(v string) *PutRepositoryPermissionsPolicyInput {
	s.Repository = &v
	return s
}

type PutRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy that was set after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryPermissionsPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutRepositoryPermissionsPolicyOutput) SetPolicy(v *ResourcePolicy) *PutRepositoryPermissionsPolicyOutput {
	s.Policy = v
	return s
}

// The details of a repository stored in CodeArtifact. A CodeArtifact repository
// contains a set of package versions, each of which maps to a set of assets.
// Repositories are polyglot—a single repository can contain packages of any
// supported type. Each repository exposes endpoints for fetching and publishing
// packages using tools like the npm CLI, the Maven CLI (mvn), and pip. You
// can create up to 100 repositories per Amazon Web Services account.
type RepositoryDescription struct {
	_ struct{} `type:"structure"`

	// The 12-digit account number of the Amazon Web Services account that manages
	// the repository.
	AdministratorAccount *string `locationName:"administratorAccount" min:"12" type:"string"`

	// The Amazon Resource Name (ARN) of the repository.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A timestamp that represents the date and time the repository was created.
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp"`

	// A text description of the repository.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain that contains the repository.
	DomainName *string `locationName:"domainName" min:"2" type:"string"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain that contains the repository. It does not include dashes or spaces.
	DomainOwner *string `locationName:"domainOwner" min:"12" type:"string"`

	// An array of external connections associated with the repository.
	ExternalConnections []*RepositoryExternalConnectionInfo `locationName:"externalConnections" type:"list"`

	// The name of the repository.
	Name *string `locationName:"name" min:"2" type:"string"`

	// A list of upstream repositories to associate with the repository. The order
	// of the upstream repositories in the list determines their priority order
	// when CodeArtifact looks for a requested package version. For more information,
	// see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	Upstreams []*UpstreamRepositoryInfo `locationName:"upstreams" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryDescription) GoString() string {
	return s.String()
}

// SetAdministratorAccount sets the AdministratorAccount field's value.
func (s *RepositoryDescription) SetAdministratorAccount(v string) *RepositoryDescription {
	s.AdministratorAccount = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RepositoryDescription) SetArn(v string) *RepositoryDescription {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RepositoryDescription) SetCreatedTime(v time.Time) *RepositoryDescription {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RepositoryDescription) SetDescription(v string) *RepositoryDescription {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *RepositoryDescription) SetDomainName(v string) *RepositoryDescription {
	s.DomainName = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *RepositoryDescription) SetDomainOwner(v string) *RepositoryDescription {
	s.DomainOwner = &v
	return s
}

// SetExternalConnections sets the ExternalConnections field's value.
func (s *RepositoryDescription) SetExternalConnections(v []*RepositoryExternalConnectionInfo) *RepositoryDescription {
	s.ExternalConnections = v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryDescription) SetName(v string) *RepositoryDescription {
	s.Name = &v
	return s
}

// SetUpstreams sets the Upstreams field's value.
func (s *RepositoryDescription) SetUpstreams(v []*UpstreamRepositoryInfo) *RepositoryDescription {
	s.Upstreams = v
	return s
}

// Contains information about the external connection of a repository.
type RepositoryExternalConnectionInfo struct {
	_ struct{} `type:"structure"`

	// The name of the external connection associated with a repository.
	ExternalConnectionName *string `locationName:"externalConnectionName" min:"2" type:"string"`

	// The package format associated with a repository's external connection. The
	// valid package formats are:
	//
	//    * npm: A Node Package Manager (npm) package.
	//
	//    * pypi: A Python Package Index (PyPI) package.
	//
	//    * maven: A Maven package that contains compiled code in a distributable
	//    format, such as a JAR file.
	//
	//    * nuget: A NuGet package.
	PackageFormat *string `locationName:"packageFormat" type:"string" enum:"PackageFormat"`

	// The status of the external connection of a repository. There is one valid
	// value, Available.
	Status *string `locationName:"status" type:"string" enum:"ExternalConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryExternalConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryExternalConnectionInfo) GoString() string {
	return s.String()
}

// SetExternalConnectionName sets the ExternalConnectionName field's value.
func (s *RepositoryExternalConnectionInfo) SetExternalConnectionName(v string) *RepositoryExternalConnectionInfo {
	s.ExternalConnectionName = &v
	return s
}

// SetPackageFormat sets the PackageFormat field's value.
func (s *RepositoryExternalConnectionInfo) SetPackageFormat(v string) *RepositoryExternalConnectionInfo {
	s.PackageFormat = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RepositoryExternalConnectionInfo) SetStatus(v string) *RepositoryExternalConnectionInfo {
	s.Status = &v
	return s
}

// Details about a repository, including its Amazon Resource Name (ARN), description,
// and domain information. The ListRepositories (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html)
// operation returns a list of RepositorySummary objects.
type RepositorySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that manages the repository.
	AdministratorAccount *string `locationName:"administratorAccount" min:"12" type:"string"`

	// The ARN of the repository.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A timestamp that represents the date and time the repository was created.
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp"`

	// The description of the repository.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain that contains the repository.
	DomainName *string `locationName:"domainName" min:"2" type:"string"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `locationName:"domainOwner" min:"12" type:"string"`

	// The name of the repository.
	Name *string `locationName:"name" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySummary) GoString() string {
	return s.String()
}

// SetAdministratorAccount sets the AdministratorAccount field's value.
func (s *RepositorySummary) SetAdministratorAccount(v string) *RepositorySummary {
	s.AdministratorAccount = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RepositorySummary) SetArn(v string) *RepositorySummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RepositorySummary) SetCreatedTime(v time.Time) *RepositorySummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RepositorySummary) SetDescription(v string) *RepositorySummary {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *RepositorySummary) SetDomainName(v string) *RepositorySummary {
	s.DomainName = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *RepositorySummary) SetDomainOwner(v string) *RepositorySummary {
	s.DomainOwner = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositorySummary) SetName(v string) *RepositorySummary {
	s.Name = &v
	return s
}

// The operation did not succeed because the resource requested is not found
// in the service.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of Amazon Web Services resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An CodeArtifact resource policy that contains a resource ARN, document details,
// and a revision.
type ResourcePolicy struct {
	_ struct{} `type:"structure"`

	// The resource policy formatted in JSON.
	Document *string `locationName:"document" min:"1" type:"string"`

	// The ARN of the resource associated with the resource policy
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy.
	Revision *string `locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *ResourcePolicy) SetDocument(v string) *ResourcePolicy {
	s.Document = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourcePolicy) SetResourceArn(v string) *ResourcePolicy {
	s.ResourceArn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ResourcePolicy) SetRevision(v string) *ResourcePolicy {
	s.Revision = &v
	return s
}

// The operation did not succeed because it would have exceeded a service limit
// for your account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of Amazon Web Services resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the revision and status of a package version.
type SuccessfulPackageVersionInfo struct {
	_ struct{} `type:"structure"`

	// The revision of a package version.
	Revision *string `locationName:"revision" type:"string"`

	// The status of a package version.
	Status *string `locationName:"status" type:"string" enum:"PackageVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulPackageVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuccessfulPackageVersionInfo) GoString() string {
	return s.String()
}

// SetRevision sets the Revision field's value.
func (s *SuccessfulPackageVersionInfo) SetRevision(v string) *SuccessfulPackageVersionInfo {
	s.Revision = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SuccessfulPackageVersionInfo) SetStatus(v string) *SuccessfulPackageVersionInfo {
	s.Status = &v
	return s
}

// A tag is a key-value pair that can be used to manage, search for, or filter
// resources in CodeArtifact.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to add or update
	// tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags you want to modify or add to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The operation did not succeed because too many requests are sent to the service.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The time period, in seconds, to wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove tags
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag key for each tag that you want to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdatePackageVersionsStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository that contains the package
	// versions with a status to be updated.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The package version’s expected status before it is updated. If expectedStatus
	// is provided, the package version's status is updated only if its status at
	// the time UpdatePackageVersionsStatus is called matches expectedStatus.
	ExpectedStatus *string `locationName:"expectedStatus" type:"string" enum:"PackageVersionStatus"`

	// A format that specifies the type of the package with the statuses to update.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"PackageFormat"`

	// The namespace of the package version to be updated. The package version component
	// that specifies its namespace depends on its type. For example:
	//
	//    * The namespace of a Maven package version is its groupId.
	//
	//    * The namespace of an npm package version is its scope.
	//
	//    * Python and NuGet package versions do not contain a corresponding component,
	//    package versions of those formats do not have a namespace.
	//
	//    * The namespace of a generic package is its namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package with the version statuses to update.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The repository that contains the package versions with the status you want
	// to update.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// The status you want to change the package version status to.
	//
	// TargetStatus is a required field
	TargetStatus *string `locationName:"targetStatus" type:"string" required:"true" enum:"PackageVersionStatus"`

	// A map of package versions and package version revisions. The map key is the
	// package version (for example, 3.5.2), and the map value is the package version
	// revision.
	VersionRevisions map[string]*string `locationName:"versionRevisions" type:"map"`

	// An array of strings that specify the versions of the package with the statuses
	// to update.
	//
	// Versions is a required field
	Versions []*string `locationName:"versions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageVersionsStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageVersionsStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackageVersionsStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePackageVersionsStatusInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Package == nil {
		invalidParams.Add(request.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Package", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.TargetStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetStatus"))
	}
	if s.Versions == nil {
		invalidParams.Add(request.NewErrParamRequired("Versions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *UpdatePackageVersionsStatusInput) SetDomain(v string) *UpdatePackageVersionsStatusInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *UpdatePackageVersionsStatusInput) SetDomainOwner(v string) *UpdatePackageVersionsStatusInput {
	s.DomainOwner = &v
	return s
}

// SetExpectedStatus sets the ExpectedStatus field's value.
func (s *UpdatePackageVersionsStatusInput) SetExpectedStatus(v string) *UpdatePackageVersionsStatusInput {
	s.ExpectedStatus = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *UpdatePackageVersionsStatusInput) SetFormat(v string) *UpdatePackageVersionsStatusInput {
	s.Format = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdatePackageVersionsStatusInput) SetNamespace(v string) *UpdatePackageVersionsStatusInput {
	s.Namespace = &v
	return s
}

// SetPackage sets the Package field's value.
func (s *UpdatePackageVersionsStatusInput) SetPackage(v string) *UpdatePackageVersionsStatusInput {
	s.Package = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *UpdatePackageVersionsStatusInput) SetRepository(v string) *UpdatePackageVersionsStatusInput {
	s.Repository = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *UpdatePackageVersionsStatusInput) SetTargetStatus(v string) *UpdatePackageVersionsStatusInput {
	s.TargetStatus = &v
	return s
}

// SetVersionRevisions sets the VersionRevisions field's value.
func (s *UpdatePackageVersionsStatusInput) SetVersionRevisions(v map[string]*string) *UpdatePackageVersionsStatusInput {
	s.VersionRevisions = v
	return s
}

// SetVersions sets the Versions field's value.
func (s *UpdatePackageVersionsStatusInput) SetVersions(v []*string) *UpdatePackageVersionsStatusInput {
	s.Versions = v
	return s
}

type UpdatePackageVersionsStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of SuccessfulPackageVersionInfo objects, one for each package version
	// with a status that successfully updated.
	FailedVersions map[string]*PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of PackageVersionError objects, one for each package version with
	// a status that failed to update.
	SuccessfulVersions map[string]*SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageVersionsStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageVersionsStatusOutput) GoString() string {
	return s.String()
}

// SetFailedVersions sets the FailedVersions field's value.
func (s *UpdatePackageVersionsStatusOutput) SetFailedVersions(v map[string]*PackageVersionError) *UpdatePackageVersionsStatusOutput {
	s.FailedVersions = v
	return s
}

// SetSuccessfulVersions sets the SuccessfulVersions field's value.
func (s *UpdatePackageVersionsStatusOutput) SetSuccessfulVersions(v map[string]*SuccessfulPackageVersionInfo) *UpdatePackageVersionsStatusOutput {
	s.SuccessfulVersions = v
	return s
}

type UpdateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// An updated repository description.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain associated with the repository to update.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the Amazon Web Services account that owns
	// the domain. It does not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository to update.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// A list of upstream repositories to associate with the repository. The order
	// of the upstream repositories in the list determines their priority order
	// when CodeArtifact looks for a requested package version. For more information,
	// see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	Upstreams []*UpstreamRepository `locationName:"upstreams" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Repository", 2))
	}
	if s.Upstreams != nil {
		for i, v := range s.Upstreams {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Upstreams", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRepositoryInput) SetDescription(v string) *UpdateRepositoryInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UpdateRepositoryInput) SetDomain(v string) *UpdateRepositoryInput {
	s.Domain = &v
	return s
}

// SetDomainOwner sets the DomainOwner field's value.
func (s *UpdateRepositoryInput) SetDomainOwner(v string) *UpdateRepositoryInput {
	s.DomainOwner = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *UpdateRepositoryInput) SetRepository(v string) *UpdateRepositoryInput {
	s.Repository = &v
	return s
}

// SetUpstreams sets the Upstreams field's value.
func (s *UpdateRepositoryInput) SetUpstreams(v []*UpstreamRepository) *UpdateRepositoryInput {
	s.Upstreams = v
	return s
}

type UpdateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The updated repository.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *UpdateRepositoryOutput) SetRepository(v *RepositoryDescription) *UpdateRepositoryOutput {
	s.Repository = v
	return s
}

// Information about an upstream repository. A list of UpstreamRepository objects
// is an input parameter to CreateRepository (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateRepository.html)
// and UpdateRepository (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdateRepository.html).
type UpstreamRepository struct {
	_ struct{} `type:"structure"`

	// The name of an upstream repository.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpstreamRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpstreamRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpstreamRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpstreamRepository"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpstreamRepository) SetRepositoryName(v string) *UpstreamRepository {
	s.RepositoryName = &v
	return s
}

// Information about an upstream repository.
type UpstreamRepositoryInfo struct {
	_ struct{} `type:"structure"`

	// The name of an upstream repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpstreamRepositoryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpstreamRepositoryInfo) GoString() string {
	return s.String()
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpstreamRepositoryInfo) SetRepositoryName(v string) *UpstreamRepositoryInfo {
	s.RepositoryName = &v
	return s
}

// The operation did not succeed because a parameter in the request was sent
// with an invalid value.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AllowPublishAllow is a AllowPublish enum value
	AllowPublishAllow = "ALLOW"

	// AllowPublishBlock is a AllowPublish enum value
	AllowPublishBlock = "BLOCK"
)

// AllowPublish_Values returns all elements of the AllowPublish enum
func AllowPublish_Values() []string {
	return []string{
		AllowPublishAllow,
		AllowPublishBlock,
	}
}

const (
	// AllowUpstreamAllow is a AllowUpstream enum value
	AllowUpstreamAllow = "ALLOW"

	// AllowUpstreamBlock is a AllowUpstream enum value
	AllowUpstreamBlock = "BLOCK"
)

// AllowUpstream_Values returns all elements of the AllowUpstream enum
func AllowUpstream_Values() []string {
	return []string{
		AllowUpstreamAllow,
		AllowUpstreamBlock,
	}
}

const (
	// DomainStatusActive is a DomainStatus enum value
	DomainStatusActive = "Active"

	// DomainStatusDeleted is a DomainStatus enum value
	DomainStatusDeleted = "Deleted"
)

// DomainStatus_Values returns all elements of the DomainStatus enum
func DomainStatus_Values() []string {
	return []string{
		DomainStatusActive,
		DomainStatusDeleted,
	}
}

const (
	// ExternalConnectionStatusAvailable is a ExternalConnectionStatus enum value
	ExternalConnectionStatusAvailable = "Available"
)

// ExternalConnectionStatus_Values returns all elements of the ExternalConnectionStatus enum
func ExternalConnectionStatus_Values() []string {
	return []string{
		ExternalConnectionStatusAvailable,
	}
}

const (
	// HashAlgorithmMd5 is a HashAlgorithm enum value
	HashAlgorithmMd5 = "MD5"

	// HashAlgorithmSha1 is a HashAlgorithm enum value
	HashAlgorithmSha1 = "SHA-1"

	// HashAlgorithmSha256 is a HashAlgorithm enum value
	HashAlgorithmSha256 = "SHA-256"

	// HashAlgorithmSha512 is a HashAlgorithm enum value
	HashAlgorithmSha512 = "SHA-512"
)

// HashAlgorithm_Values returns all elements of the HashAlgorithm enum
func HashAlgorithm_Values() []string {
	return []string{
		HashAlgorithmMd5,
		HashAlgorithmSha1,
		HashAlgorithmSha256,
		HashAlgorithmSha512,
	}
}

const (
	// PackageFormatNpm is a PackageFormat enum value
	PackageFormatNpm = "npm"

	// PackageFormatPypi is a PackageFormat enum value
	PackageFormatPypi = "pypi"

	// PackageFormatMaven is a PackageFormat enum value
	PackageFormatMaven = "maven"

	// PackageFormatNuget is a PackageFormat enum value
	PackageFormatNuget = "nuget"

	// PackageFormatGeneric is a PackageFormat enum value
	PackageFormatGeneric = "generic"
)

// PackageFormat_Values returns all elements of the PackageFormat enum
func PackageFormat_Values() []string {
	return []string{
		PackageFormatNpm,
		PackageFormatPypi,
		PackageFormatMaven,
		PackageFormatNuget,
		PackageFormatGeneric,
	}
}

const (
	// PackageVersionErrorCodeAlreadyExists is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeAlreadyExists = "ALREADY_EXISTS"

	// PackageVersionErrorCodeMismatchedRevision is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeMismatchedRevision = "MISMATCHED_REVISION"

	// PackageVersionErrorCodeMismatchedStatus is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeMismatchedStatus = "MISMATCHED_STATUS"

	// PackageVersionErrorCodeNotAllowed is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeNotAllowed = "NOT_ALLOWED"

	// PackageVersionErrorCodeNotFound is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeNotFound = "NOT_FOUND"

	// PackageVersionErrorCodeSkipped is a PackageVersionErrorCode enum value
	PackageVersionErrorCodeSkipped = "SKIPPED"
)

// PackageVersionErrorCode_Values returns all elements of the PackageVersionErrorCode enum
func PackageVersionErrorCode_Values() []string {
	return []string{
		PackageVersionErrorCodeAlreadyExists,
		PackageVersionErrorCodeMismatchedRevision,
		PackageVersionErrorCodeMismatchedStatus,
		PackageVersionErrorCodeNotAllowed,
		PackageVersionErrorCodeNotFound,
		PackageVersionErrorCodeSkipped,
	}
}

const (
	// PackageVersionOriginTypeInternal is a PackageVersionOriginType enum value
	PackageVersionOriginTypeInternal = "INTERNAL"

	// PackageVersionOriginTypeExternal is a PackageVersionOriginType enum value
	PackageVersionOriginTypeExternal = "EXTERNAL"

	// PackageVersionOriginTypeUnknown is a PackageVersionOriginType enum value
	PackageVersionOriginTypeUnknown = "UNKNOWN"
)

// PackageVersionOriginType_Values returns all elements of the PackageVersionOriginType enum
func PackageVersionOriginType_Values() []string {
	return []string{
		PackageVersionOriginTypeInternal,
		PackageVersionOriginTypeExternal,
		PackageVersionOriginTypeUnknown,
	}
}

const (
	// PackageVersionSortTypePublishedTime is a PackageVersionSortType enum value
	PackageVersionSortTypePublishedTime = "PUBLISHED_TIME"
)

// PackageVersionSortType_Values returns all elements of the PackageVersionSortType enum
func PackageVersionSortType_Values() []string {
	return []string{
		PackageVersionSortTypePublishedTime,
	}
}

const (
	// PackageVersionStatusPublished is a PackageVersionStatus enum value
	PackageVersionStatusPublished = "Published"

	// PackageVersionStatusUnfinished is a PackageVersionStatus enum value
	PackageVersionStatusUnfinished = "Unfinished"

	// PackageVersionStatusUnlisted is a PackageVersionStatus enum value
	PackageVersionStatusUnlisted = "Unlisted"

	// PackageVersionStatusArchived is a PackageVersionStatus enum value
	PackageVersionStatusArchived = "Archived"

	// PackageVersionStatusDisposed is a PackageVersionStatus enum value
	PackageVersionStatusDisposed = "Disposed"

	// PackageVersionStatusDeleted is a PackageVersionStatus enum value
	PackageVersionStatusDeleted = "Deleted"
)

// PackageVersionStatus_Values returns all elements of the PackageVersionStatus enum
func PackageVersionStatus_Values() []string {
	return []string{
		PackageVersionStatusPublished,
		PackageVersionStatusUnfinished,
		PackageVersionStatusUnlisted,
		PackageVersionStatusArchived,
		PackageVersionStatusDisposed,
		PackageVersionStatusDeleted,
	}
}

const (
	// ResourceTypeDomain is a ResourceType enum value
	ResourceTypeDomain = "domain"

	// ResourceTypeRepository is a ResourceType enum value
	ResourceTypeRepository = "repository"

	// ResourceTypePackage is a ResourceType enum value
	ResourceTypePackage = "package"

	// ResourceTypePackageVersion is a ResourceType enum value
	ResourceTypePackageVersion = "package-version"

	// ResourceTypeAsset is a ResourceType enum value
	ResourceTypeAsset = "asset"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeDomain,
		ResourceTypeRepository,
		ResourceTypePackage,
		ResourceTypePackageVersion,
		ResourceTypeAsset,
	}
}

const (
	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonEncryptionKeyError is a ValidationExceptionReason enum value
	ValidationExceptionReasonEncryptionKeyError = "ENCRYPTION_KEY_ERROR"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonEncryptionKeyError,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonOther,
	}
}
