/*
Copyright © LiquidWeb

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cmd

import (
	"fmt"

	"github.com/spf13/cobra"

	"github.com/liquidweb/liquidweb-cli/types/api"
)

var networkLoadBalancerGetStrategiesCmd = &cobra.Command{
	Use:   "get-strategies",
	Short: "Get available load balancing strategies",
	Long: `Get available load balancing strategies.

Gets a list of available strategies, with extra descriptive information.`,
	Run: func(cmd *cobra.Command, args []string) {
		var strategies apiTypes.NetworkLoadBalancerStrategies
		if err := lwCliInst.CallLwApiInto("bleed/network/loadbalancer/strategies",
			map[string]interface{}{}, &strategies); err != nil {
			lwCliInst.Die(err)
		}
		fmt.Print(strategies)
	},
}

func init() {
	networkLoadBalancerCmd.AddCommand(networkLoadBalancerGetStrategiesCmd)
}
