// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// OcirContainerScanRegistry Registry information for a OCI Registry target
type OcirContainerScanRegistry struct {

	// URL of the registry.
	Url *string `mandatory:"true" json:"url"`

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to perform the scans in. All listed repositories must be in the compartment.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId
	Repositories []string `mandatory:"false" json:"repositories"`
}

// GetUrl returns Url
func (m OcirContainerScanRegistry) GetUrl() *string {
	return m.Url
}

func (m OcirContainerScanRegistry) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m OcirContainerScanRegistry) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m OcirContainerScanRegistry) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeOcirContainerScanRegistry OcirContainerScanRegistry
	s := struct {
		DiscriminatorParam string `json:"type"`
		MarshalTypeOcirContainerScanRegistry
	}{
		"OCIR",
		(MarshalTypeOcirContainerScanRegistry)(m),
	}

	return json.Marshal(&s)
}
