// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostPortScanResultSortByEnum Enum with underlying type: string
type HostPortScanResultSortByEnum string

// Set of constants representing the allowable values for HostPortScanResultSortByEnum
const (
	HostPortScanResultSortByTimeStarted            HostPortScanResultSortByEnum = "timeStarted"
	HostPortScanResultSortByTimeFinished           HostPortScanResultSortByEnum = "timeFinished"
	HostPortScanResultSortByOpenPortCount          HostPortScanResultSortByEnum = "openPortCount"
	HostPortScanResultSortByHighestProblemSeverity HostPortScanResultSortByEnum = "highestProblemSeverity"
	HostPortScanResultSortByTimeCompleted          HostPortScanResultSortByEnum = "timeCompleted"
)

var mappingHostPortScanResultSortByEnum = map[string]HostPortScanResultSortByEnum{
	"timeStarted":            HostPortScanResultSortByTimeStarted,
	"timeFinished":           HostPortScanResultSortByTimeFinished,
	"openPortCount":          HostPortScanResultSortByOpenPortCount,
	"highestProblemSeverity": HostPortScanResultSortByHighestProblemSeverity,
	"timeCompleted":          HostPortScanResultSortByTimeCompleted,
}

var mappingHostPortScanResultSortByEnumLowerCase = map[string]HostPortScanResultSortByEnum{
	"timestarted":            HostPortScanResultSortByTimeStarted,
	"timefinished":           HostPortScanResultSortByTimeFinished,
	"openportcount":          HostPortScanResultSortByOpenPortCount,
	"highestproblemseverity": HostPortScanResultSortByHighestProblemSeverity,
	"timecompleted":          HostPortScanResultSortByTimeCompleted,
}

// GetHostPortScanResultSortByEnumValues Enumerates the set of values for HostPortScanResultSortByEnum
func GetHostPortScanResultSortByEnumValues() []HostPortScanResultSortByEnum {
	values := make([]HostPortScanResultSortByEnum, 0)
	for _, v := range mappingHostPortScanResultSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetHostPortScanResultSortByEnumStringValues Enumerates the set of values in String for HostPortScanResultSortByEnum
func GetHostPortScanResultSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"openPortCount",
		"highestProblemSeverity",
		"timeCompleted",
	}
}

// GetMappingHostPortScanResultSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostPortScanResultSortByEnum(val string) (HostPortScanResultSortByEnum, bool) {
	enum, ok := mappingHostPortScanResultSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
