// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Stack Monitoring API
//
// Stack Monitoring API.
//

package stackmonitoring

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// MonitoredResourcesCountAggregation The count of resources for specified dimension.
type MonitoredResourcesCountAggregation struct {

	// Qualifiers provided in a metric definition.
	// Available dimensions vary based on groupBy parameter.
	// Each dimension takes the form of a key-value pair.
	// Example: `"resourceType": "oci_autonomous_database"`
	Dimensions map[string]string `mandatory:"true" json:"dimensions"`

	// the value of this metric
	Count *int `mandatory:"true" json:"count"`
}

func (m MonitoredResourcesCountAggregation) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m MonitoredResourcesCountAggregation) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
