// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package keymanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListEkmsPrivateEndpointsRequest wrapper for the ListEkmsPrivateEndpoints operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/keymanagement/ListEkmsPrivateEndpoints.go.html to see an example of how to use ListEkmsPrivateEndpointsRequest.
type ListEkmsPrivateEndpointsRequest struct {

	// The OCID of the compartment.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return in a paginated "List" call.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the `opc-next-page` response header
	// from the previous "List" call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`).
	SortOrder ListEkmsPrivateEndpointsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. You can specify only one sort order. The default
	// order for `TIMECREATED` is descending. The default order for `DISPLAYNAME`
	// is ascending.
	SortBy ListEkmsPrivateEndpointsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// Unique identifier for the request. If provided, the returned request ID
	// will include this value. Otherwise, a random request ID will be
	// generated by the service.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListEkmsPrivateEndpointsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListEkmsPrivateEndpointsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListEkmsPrivateEndpointsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListEkmsPrivateEndpointsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListEkmsPrivateEndpointsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListEkmsPrivateEndpointsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListEkmsPrivateEndpointsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListEkmsPrivateEndpointsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListEkmsPrivateEndpointsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListEkmsPrivateEndpointsResponse wrapper for the ListEkmsPrivateEndpoints operation
type ListEkmsPrivateEndpointsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of []EkmsPrivateEndpointSummary instances
	Items []EkmsPrivateEndpointSummary `presentIn:"body"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then there are additional items still to get. Include this value as the `page` parameter for the
	// subsequent GET request. For information about pagination, see
	// List Pagination (https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about
	// a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListEkmsPrivateEndpointsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListEkmsPrivateEndpointsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListEkmsPrivateEndpointsSortOrderEnum Enum with underlying type: string
type ListEkmsPrivateEndpointsSortOrderEnum string

// Set of constants representing the allowable values for ListEkmsPrivateEndpointsSortOrderEnum
const (
	ListEkmsPrivateEndpointsSortOrderAsc  ListEkmsPrivateEndpointsSortOrderEnum = "ASC"
	ListEkmsPrivateEndpointsSortOrderDesc ListEkmsPrivateEndpointsSortOrderEnum = "DESC"
)

var mappingListEkmsPrivateEndpointsSortOrderEnum = map[string]ListEkmsPrivateEndpointsSortOrderEnum{
	"ASC":  ListEkmsPrivateEndpointsSortOrderAsc,
	"DESC": ListEkmsPrivateEndpointsSortOrderDesc,
}

var mappingListEkmsPrivateEndpointsSortOrderEnumLowerCase = map[string]ListEkmsPrivateEndpointsSortOrderEnum{
	"asc":  ListEkmsPrivateEndpointsSortOrderAsc,
	"desc": ListEkmsPrivateEndpointsSortOrderDesc,
}

// GetListEkmsPrivateEndpointsSortOrderEnumValues Enumerates the set of values for ListEkmsPrivateEndpointsSortOrderEnum
func GetListEkmsPrivateEndpointsSortOrderEnumValues() []ListEkmsPrivateEndpointsSortOrderEnum {
	values := make([]ListEkmsPrivateEndpointsSortOrderEnum, 0)
	for _, v := range mappingListEkmsPrivateEndpointsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListEkmsPrivateEndpointsSortOrderEnumStringValues Enumerates the set of values in String for ListEkmsPrivateEndpointsSortOrderEnum
func GetListEkmsPrivateEndpointsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListEkmsPrivateEndpointsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListEkmsPrivateEndpointsSortOrderEnum(val string) (ListEkmsPrivateEndpointsSortOrderEnum, bool) {
	enum, ok := mappingListEkmsPrivateEndpointsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListEkmsPrivateEndpointsSortByEnum Enum with underlying type: string
type ListEkmsPrivateEndpointsSortByEnum string

// Set of constants representing the allowable values for ListEkmsPrivateEndpointsSortByEnum
const (
	ListEkmsPrivateEndpointsSortByTimecreated ListEkmsPrivateEndpointsSortByEnum = "TIMECREATED"
	ListEkmsPrivateEndpointsSortByDisplayname ListEkmsPrivateEndpointsSortByEnum = "DISPLAYNAME"
)

var mappingListEkmsPrivateEndpointsSortByEnum = map[string]ListEkmsPrivateEndpointsSortByEnum{
	"TIMECREATED": ListEkmsPrivateEndpointsSortByTimecreated,
	"DISPLAYNAME": ListEkmsPrivateEndpointsSortByDisplayname,
}

var mappingListEkmsPrivateEndpointsSortByEnumLowerCase = map[string]ListEkmsPrivateEndpointsSortByEnum{
	"timecreated": ListEkmsPrivateEndpointsSortByTimecreated,
	"displayname": ListEkmsPrivateEndpointsSortByDisplayname,
}

// GetListEkmsPrivateEndpointsSortByEnumValues Enumerates the set of values for ListEkmsPrivateEndpointsSortByEnum
func GetListEkmsPrivateEndpointsSortByEnumValues() []ListEkmsPrivateEndpointsSortByEnum {
	values := make([]ListEkmsPrivateEndpointsSortByEnum, 0)
	for _, v := range mappingListEkmsPrivateEndpointsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListEkmsPrivateEndpointsSortByEnumStringValues Enumerates the set of values in String for ListEkmsPrivateEndpointsSortByEnum
func GetListEkmsPrivateEndpointsSortByEnumStringValues() []string {
	return []string{
		"TIMECREATED",
		"DISPLAYNAME",
	}
}

// GetMappingListEkmsPrivateEndpointsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListEkmsPrivateEndpointsSortByEnum(val string) (ListEkmsPrivateEndpointsSortByEnum, bool) {
	enum, ok := mappingListEkmsPrivateEndpointsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
