// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Tools
//
// Use the Database Tools API to manage connections, private endpoints, and work requests in the Database Tools service.
//

package databasetools

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DatabaseToolsPrivateEndpointReverseConnectionsSourceIp Source IP information for reverse connection configuration.
type DatabaseToolsPrivateEndpointReverseConnectionsSourceIp struct {

	// The IP address in the customer's VCN to be used as the source IP for reverse connection packets
	// traveling from the customer's VCN to the service's VCN.
	SourceIp *string `mandatory:"false" json:"sourceIp"`
}

func (m DatabaseToolsPrivateEndpointReverseConnectionsSourceIp) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DatabaseToolsPrivateEndpointReverseConnectionsSourceIp) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
