# Ace

Ace is a template engine create by [yossi](https://github.com/yosssi/ace), to see the original syntax documentation please [click here](https://github.com/yosssi/ace/blob/master/documentation/syntax.md)

### Basic Example

_**./views/index.ace**_
```html
= include ./views/partials/header .

h1 {{.Title}}

= include ./views/partials/footer .
```
_**./views/partials/header.ace**_
```html
h1 Header
```
_**./views/partials/footer.ace**_
```html
h1 Footer
```
_**./views/layouts/main.ace**_
```html
= doctype html
html
  head
    title Main
  body
    {{embed}}
```

```go
package main

import (
	"log"
	
	"github.com/gofiber/fiber/v2"
	"github.com/gofiber/template/ace"
)

func main() {
	// Create a new engine
	engine := ace.New("./views", ".ace")

  // Or from an embedded system
  // See github.com/gofiber/embed for examples
  // engine := html.NewFileSystem(http.Dir("./views", ".ace"))

	// Pass the engine to the Views
	app := fiber.New(fiber.Config{
		Views: engine,
	})

	app.Get("/", func(c *fiber.Ctx) error {
		// Render index
		return c.Render("index", fiber.Map{
			"Title": "Hello, World!",
		})
	})

	app.Get("/layout", func(c *fiber.Ctx) error {
		// Render index within layouts/main
		return c.Render("index", fiber.Map{
			"Title": "Hello, World!",
		}, "layouts/main")
	})

	log.Fatal(app.Listen(":3000"))
}

```
