// Code generated by internal/cmd/generator. DO NOT EDIT!
package encoder

import (
	"strings"
)

type CodeType int

const (
	CodeOp          CodeType = 0
	CodeArrayHead   CodeType = 1
	CodeArrayElem   CodeType = 2
	CodeSliceHead   CodeType = 3
	CodeSliceElem   CodeType = 4
	CodeMapHead     CodeType = 5
	CodeMapKey      CodeType = 6
	CodeMapValue    CodeType = 7
	CodeMapEnd      CodeType = 8
	CodeRecursive   CodeType = 9
	CodeStructField CodeType = 10
	CodeStructEnd   CodeType = 11
)

var opTypeStrings = [401]string{
	"End",
	"Interface",
	"Ptr",
	"SliceElem",
	"SliceEnd",
	"ArrayElem",
	"ArrayEnd",
	"MapKey",
	"MapValue",
	"MapEnd",
	"Recursive",
	"RecursivePtr",
	"RecursiveEnd",
	"InterfaceEnd",
	"StructAnonymousEnd",
	"Int",
	"Uint",
	"Float32",
	"Float64",
	"Bool",
	"String",
	"Bytes",
	"Number",
	"Array",
	"Map",
	"Slice",
	"Struct",
	"MarshalJSON",
	"MarshalText",
	"IntString",
	"UintString",
	"Float32String",
	"Float64String",
	"BoolString",
	"StringString",
	"NumberString",
	"IntPtr",
	"UintPtr",
	"Float32Ptr",
	"Float64Ptr",
	"BoolPtr",
	"StringPtr",
	"BytesPtr",
	"NumberPtr",
	"ArrayPtr",
	"MapPtr",
	"SlicePtr",
	"MarshalJSONPtr",
	"MarshalTextPtr",
	"InterfacePtr",
	"IntPtrString",
	"UintPtrString",
	"Float32PtrString",
	"Float64PtrString",
	"BoolPtrString",
	"StringPtrString",
	"NumberPtrString",
	"StructHeadInt",
	"StructHeadOmitEmptyInt",
	"StructPtrHeadInt",
	"StructPtrHeadOmitEmptyInt",
	"StructHeadUint",
	"StructHeadOmitEmptyUint",
	"StructPtrHeadUint",
	"StructPtrHeadOmitEmptyUint",
	"StructHeadFloat32",
	"StructHeadOmitEmptyFloat32",
	"StructPtrHeadFloat32",
	"StructPtrHeadOmitEmptyFloat32",
	"StructHeadFloat64",
	"StructHeadOmitEmptyFloat64",
	"StructPtrHeadFloat64",
	"StructPtrHeadOmitEmptyFloat64",
	"StructHeadBool",
	"StructHeadOmitEmptyBool",
	"StructPtrHeadBool",
	"StructPtrHeadOmitEmptyBool",
	"StructHeadString",
	"StructHeadOmitEmptyString",
	"StructPtrHeadString",
	"StructPtrHeadOmitEmptyString",
	"StructHeadBytes",
	"StructHeadOmitEmptyBytes",
	"StructPtrHeadBytes",
	"StructPtrHeadOmitEmptyBytes",
	"StructHeadNumber",
	"StructHeadOmitEmptyNumber",
	"StructPtrHeadNumber",
	"StructPtrHeadOmitEmptyNumber",
	"StructHeadArray",
	"StructHeadOmitEmptyArray",
	"StructPtrHeadArray",
	"StructPtrHeadOmitEmptyArray",
	"StructHeadMap",
	"StructHeadOmitEmptyMap",
	"StructPtrHeadMap",
	"StructPtrHeadOmitEmptyMap",
	"StructHeadSlice",
	"StructHeadOmitEmptySlice",
	"StructPtrHeadSlice",
	"StructPtrHeadOmitEmptySlice",
	"StructHeadStruct",
	"StructHeadOmitEmptyStruct",
	"StructPtrHeadStruct",
	"StructPtrHeadOmitEmptyStruct",
	"StructHeadMarshalJSON",
	"StructHeadOmitEmptyMarshalJSON",
	"StructPtrHeadMarshalJSON",
	"StructPtrHeadOmitEmptyMarshalJSON",
	"StructHeadMarshalText",
	"StructHeadOmitEmptyMarshalText",
	"StructPtrHeadMarshalText",
	"StructPtrHeadOmitEmptyMarshalText",
	"StructHeadIntString",
	"StructHeadOmitEmptyIntString",
	"StructPtrHeadIntString",
	"StructPtrHeadOmitEmptyIntString",
	"StructHeadUintString",
	"StructHeadOmitEmptyUintString",
	"StructPtrHeadUintString",
	"StructPtrHeadOmitEmptyUintString",
	"StructHeadFloat32String",
	"StructHeadOmitEmptyFloat32String",
	"StructPtrHeadFloat32String",
	"StructPtrHeadOmitEmptyFloat32String",
	"StructHeadFloat64String",
	"StructHeadOmitEmptyFloat64String",
	"StructPtrHeadFloat64String",
	"StructPtrHeadOmitEmptyFloat64String",
	"StructHeadBoolString",
	"StructHeadOmitEmptyBoolString",
	"StructPtrHeadBoolString",
	"StructPtrHeadOmitEmptyBoolString",
	"StructHeadStringString",
	"StructHeadOmitEmptyStringString",
	"StructPtrHeadStringString",
	"StructPtrHeadOmitEmptyStringString",
	"StructHeadNumberString",
	"StructHeadOmitEmptyNumberString",
	"StructPtrHeadNumberString",
	"StructPtrHeadOmitEmptyNumberString",
	"StructHeadIntPtr",
	"StructHeadOmitEmptyIntPtr",
	"StructPtrHeadIntPtr",
	"StructPtrHeadOmitEmptyIntPtr",
	"StructHeadUintPtr",
	"StructHeadOmitEmptyUintPtr",
	"StructPtrHeadUintPtr",
	"StructPtrHeadOmitEmptyUintPtr",
	"StructHeadFloat32Ptr",
	"StructHeadOmitEmptyFloat32Ptr",
	"StructPtrHeadFloat32Ptr",
	"StructPtrHeadOmitEmptyFloat32Ptr",
	"StructHeadFloat64Ptr",
	"StructHeadOmitEmptyFloat64Ptr",
	"StructPtrHeadFloat64Ptr",
	"StructPtrHeadOmitEmptyFloat64Ptr",
	"StructHeadBoolPtr",
	"StructHeadOmitEmptyBoolPtr",
	"StructPtrHeadBoolPtr",
	"StructPtrHeadOmitEmptyBoolPtr",
	"StructHeadStringPtr",
	"StructHeadOmitEmptyStringPtr",
	"StructPtrHeadStringPtr",
	"StructPtrHeadOmitEmptyStringPtr",
	"StructHeadBytesPtr",
	"StructHeadOmitEmptyBytesPtr",
	"StructPtrHeadBytesPtr",
	"StructPtrHeadOmitEmptyBytesPtr",
	"StructHeadNumberPtr",
	"StructHeadOmitEmptyNumberPtr",
	"StructPtrHeadNumberPtr",
	"StructPtrHeadOmitEmptyNumberPtr",
	"StructHeadArrayPtr",
	"StructHeadOmitEmptyArrayPtr",
	"StructPtrHeadArrayPtr",
	"StructPtrHeadOmitEmptyArrayPtr",
	"StructHeadMapPtr",
	"StructHeadOmitEmptyMapPtr",
	"StructPtrHeadMapPtr",
	"StructPtrHeadOmitEmptyMapPtr",
	"StructHeadSlicePtr",
	"StructHeadOmitEmptySlicePtr",
	"StructPtrHeadSlicePtr",
	"StructPtrHeadOmitEmptySlicePtr",
	"StructHeadMarshalJSONPtr",
	"StructHeadOmitEmptyMarshalJSONPtr",
	"StructPtrHeadMarshalJSONPtr",
	"StructPtrHeadOmitEmptyMarshalJSONPtr",
	"StructHeadMarshalTextPtr",
	"StructHeadOmitEmptyMarshalTextPtr",
	"StructPtrHeadMarshalTextPtr",
	"StructPtrHeadOmitEmptyMarshalTextPtr",
	"StructHeadInterfacePtr",
	"StructHeadOmitEmptyInterfacePtr",
	"StructPtrHeadInterfacePtr",
	"StructPtrHeadOmitEmptyInterfacePtr",
	"StructHeadIntPtrString",
	"StructHeadOmitEmptyIntPtrString",
	"StructPtrHeadIntPtrString",
	"StructPtrHeadOmitEmptyIntPtrString",
	"StructHeadUintPtrString",
	"StructHeadOmitEmptyUintPtrString",
	"StructPtrHeadUintPtrString",
	"StructPtrHeadOmitEmptyUintPtrString",
	"StructHeadFloat32PtrString",
	"StructHeadOmitEmptyFloat32PtrString",
	"StructPtrHeadFloat32PtrString",
	"StructPtrHeadOmitEmptyFloat32PtrString",
	"StructHeadFloat64PtrString",
	"StructHeadOmitEmptyFloat64PtrString",
	"StructPtrHeadFloat64PtrString",
	"StructPtrHeadOmitEmptyFloat64PtrString",
	"StructHeadBoolPtrString",
	"StructHeadOmitEmptyBoolPtrString",
	"StructPtrHeadBoolPtrString",
	"StructPtrHeadOmitEmptyBoolPtrString",
	"StructHeadStringPtrString",
	"StructHeadOmitEmptyStringPtrString",
	"StructPtrHeadStringPtrString",
	"StructPtrHeadOmitEmptyStringPtrString",
	"StructHeadNumberPtrString",
	"StructHeadOmitEmptyNumberPtrString",
	"StructPtrHeadNumberPtrString",
	"StructPtrHeadOmitEmptyNumberPtrString",
	"StructHead",
	"StructHeadOmitEmpty",
	"StructPtrHead",
	"StructPtrHeadOmitEmpty",
	"StructFieldInt",
	"StructFieldOmitEmptyInt",
	"StructEndInt",
	"StructEndOmitEmptyInt",
	"StructFieldUint",
	"StructFieldOmitEmptyUint",
	"StructEndUint",
	"StructEndOmitEmptyUint",
	"StructFieldFloat32",
	"StructFieldOmitEmptyFloat32",
	"StructEndFloat32",
	"StructEndOmitEmptyFloat32",
	"StructFieldFloat64",
	"StructFieldOmitEmptyFloat64",
	"StructEndFloat64",
	"StructEndOmitEmptyFloat64",
	"StructFieldBool",
	"StructFieldOmitEmptyBool",
	"StructEndBool",
	"StructEndOmitEmptyBool",
	"StructFieldString",
	"StructFieldOmitEmptyString",
	"StructEndString",
	"StructEndOmitEmptyString",
	"StructFieldBytes",
	"StructFieldOmitEmptyBytes",
	"StructEndBytes",
	"StructEndOmitEmptyBytes",
	"StructFieldNumber",
	"StructFieldOmitEmptyNumber",
	"StructEndNumber",
	"StructEndOmitEmptyNumber",
	"StructFieldArray",
	"StructFieldOmitEmptyArray",
	"StructEndArray",
	"StructEndOmitEmptyArray",
	"StructFieldMap",
	"StructFieldOmitEmptyMap",
	"StructEndMap",
	"StructEndOmitEmptyMap",
	"StructFieldSlice",
	"StructFieldOmitEmptySlice",
	"StructEndSlice",
	"StructEndOmitEmptySlice",
	"StructFieldStruct",
	"StructFieldOmitEmptyStruct",
	"StructEndStruct",
	"StructEndOmitEmptyStruct",
	"StructFieldMarshalJSON",
	"StructFieldOmitEmptyMarshalJSON",
	"StructEndMarshalJSON",
	"StructEndOmitEmptyMarshalJSON",
	"StructFieldMarshalText",
	"StructFieldOmitEmptyMarshalText",
	"StructEndMarshalText",
	"StructEndOmitEmptyMarshalText",
	"StructFieldIntString",
	"StructFieldOmitEmptyIntString",
	"StructEndIntString",
	"StructEndOmitEmptyIntString",
	"StructFieldUintString",
	"StructFieldOmitEmptyUintString",
	"StructEndUintString",
	"StructEndOmitEmptyUintString",
	"StructFieldFloat32String",
	"StructFieldOmitEmptyFloat32String",
	"StructEndFloat32String",
	"StructEndOmitEmptyFloat32String",
	"StructFieldFloat64String",
	"StructFieldOmitEmptyFloat64String",
	"StructEndFloat64String",
	"StructEndOmitEmptyFloat64String",
	"StructFieldBoolString",
	"StructFieldOmitEmptyBoolString",
	"StructEndBoolString",
	"StructEndOmitEmptyBoolString",
	"StructFieldStringString",
	"StructFieldOmitEmptyStringString",
	"StructEndStringString",
	"StructEndOmitEmptyStringString",
	"StructFieldNumberString",
	"StructFieldOmitEmptyNumberString",
	"StructEndNumberString",
	"StructEndOmitEmptyNumberString",
	"StructFieldIntPtr",
	"StructFieldOmitEmptyIntPtr",
	"StructEndIntPtr",
	"StructEndOmitEmptyIntPtr",
	"StructFieldUintPtr",
	"StructFieldOmitEmptyUintPtr",
	"StructEndUintPtr",
	"StructEndOmitEmptyUintPtr",
	"StructFieldFloat32Ptr",
	"StructFieldOmitEmptyFloat32Ptr",
	"StructEndFloat32Ptr",
	"StructEndOmitEmptyFloat32Ptr",
	"StructFieldFloat64Ptr",
	"StructFieldOmitEmptyFloat64Ptr",
	"StructEndFloat64Ptr",
	"StructEndOmitEmptyFloat64Ptr",
	"StructFieldBoolPtr",
	"StructFieldOmitEmptyBoolPtr",
	"StructEndBoolPtr",
	"StructEndOmitEmptyBoolPtr",
	"StructFieldStringPtr",
	"StructFieldOmitEmptyStringPtr",
	"StructEndStringPtr",
	"StructEndOmitEmptyStringPtr",
	"StructFieldBytesPtr",
	"StructFieldOmitEmptyBytesPtr",
	"StructEndBytesPtr",
	"StructEndOmitEmptyBytesPtr",
	"StructFieldNumberPtr",
	"StructFieldOmitEmptyNumberPtr",
	"StructEndNumberPtr",
	"StructEndOmitEmptyNumberPtr",
	"StructFieldArrayPtr",
	"StructFieldOmitEmptyArrayPtr",
	"StructEndArrayPtr",
	"StructEndOmitEmptyArrayPtr",
	"StructFieldMapPtr",
	"StructFieldOmitEmptyMapPtr",
	"StructEndMapPtr",
	"StructEndOmitEmptyMapPtr",
	"StructFieldSlicePtr",
	"StructFieldOmitEmptySlicePtr",
	"StructEndSlicePtr",
	"StructEndOmitEmptySlicePtr",
	"StructFieldMarshalJSONPtr",
	"StructFieldOmitEmptyMarshalJSONPtr",
	"StructEndMarshalJSONPtr",
	"StructEndOmitEmptyMarshalJSONPtr",
	"StructFieldMarshalTextPtr",
	"StructFieldOmitEmptyMarshalTextPtr",
	"StructEndMarshalTextPtr",
	"StructEndOmitEmptyMarshalTextPtr",
	"StructFieldInterfacePtr",
	"StructFieldOmitEmptyInterfacePtr",
	"StructEndInterfacePtr",
	"StructEndOmitEmptyInterfacePtr",
	"StructFieldIntPtrString",
	"StructFieldOmitEmptyIntPtrString",
	"StructEndIntPtrString",
	"StructEndOmitEmptyIntPtrString",
	"StructFieldUintPtrString",
	"StructFieldOmitEmptyUintPtrString",
	"StructEndUintPtrString",
	"StructEndOmitEmptyUintPtrString",
	"StructFieldFloat32PtrString",
	"StructFieldOmitEmptyFloat32PtrString",
	"StructEndFloat32PtrString",
	"StructEndOmitEmptyFloat32PtrString",
	"StructFieldFloat64PtrString",
	"StructFieldOmitEmptyFloat64PtrString",
	"StructEndFloat64PtrString",
	"StructEndOmitEmptyFloat64PtrString",
	"StructFieldBoolPtrString",
	"StructFieldOmitEmptyBoolPtrString",
	"StructEndBoolPtrString",
	"StructEndOmitEmptyBoolPtrString",
	"StructFieldStringPtrString",
	"StructFieldOmitEmptyStringPtrString",
	"StructEndStringPtrString",
	"StructEndOmitEmptyStringPtrString",
	"StructFieldNumberPtrString",
	"StructFieldOmitEmptyNumberPtrString",
	"StructEndNumberPtrString",
	"StructEndOmitEmptyNumberPtrString",
	"StructField",
	"StructFieldOmitEmpty",
	"StructEnd",
	"StructEndOmitEmpty",
}

type OpType uint16

const (
	OpEnd                                    OpType = 0
	OpInterface                              OpType = 1
	OpPtr                                    OpType = 2
	OpSliceElem                              OpType = 3
	OpSliceEnd                               OpType = 4
	OpArrayElem                              OpType = 5
	OpArrayEnd                               OpType = 6
	OpMapKey                                 OpType = 7
	OpMapValue                               OpType = 8
	OpMapEnd                                 OpType = 9
	OpRecursive                              OpType = 10
	OpRecursivePtr                           OpType = 11
	OpRecursiveEnd                           OpType = 12
	OpInterfaceEnd                           OpType = 13
	OpStructAnonymousEnd                     OpType = 14
	OpInt                                    OpType = 15
	OpUint                                   OpType = 16
	OpFloat32                                OpType = 17
	OpFloat64                                OpType = 18
	OpBool                                   OpType = 19
	OpString                                 OpType = 20
	OpBytes                                  OpType = 21
	OpNumber                                 OpType = 22
	OpArray                                  OpType = 23
	OpMap                                    OpType = 24
	OpSlice                                  OpType = 25
	OpStruct                                 OpType = 26
	OpMarshalJSON                            OpType = 27
	OpMarshalText                            OpType = 28
	OpIntString                              OpType = 29
	OpUintString                             OpType = 30
	OpFloat32String                          OpType = 31
	OpFloat64String                          OpType = 32
	OpBoolString                             OpType = 33
	OpStringString                           OpType = 34
	OpNumberString                           OpType = 35
	OpIntPtr                                 OpType = 36
	OpUintPtr                                OpType = 37
	OpFloat32Ptr                             OpType = 38
	OpFloat64Ptr                             OpType = 39
	OpBoolPtr                                OpType = 40
	OpStringPtr                              OpType = 41
	OpBytesPtr                               OpType = 42
	OpNumberPtr                              OpType = 43
	OpArrayPtr                               OpType = 44
	OpMapPtr                                 OpType = 45
	OpSlicePtr                               OpType = 46
	OpMarshalJSONPtr                         OpType = 47
	OpMarshalTextPtr                         OpType = 48
	OpInterfacePtr                           OpType = 49
	OpIntPtrString                           OpType = 50
	OpUintPtrString                          OpType = 51
	OpFloat32PtrString                       OpType = 52
	OpFloat64PtrString                       OpType = 53
	OpBoolPtrString                          OpType = 54
	OpStringPtrString                        OpType = 55
	OpNumberPtrString                        OpType = 56
	OpStructHeadInt                          OpType = 57
	OpStructHeadOmitEmptyInt                 OpType = 58
	OpStructPtrHeadInt                       OpType = 59
	OpStructPtrHeadOmitEmptyInt              OpType = 60
	OpStructHeadUint                         OpType = 61
	OpStructHeadOmitEmptyUint                OpType = 62
	OpStructPtrHeadUint                      OpType = 63
	OpStructPtrHeadOmitEmptyUint             OpType = 64
	OpStructHeadFloat32                      OpType = 65
	OpStructHeadOmitEmptyFloat32             OpType = 66
	OpStructPtrHeadFloat32                   OpType = 67
	OpStructPtrHeadOmitEmptyFloat32          OpType = 68
	OpStructHeadFloat64                      OpType = 69
	OpStructHeadOmitEmptyFloat64             OpType = 70
	OpStructPtrHeadFloat64                   OpType = 71
	OpStructPtrHeadOmitEmptyFloat64          OpType = 72
	OpStructHeadBool                         OpType = 73
	OpStructHeadOmitEmptyBool                OpType = 74
	OpStructPtrHeadBool                      OpType = 75
	OpStructPtrHeadOmitEmptyBool             OpType = 76
	OpStructHeadString                       OpType = 77
	OpStructHeadOmitEmptyString              OpType = 78
	OpStructPtrHeadString                    OpType = 79
	OpStructPtrHeadOmitEmptyString           OpType = 80
	OpStructHeadBytes                        OpType = 81
	OpStructHeadOmitEmptyBytes               OpType = 82
	OpStructPtrHeadBytes                     OpType = 83
	OpStructPtrHeadOmitEmptyBytes            OpType = 84
	OpStructHeadNumber                       OpType = 85
	OpStructHeadOmitEmptyNumber              OpType = 86
	OpStructPtrHeadNumber                    OpType = 87
	OpStructPtrHeadOmitEmptyNumber           OpType = 88
	OpStructHeadArray                        OpType = 89
	OpStructHeadOmitEmptyArray               OpType = 90
	OpStructPtrHeadArray                     OpType = 91
	OpStructPtrHeadOmitEmptyArray            OpType = 92
	OpStructHeadMap                          OpType = 93
	OpStructHeadOmitEmptyMap                 OpType = 94
	OpStructPtrHeadMap                       OpType = 95
	OpStructPtrHeadOmitEmptyMap              OpType = 96
	OpStructHeadSlice                        OpType = 97
	OpStructHeadOmitEmptySlice               OpType = 98
	OpStructPtrHeadSlice                     OpType = 99
	OpStructPtrHeadOmitEmptySlice            OpType = 100
	OpStructHeadStruct                       OpType = 101
	OpStructHeadOmitEmptyStruct              OpType = 102
	OpStructPtrHeadStruct                    OpType = 103
	OpStructPtrHeadOmitEmptyStruct           OpType = 104
	OpStructHeadMarshalJSON                  OpType = 105
	OpStructHeadOmitEmptyMarshalJSON         OpType = 106
	OpStructPtrHeadMarshalJSON               OpType = 107
	OpStructPtrHeadOmitEmptyMarshalJSON      OpType = 108
	OpStructHeadMarshalText                  OpType = 109
	OpStructHeadOmitEmptyMarshalText         OpType = 110
	OpStructPtrHeadMarshalText               OpType = 111
	OpStructPtrHeadOmitEmptyMarshalText      OpType = 112
	OpStructHeadIntString                    OpType = 113
	OpStructHeadOmitEmptyIntString           OpType = 114
	OpStructPtrHeadIntString                 OpType = 115
	OpStructPtrHeadOmitEmptyIntString        OpType = 116
	OpStructHeadUintString                   OpType = 117
	OpStructHeadOmitEmptyUintString          OpType = 118
	OpStructPtrHeadUintString                OpType = 119
	OpStructPtrHeadOmitEmptyUintString       OpType = 120
	OpStructHeadFloat32String                OpType = 121
	OpStructHeadOmitEmptyFloat32String       OpType = 122
	OpStructPtrHeadFloat32String             OpType = 123
	OpStructPtrHeadOmitEmptyFloat32String    OpType = 124
	OpStructHeadFloat64String                OpType = 125
	OpStructHeadOmitEmptyFloat64String       OpType = 126
	OpStructPtrHeadFloat64String             OpType = 127
	OpStructPtrHeadOmitEmptyFloat64String    OpType = 128
	OpStructHeadBoolString                   OpType = 129
	OpStructHeadOmitEmptyBoolString          OpType = 130
	OpStructPtrHeadBoolString                OpType = 131
	OpStructPtrHeadOmitEmptyBoolString       OpType = 132
	OpStructHeadStringString                 OpType = 133
	OpStructHeadOmitEmptyStringString        OpType = 134
	OpStructPtrHeadStringString              OpType = 135
	OpStructPtrHeadOmitEmptyStringString     OpType = 136
	OpStructHeadNumberString                 OpType = 137
	OpStructHeadOmitEmptyNumberString        OpType = 138
	OpStructPtrHeadNumberString              OpType = 139
	OpStructPtrHeadOmitEmptyNumberString     OpType = 140
	OpStructHeadIntPtr                       OpType = 141
	OpStructHeadOmitEmptyIntPtr              OpType = 142
	OpStructPtrHeadIntPtr                    OpType = 143
	OpStructPtrHeadOmitEmptyIntPtr           OpType = 144
	OpStructHeadUintPtr                      OpType = 145
	OpStructHeadOmitEmptyUintPtr             OpType = 146
	OpStructPtrHeadUintPtr                   OpType = 147
	OpStructPtrHeadOmitEmptyUintPtr          OpType = 148
	OpStructHeadFloat32Ptr                   OpType = 149
	OpStructHeadOmitEmptyFloat32Ptr          OpType = 150
	OpStructPtrHeadFloat32Ptr                OpType = 151
	OpStructPtrHeadOmitEmptyFloat32Ptr       OpType = 152
	OpStructHeadFloat64Ptr                   OpType = 153
	OpStructHeadOmitEmptyFloat64Ptr          OpType = 154
	OpStructPtrHeadFloat64Ptr                OpType = 155
	OpStructPtrHeadOmitEmptyFloat64Ptr       OpType = 156
	OpStructHeadBoolPtr                      OpType = 157
	OpStructHeadOmitEmptyBoolPtr             OpType = 158
	OpStructPtrHeadBoolPtr                   OpType = 159
	OpStructPtrHeadOmitEmptyBoolPtr          OpType = 160
	OpStructHeadStringPtr                    OpType = 161
	OpStructHeadOmitEmptyStringPtr           OpType = 162
	OpStructPtrHeadStringPtr                 OpType = 163
	OpStructPtrHeadOmitEmptyStringPtr        OpType = 164
	OpStructHeadBytesPtr                     OpType = 165
	OpStructHeadOmitEmptyBytesPtr            OpType = 166
	OpStructPtrHeadBytesPtr                  OpType = 167
	OpStructPtrHeadOmitEmptyBytesPtr         OpType = 168
	OpStructHeadNumberPtr                    OpType = 169
	OpStructHeadOmitEmptyNumberPtr           OpType = 170
	OpStructPtrHeadNumberPtr                 OpType = 171
	OpStructPtrHeadOmitEmptyNumberPtr        OpType = 172
	OpStructHeadArrayPtr                     OpType = 173
	OpStructHeadOmitEmptyArrayPtr            OpType = 174
	OpStructPtrHeadArrayPtr                  OpType = 175
	OpStructPtrHeadOmitEmptyArrayPtr         OpType = 176
	OpStructHeadMapPtr                       OpType = 177
	OpStructHeadOmitEmptyMapPtr              OpType = 178
	OpStructPtrHeadMapPtr                    OpType = 179
	OpStructPtrHeadOmitEmptyMapPtr           OpType = 180
	OpStructHeadSlicePtr                     OpType = 181
	OpStructHeadOmitEmptySlicePtr            OpType = 182
	OpStructPtrHeadSlicePtr                  OpType = 183
	OpStructPtrHeadOmitEmptySlicePtr         OpType = 184
	OpStructHeadMarshalJSONPtr               OpType = 185
	OpStructHeadOmitEmptyMarshalJSONPtr      OpType = 186
	OpStructPtrHeadMarshalJSONPtr            OpType = 187
	OpStructPtrHeadOmitEmptyMarshalJSONPtr   OpType = 188
	OpStructHeadMarshalTextPtr               OpType = 189
	OpStructHeadOmitEmptyMarshalTextPtr      OpType = 190
	OpStructPtrHeadMarshalTextPtr            OpType = 191
	OpStructPtrHeadOmitEmptyMarshalTextPtr   OpType = 192
	OpStructHeadInterfacePtr                 OpType = 193
	OpStructHeadOmitEmptyInterfacePtr        OpType = 194
	OpStructPtrHeadInterfacePtr              OpType = 195
	OpStructPtrHeadOmitEmptyInterfacePtr     OpType = 196
	OpStructHeadIntPtrString                 OpType = 197
	OpStructHeadOmitEmptyIntPtrString        OpType = 198
	OpStructPtrHeadIntPtrString              OpType = 199
	OpStructPtrHeadOmitEmptyIntPtrString     OpType = 200
	OpStructHeadUintPtrString                OpType = 201
	OpStructHeadOmitEmptyUintPtrString       OpType = 202
	OpStructPtrHeadUintPtrString             OpType = 203
	OpStructPtrHeadOmitEmptyUintPtrString    OpType = 204
	OpStructHeadFloat32PtrString             OpType = 205
	OpStructHeadOmitEmptyFloat32PtrString    OpType = 206
	OpStructPtrHeadFloat32PtrString          OpType = 207
	OpStructPtrHeadOmitEmptyFloat32PtrString OpType = 208
	OpStructHeadFloat64PtrString             OpType = 209
	OpStructHeadOmitEmptyFloat64PtrString    OpType = 210
	OpStructPtrHeadFloat64PtrString          OpType = 211
	OpStructPtrHeadOmitEmptyFloat64PtrString OpType = 212
	OpStructHeadBoolPtrString                OpType = 213
	OpStructHeadOmitEmptyBoolPtrString       OpType = 214
	OpStructPtrHeadBoolPtrString             OpType = 215
	OpStructPtrHeadOmitEmptyBoolPtrString    OpType = 216
	OpStructHeadStringPtrString              OpType = 217
	OpStructHeadOmitEmptyStringPtrString     OpType = 218
	OpStructPtrHeadStringPtrString           OpType = 219
	OpStructPtrHeadOmitEmptyStringPtrString  OpType = 220
	OpStructHeadNumberPtrString              OpType = 221
	OpStructHeadOmitEmptyNumberPtrString     OpType = 222
	OpStructPtrHeadNumberPtrString           OpType = 223
	OpStructPtrHeadOmitEmptyNumberPtrString  OpType = 224
	OpStructHead                             OpType = 225
	OpStructHeadOmitEmpty                    OpType = 226
	OpStructPtrHead                          OpType = 227
	OpStructPtrHeadOmitEmpty                 OpType = 228
	OpStructFieldInt                         OpType = 229
	OpStructFieldOmitEmptyInt                OpType = 230
	OpStructEndInt                           OpType = 231
	OpStructEndOmitEmptyInt                  OpType = 232
	OpStructFieldUint                        OpType = 233
	OpStructFieldOmitEmptyUint               OpType = 234
	OpStructEndUint                          OpType = 235
	OpStructEndOmitEmptyUint                 OpType = 236
	OpStructFieldFloat32                     OpType = 237
	OpStructFieldOmitEmptyFloat32            OpType = 238
	OpStructEndFloat32                       OpType = 239
	OpStructEndOmitEmptyFloat32              OpType = 240
	OpStructFieldFloat64                     OpType = 241
	OpStructFieldOmitEmptyFloat64            OpType = 242
	OpStructEndFloat64                       OpType = 243
	OpStructEndOmitEmptyFloat64              OpType = 244
	OpStructFieldBool                        OpType = 245
	OpStructFieldOmitEmptyBool               OpType = 246
	OpStructEndBool                          OpType = 247
	OpStructEndOmitEmptyBool                 OpType = 248
	OpStructFieldString                      OpType = 249
	OpStructFieldOmitEmptyString             OpType = 250
	OpStructEndString                        OpType = 251
	OpStructEndOmitEmptyString               OpType = 252
	OpStructFieldBytes                       OpType = 253
	OpStructFieldOmitEmptyBytes              OpType = 254
	OpStructEndBytes                         OpType = 255
	OpStructEndOmitEmptyBytes                OpType = 256
	OpStructFieldNumber                      OpType = 257
	OpStructFieldOmitEmptyNumber             OpType = 258
	OpStructEndNumber                        OpType = 259
	OpStructEndOmitEmptyNumber               OpType = 260
	OpStructFieldArray                       OpType = 261
	OpStructFieldOmitEmptyArray              OpType = 262
	OpStructEndArray                         OpType = 263
	OpStructEndOmitEmptyArray                OpType = 264
	OpStructFieldMap                         OpType = 265
	OpStructFieldOmitEmptyMap                OpType = 266
	OpStructEndMap                           OpType = 267
	OpStructEndOmitEmptyMap                  OpType = 268
	OpStructFieldSlice                       OpType = 269
	OpStructFieldOmitEmptySlice              OpType = 270
	OpStructEndSlice                         OpType = 271
	OpStructEndOmitEmptySlice                OpType = 272
	OpStructFieldStruct                      OpType = 273
	OpStructFieldOmitEmptyStruct             OpType = 274
	OpStructEndStruct                        OpType = 275
	OpStructEndOmitEmptyStruct               OpType = 276
	OpStructFieldMarshalJSON                 OpType = 277
	OpStructFieldOmitEmptyMarshalJSON        OpType = 278
	OpStructEndMarshalJSON                   OpType = 279
	OpStructEndOmitEmptyMarshalJSON          OpType = 280
	OpStructFieldMarshalText                 OpType = 281
	OpStructFieldOmitEmptyMarshalText        OpType = 282
	OpStructEndMarshalText                   OpType = 283
	OpStructEndOmitEmptyMarshalText          OpType = 284
	OpStructFieldIntString                   OpType = 285
	OpStructFieldOmitEmptyIntString          OpType = 286
	OpStructEndIntString                     OpType = 287
	OpStructEndOmitEmptyIntString            OpType = 288
	OpStructFieldUintString                  OpType = 289
	OpStructFieldOmitEmptyUintString         OpType = 290
	OpStructEndUintString                    OpType = 291
	OpStructEndOmitEmptyUintString           OpType = 292
	OpStructFieldFloat32String               OpType = 293
	OpStructFieldOmitEmptyFloat32String      OpType = 294
	OpStructEndFloat32String                 OpType = 295
	OpStructEndOmitEmptyFloat32String        OpType = 296
	OpStructFieldFloat64String               OpType = 297
	OpStructFieldOmitEmptyFloat64String      OpType = 298
	OpStructEndFloat64String                 OpType = 299
	OpStructEndOmitEmptyFloat64String        OpType = 300
	OpStructFieldBoolString                  OpType = 301
	OpStructFieldOmitEmptyBoolString         OpType = 302
	OpStructEndBoolString                    OpType = 303
	OpStructEndOmitEmptyBoolString           OpType = 304
	OpStructFieldStringString                OpType = 305
	OpStructFieldOmitEmptyStringString       OpType = 306
	OpStructEndStringString                  OpType = 307
	OpStructEndOmitEmptyStringString         OpType = 308
	OpStructFieldNumberString                OpType = 309
	OpStructFieldOmitEmptyNumberString       OpType = 310
	OpStructEndNumberString                  OpType = 311
	OpStructEndOmitEmptyNumberString         OpType = 312
	OpStructFieldIntPtr                      OpType = 313
	OpStructFieldOmitEmptyIntPtr             OpType = 314
	OpStructEndIntPtr                        OpType = 315
	OpStructEndOmitEmptyIntPtr               OpType = 316
	OpStructFieldUintPtr                     OpType = 317
	OpStructFieldOmitEmptyUintPtr            OpType = 318
	OpStructEndUintPtr                       OpType = 319
	OpStructEndOmitEmptyUintPtr              OpType = 320
	OpStructFieldFloat32Ptr                  OpType = 321
	OpStructFieldOmitEmptyFloat32Ptr         OpType = 322
	OpStructEndFloat32Ptr                    OpType = 323
	OpStructEndOmitEmptyFloat32Ptr           OpType = 324
	OpStructFieldFloat64Ptr                  OpType = 325
	OpStructFieldOmitEmptyFloat64Ptr         OpType = 326
	OpStructEndFloat64Ptr                    OpType = 327
	OpStructEndOmitEmptyFloat64Ptr           OpType = 328
	OpStructFieldBoolPtr                     OpType = 329
	OpStructFieldOmitEmptyBoolPtr            OpType = 330
	OpStructEndBoolPtr                       OpType = 331
	OpStructEndOmitEmptyBoolPtr              OpType = 332
	OpStructFieldStringPtr                   OpType = 333
	OpStructFieldOmitEmptyStringPtr          OpType = 334
	OpStructEndStringPtr                     OpType = 335
	OpStructEndOmitEmptyStringPtr            OpType = 336
	OpStructFieldBytesPtr                    OpType = 337
	OpStructFieldOmitEmptyBytesPtr           OpType = 338
	OpStructEndBytesPtr                      OpType = 339
	OpStructEndOmitEmptyBytesPtr             OpType = 340
	OpStructFieldNumberPtr                   OpType = 341
	OpStructFieldOmitEmptyNumberPtr          OpType = 342
	OpStructEndNumberPtr                     OpType = 343
	OpStructEndOmitEmptyNumberPtr            OpType = 344
	OpStructFieldArrayPtr                    OpType = 345
	OpStructFieldOmitEmptyArrayPtr           OpType = 346
	OpStructEndArrayPtr                      OpType = 347
	OpStructEndOmitEmptyArrayPtr             OpType = 348
	OpStructFieldMapPtr                      OpType = 349
	OpStructFieldOmitEmptyMapPtr             OpType = 350
	OpStructEndMapPtr                        OpType = 351
	OpStructEndOmitEmptyMapPtr               OpType = 352
	OpStructFieldSlicePtr                    OpType = 353
	OpStructFieldOmitEmptySlicePtr           OpType = 354
	OpStructEndSlicePtr                      OpType = 355
	OpStructEndOmitEmptySlicePtr             OpType = 356
	OpStructFieldMarshalJSONPtr              OpType = 357
	OpStructFieldOmitEmptyMarshalJSONPtr     OpType = 358
	OpStructEndMarshalJSONPtr                OpType = 359
	OpStructEndOmitEmptyMarshalJSONPtr       OpType = 360
	OpStructFieldMarshalTextPtr              OpType = 361
	OpStructFieldOmitEmptyMarshalTextPtr     OpType = 362
	OpStructEndMarshalTextPtr                OpType = 363
	OpStructEndOmitEmptyMarshalTextPtr       OpType = 364
	OpStructFieldInterfacePtr                OpType = 365
	OpStructFieldOmitEmptyInterfacePtr       OpType = 366
	OpStructEndInterfacePtr                  OpType = 367
	OpStructEndOmitEmptyInterfacePtr         OpType = 368
	OpStructFieldIntPtrString                OpType = 369
	OpStructFieldOmitEmptyIntPtrString       OpType = 370
	OpStructEndIntPtrString                  OpType = 371
	OpStructEndOmitEmptyIntPtrString         OpType = 372
	OpStructFieldUintPtrString               OpType = 373
	OpStructFieldOmitEmptyUintPtrString      OpType = 374
	OpStructEndUintPtrString                 OpType = 375
	OpStructEndOmitEmptyUintPtrString        OpType = 376
	OpStructFieldFloat32PtrString            OpType = 377
	OpStructFieldOmitEmptyFloat32PtrString   OpType = 378
	OpStructEndFloat32PtrString              OpType = 379
	OpStructEndOmitEmptyFloat32PtrString     OpType = 380
	OpStructFieldFloat64PtrString            OpType = 381
	OpStructFieldOmitEmptyFloat64PtrString   OpType = 382
	OpStructEndFloat64PtrString              OpType = 383
	OpStructEndOmitEmptyFloat64PtrString     OpType = 384
	OpStructFieldBoolPtrString               OpType = 385
	OpStructFieldOmitEmptyBoolPtrString      OpType = 386
	OpStructEndBoolPtrString                 OpType = 387
	OpStructEndOmitEmptyBoolPtrString        OpType = 388
	OpStructFieldStringPtrString             OpType = 389
	OpStructFieldOmitEmptyStringPtrString    OpType = 390
	OpStructEndStringPtrString               OpType = 391
	OpStructEndOmitEmptyStringPtrString      OpType = 392
	OpStructFieldNumberPtrString             OpType = 393
	OpStructFieldOmitEmptyNumberPtrString    OpType = 394
	OpStructEndNumberPtrString               OpType = 395
	OpStructEndOmitEmptyNumberPtrString      OpType = 396
	OpStructField                            OpType = 397
	OpStructFieldOmitEmpty                   OpType = 398
	OpStructEnd                              OpType = 399
	OpStructEndOmitEmpty                     OpType = 400
)

func (t OpType) String() string {
	if int(t) >= 401 {
		return ""
	}
	return opTypeStrings[int(t)]
}

func (t OpType) CodeType() CodeType {
	if strings.Contains(t.String(), "Struct") {
		if strings.Contains(t.String(), "End") {
			return CodeStructEnd
		}
		return CodeStructField
	}
	switch t {
	case OpArray, OpArrayPtr:
		return CodeArrayHead
	case OpArrayElem:
		return CodeArrayElem
	case OpSlice, OpSlicePtr:
		return CodeSliceHead
	case OpSliceElem:
		return CodeSliceElem
	case OpMap, OpMapPtr:
		return CodeMapHead
	case OpMapKey:
		return CodeMapKey
	case OpMapValue:
		return CodeMapValue
	case OpMapEnd:
		return CodeMapEnd
	}

	return CodeOp
}

func (t OpType) HeadToPtrHead() OpType {
	if strings.Index(t.String(), "PtrHead") > 0 {
		return t
	}

	idx := strings.Index(t.String(), "Head")
	if idx == -1 {
		return t
	}
	suffix := "PtrHead" + t.String()[idx+len("Head"):]

	const toPtrOffset = 2
	if strings.Contains(OpType(int(t)+toPtrOffset).String(), suffix) {
		return OpType(int(t) + toPtrOffset)
	}
	return t
}

func (t OpType) HeadToOmitEmptyHead() OpType {
	const toOmitEmptyOffset = 1
	if strings.Contains(OpType(int(t)+toOmitEmptyOffset).String(), "OmitEmpty") {
		return OpType(int(t) + toOmitEmptyOffset)
	}

	return t
}

func (t OpType) PtrHeadToHead() OpType {
	idx := strings.Index(t.String(), "Ptr")
	if idx == -1 {
		return t
	}
	suffix := t.String()[idx+len("Ptr"):]

	const toPtrOffset = 2
	if strings.Contains(OpType(int(t)-toPtrOffset).String(), suffix) {
		return OpType(int(t) - toPtrOffset)
	}
	return t
}

func (t OpType) FieldToEnd() OpType {
	idx := strings.Index(t.String(), "Field")
	if idx == -1 {
		return t
	}
	suffix := t.String()[idx+len("Field"):]
	if suffix == "" || suffix == "OmitEmpty" {
		return t
	}
	const toEndOffset = 2
	if strings.Contains(OpType(int(t)+toEndOffset).String(), "End"+suffix) {
		return OpType(int(t) + toEndOffset)
	}
	return t
}

func (t OpType) FieldToOmitEmptyField() OpType {
	const toOmitEmptyOffset = 1
	if strings.Contains(OpType(int(t)+toOmitEmptyOffset).String(), "OmitEmpty") {
		return OpType(int(t) + toOmitEmptyOffset)
	}
	return t
}
