package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSubscribeDevice invokes the vcs.ListSubscribeDevice API synchronously
func (client *Client) ListSubscribeDevice(request *ListSubscribeDeviceRequest) (response *ListSubscribeDeviceResponse, err error) {
	response = CreateListSubscribeDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListSubscribeDeviceWithChan invokes the vcs.ListSubscribeDevice API asynchronously
func (client *Client) ListSubscribeDeviceWithChan(request *ListSubscribeDeviceRequest) (<-chan *ListSubscribeDeviceResponse, <-chan error) {
	responseChan := make(chan *ListSubscribeDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSubscribeDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSubscribeDeviceWithCallback invokes the vcs.ListSubscribeDevice API asynchronously
func (client *Client) ListSubscribeDeviceWithCallback(request *ListSubscribeDeviceRequest, callback func(response *ListSubscribeDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSubscribeDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListSubscribeDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSubscribeDeviceRequest is the request struct for api ListSubscribeDevice
type ListSubscribeDeviceRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// ListSubscribeDeviceResponse is the response struct for api ListSubscribeDevice
type ListSubscribeDeviceResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListSubscribeDeviceRequest creates a request to invoke ListSubscribeDevice API
func CreateListSubscribeDeviceRequest() (request *ListSubscribeDeviceRequest) {
	request = &ListSubscribeDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "ListSubscribeDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateListSubscribeDeviceResponse creates a response to parse from ListSubscribeDevice response
func CreateListSubscribeDeviceResponse() (response *ListSubscribeDeviceResponse) {
	response = &ListSubscribeDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
