package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMaterial invokes the trademark.QueryMaterial API synchronously
// api document: https://help.aliyun.com/api/trademark/querymaterial.html
func (client *Client) QueryMaterial(request *QueryMaterialRequest) (response *QueryMaterialResponse, err error) {
	response = CreateQueryMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMaterialWithChan invokes the trademark.QueryMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/querymaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMaterialWithChan(request *QueryMaterialRequest) (<-chan *QueryMaterialResponse, <-chan error) {
	responseChan := make(chan *QueryMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMaterialWithCallback invokes the trademark.QueryMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/querymaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMaterialWithCallback(request *QueryMaterialRequest, callback func(response *QueryMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMaterialResponse
		var err error
		defer close(result)
		response, err = client.QueryMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMaterialRequest is the request struct for api QueryMaterial
type QueryMaterialRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// QueryMaterialResponse is the response struct for api QueryMaterial
type QueryMaterialResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Type               int    `json:"Type" xml:"Type"`
	Region             int    `json:"Region" xml:"Region"`
	ContactName        string `json:"ContactName" xml:"ContactName"`
	ContactNumber      string `json:"ContactNumber" xml:"ContactNumber"`
	ContactEmail       string `json:"ContactEmail" xml:"ContactEmail"`
	ContactAddress     string `json:"ContactAddress" xml:"ContactAddress"`
	ContactZipcode     string `json:"ContactZipcode" xml:"ContactZipcode"`
	Status             int    `json:"Status" xml:"Status"`
	LoaUrl             string `json:"LoaUrl" xml:"LoaUrl"`
	Name               string `json:"Name" xml:"Name"`
	CardNumber         string `json:"CardNumber" xml:"CardNumber"`
	ExpirationDate     int64  `json:"ExpirationDate" xml:"ExpirationDate"`
	Province           string `json:"Province" xml:"Province"`
	City               string `json:"City" xml:"City"`
	Town               string `json:"Town" xml:"Town"`
	Address            string `json:"Address" xml:"Address"`
	EName              string `json:"EName" xml:"EName"`
	EAddress           string `json:"EAddress" xml:"EAddress"`
	LoaStatus          int    `json:"LoaStatus" xml:"LoaStatus"`
	IdCardUrl          string `json:"IdCardUrl" xml:"IdCardUrl"`
	BusinessLicenceUrl string `json:"BusinessLicenceUrl" xml:"BusinessLicenceUrl"`
	PassportUrl        string `json:"PassportUrl" xml:"PassportUrl"`
	Id                 int64  `json:"Id" xml:"Id"`
	LegalNoticeUrl     string `json:"LegalNoticeUrl" xml:"LegalNoticeUrl"`
	Note               string `json:"Note" xml:"Note"`
	Country            string `json:"Country" xml:"Country"`
}

// CreateQueryMaterialRequest creates a request to invoke QueryMaterial API
func CreateQueryMaterialRequest() (request *QueryMaterialRequest) {
	request = &QueryMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryMaterial", "trademark", "openAPI")
	return
}

// CreateQueryMaterialResponse creates a response to parse from QueryMaterial response
func CreateQueryMaterialResponse() (response *QueryMaterialResponse) {
	response = &QueryMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
