package tdsr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotspotTag invokes the tdsr.GetHotspotTag API synchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspottag.html
func (client *Client) GetHotspotTag(request *GetHotspotTagRequest) (response *GetHotspotTagResponse, err error) {
	response = CreateGetHotspotTagResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotspotTagWithChan invokes the tdsr.GetHotspotTag API asynchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspottag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotspotTagWithChan(request *GetHotspotTagRequest) (<-chan *GetHotspotTagResponse, <-chan error) {
	responseChan := make(chan *GetHotspotTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotspotTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotspotTagWithCallback invokes the tdsr.GetHotspotTag API asynchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspottag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotspotTagWithCallback(request *GetHotspotTagRequest, callback func(response *GetHotspotTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotspotTagResponse
		var err error
		defer close(result)
		response, err = client.GetHotspotTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotspotTagRequest is the request struct for api GetHotspotTag
type GetHotspotTagRequest struct {
	*requests.RpcRequest
	SubSceneUuid string `position:"Query" name:"SubSceneUuid"`
	Type         string `position:"Query" name:"Type"`
	PreviewToken string `position:"Query" name:"PreviewToken"`
}

// GetHotspotTagResponse is the response struct for api GetHotspotTag
type GetHotspotTagResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrMessage   string `json:"ErrMessage" xml:"ErrMessage"`
	Data         string `json:"Data" xml:"Data"`
	ObjectString string `json:"ObjectString" xml:"ObjectString"`
}

// CreateGetHotspotTagRequest creates a request to invoke GetHotspotTag API
func CreateGetHotspotTagRequest() (request *GetHotspotTagRequest) {
	request = &GetHotspotTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("tdsr", "2020-01-01", "GetHotspotTag", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHotspotTagResponse creates a response to parse from GetHotspotTag response
func CreateGetHotspotTagResponse() (response *GetHotspotTagResponse) {
	response = &GetHotspotTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
