package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSmartAGApiUnsupportedFeature invokes the smartag.ListSmartAGApiUnsupportedFeature API synchronously
func (client *Client) ListSmartAGApiUnsupportedFeature(request *ListSmartAGApiUnsupportedFeatureRequest) (response *ListSmartAGApiUnsupportedFeatureResponse, err error) {
	response = CreateListSmartAGApiUnsupportedFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// ListSmartAGApiUnsupportedFeatureWithChan invokes the smartag.ListSmartAGApiUnsupportedFeature API asynchronously
func (client *Client) ListSmartAGApiUnsupportedFeatureWithChan(request *ListSmartAGApiUnsupportedFeatureRequest) (<-chan *ListSmartAGApiUnsupportedFeatureResponse, <-chan error) {
	responseChan := make(chan *ListSmartAGApiUnsupportedFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSmartAGApiUnsupportedFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSmartAGApiUnsupportedFeatureWithCallback invokes the smartag.ListSmartAGApiUnsupportedFeature API asynchronously
func (client *Client) ListSmartAGApiUnsupportedFeatureWithCallback(request *ListSmartAGApiUnsupportedFeatureRequest, callback func(response *ListSmartAGApiUnsupportedFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSmartAGApiUnsupportedFeatureResponse
		var err error
		defer close(result)
		response, err = client.ListSmartAGApiUnsupportedFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSmartAGApiUnsupportedFeatureRequest is the request struct for api ListSmartAGApiUnsupportedFeature
type ListSmartAGApiUnsupportedFeatureRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OpenApiName          string           `position:"Query" name:"OpenApiName"`
}

// ListSmartAGApiUnsupportedFeatureResponse is the response struct for api ListSmartAGApiUnsupportedFeature
type ListSmartAGApiUnsupportedFeatureResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Features  []Feature `json:"Features" xml:"Features"`
}

// CreateListSmartAGApiUnsupportedFeatureRequest creates a request to invoke ListSmartAGApiUnsupportedFeature API
func CreateListSmartAGApiUnsupportedFeatureRequest() (request *ListSmartAGApiUnsupportedFeatureRequest) {
	request = &ListSmartAGApiUnsupportedFeatureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ListSmartAGApiUnsupportedFeature", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSmartAGApiUnsupportedFeatureResponse creates a response to parse from ListSmartAGApiUnsupportedFeature response
func CreateListSmartAGApiUnsupportedFeatureResponse() (response *ListSmartAGApiUnsupportedFeatureResponse) {
	response = &ListSmartAGApiUnsupportedFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
