package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEntityRouteList invokes the scsp.GetEntityRouteList API synchronously
func (client *Client) GetEntityRouteList(request *GetEntityRouteListRequest) (response *GetEntityRouteListResponse, err error) {
	response = CreateGetEntityRouteListResponse()
	err = client.DoAction(request, response)
	return
}

// GetEntityRouteListWithChan invokes the scsp.GetEntityRouteList API asynchronously
func (client *Client) GetEntityRouteListWithChan(request *GetEntityRouteListRequest) (<-chan *GetEntityRouteListResponse, <-chan error) {
	responseChan := make(chan *GetEntityRouteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEntityRouteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEntityRouteListWithCallback invokes the scsp.GetEntityRouteList API asynchronously
func (client *Client) GetEntityRouteListWithCallback(request *GetEntityRouteListRequest, callback func(response *GetEntityRouteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEntityRouteListResponse
		var err error
		defer close(result)
		response, err = client.GetEntityRouteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEntityRouteListRequest is the request struct for api GetEntityRouteList
type GetEntityRouteListRequest struct {
	*requests.RpcRequest
	InstanceId           string           `position:"Body"`
	PageNo               requests.Integer `position:"Body"`
	PageSize             requests.Integer `position:"Body"`
	EntityName           string           `position:"Body"`
	EntityRelationNumber string           `position:"Body"`
}

// GetEntityRouteListResponse is the response struct for api GetEntityRouteList
type GetEntityRouteListResponse struct {
	*responses.BaseResponse
	Message   string                   `json:"Message" xml:"Message"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Code      string                   `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	Data      DataInGetEntityRouteList `json:"Data" xml:"Data"`
}

// CreateGetEntityRouteListRequest creates a request to invoke GetEntityRouteList API
func CreateGetEntityRouteListRequest() (request *GetEntityRouteListRequest) {
	request = &GetEntityRouteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetEntityRouteList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEntityRouteListResponse creates a response to parse from GetEntityRouteList response
func CreateGetEntityRouteListResponse() (response *GetEntityRouteListResponse) {
	response = &GetEntityRouteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
