package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HandleSimilarSecurityEvents invokes the sas.HandleSimilarSecurityEvents API synchronously
func (client *Client) HandleSimilarSecurityEvents(request *HandleSimilarSecurityEventsRequest) (response *HandleSimilarSecurityEventsResponse, err error) {
	response = CreateHandleSimilarSecurityEventsResponse()
	err = client.DoAction(request, response)
	return
}

// HandleSimilarSecurityEventsWithChan invokes the sas.HandleSimilarSecurityEvents API asynchronously
func (client *Client) HandleSimilarSecurityEventsWithChan(request *HandleSimilarSecurityEventsRequest) (<-chan *HandleSimilarSecurityEventsResponse, <-chan error) {
	responseChan := make(chan *HandleSimilarSecurityEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HandleSimilarSecurityEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HandleSimilarSecurityEventsWithCallback invokes the sas.HandleSimilarSecurityEvents API asynchronously
func (client *Client) HandleSimilarSecurityEventsWithCallback(request *HandleSimilarSecurityEventsRequest, callback func(response *HandleSimilarSecurityEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HandleSimilarSecurityEventsResponse
		var err error
		defer close(result)
		response, err = client.HandleSimilarSecurityEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HandleSimilarSecurityEventsRequest is the request struct for api HandleSimilarSecurityEvents
type HandleSimilarSecurityEventsRequest struct {
	*requests.RpcRequest
	MarkMissParam   string           `position:"Query" name:"MarkMissParam"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	OperationCode   string           `position:"Query" name:"OperationCode"`
	TaskId          requests.Integer `position:"Query" name:"TaskId"`
	OperationParams string           `position:"Query" name:"OperationParams"`
}

// HandleSimilarSecurityEventsResponse is the response struct for api HandleSimilarSecurityEvents
type HandleSimilarSecurityEventsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateHandleSimilarSecurityEventsRequest creates a request to invoke HandleSimilarSecurityEvents API
func CreateHandleSimilarSecurityEventsRequest() (request *HandleSimilarSecurityEventsRequest) {
	request = &HandleSimilarSecurityEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "HandleSimilarSecurityEvents", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateHandleSimilarSecurityEventsResponse creates a response to parse from HandleSimilarSecurityEvents response
func CreateHandleSimilarSecurityEventsResponse() (response *HandleSimilarSecurityEventsResponse) {
	response = &HandleSimilarSecurityEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
