package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReplaceAppGroupCommodityCode invokes the opensearch.ReplaceAppGroupCommodityCode API synchronously
func (client *Client) ReplaceAppGroupCommodityCode(request *ReplaceAppGroupCommodityCodeRequest) (response *ReplaceAppGroupCommodityCodeResponse, err error) {
	response = CreateReplaceAppGroupCommodityCodeResponse()
	err = client.DoAction(request, response)
	return
}

// ReplaceAppGroupCommodityCodeWithChan invokes the opensearch.ReplaceAppGroupCommodityCode API asynchronously
func (client *Client) ReplaceAppGroupCommodityCodeWithChan(request *ReplaceAppGroupCommodityCodeRequest) (<-chan *ReplaceAppGroupCommodityCodeResponse, <-chan error) {
	responseChan := make(chan *ReplaceAppGroupCommodityCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReplaceAppGroupCommodityCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReplaceAppGroupCommodityCodeWithCallback invokes the opensearch.ReplaceAppGroupCommodityCode API asynchronously
func (client *Client) ReplaceAppGroupCommodityCodeWithCallback(request *ReplaceAppGroupCommodityCodeRequest, callback func(response *ReplaceAppGroupCommodityCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReplaceAppGroupCommodityCodeResponse
		var err error
		defer close(result)
		response, err = client.ReplaceAppGroupCommodityCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReplaceAppGroupCommodityCodeRequest is the request struct for api ReplaceAppGroupCommodityCode
type ReplaceAppGroupCommodityCodeRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ReplaceAppGroupCommodityCodeResponse is the response struct for api ReplaceAppGroupCommodityCode
type ReplaceAppGroupCommodityCodeResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"requestId" xml:"requestId"`
	Result    ResultInReplaceAppGroupCommodityCode `json:"result" xml:"result"`
}

// CreateReplaceAppGroupCommodityCodeRequest creates a request to invoke ReplaceAppGroupCommodityCode API
func CreateReplaceAppGroupCommodityCodeRequest() (request *ReplaceAppGroupCommodityCodeRequest) {
	request = &ReplaceAppGroupCommodityCodeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ReplaceAppGroupCommodityCode", "/v4/openapi/app-groups/[appGroupIdentity]/actions/to-instance-typed", "opensearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReplaceAppGroupCommodityCodeResponse creates a response to parse from ReplaceAppGroupCommodityCode response
func CreateReplaceAppGroupCommodityCodeResponse() (response *ReplaceAppGroupCommodityCodeResponse) {
	response = &ReplaceAppGroupCommodityCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
