package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveDomainPlayMapping invokes the live.AddLiveDomainPlayMapping API synchronously
func (client *Client) AddLiveDomainPlayMapping(request *AddLiveDomainPlayMappingRequest) (response *AddLiveDomainPlayMappingResponse, err error) {
	response = CreateAddLiveDomainPlayMappingResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveDomainPlayMappingWithChan invokes the live.AddLiveDomainPlayMapping API asynchronously
func (client *Client) AddLiveDomainPlayMappingWithChan(request *AddLiveDomainPlayMappingRequest) (<-chan *AddLiveDomainPlayMappingResponse, <-chan error) {
	responseChan := make(chan *AddLiveDomainPlayMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveDomainPlayMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveDomainPlayMappingWithCallback invokes the live.AddLiveDomainPlayMapping API asynchronously
func (client *Client) AddLiveDomainPlayMappingWithCallback(request *AddLiveDomainPlayMappingRequest, callback func(response *AddLiveDomainPlayMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveDomainPlayMappingResponse
		var err error
		defer close(result)
		response, err = client.AddLiveDomainPlayMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveDomainPlayMappingRequest is the request struct for api AddLiveDomainPlayMapping
type AddLiveDomainPlayMappingRequest struct {
	*requests.RpcRequest
	PlayDomain string           `position:"Query" name:"PlayDomain"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	PullDomain string           `position:"Query" name:"PullDomain"`
}

// AddLiveDomainPlayMappingResponse is the response struct for api AddLiveDomainPlayMapping
type AddLiveDomainPlayMappingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveDomainPlayMappingRequest creates a request to invoke AddLiveDomainPlayMapping API
func CreateAddLiveDomainPlayMappingRequest() (request *AddLiveDomainPlayMappingRequest) {
	request = &AddLiveDomainPlayMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveDomainPlayMapping", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveDomainPlayMappingResponse creates a response to parse from AddLiveDomainPlayMapping response
func CreateAddLiveDomainPlayMappingResponse() (response *AddLiveDomainPlayMappingResponse) {
	response = &AddLiveDomainPlayMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
