package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CountNodesByOwnedJoinPermissionId invokes the linkwan.CountNodesByOwnedJoinPermissionId API synchronously
func (client *Client) CountNodesByOwnedJoinPermissionId(request *CountNodesByOwnedJoinPermissionIdRequest) (response *CountNodesByOwnedJoinPermissionIdResponse, err error) {
	response = CreateCountNodesByOwnedJoinPermissionIdResponse()
	err = client.DoAction(request, response)
	return
}

// CountNodesByOwnedJoinPermissionIdWithChan invokes the linkwan.CountNodesByOwnedJoinPermissionId API asynchronously
func (client *Client) CountNodesByOwnedJoinPermissionIdWithChan(request *CountNodesByOwnedJoinPermissionIdRequest) (<-chan *CountNodesByOwnedJoinPermissionIdResponse, <-chan error) {
	responseChan := make(chan *CountNodesByOwnedJoinPermissionIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CountNodesByOwnedJoinPermissionId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CountNodesByOwnedJoinPermissionIdWithCallback invokes the linkwan.CountNodesByOwnedJoinPermissionId API asynchronously
func (client *Client) CountNodesByOwnedJoinPermissionIdWithCallback(request *CountNodesByOwnedJoinPermissionIdRequest, callback func(response *CountNodesByOwnedJoinPermissionIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CountNodesByOwnedJoinPermissionIdResponse
		var err error
		defer close(result)
		response, err = client.CountNodesByOwnedJoinPermissionId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CountNodesByOwnedJoinPermissionIdRequest is the request struct for api CountNodesByOwnedJoinPermissionId
type CountNodesByOwnedJoinPermissionIdRequest struct {
	*requests.RpcRequest
	JoinPermissionId string `position:"Query" name:"JoinPermissionId"`
	FuzzyDevEui      string `position:"Query" name:"FuzzyDevEui"`
	ApiProduct       string `position:"Body" name:"ApiProduct"`
	ApiRevision      string `position:"Body" name:"ApiRevision"`
}

// CountNodesByOwnedJoinPermissionIdResponse is the response struct for api CountNodesByOwnedJoinPermissionId
type CountNodesByOwnedJoinPermissionIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCountNodesByOwnedJoinPermissionIdRequest creates a request to invoke CountNodesByOwnedJoinPermissionId API
func CreateCountNodesByOwnedJoinPermissionIdRequest() (request *CountNodesByOwnedJoinPermissionIdRequest) {
	request = &CountNodesByOwnedJoinPermissionIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CountNodesByOwnedJoinPermissionId", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCountNodesByOwnedJoinPermissionIdResponse creates a response to parse from CountNodesByOwnedJoinPermissionId response
func CreateCountNodesByOwnedJoinPermissionIdResponse() (response *CountNodesByOwnedJoinPermissionIdResponse) {
	response = &CountNodesByOwnedJoinPermissionIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
