package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLedger invokes the ledgerdb.DescribeLedger API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/describeledger.html
func (client *Client) DescribeLedger(request *DescribeLedgerRequest) (response *DescribeLedgerResponse, err error) {
	response = CreateDescribeLedgerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLedgerWithChan invokes the ledgerdb.DescribeLedger API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/describeledger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLedgerWithChan(request *DescribeLedgerRequest) (<-chan *DescribeLedgerResponse, <-chan error) {
	responseChan := make(chan *DescribeLedgerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLedger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLedgerWithCallback invokes the ledgerdb.DescribeLedger API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/describeledger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLedgerWithCallback(request *DescribeLedgerRequest, callback func(response *DescribeLedgerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLedgerResponse
		var err error
		defer close(result)
		response, err = client.DescribeLedger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLedgerRequest is the request struct for api DescribeLedger
type DescribeLedgerRequest struct {
	*requests.RpcRequest
	LedgerId string `position:"Query" name:"LedgerId"`
}

// DescribeLedgerResponse is the response struct for api DescribeLedger
type DescribeLedgerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Ledger    Ledger `json:"Ledger" xml:"Ledger"`
}

// CreateDescribeLedgerRequest creates a request to invoke DescribeLedger API
func CreateDescribeLedgerRequest() (request *DescribeLedgerRequest) {
	request = &DescribeLedgerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "DescribeLedger", "ledgerdb", "openAPI")
	return
}

// CreateDescribeLedgerResponse creates a response to parse from DescribeLedger response
func CreateDescribeLedgerResponse() (response *DescribeLedgerResponse) {
	response = &DescribeLedgerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
