package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccelerator invokes the ga.DescribeAccelerator API synchronously
func (client *Client) DescribeAccelerator(request *DescribeAcceleratorRequest) (response *DescribeAcceleratorResponse, err error) {
	response = CreateDescribeAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAcceleratorWithChan invokes the ga.DescribeAccelerator API asynchronously
func (client *Client) DescribeAcceleratorWithChan(request *DescribeAcceleratorRequest) (<-chan *DescribeAcceleratorResponse, <-chan error) {
	responseChan := make(chan *DescribeAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAcceleratorWithCallback invokes the ga.DescribeAccelerator API asynchronously
func (client *Client) DescribeAcceleratorWithCallback(request *DescribeAcceleratorRequest, callback func(response *DescribeAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAcceleratorRequest is the request struct for api DescribeAccelerator
type DescribeAcceleratorRequest struct {
	*requests.RpcRequest
	AcceleratorId string `position:"Query" name:"AcceleratorId"`
}

// DescribeAcceleratorResponse is the response struct for api DescribeAccelerator
type DescribeAcceleratorResponse struct {
	*responses.BaseResponse
	DdosId                      string                      `json:"DdosId" xml:"DdosId"`
	DnsName                     string                      `json:"DnsName" xml:"DnsName"`
	Description                 string                      `json:"Description" xml:"Description"`
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	InstanceChargeType          string                      `json:"InstanceChargeType" xml:"InstanceChargeType"`
	CreateTime                  int64                       `json:"CreateTime" xml:"CreateTime"`
	SecondDnsName               string                      `json:"SecondDnsName" xml:"SecondDnsName"`
	Name                        string                      `json:"Name" xml:"Name"`
	State                       string                      `json:"State" xml:"State"`
	ExpiredTime                 int64                       `json:"ExpiredTime" xml:"ExpiredTime"`
	CenId                       string                      `json:"CenId" xml:"CenId"`
	RegionId                    string                      `json:"RegionId" xml:"RegionId"`
	Spec                        string                      `json:"Spec" xml:"Spec"`
	AcceleratorId               string                      `json:"AcceleratorId" xml:"AcceleratorId"`
	BasicBandwidthPackage       BasicBandwidthPackage       `json:"BasicBandwidthPackage" xml:"BasicBandwidthPackage"`
	CrossDomainBandwidthPackage CrossDomainBandwidthPackage `json:"CrossDomainBandwidthPackage" xml:"CrossDomainBandwidthPackage"`
}

// CreateDescribeAcceleratorRequest creates a request to invoke DescribeAccelerator API
func CreateDescribeAcceleratorRequest() (request *DescribeAcceleratorRequest) {
	request = &DescribeAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DescribeAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAcceleratorResponse creates a response to parse from DescribeAccelerator response
func CreateDescribeAcceleratorResponse() (response *DescribeAcceleratorResponse) {
	response = &DescribeAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
