package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOutboundStrategies invokes the dyvmsapi.ListOutboundStrategies API synchronously
func (client *Client) ListOutboundStrategies(request *ListOutboundStrategiesRequest) (response *ListOutboundStrategiesResponse, err error) {
	response = CreateListOutboundStrategiesResponse()
	err = client.DoAction(request, response)
	return
}

// ListOutboundStrategiesWithChan invokes the dyvmsapi.ListOutboundStrategies API asynchronously
func (client *Client) ListOutboundStrategiesWithChan(request *ListOutboundStrategiesRequest) (<-chan *ListOutboundStrategiesResponse, <-chan error) {
	responseChan := make(chan *ListOutboundStrategiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOutboundStrategies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOutboundStrategiesWithCallback invokes the dyvmsapi.ListOutboundStrategies API asynchronously
func (client *Client) ListOutboundStrategiesWithCallback(request *ListOutboundStrategiesRequest, callback func(response *ListOutboundStrategiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOutboundStrategiesResponse
		var err error
		defer close(result)
		response, err = client.ListOutboundStrategies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOutboundStrategiesRequest is the request struct for api ListOutboundStrategies
type ListOutboundStrategiesRequest struct {
	*requests.RpcRequest
	BuId                 requests.Integer `position:"Query" name:"BuId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Keyword              string           `position:"Query" name:"Keyword"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListOutboundStrategiesResponse is the response struct for api ListOutboundStrategies
type ListOutboundStrategiesResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Code               string             `json:"Code" xml:"Code"`
	Message            string             `json:"Message" xml:"Message"`
	OutboundStrategies []OutboundStrategy `json:"OutboundStrategies" xml:"OutboundStrategies"`
}

// CreateListOutboundStrategiesRequest creates a request to invoke ListOutboundStrategies API
func CreateListOutboundStrategiesRequest() (request *ListOutboundStrategiesRequest) {
	request = &ListOutboundStrategiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListOutboundStrategies", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOutboundStrategiesResponse creates a response to parse from ListOutboundStrategies response
func CreateListOutboundStrategiesResponse() (response *ListOutboundStrategiesResponse) {
	response = &ListOutboundStrategiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
