package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseDataCorrectSQLJob invokes the dms_enterprise.PauseDataCorrectSQLJob API synchronously
func (client *Client) PauseDataCorrectSQLJob(request *PauseDataCorrectSQLJobRequest) (response *PauseDataCorrectSQLJobResponse, err error) {
	response = CreatePauseDataCorrectSQLJobResponse()
	err = client.DoAction(request, response)
	return
}

// PauseDataCorrectSQLJobWithChan invokes the dms_enterprise.PauseDataCorrectSQLJob API asynchronously
func (client *Client) PauseDataCorrectSQLJobWithChan(request *PauseDataCorrectSQLJobRequest) (<-chan *PauseDataCorrectSQLJobResponse, <-chan error) {
	responseChan := make(chan *PauseDataCorrectSQLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseDataCorrectSQLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseDataCorrectSQLJobWithCallback invokes the dms_enterprise.PauseDataCorrectSQLJob API asynchronously
func (client *Client) PauseDataCorrectSQLJobWithCallback(request *PauseDataCorrectSQLJobRequest, callback func(response *PauseDataCorrectSQLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseDataCorrectSQLJobResponse
		var err error
		defer close(result)
		response, err = client.PauseDataCorrectSQLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseDataCorrectSQLJobRequest is the request struct for api PauseDataCorrectSQLJob
type PauseDataCorrectSQLJobRequest struct {
	*requests.RpcRequest
	OrderId requests.Integer `position:"Query" name:"OrderId"`
	Type    string           `position:"Query" name:"Type"`
	Tid     requests.Integer `position:"Query" name:"Tid"`
	JobId   requests.Integer `position:"Query" name:"JobId"`
}

// PauseDataCorrectSQLJobResponse is the response struct for api PauseDataCorrectSQLJob
type PauseDataCorrectSQLJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreatePauseDataCorrectSQLJobRequest creates a request to invoke PauseDataCorrectSQLJob API
func CreatePauseDataCorrectSQLJobRequest() (request *PauseDataCorrectSQLJobRequest) {
	request = &PauseDataCorrectSQLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "PauseDataCorrectSQLJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePauseDataCorrectSQLJobResponse creates a response to parse from PauseDataCorrectSQLJob response
func CreatePauseDataCorrectSQLJobResponse() (response *PauseDataCorrectSQLJobResponse) {
	response = &PauseDataCorrectSQLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
