package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindInstanceNodeList invokes the csb.FindInstanceNodeList API synchronously
// api document: https://help.aliyun.com/api/csb/findinstancenodelist.html
func (client *Client) FindInstanceNodeList(request *FindInstanceNodeListRequest) (response *FindInstanceNodeListResponse, err error) {
	response = CreateFindInstanceNodeListResponse()
	err = client.DoAction(request, response)
	return
}

// FindInstanceNodeListWithChan invokes the csb.FindInstanceNodeList API asynchronously
// api document: https://help.aliyun.com/api/csb/findinstancenodelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindInstanceNodeListWithChan(request *FindInstanceNodeListRequest) (<-chan *FindInstanceNodeListResponse, <-chan error) {
	responseChan := make(chan *FindInstanceNodeListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindInstanceNodeList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindInstanceNodeListWithCallback invokes the csb.FindInstanceNodeList API asynchronously
// api document: https://help.aliyun.com/api/csb/findinstancenodelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindInstanceNodeListWithCallback(request *FindInstanceNodeListRequest, callback func(response *FindInstanceNodeListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindInstanceNodeListResponse
		var err error
		defer close(result)
		response, err = client.FindInstanceNodeList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindInstanceNodeListRequest is the request struct for api FindInstanceNodeList
type FindInstanceNodeListRequest struct {
	*requests.RpcRequest
	OnlyImported requests.Boolean `position:"Query" name:"OnlyImported"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
	InstanceName string           `position:"Query" name:"InstanceName"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
}

// FindInstanceNodeListResponse is the response struct for api FindInstanceNodeList
type FindInstanceNodeListResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateFindInstanceNodeListRequest creates a request to invoke FindInstanceNodeList API
func CreateFindInstanceNodeListRequest() (request *FindInstanceNodeListRequest) {
	request = &FindInstanceNodeListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindInstanceNodeList", "", "")
	request.Method = requests.GET
	return
}

// CreateFindInstanceNodeListResponse creates a response to parse from FindInstanceNodeList response
func CreateFindInstanceNodeListResponse() (response *FindInstanceNodeListResponse) {
	response = &FindInstanceNodeListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
