package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartRemediation invokes the config.StartRemediation API synchronously
func (client *Client) StartRemediation(request *StartRemediationRequest) (response *StartRemediationResponse, err error) {
	response = CreateStartRemediationResponse()
	err = client.DoAction(request, response)
	return
}

// StartRemediationWithChan invokes the config.StartRemediation API asynchronously
func (client *Client) StartRemediationWithChan(request *StartRemediationRequest) (<-chan *StartRemediationResponse, <-chan error) {
	responseChan := make(chan *StartRemediationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartRemediation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartRemediationWithCallback invokes the config.StartRemediation API asynchronously
func (client *Client) StartRemediationWithCallback(request *StartRemediationRequest, callback func(response *StartRemediationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartRemediationResponse
		var err error
		defer close(result)
		response, err = client.StartRemediation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartRemediationRequest is the request struct for api StartRemediation
type StartRemediationRequest struct {
	*requests.RpcRequest
	ConfigRuleId string `position:"Query" name:"ConfigRuleId"`
}

// StartRemediationResponse is the response struct for api StartRemediation
type StartRemediationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateStartRemediationRequest creates a request to invoke StartRemediation API
func CreateStartRemediationRequest() (request *StartRemediationRequest) {
	request = &StartRemediationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "StartRemediation", "", "")
	request.Method = requests.POST
	return
}

// CreateStartRemediationResponse creates a response to parse from StartRemediation response
func CreateStartRemediationResponse() (response *StartRemediationResponse) {
	response = &StartRemediationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
