package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCompliancePackTemplates invokes the config.ListCompliancePackTemplates API synchronously
func (client *Client) ListCompliancePackTemplates(request *ListCompliancePackTemplatesRequest) (response *ListCompliancePackTemplatesResponse, err error) {
	response = CreateListCompliancePackTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCompliancePackTemplatesWithChan invokes the config.ListCompliancePackTemplates API asynchronously
func (client *Client) ListCompliancePackTemplatesWithChan(request *ListCompliancePackTemplatesRequest) (<-chan *ListCompliancePackTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListCompliancePackTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCompliancePackTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCompliancePackTemplatesWithCallback invokes the config.ListCompliancePackTemplates API asynchronously
func (client *Client) ListCompliancePackTemplatesWithCallback(request *ListCompliancePackTemplatesRequest, callback func(response *ListCompliancePackTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCompliancePackTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListCompliancePackTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCompliancePackTemplatesRequest is the request struct for api ListCompliancePackTemplates
type ListCompliancePackTemplatesRequest struct {
	*requests.RpcRequest
	CompliancePackTemplateId string           `position:"Query" name:"CompliancePackTemplateId"`
	PageNumber               requests.Integer `position:"Query" name:"PageNumber"`
	PageSize                 requests.Integer `position:"Query" name:"PageSize"`
}

// ListCompliancePackTemplatesResponse is the response struct for api ListCompliancePackTemplates
type ListCompliancePackTemplatesResponse struct {
	*responses.BaseResponse
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	CompliancePackTemplatesResult CompliancePackTemplatesResult `json:"CompliancePackTemplatesResult" xml:"CompliancePackTemplatesResult"`
}

// CreateListCompliancePackTemplatesRequest creates a request to invoke ListCompliancePackTemplates API
func CreateListCompliancePackTemplatesRequest() (request *ListCompliancePackTemplatesRequest) {
	request = &ListCompliancePackTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListCompliancePackTemplates", "", "")
	request.Method = requests.GET
	return
}

// CreateListCompliancePackTemplatesResponse creates a response to parse from ListCompliancePackTemplates response
func CreateListCompliancePackTemplatesResponse() (response *ListCompliancePackTemplatesResponse) {
	response = &ListCompliancePackTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
