package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutConfigItemsForFlat invokes the cloudcallcenter.PutConfigItemsForFlat API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemsforflat.html
func (client *Client) PutConfigItemsForFlat(request *PutConfigItemsForFlatRequest) (response *PutConfigItemsForFlatResponse, err error) {
	response = CreatePutConfigItemsForFlatResponse()
	err = client.DoAction(request, response)
	return
}

// PutConfigItemsForFlatWithChan invokes the cloudcallcenter.PutConfigItemsForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemsforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutConfigItemsForFlatWithChan(request *PutConfigItemsForFlatRequest) (<-chan *PutConfigItemsForFlatResponse, <-chan error) {
	responseChan := make(chan *PutConfigItemsForFlatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutConfigItemsForFlat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutConfigItemsForFlatWithCallback invokes the cloudcallcenter.PutConfigItemsForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putconfigitemsforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutConfigItemsForFlatWithCallback(request *PutConfigItemsForFlatRequest, callback func(response *PutConfigItemsForFlatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutConfigItemsForFlatResponse
		var err error
		defer close(result)
		response, err = client.PutConfigItemsForFlat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutConfigItemsForFlatRequest is the request struct for api PutConfigItemsForFlat
type PutConfigItemsForFlatRequest struct {
	*requests.RpcRequest
	InstanceId string    `position:"Query" name:"InstanceId"`
	ConfigItem *[]string `position:"Query" name:"ConfigItem"  type:"Repeated"`
}

// PutConfigItemsForFlatResponse is the response struct for api PutConfigItemsForFlat
type PutConfigItemsForFlatResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePutConfigItemsForFlatRequest creates a request to invoke PutConfigItemsForFlat API
func CreatePutConfigItemsForFlatRequest() (request *PutConfigItemsForFlatRequest) {
	request = &PutConfigItemsForFlatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PutConfigItemsForFlat", "", "")
	request.Method = requests.POST
	return
}

// CreatePutConfigItemsForFlatResponse creates a response to parse from PutConfigItemsForFlat response
func CreatePutConfigItemsForFlatResponse() (response *PutConfigItemsForFlatResponse) {
	response = &PutConfigItemsForFlatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
