package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteElasticPlan invokes the adb.DeleteElasticPlan API synchronously
func (client *Client) DeleteElasticPlan(request *DeleteElasticPlanRequest) (response *DeleteElasticPlanResponse, err error) {
	response = CreateDeleteElasticPlanResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteElasticPlanWithChan invokes the adb.DeleteElasticPlan API asynchronously
func (client *Client) DeleteElasticPlanWithChan(request *DeleteElasticPlanRequest) (<-chan *DeleteElasticPlanResponse, <-chan error) {
	responseChan := make(chan *DeleteElasticPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteElasticPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteElasticPlanWithCallback invokes the adb.DeleteElasticPlan API asynchronously
func (client *Client) DeleteElasticPlanWithCallback(request *DeleteElasticPlanRequest, callback func(response *DeleteElasticPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteElasticPlanResponse
		var err error
		defer close(result)
		response, err = client.DeleteElasticPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteElasticPlanRequest is the request struct for api DeleteElasticPlan
type DeleteElasticPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ElasticPlanName      string           `position:"Query" name:"ElasticPlanName"`
}

// DeleteElasticPlanResponse is the response struct for api DeleteElasticPlan
type DeleteElasticPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteElasticPlanRequest creates a request to invoke DeleteElasticPlan API
func CreateDeleteElasticPlanRequest() (request *DeleteElasticPlanRequest) {
	request = &DeleteElasticPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DeleteElasticPlan", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteElasticPlanResponse creates a response to parse from DeleteElasticPlan response
func CreateDeleteElasticPlanResponse() (response *DeleteElasticPlanResponse) {
	response = &DeleteElasticPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
