// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/type/decimal.proto

package decimal

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A representation of a decimal value, such as 2.5. Clients may convert values
// into language-native decimal formats, such as Java's [BigDecimal][] or
// Python's [decimal.Decimal][].
//
// [BigDecimal]:
// https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html
// [decimal.Decimal]: https://docs.python.org/3/library/decimal.html
type Decimal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The decimal value, as a string.
	//
	// The string representation consists of an optional sign, `+` (`U+002B`)
	// or `-` (`U+002D`), followed by a sequence of zero or more decimal digits
	// ("the integer"), optionally followed by a fraction, optionally followed
	// by an exponent.
	//
	// The fraction consists of a decimal point followed by zero or more decimal
	// digits. The string must contain at least one digit in either the integer
	// or the fraction. The number formed by the sign, the integer and the
	// fraction is referred to as the significand.
	//
	// The exponent consists of the character `e` (`U+0065`) or `E` (`U+0045`)
	// followed by one or more decimal digits.
	//
	// Services **should** normalize decimal values before storing them by:
	//
	//   - Removing an explicitly-provided `+` sign (`+2.5` -> `2.5`).
	//   - Replacing a zero-length integer value with `0` (`.5` -> `0.5`).
	//   - Coercing the exponent character to lower-case (`2.5E8` -> `2.5e8`).
	//   - Removing an explicitly-provided zero exponent (`2.5e0` -> `2.5`).
	//
	// Services **may** perform additional normalization based on its own needs
	// and the internal decimal implementation selected, such as shifting the
	// decimal point and exponent value together (example: `2.5e-1` <-> `0.25`).
	// Additionally, services **may** preserve trailing zeroes in the fraction
	// to indicate increased precision, but are not required to do so.
	//
	// Note that only the `.` character is supported to divide the integer
	// and the fraction; `,` **should not** be supported regardless of locale.
	// Additionally, thousand separators **should not** be supported. If a
	// service does support them, values **must** be normalized.
	//
	// The ENBF grammar is:
	//
	//	DecimalString =
	//	  [Sign] Significand [Exponent];
	//
	//	Sign = '+' | '-';
	//
	//	Significand =
	//	  Digits ['.'] [Digits] | [Digits] '.' Digits;
	//
	//	Exponent = ('e' | 'E') [Sign] Digits;
	//
	//	Digits = { '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' };
	//
	// Services **should** clearly document the range of supported values, the
	// maximum supported precision (total number of digits), and, if applicable,
	// the scale (number of digits after the decimal point), as well as how it
	// behaves when receiving out-of-bounds values.
	//
	// Services **may** choose to accept values passed as input even when the
	// value has a higher precision or scale than the service supports, and
	// **should** round the value to fit the supported scale. Alternatively, the
	// service **may** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC)
	// if precision would be lost.
	//
	// Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in
	// gRPC) if the service receives a value outside of the supported range.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Decimal) Reset() {
	*x = Decimal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_type_decimal_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Decimal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decimal) ProtoMessage() {}

func (x *Decimal) ProtoReflect() protoreflect.Message {
	mi := &file_google_type_decimal_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decimal.ProtoReflect.Descriptor instead.
func (*Decimal) Descriptor() ([]byte, []int) {
	return file_google_type_decimal_proto_rawDescGZIP(), []int{0}
}

func (x *Decimal) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_type_decimal_proto protoreflect.FileDescriptor

var file_google_type_decimal_proto_rawDesc = []byte{
	0x0a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x65,
	0x63, 0x69, 0x6d, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x22, 0x1f, 0x0a, 0x07, 0x44, 0x65, 0x63, 0x69,
	0x6d, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x66, 0x0a, 0x0f, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0c, 0x44, 0x65,
	0x63, 0x69, 0x6d, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c,
	0x3b, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x03, 0x47, 0x54,
	0x50, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_type_decimal_proto_rawDescOnce sync.Once
	file_google_type_decimal_proto_rawDescData = file_google_type_decimal_proto_rawDesc
)

func file_google_type_decimal_proto_rawDescGZIP() []byte {
	file_google_type_decimal_proto_rawDescOnce.Do(func() {
		file_google_type_decimal_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_type_decimal_proto_rawDescData)
	})
	return file_google_type_decimal_proto_rawDescData
}

var file_google_type_decimal_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_type_decimal_proto_goTypes = []interface{}{
	(*Decimal)(nil), // 0: google.type.Decimal
}
var file_google_type_decimal_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_type_decimal_proto_init() }
func file_google_type_decimal_proto_init() {
	if File_google_type_decimal_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_type_decimal_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Decimal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_type_decimal_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_type_decimal_proto_goTypes,
		DependencyIndexes: file_google_type_decimal_proto_depIdxs,
		MessageInfos:      file_google_type_decimal_proto_msgTypes,
	}.Build()
	File_google_type_decimal_proto = out.File
	file_google_type_decimal_proto_rawDesc = nil
	file_google_type_decimal_proto_goTypes = nil
	file_google_type_decimal_proto_depIdxs = nil
}
