// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/backup_plan.proto

package gkebackuppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State
type BackupPlan_State int32

const (
	// Default first value for Enums.
	BackupPlan_STATE_UNSPECIFIED BackupPlan_State = 0
	// Waiting for cluster state to be RUNNING.
	BackupPlan_CLUSTER_PENDING BackupPlan_State = 1
	// The BackupPlan is in the process of being created.
	BackupPlan_PROVISIONING BackupPlan_State = 2
	// The BackupPlan has successfully been created and is ready for Backups.
	BackupPlan_READY BackupPlan_State = 3
	// BackupPlan creation has failed.
	BackupPlan_FAILED BackupPlan_State = 4
	// The BackupPlan has been deactivated.
	BackupPlan_DEACTIVATED BackupPlan_State = 5
	// The BackupPlan is in the process of being deleted.
	BackupPlan_DELETING BackupPlan_State = 6
)

// Enum value maps for BackupPlan_State.
var (
	BackupPlan_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CLUSTER_PENDING",
		2: "PROVISIONING",
		3: "READY",
		4: "FAILED",
		5: "DEACTIVATED",
		6: "DELETING",
	}
	BackupPlan_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CLUSTER_PENDING":   1,
		"PROVISIONING":      2,
		"READY":             3,
		"FAILED":            4,
		"DEACTIVATED":       5,
		"DELETING":          6,
	}
)

func (x BackupPlan_State) Enum() *BackupPlan_State {
	p := new(BackupPlan_State)
	*p = x
	return p
}

func (x BackupPlan_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupPlan_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_enumTypes[0].Descriptor()
}

func (BackupPlan_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_backup_plan_proto_enumTypes[0]
}

func (x BackupPlan_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupPlan_State.Descriptor instead.
func (BackupPlan_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{0, 0}
}

// Defines the configuration and scheduling for a "line" of Backups.
type BackupPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the BackupPlan resource.
	// Format: `projects/*/locations/*/backupPlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this BackupPlan resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this BackupPlan resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User specified descriptive string for this BackupPlan.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. The source cluster from which Backups will be created
	// via this BackupPlan. Valid formats:
	//
	// - `projects/*/locations/*/clusters/*`
	// - `projects/*/zones/*/clusters/*`
	Cluster string `protobuf:"bytes,6,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. RetentionPolicy governs lifecycle of Backups created under this
	// plan.
	RetentionPolicy *BackupPlan_RetentionPolicy `protobuf:"bytes,7,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	// Optional. A set of custom labels supplied by user.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Defines a schedule for automatic Backup creation via this
	// BackupPlan.
	BackupSchedule *BackupPlan_Schedule `protobuf:"bytes,9,opt,name=backup_schedule,json=backupSchedule,proto3" json:"backup_schedule,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a backup plan from overwriting each
	// other. It is strongly suggested that systems make use of the 'etag' in the
	// read-modify-write cycle to perform BackupPlan updates in order to avoid
	// race conditions: An `etag` is returned in the response to `GetBackupPlan`,
	// and systems are expected to put that etag in the request to
	// `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
	// will be applied to the same version of the resource.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. This flag indicates whether this BackupPlan has been deactivated.
	// Setting this field to True locks the BackupPlan such that no further
	// updates will be allowed (except deletes), including the deactivated field
	// itself. It also prevents any new Backups from being created via this
	// BackupPlan (including scheduled Backups).
	//
	// Default: False
	Deactivated bool `protobuf:"varint,11,opt,name=deactivated,proto3" json:"deactivated,omitempty"`
	// Optional. Defines the configuration of Backups created via this BackupPlan.
	BackupConfig *BackupPlan_BackupConfig `protobuf:"bytes,12,opt,name=backup_config,json=backupConfig,proto3" json:"backup_config,omitempty"`
	// Output only. The number of Kubernetes Pods backed up in the
	// last successful Backup created via this BackupPlan.
	ProtectedPodCount int32 `protobuf:"varint,13,opt,name=protected_pod_count,json=protectedPodCount,proto3" json:"protected_pod_count,omitempty"`
	// Output only. State of the BackupPlan. This State field reflects the
	// various stages a BackupPlan can be in
	// during the Create operation. It will be set to "DEACTIVATED"
	// if the BackupPlan is deactivated on an Update
	State BackupPlan_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.BackupPlan_State" json:"state,omitempty"`
	// Output only. Human-readable description of why BackupPlan is in the current
	// `state`. This field is only meant for human readability and should not be
	// used programmatically as this field is not guaranteed to be consistent.
	StateReason string `protobuf:"bytes,15,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// Output only. A number that represents the current risk level of this
	// BackupPlan from RPO perspective with 1 being no risk and 5 being highest
	// risk.
	RpoRiskLevel int32 `protobuf:"varint,16,opt,name=rpo_risk_level,json=rpoRiskLevel,proto3" json:"rpo_risk_level,omitempty"`
	// Output only. Human-readable description of why the BackupPlan is in the
	// current rpo_risk_level and action items if any.
	RpoRiskReason string `protobuf:"bytes,17,opt,name=rpo_risk_reason,json=rpoRiskReason,proto3" json:"rpo_risk_reason,omitempty"`
	// Output only. Completion time of the last successful Backup. This is sourced
	// from a successful Backup's complete_time field. This field is added to
	// maintain consistency with BackupPlanBinding to display last successful
	// backup time.
	LastSuccessfulBackupTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=last_successful_backup_time,json=lastSuccessfulBackupTime,proto3" json:"last_successful_backup_time,omitempty"`
}

func (x *BackupPlan) Reset() {
	*x = BackupPlan{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlan) ProtoMessage() {}

func (x *BackupPlan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlan.ProtoReflect.Descriptor instead.
func (*BackupPlan) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{0}
}

func (x *BackupPlan) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupPlan) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *BackupPlan) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupPlan) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BackupPlan) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BackupPlan) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *BackupPlan) GetRetentionPolicy() *BackupPlan_RetentionPolicy {
	if x != nil {
		return x.RetentionPolicy
	}
	return nil
}

func (x *BackupPlan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BackupPlan) GetBackupSchedule() *BackupPlan_Schedule {
	if x != nil {
		return x.BackupSchedule
	}
	return nil
}

func (x *BackupPlan) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *BackupPlan) GetDeactivated() bool {
	if x != nil {
		return x.Deactivated
	}
	return false
}

func (x *BackupPlan) GetBackupConfig() *BackupPlan_BackupConfig {
	if x != nil {
		return x.BackupConfig
	}
	return nil
}

func (x *BackupPlan) GetProtectedPodCount() int32 {
	if x != nil {
		return x.ProtectedPodCount
	}
	return 0
}

func (x *BackupPlan) GetState() BackupPlan_State {
	if x != nil {
		return x.State
	}
	return BackupPlan_STATE_UNSPECIFIED
}

func (x *BackupPlan) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *BackupPlan) GetRpoRiskLevel() int32 {
	if x != nil {
		return x.RpoRiskLevel
	}
	return 0
}

func (x *BackupPlan) GetRpoRiskReason() string {
	if x != nil {
		return x.RpoRiskReason
	}
	return ""
}

func (x *BackupPlan) GetLastSuccessfulBackupTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSuccessfulBackupTime
	}
	return nil
}

// Defines RPO scheduling configuration for automatically creating
// Backups via this BackupPlan.
type RpoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Defines the target RPO for the BackupPlan in minutes, which means
	// the target maximum data loss in time that is acceptable for this
	// BackupPlan. This must be at least 60, i.e., 1 hour, and at most 86400,
	// i.e., 60 days.
	TargetRpoMinutes int32 `protobuf:"varint,1,opt,name=target_rpo_minutes,json=targetRpoMinutes,proto3" json:"target_rpo_minutes,omitempty"`
	// Optional. User specified time windows during which backup can NOT happen
	// for this BackupPlan - backups should start and finish outside of any given
	// exclusion window. Note: backup jobs will be scheduled to start and
	// finish outside the duration of the window as much as possible, but
	// running jobs will not get canceled when it runs into the window.
	// All the time and date values in exclusion_windows entry in the API are in
	// UTC.
	// We only allow <=1 recurrence (daily or weekly) exclusion window for a
	// BackupPlan while no restriction on number of single occurrence
	// windows.
	ExclusionWindows []*ExclusionWindow `protobuf:"bytes,2,rep,name=exclusion_windows,json=exclusionWindows,proto3" json:"exclusion_windows,omitempty"`
}

func (x *RpoConfig) Reset() {
	*x = RpoConfig{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RpoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpoConfig) ProtoMessage() {}

func (x *RpoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RpoConfig.ProtoReflect.Descriptor instead.
func (*RpoConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{1}
}

func (x *RpoConfig) GetTargetRpoMinutes() int32 {
	if x != nil {
		return x.TargetRpoMinutes
	}
	return 0
}

func (x *RpoConfig) GetExclusionWindows() []*ExclusionWindow {
	if x != nil {
		return x.ExclusionWindows
	}
	return nil
}

// Defines a time window during which no backup should
// happen. All time and date are in UTC.
type ExclusionWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the start time of the window using time of the day in
	// UTC.
	StartTime *timeofday.TimeOfDay `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Required. Specifies duration of the window.
	// Duration must be >= 5 minutes and < (target RPO - 20 minutes).
	// Additional restrictions based on the recurrence type to allow some time for
	// backup to happen:
	// - single_occurrence_date:  no restriction, but UI may warn about this when
	// duration >= target RPO
	// - daily window: duration < 24 hours
	// - weekly window:
	//   - days of week includes all seven days of a week: duration < 24 hours
	//   - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// Required. Specifies the day(s) on which the exclusion window takes
	// effect. Exactly one of the fields MUST be specified.
	//
	// Types that are assignable to Recurrence:
	//
	//	*ExclusionWindow_SingleOccurrenceDate
	//	*ExclusionWindow_Daily
	//	*ExclusionWindow_DaysOfWeek
	Recurrence isExclusionWindow_Recurrence `protobuf_oneof:"recurrence"`
}

func (x *ExclusionWindow) Reset() {
	*x = ExclusionWindow{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExclusionWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExclusionWindow) ProtoMessage() {}

func (x *ExclusionWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExclusionWindow.ProtoReflect.Descriptor instead.
func (*ExclusionWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{2}
}

func (x *ExclusionWindow) GetStartTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExclusionWindow) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (m *ExclusionWindow) GetRecurrence() isExclusionWindow_Recurrence {
	if m != nil {
		return m.Recurrence
	}
	return nil
}

func (x *ExclusionWindow) GetSingleOccurrenceDate() *date.Date {
	if x, ok := x.GetRecurrence().(*ExclusionWindow_SingleOccurrenceDate); ok {
		return x.SingleOccurrenceDate
	}
	return nil
}

func (x *ExclusionWindow) GetDaily() bool {
	if x, ok := x.GetRecurrence().(*ExclusionWindow_Daily); ok {
		return x.Daily
	}
	return false
}

func (x *ExclusionWindow) GetDaysOfWeek() *ExclusionWindow_DayOfWeekList {
	if x, ok := x.GetRecurrence().(*ExclusionWindow_DaysOfWeek); ok {
		return x.DaysOfWeek
	}
	return nil
}

type isExclusionWindow_Recurrence interface {
	isExclusionWindow_Recurrence()
}

type ExclusionWindow_SingleOccurrenceDate struct {
	// No recurrence. The exclusion window occurs only once and on this
	// date in UTC.
	SingleOccurrenceDate *date.Date `protobuf:"bytes,3,opt,name=single_occurrence_date,json=singleOccurrenceDate,proto3,oneof"`
}

type ExclusionWindow_Daily struct {
	// The exclusion window occurs every day if set to "True".
	// Specifying this field to "False" is an error.
	Daily bool `protobuf:"varint,4,opt,name=daily,proto3,oneof"`
}

type ExclusionWindow_DaysOfWeek struct {
	// The exclusion window occurs on these days of each week in UTC.
	DaysOfWeek *ExclusionWindow_DayOfWeekList `protobuf:"bytes,5,opt,name=days_of_week,json=daysOfWeek,proto3,oneof"`
}

func (*ExclusionWindow_SingleOccurrenceDate) isExclusionWindow_Recurrence() {}

func (*ExclusionWindow_Daily) isExclusionWindow_Recurrence() {}

func (*ExclusionWindow_DaysOfWeek) isExclusionWindow_Recurrence() {}

// RetentionPolicy defines a Backup retention policy for a BackupPlan.
type BackupPlan_RetentionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Minimum age for Backups created via this BackupPlan (in days).
	// This field MUST be an integer value between 0-90 (inclusive).
	// A Backup created under this BackupPlan will NOT be deletable until it
	// reaches Backup's (create_time + backup_delete_lock_days).
	// Updating this field of a BackupPlan does NOT affect existing Backups
	// under it. Backups created AFTER a successful update will inherit
	// the new value.
	//
	// Default: 0 (no delete blocking)
	BackupDeleteLockDays int32 `protobuf:"varint,1,opt,name=backup_delete_lock_days,json=backupDeleteLockDays,proto3" json:"backup_delete_lock_days,omitempty"`
	// Optional. The default maximum age of a Backup created via this
	// BackupPlan. This field MUST be an integer value >= 0 and <= 365. If
	// specified, a Backup created under this BackupPlan will be automatically
	// deleted after its age reaches (create_time + backup_retain_days). If not
	// specified, Backups created under this BackupPlan will NOT be subject to
	// automatic deletion. Updating this field does NOT affect existing Backups
	// under it. Backups created AFTER a successful update will automatically
	// pick up the new value. NOTE: backup_retain_days must be >=
	// [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
	// If
	// [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
	// is defined, then this must be
	// <= 360 * the creation interval. If
	// [rpo_config][google.cloud.gkebackup.v1.BackupPlan.Schedule.rpo_config] is
	// defined, then this must be
	// <= 360 * [target_rpo_minutes][Schedule.rpo_config.target_rpo_minutes] /
	// (1440minutes/day).
	//
	// Default: 0 (no automatic deletion)
	BackupRetainDays int32 `protobuf:"varint,2,opt,name=backup_retain_days,json=backupRetainDays,proto3" json:"backup_retain_days,omitempty"`
	// Optional. This flag denotes whether the retention policy of this
	// BackupPlan is locked.  If set to True, no further update is allowed on
	// this policy, including the `locked` field itself.
	//
	// Default: False
	Locked bool `protobuf:"varint,3,opt,name=locked,proto3" json:"locked,omitempty"`
}

func (x *BackupPlan_RetentionPolicy) Reset() {
	*x = BackupPlan_RetentionPolicy{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlan_RetentionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlan_RetentionPolicy) ProtoMessage() {}

func (x *BackupPlan_RetentionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlan_RetentionPolicy.ProtoReflect.Descriptor instead.
func (*BackupPlan_RetentionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BackupPlan_RetentionPolicy) GetBackupDeleteLockDays() int32 {
	if x != nil {
		return x.BackupDeleteLockDays
	}
	return 0
}

func (x *BackupPlan_RetentionPolicy) GetBackupRetainDays() int32 {
	if x != nil {
		return x.BackupRetainDays
	}
	return 0
}

func (x *BackupPlan_RetentionPolicy) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

// Defines scheduling parameters for automatically creating Backups
// via this BackupPlan.
type BackupPlan_Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A standard [cron](https://wikipedia.com/wiki/cron) string that
	// defines a repeating schedule for creating Backups via this BackupPlan.
	// This is mutually exclusive with the
	// [rpo_config][google.cloud.gkebackup.v1.BackupPlan.Schedule.rpo_config]
	// field since at most one schedule can be defined for a BackupPlan. If this
	// is defined, then
	// [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
	// must also be defined.
	//
	// Default (empty): no automatic backup creation will occur.
	CronSchedule string `protobuf:"bytes,1,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	// Optional. This flag denotes whether automatic Backup creation is paused
	// for this BackupPlan.
	//
	// Default: False
	Paused bool `protobuf:"varint,2,opt,name=paused,proto3" json:"paused,omitempty"`
	// Optional. Defines the RPO schedule configuration for this BackupPlan.
	// This is mutually exclusive with the
	// [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
	// field since at most one schedule can be defined for a BackupPLan. If this
	// is defined, then
	// [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
	// must also be defined.
	//
	// Default (empty): no automatic backup creation will occur.
	RpoConfig *RpoConfig `protobuf:"bytes,3,opt,name=rpo_config,json=rpoConfig,proto3" json:"rpo_config,omitempty"`
	// Output only. Start time of next scheduled backup under this BackupPlan by
	// either cron_schedule or rpo config.
	NextScheduledBackupTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=next_scheduled_backup_time,json=nextScheduledBackupTime,proto3" json:"next_scheduled_backup_time,omitempty"`
}

func (x *BackupPlan_Schedule) Reset() {
	*x = BackupPlan_Schedule{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlan_Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlan_Schedule) ProtoMessage() {}

func (x *BackupPlan_Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlan_Schedule.ProtoReflect.Descriptor instead.
func (*BackupPlan_Schedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{0, 1}
}

func (x *BackupPlan_Schedule) GetCronSchedule() string {
	if x != nil {
		return x.CronSchedule
	}
	return ""
}

func (x *BackupPlan_Schedule) GetPaused() bool {
	if x != nil {
		return x.Paused
	}
	return false
}

func (x *BackupPlan_Schedule) GetRpoConfig() *RpoConfig {
	if x != nil {
		return x.RpoConfig
	}
	return nil
}

func (x *BackupPlan_Schedule) GetNextScheduledBackupTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextScheduledBackupTime
	}
	return nil
}

// BackupConfig defines the configuration of Backups created via this
// BackupPlan.
type BackupPlan_BackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This defines the "scope" of the Backup - which namespaced
	// resources in the cluster will be included in a Backup.
	// Exactly one of the fields of backup_scope MUST be specified.
	//
	// Types that are assignable to BackupScope:
	//
	//	*BackupPlan_BackupConfig_AllNamespaces
	//	*BackupPlan_BackupConfig_SelectedNamespaces
	//	*BackupPlan_BackupConfig_SelectedApplications
	BackupScope isBackupPlan_BackupConfig_BackupScope `protobuf_oneof:"backup_scope"`
	// Optional. This flag specifies whether volume data should be backed up
	// when PVCs are included in the scope of a Backup.
	//
	// Default: False
	IncludeVolumeData bool `protobuf:"varint,4,opt,name=include_volume_data,json=includeVolumeData,proto3" json:"include_volume_data,omitempty"`
	// Optional. This flag specifies whether Kubernetes Secret resources should
	// be included when they fall into the scope of Backups.
	//
	// Default: False
	IncludeSecrets bool `protobuf:"varint,5,opt,name=include_secrets,json=includeSecrets,proto3" json:"include_secrets,omitempty"`
	// Optional. This defines a customer managed encryption key that will be
	// used to encrypt the "config" portion (the Kubernetes resources) of
	// Backups created via this plan.
	//
	// Default (empty): Config backup artifacts will not be encrypted.
	EncryptionKey *EncryptionKey `protobuf:"bytes,6,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// Optional. If false, Backups will fail when Backup for GKE detects
	// Kubernetes configuration that is non-standard or
	// requires additional setup to restore.
	//
	// Default: False
	PermissiveMode bool `protobuf:"varint,7,opt,name=permissive_mode,json=permissiveMode,proto3" json:"permissive_mode,omitempty"`
}

func (x *BackupPlan_BackupConfig) Reset() {
	*x = BackupPlan_BackupConfig{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlan_BackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlan_BackupConfig) ProtoMessage() {}

func (x *BackupPlan_BackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlan_BackupConfig.ProtoReflect.Descriptor instead.
func (*BackupPlan_BackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{0, 2}
}

func (m *BackupPlan_BackupConfig) GetBackupScope() isBackupPlan_BackupConfig_BackupScope {
	if m != nil {
		return m.BackupScope
	}
	return nil
}

func (x *BackupPlan_BackupConfig) GetAllNamespaces() bool {
	if x, ok := x.GetBackupScope().(*BackupPlan_BackupConfig_AllNamespaces); ok {
		return x.AllNamespaces
	}
	return false
}

func (x *BackupPlan_BackupConfig) GetSelectedNamespaces() *Namespaces {
	if x, ok := x.GetBackupScope().(*BackupPlan_BackupConfig_SelectedNamespaces); ok {
		return x.SelectedNamespaces
	}
	return nil
}

func (x *BackupPlan_BackupConfig) GetSelectedApplications() *NamespacedNames {
	if x, ok := x.GetBackupScope().(*BackupPlan_BackupConfig_SelectedApplications); ok {
		return x.SelectedApplications
	}
	return nil
}

func (x *BackupPlan_BackupConfig) GetIncludeVolumeData() bool {
	if x != nil {
		return x.IncludeVolumeData
	}
	return false
}

func (x *BackupPlan_BackupConfig) GetIncludeSecrets() bool {
	if x != nil {
		return x.IncludeSecrets
	}
	return false
}

func (x *BackupPlan_BackupConfig) GetEncryptionKey() *EncryptionKey {
	if x != nil {
		return x.EncryptionKey
	}
	return nil
}

func (x *BackupPlan_BackupConfig) GetPermissiveMode() bool {
	if x != nil {
		return x.PermissiveMode
	}
	return false
}

type isBackupPlan_BackupConfig_BackupScope interface {
	isBackupPlan_BackupConfig_BackupScope()
}

type BackupPlan_BackupConfig_AllNamespaces struct {
	// If True, include all namespaced resources
	AllNamespaces bool `protobuf:"varint,1,opt,name=all_namespaces,json=allNamespaces,proto3,oneof"`
}

type BackupPlan_BackupConfig_SelectedNamespaces struct {
	// If set, include just the resources in the listed namespaces.
	SelectedNamespaces *Namespaces `protobuf:"bytes,2,opt,name=selected_namespaces,json=selectedNamespaces,proto3,oneof"`
}

type BackupPlan_BackupConfig_SelectedApplications struct {
	// If set, include just the resources referenced by the listed
	// ProtectedApplications.
	SelectedApplications *NamespacedNames `protobuf:"bytes,3,opt,name=selected_applications,json=selectedApplications,proto3,oneof"`
}

func (*BackupPlan_BackupConfig_AllNamespaces) isBackupPlan_BackupConfig_BackupScope() {}

func (*BackupPlan_BackupConfig_SelectedNamespaces) isBackupPlan_BackupConfig_BackupScope() {}

func (*BackupPlan_BackupConfig_SelectedApplications) isBackupPlan_BackupConfig_BackupScope() {}

// Holds repeated DaysOfWeek values as a container.
type ExclusionWindow_DayOfWeekList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of days of week.
	DaysOfWeek []dayofweek.DayOfWeek `protobuf:"varint,1,rep,packed,name=days_of_week,json=daysOfWeek,proto3,enum=google.type.DayOfWeek" json:"days_of_week,omitempty"`
}

func (x *ExclusionWindow_DayOfWeekList) Reset() {
	*x = ExclusionWindow_DayOfWeekList{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExclusionWindow_DayOfWeekList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExclusionWindow_DayOfWeekList) ProtoMessage() {}

func (x *ExclusionWindow_DayOfWeekList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExclusionWindow_DayOfWeekList.ProtoReflect.Descriptor instead.
func (*ExclusionWindow_DayOfWeekList) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ExclusionWindow_DayOfWeekList) GetDaysOfWeek() []dayofweek.DayOfWeek {
	if x != nil {
		return x.DaysOfWeek
	}
	return nil
}

var File_google_cloud_gkebackup_v1_backup_plan_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_backup_plan_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xed, 0x11, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x05, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x65, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x64, 0x12, 0x5c, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x50, 0x6f, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x0e, 0x72, 0x70, 0x6f, 0x5f,
	0x72, 0x69, 0x73, 0x6b, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x70, 0x6f, 0x52, 0x69, 0x73, 0x6b, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x2b, 0x0a, 0x0f, 0x72, 0x70, 0x6f, 0x5f, 0x72, 0x69, 0x73, 0x6b, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x72, 0x70, 0x6f, 0x52, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x5e, 0x0a, 0x1b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x66, 0x75, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x69, 0x6d, 0x65,
	0x1a, 0x9d, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x3a, 0x0a, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x61, 0x79, 0x73,
	0x12, 0x31, 0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x44,
	0x61, 0x79, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64,
	0x1a, 0xf9, 0x01, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x63, 0x72, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x72, 0x6f, 0x6e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x70, 0x61,
	0x75, 0x73, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x0a, 0x72, 0x70, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x70, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x70, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c,
	0x0a, 0x1a, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x17, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xeb, 0x03, 0x0a,
	0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x27, 0x0a,
	0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x61, 0x0a, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x48, 0x00, 0x52, 0x14, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x0f,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52,
	0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x06, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x23, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x41, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d, 0x22,
	0x9c, 0x01, 0x0a, 0x09, 0x52, 0x70, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a,
	0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x70, 0x6f, 0x5f, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x70, 0x6f, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x5c, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x22, 0xa8,
	0x03, 0x0a, 0x0f, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x12, 0x3a, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x16, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x12, 0x5c, 0x0a,
	0x0c, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e,
	0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x0a, 0x64, 0x61, 0x79, 0x73, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x1a, 0x4e, 0x0a, 0x0d, 0x44,
	0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x0c,
	0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x64, 0x61, 0x79, 0x73, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x0c, 0x0a, 0x0a, 0x72,
	0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0xc6, 0x01, 0x0a, 0x1d, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescData = file_google_cloud_gkebackup_v1_backup_plan_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_backup_plan_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_backup_plan_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_gkebackup_v1_backup_plan_proto_goTypes = []any{
	(BackupPlan_State)(0),                 // 0: google.cloud.gkebackup.v1.BackupPlan.State
	(*BackupPlan)(nil),                    // 1: google.cloud.gkebackup.v1.BackupPlan
	(*RpoConfig)(nil),                     // 2: google.cloud.gkebackup.v1.RpoConfig
	(*ExclusionWindow)(nil),               // 3: google.cloud.gkebackup.v1.ExclusionWindow
	(*BackupPlan_RetentionPolicy)(nil),    // 4: google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy
	(*BackupPlan_Schedule)(nil),           // 5: google.cloud.gkebackup.v1.BackupPlan.Schedule
	(*BackupPlan_BackupConfig)(nil),       // 6: google.cloud.gkebackup.v1.BackupPlan.BackupConfig
	nil,                                   // 7: google.cloud.gkebackup.v1.BackupPlan.LabelsEntry
	(*ExclusionWindow_DayOfWeekList)(nil), // 8: google.cloud.gkebackup.v1.ExclusionWindow.DayOfWeekList
	(*timestamppb.Timestamp)(nil),         // 9: google.protobuf.Timestamp
	(*timeofday.TimeOfDay)(nil),           // 10: google.type.TimeOfDay
	(*durationpb.Duration)(nil),           // 11: google.protobuf.Duration
	(*date.Date)(nil),                     // 12: google.type.Date
	(*Namespaces)(nil),                    // 13: google.cloud.gkebackup.v1.Namespaces
	(*NamespacedNames)(nil),               // 14: google.cloud.gkebackup.v1.NamespacedNames
	(*EncryptionKey)(nil),                 // 15: google.cloud.gkebackup.v1.EncryptionKey
	(dayofweek.DayOfWeek)(0),              // 16: google.type.DayOfWeek
}
var file_google_cloud_gkebackup_v1_backup_plan_proto_depIdxs = []int32{
	9,  // 0: google.cloud.gkebackup.v1.BackupPlan.create_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.cloud.gkebackup.v1.BackupPlan.update_time:type_name -> google.protobuf.Timestamp
	4,  // 2: google.cloud.gkebackup.v1.BackupPlan.retention_policy:type_name -> google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy
	7,  // 3: google.cloud.gkebackup.v1.BackupPlan.labels:type_name -> google.cloud.gkebackup.v1.BackupPlan.LabelsEntry
	5,  // 4: google.cloud.gkebackup.v1.BackupPlan.backup_schedule:type_name -> google.cloud.gkebackup.v1.BackupPlan.Schedule
	6,  // 5: google.cloud.gkebackup.v1.BackupPlan.backup_config:type_name -> google.cloud.gkebackup.v1.BackupPlan.BackupConfig
	0,  // 6: google.cloud.gkebackup.v1.BackupPlan.state:type_name -> google.cloud.gkebackup.v1.BackupPlan.State
	9,  // 7: google.cloud.gkebackup.v1.BackupPlan.last_successful_backup_time:type_name -> google.protobuf.Timestamp
	3,  // 8: google.cloud.gkebackup.v1.RpoConfig.exclusion_windows:type_name -> google.cloud.gkebackup.v1.ExclusionWindow
	10, // 9: google.cloud.gkebackup.v1.ExclusionWindow.start_time:type_name -> google.type.TimeOfDay
	11, // 10: google.cloud.gkebackup.v1.ExclusionWindow.duration:type_name -> google.protobuf.Duration
	12, // 11: google.cloud.gkebackup.v1.ExclusionWindow.single_occurrence_date:type_name -> google.type.Date
	8,  // 12: google.cloud.gkebackup.v1.ExclusionWindow.days_of_week:type_name -> google.cloud.gkebackup.v1.ExclusionWindow.DayOfWeekList
	2,  // 13: google.cloud.gkebackup.v1.BackupPlan.Schedule.rpo_config:type_name -> google.cloud.gkebackup.v1.RpoConfig
	9,  // 14: google.cloud.gkebackup.v1.BackupPlan.Schedule.next_scheduled_backup_time:type_name -> google.protobuf.Timestamp
	13, // 15: google.cloud.gkebackup.v1.BackupPlan.BackupConfig.selected_namespaces:type_name -> google.cloud.gkebackup.v1.Namespaces
	14, // 16: google.cloud.gkebackup.v1.BackupPlan.BackupConfig.selected_applications:type_name -> google.cloud.gkebackup.v1.NamespacedNames
	15, // 17: google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key:type_name -> google.cloud.gkebackup.v1.EncryptionKey
	16, // 18: google.cloud.gkebackup.v1.ExclusionWindow.DayOfWeekList.days_of_week:type_name -> google.type.DayOfWeek
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_backup_plan_proto_init() }
func file_google_cloud_gkebackup_v1_backup_plan_proto_init() {
	if File_google_cloud_gkebackup_v1_backup_plan_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_common_proto_init()
	file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[2].OneofWrappers = []any{
		(*ExclusionWindow_SingleOccurrenceDate)(nil),
		(*ExclusionWindow_Daily)(nil),
		(*ExclusionWindow_DaysOfWeek)(nil),
	}
	file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes[5].OneofWrappers = []any{
		(*BackupPlan_BackupConfig_AllNamespaces)(nil),
		(*BackupPlan_BackupConfig_SelectedNamespaces)(nil),
		(*BackupPlan_BackupConfig_SelectedApplications)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_backup_plan_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_backup_plan_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_backup_plan_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_backup_plan_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_backup_plan_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_backup_plan_proto = out.File
	file_google_cloud_gkebackup_v1_backup_plan_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_backup_plan_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_backup_plan_proto_depIdxs = nil
}
