// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/reasoning_engine_execution_service.proto

package aiplatformpb

import (
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for [ReasoningEngineExecutionService.Query][].
type QueryReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReasoningEngine resource to use.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Input content provided by users in JSON object format. Examples
	// include text query, function calling parameters, media bytes, etc.
	Input *structpb.Struct `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// Optional. Class method to be used for the query.
	// It is optional and defaults to "query" if unspecified.
	ClassMethod string `protobuf:"bytes,3,opt,name=class_method,json=classMethod,proto3" json:"class_method,omitempty"`
}

func (x *QueryReasoningEngineRequest) Reset() {
	*x = QueryReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryReasoningEngineRequest) ProtoMessage() {}

func (x *QueryReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*QueryReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescGZIP(), []int{0}
}

func (x *QueryReasoningEngineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryReasoningEngineRequest) GetInput() *structpb.Struct {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *QueryReasoningEngineRequest) GetClassMethod() string {
	if x != nil {
		return x.ClassMethod
	}
	return ""
}

// Response message for [ReasoningEngineExecutionService.Query][]
type QueryReasoningEngineResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response provided by users in JSON object format.
	Output *structpb.Value `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *QueryReasoningEngineResponse) Reset() {
	*x = QueryReasoningEngineResponse{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryReasoningEngineResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryReasoningEngineResponse) ProtoMessage() {}

func (x *QueryReasoningEngineResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryReasoningEngineResponse.ProtoReflect.Descriptor instead.
func (*QueryReasoningEngineResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescGZIP(), []int{1}
}

func (x *QueryReasoningEngineResponse) GetOutput() *structpb.Value {
	if x != nil {
		return x.Output
	}
	return nil
}

// Request message for [ReasoningEngineExecutionService.StreamQuery][].
type StreamQueryReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReasoningEngine resource to use.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Input content provided by users in JSON object format. Examples
	// include text query, function calling parameters, media bytes, etc.
	Input *structpb.Struct `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// Optional. Class method to be used for the stream query.
	// It is optional and defaults to "stream_query" if unspecified.
	ClassMethod string `protobuf:"bytes,3,opt,name=class_method,json=classMethod,proto3" json:"class_method,omitempty"`
}

func (x *StreamQueryReasoningEngineRequest) Reset() {
	*x = StreamQueryReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamQueryReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamQueryReasoningEngineRequest) ProtoMessage() {}

func (x *StreamQueryReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamQueryReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*StreamQueryReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescGZIP(), []int{2}
}

func (x *StreamQueryReasoningEngineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StreamQueryReasoningEngineRequest) GetInput() *structpb.Struct {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *StreamQueryReasoningEngineRequest) GetClassMethod() string {
	if x != nil {
		return x.ClassMethod
	}
	return ""
}

var File_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x01,
	0x0a, 0x1b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x22, 0x4e, 0x0a, 0x1c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2e, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x22, 0xc6, 0x01, 0x0a, 0x21, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x32, 0x86, 0x04, 0x0a, 0x1f, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd0, 0x01,
	0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x12, 0xc0, 0x01, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x42, 0x6f, 0x64, 0x79, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x30, 0x01, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xe2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x24, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescData = file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_goTypes = []any{
	(*QueryReasoningEngineRequest)(nil),       // 0: google.cloud.aiplatform.v1.QueryReasoningEngineRequest
	(*QueryReasoningEngineResponse)(nil),      // 1: google.cloud.aiplatform.v1.QueryReasoningEngineResponse
	(*StreamQueryReasoningEngineRequest)(nil), // 2: google.cloud.aiplatform.v1.StreamQueryReasoningEngineRequest
	(*structpb.Struct)(nil),                   // 3: google.protobuf.Struct
	(*structpb.Value)(nil),                    // 4: google.protobuf.Value
	(*httpbody.HttpBody)(nil),                 // 5: google.api.HttpBody
}
var file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_depIdxs = []int32{
	3, // 0: google.cloud.aiplatform.v1.QueryReasoningEngineRequest.input:type_name -> google.protobuf.Struct
	4, // 1: google.cloud.aiplatform.v1.QueryReasoningEngineResponse.output:type_name -> google.protobuf.Value
	3, // 2: google.cloud.aiplatform.v1.StreamQueryReasoningEngineRequest.input:type_name -> google.protobuf.Struct
	0, // 3: google.cloud.aiplatform.v1.ReasoningEngineExecutionService.QueryReasoningEngine:input_type -> google.cloud.aiplatform.v1.QueryReasoningEngineRequest
	2, // 4: google.cloud.aiplatform.v1.ReasoningEngineExecutionService.StreamQueryReasoningEngine:input_type -> google.cloud.aiplatform.v1.StreamQueryReasoningEngineRequest
	1, // 5: google.cloud.aiplatform.v1.ReasoningEngineExecutionService.QueryReasoningEngine:output_type -> google.cloud.aiplatform.v1.QueryReasoningEngineResponse
	5, // 6: google.cloud.aiplatform.v1.ReasoningEngineExecutionService.StreamQueryReasoningEngine:output_type -> google.api.HttpBody
	5, // [5:7] is the sub-list for method output_type
	3, // [3:5] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_init() }
func file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_init() {
	if File_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto = out.File
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_execution_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReasoningEngineExecutionServiceClient is the client API for ReasoningEngineExecutionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReasoningEngineExecutionServiceClient interface {
	// Queries using a reasoning engine.
	QueryReasoningEngine(ctx context.Context, in *QueryReasoningEngineRequest, opts ...grpc.CallOption) (*QueryReasoningEngineResponse, error)
	// Streams queries using a reasoning engine.
	StreamQueryReasoningEngine(ctx context.Context, in *StreamQueryReasoningEngineRequest, opts ...grpc.CallOption) (ReasoningEngineExecutionService_StreamQueryReasoningEngineClient, error)
}

type reasoningEngineExecutionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReasoningEngineExecutionServiceClient(cc grpc.ClientConnInterface) ReasoningEngineExecutionServiceClient {
	return &reasoningEngineExecutionServiceClient{cc}
}

func (c *reasoningEngineExecutionServiceClient) QueryReasoningEngine(ctx context.Context, in *QueryReasoningEngineRequest, opts ...grpc.CallOption) (*QueryReasoningEngineResponse, error) {
	out := new(QueryReasoningEngineResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineExecutionService/QueryReasoningEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineExecutionServiceClient) StreamQueryReasoningEngine(ctx context.Context, in *StreamQueryReasoningEngineRequest, opts ...grpc.CallOption) (ReasoningEngineExecutionService_StreamQueryReasoningEngineClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ReasoningEngineExecutionService_serviceDesc.Streams[0], "/google.cloud.aiplatform.v1.ReasoningEngineExecutionService/StreamQueryReasoningEngine", opts...)
	if err != nil {
		return nil, err
	}
	x := &reasoningEngineExecutionServiceStreamQueryReasoningEngineClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReasoningEngineExecutionService_StreamQueryReasoningEngineClient interface {
	Recv() (*httpbody.HttpBody, error)
	grpc.ClientStream
}

type reasoningEngineExecutionServiceStreamQueryReasoningEngineClient struct {
	grpc.ClientStream
}

func (x *reasoningEngineExecutionServiceStreamQueryReasoningEngineClient) Recv() (*httpbody.HttpBody, error) {
	m := new(httpbody.HttpBody)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ReasoningEngineExecutionServiceServer is the server API for ReasoningEngineExecutionService service.
type ReasoningEngineExecutionServiceServer interface {
	// Queries using a reasoning engine.
	QueryReasoningEngine(context.Context, *QueryReasoningEngineRequest) (*QueryReasoningEngineResponse, error)
	// Streams queries using a reasoning engine.
	StreamQueryReasoningEngine(*StreamQueryReasoningEngineRequest, ReasoningEngineExecutionService_StreamQueryReasoningEngineServer) error
}

// UnimplementedReasoningEngineExecutionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReasoningEngineExecutionServiceServer struct {
}

func (*UnimplementedReasoningEngineExecutionServiceServer) QueryReasoningEngine(context.Context, *QueryReasoningEngineRequest) (*QueryReasoningEngineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryReasoningEngine not implemented")
}
func (*UnimplementedReasoningEngineExecutionServiceServer) StreamQueryReasoningEngine(*StreamQueryReasoningEngineRequest, ReasoningEngineExecutionService_StreamQueryReasoningEngineServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamQueryReasoningEngine not implemented")
}

func RegisterReasoningEngineExecutionServiceServer(s *grpc.Server, srv ReasoningEngineExecutionServiceServer) {
	s.RegisterService(&_ReasoningEngineExecutionService_serviceDesc, srv)
}

func _ReasoningEngineExecutionService_QueryReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineExecutionServiceServer).QueryReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineExecutionService/QueryReasoningEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineExecutionServiceServer).QueryReasoningEngine(ctx, req.(*QueryReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineExecutionService_StreamQueryReasoningEngine_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamQueryReasoningEngineRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReasoningEngineExecutionServiceServer).StreamQueryReasoningEngine(m, &reasoningEngineExecutionServiceStreamQueryReasoningEngineServer{stream})
}

type ReasoningEngineExecutionService_StreamQueryReasoningEngineServer interface {
	Send(*httpbody.HttpBody) error
	grpc.ServerStream
}

type reasoningEngineExecutionServiceStreamQueryReasoningEngineServer struct {
	grpc.ServerStream
}

func (x *reasoningEngineExecutionServiceStreamQueryReasoningEngineServer) Send(m *httpbody.HttpBody) error {
	return x.ServerStream.SendMsg(m)
}

var _ReasoningEngineExecutionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.ReasoningEngineExecutionService",
	HandlerType: (*ReasoningEngineExecutionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryReasoningEngine",
			Handler:    _ReasoningEngineExecutionService_QueryReasoningEngine_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamQueryReasoningEngine",
			Handler:       _ReasoningEngineExecutionService_StreamQueryReasoningEngine_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1/reasoning_engine_execution_service.proto",
}
