// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/data_documentation.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// DataDocumentation scan related spec.
type DataDocumentationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataDocumentationSpec) Reset() {
	*x = DataDocumentationSpec{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationSpec) ProtoMessage() {}

func (x *DataDocumentationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationSpec.ProtoReflect.Descriptor instead.
func (*DataDocumentationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{0}
}

// The output of a DataDocumentation scan.
type DataDocumentationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the data documentation scan.
	//
	// Types that are assignable to Result:
	//
	//	*DataDocumentationResult_TableResult_
	Result isDataDocumentationResult_Result `protobuf_oneof:"result"`
}

func (x *DataDocumentationResult) Reset() {
	*x = DataDocumentationResult{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationResult) ProtoMessage() {}

func (x *DataDocumentationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationResult.ProtoReflect.Descriptor instead.
func (*DataDocumentationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{1}
}

func (m *DataDocumentationResult) GetResult() isDataDocumentationResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataDocumentationResult) GetTableResult() *DataDocumentationResult_TableResult {
	if x, ok := x.GetResult().(*DataDocumentationResult_TableResult_); ok {
		return x.TableResult
	}
	return nil
}

type isDataDocumentationResult_Result interface {
	isDataDocumentationResult_Result()
}

type DataDocumentationResult_TableResult_ struct {
	// Output only. Table result for insights.
	TableResult *DataDocumentationResult_TableResult `protobuf:"bytes,8,opt,name=table_result,json=tableResult,proto3,oneof"`
}

func (*DataDocumentationResult_TableResult_) isDataDocumentationResult_Result() {}

// Generated metadata about the table.
type DataDocumentationResult_TableResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The service-qualified full resource name of the cloud
	// resource. Ex:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Generated description of the table.
	Overview string `protobuf:"bytes,2,opt,name=overview,proto3" json:"overview,omitempty"`
	// Output only. Schema of the table with generated metadata of the columns
	// in the schema.
	Schema *DataDocumentationResult_Schema `protobuf:"bytes,3,opt,name=schema,proto3" json:"schema,omitempty"`
	// Output only. Sample SQL queries for the table.
	Queries []*DataDocumentationResult_Query `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
}

func (x *DataDocumentationResult_TableResult) Reset() {
	*x = DataDocumentationResult_TableResult{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationResult_TableResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationResult_TableResult) ProtoMessage() {}

func (x *DataDocumentationResult_TableResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationResult_TableResult.ProtoReflect.Descriptor instead.
func (*DataDocumentationResult_TableResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DataDocumentationResult_TableResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataDocumentationResult_TableResult) GetOverview() string {
	if x != nil {
		return x.Overview
	}
	return ""
}

func (x *DataDocumentationResult_TableResult) GetSchema() *DataDocumentationResult_Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *DataDocumentationResult_TableResult) GetQueries() []*DataDocumentationResult_Query {
	if x != nil {
		return x.Queries
	}
	return nil
}

// A sample SQL query in data documentation.
type DataDocumentationResult_Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The SQL query string which can be executed.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// Output only. The description for the query.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *DataDocumentationResult_Query) Reset() {
	*x = DataDocumentationResult_Query{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationResult_Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationResult_Query) ProtoMessage() {}

func (x *DataDocumentationResult_Query) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationResult_Query.ProtoReflect.Descriptor instead.
func (*DataDocumentationResult_Query) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DataDocumentationResult_Query) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *DataDocumentationResult_Query) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Schema of the table with generated metadata of columns.
type DataDocumentationResult_Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of columns.
	Fields []*DataDocumentationResult_Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *DataDocumentationResult_Schema) Reset() {
	*x = DataDocumentationResult_Schema{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationResult_Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationResult_Schema) ProtoMessage() {}

func (x *DataDocumentationResult_Schema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationResult_Schema.ProtoReflect.Descriptor instead.
func (*DataDocumentationResult_Schema) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{1, 2}
}

func (x *DataDocumentationResult_Schema) GetFields() []*DataDocumentationResult_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Column of a table with generated metadata and nested fields.
type DataDocumentationResult_Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the column.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Generated description for columns and fields.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Nested fields.
	Fields []*DataDocumentationResult_Field `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *DataDocumentationResult_Field) Reset() {
	*x = DataDocumentationResult_Field{}
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDocumentationResult_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDocumentationResult_Field) ProtoMessage() {}

func (x *DataDocumentationResult_Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDocumentationResult_Field.ProtoReflect.Descriptor instead.
func (*DataDocumentationResult_Field) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP(), []int{1, 3}
}

func (x *DataDocumentationResult_Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataDocumentationResult_Field) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataDocumentationResult_Field) GetFields() []*DataDocumentationResult_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

var File_google_cloud_dataplex_v1_data_documentation_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_data_documentation_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x17,
	0x0a, 0x15, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0xcc, 0x05, 0x0a, 0x17, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x67, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xf6, 0x01, 0x0a,
	0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6f, 0x76,
	0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x55, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x56, 0x0a,
	0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x71, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x45, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x15,
	0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x5e, 0x0a, 0x06,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x54, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x9d, 0x01, 0x0a,
	0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x42, 0x08, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x44, 0x61, 0x74, 0x61, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_data_documentation_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_data_documentation_proto_rawDescData = file_google_cloud_dataplex_v1_data_documentation_proto_rawDesc
)

func file_google_cloud_dataplex_v1_data_documentation_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_data_documentation_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_data_documentation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_data_documentation_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_data_documentation_proto_rawDescData
}

var file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_dataplex_v1_data_documentation_proto_goTypes = []any{
	(*DataDocumentationSpec)(nil),               // 0: google.cloud.dataplex.v1.DataDocumentationSpec
	(*DataDocumentationResult)(nil),             // 1: google.cloud.dataplex.v1.DataDocumentationResult
	(*DataDocumentationResult_TableResult)(nil), // 2: google.cloud.dataplex.v1.DataDocumentationResult.TableResult
	(*DataDocumentationResult_Query)(nil),       // 3: google.cloud.dataplex.v1.DataDocumentationResult.Query
	(*DataDocumentationResult_Schema)(nil),      // 4: google.cloud.dataplex.v1.DataDocumentationResult.Schema
	(*DataDocumentationResult_Field)(nil),       // 5: google.cloud.dataplex.v1.DataDocumentationResult.Field
}
var file_google_cloud_dataplex_v1_data_documentation_proto_depIdxs = []int32{
	2, // 0: google.cloud.dataplex.v1.DataDocumentationResult.table_result:type_name -> google.cloud.dataplex.v1.DataDocumentationResult.TableResult
	4, // 1: google.cloud.dataplex.v1.DataDocumentationResult.TableResult.schema:type_name -> google.cloud.dataplex.v1.DataDocumentationResult.Schema
	3, // 2: google.cloud.dataplex.v1.DataDocumentationResult.TableResult.queries:type_name -> google.cloud.dataplex.v1.DataDocumentationResult.Query
	5, // 3: google.cloud.dataplex.v1.DataDocumentationResult.Schema.fields:type_name -> google.cloud.dataplex.v1.DataDocumentationResult.Field
	5, // 4: google.cloud.dataplex.v1.DataDocumentationResult.Field.fields:type_name -> google.cloud.dataplex.v1.DataDocumentationResult.Field
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_data_documentation_proto_init() }
func file_google_cloud_dataplex_v1_data_documentation_proto_init() {
	if File_google_cloud_dataplex_v1_data_documentation_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes[1].OneofWrappers = []any{
		(*DataDocumentationResult_TableResult_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_data_documentation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_data_documentation_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_data_documentation_proto_depIdxs,
		MessageInfos:      file_google_cloud_dataplex_v1_data_documentation_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_data_documentation_proto = out.File
	file_google_cloud_dataplex_v1_data_documentation_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_data_documentation_proto_goTypes = nil
	file_google_cloud_dataplex_v1_data_documentation_proto_depIdxs = nil
}
