// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.3
// source: datastore_v3.proto

package gaepb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Property_Meaning int32

const (
	Property_NO_MEANING       Property_Meaning = 0
	Property_BLOB             Property_Meaning = 14
	Property_TEXT             Property_Meaning = 15
	Property_BYTESTRING       Property_Meaning = 16
	Property_ATOM_CATEGORY    Property_Meaning = 1
	Property_ATOM_LINK        Property_Meaning = 2
	Property_ATOM_TITLE       Property_Meaning = 3
	Property_ATOM_CONTENT     Property_Meaning = 4
	Property_ATOM_SUMMARY     Property_Meaning = 5
	Property_ATOM_AUTHOR      Property_Meaning = 6
	Property_GD_WHEN          Property_Meaning = 7
	Property_GD_EMAIL         Property_Meaning = 8
	Property_GEORSS_POINT     Property_Meaning = 9
	Property_GD_IM            Property_Meaning = 10
	Property_GD_PHONENUMBER   Property_Meaning = 11
	Property_GD_POSTALADDRESS Property_Meaning = 12
	Property_GD_RATING        Property_Meaning = 13
	Property_BLOBKEY          Property_Meaning = 17
	Property_ENTITY_PROTO     Property_Meaning = 19
	Property_INDEX_VALUE      Property_Meaning = 18
)

// Enum value maps for Property_Meaning.
var (
	Property_Meaning_name = map[int32]string{
		0:  "NO_MEANING",
		14: "BLOB",
		15: "TEXT",
		16: "BYTESTRING",
		1:  "ATOM_CATEGORY",
		2:  "ATOM_LINK",
		3:  "ATOM_TITLE",
		4:  "ATOM_CONTENT",
		5:  "ATOM_SUMMARY",
		6:  "ATOM_AUTHOR",
		7:  "GD_WHEN",
		8:  "GD_EMAIL",
		9:  "GEORSS_POINT",
		10: "GD_IM",
		11: "GD_PHONENUMBER",
		12: "GD_POSTALADDRESS",
		13: "GD_RATING",
		17: "BLOBKEY",
		19: "ENTITY_PROTO",
		18: "INDEX_VALUE",
	}
	Property_Meaning_value = map[string]int32{
		"NO_MEANING":       0,
		"BLOB":             14,
		"TEXT":             15,
		"BYTESTRING":       16,
		"ATOM_CATEGORY":    1,
		"ATOM_LINK":        2,
		"ATOM_TITLE":       3,
		"ATOM_CONTENT":     4,
		"ATOM_SUMMARY":     5,
		"ATOM_AUTHOR":      6,
		"GD_WHEN":          7,
		"GD_EMAIL":         8,
		"GEORSS_POINT":     9,
		"GD_IM":            10,
		"GD_PHONENUMBER":   11,
		"GD_POSTALADDRESS": 12,
		"GD_RATING":        13,
		"BLOBKEY":          17,
		"ENTITY_PROTO":     19,
		"INDEX_VALUE":      18,
	}
)

func (x Property_Meaning) Enum() *Property_Meaning {
	p := new(Property_Meaning)
	*p = x
	return p
}

func (x Property_Meaning) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Property_Meaning) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[0].Descriptor()
}

func (Property_Meaning) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[0]
}

func (x Property_Meaning) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Property_Meaning) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Property_Meaning(num)
	return nil
}

// Deprecated: Use Property_Meaning.Descriptor instead.
func (Property_Meaning) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{2, 0}
}

type Property_FtsTokenizationOption int32

const (
	Property_HTML Property_FtsTokenizationOption = 1
	Property_ATOM Property_FtsTokenizationOption = 2
)

// Enum value maps for Property_FtsTokenizationOption.
var (
	Property_FtsTokenizationOption_name = map[int32]string{
		1: "HTML",
		2: "ATOM",
	}
	Property_FtsTokenizationOption_value = map[string]int32{
		"HTML": 1,
		"ATOM": 2,
	}
)

func (x Property_FtsTokenizationOption) Enum() *Property_FtsTokenizationOption {
	p := new(Property_FtsTokenizationOption)
	*p = x
	return p
}

func (x Property_FtsTokenizationOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Property_FtsTokenizationOption) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[1].Descriptor()
}

func (Property_FtsTokenizationOption) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[1]
}

func (x Property_FtsTokenizationOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Property_FtsTokenizationOption) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Property_FtsTokenizationOption(num)
	return nil
}

// Deprecated: Use Property_FtsTokenizationOption.Descriptor instead.
func (Property_FtsTokenizationOption) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{2, 1}
}

type EntityProto_Kind int32

const (
	EntityProto_GD_CONTACT EntityProto_Kind = 1
	EntityProto_GD_EVENT   EntityProto_Kind = 2
	EntityProto_GD_MESSAGE EntityProto_Kind = 3
)

// Enum value maps for EntityProto_Kind.
var (
	EntityProto_Kind_name = map[int32]string{
		1: "GD_CONTACT",
		2: "GD_EVENT",
		3: "GD_MESSAGE",
	}
	EntityProto_Kind_value = map[string]int32{
		"GD_CONTACT": 1,
		"GD_EVENT":   2,
		"GD_MESSAGE": 3,
	}
)

func (x EntityProto_Kind) Enum() *EntityProto_Kind {
	p := new(EntityProto_Kind)
	*p = x
	return p
}

func (x EntityProto_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityProto_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[2].Descriptor()
}

func (EntityProto_Kind) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[2]
}

func (x EntityProto_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *EntityProto_Kind) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = EntityProto_Kind(num)
	return nil
}

// Deprecated: Use EntityProto_Kind.Descriptor instead.
func (EntityProto_Kind) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{6, 0}
}

type Index_Property_Direction int32

const (
	Index_Property_ASCENDING  Index_Property_Direction = 1
	Index_Property_DESCENDING Index_Property_Direction = 2
)

// Enum value maps for Index_Property_Direction.
var (
	Index_Property_Direction_name = map[int32]string{
		1: "ASCENDING",
		2: "DESCENDING",
	}
	Index_Property_Direction_value = map[string]int32{
		"ASCENDING":  1,
		"DESCENDING": 2,
	}
)

func (x Index_Property_Direction) Enum() *Index_Property_Direction {
	p := new(Index_Property_Direction)
	*p = x
	return p
}

func (x Index_Property_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Index_Property_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[3].Descriptor()
}

func (Index_Property_Direction) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[3]
}

func (x Index_Property_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Index_Property_Direction) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Index_Property_Direction(num)
	return nil
}

// Deprecated: Use Index_Property_Direction.Descriptor instead.
func (Index_Property_Direction) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{8, 0, 0}
}

type CompositeIndex_State int32

const (
	CompositeIndex_WRITE_ONLY CompositeIndex_State = 1
	CompositeIndex_READ_WRITE CompositeIndex_State = 2
	CompositeIndex_DELETED    CompositeIndex_State = 3
	CompositeIndex_ERROR      CompositeIndex_State = 4
)

// Enum value maps for CompositeIndex_State.
var (
	CompositeIndex_State_name = map[int32]string{
		1: "WRITE_ONLY",
		2: "READ_WRITE",
		3: "DELETED",
		4: "ERROR",
	}
	CompositeIndex_State_value = map[string]int32{
		"WRITE_ONLY": 1,
		"READ_WRITE": 2,
		"DELETED":    3,
		"ERROR":      4,
	}
)

func (x CompositeIndex_State) Enum() *CompositeIndex_State {
	p := new(CompositeIndex_State)
	*p = x
	return p
}

func (x CompositeIndex_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompositeIndex_State) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[4].Descriptor()
}

func (CompositeIndex_State) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[4]
}

func (x CompositeIndex_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CompositeIndex_State) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CompositeIndex_State(num)
	return nil
}

// Deprecated: Use CompositeIndex_State.Descriptor instead.
func (CompositeIndex_State) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{9, 0}
}

type Snapshot_Status int32

const (
	Snapshot_INACTIVE Snapshot_Status = 0
	Snapshot_ACTIVE   Snapshot_Status = 1
)

// Enum value maps for Snapshot_Status.
var (
	Snapshot_Status_name = map[int32]string{
		0: "INACTIVE",
		1: "ACTIVE",
	}
	Snapshot_Status_value = map[string]int32{
		"INACTIVE": 0,
		"ACTIVE":   1,
	}
)

func (x Snapshot_Status) Enum() *Snapshot_Status {
	p := new(Snapshot_Status)
	*p = x
	return p
}

func (x Snapshot_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[5].Descriptor()
}

func (Snapshot_Status) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[5]
}

func (x Snapshot_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Snapshot_Status) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Snapshot_Status(num)
	return nil
}

// Deprecated: Use Snapshot_Status.Descriptor instead.
func (Snapshot_Status) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{12, 0}
}

type Query_Hint int32

const (
	Query_ORDER_FIRST    Query_Hint = 1
	Query_ANCESTOR_FIRST Query_Hint = 2
	Query_FILTER_FIRST   Query_Hint = 3
)

// Enum value maps for Query_Hint.
var (
	Query_Hint_name = map[int32]string{
		1: "ORDER_FIRST",
		2: "ANCESTOR_FIRST",
		3: "FILTER_FIRST",
	}
	Query_Hint_value = map[string]int32{
		"ORDER_FIRST":    1,
		"ANCESTOR_FIRST": 2,
		"FILTER_FIRST":   3,
	}
)

func (x Query_Hint) Enum() *Query_Hint {
	p := new(Query_Hint)
	*p = x
	return p
}

func (x Query_Hint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Query_Hint) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[6].Descriptor()
}

func (Query_Hint) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[6]
}

func (x Query_Hint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Query_Hint) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Query_Hint(num)
	return nil
}

// Deprecated: Use Query_Hint.Descriptor instead.
func (Query_Hint) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15, 0}
}

type Query_Filter_Operator int32

const (
	Query_Filter_LESS_THAN             Query_Filter_Operator = 1
	Query_Filter_LESS_THAN_OR_EQUAL    Query_Filter_Operator = 2
	Query_Filter_GREATER_THAN          Query_Filter_Operator = 3
	Query_Filter_GREATER_THAN_OR_EQUAL Query_Filter_Operator = 4
	Query_Filter_EQUAL                 Query_Filter_Operator = 5
	Query_Filter_IN                    Query_Filter_Operator = 6
	Query_Filter_EXISTS                Query_Filter_Operator = 7
)

// Enum value maps for Query_Filter_Operator.
var (
	Query_Filter_Operator_name = map[int32]string{
		1: "LESS_THAN",
		2: "LESS_THAN_OR_EQUAL",
		3: "GREATER_THAN",
		4: "GREATER_THAN_OR_EQUAL",
		5: "EQUAL",
		6: "IN",
		7: "EXISTS",
	}
	Query_Filter_Operator_value = map[string]int32{
		"LESS_THAN":             1,
		"LESS_THAN_OR_EQUAL":    2,
		"GREATER_THAN":          3,
		"GREATER_THAN_OR_EQUAL": 4,
		"EQUAL":                 5,
		"IN":                    6,
		"EXISTS":                7,
	}
)

func (x Query_Filter_Operator) Enum() *Query_Filter_Operator {
	p := new(Query_Filter_Operator)
	*p = x
	return p
}

func (x Query_Filter_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Query_Filter_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[7].Descriptor()
}

func (Query_Filter_Operator) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[7]
}

func (x Query_Filter_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Query_Filter_Operator) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Query_Filter_Operator(num)
	return nil
}

// Deprecated: Use Query_Filter_Operator.Descriptor instead.
func (Query_Filter_Operator) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15, 0, 0}
}

type Query_Order_Direction int32

const (
	Query_Order_ASCENDING  Query_Order_Direction = 1
	Query_Order_DESCENDING Query_Order_Direction = 2
)

// Enum value maps for Query_Order_Direction.
var (
	Query_Order_Direction_name = map[int32]string{
		1: "ASCENDING",
		2: "DESCENDING",
	}
	Query_Order_Direction_value = map[string]int32{
		"ASCENDING":  1,
		"DESCENDING": 2,
	}
)

func (x Query_Order_Direction) Enum() *Query_Order_Direction {
	p := new(Query_Order_Direction)
	*p = x
	return p
}

func (x Query_Order_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Query_Order_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[8].Descriptor()
}

func (Query_Order_Direction) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[8]
}

func (x Query_Order_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Query_Order_Direction) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Query_Order_Direction(num)
	return nil
}

// Deprecated: Use Query_Order_Direction.Descriptor instead.
func (Query_Order_Direction) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15, 1, 0}
}

type Error_ErrorCode int32

const (
	Error_BAD_REQUEST                  Error_ErrorCode = 1
	Error_CONCURRENT_TRANSACTION       Error_ErrorCode = 2
	Error_INTERNAL_ERROR               Error_ErrorCode = 3
	Error_NEED_INDEX                   Error_ErrorCode = 4
	Error_TIMEOUT                      Error_ErrorCode = 5
	Error_PERMISSION_DENIED            Error_ErrorCode = 6
	Error_BIGTABLE_ERROR               Error_ErrorCode = 7
	Error_COMMITTED_BUT_STILL_APPLYING Error_ErrorCode = 8
	Error_CAPABILITY_DISABLED          Error_ErrorCode = 9
	Error_TRY_ALTERNATE_BACKEND        Error_ErrorCode = 10
	Error_SAFE_TIME_TOO_OLD            Error_ErrorCode = 11
)

// Enum value maps for Error_ErrorCode.
var (
	Error_ErrorCode_name = map[int32]string{
		1:  "BAD_REQUEST",
		2:  "CONCURRENT_TRANSACTION",
		3:  "INTERNAL_ERROR",
		4:  "NEED_INDEX",
		5:  "TIMEOUT",
		6:  "PERMISSION_DENIED",
		7:  "BIGTABLE_ERROR",
		8:  "COMMITTED_BUT_STILL_APPLYING",
		9:  "CAPABILITY_DISABLED",
		10: "TRY_ALTERNATE_BACKEND",
		11: "SAFE_TIME_TOO_OLD",
	}
	Error_ErrorCode_value = map[string]int32{
		"BAD_REQUEST":                  1,
		"CONCURRENT_TRANSACTION":       2,
		"INTERNAL_ERROR":               3,
		"NEED_INDEX":                   4,
		"TIMEOUT":                      5,
		"PERMISSION_DENIED":            6,
		"BIGTABLE_ERROR":               7,
		"COMMITTED_BUT_STILL_APPLYING": 8,
		"CAPABILITY_DISABLED":          9,
		"TRY_ALTERNATE_BACKEND":        10,
		"SAFE_TIME_TOO_OLD":            11,
	}
)

func (x Error_ErrorCode) Enum() *Error_ErrorCode {
	p := new(Error_ErrorCode)
	*p = x
	return p
}

func (x Error_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Error_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[9].Descriptor()
}

func (Error_ErrorCode) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[9]
}

func (x Error_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Error_ErrorCode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Error_ErrorCode(num)
	return nil
}

// Deprecated: Use Error_ErrorCode.Descriptor instead.
func (Error_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{19, 0}
}

type PutRequest_AutoIdPolicy int32

const (
	PutRequest_CURRENT    PutRequest_AutoIdPolicy = 0
	PutRequest_SEQUENTIAL PutRequest_AutoIdPolicy = 1
)

// Enum value maps for PutRequest_AutoIdPolicy.
var (
	PutRequest_AutoIdPolicy_name = map[int32]string{
		0: "CURRENT",
		1: "SEQUENTIAL",
	}
	PutRequest_AutoIdPolicy_value = map[string]int32{
		"CURRENT":    0,
		"SEQUENTIAL": 1,
	}
)

func (x PutRequest_AutoIdPolicy) Enum() *PutRequest_AutoIdPolicy {
	p := new(PutRequest_AutoIdPolicy)
	*p = x
	return p
}

func (x PutRequest_AutoIdPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PutRequest_AutoIdPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[10].Descriptor()
}

func (PutRequest_AutoIdPolicy) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[10]
}

func (x PutRequest_AutoIdPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *PutRequest_AutoIdPolicy) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = PutRequest_AutoIdPolicy(num)
	return nil
}

// Deprecated: Use PutRequest_AutoIdPolicy.Descriptor instead.
func (PutRequest_AutoIdPolicy) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{23, 0}
}

type BeginTransactionRequest_TransactionMode int32

const (
	BeginTransactionRequest_UNKNOWN    BeginTransactionRequest_TransactionMode = 0
	BeginTransactionRequest_READ_ONLY  BeginTransactionRequest_TransactionMode = 1
	BeginTransactionRequest_READ_WRITE BeginTransactionRequest_TransactionMode = 2
)

// Enum value maps for BeginTransactionRequest_TransactionMode.
var (
	BeginTransactionRequest_TransactionMode_name = map[int32]string{
		0: "UNKNOWN",
		1: "READ_ONLY",
		2: "READ_WRITE",
	}
	BeginTransactionRequest_TransactionMode_value = map[string]int32{
		"UNKNOWN":    0,
		"READ_ONLY":  1,
		"READ_WRITE": 2,
	}
)

func (x BeginTransactionRequest_TransactionMode) Enum() *BeginTransactionRequest_TransactionMode {
	p := new(BeginTransactionRequest_TransactionMode)
	*p = x
	return p
}

func (x BeginTransactionRequest_TransactionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BeginTransactionRequest_TransactionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_datastore_v3_proto_enumTypes[11].Descriptor()
}

func (BeginTransactionRequest_TransactionMode) Type() protoreflect.EnumType {
	return &file_datastore_v3_proto_enumTypes[11]
}

func (x BeginTransactionRequest_TransactionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *BeginTransactionRequest_TransactionMode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = BeginTransactionRequest_TransactionMode(num)
	return nil
}

// Deprecated: Use BeginTransactionRequest_TransactionMode.Descriptor instead.
func (BeginTransactionRequest_TransactionMode) EnumDescriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{36, 0}
}

type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{0}
}

type PropertyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Int64Value     *int64                        `protobuf:"varint,1,opt,name=int64Value" json:"int64Value,omitempty"`
	BooleanValue   *bool                         `protobuf:"varint,2,opt,name=booleanValue" json:"booleanValue,omitempty"`
	StringValue    *string                       `protobuf:"bytes,3,opt,name=stringValue" json:"stringValue,omitempty"`
	DoubleValue    *float64                      `protobuf:"fixed64,4,opt,name=doubleValue" json:"doubleValue,omitempty"`
	Pointvalue     *PropertyValue_PointValue     `protobuf:"group,5,opt,name=PointValue,json=pointvalue" json:"pointvalue,omitempty"`
	Uservalue      *PropertyValue_UserValue      `protobuf:"group,8,opt,name=UserValue,json=uservalue" json:"uservalue,omitempty"`
	Referencevalue *PropertyValue_ReferenceValue `protobuf:"group,12,opt,name=ReferenceValue,json=referencevalue" json:"referencevalue,omitempty"`
}

func (x *PropertyValue) Reset() {
	*x = PropertyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyValue) ProtoMessage() {}

func (x *PropertyValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyValue.ProtoReflect.Descriptor instead.
func (*PropertyValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{1}
}

func (x *PropertyValue) GetInt64Value() int64 {
	if x != nil && x.Int64Value != nil {
		return *x.Int64Value
	}
	return 0
}

func (x *PropertyValue) GetBooleanValue() bool {
	if x != nil && x.BooleanValue != nil {
		return *x.BooleanValue
	}
	return false
}

func (x *PropertyValue) GetStringValue() string {
	if x != nil && x.StringValue != nil {
		return *x.StringValue
	}
	return ""
}

func (x *PropertyValue) GetDoubleValue() float64 {
	if x != nil && x.DoubleValue != nil {
		return *x.DoubleValue
	}
	return 0
}

func (x *PropertyValue) GetPointvalue() *PropertyValue_PointValue {
	if x != nil {
		return x.Pointvalue
	}
	return nil
}

func (x *PropertyValue) GetUservalue() *PropertyValue_UserValue {
	if x != nil {
		return x.Uservalue
	}
	return nil
}

func (x *PropertyValue) GetReferencevalue() *PropertyValue_ReferenceValue {
	if x != nil {
		return x.Referencevalue
	}
	return nil
}

type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meaning               *Property_Meaning               `protobuf:"varint,1,opt,name=meaning,enum=appengine.v2.Property_Meaning,def=0" json:"meaning,omitempty"`
	MeaningUri            *string                         `protobuf:"bytes,2,opt,name=meaning_uri,json=meaningUri" json:"meaning_uri,omitempty"`
	Name                  *string                         `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Value                 *PropertyValue                  `protobuf:"bytes,5,req,name=value" json:"value,omitempty"`
	Multiple              *bool                           `protobuf:"varint,4,req,name=multiple" json:"multiple,omitempty"`
	Searchable            *bool                           `protobuf:"varint,6,opt,name=searchable,def=0" json:"searchable,omitempty"`
	FtsTokenizationOption *Property_FtsTokenizationOption `protobuf:"varint,8,opt,name=fts_tokenization_option,json=ftsTokenizationOption,enum=appengine.v2.Property_FtsTokenizationOption" json:"fts_tokenization_option,omitempty"`
	Locale                *string                         `protobuf:"bytes,9,opt,name=locale,def=en" json:"locale,omitempty"`
}

// Default values for Property fields.
const (
	Default_Property_Meaning    = Property_NO_MEANING
	Default_Property_Searchable = bool(false)
	Default_Property_Locale     = string("en")
)

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{2}
}

func (x *Property) GetMeaning() Property_Meaning {
	if x != nil && x.Meaning != nil {
		return *x.Meaning
	}
	return Default_Property_Meaning
}

func (x *Property) GetMeaningUri() string {
	if x != nil && x.MeaningUri != nil {
		return *x.MeaningUri
	}
	return ""
}

func (x *Property) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Property) GetValue() *PropertyValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Property) GetMultiple() bool {
	if x != nil && x.Multiple != nil {
		return *x.Multiple
	}
	return false
}

func (x *Property) GetSearchable() bool {
	if x != nil && x.Searchable != nil {
		return *x.Searchable
	}
	return Default_Property_Searchable
}

func (x *Property) GetFtsTokenizationOption() Property_FtsTokenizationOption {
	if x != nil && x.FtsTokenizationOption != nil {
		return *x.FtsTokenizationOption
	}
	return Property_HTML
}

func (x *Property) GetLocale() string {
	if x != nil && x.Locale != nil {
		return *x.Locale
	}
	return Default_Property_Locale
}

type Path struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Element []*Path_Element `protobuf:"group,1,rep,name=Element,json=element" json:"element,omitempty"`
}

func (x *Path) Reset() {
	*x = Path{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Path) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path) ProtoMessage() {}

func (x *Path) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path.ProtoReflect.Descriptor instead.
func (*Path) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{3}
}

func (x *Path) GetElement() []*Path_Element {
	if x != nil {
		return x.Element
	}
	return nil
}

type Reference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	App       *string `protobuf:"bytes,13,req,name=app" json:"app,omitempty"`
	NameSpace *string `protobuf:"bytes,20,opt,name=name_space,json=nameSpace" json:"name_space,omitempty"`
	Path      *Path   `protobuf:"bytes,14,req,name=path" json:"path,omitempty"`
}

func (x *Reference) Reset() {
	*x = Reference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reference) ProtoMessage() {}

func (x *Reference) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reference.ProtoReflect.Descriptor instead.
func (*Reference) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{4}
}

func (x *Reference) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

func (x *Reference) GetNameSpace() string {
	if x != nil && x.NameSpace != nil {
		return *x.NameSpace
	}
	return ""
}

func (x *Reference) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Email             *string `protobuf:"bytes,1,req,name=email" json:"email,omitempty"`
	AuthDomain        *string `protobuf:"bytes,2,req,name=auth_domain,json=authDomain" json:"auth_domain,omitempty"`
	Nickname          *string `protobuf:"bytes,3,opt,name=nickname" json:"nickname,omitempty"`
	FederatedIdentity *string `protobuf:"bytes,6,opt,name=federated_identity,json=federatedIdentity" json:"federated_identity,omitempty"`
	FederatedProvider *string `protobuf:"bytes,7,opt,name=federated_provider,json=federatedProvider" json:"federated_provider,omitempty"`
}

func (x *User) Reset() {
	*x = User{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{5}
}

func (x *User) GetEmail() string {
	if x != nil && x.Email != nil {
		return *x.Email
	}
	return ""
}

func (x *User) GetAuthDomain() string {
	if x != nil && x.AuthDomain != nil {
		return *x.AuthDomain
	}
	return ""
}

func (x *User) GetNickname() string {
	if x != nil && x.Nickname != nil {
		return *x.Nickname
	}
	return ""
}

func (x *User) GetFederatedIdentity() string {
	if x != nil && x.FederatedIdentity != nil {
		return *x.FederatedIdentity
	}
	return ""
}

func (x *User) GetFederatedProvider() string {
	if x != nil && x.FederatedProvider != nil {
		return *x.FederatedProvider
	}
	return ""
}

type EntityProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key         *Reference        `protobuf:"bytes,13,req,name=key" json:"key,omitempty"`
	EntityGroup *Path             `protobuf:"bytes,16,req,name=entity_group,json=entityGroup" json:"entity_group,omitempty"`
	Owner       *User             `protobuf:"bytes,17,opt,name=owner" json:"owner,omitempty"`
	Kind        *EntityProto_Kind `protobuf:"varint,4,opt,name=kind,enum=appengine.v2.EntityProto_Kind" json:"kind,omitempty"`
	KindUri     *string           `protobuf:"bytes,5,opt,name=kind_uri,json=kindUri" json:"kind_uri,omitempty"`
	Property    []*Property       `protobuf:"bytes,14,rep,name=property" json:"property,omitempty"`
	RawProperty []*Property       `protobuf:"bytes,15,rep,name=raw_property,json=rawProperty" json:"raw_property,omitempty"`
	Rank        *int32            `protobuf:"varint,18,opt,name=rank" json:"rank,omitempty"`
}

func (x *EntityProto) Reset() {
	*x = EntityProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityProto) ProtoMessage() {}

func (x *EntityProto) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityProto.ProtoReflect.Descriptor instead.
func (*EntityProto) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{6}
}

func (x *EntityProto) GetKey() *Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *EntityProto) GetEntityGroup() *Path {
	if x != nil {
		return x.EntityGroup
	}
	return nil
}

func (x *EntityProto) GetOwner() *User {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *EntityProto) GetKind() EntityProto_Kind {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return EntityProto_GD_CONTACT
}

func (x *EntityProto) GetKindUri() string {
	if x != nil && x.KindUri != nil {
		return *x.KindUri
	}
	return ""
}

func (x *EntityProto) GetProperty() []*Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *EntityProto) GetRawProperty() []*Property {
	if x != nil {
		return x.RawProperty
	}
	return nil
}

func (x *EntityProto) GetRank() int32 {
	if x != nil && x.Rank != nil {
		return *x.Rank
	}
	return 0
}

type CompositeProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexId *int64   `protobuf:"varint,1,req,name=index_id,json=indexId" json:"index_id,omitempty"`
	Value   []string `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
}

func (x *CompositeProperty) Reset() {
	*x = CompositeProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompositeProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompositeProperty) ProtoMessage() {}

func (x *CompositeProperty) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompositeProperty.ProtoReflect.Descriptor instead.
func (*CompositeProperty) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{7}
}

func (x *CompositeProperty) GetIndexId() int64 {
	if x != nil && x.IndexId != nil {
		return *x.IndexId
	}
	return 0
}

func (x *CompositeProperty) GetValue() []string {
	if x != nil {
		return x.Value
	}
	return nil
}

type Index struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EntityType *string           `protobuf:"bytes,1,req,name=entity_type,json=entityType" json:"entity_type,omitempty"`
	Ancestor   *bool             `protobuf:"varint,5,req,name=ancestor" json:"ancestor,omitempty"`
	Property   []*Index_Property `protobuf:"group,2,rep,name=Property,json=property" json:"property,omitempty"`
}

func (x *Index) Reset() {
	*x = Index{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index) ProtoMessage() {}

func (x *Index) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index.ProtoReflect.Descriptor instead.
func (*Index) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{8}
}

func (x *Index) GetEntityType() string {
	if x != nil && x.EntityType != nil {
		return *x.EntityType
	}
	return ""
}

func (x *Index) GetAncestor() bool {
	if x != nil && x.Ancestor != nil {
		return *x.Ancestor
	}
	return false
}

func (x *Index) GetProperty() []*Index_Property {
	if x != nil {
		return x.Property
	}
	return nil
}

type CompositeIndex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AppId             *string               `protobuf:"bytes,1,req,name=app_id,json=appId" json:"app_id,omitempty"`
	Id                *int64                `protobuf:"varint,2,req,name=id" json:"id,omitempty"`
	Definition        *Index                `protobuf:"bytes,3,req,name=definition" json:"definition,omitempty"`
	State             *CompositeIndex_State `protobuf:"varint,4,req,name=state,enum=appengine.v2.CompositeIndex_State" json:"state,omitempty"`
	OnlyUseIfRequired *bool                 `protobuf:"varint,6,opt,name=only_use_if_required,json=onlyUseIfRequired,def=0" json:"only_use_if_required,omitempty"`
}

// Default values for CompositeIndex fields.
const (
	Default_CompositeIndex_OnlyUseIfRequired = bool(false)
)

func (x *CompositeIndex) Reset() {
	*x = CompositeIndex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompositeIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompositeIndex) ProtoMessage() {}

func (x *CompositeIndex) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompositeIndex.ProtoReflect.Descriptor instead.
func (*CompositeIndex) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{9}
}

func (x *CompositeIndex) GetAppId() string {
	if x != nil && x.AppId != nil {
		return *x.AppId
	}
	return ""
}

func (x *CompositeIndex) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *CompositeIndex) GetDefinition() *Index {
	if x != nil {
		return x.Definition
	}
	return nil
}

func (x *CompositeIndex) GetState() CompositeIndex_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return CompositeIndex_WRITE_ONLY
}

func (x *CompositeIndex) GetOnlyUseIfRequired() bool {
	if x != nil && x.OnlyUseIfRequired != nil {
		return *x.OnlyUseIfRequired
	}
	return Default_CompositeIndex_OnlyUseIfRequired
}

type IndexPostfix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexValue []*IndexPostfix_IndexValue `protobuf:"bytes,1,rep,name=index_value,json=indexValue" json:"index_value,omitempty"`
	Key        *Reference                 `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	Before     *bool                      `protobuf:"varint,3,opt,name=before,def=1" json:"before,omitempty"`
}

// Default values for IndexPostfix fields.
const (
	Default_IndexPostfix_Before = bool(true)
)

func (x *IndexPostfix) Reset() {
	*x = IndexPostfix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexPostfix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexPostfix) ProtoMessage() {}

func (x *IndexPostfix) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexPostfix.ProtoReflect.Descriptor instead.
func (*IndexPostfix) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{10}
}

func (x *IndexPostfix) GetIndexValue() []*IndexPostfix_IndexValue {
	if x != nil {
		return x.IndexValue
	}
	return nil
}

func (x *IndexPostfix) GetKey() *Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *IndexPostfix) GetBefore() bool {
	if x != nil && x.Before != nil {
		return *x.Before
	}
	return Default_IndexPostfix_Before
}

type IndexPosition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key    *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Before *bool   `protobuf:"varint,2,opt,name=before,def=1" json:"before,omitempty"`
}

// Default values for IndexPosition fields.
const (
	Default_IndexPosition_Before = bool(true)
)

func (x *IndexPosition) Reset() {
	*x = IndexPosition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexPosition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexPosition) ProtoMessage() {}

func (x *IndexPosition) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexPosition.ProtoReflect.Descriptor instead.
func (*IndexPosition) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{11}
}

func (x *IndexPosition) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *IndexPosition) GetBefore() bool {
	if x != nil && x.Before != nil {
		return *x.Before
	}
	return Default_IndexPosition_Before
}

type Snapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ts *int64 `protobuf:"varint,1,req,name=ts" json:"ts,omitempty"`
}

func (x *Snapshot) Reset() {
	*x = Snapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Snapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snapshot) ProtoMessage() {}

func (x *Snapshot) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snapshot.ProtoReflect.Descriptor instead.
func (*Snapshot) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{12}
}

func (x *Snapshot) GetTs() int64 {
	if x != nil && x.Ts != nil {
		return *x.Ts
	}
	return 0
}

type InternalHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Qos *string `protobuf:"bytes,1,opt,name=qos" json:"qos,omitempty"`
}

func (x *InternalHeader) Reset() {
	*x = InternalHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InternalHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalHeader) ProtoMessage() {}

func (x *InternalHeader) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalHeader.ProtoReflect.Descriptor instead.
func (*InternalHeader) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{13}
}

func (x *InternalHeader) GetQos() string {
	if x != nil && x.Qos != nil {
		return *x.Qos
	}
	return ""
}

type Transaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *InternalHeader `protobuf:"bytes,4,opt,name=header" json:"header,omitempty"`
	Handle      *uint64         `protobuf:"fixed64,1,req,name=handle" json:"handle,omitempty"`
	App         *string         `protobuf:"bytes,2,req,name=app" json:"app,omitempty"`
	MarkChanges *bool           `protobuf:"varint,3,opt,name=mark_changes,json=markChanges,def=0" json:"mark_changes,omitempty"`
}

// Default values for Transaction fields.
const (
	Default_Transaction_MarkChanges = bool(false)
)

func (x *Transaction) Reset() {
	*x = Transaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transaction) ProtoMessage() {}

func (x *Transaction) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transaction.ProtoReflect.Descriptor instead.
func (*Transaction) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{14}
}

func (x *Transaction) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *Transaction) GetHandle() uint64 {
	if x != nil && x.Handle != nil {
		return *x.Handle
	}
	return 0
}

func (x *Transaction) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

func (x *Transaction) GetMarkChanges() bool {
	if x != nil && x.MarkChanges != nil {
		return *x.MarkChanges
	}
	return Default_Transaction_MarkChanges
}

type Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header              *InternalHeader   `protobuf:"bytes,39,opt,name=header" json:"header,omitempty"`
	App                 *string           `protobuf:"bytes,1,req,name=app" json:"app,omitempty"`
	NameSpace           *string           `protobuf:"bytes,29,opt,name=name_space,json=nameSpace" json:"name_space,omitempty"`
	Kind                *string           `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Ancestor            *Reference        `protobuf:"bytes,17,opt,name=ancestor" json:"ancestor,omitempty"`
	Filter              []*Query_Filter   `protobuf:"group,4,rep,name=Filter,json=filter" json:"filter,omitempty"`
	SearchQuery         *string           `protobuf:"bytes,8,opt,name=search_query,json=searchQuery" json:"search_query,omitempty"`
	Order               []*Query_Order    `protobuf:"group,9,rep,name=Order,json=order" json:"order,omitempty"`
	Hint                *Query_Hint       `protobuf:"varint,18,opt,name=hint,enum=appengine.v2.Query_Hint" json:"hint,omitempty"`
	Count               *int32            `protobuf:"varint,23,opt,name=count" json:"count,omitempty"`
	Offset              *int32            `protobuf:"varint,12,opt,name=offset,def=0" json:"offset,omitempty"`
	Limit               *int32            `protobuf:"varint,16,opt,name=limit" json:"limit,omitempty"`
	CompiledCursor      *CompiledCursor   `protobuf:"bytes,30,opt,name=compiled_cursor,json=compiledCursor" json:"compiled_cursor,omitempty"`
	EndCompiledCursor   *CompiledCursor   `protobuf:"bytes,31,opt,name=end_compiled_cursor,json=endCompiledCursor" json:"end_compiled_cursor,omitempty"`
	CompositeIndex      []*CompositeIndex `protobuf:"bytes,19,rep,name=composite_index,json=compositeIndex" json:"composite_index,omitempty"`
	RequirePerfectPlan  *bool             `protobuf:"varint,20,opt,name=require_perfect_plan,json=requirePerfectPlan,def=0" json:"require_perfect_plan,omitempty"`
	KeysOnly            *bool             `protobuf:"varint,21,opt,name=keys_only,json=keysOnly,def=0" json:"keys_only,omitempty"`
	Transaction         *Transaction      `protobuf:"bytes,22,opt,name=transaction" json:"transaction,omitempty"`
	Compile             *bool             `protobuf:"varint,25,opt,name=compile,def=0" json:"compile,omitempty"`
	FailoverMs          *int64            `protobuf:"varint,26,opt,name=failover_ms,json=failoverMs" json:"failover_ms,omitempty"`
	Strong              *bool             `protobuf:"varint,32,opt,name=strong" json:"strong,omitempty"`
	PropertyName        []string          `protobuf:"bytes,33,rep,name=property_name,json=propertyName" json:"property_name,omitempty"`
	GroupByPropertyName []string          `protobuf:"bytes,34,rep,name=group_by_property_name,json=groupByPropertyName" json:"group_by_property_name,omitempty"`
	Distinct            *bool             `protobuf:"varint,24,opt,name=distinct" json:"distinct,omitempty"`
	MinSafeTimeSeconds  *int64            `protobuf:"varint,35,opt,name=min_safe_time_seconds,json=minSafeTimeSeconds" json:"min_safe_time_seconds,omitempty"`
	SafeReplicaName     []string          `protobuf:"bytes,36,rep,name=safe_replica_name,json=safeReplicaName" json:"safe_replica_name,omitempty"`
	PersistOffset       *bool             `protobuf:"varint,37,opt,name=persist_offset,json=persistOffset,def=0" json:"persist_offset,omitempty"`
}

// Default values for Query fields.
const (
	Default_Query_Offset             = int32(0)
	Default_Query_RequirePerfectPlan = bool(false)
	Default_Query_KeysOnly           = bool(false)
	Default_Query_Compile            = bool(false)
	Default_Query_PersistOffset      = bool(false)
)

func (x *Query) Reset() {
	*x = Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Query) ProtoMessage() {}

func (x *Query) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Query.ProtoReflect.Descriptor instead.
func (*Query) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15}
}

func (x *Query) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *Query) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

func (x *Query) GetNameSpace() string {
	if x != nil && x.NameSpace != nil {
		return *x.NameSpace
	}
	return ""
}

func (x *Query) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Query) GetAncestor() *Reference {
	if x != nil {
		return x.Ancestor
	}
	return nil
}

func (x *Query) GetFilter() []*Query_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *Query) GetSearchQuery() string {
	if x != nil && x.SearchQuery != nil {
		return *x.SearchQuery
	}
	return ""
}

func (x *Query) GetOrder() []*Query_Order {
	if x != nil {
		return x.Order
	}
	return nil
}

func (x *Query) GetHint() Query_Hint {
	if x != nil && x.Hint != nil {
		return *x.Hint
	}
	return Query_ORDER_FIRST
}

func (x *Query) GetCount() int32 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *Query) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return Default_Query_Offset
}

func (x *Query) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

func (x *Query) GetCompiledCursor() *CompiledCursor {
	if x != nil {
		return x.CompiledCursor
	}
	return nil
}

func (x *Query) GetEndCompiledCursor() *CompiledCursor {
	if x != nil {
		return x.EndCompiledCursor
	}
	return nil
}

func (x *Query) GetCompositeIndex() []*CompositeIndex {
	if x != nil {
		return x.CompositeIndex
	}
	return nil
}

func (x *Query) GetRequirePerfectPlan() bool {
	if x != nil && x.RequirePerfectPlan != nil {
		return *x.RequirePerfectPlan
	}
	return Default_Query_RequirePerfectPlan
}

func (x *Query) GetKeysOnly() bool {
	if x != nil && x.KeysOnly != nil {
		return *x.KeysOnly
	}
	return Default_Query_KeysOnly
}

func (x *Query) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *Query) GetCompile() bool {
	if x != nil && x.Compile != nil {
		return *x.Compile
	}
	return Default_Query_Compile
}

func (x *Query) GetFailoverMs() int64 {
	if x != nil && x.FailoverMs != nil {
		return *x.FailoverMs
	}
	return 0
}

func (x *Query) GetStrong() bool {
	if x != nil && x.Strong != nil {
		return *x.Strong
	}
	return false
}

func (x *Query) GetPropertyName() []string {
	if x != nil {
		return x.PropertyName
	}
	return nil
}

func (x *Query) GetGroupByPropertyName() []string {
	if x != nil {
		return x.GroupByPropertyName
	}
	return nil
}

func (x *Query) GetDistinct() bool {
	if x != nil && x.Distinct != nil {
		return *x.Distinct
	}
	return false
}

func (x *Query) GetMinSafeTimeSeconds() int64 {
	if x != nil && x.MinSafeTimeSeconds != nil {
		return *x.MinSafeTimeSeconds
	}
	return 0
}

func (x *Query) GetSafeReplicaName() []string {
	if x != nil {
		return x.SafeReplicaName
	}
	return nil
}

func (x *Query) GetPersistOffset() bool {
	if x != nil && x.PersistOffset != nil {
		return *x.PersistOffset
	}
	return Default_Query_PersistOffset
}

type CompiledQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Primaryscan       *CompiledQuery_PrimaryScan     `protobuf:"group,1,req,name=PrimaryScan,json=primaryscan" json:"primaryscan,omitempty"`
	Mergejoinscan     []*CompiledQuery_MergeJoinScan `protobuf:"group,7,rep,name=MergeJoinScan,json=mergejoinscan" json:"mergejoinscan,omitempty"`
	IndexDef          *Index                         `protobuf:"bytes,21,opt,name=index_def,json=indexDef" json:"index_def,omitempty"`
	Offset            *int32                         `protobuf:"varint,10,opt,name=offset,def=0" json:"offset,omitempty"`
	Limit             *int32                         `protobuf:"varint,11,opt,name=limit" json:"limit,omitempty"`
	KeysOnly          *bool                          `protobuf:"varint,12,req,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
	PropertyName      []string                       `protobuf:"bytes,24,rep,name=property_name,json=propertyName" json:"property_name,omitempty"`
	DistinctInfixSize *int32                         `protobuf:"varint,25,opt,name=distinct_infix_size,json=distinctInfixSize" json:"distinct_infix_size,omitempty"`
	Entityfilter      *CompiledQuery_EntityFilter    `protobuf:"group,13,opt,name=EntityFilter,json=entityfilter" json:"entityfilter,omitempty"`
}

// Default values for CompiledQuery fields.
const (
	Default_CompiledQuery_Offset = int32(0)
)

func (x *CompiledQuery) Reset() {
	*x = CompiledQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledQuery) ProtoMessage() {}

func (x *CompiledQuery) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledQuery.ProtoReflect.Descriptor instead.
func (*CompiledQuery) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{16}
}

func (x *CompiledQuery) GetPrimaryscan() *CompiledQuery_PrimaryScan {
	if x != nil {
		return x.Primaryscan
	}
	return nil
}

func (x *CompiledQuery) GetMergejoinscan() []*CompiledQuery_MergeJoinScan {
	if x != nil {
		return x.Mergejoinscan
	}
	return nil
}

func (x *CompiledQuery) GetIndexDef() *Index {
	if x != nil {
		return x.IndexDef
	}
	return nil
}

func (x *CompiledQuery) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return Default_CompiledQuery_Offset
}

func (x *CompiledQuery) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

func (x *CompiledQuery) GetKeysOnly() bool {
	if x != nil && x.KeysOnly != nil {
		return *x.KeysOnly
	}
	return false
}

func (x *CompiledQuery) GetPropertyName() []string {
	if x != nil {
		return x.PropertyName
	}
	return nil
}

func (x *CompiledQuery) GetDistinctInfixSize() int32 {
	if x != nil && x.DistinctInfixSize != nil {
		return *x.DistinctInfixSize
	}
	return 0
}

func (x *CompiledQuery) GetEntityfilter() *CompiledQuery_EntityFilter {
	if x != nil {
		return x.Entityfilter
	}
	return nil
}

type CompiledCursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Position *CompiledCursor_Position `protobuf:"group,2,opt,name=Position,json=position" json:"position,omitempty"`
}

func (x *CompiledCursor) Reset() {
	*x = CompiledCursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledCursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledCursor) ProtoMessage() {}

func (x *CompiledCursor) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledCursor.ProtoReflect.Descriptor instead.
func (*CompiledCursor) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{17}
}

func (x *CompiledCursor) GetPosition() *CompiledCursor_Position {
	if x != nil {
		return x.Position
	}
	return nil
}

type Cursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cursor *uint64 `protobuf:"fixed64,1,req,name=cursor" json:"cursor,omitempty"`
	App    *string `protobuf:"bytes,2,opt,name=app" json:"app,omitempty"`
}

func (x *Cursor) Reset() {
	*x = Cursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cursor) ProtoMessage() {}

func (x *Cursor) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cursor.ProtoReflect.Descriptor instead.
func (*Cursor) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{18}
}

func (x *Cursor) GetCursor() uint64 {
	if x != nil && x.Cursor != nil {
		return *x.Cursor
	}
	return 0
}

func (x *Cursor) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{19}
}

type Cost struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexWrites             *int32           `protobuf:"varint,1,opt,name=index_writes,json=indexWrites" json:"index_writes,omitempty"`
	IndexWriteBytes         *int32           `protobuf:"varint,2,opt,name=index_write_bytes,json=indexWriteBytes" json:"index_write_bytes,omitempty"`
	EntityWrites            *int32           `protobuf:"varint,3,opt,name=entity_writes,json=entityWrites" json:"entity_writes,omitempty"`
	EntityWriteBytes        *int32           `protobuf:"varint,4,opt,name=entity_write_bytes,json=entityWriteBytes" json:"entity_write_bytes,omitempty"`
	Commitcost              *Cost_CommitCost `protobuf:"group,5,opt,name=CommitCost,json=commitcost" json:"commitcost,omitempty"`
	ApproximateStorageDelta *int32           `protobuf:"varint,8,opt,name=approximate_storage_delta,json=approximateStorageDelta" json:"approximate_storage_delta,omitempty"`
	IdSequenceUpdates       *int32           `protobuf:"varint,9,opt,name=id_sequence_updates,json=idSequenceUpdates" json:"id_sequence_updates,omitempty"`
}

func (x *Cost) Reset() {
	*x = Cost{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cost) ProtoMessage() {}

func (x *Cost) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cost.ProtoReflect.Descriptor instead.
func (*Cost) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{20}
}

func (x *Cost) GetIndexWrites() int32 {
	if x != nil && x.IndexWrites != nil {
		return *x.IndexWrites
	}
	return 0
}

func (x *Cost) GetIndexWriteBytes() int32 {
	if x != nil && x.IndexWriteBytes != nil {
		return *x.IndexWriteBytes
	}
	return 0
}

func (x *Cost) GetEntityWrites() int32 {
	if x != nil && x.EntityWrites != nil {
		return *x.EntityWrites
	}
	return 0
}

func (x *Cost) GetEntityWriteBytes() int32 {
	if x != nil && x.EntityWriteBytes != nil {
		return *x.EntityWriteBytes
	}
	return 0
}

func (x *Cost) GetCommitcost() *Cost_CommitCost {
	if x != nil {
		return x.Commitcost
	}
	return nil
}

func (x *Cost) GetApproximateStorageDelta() int32 {
	if x != nil && x.ApproximateStorageDelta != nil {
		return *x.ApproximateStorageDelta
	}
	return 0
}

func (x *Cost) GetIdSequenceUpdates() int32 {
	if x != nil && x.IdSequenceUpdates != nil {
		return *x.IdSequenceUpdates
	}
	return 0
}

type GetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header        *InternalHeader `protobuf:"bytes,6,opt,name=header" json:"header,omitempty"`
	Key           []*Reference    `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	Transaction   *Transaction    `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	FailoverMs    *int64          `protobuf:"varint,3,opt,name=failover_ms,json=failoverMs" json:"failover_ms,omitempty"`
	Strong        *bool           `protobuf:"varint,4,opt,name=strong" json:"strong,omitempty"`
	AllowDeferred *bool           `protobuf:"varint,5,opt,name=allow_deferred,json=allowDeferred,def=0" json:"allow_deferred,omitempty"`
}

// Default values for GetRequest fields.
const (
	Default_GetRequest_AllowDeferred = bool(false)
)

func (x *GetRequest) Reset() {
	*x = GetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequest) ProtoMessage() {}

func (x *GetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequest.ProtoReflect.Descriptor instead.
func (*GetRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{21}
}

func (x *GetRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetRequest) GetKey() []*Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *GetRequest) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *GetRequest) GetFailoverMs() int64 {
	if x != nil && x.FailoverMs != nil {
		return *x.FailoverMs
	}
	return 0
}

func (x *GetRequest) GetStrong() bool {
	if x != nil && x.Strong != nil {
		return *x.Strong
	}
	return false
}

func (x *GetRequest) GetAllowDeferred() bool {
	if x != nil && x.AllowDeferred != nil {
		return *x.AllowDeferred
	}
	return Default_GetRequest_AllowDeferred
}

type GetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entity   []*GetResponse_Entity `protobuf:"group,1,rep,name=Entity,json=entity" json:"entity,omitempty"`
	Deferred []*Reference          `protobuf:"bytes,5,rep,name=deferred" json:"deferred,omitempty"`
	InOrder  *bool                 `protobuf:"varint,6,opt,name=in_order,json=inOrder,def=1" json:"in_order,omitempty"`
}

// Default values for GetResponse fields.
const (
	Default_GetResponse_InOrder = bool(true)
)

func (x *GetResponse) Reset() {
	*x = GetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResponse) ProtoMessage() {}

func (x *GetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResponse.ProtoReflect.Descriptor instead.
func (*GetResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{22}
}

func (x *GetResponse) GetEntity() []*GetResponse_Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *GetResponse) GetDeferred() []*Reference {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *GetResponse) GetInOrder() bool {
	if x != nil && x.InOrder != nil {
		return *x.InOrder
	}
	return Default_GetResponse_InOrder
}

type PutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header         *InternalHeader          `protobuf:"bytes,11,opt,name=header" json:"header,omitempty"`
	Entity         []*EntityProto           `protobuf:"bytes,1,rep,name=entity" json:"entity,omitempty"`
	Transaction    *Transaction             `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	CompositeIndex []*CompositeIndex        `protobuf:"bytes,3,rep,name=composite_index,json=compositeIndex" json:"composite_index,omitempty"`
	Trusted        *bool                    `protobuf:"varint,4,opt,name=trusted,def=0" json:"trusted,omitempty"`
	Force          *bool                    `protobuf:"varint,7,opt,name=force,def=0" json:"force,omitempty"`
	MarkChanges    *bool                    `protobuf:"varint,8,opt,name=mark_changes,json=markChanges,def=0" json:"mark_changes,omitempty"`
	Snapshot       []*Snapshot              `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
	AutoIdPolicy   *PutRequest_AutoIdPolicy `protobuf:"varint,10,opt,name=auto_id_policy,json=autoIdPolicy,enum=appengine.v2.PutRequest_AutoIdPolicy,def=0" json:"auto_id_policy,omitempty"`
}

// Default values for PutRequest fields.
const (
	Default_PutRequest_Trusted      = bool(false)
	Default_PutRequest_Force        = bool(false)
	Default_PutRequest_MarkChanges  = bool(false)
	Default_PutRequest_AutoIdPolicy = PutRequest_CURRENT
)

func (x *PutRequest) Reset() {
	*x = PutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutRequest) ProtoMessage() {}

func (x *PutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutRequest.ProtoReflect.Descriptor instead.
func (*PutRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{23}
}

func (x *PutRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PutRequest) GetEntity() []*EntityProto {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *PutRequest) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *PutRequest) GetCompositeIndex() []*CompositeIndex {
	if x != nil {
		return x.CompositeIndex
	}
	return nil
}

func (x *PutRequest) GetTrusted() bool {
	if x != nil && x.Trusted != nil {
		return *x.Trusted
	}
	return Default_PutRequest_Trusted
}

func (x *PutRequest) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return Default_PutRequest_Force
}

func (x *PutRequest) GetMarkChanges() bool {
	if x != nil && x.MarkChanges != nil {
		return *x.MarkChanges
	}
	return Default_PutRequest_MarkChanges
}

func (x *PutRequest) GetSnapshot() []*Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

func (x *PutRequest) GetAutoIdPolicy() PutRequest_AutoIdPolicy {
	if x != nil && x.AutoIdPolicy != nil {
		return *x.AutoIdPolicy
	}
	return Default_PutRequest_AutoIdPolicy
}

type PutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key     []*Reference `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	Cost    *Cost        `protobuf:"bytes,2,opt,name=cost" json:"cost,omitempty"`
	Version []int64      `protobuf:"varint,3,rep,name=version" json:"version,omitempty"`
}

func (x *PutResponse) Reset() {
	*x = PutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutResponse) ProtoMessage() {}

func (x *PutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutResponse.ProtoReflect.Descriptor instead.
func (*PutResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{24}
}

func (x *PutResponse) GetKey() []*Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PutResponse) GetCost() *Cost {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *PutResponse) GetVersion() []int64 {
	if x != nil {
		return x.Version
	}
	return nil
}

type TouchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header         *InternalHeader   `protobuf:"bytes,10,opt,name=header" json:"header,omitempty"`
	Key            []*Reference      `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	CompositeIndex []*CompositeIndex `protobuf:"bytes,2,rep,name=composite_index,json=compositeIndex" json:"composite_index,omitempty"`
	Force          *bool             `protobuf:"varint,3,opt,name=force,def=0" json:"force,omitempty"`
	Snapshot       []*Snapshot       `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
}

// Default values for TouchRequest fields.
const (
	Default_TouchRequest_Force = bool(false)
)

func (x *TouchRequest) Reset() {
	*x = TouchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TouchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TouchRequest) ProtoMessage() {}

func (x *TouchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TouchRequest.ProtoReflect.Descriptor instead.
func (*TouchRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{25}
}

func (x *TouchRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *TouchRequest) GetKey() []*Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *TouchRequest) GetCompositeIndex() []*CompositeIndex {
	if x != nil {
		return x.CompositeIndex
	}
	return nil
}

func (x *TouchRequest) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return Default_TouchRequest_Force
}

func (x *TouchRequest) GetSnapshot() []*Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

type TouchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cost *Cost `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
}

func (x *TouchResponse) Reset() {
	*x = TouchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TouchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TouchResponse) ProtoMessage() {}

func (x *TouchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TouchResponse.ProtoReflect.Descriptor instead.
func (*TouchResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{26}
}

func (x *TouchResponse) GetCost() *Cost {
	if x != nil {
		return x.Cost
	}
	return nil
}

type DeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *InternalHeader `protobuf:"bytes,10,opt,name=header" json:"header,omitempty"`
	Key         []*Reference    `protobuf:"bytes,6,rep,name=key" json:"key,omitempty"`
	Transaction *Transaction    `protobuf:"bytes,5,opt,name=transaction" json:"transaction,omitempty"`
	Trusted     *bool           `protobuf:"varint,4,opt,name=trusted,def=0" json:"trusted,omitempty"`
	Force       *bool           `protobuf:"varint,7,opt,name=force,def=0" json:"force,omitempty"`
	MarkChanges *bool           `protobuf:"varint,8,opt,name=mark_changes,json=markChanges,def=0" json:"mark_changes,omitempty"`
	Snapshot    []*Snapshot     `protobuf:"bytes,9,rep,name=snapshot" json:"snapshot,omitempty"`
}

// Default values for DeleteRequest fields.
const (
	Default_DeleteRequest_Trusted     = bool(false)
	Default_DeleteRequest_Force       = bool(false)
	Default_DeleteRequest_MarkChanges = bool(false)
)

func (x *DeleteRequest) Reset() {
	*x = DeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRequest) ProtoMessage() {}

func (x *DeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRequest.ProtoReflect.Descriptor instead.
func (*DeleteRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DeleteRequest) GetKey() []*Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *DeleteRequest) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *DeleteRequest) GetTrusted() bool {
	if x != nil && x.Trusted != nil {
		return *x.Trusted
	}
	return Default_DeleteRequest_Trusted
}

func (x *DeleteRequest) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return Default_DeleteRequest_Force
}

func (x *DeleteRequest) GetMarkChanges() bool {
	if x != nil && x.MarkChanges != nil {
		return *x.MarkChanges
	}
	return Default_DeleteRequest_MarkChanges
}

func (x *DeleteRequest) GetSnapshot() []*Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

type DeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cost    *Cost   `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
	Version []int64 `protobuf:"varint,3,rep,name=version" json:"version,omitempty"`
}

func (x *DeleteResponse) Reset() {
	*x = DeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteResponse) ProtoMessage() {}

func (x *DeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteResponse.ProtoReflect.Descriptor instead.
func (*DeleteResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteResponse) GetCost() *Cost {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *DeleteResponse) GetVersion() []int64 {
	if x != nil {
		return x.Version
	}
	return nil
}

type NextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *InternalHeader `protobuf:"bytes,5,opt,name=header" json:"header,omitempty"`
	Cursor  *Cursor         `protobuf:"bytes,1,req,name=cursor" json:"cursor,omitempty"`
	Count   *int32          `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	Offset  *int32          `protobuf:"varint,4,opt,name=offset,def=0" json:"offset,omitempty"`
	Compile *bool           `protobuf:"varint,3,opt,name=compile,def=0" json:"compile,omitempty"`
}

// Default values for NextRequest fields.
const (
	Default_NextRequest_Offset  = int32(0)
	Default_NextRequest_Compile = bool(false)
)

func (x *NextRequest) Reset() {
	*x = NextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextRequest) ProtoMessage() {}

func (x *NextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextRequest.ProtoReflect.Descriptor instead.
func (*NextRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{29}
}

func (x *NextRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *NextRequest) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

func (x *NextRequest) GetCount() int32 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *NextRequest) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return Default_NextRequest_Offset
}

func (x *NextRequest) GetCompile() bool {
	if x != nil && x.Compile != nil {
		return *x.Compile
	}
	return Default_NextRequest_Compile
}

type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cursor         *Cursor           `protobuf:"bytes,1,opt,name=cursor" json:"cursor,omitempty"`
	Result         []*EntityProto    `protobuf:"bytes,2,rep,name=result" json:"result,omitempty"`
	SkippedResults *int32            `protobuf:"varint,7,opt,name=skipped_results,json=skippedResults" json:"skipped_results,omitempty"`
	MoreResults    *bool             `protobuf:"varint,3,req,name=more_results,json=moreResults" json:"more_results,omitempty"`
	KeysOnly       *bool             `protobuf:"varint,4,opt,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
	IndexOnly      *bool             `protobuf:"varint,9,opt,name=index_only,json=indexOnly" json:"index_only,omitempty"`
	SmallOps       *bool             `protobuf:"varint,10,opt,name=small_ops,json=smallOps" json:"small_ops,omitempty"`
	CompiledQuery  *CompiledQuery    `protobuf:"bytes,5,opt,name=compiled_query,json=compiledQuery" json:"compiled_query,omitempty"`
	CompiledCursor *CompiledCursor   `protobuf:"bytes,6,opt,name=compiled_cursor,json=compiledCursor" json:"compiled_cursor,omitempty"`
	Index          []*CompositeIndex `protobuf:"bytes,8,rep,name=index" json:"index,omitempty"`
	Version        []int64           `protobuf:"varint,11,rep,name=version" json:"version,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{30}
}

func (x *QueryResult) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

func (x *QueryResult) GetResult() []*EntityProto {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *QueryResult) GetSkippedResults() int32 {
	if x != nil && x.SkippedResults != nil {
		return *x.SkippedResults
	}
	return 0
}

func (x *QueryResult) GetMoreResults() bool {
	if x != nil && x.MoreResults != nil {
		return *x.MoreResults
	}
	return false
}

func (x *QueryResult) GetKeysOnly() bool {
	if x != nil && x.KeysOnly != nil {
		return *x.KeysOnly
	}
	return false
}

func (x *QueryResult) GetIndexOnly() bool {
	if x != nil && x.IndexOnly != nil {
		return *x.IndexOnly
	}
	return false
}

func (x *QueryResult) GetSmallOps() bool {
	if x != nil && x.SmallOps != nil {
		return *x.SmallOps
	}
	return false
}

func (x *QueryResult) GetCompiledQuery() *CompiledQuery {
	if x != nil {
		return x.CompiledQuery
	}
	return nil
}

func (x *QueryResult) GetCompiledCursor() *CompiledCursor {
	if x != nil {
		return x.CompiledCursor
	}
	return nil
}

func (x *QueryResult) GetIndex() []*CompositeIndex {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *QueryResult) GetVersion() []int64 {
	if x != nil {
		return x.Version
	}
	return nil
}

type AllocateIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header   *InternalHeader `protobuf:"bytes,4,opt,name=header" json:"header,omitempty"`
	ModelKey *Reference      `protobuf:"bytes,1,opt,name=model_key,json=modelKey" json:"model_key,omitempty"`
	Size     *int64          `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	Max      *int64          `protobuf:"varint,3,opt,name=max" json:"max,omitempty"`
	Reserve  []*Reference    `protobuf:"bytes,5,rep,name=reserve" json:"reserve,omitempty"`
}

func (x *AllocateIdsRequest) Reset() {
	*x = AllocateIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocateIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateIdsRequest) ProtoMessage() {}

func (x *AllocateIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateIdsRequest.ProtoReflect.Descriptor instead.
func (*AllocateIdsRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{31}
}

func (x *AllocateIdsRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *AllocateIdsRequest) GetModelKey() *Reference {
	if x != nil {
		return x.ModelKey
	}
	return nil
}

func (x *AllocateIdsRequest) GetSize() int64 {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return 0
}

func (x *AllocateIdsRequest) GetMax() int64 {
	if x != nil && x.Max != nil {
		return *x.Max
	}
	return 0
}

func (x *AllocateIdsRequest) GetReserve() []*Reference {
	if x != nil {
		return x.Reserve
	}
	return nil
}

type AllocateIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start *int64 `protobuf:"varint,1,req,name=start" json:"start,omitempty"`
	End   *int64 `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
	Cost  *Cost  `protobuf:"bytes,3,opt,name=cost" json:"cost,omitempty"`
}

func (x *AllocateIdsResponse) Reset() {
	*x = AllocateIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocateIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateIdsResponse) ProtoMessage() {}

func (x *AllocateIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateIdsResponse.ProtoReflect.Descriptor instead.
func (*AllocateIdsResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{32}
}

func (x *AllocateIdsResponse) GetStart() int64 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *AllocateIdsResponse) GetEnd() int64 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

func (x *AllocateIdsResponse) GetCost() *Cost {
	if x != nil {
		return x.Cost
	}
	return nil
}

type CompositeIndices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Index []*CompositeIndex `protobuf:"bytes,1,rep,name=index" json:"index,omitempty"`
}

func (x *CompositeIndices) Reset() {
	*x = CompositeIndices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompositeIndices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompositeIndices) ProtoMessage() {}

func (x *CompositeIndices) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompositeIndices.ProtoReflect.Descriptor instead.
func (*CompositeIndices) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{33}
}

func (x *CompositeIndices) GetIndex() []*CompositeIndex {
	if x != nil {
		return x.Index
	}
	return nil
}

type AddActionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *InternalHeader `protobuf:"bytes,3,opt,name=header" json:"header,omitempty"`
	Transaction *Transaction    `protobuf:"bytes,1,req,name=transaction" json:"transaction,omitempty"`
	Action      []*Action       `protobuf:"bytes,2,rep,name=action" json:"action,omitempty"`
}

func (x *AddActionsRequest) Reset() {
	*x = AddActionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddActionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddActionsRequest) ProtoMessage() {}

func (x *AddActionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddActionsRequest.ProtoReflect.Descriptor instead.
func (*AddActionsRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{34}
}

func (x *AddActionsRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *AddActionsRequest) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *AddActionsRequest) GetAction() []*Action {
	if x != nil {
		return x.Action
	}
	return nil
}

type AddActionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddActionsResponse) Reset() {
	*x = AddActionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddActionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddActionsResponse) ProtoMessage() {}

func (x *AddActionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddActionsResponse.ProtoReflect.Descriptor instead.
func (*AddActionsResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{35}
}

type BeginTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header              *InternalHeader                          `protobuf:"bytes,3,opt,name=header" json:"header,omitempty"`
	App                 *string                                  `protobuf:"bytes,1,req,name=app" json:"app,omitempty"`
	AllowMultipleEg     *bool                                    `protobuf:"varint,2,opt,name=allow_multiple_eg,json=allowMultipleEg,def=0" json:"allow_multiple_eg,omitempty"`
	DatabaseId          *string                                  `protobuf:"bytes,4,opt,name=database_id,json=databaseId" json:"database_id,omitempty"`
	Mode                *BeginTransactionRequest_TransactionMode `protobuf:"varint,5,opt,name=mode,enum=appengine.v2.BeginTransactionRequest_TransactionMode,def=0" json:"mode,omitempty"`
	PreviousTransaction *Transaction                             `protobuf:"bytes,7,opt,name=previous_transaction,json=previousTransaction" json:"previous_transaction,omitempty"`
}

// Default values for BeginTransactionRequest fields.
const (
	Default_BeginTransactionRequest_AllowMultipleEg = bool(false)
	Default_BeginTransactionRequest_Mode            = BeginTransactionRequest_UNKNOWN
)

func (x *BeginTransactionRequest) Reset() {
	*x = BeginTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginTransactionRequest) ProtoMessage() {}

func (x *BeginTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginTransactionRequest.ProtoReflect.Descriptor instead.
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{36}
}

func (x *BeginTransactionRequest) GetHeader() *InternalHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *BeginTransactionRequest) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

func (x *BeginTransactionRequest) GetAllowMultipleEg() bool {
	if x != nil && x.AllowMultipleEg != nil {
		return *x.AllowMultipleEg
	}
	return Default_BeginTransactionRequest_AllowMultipleEg
}

func (x *BeginTransactionRequest) GetDatabaseId() string {
	if x != nil && x.DatabaseId != nil {
		return *x.DatabaseId
	}
	return ""
}

func (x *BeginTransactionRequest) GetMode() BeginTransactionRequest_TransactionMode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return Default_BeginTransactionRequest_Mode
}

func (x *BeginTransactionRequest) GetPreviousTransaction() *Transaction {
	if x != nil {
		return x.PreviousTransaction
	}
	return nil
}

type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cost    *Cost                     `protobuf:"bytes,1,opt,name=cost" json:"cost,omitempty"`
	Version []*CommitResponse_Version `protobuf:"group,3,rep,name=Version,json=version" json:"version,omitempty"`
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{37}
}

func (x *CommitResponse) GetCost() *Cost {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *CommitResponse) GetVersion() []*CommitResponse_Version {
	if x != nil {
		return x.Version
	}
	return nil
}

type PropertyValue_PointValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	X *float64 `protobuf:"fixed64,6,req,name=x" json:"x,omitempty"`
	Y *float64 `protobuf:"fixed64,7,req,name=y" json:"y,omitempty"`
}

func (x *PropertyValue_PointValue) Reset() {
	*x = PropertyValue_PointValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyValue_PointValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyValue_PointValue) ProtoMessage() {}

func (x *PropertyValue_PointValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyValue_PointValue.ProtoReflect.Descriptor instead.
func (*PropertyValue_PointValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{1, 0}
}

func (x *PropertyValue_PointValue) GetX() float64 {
	if x != nil && x.X != nil {
		return *x.X
	}
	return 0
}

func (x *PropertyValue_PointValue) GetY() float64 {
	if x != nil && x.Y != nil {
		return *x.Y
	}
	return 0
}

type PropertyValue_UserValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Email             *string `protobuf:"bytes,9,req,name=email" json:"email,omitempty"`
	AuthDomain        *string `protobuf:"bytes,10,req,name=auth_domain,json=authDomain" json:"auth_domain,omitempty"`
	Nickname          *string `protobuf:"bytes,11,opt,name=nickname" json:"nickname,omitempty"`
	FederatedIdentity *string `protobuf:"bytes,21,opt,name=federated_identity,json=federatedIdentity" json:"federated_identity,omitempty"`
	FederatedProvider *string `protobuf:"bytes,22,opt,name=federated_provider,json=federatedProvider" json:"federated_provider,omitempty"`
}

func (x *PropertyValue_UserValue) Reset() {
	*x = PropertyValue_UserValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyValue_UserValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyValue_UserValue) ProtoMessage() {}

func (x *PropertyValue_UserValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyValue_UserValue.ProtoReflect.Descriptor instead.
func (*PropertyValue_UserValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{1, 1}
}

func (x *PropertyValue_UserValue) GetEmail() string {
	if x != nil && x.Email != nil {
		return *x.Email
	}
	return ""
}

func (x *PropertyValue_UserValue) GetAuthDomain() string {
	if x != nil && x.AuthDomain != nil {
		return *x.AuthDomain
	}
	return ""
}

func (x *PropertyValue_UserValue) GetNickname() string {
	if x != nil && x.Nickname != nil {
		return *x.Nickname
	}
	return ""
}

func (x *PropertyValue_UserValue) GetFederatedIdentity() string {
	if x != nil && x.FederatedIdentity != nil {
		return *x.FederatedIdentity
	}
	return ""
}

func (x *PropertyValue_UserValue) GetFederatedProvider() string {
	if x != nil && x.FederatedProvider != nil {
		return *x.FederatedProvider
	}
	return ""
}

type PropertyValue_ReferenceValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	App         *string                                     `protobuf:"bytes,13,req,name=app" json:"app,omitempty"`
	NameSpace   *string                                     `protobuf:"bytes,20,opt,name=name_space,json=nameSpace" json:"name_space,omitempty"`
	Pathelement []*PropertyValue_ReferenceValue_PathElement `protobuf:"group,14,rep,name=PathElement,json=pathelement" json:"pathelement,omitempty"`
}

func (x *PropertyValue_ReferenceValue) Reset() {
	*x = PropertyValue_ReferenceValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyValue_ReferenceValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyValue_ReferenceValue) ProtoMessage() {}

func (x *PropertyValue_ReferenceValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyValue_ReferenceValue.ProtoReflect.Descriptor instead.
func (*PropertyValue_ReferenceValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{1, 2}
}

func (x *PropertyValue_ReferenceValue) GetApp() string {
	if x != nil && x.App != nil {
		return *x.App
	}
	return ""
}

func (x *PropertyValue_ReferenceValue) GetNameSpace() string {
	if x != nil && x.NameSpace != nil {
		return *x.NameSpace
	}
	return ""
}

func (x *PropertyValue_ReferenceValue) GetPathelement() []*PropertyValue_ReferenceValue_PathElement {
	if x != nil {
		return x.Pathelement
	}
	return nil
}

type PropertyValue_ReferenceValue_PathElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *string `protobuf:"bytes,15,req,name=type" json:"type,omitempty"`
	Id   *int64  `protobuf:"varint,16,opt,name=id" json:"id,omitempty"`
	Name *string `protobuf:"bytes,17,opt,name=name" json:"name,omitempty"`
}

func (x *PropertyValue_ReferenceValue_PathElement) Reset() {
	*x = PropertyValue_ReferenceValue_PathElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyValue_ReferenceValue_PathElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyValue_ReferenceValue_PathElement) ProtoMessage() {}

func (x *PropertyValue_ReferenceValue_PathElement) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyValue_ReferenceValue_PathElement.ProtoReflect.Descriptor instead.
func (*PropertyValue_ReferenceValue_PathElement) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *PropertyValue_ReferenceValue_PathElement) GetType() string {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ""
}

func (x *PropertyValue_ReferenceValue_PathElement) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *PropertyValue_ReferenceValue_PathElement) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

type Path_Element struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *string `protobuf:"bytes,2,req,name=type" json:"type,omitempty"`
	Id   *int64  `protobuf:"varint,3,opt,name=id" json:"id,omitempty"`
	Name *string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (x *Path_Element) Reset() {
	*x = Path_Element{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Path_Element) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path_Element) ProtoMessage() {}

func (x *Path_Element) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path_Element.ProtoReflect.Descriptor instead.
func (*Path_Element) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Path_Element) GetType() string {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ""
}

func (x *Path_Element) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Path_Element) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

type Index_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      *string                   `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Direction *Index_Property_Direction `protobuf:"varint,4,opt,name=direction,enum=appengine.v2.Index_Property_Direction,def=1" json:"direction,omitempty"`
}

// Default values for Index_Property fields.
const (
	Default_Index_Property_Direction = Index_Property_ASCENDING
)

func (x *Index_Property) Reset() {
	*x = Index_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index_Property) ProtoMessage() {}

func (x *Index_Property) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index_Property.ProtoReflect.Descriptor instead.
func (*Index_Property) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Index_Property) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Index_Property) GetDirection() Index_Property_Direction {
	if x != nil && x.Direction != nil {
		return *x.Direction
	}
	return Default_Index_Property_Direction
}

type IndexPostfix_IndexValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PropertyName *string        `protobuf:"bytes,1,req,name=property_name,json=propertyName" json:"property_name,omitempty"`
	Value        *PropertyValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
}

func (x *IndexPostfix_IndexValue) Reset() {
	*x = IndexPostfix_IndexValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexPostfix_IndexValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexPostfix_IndexValue) ProtoMessage() {}

func (x *IndexPostfix_IndexValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexPostfix_IndexValue.ProtoReflect.Descriptor instead.
func (*IndexPostfix_IndexValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{10, 0}
}

func (x *IndexPostfix_IndexValue) GetPropertyName() string {
	if x != nil && x.PropertyName != nil {
		return *x.PropertyName
	}
	return ""
}

func (x *IndexPostfix_IndexValue) GetValue() *PropertyValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type Query_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Op       *Query_Filter_Operator `protobuf:"varint,6,req,name=op,enum=appengine.v2.Query_Filter_Operator" json:"op,omitempty"`
	Property []*Property            `protobuf:"bytes,14,rep,name=property" json:"property,omitempty"`
}

func (x *Query_Filter) Reset() {
	*x = Query_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Query_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Query_Filter) ProtoMessage() {}

func (x *Query_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Query_Filter.ProtoReflect.Descriptor instead.
func (*Query_Filter) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15, 0}
}

func (x *Query_Filter) GetOp() Query_Filter_Operator {
	if x != nil && x.Op != nil {
		return *x.Op
	}
	return Query_Filter_LESS_THAN
}

func (x *Query_Filter) GetProperty() []*Property {
	if x != nil {
		return x.Property
	}
	return nil
}

type Query_Order struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Property  *string                `protobuf:"bytes,10,req,name=property" json:"property,omitempty"`
	Direction *Query_Order_Direction `protobuf:"varint,11,opt,name=direction,enum=appengine.v2.Query_Order_Direction,def=1" json:"direction,omitempty"`
}

// Default values for Query_Order fields.
const (
	Default_Query_Order_Direction = Query_Order_ASCENDING
)

func (x *Query_Order) Reset() {
	*x = Query_Order{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Query_Order) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Query_Order) ProtoMessage() {}

func (x *Query_Order) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Query_Order.ProtoReflect.Descriptor instead.
func (*Query_Order) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{15, 1}
}

func (x *Query_Order) GetProperty() string {
	if x != nil && x.Property != nil {
		return *x.Property
	}
	return ""
}

func (x *Query_Order) GetDirection() Query_Order_Direction {
	if x != nil && x.Direction != nil {
		return *x.Direction
	}
	return Default_Query_Order_Direction
}

type CompiledQuery_PrimaryScan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexName                  *string  `protobuf:"bytes,2,opt,name=index_name,json=indexName" json:"index_name,omitempty"`
	StartKey                   *string  `protobuf:"bytes,3,opt,name=start_key,json=startKey" json:"start_key,omitempty"`
	StartInclusive             *bool    `protobuf:"varint,4,opt,name=start_inclusive,json=startInclusive" json:"start_inclusive,omitempty"`
	EndKey                     *string  `protobuf:"bytes,5,opt,name=end_key,json=endKey" json:"end_key,omitempty"`
	EndInclusive               *bool    `protobuf:"varint,6,opt,name=end_inclusive,json=endInclusive" json:"end_inclusive,omitempty"`
	StartPostfixValue          []string `protobuf:"bytes,22,rep,name=start_postfix_value,json=startPostfixValue" json:"start_postfix_value,omitempty"`
	EndPostfixValue            []string `protobuf:"bytes,23,rep,name=end_postfix_value,json=endPostfixValue" json:"end_postfix_value,omitempty"`
	EndUnappliedLogTimestampUs *int64   `protobuf:"varint,19,opt,name=end_unapplied_log_timestamp_us,json=endUnappliedLogTimestampUs" json:"end_unapplied_log_timestamp_us,omitempty"`
}

func (x *CompiledQuery_PrimaryScan) Reset() {
	*x = CompiledQuery_PrimaryScan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledQuery_PrimaryScan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledQuery_PrimaryScan) ProtoMessage() {}

func (x *CompiledQuery_PrimaryScan) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledQuery_PrimaryScan.ProtoReflect.Descriptor instead.
func (*CompiledQuery_PrimaryScan) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{16, 0}
}

func (x *CompiledQuery_PrimaryScan) GetIndexName() string {
	if x != nil && x.IndexName != nil {
		return *x.IndexName
	}
	return ""
}

func (x *CompiledQuery_PrimaryScan) GetStartKey() string {
	if x != nil && x.StartKey != nil {
		return *x.StartKey
	}
	return ""
}

func (x *CompiledQuery_PrimaryScan) GetStartInclusive() bool {
	if x != nil && x.StartInclusive != nil {
		return *x.StartInclusive
	}
	return false
}

func (x *CompiledQuery_PrimaryScan) GetEndKey() string {
	if x != nil && x.EndKey != nil {
		return *x.EndKey
	}
	return ""
}

func (x *CompiledQuery_PrimaryScan) GetEndInclusive() bool {
	if x != nil && x.EndInclusive != nil {
		return *x.EndInclusive
	}
	return false
}

func (x *CompiledQuery_PrimaryScan) GetStartPostfixValue() []string {
	if x != nil {
		return x.StartPostfixValue
	}
	return nil
}

func (x *CompiledQuery_PrimaryScan) GetEndPostfixValue() []string {
	if x != nil {
		return x.EndPostfixValue
	}
	return nil
}

func (x *CompiledQuery_PrimaryScan) GetEndUnappliedLogTimestampUs() int64 {
	if x != nil && x.EndUnappliedLogTimestampUs != nil {
		return *x.EndUnappliedLogTimestampUs
	}
	return 0
}

type CompiledQuery_MergeJoinScan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexName   *string  `protobuf:"bytes,8,req,name=index_name,json=indexName" json:"index_name,omitempty"`
	PrefixValue []string `protobuf:"bytes,9,rep,name=prefix_value,json=prefixValue" json:"prefix_value,omitempty"`
	ValuePrefix *bool    `protobuf:"varint,20,opt,name=value_prefix,json=valuePrefix,def=0" json:"value_prefix,omitempty"`
}

// Default values for CompiledQuery_MergeJoinScan fields.
const (
	Default_CompiledQuery_MergeJoinScan_ValuePrefix = bool(false)
)

func (x *CompiledQuery_MergeJoinScan) Reset() {
	*x = CompiledQuery_MergeJoinScan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledQuery_MergeJoinScan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledQuery_MergeJoinScan) ProtoMessage() {}

func (x *CompiledQuery_MergeJoinScan) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledQuery_MergeJoinScan.ProtoReflect.Descriptor instead.
func (*CompiledQuery_MergeJoinScan) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{16, 1}
}

func (x *CompiledQuery_MergeJoinScan) GetIndexName() string {
	if x != nil && x.IndexName != nil {
		return *x.IndexName
	}
	return ""
}

func (x *CompiledQuery_MergeJoinScan) GetPrefixValue() []string {
	if x != nil {
		return x.PrefixValue
	}
	return nil
}

func (x *CompiledQuery_MergeJoinScan) GetValuePrefix() bool {
	if x != nil && x.ValuePrefix != nil {
		return *x.ValuePrefix
	}
	return Default_CompiledQuery_MergeJoinScan_ValuePrefix
}

type CompiledQuery_EntityFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Distinct *bool      `protobuf:"varint,14,opt,name=distinct,def=0" json:"distinct,omitempty"`
	Kind     *string    `protobuf:"bytes,17,opt,name=kind" json:"kind,omitempty"`
	Ancestor *Reference `protobuf:"bytes,18,opt,name=ancestor" json:"ancestor,omitempty"`
}

// Default values for CompiledQuery_EntityFilter fields.
const (
	Default_CompiledQuery_EntityFilter_Distinct = bool(false)
)

func (x *CompiledQuery_EntityFilter) Reset() {
	*x = CompiledQuery_EntityFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledQuery_EntityFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledQuery_EntityFilter) ProtoMessage() {}

func (x *CompiledQuery_EntityFilter) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledQuery_EntityFilter.ProtoReflect.Descriptor instead.
func (*CompiledQuery_EntityFilter) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{16, 2}
}

func (x *CompiledQuery_EntityFilter) GetDistinct() bool {
	if x != nil && x.Distinct != nil {
		return *x.Distinct
	}
	return Default_CompiledQuery_EntityFilter_Distinct
}

func (x *CompiledQuery_EntityFilter) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *CompiledQuery_EntityFilter) GetAncestor() *Reference {
	if x != nil {
		return x.Ancestor
	}
	return nil
}

type CompiledCursor_Position struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartKey       *string                               `protobuf:"bytes,27,opt,name=start_key,json=startKey" json:"start_key,omitempty"`
	Indexvalue     []*CompiledCursor_Position_IndexValue `protobuf:"group,29,rep,name=IndexValue,json=indexvalue" json:"indexvalue,omitempty"`
	Key            *Reference                            `protobuf:"bytes,32,opt,name=key" json:"key,omitempty"`
	StartInclusive *bool                                 `protobuf:"varint,28,opt,name=start_inclusive,json=startInclusive,def=1" json:"start_inclusive,omitempty"`
}

// Default values for CompiledCursor_Position fields.
const (
	Default_CompiledCursor_Position_StartInclusive = bool(true)
)

func (x *CompiledCursor_Position) Reset() {
	*x = CompiledCursor_Position{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledCursor_Position) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledCursor_Position) ProtoMessage() {}

func (x *CompiledCursor_Position) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledCursor_Position.ProtoReflect.Descriptor instead.
func (*CompiledCursor_Position) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{17, 0}
}

func (x *CompiledCursor_Position) GetStartKey() string {
	if x != nil && x.StartKey != nil {
		return *x.StartKey
	}
	return ""
}

func (x *CompiledCursor_Position) GetIndexvalue() []*CompiledCursor_Position_IndexValue {
	if x != nil {
		return x.Indexvalue
	}
	return nil
}

func (x *CompiledCursor_Position) GetKey() *Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *CompiledCursor_Position) GetStartInclusive() bool {
	if x != nil && x.StartInclusive != nil {
		return *x.StartInclusive
	}
	return Default_CompiledCursor_Position_StartInclusive
}

type CompiledCursor_Position_IndexValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Property *string        `protobuf:"bytes,30,opt,name=property" json:"property,omitempty"`
	Value    *PropertyValue `protobuf:"bytes,31,req,name=value" json:"value,omitempty"`
}

func (x *CompiledCursor_Position_IndexValue) Reset() {
	*x = CompiledCursor_Position_IndexValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompiledCursor_Position_IndexValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompiledCursor_Position_IndexValue) ProtoMessage() {}

func (x *CompiledCursor_Position_IndexValue) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompiledCursor_Position_IndexValue.ProtoReflect.Descriptor instead.
func (*CompiledCursor_Position_IndexValue) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{17, 0, 0}
}

func (x *CompiledCursor_Position_IndexValue) GetProperty() string {
	if x != nil && x.Property != nil {
		return *x.Property
	}
	return ""
}

func (x *CompiledCursor_Position_IndexValue) GetValue() *PropertyValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type Cost_CommitCost struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestedEntityPuts    *int32 `protobuf:"varint,6,opt,name=requested_entity_puts,json=requestedEntityPuts" json:"requested_entity_puts,omitempty"`
	RequestedEntityDeletes *int32 `protobuf:"varint,7,opt,name=requested_entity_deletes,json=requestedEntityDeletes" json:"requested_entity_deletes,omitempty"`
}

func (x *Cost_CommitCost) Reset() {
	*x = Cost_CommitCost{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cost_CommitCost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cost_CommitCost) ProtoMessage() {}

func (x *Cost_CommitCost) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cost_CommitCost.ProtoReflect.Descriptor instead.
func (*Cost_CommitCost) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{20, 0}
}

func (x *Cost_CommitCost) GetRequestedEntityPuts() int32 {
	if x != nil && x.RequestedEntityPuts != nil {
		return *x.RequestedEntityPuts
	}
	return 0
}

func (x *Cost_CommitCost) GetRequestedEntityDeletes() int32 {
	if x != nil && x.RequestedEntityDeletes != nil {
		return *x.RequestedEntityDeletes
	}
	return 0
}

type GetResponse_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entity  *EntityProto `protobuf:"bytes,2,opt,name=entity" json:"entity,omitempty"`
	Key     *Reference   `protobuf:"bytes,4,opt,name=key" json:"key,omitempty"`
	Version *int64       `protobuf:"varint,3,opt,name=version" json:"version,omitempty"`
}

func (x *GetResponse_Entity) Reset() {
	*x = GetResponse_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResponse_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResponse_Entity) ProtoMessage() {}

func (x *GetResponse_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResponse_Entity.ProtoReflect.Descriptor instead.
func (*GetResponse_Entity) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{22, 0}
}

func (x *GetResponse_Entity) GetEntity() *EntityProto {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *GetResponse_Entity) GetKey() *Reference {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *GetResponse_Entity) GetVersion() int64 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

type CommitResponse_Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RootEntityKey *Reference `protobuf:"bytes,4,req,name=root_entity_key,json=rootEntityKey" json:"root_entity_key,omitempty"`
	Version       *int64     `protobuf:"varint,5,req,name=version" json:"version,omitempty"`
}

func (x *CommitResponse_Version) Reset() {
	*x = CommitResponse_Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datastore_v3_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse_Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse_Version) ProtoMessage() {}

func (x *CommitResponse_Version) ProtoReflect() protoreflect.Message {
	mi := &file_datastore_v3_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse_Version.ProtoReflect.Descriptor instead.
func (*CommitResponse_Version) Descriptor() ([]byte, []int) {
	return file_datastore_v3_proto_rawDescGZIP(), []int{37, 0}
}

func (x *CommitResponse_Version) GetRootEntityKey() *Reference {
	if x != nil {
		return x.RootEntityKey
	}
	return nil
}

func (x *CommitResponse_Version) GetVersion() int64 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

var File_datastore_v3_proto protoreflect.FileDescriptor

var file_datastore_v3_proto_rawDesc = []byte{
	0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x33, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x22, 0x08, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc6, 0x06, 0x0a,
	0x0d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x22,
	0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0a, 0x32, 0x26, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43,
	0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0a, 0x32, 0x25, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0a, 0x32, 0x2a, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x28, 0x0a, 0x0a, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x06, 0x20, 0x02, 0x28, 0x01,
	0x52, 0x01, 0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x07, 0x20, 0x02, 0x28, 0x01, 0x52, 0x01,
	0x79, 0x1a, 0xbc, 0x01, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x09, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x18, 0x0a, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x66,
	0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x1a, 0xe2, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70, 0x70, 0x18, 0x0d, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x03, 0x61, 0x70, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x36, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x45,
	0x0a, 0x0b, 0x50, 0x61, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf2, 0x05, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x44, 0x0a, 0x07, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x4d, 0x65, 0x61, 0x6e,
	0x69, 0x6e, 0x67, 0x3a, 0x0a, 0x4e, 0x4f, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x49, 0x4e, 0x47, 0x52,
	0x07, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x61, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d,
	0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x08, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0a,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x17, 0x66, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x46, 0x74, 0x73,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x15, 0x66, 0x74, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x06, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x3a, 0x02, 0x65, 0x6e, 0x52, 0x06, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x65, 0x22, 0xc5, 0x02, 0x0a, 0x07, 0x4d, 0x65, 0x61, 0x6e, 0x69, 0x6e,
	0x67, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10, 0x0e, 0x12, 0x08, 0x0a, 0x04, 0x54,
	0x45, 0x58, 0x54, 0x10, 0x0f, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x59, 0x54, 0x45, 0x53, 0x54, 0x52,
	0x49, 0x4e, 0x47, 0x10, 0x10, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x54, 0x4f, 0x4d, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x54, 0x4f, 0x4d,
	0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x54, 0x4f, 0x4d, 0x5f,
	0x54, 0x49, 0x54, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x54, 0x4f, 0x4d, 0x5f,
	0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x54, 0x4f,
	0x4d, 0x5f, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x41,
	0x54, 0x4f, 0x4d, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07,
	0x47, 0x44, 0x5f, 0x57, 0x48, 0x45, 0x4e, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x44, 0x5f,
	0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x45, 0x4f, 0x52, 0x53,
	0x53, 0x5f, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x44, 0x5f,
	0x49, 0x4d, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x44, 0x5f, 0x50, 0x48, 0x4f, 0x4e, 0x45,
	0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x0b, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x44, 0x5f, 0x50,
	0x4f, 0x53, 0x54, 0x41, 0x4c, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0c, 0x12, 0x0d,
	0x0a, 0x09, 0x47, 0x44, 0x5f, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0d, 0x12, 0x0b, 0x0a,
	0x07, 0x42, 0x4c, 0x4f, 0x42, 0x4b, 0x45, 0x59, 0x10, 0x11, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x4e,
	0x54, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b,
	0x49, 0x4e, 0x44, 0x45, 0x58, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x12, 0x22, 0x2b, 0x0a,
	0x15, 0x46, 0x74, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x54, 0x4d, 0x4c, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x41, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x22, 0x7f, 0x0a, 0x04, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0a, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x41, 0x0a, 0x07, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x09, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70, 0x70, 0x18,
	0x0d, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x61, 0x70, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x0e, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x22, 0xb7, 0x01, 0x0a, 0x04, 0x55, 0x73, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a,
	0x12, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x66, 0x65, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x2d, 0x0a, 0x12,
	0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0xa1, 0x03, 0x0a, 0x0b,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x0d, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x35, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x10, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x74, 0x68,
	0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x28, 0x0a,
	0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6b,
	0x69, 0x6e, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6b,
	0x69, 0x6e, 0x64, 0x55, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x39, 0x0a, 0x0c, 0x72, 0x61,
	0x77, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0b, 0x72, 0x61, 0x77, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x22, 0x34, 0x0a, 0x04, 0x4b, 0x69, 0x6e,
	0x64, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x44, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x0e, 0x0a, 0x0a, 0x47, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0x03, 0x22,
	0x44, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x9c, 0x02, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x38, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x1c,
	0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x1a, 0x9b, 0x01, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x09, 0x41, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x52, 0x09, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2a, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x22, 0x9f, 0x02, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x33,
	0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x0e, 0x32, 0x22, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a,
	0x14, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x11, 0x6f, 0x6e, 0x6c, 0x79, 0x55, 0x73, 0x65, 0x49, 0x66, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x22, 0x3f, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0e,
	0x0a, 0x0a, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0b,
	0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x22, 0x85, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x50, 0x6f, 0x73, 0x74, 0x66, 0x69, 0x78, 0x12, 0x46, 0x0a, 0x0b, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x50, 0x6f, 0x73, 0x74, 0x66, 0x69, 0x78, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1c, 0x0a, 0x06, 0x62, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65,
	0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x1a, 0x64, 0x0a, 0x0a, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x3f,
	0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x1c, 0x0a, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x22,
	0x3e, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x74, 0x73, 0x22, 0x22, 0x0a, 0x06, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x22,
	0x22, 0x0a, 0x0e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x10, 0x0a, 0x03, 0x71, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x71, 0x6f, 0x73, 0x22, 0x97, 0x01, 0x0a, 0x0b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x06, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70, 0x70, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03,
	0x61, 0x70, 0x70, 0x12, 0x28, 0x0a, 0x0c, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0xd9, 0x0c,
	0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x10, 0x0a,
	0x03, 0x61, 0x70, 0x70, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x61, 0x70, 0x70, 0x12,
	0x1d, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x1d, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x12, 0x33, 0x0a, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2f,
	0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x19, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12,
	0x2c, 0x0a, 0x04, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x68, 0x69, 0x6e, 0x74, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x4c, 0x0a, 0x13, 0x65,
	0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x72, 0x73,
	0x6f, 0x72, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64,
	0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x11, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x13, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x37, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x66,
	0x65, 0x63, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05,
	0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x50, 0x65,
	0x72, 0x66, 0x65, 0x63, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x22, 0x0a, 0x09, 0x6b, 0x65, 0x79,
	0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x3b, 0x0a,
	0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x63, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x66,
	0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6d, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x4d, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x18, 0x20, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74,
	0x72, 0x6f, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x21, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x62, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x22, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x42, 0x79, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x69,
	0x6e, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x53, 0x61,
	0x66, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x24, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x61, 0x66, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0e, 0x70, 0x65, 0x72,
	0x73, 0x69, 0x73, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x25, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xf0, 0x01, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x33, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x06, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x23,
	0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x7d, 0x0a, 0x08, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45, 0x53, 0x53, 0x5f,
	0x54, 0x48, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54,
	0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x03,
	0x12, 0x19, 0x0a, 0x15, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e,
	0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x51, 0x55, 0x41, 0x4c, 0x10, 0x05, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10, 0x06, 0x12, 0x0a,
	0x0a, 0x06, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x07, 0x1a, 0x9d, 0x01, 0x0a, 0x05, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x18, 0x0a, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x12, 0x4c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x2e, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x09, 0x41, 0x53, 0x43, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2a,
	0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45,
	0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x3d, 0x0a, 0x04, 0x48, 0x69,
	0x6e, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x46, 0x49, 0x52, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4e, 0x43, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x5f,
	0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x03, 0x22, 0x9a, 0x08, 0x0a, 0x0d, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x49, 0x0a, 0x0b, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0a,
	0x32, 0x27, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x73, 0x63, 0x61, 0x6e, 0x12, 0x4f, 0x0a, 0x0d, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6a,
	0x6f, 0x69, 0x6e, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x29, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65,
	0x4a, 0x6f, 0x69, 0x6e, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x0d, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6a,
	0x6f, 0x69, 0x6e, 0x73, 0x63, 0x61, 0x6e, 0x12, 0x30, 0x0a, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x5f, 0x64, 0x65, 0x66, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x65, 0x66, 0x12, 0x19, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65,
	0x79, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0c, 0x20, 0x02, 0x28, 0x08, 0x52, 0x08, 0x6b,
	0x65, 0x79, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13,
	0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x69, 0x78, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x64, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x69, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4c, 0x0a, 0x0c,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0a, 0x32, 0x28, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x1a, 0xd0, 0x02, 0x0a, 0x0b, 0x50,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x65, 0x6e, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x65, 0x6e, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x5f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x12, 0x2e, 0x0a,
	0x13, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x66, 0x69, 0x78, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x50, 0x6f, 0x73, 0x74, 0x66, 0x69, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a, 0x0a,
	0x11, 0x65, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x66, 0x69, 0x78, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x17, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x50, 0x6f, 0x73,
	0x74, 0x66, 0x69, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x42, 0x0a, 0x1e, 0x65, 0x6e, 0x64,
	0x5f, 0x75, 0x6e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x75, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x1a, 0x65, 0x6e, 0x64, 0x55, 0x6e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x55, 0x73, 0x1a, 0x7b, 0x0a,
	0x0d, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4a, 0x6f, 0x69, 0x6e, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x28, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0b, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x7a, 0x0a, 0x0c, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x33, 0x0a, 0x08, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x86, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x41, 0x0a, 0x08, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0a, 0x32, 0x25, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb0, 0x02, 0x0a,
	0x08, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x50, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x30, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72,
	0x75, 0x65, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x76, 0x65, 0x1a, 0x5b, 0x0a, 0x0a, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x31, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x1f, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x32, 0x0a, 0x06, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x06, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x61, 0x70, 0x70, 0x22, 0x8b, 0x02, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x81, 0x02,
	0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x42,
	0x41, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16,
	0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x4e, 0x45, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07,
	0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x06,
	0x12, 0x12, 0x0a, 0x0e, 0x42, 0x49, 0x47, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x07, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x54, 0x45,
	0x44, 0x5f, 0x42, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x49, 0x4c, 0x4c, 0x5f, 0x41, 0x50, 0x50, 0x4c,
	0x59, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49,
	0x4c, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x09, 0x12,
	0x19, 0x0a, 0x15, 0x54, 0x52, 0x59, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x54, 0x45,
	0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x10, 0x0a, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x41,
	0x46, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4f, 0x4c, 0x44, 0x10,
	0x0b, 0x22, 0xcf, 0x03, 0x0a, 0x04, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0a,
	0x32, 0x1d, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x73, 0x74, 0x52,
	0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x64, 0x5f, 0x73, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x69, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x7a, 0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x75, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x75, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x73, 0x22, 0x91, 0x02, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6d, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x4d,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x12, 0x2c, 0x0a, 0x0e, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x44,
	0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x22, 0xa0, 0x02, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x20, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x33, 0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x64, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x69, 0x6e, 0x5f, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07,
	0x69, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x1a, 0x80, 0x01, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x31, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x04, 0x0a, 0x0a, 0x50,
	0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x31, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1f, 0x0a, 0x07, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x07,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0c, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73,
	0x65, 0x52, 0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x32,
	0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x75, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x49, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x3a, 0x07, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f,
	0x49, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x2b, 0x0a, 0x0c, 0x41, 0x75, 0x74, 0x6f,
	0x49, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x55, 0x52, 0x52,
	0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x54,
	0x49, 0x41, 0x4c, 0x10, 0x01, 0x22, 0x7a, 0x0a, 0x0b, 0x50, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x26, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x73,
	0x74, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x87, 0x02, 0x0a, 0x0c, 0x54, 0x6f, 0x75, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x37, 0x0a, 0x0d, 0x54,
	0x6f, 0x75, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x04,
	0x63, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x52, 0x04,
	0x63, 0x6f, 0x73, 0x74, 0x22, 0xc9, 0x02, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x07, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x12, 0x28, 0x0a, 0x0c, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52,
	0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x08,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x22, 0x52, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x73, 0x74, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x01, 0x0a, 0x0b, 0x4e, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01,
	0x30, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x07, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73,
	0x65, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x22, 0xec, 0x03, 0x0a, 0x0b, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0b, 0x6d, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x73, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4f,
	0x6e, 0x6c, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x70, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x4f, 0x70, 0x73,
	0x12, 0x42, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x12, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6d,
	0x61, 0x78, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x07, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x22, 0x65, 0x0a, 0x13, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x12, 0x26, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x22, 0x46, 0x0a, 0x10,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x32, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x22, 0xb4, 0x01, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x3b, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x14, 0x0a, 0x12, 0x41,
	0x64, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x96, 0x03, 0x0a, 0x17, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70, 0x70, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x03, 0x61, 0x70, 0x70, 0x12, 0x31, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x5f, 0x65, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x45, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x07,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x4c, 0x0a,
	0x14, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3d, 0x0a, 0x0f, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52,
	0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45,
	0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x22, 0xde, 0x01, 0x0a, 0x0e, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a,
	0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x52,
	0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0a, 0x32, 0x24, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x64, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3f, 0x0a, 0x0f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4b, 0x65,
	0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x02,
	0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x34, 0x5a, 0x32, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x67, 0x61, 0x65, 0x70, 0x62, 0x3b, 0x67, 0x61, 0x65, 0x70,
	0x62,
}

var (
	file_datastore_v3_proto_rawDescOnce sync.Once
	file_datastore_v3_proto_rawDescData = file_datastore_v3_proto_rawDesc
)

func file_datastore_v3_proto_rawDescGZIP() []byte {
	file_datastore_v3_proto_rawDescOnce.Do(func() {
		file_datastore_v3_proto_rawDescData = protoimpl.X.CompressGZIP(file_datastore_v3_proto_rawDescData)
	})
	return file_datastore_v3_proto_rawDescData
}

var file_datastore_v3_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_datastore_v3_proto_msgTypes = make([]protoimpl.MessageInfo, 55)
var file_datastore_v3_proto_goTypes = []interface{}{
	(Property_Meaning)(0),                            // 0: appengine.v2.Property.Meaning
	(Property_FtsTokenizationOption)(0),              // 1: appengine.v2.Property.FtsTokenizationOption
	(EntityProto_Kind)(0),                            // 2: appengine.v2.EntityProto.Kind
	(Index_Property_Direction)(0),                    // 3: appengine.v2.Index.Property.Direction
	(CompositeIndex_State)(0),                        // 4: appengine.v2.CompositeIndex.State
	(Snapshot_Status)(0),                             // 5: appengine.v2.Snapshot.Status
	(Query_Hint)(0),                                  // 6: appengine.v2.Query.Hint
	(Query_Filter_Operator)(0),                       // 7: appengine.v2.Query.Filter.Operator
	(Query_Order_Direction)(0),                       // 8: appengine.v2.Query.Order.Direction
	(Error_ErrorCode)(0),                             // 9: appengine.v2.Error.ErrorCode
	(PutRequest_AutoIdPolicy)(0),                     // 10: appengine.v2.PutRequest.AutoIdPolicy
	(BeginTransactionRequest_TransactionMode)(0),     // 11: appengine.v2.BeginTransactionRequest.TransactionMode
	(*Action)(nil),                                   // 12: appengine.v2.Action
	(*PropertyValue)(nil),                            // 13: appengine.v2.PropertyValue
	(*Property)(nil),                                 // 14: appengine.v2.Property
	(*Path)(nil),                                     // 15: appengine.v2.Path
	(*Reference)(nil),                                // 16: appengine.v2.Reference
	(*User)(nil),                                     // 17: appengine.v2.User
	(*EntityProto)(nil),                              // 18: appengine.v2.EntityProto
	(*CompositeProperty)(nil),                        // 19: appengine.v2.CompositeProperty
	(*Index)(nil),                                    // 20: appengine.v2.Index
	(*CompositeIndex)(nil),                           // 21: appengine.v2.CompositeIndex
	(*IndexPostfix)(nil),                             // 22: appengine.v2.IndexPostfix
	(*IndexPosition)(nil),                            // 23: appengine.v2.IndexPosition
	(*Snapshot)(nil),                                 // 24: appengine.v2.Snapshot
	(*InternalHeader)(nil),                           // 25: appengine.v2.InternalHeader
	(*Transaction)(nil),                              // 26: appengine.v2.Transaction
	(*Query)(nil),                                    // 27: appengine.v2.Query
	(*CompiledQuery)(nil),                            // 28: appengine.v2.CompiledQuery
	(*CompiledCursor)(nil),                           // 29: appengine.v2.CompiledCursor
	(*Cursor)(nil),                                   // 30: appengine.v2.Cursor
	(*Error)(nil),                                    // 31: appengine.v2.Error
	(*Cost)(nil),                                     // 32: appengine.v2.Cost
	(*GetRequest)(nil),                               // 33: appengine.v2.GetRequest
	(*GetResponse)(nil),                              // 34: appengine.v2.GetResponse
	(*PutRequest)(nil),                               // 35: appengine.v2.PutRequest
	(*PutResponse)(nil),                              // 36: appengine.v2.PutResponse
	(*TouchRequest)(nil),                             // 37: appengine.v2.TouchRequest
	(*TouchResponse)(nil),                            // 38: appengine.v2.TouchResponse
	(*DeleteRequest)(nil),                            // 39: appengine.v2.DeleteRequest
	(*DeleteResponse)(nil),                           // 40: appengine.v2.DeleteResponse
	(*NextRequest)(nil),                              // 41: appengine.v2.NextRequest
	(*QueryResult)(nil),                              // 42: appengine.v2.QueryResult
	(*AllocateIdsRequest)(nil),                       // 43: appengine.v2.AllocateIdsRequest
	(*AllocateIdsResponse)(nil),                      // 44: appengine.v2.AllocateIdsResponse
	(*CompositeIndices)(nil),                         // 45: appengine.v2.CompositeIndices
	(*AddActionsRequest)(nil),                        // 46: appengine.v2.AddActionsRequest
	(*AddActionsResponse)(nil),                       // 47: appengine.v2.AddActionsResponse
	(*BeginTransactionRequest)(nil),                  // 48: appengine.v2.BeginTransactionRequest
	(*CommitResponse)(nil),                           // 49: appengine.v2.CommitResponse
	(*PropertyValue_PointValue)(nil),                 // 50: appengine.v2.PropertyValue.PointValue
	(*PropertyValue_UserValue)(nil),                  // 51: appengine.v2.PropertyValue.UserValue
	(*PropertyValue_ReferenceValue)(nil),             // 52: appengine.v2.PropertyValue.ReferenceValue
	(*PropertyValue_ReferenceValue_PathElement)(nil), // 53: appengine.v2.PropertyValue.ReferenceValue.PathElement
	(*Path_Element)(nil),                             // 54: appengine.v2.Path.Element
	(*Index_Property)(nil),                           // 55: appengine.v2.Index.Property
	(*IndexPostfix_IndexValue)(nil),                  // 56: appengine.v2.IndexPostfix.IndexValue
	(*Query_Filter)(nil),                             // 57: appengine.v2.Query.Filter
	(*Query_Order)(nil),                              // 58: appengine.v2.Query.Order
	(*CompiledQuery_PrimaryScan)(nil),                // 59: appengine.v2.CompiledQuery.PrimaryScan
	(*CompiledQuery_MergeJoinScan)(nil),              // 60: appengine.v2.CompiledQuery.MergeJoinScan
	(*CompiledQuery_EntityFilter)(nil),               // 61: appengine.v2.CompiledQuery.EntityFilter
	(*CompiledCursor_Position)(nil),                  // 62: appengine.v2.CompiledCursor.Position
	(*CompiledCursor_Position_IndexValue)(nil),       // 63: appengine.v2.CompiledCursor.Position.IndexValue
	(*Cost_CommitCost)(nil),                          // 64: appengine.v2.Cost.CommitCost
	(*GetResponse_Entity)(nil),                       // 65: appengine.v2.GetResponse.Entity
	(*CommitResponse_Version)(nil),                   // 66: appengine.v2.CommitResponse.Version
}
var file_datastore_v3_proto_depIdxs = []int32{
	50, // 0: appengine.v2.PropertyValue.pointvalue:type_name -> appengine.v2.PropertyValue.PointValue
	51, // 1: appengine.v2.PropertyValue.uservalue:type_name -> appengine.v2.PropertyValue.UserValue
	52, // 2: appengine.v2.PropertyValue.referencevalue:type_name -> appengine.v2.PropertyValue.ReferenceValue
	0,  // 3: appengine.v2.Property.meaning:type_name -> appengine.v2.Property.Meaning
	13, // 4: appengine.v2.Property.value:type_name -> appengine.v2.PropertyValue
	1,  // 5: appengine.v2.Property.fts_tokenization_option:type_name -> appengine.v2.Property.FtsTokenizationOption
	54, // 6: appengine.v2.Path.element:type_name -> appengine.v2.Path.Element
	15, // 7: appengine.v2.Reference.path:type_name -> appengine.v2.Path
	16, // 8: appengine.v2.EntityProto.key:type_name -> appengine.v2.Reference
	15, // 9: appengine.v2.EntityProto.entity_group:type_name -> appengine.v2.Path
	17, // 10: appengine.v2.EntityProto.owner:type_name -> appengine.v2.User
	2,  // 11: appengine.v2.EntityProto.kind:type_name -> appengine.v2.EntityProto.Kind
	14, // 12: appengine.v2.EntityProto.property:type_name -> appengine.v2.Property
	14, // 13: appengine.v2.EntityProto.raw_property:type_name -> appengine.v2.Property
	55, // 14: appengine.v2.Index.property:type_name -> appengine.v2.Index.Property
	20, // 15: appengine.v2.CompositeIndex.definition:type_name -> appengine.v2.Index
	4,  // 16: appengine.v2.CompositeIndex.state:type_name -> appengine.v2.CompositeIndex.State
	56, // 17: appengine.v2.IndexPostfix.index_value:type_name -> appengine.v2.IndexPostfix.IndexValue
	16, // 18: appengine.v2.IndexPostfix.key:type_name -> appengine.v2.Reference
	25, // 19: appengine.v2.Transaction.header:type_name -> appengine.v2.InternalHeader
	25, // 20: appengine.v2.Query.header:type_name -> appengine.v2.InternalHeader
	16, // 21: appengine.v2.Query.ancestor:type_name -> appengine.v2.Reference
	57, // 22: appengine.v2.Query.filter:type_name -> appengine.v2.Query.Filter
	58, // 23: appengine.v2.Query.order:type_name -> appengine.v2.Query.Order
	6,  // 24: appengine.v2.Query.hint:type_name -> appengine.v2.Query.Hint
	29, // 25: appengine.v2.Query.compiled_cursor:type_name -> appengine.v2.CompiledCursor
	29, // 26: appengine.v2.Query.end_compiled_cursor:type_name -> appengine.v2.CompiledCursor
	21, // 27: appengine.v2.Query.composite_index:type_name -> appengine.v2.CompositeIndex
	26, // 28: appengine.v2.Query.transaction:type_name -> appengine.v2.Transaction
	59, // 29: appengine.v2.CompiledQuery.primaryscan:type_name -> appengine.v2.CompiledQuery.PrimaryScan
	60, // 30: appengine.v2.CompiledQuery.mergejoinscan:type_name -> appengine.v2.CompiledQuery.MergeJoinScan
	20, // 31: appengine.v2.CompiledQuery.index_def:type_name -> appengine.v2.Index
	61, // 32: appengine.v2.CompiledQuery.entityfilter:type_name -> appengine.v2.CompiledQuery.EntityFilter
	62, // 33: appengine.v2.CompiledCursor.position:type_name -> appengine.v2.CompiledCursor.Position
	64, // 34: appengine.v2.Cost.commitcost:type_name -> appengine.v2.Cost.CommitCost
	25, // 35: appengine.v2.GetRequest.header:type_name -> appengine.v2.InternalHeader
	16, // 36: appengine.v2.GetRequest.key:type_name -> appengine.v2.Reference
	26, // 37: appengine.v2.GetRequest.transaction:type_name -> appengine.v2.Transaction
	65, // 38: appengine.v2.GetResponse.entity:type_name -> appengine.v2.GetResponse.Entity
	16, // 39: appengine.v2.GetResponse.deferred:type_name -> appengine.v2.Reference
	25, // 40: appengine.v2.PutRequest.header:type_name -> appengine.v2.InternalHeader
	18, // 41: appengine.v2.PutRequest.entity:type_name -> appengine.v2.EntityProto
	26, // 42: appengine.v2.PutRequest.transaction:type_name -> appengine.v2.Transaction
	21, // 43: appengine.v2.PutRequest.composite_index:type_name -> appengine.v2.CompositeIndex
	24, // 44: appengine.v2.PutRequest.snapshot:type_name -> appengine.v2.Snapshot
	10, // 45: appengine.v2.PutRequest.auto_id_policy:type_name -> appengine.v2.PutRequest.AutoIdPolicy
	16, // 46: appengine.v2.PutResponse.key:type_name -> appengine.v2.Reference
	32, // 47: appengine.v2.PutResponse.cost:type_name -> appengine.v2.Cost
	25, // 48: appengine.v2.TouchRequest.header:type_name -> appengine.v2.InternalHeader
	16, // 49: appengine.v2.TouchRequest.key:type_name -> appengine.v2.Reference
	21, // 50: appengine.v2.TouchRequest.composite_index:type_name -> appengine.v2.CompositeIndex
	24, // 51: appengine.v2.TouchRequest.snapshot:type_name -> appengine.v2.Snapshot
	32, // 52: appengine.v2.TouchResponse.cost:type_name -> appengine.v2.Cost
	25, // 53: appengine.v2.DeleteRequest.header:type_name -> appengine.v2.InternalHeader
	16, // 54: appengine.v2.DeleteRequest.key:type_name -> appengine.v2.Reference
	26, // 55: appengine.v2.DeleteRequest.transaction:type_name -> appengine.v2.Transaction
	24, // 56: appengine.v2.DeleteRequest.snapshot:type_name -> appengine.v2.Snapshot
	32, // 57: appengine.v2.DeleteResponse.cost:type_name -> appengine.v2.Cost
	25, // 58: appengine.v2.NextRequest.header:type_name -> appengine.v2.InternalHeader
	30, // 59: appengine.v2.NextRequest.cursor:type_name -> appengine.v2.Cursor
	30, // 60: appengine.v2.QueryResult.cursor:type_name -> appengine.v2.Cursor
	18, // 61: appengine.v2.QueryResult.result:type_name -> appengine.v2.EntityProto
	28, // 62: appengine.v2.QueryResult.compiled_query:type_name -> appengine.v2.CompiledQuery
	29, // 63: appengine.v2.QueryResult.compiled_cursor:type_name -> appengine.v2.CompiledCursor
	21, // 64: appengine.v2.QueryResult.index:type_name -> appengine.v2.CompositeIndex
	25, // 65: appengine.v2.AllocateIdsRequest.header:type_name -> appengine.v2.InternalHeader
	16, // 66: appengine.v2.AllocateIdsRequest.model_key:type_name -> appengine.v2.Reference
	16, // 67: appengine.v2.AllocateIdsRequest.reserve:type_name -> appengine.v2.Reference
	32, // 68: appengine.v2.AllocateIdsResponse.cost:type_name -> appengine.v2.Cost
	21, // 69: appengine.v2.CompositeIndices.index:type_name -> appengine.v2.CompositeIndex
	25, // 70: appengine.v2.AddActionsRequest.header:type_name -> appengine.v2.InternalHeader
	26, // 71: appengine.v2.AddActionsRequest.transaction:type_name -> appengine.v2.Transaction
	12, // 72: appengine.v2.AddActionsRequest.action:type_name -> appengine.v2.Action
	25, // 73: appengine.v2.BeginTransactionRequest.header:type_name -> appengine.v2.InternalHeader
	11, // 74: appengine.v2.BeginTransactionRequest.mode:type_name -> appengine.v2.BeginTransactionRequest.TransactionMode
	26, // 75: appengine.v2.BeginTransactionRequest.previous_transaction:type_name -> appengine.v2.Transaction
	32, // 76: appengine.v2.CommitResponse.cost:type_name -> appengine.v2.Cost
	66, // 77: appengine.v2.CommitResponse.version:type_name -> appengine.v2.CommitResponse.Version
	53, // 78: appengine.v2.PropertyValue.ReferenceValue.pathelement:type_name -> appengine.v2.PropertyValue.ReferenceValue.PathElement
	3,  // 79: appengine.v2.Index.Property.direction:type_name -> appengine.v2.Index.Property.Direction
	13, // 80: appengine.v2.IndexPostfix.IndexValue.value:type_name -> appengine.v2.PropertyValue
	7,  // 81: appengine.v2.Query.Filter.op:type_name -> appengine.v2.Query.Filter.Operator
	14, // 82: appengine.v2.Query.Filter.property:type_name -> appengine.v2.Property
	8,  // 83: appengine.v2.Query.Order.direction:type_name -> appengine.v2.Query.Order.Direction
	16, // 84: appengine.v2.CompiledQuery.EntityFilter.ancestor:type_name -> appengine.v2.Reference
	63, // 85: appengine.v2.CompiledCursor.Position.indexvalue:type_name -> appengine.v2.CompiledCursor.Position.IndexValue
	16, // 86: appengine.v2.CompiledCursor.Position.key:type_name -> appengine.v2.Reference
	13, // 87: appengine.v2.CompiledCursor.Position.IndexValue.value:type_name -> appengine.v2.PropertyValue
	18, // 88: appengine.v2.GetResponse.Entity.entity:type_name -> appengine.v2.EntityProto
	16, // 89: appengine.v2.GetResponse.Entity.key:type_name -> appengine.v2.Reference
	16, // 90: appengine.v2.CommitResponse.Version.root_entity_key:type_name -> appengine.v2.Reference
	91, // [91:91] is the sub-list for method output_type
	91, // [91:91] is the sub-list for method input_type
	91, // [91:91] is the sub-list for extension type_name
	91, // [91:91] is the sub-list for extension extendee
	0,  // [0:91] is the sub-list for field type_name
}

func init() { file_datastore_v3_proto_init() }
func file_datastore_v3_proto_init() {
	if File_datastore_v3_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_datastore_v3_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Path); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Reference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*User); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompositeProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompositeIndex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexPostfix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexPosition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Snapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InternalHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledCursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cost); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TouchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TouchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocateIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocateIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompositeIndices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddActionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddActionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyValue_PointValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyValue_UserValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyValue_ReferenceValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyValue_ReferenceValue_PathElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Path_Element); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexPostfix_IndexValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Query_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Query_Order); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledQuery_PrimaryScan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledQuery_MergeJoinScan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledQuery_EntityFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledCursor_Position); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompiledCursor_Position_IndexValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cost_CommitCost); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResponse_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datastore_v3_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse_Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_datastore_v3_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   55,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_datastore_v3_proto_goTypes,
		DependencyIndexes: file_datastore_v3_proto_depIdxs,
		EnumInfos:         file_datastore_v3_proto_enumTypes,
		MessageInfos:      file_datastore_v3_proto_msgTypes,
	}.Build()
	File_datastore_v3_proto = out.File
	file_datastore_v3_proto_rawDesc = nil
	file_datastore_v3_proto_goTypes = nil
	file_datastore_v3_proto_depIdxs = nil
}
