/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
)

// Linger please
var (
	_ _context.Context
)

type SigninApi interface {

	/*
			 * PostSignin Create a user session.
			 * Authenticates [Basic authentication credentials](#section/Authentication/BasicAuthentication)
		for a [user]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user),
		and then, if successful, generates a user session.

		To authenticate a user, pass the HTTP `Authorization` header with the
		`Basic` scheme and the base64-encoded username and password.
		For syntax and more information, see [Basic Authentication](#section/Authentication/BasicAuthentication) for
		syntax and more information.

		If authentication is successful, InfluxDB creates a new session for the user
		and then returns the session cookie in the `Set-Cookie` response header.

		User sessions exist only in memory.
		They expire within ten minutes and during restarts of the InfluxDB instance.

		#### User sessions with authorizations

		- In InfluxDB Cloud, a user session inherits all the user's permissions for
		  the organization.
		- In InfluxDB OSS, a user session inherits all the user's permissions for all
		  the organizations that the user belongs to.

		#### Related endpoints

		- [Signout](#tag/Signout)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return ApiPostSigninRequest
	*/
	PostSignin(ctx _context.Context) ApiPostSigninRequest

	/*
	 * PostSigninExecute executes the request
	 */
	PostSigninExecute(r ApiPostSigninRequest) error

	/*
	 * PostSigninExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	PostSigninExecuteWithHttpInfo(r ApiPostSigninRequest) (*_nethttp.Response, error)
}

// SigninApiService SigninApi service
type SigninApiService service

type ApiPostSigninRequest struct {
	ctx          _context.Context
	ApiService   SigninApi
	zapTraceSpan *string
}

func (r ApiPostSigninRequest) ZapTraceSpan(zapTraceSpan string) ApiPostSigninRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostSigninRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostSigninRequest) Execute() error {
	return r.ApiService.PostSigninExecute(r)
}

func (r ApiPostSigninRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.PostSigninExecuteWithHttpInfo(r)
}

/*
 * PostSignin Create a user session.
 * Authenticates [Basic authentication credentials](#section/Authentication/BasicAuthentication)
for a [user]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user),
and then, if successful, generates a user session.

To authenticate a user, pass the HTTP `Authorization` header with the
`Basic` scheme and the base64-encoded username and password.
For syntax and more information, see [Basic Authentication](#section/Authentication/BasicAuthentication) for
syntax and more information.

If authentication is successful, InfluxDB creates a new session for the user
and then returns the session cookie in the `Set-Cookie` response header.

User sessions exist only in memory.
They expire within ten minutes and during restarts of the InfluxDB instance.

#### User sessions with authorizations

- In InfluxDB Cloud, a user session inherits all the user's permissions for
  the organization.
- In InfluxDB OSS, a user session inherits all the user's permissions for all
  the organizations that the user belongs to.

#### Related endpoints

- [Signout](#tag/Signout)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostSigninRequest
*/
func (a *SigninApiService) PostSignin(ctx _context.Context) ApiPostSigninRequest {
	return ApiPostSigninRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 */
func (a *SigninApiService) PostSigninExecute(r ApiPostSigninRequest) error {
	_, err := a.PostSigninExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *SigninApiService) PostSigninExecuteWithHttpInfo(r ApiPostSigninRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "SigninApiService.PostSignin")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/signin"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
